/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.DataSessionIterator;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.UtilFncs;
import java.util.ListIterator;
import java.util.Vector;

public class Thread
implements Comparable {
    int nodeID = -1;
    int contextID = -1;
    int threadID = -1;
    Vector functions = null;
    Vector userevents = null;
    private double[] doubleList;
    double totalExclusiveValue = 0.0;
    double totalInclusiveValue = 0.0;
    private int maxNumberOfCalls = 0;
    private int maxNumberOfSubRoutines = 0;
    private boolean trimmed = false;
    private boolean debug = false;

    public Thread() {
        this.doubleList = new double[7];
    }

    public Thread(int n) {
        this.doubleList = new double[n * 7];
    }

    public Thread(int n, int n2, int n3) {
        this.nodeID = n;
        this.contextID = n2;
        this.threadID = n3;
        this.doubleList = new double[7];
    }

    public Thread(int n, int n2, int n3, int n4) {
        this.nodeID = n;
        this.contextID = n2;
        this.threadID = n3;
        this.doubleList = new double[n4 * 7];
    }

    public void setNodeId(int n) {
        this.nodeID = n;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public void setContextID(int n) {
        this.contextID = n;
    }

    public int getContextID() {
        return this.contextID;
    }

    public void setThreadID(int n) {
        this.threadID = n;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public void initializeFunctionList(int n) {
        this.functions = new Vector(n);
        Object e = null;
        for (int i = 0; i < n; ++i) {
            this.functions.add(e);
        }
    }

    public void initializeUsereventList(int n) {
        this.userevents = new Vector(n);
        Object e = null;
        for (int i = 0; i < n; ++i) {
            this.userevents.add(e);
        }
    }

    public void incrementStorage() {
        int n = this.doubleList.length;
        double[] dArray = new double[n + 7];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.doubleList[i];
        }
        this.doubleList = dArray;
    }

    public void addFunction(GlobalThreadDataElement globalThreadDataElement) {
        this.functions.addElement(globalThreadDataElement);
    }

    public void addFunction(GlobalThreadDataElement globalThreadDataElement, int n) {
        if (this.debug()) {
            System.out.println("######");
            System.out.println("#Thread.addFuntion(...)");
            System.out.println("#id:" + n);
            System.out.println("#name:" + globalThreadDataElement.getMappingName());
            System.out.println("#functions.size():" + this.functions.size());
        }
        boolean bl = false;
        Object e = null;
        while (n >= this.functions.size()) {
            this.functions.add(e);
        }
        if (this.functions.elementAt(n) == null) {
            this.functions.setElementAt(globalThreadDataElement, n);
            bl = true;
        }
        if (this.debug()) {
            System.out.println("#added?:" + bl);
            System.out.println("#functions.size():" + this.functions.size());
            System.out.println("######");
        }
    }

    public void addUserevent(GlobalThreadDataElement globalThreadDataElement) {
        this.userevents.addElement(globalThreadDataElement);
    }

    public void addUserevent(GlobalThreadDataElement globalThreadDataElement, int n) {
        if (n >= this.userevents.size()) {
            this.userevents.add(globalThreadDataElement);
        } else if (this.userevents.elementAt(n) == null) {
            this.userevents.setElementAt(globalThreadDataElement, n);
        }
        if (this.debug()) {
            System.out.println("######");
            System.out.println("Thread.addUserevent(...)");
            System.out.println("id:" + n);
            System.out.println("userevents.size():" + this.functions.size());
            System.out.println("######");
        }
    }

    public GlobalThreadDataElement getFunction(int n) {
        GlobalThreadDataElement globalThreadDataElement = null;
        try {
            if (this.functions != null && n < this.functions.size()) {
                globalThreadDataElement = (GlobalThreadDataElement)this.functions.elementAt(n);
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "T2");
        }
        return globalThreadDataElement;
    }

    public Vector getFunctionList() {
        return this.functions;
    }

    public ListIterator getFunctionListIterator() {
        return new DataSessionIterator(this.functions);
    }

    public GlobalThreadDataElement getUserevent(int n) {
        GlobalThreadDataElement globalThreadDataElement = null;
        try {
            if (this.userevents != null && n < this.userevents.size()) {
                globalThreadDataElement = (GlobalThreadDataElement)this.userevents.elementAt(n);
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "T3");
        }
        return globalThreadDataElement;
    }

    public Vector getUsereventList() {
        return this.userevents;
    }

    public ListIterator getUsereventListIterator() {
        return new DataSessionIterator(this.userevents);
    }

    public void setThreadData(int n) {
        this.setThreadDataHelper(n);
        this.setPercentData(n);
        this.setThreadDataHelper(n);
    }

    private void setThreadDataHelper(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 0;
        int n3 = 0;
        double d6 = 0.0;
        int n4 = 0;
        ListIterator listIterator = this.getFunctionListIterator();
        while (listIterator.hasNext()) {
            GlobalThreadDataElement globalThreadDataElement = (GlobalThreadDataElement)listIterator.next();
            if (globalThreadDataElement == null) continue;
            d6 = globalThreadDataElement.getInclusiveValue(n);
            if (d6 > d) {
                d = d6;
            }
            if ((d6 = globalThreadDataElement.getExclusiveValue(n)) > d2) {
                d2 = d6;
            }
            if ((d6 = globalThreadDataElement.getInclusivePercentValue(n)) > d3) {
                d3 = d6;
            }
            if ((d6 = globalThreadDataElement.getExclusivePercentValue(n)) > d4) {
                d4 = d6;
            }
            if ((d6 = globalThreadDataElement.getUserSecPerCall(n)) > d5) {
                d5 = d6;
            }
            if ((n4 = globalThreadDataElement.getNumberOfCalls()) > n2) {
                n2 = n4;
            }
            if ((n4 = globalThreadDataElement.getNumberOfSubRoutines()) <= n3) continue;
            n3 = n4;
        }
        if (this.debug()) {
            System.out.println("------");
            System.out.println("T-D01");
            System.out.println("maxInclusiveValue:" + d);
            System.out.println("maxExclusiveValue:" + d2);
            System.out.println("maxInclusivePercentValue:" + d3);
            System.out.println("maxExclusivePercentValue:" + d4);
            System.out.println("maxUserSecPerCall:" + d5);
            System.out.println("maxNumberOfCalls:" + n2);
            System.out.println("maxNumberOfSubroutines:" + n3);
            System.out.println("------");
        }
        this.setMaxInclusiveValue(n, d);
        this.setMaxExclusiveValue(n, d2);
        this.setMaxInclusivePercentValue(n, d3);
        this.setMaxExclusivePercentValue(n, d4);
        this.setMaxUserSecPerCall(n, d5);
        this.setMaxNumberOfCalls(n2);
        this.setMaxNumberOfSubRoutines(n3);
    }

    private void setPercentData(int n) {
        ListIterator listIterator = this.getFunctionListIterator();
        while (listIterator.hasNext()) {
            GlobalThreadDataElement globalThreadDataElement = (GlobalThreadDataElement)listIterator.next();
            if (globalThreadDataElement == null) continue;
            GlobalMappingElement globalMappingElement = globalThreadDataElement.getGlobalMappingElement();
            double d = this.getMaxInclusiveValue(n);
            double d2 = globalThreadDataElement.getExclusiveValue(n);
            double d3 = globalThreadDataElement.getInclusiveValue(n);
            if (d == 0.0) continue;
            double d4 = d2 / d * 100.0;
            globalThreadDataElement.setExclusivePercentValue(n, d4);
            if (globalMappingElement.getMaxExclusivePercentValue(n) < d4) {
                globalMappingElement.setMaxExclusivePercentValue(n, d4);
            }
            d4 = d3 / d * 100.0;
            globalThreadDataElement.setInclusivePercentValue(n, d4);
            if (!(globalMappingElement.getMaxInclusivePercentValue(n) < d4)) continue;
            globalMappingElement.setMaxInclusivePercentValue(n, d4);
        }
    }

    public void setMaxInclusiveValue(int n, double d) {
        this.insertDouble(n, 0, d);
    }

    public double getMaxInclusiveValue(int n) {
        return this.getDouble(n, 0);
    }

    public void setMaxExclusiveValue(int n, double d) {
        this.insertDouble(n, 1, d);
    }

    public double getMaxExclusiveValue(int n) {
        return this.getDouble(n, 1);
    }

    public void setMaxInclusivePercentValue(int n, double d) {
        this.insertDouble(n, 2, d);
    }

    public double getMaxInclusivePercentValue(int n) {
        return this.getDouble(n, 2);
    }

    public void setMaxExclusivePercentValue(int n, double d) {
        this.insertDouble(n, 3, d);
    }

    public double getMaxExclusivePercentValue(int n) {
        return this.getDouble(n, 3);
    }

    public void setMaxUserSecPerCall(int n, double d) {
        this.insertDouble(n, 4, d);
    }

    public double getMaxUserSecPerCall(int n) {
        return this.getDouble(n, 4);
    }

    public void setMaxNumberOfCalls(int n) {
        this.maxNumberOfCalls = n;
    }

    public int getMaxNumberOfCalls() {
        return this.maxNumberOfCalls;
    }

    public void setMaxNumberOfSubRoutines(int n) {
        this.maxNumberOfSubRoutines = n;
    }

    public int getMaxNumberOfSubRoutines() {
        return this.maxNumberOfSubRoutines;
    }

    public void setTrimmed(boolean bl) {
        this.trimmed = bl;
    }

    public boolean trimmed() {
        return this.trimmed;
    }

    public int compareTo(Object object) {
        if (object instanceof Integer) {
            return this.threadID - (Integer)object;
        }
        return this.threadID - ((Thread)object).getThreadID();
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }

    private void insertDouble(int n, int n2, double d) {
        int n3 = n * 5 + n2;
        try {
            this.doubleList[n3] = d;
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "GT01");
        }
    }

    private double getDouble(int n, int n2) {
        int n3 = n * 5 + n2;
        try {
            return this.doubleList[n3];
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "GT01");
            return -1.0;
        }
    }
}

