/*
 * Decompiled with CFR 0.152.
 */
package TauIL;

import TauIL.TauIL;
import TauIL.absyn.AbstractSyntaxTree;
import TauIL.interpreter.Interpreter;
import TauIL.lexer.Lexer;
import TauIL.parser.Parser;
import TauIL.util.BadOptException;
import TauIL.util.GetOpt;
import TauIL.util.InstList;
import TauIL.util.InstListWriter;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Vector;

public class Tool {
    public static final char[] version = new char[]{'0', '8', 'a'};
    private static String fname = null;
    private static boolean debug = false;
    private static boolean verbose = false;
    private static HashMap macros = new HashMap();

    public static boolean parseCommandLine(String[] stringArray) {
        try {
            char c;
            GetOpt getOpt = new GetOpt(stringArray, "dhiuvD:");
            while ((c = getOpt.getopt()) != '\u0000') {
                switch (c) {
                    case 'i': {
                        verbose = true;
                        break;
                    }
                    case 'D': {
                        String string = getOpt.optarg();
                        int n = string.indexOf("=");
                        String string2 = string.substring(0, n);
                        String string3 = string.substring(n + 1);
                        macros.put(string2, Lexer.makeMacroValue(string3));
                        break;
                    }
                    case 'd': {
                        debug = true;
                        break;
                    }
                    case 'v': {
                        Tool.version();
                        System.exit(0);
                    }
                    case 'h': 
                    case 'u': {
                        return false;
                    }
                }
            }
            fname = getOpt.param();
            if (fname == null && (fname = getOpt.optarg()) == null) {
                return false;
            }
        }
        catch (BadOptException badOptException) {
            return false;
        }
        return true;
    }

    public static void usage() {
        System.err.println("Usage: tau_analyze [-hiuv] [-D macro[=value]] inst-spec");
        System.err.println("Options:");
        System.err.println(" -h               : display usage dialogue");
        System.err.println(" -i               : prints step by step processing information");
        System.err.println(" -u               : same function as -h option");
        System.err.println(" -v               : display version information");
        System.err.println(" -D macro[=value] : defines a macro with an optional value");
        System.err.println(" inst-spec        : file name of insturmentation specification");
        System.err.println();
        Tool.version();
        System.exit(0);
    }

    public static void version() {
        System.err.println("tau_analyze v" + version[0] + "." + version[1] + version[2]);
        TauIL.version();
        System.err.println();
        System.err.println("Written by Tyrel Datwyler, 2003");
    }

    public static void main(String[] stringArray) {
        if (!Tool.parseCommandLine(stringArray)) {
            Tool.usage();
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(fname);
            Lexer lexer = new Lexer(fileInputStream);
            lexer.defineMacros(macros);
            lexer.setDebugMode(debug);
            Parser parser = new Parser(lexer);
            AbstractSyntaxTree abstractSyntaxTree = debug ? (AbstractSyntaxTree)parser.debug_parse().value : (AbstractSyntaxTree)parser.parse().value;
            Interpreter interpreter = new Interpreter(abstractSyntaxTree);
            interpreter.setVerboseMode(verbose);
            interpreter.setDebugMode(debug);
            interpreter.interpret();
            InstListWriter instListWriter = new InstListWriter();
            Vector vector = interpreter.getInstLists();
            ListIterator listIterator = vector.listIterator();
            while (listIterator.hasNext()) {
                instListWriter.writeList((InstList)listIterator.next());
            }
        }
        catch (Error error) {
            System.err.println("Unhandled error has been thrown.");
            error.printStackTrace();
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println("Unhandled exception has been thrown.");
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

