/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.dynatype;

import java.io.PrintStream;
import org.jatha.Jatha;
import org.jatha.dynatype.LispPackage;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispSymbol;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.StandardLispString;
import org.jatha.dynatype.StandardLispValue;
import org.jatha.util.SymbolTable;

public class StandardLispPackage
extends StandardLispValue
implements LispPackage {
    protected SymbolTable f_symbolTable;
    protected LispValue f_name;
    protected LispValue f_nicknames;
    protected LispValue f_uses;

    public StandardLispPackage() {
    }

    public StandardLispPackage(Jatha lisp, String name) {
        this(lisp, new StandardLispString(lisp, name));
    }

    public StandardLispPackage(Jatha lisp, LispValue name) {
        this(lisp, name, null, null, null);
    }

    public StandardLispPackage(Jatha lisp, LispValue name, LispValue nicknames) {
        this(lisp, name, nicknames, null, null);
    }

    public StandardLispPackage(Jatha lisp, LispValue name, LispValue nicknames, LispValue usesList) {
        this(lisp, name, nicknames, usesList, null);
    }

    public StandardLispPackage(Jatha lisp, LispValue pname, LispValue pnicknames, LispValue puses, SymbolTable symtab) {
        super(lisp);
        this.f_name = pname == null ? this.f_lisp.NIL : pname;
        this.f_nicknames = pnicknames == null ? this.f_lisp.NIL : pnicknames;
        this.f_uses = puses == null ? this.f_lisp.NIL : puses;
        this.f_symbolTable = symtab instanceof SymbolTable ? symtab : new SymbolTable(this.f_lisp);
    }

    public SymbolTable getSymbolTable() {
        return this.f_symbolTable;
    }

    public void internal_princ(PrintStream os) {
        os.print("#<The " + ((LispString)this.f_name).getValue() + " package>");
    }

    public void internal_prin1(PrintStream os) {
        os.print("#<The " + ((LispString)this.f_name).getValue() + " package>");
    }

    public void internal_print(PrintStream os) {
        os.print("#<The " + ((LispString)this.f_name).getValue() + " package>");
    }

    public String toString() {
        if (this.f_nicknames != this.f_lisp.NIL) {
            return ((LispString)this.f_nicknames.car()).getValue();
        }
        return ((LispString)this.f_name).getValue();
    }

    public LispValue getExternalSymbol(LispString str) {
        LispValue symbol = this.f_symbolTable.get(str);
        if (symbol != this.f_lisp.NIL && ((LispSymbol)symbol).externalP()) {
            return symbol;
        }
        return this.f_lisp.NIL;
    }

    public LispValue addSymbol(LispString name, LispValue symbol) {
        this.f_symbolTable.put(name, symbol);
        return symbol;
    }

    public LispValue getSymbol(LispString str) {
        LispValue symbol = this.f_symbolTable.get(str);
        if (symbol != this.f_lisp.NIL) {
            return symbol;
        }
        LispValue p = this.f_uses;
        while (p != this.f_lisp.NIL) {
            symbol = ((LispPackage)p.car()).getExternalSymbol(str);
            if (symbol != this.f_lisp.NIL) {
                return symbol;
            }
            p = p.cdr();
        }
        return this.f_lisp.NIL;
    }

    LispValue makeSymbolsFromList(LispValue symbolList) {
        if (symbolList == this.f_lisp.NIL) {
            return symbolList;
        }
        if (symbolList.car().basic_symbolp()) {
            return this.f_lisp.makeCons(symbolList.car(), this.makeSymbolsFromList(symbolList.cdr()));
        }
        return this.f_lisp.makeCons(this.f_lisp.EVAL.intern((LispString)symbolList.car(), (LispPackage)this), this.makeSymbolsFromList(symbolList.cdr()));
    }

    public LispValue export(LispValue symbols) {
        if (!symbols.basic_consp()) {
            symbols = this.f_lisp.makeCons(symbols, this.f_lisp.NIL);
        }
        LispValue s = symbols;
        while (s != this.f_lisp.NIL) {
            ((LispSymbol)s.car()).setExternal(true);
            s = s.cdr();
        }
        return this.f_lisp.T;
    }

    public LispValue lisp_import(LispValue symbols) {
        if (!symbols.basic_consp()) {
            symbols = this.f_lisp.makeCons(symbols, this.f_lisp.NIL);
        }
        LispValue s = symbols;
        while (s != this.f_lisp.NIL) {
            LispValue symb = s.car();
            if (this.getSymbol((LispString)symb.symbol_name()) == this.f_lisp.NIL) {
                this.f_symbolTable.put((LispString)symb.symbol_name(), symb);
            } else {
                System.err.println(";; * WARNING: Attempt to import " + symb + " conflicts with existing symbol " + this.getSymbol((LispString)symb.symbol_name()) + " in " + this.f_name);
            }
            s = s.cdr();
        }
        return this.f_lisp.T;
    }

    public LispValue type_of() {
        return this.f_lisp.PACKAGE_TYPE;
    }

    public LispValue typep(LispValue type) {
        LispValue result = super.typep(type);
        if (result == this.f_lisp.T || type == this.f_lisp.PACKAGE_TYPE) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }

    public LispString getName() {
        return (LispString)this.f_name;
    }

    public LispValue getNicknames() {
        return this.f_nicknames;
    }
}

