/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.dynatype;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jatha.Jatha;
import org.jatha.dynatype.LispCons;
import org.jatha.dynatype.LispConsOrNil;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.LispValueNotAConsException;
import org.jatha.dynatype.LispValueNotAListException;
import org.jatha.dynatype.StandardLispConsOrNil;
import org.jatha.dynatype.StandardLispInteger;

public class StandardLispCons
extends StandardLispConsOrNil
implements LispCons {
    protected LispValue carCell;
    protected LispValue cdrCell;

    public StandardLispCons() {
    }

    public StandardLispCons(Jatha lisp, LispValue theCar, LispValue theCdr) {
        super(lisp);
        if (theCar == null) {
            System.err.println("** LispCons: attempting to create a CONS when CAR=null.  Substituting NIL");
            theCar = lisp.NIL;
        }
        this.carCell = theCar;
        if (theCdr == null) {
            System.err.println("** LispCons: attempting to create a CONS when CDR=null.  Substituting NIL");
            theCdr = lisp.NIL;
        }
        this.cdrCell = theCdr;
    }

    public StandardLispCons(Jatha lisp) {
        super(lisp);
        this.carCell = this.f_lisp.NIL;
        this.cdrCell = this.f_lisp.NIL;
    }

    public void internal_princ(PrintStream os) {
        os.print("(");
        this.carCell.internal_princ(os);
        this.cdrCell.internal_princ_as_cdr(os);
        os.print(")");
    }

    public void internal_princ_as_cdr(PrintStream os) {
        os.print(" ");
        this.carCell.internal_princ(os);
        this.cdrCell.internal_princ_as_cdr(os);
    }

    public void internal_prin1(PrintStream os) {
        os.print("(");
        this.carCell.internal_prin1(os);
        this.cdrCell.internal_prin1_as_cdr(os);
        os.print(")");
    }

    public void internal_prin1_as_cdr(PrintStream os) {
        os.print(" ");
        this.carCell.internal_prin1(os);
        this.cdrCell.internal_prin1_as_cdr(os);
    }

    public void internal_print(PrintStream os) {
        os.print("(");
        this.carCell.internal_print(os);
        this.cdrCell.internal_print_as_cdr(os);
        os.print(")");
    }

    public void internal_print_as_cdr(PrintStream os) {
        os.print(" ");
        this.carCell.internal_print(os);
        this.cdrCell.internal_print_as_cdr(os);
    }

    public boolean basic_consp() {
        return true;
    }

    public boolean basic_constantp() {
        return this.carCell == this.f_lisp.QUOTE;
    }

    public int basic_length() {
        return (int)((LispInteger)this.length()).getLongValue();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        buf.append(this.carCell.toString());
        buf.append(this.cdrCell.toStringAsCdr_internal(1L));
        buf.append(")");
        return buf.toString();
    }

    public String toStringAsCdr_internal(long index) {
        if (index > this.f_lisp.getMaxListLength().getLongValue()) {
            System.err.println("Printing list...longer than *MAX-LIST-LENGTH*.  Truncated.");
            System.err.println("Next few items are: ");
            LispValue ptr = this;
            int i = 0;
            while (i < 10) {
                if (!(ptr instanceof LispCons)) break;
                System.err.println("    " + ptr.car());
                ptr = ptr.cdr();
                ++i;
            }
            return "...";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(" ");
        buf.append(this.carCell.toString());
        buf.append(this.cdrCell.toStringAsCdr_internal(index + 1L));
        return buf.toString();
    }

    public String toStringAsCdr() {
        StringBuffer buf = new StringBuffer();
        buf.append(" ");
        buf.append(this.carCell.toString());
        buf.append(this.cdrCell.toStringAsCdr());
        return buf.toString();
    }

    public boolean contains(LispValue object) {
        return this.member(object) != this.f_lisp.NIL;
    }

    public Collection toCollection() {
        ArrayList result = new ArrayList(this.basic_length());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public LispValue append(LispValue otherList) {
        return this.f_lisp.makeCons(this.car(), this.cdr().append(otherList));
    }

    public LispValue assoc(LispValue index) {
        LispValue ptr = this;
        while (!ptr.basic_null()) {
            LispValue value = ptr.car();
            if (!ptr.basic_consp()) {
                throw new LispValueNotAListException("An argument to ASSOC");
            }
            if (index.eql(value.car()) == this.f_lisp.T) {
                return value;
            }
            ptr = ptr.cdr();
        }
        return this.f_lisp.NIL;
    }

    public LispValue car() {
        return this.carCell;
    }

    public LispValue cdr() {
        return this.cdrCell;
    }

    public LispValue consp() {
        return this.f_lisp.T;
    }

    public LispValue copy_list() {
        return this.f_lisp.makeCons(this.car(), this.cdr().copy_list());
    }

    public LispValue copy() {
        return new StandardLispCons(this.f_lisp, this.carCell.copy(), this.cdrCell.copy());
    }

    public LispValue equal(LispValue value) {
        boolean result;
        if (!(value instanceof LispCons)) {
            return this.f_lisp.NIL;
        }
        boolean bl = result = this.carCell.equal(value.car()) != this.f_lisp.NIL && this.cdrCell.equal(value.cdr()) != this.f_lisp.NIL;
        if (result) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }

    public LispValue first() {
        return this.carCell;
    }

    public LispValue second() {
        return this.cdr().first();
    }

    public LispValue third() {
        return this.cdr().second();
    }

    public LispValue fourth() {
        return this.cdr().third();
    }

    public LispValue fifth() {
        return this.cdr().fourth();
    }

    public LispValue sixth() {
        return this.cdr().fifth();
    }

    public LispValue seventh() {
        return this.cdr().sixth();
    }

    public LispValue eighth() {
        return this.cdr().seventh();
    }

    public LispValue ninth() {
        return this.cdr().eighth();
    }

    public LispValue tenth() {
        return this.cdr().ninth();
    }

    public LispValue last() {
        LispValue ptr = this;
        long len = 0L;
        long maxLength = this.f_lisp.getMaxListLength().getLongValue();
        while (!ptr.cdr().basic_null()) {
            if (!ptr.basic_consp()) {
                throw new LispValueNotAListException("An argument to LAST");
            }
            if (++len > maxLength) {
                throw new LispValueNotAListException("Encountered a list whose length is greater than " + maxLength + ".  This is probably an error.  Adjust *MAX-LIST-LENGTH* if necessary.");
            }
            ptr = ptr.cdr();
        }
        return ptr;
    }

    public LispValue length() {
        LispValue ptr = this;
        long len = 0L;
        long maxLength = this.f_lisp.getMaxListLength().getLongValue();
        while (!ptr.basic_null()) {
            if (++len > maxLength) {
                System.err.println("list is: " + this.car() + ", remainder is: " + ptr.car() + ", " + ptr.cdr().car() + ", " + ptr.cdr().cdr().car());
                throw new LispValueNotAListException("Encountered a list whose length is greater than " + maxLength + ".  This is probably an error.  Adjust *MAX-LIST-LENGTH* if necessary.");
            }
            if (!ptr.basic_consp()) {
                throw new LispValueNotAListException("An argument to LENGTH");
            }
            ptr = ptr.cdr();
        }
        return new StandardLispInteger(this.f_lisp, len);
    }

    public LispValue member(LispValue elt) {
        if (this.car().eql(elt) == this.f_lisp.T) {
            return this;
        }
        return this.cdr().member(elt);
    }

    public LispValue pop() {
        LispValue result = this.carCell;
        if (!(this.cdrCell instanceof LispConsOrNil)) {
            throw new LispValueNotAConsException("The cdr of the argument to POP ");
        }
        this.carCell = this.cdrCell.car();
        this.cdrCell = this.cdrCell.cdr();
        return result;
    }

    public LispValue push(LispValue value) {
        this.cdrCell = new StandardLispCons(this.f_lisp, this.carCell, this.cdrCell);
        this.carCell = value;
        return this;
    }

    public LispValue rassoc(LispValue index) {
        LispValue ptr = this;
        long len = 0L;
        long maxLength = this.f_lisp.getMaxListLength().getLongValue();
        while (!ptr.basic_null()) {
            LispValue value = ptr.car();
            if (!ptr.basic_consp()) {
                throw new LispValueNotAListException("The second argument to RASSOC");
            }
            if (index.eql(value.cdr()) == this.f_lisp.T) {
                return value;
            }
            ptr = ptr.cdr();
            if (++len <= maxLength) continue;
            throw new LispValueNotAListException("Encountered a list whose length is greater than " + maxLength + ".  This is probably an error.  Adjust *MAX-LIST-LENGTH* if necessary.");
        }
        return this.f_lisp.NIL;
    }

    public LispValue rest() {
        return this.cdrCell;
    }

    public LispValue remove(LispValue elt) {
        if (this.car().eql(elt) == this.f_lisp.T) {
            return this.cdr().remove(elt);
        }
        return new StandardLispCons(this.f_lisp, this.car(), this.cdr().remove(elt));
    }

    public LispValue rplaca(LispValue newCar) {
        this.carCell = newCar;
        return this;
    }

    public LispValue rplacd(LispValue newCdr) {
        this.cdrCell = newCdr;
        return this;
    }

    public LispValue subst(LispValue newValue, LispValue oldValue) {
        if (oldValue.eql(this.car()) == this.f_lisp.T) {
            return new StandardLispCons(this.f_lisp, newValue, this.cdr().subst(newValue, oldValue));
        }
        if (oldValue.eql(this.cdr()) == this.f_lisp.T) {
            return new StandardLispCons(this.f_lisp, this.car(), newValue);
        }
        return new StandardLispCons(this.f_lisp, this.car(), this.cdr().subst(newValue, oldValue));
    }

    public LispValue type_of() {
        return this.f_lisp.CONS_TYPE;
    }

    public LispValue typep(LispValue type) {
        LispValue result = super.typep(type);
        if (result == this.f_lisp.T || type == this.f_lisp.CONS_TYPE) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }
}

