/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_CONNECTION_MANAGER_FACTORY_H
#define QTTAPIOCA_CONNECTION_MANAGER_FACTORY_H

#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QObject>

namespace QtTapioca {

class ConnectionManager;
class ConnectionManagerFactoryPrivate;

class ConnectionManagerFactory: public QObject {
    Q_OBJECT
    Q_DECLARE_PRIVATE(ConnectionManagerFactory)

public:
    ~ConnectionManagerFactory();

    static ConnectionManagerFactory *self();

    static void registerTypes();

    const QList<ConnectionManager*> &getAllConnectionManagers() const;
    QList<ConnectionManager*> getConnectionManagers(const QString &protocol) const;
    ConnectionManager *getConnectionManager(const QString &protocol) const;
    ConnectionManager *getConnectionManagerByName(const QString &name) const;

Q_SIGNALS:
    void newConnectionManager(const QString &protocol);

private:
    /* disable copy constructor */
    ConnectionManagerFactory(const ConnectionManagerFactory &);
    ConnectionManagerFactory();
    void load();

    static ConnectionManagerFactory *s_self;
    QList<ConnectionManager*> m_cms;
    ConnectionManagerFactoryPrivate *d;
};

} // namespace

#endif

