/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_CHANNEL_H
#define QTTAPIOCA_CHANNEL_H

#include <QtCore/QList>
#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtTapioca/DBusProxyObject>

namespace QtTapioca {

class Connection;
class ChannelPrivate;
class ChannelTarget;

class Channel: public DBusProxyObject {
    Q_OBJECT
    Q_PROPERTY(Type type READ type)
    Q_DECLARE_PRIVATE(Channel)
    Q_ENUMS(Type)

public:
    enum Type {
        Text = 0,
        Audio,
        Video
    };

    ~Channel();

    Type type() const { return m_type; }

    /** Returns the channel's target */
    ChannelTarget* target() const;

    void close();

Q_SIGNALS:
    void closed();

private Q_SLOTS:
    void onClosed();

private:
    friend class TextChannel;

    Channel(Connection *conn, const QString &serviceName, const QString &objPath, Type type, ChannelTarget *target, QObject *parent = 0);

    Type m_type;
    ChannelPrivate *d;
};

} // namespace

#endif

