#!/usr/bin/perl -w
###############################################################################
#                                                                             #
#  TakTuk, a middleware for adaptive large scale parallel remote executions   #
#  deployment. Perl implementation, copyright(C) 2006 Guillaume Huard.        #
#                                                                             #
#  This program is free software; you can redistribute it and/or modify       #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  This program is distributed in the hope that it will be useful,            #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with this program; if not, write to the Free Software                #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
#                                                                             #
#  Contact: Guillaume.Huard@imag.fr                                           #
#           ENSIMAG - Laboratoire ID                                          #
#           51 avenue Jean Kuntzmann                                          #
#           38330 Montbonnot Saint Martin                                     #
#                                                                             #
###############################################################################

use strict;

print "I'm process $ENV{TAKTUK_RANK} among $ENV{TAKTUK_COUNT}\n";

if ($ENV{TAKTUK_RANK} > 1)
  {
    my ($to, $from, $message) = taktuk::recv();
    if (not defined($message))
      {
        print taktuk::error_msg($taktuk::error), "\n";
      }
    else
      {
        print "$to received $message from $from\n";
      }
  }

sleep 1;
my $next = $ENV{TAKTUK_RANK}+1;
$next = 1 if ($next > $ENV{TAKTUK_COUNT});
if (not taktuk::send(to=>$next,body=>"[Salut numero $ENV{TAKTUK_RANK}]"))
  {
    print taktuk::error_msg($taktuk::error), "\n";
  }

if ($ENV{TAKTUK_RANK} == 1)
  {
    my ($to, $from, $message) = taktuk::recv(timeout=>5);
    if (not defined($message))
      {
        print taktuk::error_msg($taktuk::error), "\n";
      }
    else
      {
        print "$to received $message from $from\n";
      }
  }
