#ifndef ITEM_LIST_H
#define ITEM_LIST_H

/*
 * Item list widget
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma interface

#include <sigc++/sigc++.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/box.h>
#include <gtkmm/label.h>
#include <gtkmm/entry.h>
#include <gtkmm/menu.h>
#include <TagcollDocument.h>

class ItemList : public Gtk::VBox
{
public:
	//typedef SigC::Signal0<void> type_signal_changed;
	typedef SigC::Signal0<void> type_signal_selection_changed;
	typedef SigC::Signal0<void> type_signal_focus_in;
	typedef SigC::Signal1<void, TagCollection<int>::Change> type_signal_request_tagcoll_change;
	typedef SigC::Signal0<void> type_signal_request_tagset_merge;
	typedef SigC::Signal0<void> type_signal_request_tagset_intersect;
	typedef SigC::Signal0<void> type_signal_request_item_copy;
	typedef SigC::Signal0<void> type_signal_request_item_move;
	typedef SigC::Signal1< void, OpSet<std::string> > type_signal_select_tagset;
	typedef SigC::Signal1< void, OpSet<std::string> > type_signal_select_tagset_other_panel;

protected:
	TagcollDocument<std::string>& doc;
	OpSet<std::string> _tagset;
	Glib::ustring filter;
	
	Gtk::TreeView itemList;
	Glib::RefPtr<Gtk::ListStore> itemListModel;

	Gtk::ScrolledWindow scrolledItemList;
	Gtk::HBox filterHBox;
	Gtk::Label filterLabel;
	Gtk::Entry filterEdit;
	Gtk::Menu itemPopup;

	std::vector<std::string> selected;

	// Tree model columns
	class ItemListModelColumns : public Gtk::TreeModel::ColumnRecord
	{
	public:
		ItemListModelColumns() { add(name); add(tags); }

		Gtk::TreeModelColumn<Glib::ustring> name;
		Gtk::TreeModelColumn< OpSet<std::string> > tags;
	};

	ItemListModelColumns itemListModelColumns;
	
	//type_signal_changed _signal_changed;
	type_signal_selection_changed _signal_selection_changed;
	type_signal_focus_in _signal_focus_in;
	type_signal_request_tagcoll_change _signal_request_tagcoll_change;
	type_signal_request_tagset_merge _signal_request_tagset_merge;
	type_signal_request_tagset_intersect _signal_request_tagset_intersect;
	type_signal_request_item_copy _signal_request_item_copy;
	type_signal_request_item_move _signal_request_item_move;
	type_signal_select_tagset _signal_select_tagset;
	type_signal_select_tagset_other_panel _signal_select_tagset_other_panel;

	void updateList();

	//void on_selectedList_row_activated(const Gtk::TreePath& path, Gtk::TreeViewColumn*);
	//void on_availableList_row_activated(const Gtk::TreePath& path, Gtk::TreeViewColumn*);
	void on_filter_changed();
	void on_document_changed();
	bool on_event(GdkEvent* e);
	void on_selected_row_iterated(const Gtk::TreeModel::iterator& iter);
	void on_add_tag(std::string tag);
	void on_remove_tag(std::string tag);
	void do_signal_request_tagcoll_change(TagCollection<int>::Change change);
	void do_signal_request_tagset_merge();
	void do_signal_request_tagset_intersect();
	void do_signal_request_item_copy();
	void do_signal_request_item_move();
	void do_signal_select_tagset(OpSet<std::string> tagset);
	void do_signal_select_tagset_other_panel(OpSet<std::string> tagset);

public:
	ItemList(TagcollDocument<std::string>& doc);
	virtual ~ItemList() {}

	void setTagset(const OpSet<std::string>& ts) { _tagset = ts; updateList(); }

	std::map< std::string, OpSet<std::string> > getAllItems();
	std::map< std::string, OpSet<std::string> > getSelection();
	int getSelectionSize();

	//type_signal_changed signal_changed() throw () { return _signal_changed; }
	//virtual void do_changed();

	virtual void do_selection_changed();
	virtual void do_focus_in();
	virtual void on_itemList_drag_data_get(
			const Glib::RefPtr<Gdk::DragContext>&, GtkSelectionData* selection_data, guint, guint);
	virtual void on_itemList_drop_drag_data_received(
			const Glib::RefPtr<Gdk::DragContext>& context, int, int, GtkSelectionData* selection_data, guint, guint time);
	virtual bool on_focus_in(GdkEventFocus*);

	// Signals
	type_signal_selection_changed signal_selection_changed() throw ()
		{ return _signal_selection_changed; }
	type_signal_focus_in signal_focus_in() throw ()
		{ return _signal_focus_in; }
	type_signal_request_tagcoll_change signal_request_tagcoll_change() throw ()
		{ return _signal_request_tagcoll_change; }
	type_signal_request_tagset_merge signal_request_tagset_merge() throw ()
		{ return _signal_request_tagset_merge; }
	type_signal_request_tagset_intersect signal_request_tagset_intersect() throw ()
		{ return _signal_request_tagset_intersect; }
	type_signal_request_item_copy signal_request_item_copy() throw ()
		{ return _signal_request_item_copy; }
	type_signal_request_item_move signal_request_item_move() throw ()
		{ return _signal_request_item_move; }
	type_signal_select_tagset signal_select_tagset() throw ()
		{ return _signal_select_tagset; }
	type_signal_select_tagset_other_panel signal_select_tagset_other_panel() throw ()
		{ return _signal_select_tagset_other_panel; }

	friend class TagsetCellRenderer;
};

// vim:set ts=4 sw=4:
#endif
