#include "common.h"

int getMdVersion(mdu_version_t * ver) {
    int file;
    int ret;

    file = open("/dev/md0",O_RDONLY);
    if (file < 0) {
	if (errno != ENOENT)
		goto err;
	file = open("/dev/md/0",O_RDONLY);
	if (file < 0)
		goto err;
    }

    ret = ioctl(file, RAID_VERSION, (unsigned long)ver);
    if (ret == -1) {
	if (errno == EINVAL) {
	    /* just fake it */
	    ver->major = 0;
	    ver->minor = 36;
	    ver->patchlevel = 0;
	} else {
err:
	    fprintf(stderr, "cannot determine md version: ");
	    if (errno == EACCES)
	        fprintf(stderr, "need to be run as root.\n");
	    else if (errno == ENOSYS)
	        fprintf(stderr, "kernel has no RAID support.\n");
	    else if (errno == EEXIST)
	        fprintf(stderr, "device already running!\n");
	    else if (errno == ENOENT)
	        fprintf(stderr, "no MD device file in /dev.\n");
	    else
	        fprintf(stderr, "%d.\n", errno);
	    close(file);
	    return -1;
	}
    }

    close(file);

    return 0;
}
