'''
 ====================================================================
 Copyright (c) 2003-2005 Barry A Scott.  All rights reserved.

 This software is licensed as described in the file LICENSE.txt,
 which you should have received as part of this distribution.

 ====================================================================

    wb_shell_unix_commands.py

'''
import os
import xml.sax.saxutils

def EditFile( app, project_info, filename ):
    p = app.prefs.getEditor()

    if p.editor_image:
        if p.editor_options:
            command_line = '"%s" %s "%s" &' % \
                (p.editor_image, p.editor_options, filename)
        else:
            command_line = '"%s" "%s" &' % \
                (p.editor_image, filename)
    else:
        command_line = '"open" -e "%s" &' % filename

    app.log.info( command_line )
    cur_dir = os.getcwd()
    try:
        os.chdir( project_info.getWorkingDir() )
        os.system( command_line )
    finally:
        os.chdir( cur_dir )

def ShellOpen( app, project_info, filename ):
    print 'Open',filename
    cur_dir = os.getcwd()
    try:
        os.chdir( project_info.getWorkingDir() )
        os.system( 'open "%s"' % filename )
    finally:
        os.chdir( cur_dir )

def CommandShell( app, project_info ):
    shell_script_filename = os.path.join( '/tmp', 'wb.term' )

    p = app.prefs.getShell()
    working_dir = project_info.getWorkingDir()

    # calc a title that is leaf to root so that the leaf shows up in a task bar first
    title = []
    pi = project_info
    while pi:
        title.append( pi.project_name )
        pi = pi.parent

    commands = 'cd "%s"' % working_dir

    if len( p.shell_init_command ) > 0:
        commands = commands + ';. "%s"\n' % p.shell_init_command

    f  = open( shell_script_filename, 'w' )
    f.write( '''<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple Computer//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
    <key>WindowSettings</key>
    <array>
        <dict>
            <key>CustomTitle</key>
            <string>%s</string>
            <key>ExecutionString</key>
            <string>%s</string>
        </dict>
    </array>
</dict>
</plist>
''' % (xml.sax.saxutils.escape( ' '.join( title ) ), xml.sax.saxutils.escape( commands )) )
    f.close()

    command_line = '"open" "%s" &' % shell_script_filename

    app.log.info( command_line )
    os.system( command_line )

def FileBrowser( app, project_info ):
    command_line = 'open -a "Finder" "%s" &' % project_info.getWorkingDir()

    app.log.info( command_line )
    os.system( command_line )
