package SDCommon;

use base qw/ Exporter /;
our @EXPORT = qw(writeCfg withecho withechoNoPrompt needs_upsTagUrl
needs_upsCurrentUrl needs_tagsUrl url insvn long_path oldSvnDirsCheck);
#### common ####
#

use Cwd;

# workaround for the old piece of Perl shit in Woody
sub long_path {
   if( ($] cmp "5.008") >= 0) {
      return Cwd::abs_path($_[0]);
   }
   use File::Basename;
   return $_[0] if (! -r $_[0]);
   return Cwd::abs_path(dirname($_[0]))."/".basename($_[0]); # would break on symlinks but get a newer perl if you wanna fix it
   #   ( (-l $_[0]) ? readlink($_[0]) : $_[0]);
}

$cfgFile=long_path(".svn/deb-layout");
my $opt_quiet;

sub exwerror {
   print STDERR $_[0]."\n";
   exit 1;
}

sub withecho {
   # weed undefs out
   for($i=0; $i<=$#_; $i++) {splice(@_, $i, 1) if(!defined($_[$i]));}
   $cmd=join(' ',@_);
   retry:
   print STDERR "$cmd\n" if(!$opt_quiet);
   if(system(@_)) {
      print STDERR "Command $cmd failed, how to continue now? [Qri?]: ";
      prompt:
      $ans = <STDIN>;
      if($ans =~ /^q\n/i) {
         exwerror("Aborting.\n");
      }
      elsif($ans =~ /^i\n/i) {
         return 1;
      }
      elsif($ans =~ /^r\n/i) {
         goto retry;
      }
      else {
         print STDERR "Invalid selection! " if (! ($ans =~ /^\?/i));
         print STDERR "The choices are: Quit (q), Retry (r), Ignore & continue (i).\n";
         print STDERR "[Qri?]: ";
         goto prompt;
      }
   }
   return 1;
}

sub withechoNoPrompt {
   # weed undefs out
   for($i=0; $i<=$#_; $i++) {splice(@_, $i, 1) if(!defined($_[$i]));}
   $cmd=join(' ',@_);
   print STDERR "$cmd\n" if(!$opt_quiet);
   return (!system(@_));
}

sub oldSvnDirsCheck {
   my @svndirs;
   $dir = $_[0];
   @svndirs=`find $dir -name .svn`;
   if(@svndirs) {
      print "Found conflicting .svn directories in the upstream source:\n";
      if($opt_verbose) {
         print @svndirs;
      }
      else {
         print "use -v to display the files\n";
      }
      print "Hint: use the uclean program to fix upstream source tarball\n";
      exit 1;
   }
}
         

# gets the url of specified local (checkout) directory
sub url {
   my $info;
   return undef if !defined $_[0];
   # bloated with caching, maybe reduce to returning URL again
   my $URL;
   my $PATH;
   $testpath=long_path($_[0]);
   return $cacheUrl{$testpath} if($cacheUrl{$testpath});
   open($info, "svn info $testpath 2>/dev/null |");
   while(<$info>) { 
      $URL=$1 if(/^Url:\W*(.+)\n/i); 
      $PATH=$1 if(/^Path:\s*(.+)\n/i);
   };
   if($URL && close($info)) {
      $cacheUrl{$testpath}=$URL;
      $cacheUrl{$PATH}=$URl;
      return $URL;
   }
   return undef;
}

sub insvn {
   $testurl = $_[0];
   my $url=$testurl;
   $url =~ /(.*:\/\/)(.*)/;
   $proto=$1;
   $url=$2;
   while( $url =~ /\.\./) { 
      $url =~ s/\/\//\//g;
      $url =~ s/[^\/]+\/\.\.//g;
      $url =~ s/\/\//\//g;
   }
   $url =~ s/\/$//g;
   $url=$proto.$url;
   return undef if !defined $testurl;
   return  $inSvn{$testurl} if $inSvn{$testurl};
   open($info, "svn ls $url 2>/dev/null |");
   @junk=<$info>;
   if (close $info) {
      $inSvn{$testurl}=$url;
      return $url;
   }
   return undef;
}

# helper to automate lookup for variables
# does not change defined var, but looks for useful path if not defined
sub such {
   
   my @testloc;
   my @testsvn;
   our($pre, $suf, $var, $basedir) = @_;
   # if basedir contains :// -> svn lookup;
   # args: 
   # prefix: like branches
   # suffix: like upstream
   # var: name of the variable we work on in %c
   # basedir: starting directory. If ommited, `pwd` is used

   return if (defined($c{$var}));
   
   $basedir=Cwd::getcwd if(!$basedir);
   if($basedir=~/:\/\//) {
      print "W: $var not specified anywhere, looking in the local repository...\n";
      @testsvn=("$basedir/../$pre/$suf",
      "$basedir/../../$pre/$package/$suf");
   }
   else {
      if($opt_verbose) {
         print "I: trying blind lookup for ressource directories in SVN repository.\n";
         print "D: $pre, $suf, $var, $basedir.\n";
         print "I: adding the URLs to the $cfgFile to skip the check later.\n";
      }
      @testloc=(long_path("$basedir/../$pre/$suf"),
      long_path("$basedir/../../$pre/$package/$suf"));
   }
   foreach $dir (@testloc) {
      if ($dir && -d $dir) { $c{$var}=$dir; return;}
   }
   for (@testsvn) {
      if ($_ && insvn($_)) { $c{$var}=insvn($_); return;}
   }
}

# if still undefined, try blind search in the repository
sub needs_upsTagUrl {
   such("branches","upstream", "upsTagUrl", url("."));
   exwerror "upsTagUrl setting is required, but could not be found in $cfgFile or repository tree." if (!defined $c{"upsTagUrl"});
}
sub needs_upsCurrentUrl {
   such("branches","upstream/current", "upsCurrentUrl", url("."));
   exwerror "upsCurrentUrl setting is required, but could not be found in $cfgFile or repository tree." if (!defined $c{"upsCurrentUrl"});
}
sub needs_tagsUrl {
   such("tags", "", "tagsUrl", url("."));
   exwerror "tagsUrl setting is required, but could not be found in $cfgFile or repository tree." if (!defined $c{"tagsUrl"});
}
sub writeCfg {
   if($_[0]){$cfgFile = $_[0];}
   open($cfg, ">$cfgFile") || die "Could not open $cfgFile for writing.\n";
   foreach (sort(keys %c)) {
      print $cfg "$_=".$c{$_}."\n" if defined $c{$_};
   }
   print $cfg @cfgRest;
   close($cfg);
}

sub sd_exit {
   print "Writing config: $cfgFile\n\n\n" if $opt_verbose;
   $ret=$_[0];
   &writeCfg();
   # print STDERR "Return-Code: $ret";
   exit $ret;
}

sub configure {

   open($infoC, "svn info debian/changelog |");  @junk=<$infoC>;
   if(!close($infoC)) {
      exwerror "Not started from the Trunk directory or not a valid SVN repository. Aborting.\n";
   }

#   `head -n1 debian/changelog` =~ /^(\S+)\s*\((.+)\)/;
#   $package=$1 if(!defined($package));
#   $upVersion=$2;
#   $tagVersion=$upVersion;
#   if(!$force_debian) {
#      $upVersion=~s/^.*://;
#      $upVersion=~s/-.*//;
#   }

   if(  (-f "debian/changelog" &&
         `head -n1 debian/changelog` =~ /^(\S+)\s*\((.+)\)/
      )
      || 
      (-f "../debian/changelog" && chdir ".." &&
         `head -n1 debian/changelog` =~ /^(\S+)\s*\((.+)\)/
      )
   )
      {
      $package=$1;
      $upVersion=$2;
      $tagVersion=$upVersion;
      if(!$force_debian) {
         $upVersion=~s/^.*://;
         $upVersion=~s/(.*)-([^-]+)/$1/;
      }
      print STDERR "I: Got package name and version from debian/changelog.\n" if $opt_verbose;
   }
   else { 
      exwerror "E: Not started from the trunk/PACKAGE directory.\n";
   }
   print "
   Package name: $package
   Current upstream version: $upVersion
   Debian tag: $tagVersion

   " if $opt_verbose;

   # keep the list of known vars here
   # @cfgVars=("upsCurrentDir", "upsTagDir", "tagsDir", "origDir", "origUrl",
   # "upsCurrentUrl","upsTagUrl", "tagsUrl", "trunkUrl", "trunkDir");

   if(-e $cfgFile) {
      print "Settings found in $cfgFile :\n";
      open($cfg, "<$cfgFile");
      while(<$cfg>) {
         if(/(\S+)\s*=\s*(.+)(\n|\r)*/) {
            $val=$2;
            $val=~ s/\ ~/\ $ENV{"HOME"}/;
            $c{$1}=$val;
            print "\t$1: $val\n";
         }
         else {
            push(@cfgRest,$_);
         }
      }
      close($cfg);
   }
   else {
      print "$cfgFile not found, autodetecting settings...\n";
   }

   # always redetect them; keep them in the same config base just for the
   # record
   $c{"trunkUrl"}=url(".");
   if($c{"trunkUrl"}) {
      $c{"trunkDir"}=getcwd;
   }
   else {
      exwerror "We are not in a working copy of SVN trunk directory";
   }

   foreach(values(%c)) {
      exwerror "\nThe directory $_ does not exist!

Create this directory or fix the setting in .svn/deb-layout or remove that
line and let svn-descripts redetect the value. Also check the associated URL.

" if($_=~/^\// && ! -e $_);
   }
   # lookup for local locations and get URLs from them if needed
   such("build-area", "", "buildArea");
   such("tags", "", "tagsDir");
   $c{"tagsUrl"}=url($c{"tagsDir"}) if($c{"tagsDir"} && !defined $c{"tagsUrl"});
   if($upVersion ne $tagVersion) {
      such("branches","upstream", "upsTagDir");
      $c{"upsTagUrl"}=url($c{"upsTagDir"}) if($c{"upsTagDir"} && !defined $c{"upsTagUrl"});
      such("branches","upstream/current", "upsCurrentDir");
      $c{"upsCurrentUrl"}=url($c{"upsCurrentDir"}) if($c{"upsCurrentDir"} && !defined $c{"upsCurrentUrl"});
      such("tarballs", "", "origDir");
      $c{"origUrl"}=url($c{"origDir"}) if($c{"origDir"} && !defined $c{"origUrl"});
   }

   &writeCfg;
   #
   #foreach("branches", "tarballs", "trunk", "tags") {
   #   if(length($pkgDir)) {
   #      exwerror "E: Weird directory structure. Where am I? Missing $startdir/$_/$package/\n"
   #      if(! -d $_."/$package");
   #   }
   #   else {
   #      mkdir $_;
   ##      withecho "svn $quiet add $_" if(`svn status -N $_`=~/^\?/);
   #   }
   #}
   #
   ## sanity check first
}

sub check_uncommited {
   open($svn, "svn status |");
   @conflicts = <$svn>;
   if ($#conflicts != -1) {
      print "E: found unresolved issues: \n\n @conflicts\n";
      exwerror "E: Resolve them manually before continueing\n";
   }
   close($svn);
}

1;
##
##### /common ###

