/*
 * Decompiled with CFR 0.152.
 */
package roadnetwork;

import classes.ProjectElement;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import shapes.Polygon2D;
import shapes.Rectangle2DExt;

public abstract class RoadNetworkElement
extends ProjectElement
implements Serializable {
    protected String id;
    protected Polygon2D.Double shape;

    @Override
    public void Draw(Graphics2D g, double zoomFactor, boolean isDeleted, boolean isSelected) {
        Color prev = g.getColor();
        if (!isSelected && !isDeleted) {
            g.setColor(Color.BLACK);
        }
        if (isSelected && !isDeleted) {
            g.setColor(Color.GREEN);
        }
        if (!isSelected && isDeleted) {
            g.setColor(Color.RED);
        }
        if (isSelected && isDeleted) {
            g.setColor(Color.ORANGE);
        }
        g.fill(this.shape);
        g.setColor(prev);
    }

    @Override
    public Rectangle2DExt getBounds() {
        return new Rectangle2DExt(this.shape.getBounds2D());
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean Hit(Point p) {
        return this.shape.getBounds2D().contains(p.x, p.y) && this.shape.contains(p.x, p.y);
    }

    @Override
    public boolean Hit(Rectangle transformedRectangle) {
        return this.shape.intersects(transformedRectangle);
    }

    public boolean Overlaps(Shape s) {
        return this.shape.overlaps(s);
    }

    public void setId(String id) {
        this.id = id;
    }
}

