/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.sumo;

import cadyts.demand.ODRelation;
import cadyts.utilities.math.Cholesky;
import cadyts.utilities.math.Matrix;
import cadyts.utilities.math.simulatedannealing.SolutionEvaluator;
import cadyts.utilities.misc.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class SensorLocationObjectiveFunction
implements SolutionEvaluator<Set<String>> {
    private final double priorOdVarianceScale;
    private final Map<ODRelation<String>, Double> od2demand;
    private final Map<ODRelation<String>, Set<String>> od2links;
    private final Map<Tuple<ODRelation<String>, String>, Double> odAndLink2coverage;
    private Set<String> lastSolution;
    private double lastEvaluation;

    SensorLocationObjectiveFunction(double priorOdVarianceScale) {
        this.priorOdVarianceScale = priorOdVarianceScale;
        this.od2demand = new LinkedHashMap<ODRelation<String>, Double>();
        this.od2links = new LinkedHashMap<ODRelation<String>, Set<String>>();
        this.odAndLink2coverage = new LinkedHashMap<Tuple<ODRelation<String>, String>, Double>();
        this.lastSolution = null;
        this.lastEvaluation = Double.NaN;
    }

    void registerOdLink(ODRelation<String> od, String link, double probability) {
        this.od2demand.put(od, (this.od2demand.containsKey(od) ? this.od2demand.get(od) : 0.0) + probability);
        Set<String> coveredLinks = this.od2links.get(od);
        if (coveredLinks == null) {
            coveredLinks = new LinkedHashSet<String>();
            this.od2links.put(od, coveredLinks);
        }
        coveredLinks.add(link);
        Tuple<ODRelation<String>, String> key = new Tuple<ODRelation<String>, String>(od, link);
        Double coverage = this.odAndLink2coverage.get(key);
        if (coverage == null) {
            this.odAndLink2coverage.put(key, probability);
        } else {
            this.odAndLink2coverage.put(key, coverage + probability);
        }
    }

    int odCnt() {
        return this.od2links.size();
    }

    @Override
    public boolean feasible(Set<String> solution) {
        double eval = this.evaluation(solution);
        return !Double.isInfinite(eval) && !Double.isNaN(eval);
    }

    @Override
    public double evaluation(Set<String> solution) {
        if (solution.equals(this.lastSolution)) {
            return this.lastEvaluation;
        }
        int dim = this.od2links.size();
        Matrix negativeHessian = new Matrix(dim, dim);
        ArrayList<ODRelation<String>> odList = new ArrayList<ODRelation<String>>(this.od2links.keySet());
        int i = 0;
        while (i < dim) {
            ODRelation odi = (ODRelation)odList.get(i);
            double demandi = this.od2demand.get(odi);
            int j = 0;
            while (j <= i) {
                ODRelation odj = (ODRelation)odList.get(j);
                double demandj = this.od2demand.get(odj);
                LinkedHashSet<String> jointSensors = new LinkedHashSet<String>(solution);
                jointSensors.retainAll((Collection)this.od2links.get(odi));
                jointSensors.retainAll((Collection)this.od2links.get(odj));
                double entry = 0.0;
                for (String link : jointSensors) {
                    Tuple<ODRelation, String> key1 = new Tuple<ODRelation, String>(odi, link);
                    Tuple<ODRelation, String> key2 = new Tuple<ODRelation, String>(odj, link);
                    entry += this.odAndLink2coverage.get(key1) * this.odAndLink2coverage.get(key2);
                }
                entry /= demandi * demandj;
                if (i == j) {
                    double addend = 1.0 / (this.priorOdVarianceScale * (1.0 + demandi));
                    negativeHessian.getRow(i).set(i, entry + addend);
                } else {
                    negativeHessian.getRow(i).set(j, entry);
                    negativeHessian.getRow(j).set(i, entry);
                }
                ++j;
            }
            ++i;
        }
        Cholesky cholesky = new Cholesky();
        cholesky.invert(negativeHessian);
        if (!cholesky.valid()) {
            return Double.POSITIVE_INFINITY;
        }
        double evaluation = 0.0;
        Matrix cov = cholesky.getResult();
        int i2 = 0;
        while (i2 < dim) {
            evaluation += cov.getRow(i2).get(i2);
            ++i2;
        }
        this.lastSolution = solution;
        this.lastEvaluation = evaluation;
        return evaluation;
    }
}

