/*
 * Decompiled with CFR 0.152.
 */
package tdl;

import classes.Pair;
import classes.TypeSelection;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import simulation.JobType;
import simulation.VehicleType;

public class XMLHelpers {
    public static String shapeToXML(Shape s) {
        StringBuilder sb = new StringBuilder();
        PathIterator pi = s.getPathIterator(new AffineTransform());
        float[] coords = new float[6];
        while (!pi.isDone()) {
            pi.currentSegment(coords);
            sb.append(String.valueOf(String.valueOf(coords[0])) + "," + String.valueOf(coords[1]));
            pi.next();
            if (pi.isDone()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String vehicleSelectionToXML(String elementName, TypeSelection<VehicleType> vehicleSelection) {
        StringBuilder sb = new StringBuilder();
        sb.append("<" + elementName + ">\n");
        for (Pair pair : vehicleSelection) {
            sb.append("<selectedVehicle vehicleType=\"" + ((VehicleType)pair.getFirst()).getName() + "\" probability=\"" + ((Float)pair.getSecond()).toString() + "\"/>\n");
        }
        sb.append("</" + elementName + ">\n");
        return sb.toString();
    }

    public static String jobSelectionToXML(String elementName, TypeSelection<JobType> jobSelection) {
        StringBuilder sb = new StringBuilder();
        sb.append("<" + elementName + ">\n");
        for (Pair pair : jobSelection) {
            sb.append("<selectedJob jobType=\"" + ((JobType)pair.getFirst()).getName() + "\" probability=\"" + ((Float)pair.getSecond()).toString() + "\"/>\n");
        }
        sb.append("</" + elementName + ">\n");
        return sb.toString();
    }
}

