/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import cern.jet.random.Poisson;
import classes.Constants;
import classes.Pair;
import classes.TypeSelection;
import enums.SchoolType;
import helpers.RandomNumberProvider;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import roadnetwork.Edge;
import roadnetwork.Lane;
import roadnetwork.RoadNetwork;
import simulation.Adult;
import simulation.Child;
import simulation.House;
import simulation.JobType;
import simulation.Route;
import simulation.SUMOInstructionList;
import simulation.Trip;
import simulation.VehicleType;
import trafficdefinition.Accident;
import trafficdefinition.AreaFlow;
import trafficdefinition.Flow;
import trafficdefinition.HotSpot;
import trafficdefinition.RandomTrafficDefinitionLayer;
import trafficdefinition.School;
import trafficdefinition.TrafficArea;
import trafficdefinition.TrafficDefinitionElement;
import trafficdefinition.UserDefinedTrafficDefinitionLayer;

public class TrafficGenerator {
    public static void GenerateUserDefinedLayerTraffic(RoadNetwork roadNetwork, UserDefinedTrafficDefinitionLayer layer, SUMOInstructionList<Trip> tripsList, SUMOInstructionList<Route> accidentRoutesList) throws Exception {
        List layerElements = layer.getElements();
        for (TrafficDefinitionElement t : layerElements) {
            if (!t.isEnabled()) continue;
            if (t instanceof Flow) {
                tripsList.addAll(TrafficGenerator.GenerateFlowTraffic((Flow)t));
                continue;
            }
            if (t instanceof AreaFlow) {
                tripsList.addAll(TrafficGenerator.GenerateAreaFlowTraffic((AreaFlow)t, roadNetwork));
                continue;
            }
            if (t instanceof HotSpot) {
                tripsList.addAll(TrafficGenerator.GenerateHotSpotTraffic((HotSpot)t, roadNetwork));
                continue;
            }
            if (!(t instanceof Accident)) continue;
            accidentRoutesList.addAll(TrafficGenerator.GenerateAccidentTraffic((Accident)t, roadNetwork));
        }
    }

    public static void GenerateRandomLayerTraffic(RoadNetwork roadNetwork, RandomTrafficDefinitionLayer layer, SUMOInstructionList<Trip> tripsList) throws Exception {
        Random r = RandomNumberProvider.getRandom();
        List<Object> allEdges = new ArrayList();
        allEdges = roadNetwork.getEdges();
        int totalNetworkEdges = allEdges.size();
        String color = "1,0,0";
        if (totalNetworkEdges == 0) {
            return;
        }
        int emissionDuration = layer.getEndingTime() - layer.getStartingTime();
        int totalVehiclesToEmit = layer.getVehiclesPerSecond() * emissionDuration;
        int i = 0;
        while (i < totalVehiclesToEmit) {
            VehicleType vehicleType = layer.getVehicleSelection().getRandomType();
            Edge randomNetworkEdge1 = (Edge)allEdges.get(r.nextInt(totalNetworkEdges));
            Edge randomNetworkEdge2 = (Edge)allEdges.get(r.nextInt(totalNetworkEdges));
            int timeToLeave = layer.getStartingTime() + r.nextInt(layer.getEndingTime() + 1 - layer.getStartingTime());
            tripsList.add(new Trip(timeToLeave, "<tripdef id=\"" + layer.getName() + "-In-" + String.valueOf(i) + "\" depart=\"" + String.valueOf(timeToLeave) + "\" from=\"" + randomNetworkEdge1.getId() + "\" to=\"" + randomNetworkEdge2.getId() + "\" color=\"" + color + "\" type=\"" + vehicleType.getName() + "\" />\n"));
            ++i;
        }
    }

    public static void GenerateActivityBasedTraffic(RoadNetwork roadNetwork, List<JobType> projectJobTypes, TypeSelection<VehicleType> vehicleTypes, List<TrafficDefinitionElement> activityBasedTrafficDefinitionElements, SUMOInstructionList<Trip> tripsList, SUMOInstructionList<Route> routesList) throws Exception {
        ArrayList<TrafficArea> areas = new ArrayList<TrafficArea>();
        ArrayList<School> schools = new ArrayList<School>();
        for (TrafficDefinitionElement t : activityBasedTrafficDefinitionElements) {
            if (t instanceof TrafficArea) {
                areas.add((TrafficArea)t);
                continue;
            }
            if (!(t instanceof School)) continue;
            schools.add((School)t);
        }
        for (School school : schools) {
            school.setAvailableCapacity(school.getCapacity());
            school.setClosestEdge(roadNetwork.findClosestEdge(school.getLocation()));
        }
        Hashtable workPositionsPerJobTypePerArea = new Hashtable();
        for (JobType projectJobType : projectJobTypes) {
            ArrayList<Pair<TrafficArea, Integer>> areaPositions = new ArrayList<Pair<TrafficArea, Integer>>();
            for (TrafficArea area : areas) {
                float areaJobPossibility = area.getWorkersJobSelection().getTypePossibility(projectJobType).floatValue();
                if (!(areaJobPossibility > 0.0f)) continue;
                areaPositions.add(new Pair<TrafficArea, Integer>(area, Math.round(areaJobPossibility * (float)area.getWorkPositions())));
            }
            workPositionsPerJobTypePerArea.put(projectJobType, areaPositions);
        }
        int houseID = 0;
        for (TrafficArea area : areas) {
            int unassignedPeople = area.getPopulation();
            ArrayList<House> areaHouses = new ArrayList<House>();
            Random r = RandomNumberProvider.getRandom();
            while (unassignedPeople > 0) {
                House house = new House(area, houseID++);
                Point2D.Double houseLocation = area.getRandomPointInArea();
                house.setAddress(roadNetwork.findClosestEdge(houseLocation));
                house.setLocation(houseLocation);
                int houseAdults = Math.round((float)(r.nextGaussian() * 0.8 + (double)area.getAverageAdultsPerHouse()));
                if (houseAdults < 1) {
                    houseAdults = 1;
                }
                int houseChildren = Poisson.staticNextInt((double)area.getAverageChildrenPerHouse());
                house.createAdults(houseAdults, area.getPossibilityAdultIsDriver(), area.getPossibilityAdultHasJob());
                house.createChildren(houseChildren);
                house.assignVehiclesToDrivers(area.getPossibilityDriverHasCar(), vehicleTypes);
                for (Child child : house.getChildren()) {
                    School closestAvailableSchool = TrafficGenerator.FindClosestSchoolToLocation(schools, child.getSchoolType(), house.getLocation());
                    child.setSchool(closestAvailableSchool);
                    if (closestAvailableSchool == null) continue;
                    closestAvailableSchool.setAvailableCapacity(closestAvailableSchool.getAvailableCapacity() - 1);
                }
                areaHouses.add(house);
                unassignedPeople -= house.getNumberOfResidents();
            }
            for (House house : areaHouses) {
                for (Adult adult : house.getWorkingAdults()) {
                    JobType job = area.getResidentsJobSelection().getRandomType();
                    List jobAreaPositions = (List)workPositionsPerJobTypePerArea.get(job);
                    if (jobAreaPositions.size() > 0) {
                        int i = r.nextInt(jobAreaPositions.size());
                        Point2D.Double jobLocation = ((TrafficArea)((Pair)jobAreaPositions.get(i)).getFirst()).getRandomPointInArea();
                        adult.setJobLocation(job, roadNetwork.findClosestEdge(jobLocation));
                        if ((Integer)((Pair)jobAreaPositions.get(i)).getSecond() == 1) {
                            jobAreaPositions.remove(i);
                            continue;
                        }
                        ((Pair)jobAreaPositions.get(i)).setSecond((Integer)((Pair)jobAreaPositions.get(i)).getSecond() - 1);
                        continue;
                    }
                    adult.setHasJob(false);
                }
            }
            for (House house : areaHouses) {
                System.out.println(String.valueOf(area.getName()) + " " + String.valueOf(house.getId()));
                house.createActivities(tripsList, routesList);
            }
        }
    }

    private static SUMOInstructionList<Trip> GenerateHotSpotTraffic(HotSpot spot, RoadNetwork roadNetwork) {
        Random r = RandomNumberProvider.getRandom();
        SUMOInstructionList<Trip> trips = new SUMOInstructionList<Trip>();
        List<Object> hotspotEdges = new ArrayList();
        hotspotEdges = roadNetwork.SelectEdges(spot.getArea());
        int totalHotspotEdges = hotspotEdges.size();
        List<Object> allEdges = new ArrayList();
        allEdges = roadNetwork.getEdges();
        for (Edge edge : hotspotEdges) {
            if (!allEdges.contains(edge)) continue;
            allEdges.remove(edge);
        }
        int n = allEdges.size();
        String color = String.valueOf(new Float((float)spot.getColor().getRed() / 255.0f).toString()) + "," + new Float((float)spot.getColor().getGreen() / 255.0f).toString() + "," + new Float((float)spot.getColor().getBlue() / 255.0f).toString();
        if (n == 0 || totalHotspotEdges == 0) {
            return null;
        }
        int i = 0;
        while (i < spot.getNumberOfVehicles()) {
            VehicleType vehicleType = spot.getVehicleSelection().getRandomType();
            Edge randomHotspotEdge = (Edge)hotspotEdges.get(r.nextInt(totalHotspotEdges));
            Edge randomNetworkEdge = (Edge)allEdges.get(r.nextInt(n));
            if (spot.isDirectionIn()) {
                int timeOfDepartureFromSource = 0;
                if (spot.getDirectionInType() == HotSpot.DirectionInTimeType.TimeOfDepartureFromSource) {
                    timeOfDepartureFromSource = spot.getDirectionInBeginTime() + r.nextInt(spot.getDirectionInEndTime() + 1 - spot.getDirectionInBeginTime());
                } else if (spot.getDirectionInType() == HotSpot.DirectionInTimeType.TimeOfArrivalToDestination) {
                    float distanceToTravel = randomHotspotEdge.DistanceFrom(randomNetworkEdge);
                    int estimatedTravelTime = Math.round(distanceToTravel / Constants.averageSpeed);
                    timeOfDepartureFromSource = spot.getDirectionInBeginTime() + r.nextInt(spot.getDirectionInEndTime() + 1 - spot.getDirectionInBeginTime()) - estimatedTravelTime;
                    timeOfDepartureFromSource = Math.min(timeOfDepartureFromSource, 0);
                }
                trips.add(new Trip(timeOfDepartureFromSource, "<tripdef id=\"" + spot.getName() + "-In-" + String.valueOf(i) + "\" depart=\"" + String.valueOf(timeOfDepartureFromSource) + "\" from=\"" + randomNetworkEdge.getId() + "\" to=\"" + randomHotspotEdge.getId() + "\" color=\"" + color + "\" type=\"" + vehicleType.getName() + "\" />\n"));
            }
            if (spot.isDirectionOut()) {
                int timeToLeaveSpot = spot.getDirectionOutBeginTime() + r.nextInt(spot.getDirectionOutEndTime() + 1 - spot.getDirectionOutBeginTime());
                trips.add(new Trip(timeToLeaveSpot, "<tripdef id=\"" + spot.getName() + "-Out-" + String.valueOf(i) + "\" depart=\"" + String.valueOf(timeToLeaveSpot) + "\" from=\"" + randomHotspotEdge.getId() + "\" to=\"" + randomNetworkEdge.getId() + "\" color=\"" + color + "\" type=\"" + vehicleType.getName() + "\" />\n"));
            }
            ++i;
        }
        return trips;
    }

    private static SUMOInstructionList<Trip> GenerateFlowTraffic(Flow flow) {
        Random r = RandomNumberProvider.getRandom();
        SUMOInstructionList<Trip> trips = new SUMOInstructionList<Trip>();
        int i = 0;
        while (i < flow.getNumberOfVehicles()) {
            int departureTime = flow.getBeginTime() + r.nextInt(flow.getEndTime() + 1 - flow.getBeginTime());
            String color = String.valueOf(new Float((float)flow.getColor().getRed() / 255.0f).toString()) + "," + new Float((float)flow.getColor().getGreen() / 255.0f).toString() + "," + new Float((float)flow.getColor().getBlue() / 255.0f).toString();
            trips.add(new Trip(departureTime, "<tripdef id=\"" + flow.getName() + "-" + String.valueOf(i) + "\" depart=\"" + String.valueOf(departureTime) + "\" from=\"" + flow.getStart().getId() + "\" to=\"" + flow.getEnd().getId() + "\" color=\"" + color + "\" type=\"" + flow.getVehicleSelection().getRandomType().getName() + "\" />\n"));
            ++i;
        }
        return trips;
    }

    private static SUMOInstructionList<Route> GenerateAccidentTraffic(Accident accident, RoadNetwork roadNetwork) throws Exception {
        SUMOInstructionList<Route> routes = new SUMOInstructionList<Route>();
        for (Pair<Lane, Boolean> affectedLane : accident.getAffectedLanes()) {
            Edge connectedEdge;
            if (!affectedLane.getSecond().booleanValue()) continue;
            String route = accident.getEdge().getId();
            if (affectedLane.getFirst().getConnectedEdges().size() > 0 && (connectedEdge = roadNetwork.findEdge(affectedLane.getFirst().getConnectedEdges().get(0))) != null) {
                route = String.valueOf(route) + " " + connectedEdge.getId();
            }
            routes.add(new Route(accident.getStartingTime(), "<vehicle id=\"Accident-" + accident.getName() + "-" + affectedLane.getFirst().getId() + "\" type=\"Default\" depart=\"" + String.valueOf(accident.getStartingTime()) + "\" color=\"1,0,0\">\n" + "     <route color=\"1,0,0\">" + route + "</route>\n" + "     <stop lane=\"" + affectedLane.getFirst().getId() + "\" pos=\"" + accident.getEdgeRelativeLocation() + "\" duration=\"" + String.valueOf(accident.getEndingTime() - accident.getStartingTime()) + "\"/>\n" + "</vehicle>\n"));
        }
        return routes;
    }

    private static SUMOInstructionList<Trip> GenerateAreaFlowTraffic(AreaFlow areaFlow, RoadNetwork roadNetwork) {
        Random r = RandomNumberProvider.getRandom();
        SUMOInstructionList<Trip> trips = new SUMOInstructionList<Trip>();
        List<Object> fromAreaEdges = new ArrayList();
        fromAreaEdges = roadNetwork.SelectEdges(areaFlow.getStartArea());
        int totalFromAreaEdges = fromAreaEdges.size();
        List<Object> toAreaEdges = new ArrayList();
        toAreaEdges = roadNetwork.SelectEdges(areaFlow.getEndArea());
        int totalToAreaEdges = toAreaEdges.size();
        if (totalToAreaEdges == 0 || totalFromAreaEdges == 0) {
            return null;
        }
        int i = 0;
        while (i < areaFlow.getNumberOfVehicles()) {
            Edge randomFromEdge = (Edge)fromAreaEdges.get(r.nextInt(totalFromAreaEdges));
            Edge randomToEdge = (Edge)toAreaEdges.get(r.nextInt(totalToAreaEdges));
            int departureTime = areaFlow.getBeginTime() + r.nextInt(areaFlow.getEndTime() + 1 - areaFlow.getBeginTime());
            String color = String.valueOf(new Float((float)areaFlow.getColor().getRed() / 255.0f).toString()) + "," + new Float((float)areaFlow.getColor().getGreen() / 255.0f).toString() + "," + new Float((float)areaFlow.getColor().getBlue() / 255.0f).toString();
            trips.add(new Trip(departureTime, "<tripdef id=\"" + areaFlow.getName() + "-" + String.valueOf(i) + "\" depart=\"" + String.valueOf(departureTime) + "\" from=\"" + randomFromEdge.getId() + "\" to=\"" + randomToEdge.getId() + "\" color=\"" + color + "\" type=\"" + areaFlow.getVehicleSelection().getRandomType().getName() + "\" />\n"));
            ++i;
        }
        return trips;
    }

    private static School FindClosestSchoolToLocation(List<School> schools, SchoolType type, Point2D.Double location) {
        School closestSchool = null;
        double minimumSchoolDistance = 3.4028234663852886E38;
        for (School school : schools) {
            double schoolDistance;
            if (school.getSchoolType() != type || school.getAvailableCapacity() <= 0 || !((schoolDistance = school.getLocation().distance(location)) < minimumSchoolDistance)) continue;
            minimumSchoolDistance = schoolDistance;
            closestSchool = school;
        }
        return closestSchool;
    }
}

