/*
 * Decompiled with CFR 0.152.
 */
package ui.propertypanels;

import classes.Project;
import classes.TypeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import simulation.VehicleType;
import trafficdefinition.Flow;
import ui.controls.SimTimeEdit;
import ui.dialogs.DlgSelectTypes;

public class PnlFlowProperties
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton btnChangeColor = null;
    private JButton btnSelectVehicleTypes = null;
    private Flow currentFlow = null;
    private JLabel lblBeginTimeTitle = null;
    private JLabel lblColorTitle = null;
    private JLabel lblEndTimeTitle = null;
    private JLabel lblFromTitle = null;
    private JLabel lblFromValue = null;
    private JLabel lblNameTitle = null;
    private JLabel lblNumberOfVehiclesTitle = null;
    private JLabel lblToTitle = null;
    private JLabel lblToValue = null;
    private JSpinner spnNumberOfVehicles = null;
    private JTextField txtName = null;
    private JCheckBox chkEnabled = null;
    private SimTimeEdit steBeginTime = null;
    private SimTimeEdit steEndTime = null;

    public PnlFlowProperties() {
        this.initialize();
    }

    public void setFlow(Flow flow) {
        this.currentFlow = flow;
        this.txtName.setText(this.currentFlow.getName());
        this.lblFromValue.setText(this.currentFlow.getStart().getId());
        this.lblToValue.setText(this.currentFlow.getEnd().getId());
        this.steBeginTime.setValue(this.currentFlow.getBeginTime());
        this.steEndTime.setValue(this.currentFlow.getEndTime());
        this.spnNumberOfVehicles.setValue(this.currentFlow.getNumberOfVehicles());
        this.btnChangeColor.setBackground(this.currentFlow.getColor());
        this.chkEnabled.setSelected(this.currentFlow.isEnabled());
    }

    private JButton getBtnChangeColor() {
        if (this.btnChangeColor == null) {
            this.btnChangeColor = new JButton();
            this.btnChangeColor.setText("");
            this.btnChangeColor.setPreferredSize(new Dimension(86, 20));
            this.btnChangeColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlFlowProperties.this.ChangeColor();
                }
            });
        }
        return this.btnChangeColor;
    }

    private JButton getBtnSelectVehicleTypes() {
        if (this.btnSelectVehicleTypes == null) {
            this.btnSelectVehicleTypes = new JButton();
            this.btnSelectVehicleTypes.setText("Vehicle types...");
            this.btnSelectVehicleTypes.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/vehicletypes.png")));
            this.btnSelectVehicleTypes.setPreferredSize(new Dimension(150, 20));
            this.btnSelectVehicleTypes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlFlowProperties.this.SelectVehicleTypes();
                }
            });
        }
        return this.btnSelectVehicleTypes;
    }

    private JSpinner getSpnNumberOfVehicles() {
        if (this.spnNumberOfVehicles == null) {
            this.spnNumberOfVehicles = new JSpinner();
            this.spnNumberOfVehicles.setPreferredSize(new Dimension(70, 20));
            this.spnNumberOfVehicles.setModel(new SpinnerNumberModel(1, 1, 1000000, 1));
            this.spnNumberOfVehicles.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlFlowProperties.this.currentFlow.setNumberOfVehicles((Integer)PnlFlowProperties.this.spnNumberOfVehicles.getValue());
                }
            });
        }
        return this.spnNumberOfVehicles;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
            this.txtName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    PnlFlowProperties.this.currentFlow.setName(PnlFlowProperties.this.txtName.getText());
                }
            });
        }
        return this.txtName;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.gridy = 4;
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.gridx = 1;
        gridBagConstraints15.gridy = 3;
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = 1;
        gridBagConstraints14.anchor = 17;
        gridBagConstraints14.gridy = 7;
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.gridx = 1;
        gridBagConstraints22.anchor = 17;
        gridBagConstraints22.gridy = 5;
        GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
        gridBagConstraints23.gridx = 1;
        gridBagConstraints23.fill = 1;
        gridBagConstraints23.insets = new Insets(2, 0, 2, 10);
        gridBagConstraints23.gridy = 6;
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.anchor = 11;
        gridBagConstraints13.insets = new Insets(15, 2, 2, 2);
        gridBagConstraints13.weighty = 1.0;
        gridBagConstraints13.gridwidth = 2;
        gridBagConstraints13.gridy = 8;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.insets = new Insets(0, 10, 0, 5);
        gridBagConstraints12.anchor = 17;
        gridBagConstraints12.gridy = 5;
        this.lblNumberOfVehiclesTitle = new JLabel();
        this.lblNumberOfVehiclesTitle.setText("Number of vehicles:");
        GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
        gridBagConstraints51.gridx = 0;
        gridBagConstraints51.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints51.anchor = 17;
        gridBagConstraints51.gridy = 6;
        this.lblColorTitle = new JLabel();
        this.lblColorTitle.setText("Color:");
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.gridx = 0;
        gridBagConstraints31.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints31.anchor = 17;
        gridBagConstraints31.gridy = 4;
        this.lblEndTimeTitle = new JLabel();
        this.lblEndTimeTitle.setText("End time:");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.gridy = 3;
        this.lblBeginTimeTitle = new JLabel();
        this.lblBeginTimeTitle.setText("Begin time:");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints5.gridy = 2;
        this.lblToValue = new JLabel();
        this.lblToValue.setText("To");
        this.lblToValue.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridy = 2;
        this.lblToTitle = new JLabel();
        this.lblToTitle.setText("To:");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints3.gridy = 1;
        this.lblFromValue = new JLabel();
        this.lblFromValue.setText("From");
        this.lblFromValue.setDisplayedMnemonic(0);
        this.lblFromValue.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridy = 1;
        this.lblFromTitle = new JLabel();
        this.lblFromTitle.setText("From:");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        this.lblNameTitle = new JLabel();
        this.lblNameTitle.setText("Name:");
        this.setSize(300, 214);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblNameTitle, gridBagConstraints);
        this.add((Component)this.getTxtName(), gridBagConstraints1);
        this.add((Component)this.lblFromTitle, gridBagConstraints2);
        this.add((Component)this.lblFromValue, gridBagConstraints3);
        this.add((Component)this.lblToTitle, gridBagConstraints4);
        this.add((Component)this.lblToValue, gridBagConstraints5);
        this.add((Component)this.lblBeginTimeTitle, gridBagConstraints11);
        this.add((Component)this.lblEndTimeTitle, gridBagConstraints31);
        this.add((Component)this.lblColorTitle, gridBagConstraints51);
        this.add((Component)this.lblNumberOfVehiclesTitle, gridBagConstraints12);
        this.add((Component)this.getBtnSelectVehicleTypes(), gridBagConstraints13);
        this.add((Component)this.getBtnChangeColor(), gridBagConstraints23);
        this.add((Component)this.getSpnNumberOfVehicles(), gridBagConstraints22);
        this.add((Component)this.getChkEnabled(), gridBagConstraints14);
        this.add((Component)this.getSteBeginTime(), gridBagConstraints15);
        this.add((Component)this.getSteEndTime(), gridBagConstraints21);
    }

    protected void ChangeColor() {
        Color newColor = JColorChooser.showDialog(this, "Select flow color", this.currentFlow.getColor());
        if (newColor != null) {
            this.currentFlow.setColor(newColor);
            this.btnChangeColor.setBackground(newColor);
        }
    }

    protected void SelectVehicleTypes() {
        TypeSelection<VehicleType> projectVehicleTypes = new TypeSelection<VehicleType>(Project.getCurrentlyLoadedProject().getVehicleTypes());
        TypeSelection<VehicleType> flowVehicleTypes = new TypeSelection<VehicleType>(this.currentFlow.getVehicleSelection());
        flowVehicleTypes.addTypesNotInSelection(projectVehicleTypes);
        DlgSelectTypes<VehicleType> dlg = new DlgSelectTypes<VehicleType>(flowVehicleTypes);
        dlg.setVisible(true);
        if (dlg.getAnswer() == 0) {
            flowVehicleTypes.removeTypesWithZeroPercentage();
            this.currentFlow.setVehicleSelection(flowVehicleTypes);
        }
    }

    private JCheckBox getChkEnabled() {
        if (this.chkEnabled == null) {
            this.chkEnabled = new JCheckBox();
            this.chkEnabled.setText("Enabled");
            this.chkEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlFlowProperties.this.currentFlow.setEnabled(PnlFlowProperties.this.chkEnabled.isSelected());
                }
            });
        }
        return this.chkEnabled;
    }

    private SimTimeEdit getSteBeginTime() {
        if (this.steBeginTime == null) {
            this.steBeginTime = new SimTimeEdit();
            this.steBeginTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlFlowProperties.this.currentFlow.setBeginTime(PnlFlowProperties.this.steBeginTime.getValue());
                }
            });
        }
        return this.steBeginTime;
    }

    private SimTimeEdit getSteEndTime() {
        if (this.steEndTime == null) {
            this.steEndTime = new SimTimeEdit();
            this.steEndTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlFlowProperties.this.currentFlow.setEndTime(PnlFlowProperties.this.steEndTime.getValue());
                }
            });
        }
        return this.steEndTime;
    }
}

