/*
 *  $Id: uimconfig.c 9 2004-02-06 06:24:52Z omote $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "siod.h"
#include "uimconfig.h"

extern LISP sym_t;
int sumika_siod_fatal;

int  init_uim_config(struct _uim_config *config);
void free_uim_config(struct _uim_config *config);
static void read_uim_config_global (struct _uim_config_global *config);
static void read_uim_config_canna  (struct _uim_config_canna  *config);
static void read_uim_config_skk	   (struct _uim_config_skk    *config);
static void free_uim_config_global (struct _uim_config_global *config);
static void free_uim_config_canna  (struct _uim_config_canna  *config);
static void free_uim_config_skk	   (struct _uim_config_skk    *config);

static void exit_hook(void)
{
    sumika_siod_fatal = 1;
}

static LISP sumika_symbol_value(const char *symbol_str)
{
    LISP symbol_str_ = rintern(symbol_str);

    if(symbol_boundp(symbol_str_, NIL) == sym_t) {
	return symbol_value(symbol_str_, NIL);
    } else {
	return NIL;
   }
}

static char *sumika_symbol_value_str(const char *symbol_str)
{
    LISP val_;
    char *val;
    val_ = sumika_symbol_value(symbol_str);

    if( val_ != NIL) {
	val = sumika_get_c_string(val_);
    } else {
	val = NULL;
    }
    return val;
}

char *sumika_get_c_string(LISP str)
{
    char *s;
    long len;
    char *buf;
    s = get_c_string_dim(str, &len);
    buf = (char *)malloc(sizeof(char)*(len + 1));
    strncpy(buf, s, len);
    buf[len] = '\0';
    return buf;
}

int init_uim_config(struct _uim_config *config)
{
    struct passwd *pw;
    char fn[1024];
    struct stat stat;
    struct _uim_config_global *conf_global;
    struct _uim_config_skk    *conf_skk;
    struct _uim_config_canna  *conf_canna;
    char *siod_argv[] =
    {
	"siod",
	"-h100000:10",
	"-o1000",
	"-s200000",
	"-n128",
	"-v0",
    };
/*    char verbose_argv[4] = "-v4"; */

    conf_global = &(config->global);
    conf_skk	= &(config->skk);
    conf_canna	= &(config->canna);

    pw = getpwuid(getuid());
    snprintf(fn, sizeof(fn), "%s/.uim", pw->pw_dir);

    if(lstat(fn, &stat) == -1)
	return -1;

    siod_init (6, siod_argv, 1, stderr);
    set_fatal_exit_hook(exit_hook);

    vload(fn, 0, 1);

    read_uim_config_global(conf_global);
/*    read_uim_config_anthy(); */
/*    read_uim_config_prime(); */
    read_uim_config_skk(conf_skk);
    read_uim_config_canna(conf_canna);

    return 0;
}

void free_uim_config(struct _uim_config *config)
{
    free_uim_config_global(&(config->global));
/*    free_uim_config_anthy(&(config->anthy)); */
/*    free_uim_config_prime(&(config->prime)); */
    free_uim_config_canna(&(config->canna));
    free_uim_config_skk(&(config->skk));
}

static void read_uim_config_global(struct _uim_config_global *config)
{
    LISP val_;

    config->default_im = sumika_symbol_value_str("default-im-name");
    config->cand_win_pos = sumika_symbol_value_str("candidate-window-position");

    val_ = sumika_symbol_value("enable-im-switch");
    if(val_ == NIL)
	config->enable_im_switch = 0;
    else
	config->enable_im_switch = 1;
}

static void free_uim_config_global(struct _uim_config_global *config)
{
    if(config->default_im != NULL)
	free(config->default_im);
    if(config->cand_win_pos != NULL)
	free(config->cand_win_pos);
}

static void read_uim_config_skk(struct _uim_config_skk *config)
{
    LISP val_;
    char *val;

    val_ = sumika_symbol_value("skk-use-recursive-learning?");
    if(val_ == NIL)
	config->recursive_learning = 0;
    else
	config->recursive_learning = 1;

    val = sumika_symbol_value_str("skk-style");
    if(val != NULL && strcmp(val, "skk-style-ddskk-like") == 0) {
	config->skk_style = strdup("ddskk");
	free(val);
    }
    else if(val != NULL && strcmp(val, "skk-style-uim") == 0) {
	config->skk_style = strdup("uim");
	free(val);
    }
    else
	config->skk_style = strdup("ddskk");


    config->skk_dic_filename = sumika_symbol_value_str("skk-dic-file-name");
    config->skk_userdic_filename = sumika_symbol_value_str("skk-personal-dic-filename");
    config->skk_uim_userdic_filename = sumika_symbol_value_str("skk-uim-personal-dic-filename");
}

static void free_uim_config_skk(struct _uim_config_skk *config)
{
    if(config->skk_dic_filename != NULL)
	free(config->skk_dic_filename);
    if(config->skk_userdic_filename != NULL)
	free(config->skk_userdic_filename);
    if(config->skk_uim_userdic_filename != NULL)
	free(config->skk_uim_userdic_filename);
    if(config->skk_style != NULL)
	free(config->skk_style);
}

static void read_uim_config_canna(struct _uim_config_canna *config)
{
    config->cannaserver = sumika_symbol_value_str("canna-server-name");
}

static void free_uim_config_canna(struct _uim_config_canna *config)
{
    if(config->cannaserver != NULL)
	free(config->cannaserver);
}

int write_uim_config(struct _uim_config *config)
{
    FILE *fp;
    char fn[1024];
    struct stat st;
    struct passwd *pw;

    pw = getpwuid(getuid());
    snprintf(fn, sizeof(fn), "%s/.uim", pw->pw_dir);

    fp = fopen(fn, "w");

    if(fp == NULL)
	return -1;

    /* global */
    if((config->global).default_im != NULL &&
       strcmp((config->global).default_im, "Anthy") == 0)
    {
	fprintf(fp, "(define default-im-name 'anthy)\n");
    }
    else if((config->global).default_im != NULL &&
	    strcmp((config->global).default_im, "Canna") == 0)
    {
	fprintf(fp, "(define default-im-name 'canna)\n");
    }
    else if((config->global).default_im != NULL &&
	    strcmp((config->global).default_im, "PRIME") == 0)
    {
	fprintf(fp, "(define default-im-name 'prime)\n");
    }
    else if((config->global).default_im != NULL &&
	    strcmp((config->global).default_im, "T-Code") == 0)
    {
	fprintf(fp, "(define default-im-name 'tcode)\n");
    }
    else if((config->global).default_im != NULL &&
	    strcmp((config->global).default_im, "TUT-Code") == 0)
    {
	fprintf(fp, "(define default-im-name 'tutcode)\n");
    }

    if((config->global).enable_im_switch == 1)
	fprintf(fp, "(define enable-im-switch #t)\n");
    else
	fprintf(fp, "(define enable-im-switch #f)\n");

    if((config->global).cand_win_pos != NULL)
	fprintf(fp, "(define candidate-window-position \"%s\"\n)",
		(config->global).cand_win_pos);

    /* canna */
    if((config->canna).cannaserver != NULL && (config->canna).cannaserver[0] != '\0')
	fprintf(fp, "(define canna-server-name \"%s\"\n", (config->canna).cannaserver);

    /* skk */
    if((config->skk).skk_dic_filename != NULL &&
       (config->skk).skk_dic_filename[0] != '\0')
	fprintf(fp, "(define skk-dic-file-name \"%s\"\n", (config->skk).skk_dic_filename);

    if((config->skk).skk_userdic_filename != NULL &&
       (config->skk).skk_userdic_filename[0] != '\0')
    {
	fprintf(fp, "(define skk-personal-dic-filename \"%s\"\n",
		(config->skk).skk_userdic_filename);
    }

    if((config->skk).skk_uim_userdic_filename != NULL &&
       (config->skk).skk_uim_userdic_filename[0] != '\0')
    {
	fprintf(fp, "(define skk-uim-presonal-dic-filename \"%s\"\n",
		(config->skk).skk_uim_userdic_filename);
    }

    if((config->skk).recursive_learning == 1)
	fprintf(fp, "(define skk-use-recursive-learning? #t)\n");
    else if ((config->skk).recursive_learning == 0)
	fprintf(fp, "(define skk-use-recursive-learning? #f)\n");

    if((config->skk).skk_style != NULL &&
       strcmp((config->skk).skk_style, "ddskk") == 0)
    {
	fprintf(fp,"(define skk-style 'skk-style-ddskk-like)\n");
    } else if ((config->skk).skk_style != NULL &&
	       strcmp((config->skk).skk_style, "uim") == 0)
    {
	fprintf(fp,"(define skk-style 'skk-style-uim)\n");
    }
    fclose(fp);
    return 0;
}
