/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "DebugSettingsInfo.h"
#include "DebugSettingsWidget.h"
#include "DebugSettings.h"
#include "Utility.h"


DebugSettingsInfo::DebugSettingsInfo( const QString& title, const QString& id,
  DebugSettings* dbg, int sortIndex ) : _title(title), _id(id), _dbg(dbg),
  _sortIndex(sortIndex)
{
  _log  = _dbg->getLog();
  _l10n = _dbg->getL10n();
}

DebugSettingsInfo::~DebugSettingsInfo()
{
}

const QString& DebugSettingsInfo::getTitle()
{
  return _title;
}

const QString& DebugSettingsInfo::getSettingsId()
{
  return _id;
}

void DebugSettingsInfo::initWidgetData( SettingsWidget* sw )
{
  DebugSettingsWidget* dsw = dynamic_cast<DebugSettingsWidget*>(sw);
  dsw->setLog(_log);
  dsw->setL10n(_l10n);
}

void DebugSettingsInfo::storeWidgetData( SettingsWidget* sw )
{
  DebugSettingsWidget* dsw = dynamic_cast<DebugSettingsWidget*>(sw);
  _log  = dsw->getLog();
  _l10n = dsw->getL10n();
}

bool DebugSettingsInfo::isModified()
{
  return (_dbg->getLog()  != _log)
    ||   (_dbg->getL10n() != _l10n);
}

void DebugSettingsInfo::ok()
{
  apply();
}

void DebugSettingsInfo::apply()
{
  _dbg->setLog(_log);
  _dbg->setL10n(_l10n);
}

void DebugSettingsInfo::cancel()
{
  // do nothing
}

int DebugSettingsInfo::getSortIndex()
{
  return _sortIndex;
}
