/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _ASSERTIONTRAIT_STRING_H
#define _ASSERTIONTRAIT_STRING_H

// sc
#include "util/String.h"

CPPUNIT_NS_BEGIN

/** This adds sc::String support to CPPUNIT_ASSERT_EQUALS. */
template<> struct /*CPPUNIT_NS::*/assertion_traits<sc::String>
{
  static bool equal( const sc::String& x, const sc::String& y )
  {
    return x == y;
  }

  static std::string toString( const sc::String& x )
  {
    std::string text = '"' + (!x.isEmpty() ? std::string(x) : "<null>") + '"';
    OStringStream ost;
    ost << text;
    return ost.str();
  }
};

CPPUNIT_NS_END

#endif // _ASSERTIONTRAIT_STRING_H
