/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "PropSetRevCmd.h"
#include "PropSetRevParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"
#include "util/Error.h"


PropSetRevCmd::PropSetRevCmd( PropSetRevParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

PropSetRevCmd::~PropSetRevCmd()
{
}

void PropSetRevCmd::run()
{
  sc::Error* err;

  _prgscb->started( getId(), _param, getCancel() );

  err = _client->propsetrev( _param->getPropName(), _param->getPropVal(),
    _param->getPathOrUrl(), *_param->getRevision(), &_param->getRevnumber(),
    _param->getForce() );

  _param->setError( err );
  _prgscb->finished( getId(), _param );

  _cb->handleResult( _param, err );
}
