/* ====================================================================
 * Copyright (c) 2008                    Martin Hauner
 *                                       http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _WCVIEWSTATUS_H
#define _WCVIEWSTATUS_H

// sc
#include "WcViewItem.h"
#include "svn/WcStatusTypes.h"

// qt
#include <QtCore/QVariant>


/** WcViewTreeModel item implementation for svn::WcStatus objects. */
class WcViewStatus : public WcViewItem
{
public:
  WcViewStatus( svn::WcStatusPtr status );

  svn::WcStatusPtr status() const;

  // WcViewItem
  bool isDir() const;
  const sc::String& path() const;

private:
  svn::WcStatusPtr _status;
};


/** WcViewItemData implemetation for WcViewStatus items. */
class WcViewStatusData : public WcViewItemData
{
public:
  WcViewStatusData();

  /* WcViewItem overwrites. */
  QString data( int column, const WcViewItem* ) const;
  QColor color( int column, const WcViewItem* ) const;
  QString header( int column ) const;
  Qt::Alignment alignment( int column ) const;
  int columns() const;
  bool deep( int column ) const;
};

#endif //  _WCVIEWSTATUS_H
