/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "PostCmdResult.h"
#include "ErrorSupport.h"
#include "commands/ScParam.h"
#include "events/ScParamEvent.h"
#include "events/LoggingEvent.h"
#include "events/EventSupport.h"
#include "sublib/TargetId.h"
#include "sublib/TargetRepository.h"
#include "util/Error.h"

// svn
#include "svn_error_codes.h"

// qt
#include <QtGui/QApplication>


PostCmdResult::PostCmdResult( ID tid )
: _tid(tid)
{
}

PostCmdResult::PostCmdResult( QObject* o )
: _tid(TargetId::getTid(o))
{
}

void PostCmdResult::handleResult( ScParam* param, const sc::Error* error )
{
  if( error != sc::Success && error->getCode() != SVN_ERR_CANCELLED )
  {
    handleError( error );
  }

  QObject* target = TargetRepository::get(_tid);
  if( target )
  {
    postEvent( target, new ScParamEvent(param, error) );
  }
  else
  {
    delete param;
    delete error;
  }
}
