echo off

rem setup environment and run visual studio.

rem basic environment setup:
call "c:\Program Files\Microsoft Visual Studio 9.0\VC\bin\vcvars32.bat"


rem edit INCLUDE,LIB, LIBPATH_DEBUG/RELEASE paths to include all Subcommander
rem dependencies: boost, apr, apr-util, intl, neon, openssl, Qt4, cppunit

rem *************************************************************************
set BUILD_ROOT=c:\Development

set APR_ROOT=%BUILD_ROOT%\apr-1.2.12
set INTL_ROOT=%BUILD_ROOT%\intl-0.17.0
set BOOST_ROOT=%BUILD_ROOT%\boost-1.34.1

set SVN_ROOT=%BUILD_ROOT%\Subversion-1.5.1
set SVN_ROOT_DEBUG=%SVN_ROOT%\Debug\subversion
set SVN_ROOT_RELEASE=%SVN_ROOT%\Release\subversion

set QT_ROOT=%BUILD_ROOT%\qt-win-opensource-src-4.4.0
set SSL_ROOT=%BUILD_ROOT%\openssl-0.9.8g
set NEON_ROOT=%BUILD_ROOT%\neon-0.27.2
set CPPUNIT_ROOT=%BUILD_ROOT%\cppunit-1.12.0

set GTEST_ROOT=%BUILD_ROOT%\gtest-1.0.0
rem *************************************************************************

rem extend path
set PATH=%QT_ROOT%\bin;%PATH%


rem set INCLUDE=..;%INCLUDE%
set INCLUDE=%APR_ROOT%\apr\include;%INCLUDE%
set INCLUDE=%APR_ROOT%\apr-util\include;%INCLUDE%
set INCLUDE=%APR_ROOT%\apr-iconv\include;%INCLUDE%
set INCLUDE=%INTL_ROOT%\include;%INCLUDE%
set INCLUDE=%BOOST_ROOT%;%INCLUDE%
set INCLUDE=%SVN_ROOT%\subversion\include;%INCLUDE%
set INCLUDE=%QT_ROOT%\include;%INCLUDE%
set INCLUDE=%SSL_ROOT%\inc32;%INCLUDE%
set INCLUDE=%NEON_ROOT%;%INCLUDE%
set INCLUDE=%CPPUNIT_ROOT%\include;%INCLUDE%
set INCLUDE=%GTEST_ROOT%\include;%INCLUDE%

rem add library paths to libraries with different names for Debug & Release
set LIB=%QT_ROOT%\lib;%LIB%
set LIB=%INTL_ROOT%\lib;%LIB%
set LIB=%NEON_ROOT%;%LIB%
set LIB=%CPPUNIT_ROOT%\lib;%LIB%
set LIB=%GTEST_ROOT%\lib;%LIB%

rem Debug library paths to libraries with identical names for Debug & Release
set LIBPATH_DEBUG=%APR_ROOT%\apr\Debug;%LIBPATH_DEBUG%
set LIBPATH_DEBUG=%APR_ROOT%\apr-util\Debug;%LIBPATH_DEBUG%
set LIBPATH_DEBUG=%APR_ROOT%\apr-util\xml\expat\lib\LibD;%LIBPATH_DEBUG%
set LIBPATH_DEBUG=%APR_ROOT%\apr-iconv\Debug;%LIBPATH_DEBUG%

set LIBPATH_DEBUG=%SVN_ROOT_DEBUG%\libsvn_subr;%LIBPATH_DEBUG%
set LIBPATH_DEBUG=%SVN_ROOT_DEBUG%\libsvn_wc;%LIBPATH_DEBUG%
set LIBPATH_DEBUG=%SVN_ROOT_DEBUG%\libsvn_ra;%LIBPATH_DEBUG%
set LIBPATH_DEBUG=%SVN_ROOT_DEBUG%\libsvn_fs;%LIBPATH_DEBUG%
set LIBPATH_DEBUG=%SVN_ROOT_DEBUG%\libsvn_diff;%LIBPATH_DEBUG%
set LIBPATH_DEBUG=%SVN_ROOT_DEBUG%\libsvn_delta;%LIBPATH_DEBUG%
set LIBPATH_DEBUG=%SVN_ROOT_DEBUG%\libsvn_repos;%LIBPATH_DEBUG%
set LIBPATH_DEBUG=%SVN_ROOT_DEBUG%\libsvn_client;%LIBPATH_DEBUG%


rem Release library paths to libraries with identical names for Debug & Release
set LIBPATH_RELEASE=%APR_ROOT%\apr\Release;%LIBPATH_RELEASE%
set LIBPATH_RELEASE=%APR_ROOT%\apr-util\Release;%LIBPATH_RELEASE%
set LIBPATH_RELEASE=%APR_ROOT%\apr-util\xml\expat\lib\LibR;%LIBPATH_RELEASE%
set LIBPATH_RELEASE=%APR_ROOT%\apr-iconv\Release;%LIBPATH_RELEASE%

set LIBPATH_RELEASE=%SVN_ROOT_RELEASE%\libsvn_subr;%LIBPATH_RELEASE%
set LIBPATH_RELEASE=%SVN_ROOT_RELEASE%\libsvn_wc;%LIBPATH_RELEASE%
set LIBPATH_RELEASE=%SVN_ROOT_RELEASE%\libsvn_ra;%LIBPATH_RELEASE%
set LIBPATH_RELEASE=%SVN_ROOT_RELEASE%\libsvn_fs;%LIBPATH_RELEASE%
set LIBPATH_RELEASE=%SVN_ROOT_RELEASE%\libsvn_diff;%LIBPATH_RELEASE%
set LIBPATH_RELEASE=%SVN_ROOT_RELEASE%\libsvn_delta;%LIBPATH_RELEASE%
set LIBPATH_RELEASE=%SVN_ROOT_RELEASE%\libsvn_repos;%LIBPATH_RELEASE%
set LIBPATH_RELEASE=%SVN_ROOT_RELEASE%\libsvn_client;%LIBPATH_RELEASE%


rem copy dependency libaries (if newer) to binary folders
set DBG_BIN=bin\Debug
set REL_BIN=bin\Release

xcopy /Y /D %APR_ROOT%\apr\Debug\libapr-1.dll %DBG_BIN%
xcopy /Y /D %APR_ROOT%\apr\Debug\libapr-1.pdb %DBG_BIN%
xcopy /Y /D %APR_ROOT%\apr-util\Debug\libaprutil-1.dll %DBG_BIN%
xcopy /Y /D %APR_ROOT%\apr-util\Debug\libaprutil-1.pdb %DBG_BIN%
xcopy /Y /D %APR_ROOT%\apr-iconv\Debug\libapriconv-1.dll %DBG_BIN%
xcopy /Y /D %APR_ROOT%\apr-iconv\Debug\libapriconv-1.pdb %DBG_BIN%
xcopy /Y /D %APR_ROOT%\apr-iconv\Debug\iconv\*.so  %DBG_BIN%\iconv
xcopy /Y /D %APR_ROOT%\apr-iconv\Debug\iconv\*.pdb %DBG_BIN%\iconv

xcopy /Y /D %APR_ROOT%\apr\Release\libapr-1.dll %REL_BIN%
xcopy /Y /D %APR_ROOT%\apr\Release\libapr-1.pdb %REL_BIN%
xcopy /Y /D %APR_ROOT%\apr-util\Release\libaprutil-1.dll %REL_BIN%
xcopy /Y /D %APR_ROOT%\apr-util\Release\libaprutil-1.pdb %REL_BIN%
xcopy /Y /D %APR_ROOT%\apr-iconv\Release\libapriconv-1.dll %REL_BIN%
xcopy /Y /D %APR_ROOT%\apr-iconv\Release\libapriconv-1.pdb %REL_BIN%
xcopy /Y /D %APR_ROOT%\apr-iconv\Release\iconv\*.so  %REL_BIN%\iconv
xcopy /Y /D %APR_ROOT%\apr-iconv\Release\iconv\*.pdb %REL_BIN%\iconv

xcopy /Y /D %INTL_ROOT%\bin\intl3_svnd.dll %DBG_BIN%
xcopy /Y /D %INTL_ROOT%\bin\intl3_svndd.pdb %DBG_BIN%
xcopy /Y /D %INTL_ROOT%\bin\intl3_svn.dll %REL_BIN%
xcopy /Y /D %INTL_ROOT%\bin\intl3_svn.pdb %REL_BIN%

xcopy /Y /D %SSL_ROOT%\out32dll.dbg\libeay32.dll %DBG_BIN%
xcopy /Y /D %SSL_ROOT%\out32dll.dbg\ssleay32.dll %DBG_BIN%
xcopy /Y /D %SSL_ROOT%\out32dll\libeay32.dll %REL_BIN%
xcopy /Y /D %SSL_ROOT%\out32dll\ssleay32.dll %REL_BIN%

xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_subr\libsvn_subr-1.dll %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_subr\libsvn_subr-1.pdb %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_wc\libsvn_wc-1.dll %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_wc\libsvn_wc-1.pdb %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_ra\libsvn_ra-1.dll %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_ra\libsvn_ra-1.pdb %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_fs\libsvn_fs-1.dll %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_fs\libsvn_fs-1.pdb %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_diff\libsvn_diff-1.dll %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_diff\libsvn_diff-1.pdb %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_delta\libsvn_delta-1.dll %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_delta\libsvn_delta-1.pdb %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_repos\libsvn_repos-1.dll %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_repos\libsvn_repos-1.pdb %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_client\libsvn_client-1.dll %DBG_BIN%
xcopy /Y /D %SVN_ROOT_DEBUG%\libsvn_client\libsvn_client-1.pdb %DBG_BIN%

xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_subr\libsvn_subr-1.dll %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_subr\libsvn_subr-1.pdb %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_wc\libsvn_wc-1.dll %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_wc\libsvn_wc-1.pdb %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_ra\libsvn_ra-1.dll %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_ra\libsvn_ra-1.pdb %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_fs\libsvn_fs-1.dll %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_fs\libsvn_fs-1.pdb %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_diff\libsvn_diff-1.dll %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_diff\libsvn_diff-1.pdb %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_delta\libsvn_delta-1.dll %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_delta\libsvn_delta-1.pdb %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_repos\libsvn_repos-1.dll %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_repos\libsvn_repos-1.pdb %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_client\libsvn_client-1.dll %REL_BIN%
xcopy /Y /D %SVN_ROOT_RELEASE%\libsvn_client\libsvn_client-1.pdb %REL_BIN%

xcopy /Y /D %QT_ROOT%\lib\Qt3Supportd4.dll %DBG_BIN%
xcopy /Y /D %QT_ROOT%\lib\QtCored4.dll %DBG_BIN%
xcopy /Y /D %QT_ROOT%\lib\QtGuid4.dll %DBG_BIN%
xcopy /Y /D %QT_ROOT%\lib\QtNetworkd4.dll %DBG_BIN%
xcopy /Y /D %QT_ROOT%\lib\QtSqld4.dll %DBG_BIN%
xcopy /Y /D %QT_ROOT%\lib\QtXmld4.dll %DBG_BIN%

xcopy /Y /D %QT_ROOT%\plugins\accessible\qtaccessiblecompatwidgetsd4.dll %DBG_BIN%\plugins\accessible\
xcopy /Y /D %QT_ROOT%\plugins\accessible\qtaccessiblewidgetsd4.dll %DBG_BIN%\plugins\accessible\
xcopy /Y /D %QT_ROOT%\plugins\codecs\qcncodecsd4.dll %DBG_BIN%\plugins\codecs\
xcopy /Y /D %QT_ROOT%\plugins\codecs\qjpcodecsd4.dll %DBG_BIN%\plugins\codecs\
xcopy /Y /D %QT_ROOT%\plugins\codecs\qkrcodecsd4.dll %DBG_BIN%\plugins\codecs\
xcopy /Y /D %QT_ROOT%\plugins\codecs\qtwcodecsd4.dll %DBG_BIN%\plugins\codecs\
xcopy /Y /D %QT_ROOT%\plugins\iconengines\qsvgicond4.dll %DBG_BIN%\plugins\iconengines\
xcopy /Y /D %QT_ROOT%\plugins\imageformats\qgifd4.dll %DBG_BIN%\plugins\imageformats\
xcopy /Y /D %QT_ROOT%\plugins\imageformats\qicod4.dll %DBG_BIN%\plugins\imageformats\
xcopy /Y /D %QT_ROOT%\plugins\imageformats\qjpegd4.dll %DBG_BIN%\plugins\imageformats\
xcopy /Y /D %QT_ROOT%\plugins\imageformats\qmngd4.dll %DBG_BIN%\plugins\imageformats\
xcopy /Y /D %QT_ROOT%\plugins\imageformats\qsvgd4.dll %DBG_BIN%\plugins\imageformats\
xcopy /Y /D %QT_ROOT%\plugins\imageformats\qtiffd4.dll %DBG_BIN%\plugins\imageformats\
xcopy /Y /D %QT_ROOT%\plugins\sqldrivers\qsqlited4.dll %DBG_BIN%\plugins\sqldrivers\

xcopy /Y /D %QT_ROOT%\lib\Qt3Support4.dll %REL_BIN%
xcopy /Y /D %QT_ROOT%\lib\QtCore4.dll %REL_BIN%
xcopy /Y /D %QT_ROOT%\lib\QtGui4.dll %REL_BIN%
xcopy /Y /D %QT_ROOT%\lib\QtNetwork4.dll %REL_BIN%
xcopy /Y /D %QT_ROOT%\lib\QtSql4.dll %REL_BIN%
xcopy /Y /D %QT_ROOT%\lib\QtXml4.dll %REL_BIN%

xcopy /Y /D %QT_ROOT%\plugins\accessible\qtaccessiblecompatwidgets4.dll %REL_BIN%\plugins\accessible\
xcopy /Y /D %QT_ROOT%\plugins\accessible\qtaccessiblewidgets4.dll %REL_BIN%\plugins\accessible\
xcopy /Y /D %QT_ROOT%\plugins\codecs\qcncodecs4.dll %REL_BIN%\plugins\codecs\
xcopy /Y /D %QT_ROOT%\plugins\codecs\qjpcodecs4.dll %REL_BIN%\plugins\codecs\
xcopy /Y /D %QT_ROOT%\plugins\codecs\qkrcodecs4.dll %REL_BIN%\plugins\codecs\
xcopy /Y /D %QT_ROOT%\plugins\codecs\qtwcodecs4.dll %REL_BIN%\plugins\codecs\
xcopy /Y /D %QT_ROOT%\plugins\iconengines\qsvgicon4.dll %REL_BIN%\plugins\iconengines\
xcopy /Y /D %QT_ROOT%\plugins\imageformats\qgif4.dll %REL_BIN%\plugins\imageformats\
xcopy /Y /D %QT_ROOT%\plugins\imageformats\qico4.dll %REL_BIN%\plugins\imageformats\
xcopy /Y /D %QT_ROOT%\plugins\imageformats\qjpeg4.dll %REL_BIN%\plugins\imageformats\
xcopy /Y /D %QT_ROOT%\plugins\imageformats\qmng4.dll %REL_BIN%\plugins\imageformats\
xcopy /Y /D %QT_ROOT%\plugins\imageformats\qsvg4.dll %REL_BIN%\plugins\imageformats\
xcopy /Y /D %QT_ROOT%\plugins\imageformats\qtiff4.dll %REL_BIN%\plugins\imageformats\
xcopy /Y /D %QT_ROOT%\plugins\sqldrivers\qsqlite4.dll %REL_BIN%\plugins\sqldrivers\

rem finally run visual studio and tell it to use the set
rem environment.

start vcexpress /useenv sc.sln

pause
