/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "TextEdit.h"

// qt
#include <qpainter.h>



TextEdit::TextEdit( QWidget *parent, const char *name )
: QTextEdit(parent,name)
{
  viewport()->installEventFilter( this );
}

TextEdit::~TextEdit()
{
}


bool TextEdit::eventFilter( QObject *obj, QEvent *ev )
{
  // this is a hack to draw the right column marker and to emit
  // the current cursor position.

  // better solutions are welcome..

  bool res = super::eventFilter( obj, ev );

  if(   ev->type() == QEvent::Paint
     || ev->type() == QEvent::KeyRelease
     || ev->type() == QEvent::KeyPress
     || ev->type() == QEvent::MouseButtonPress
     || ev->type() == QEvent::MouseButtonRelease
    )
  {
    QPainter p( viewport() );

    QFontMetrics m(font());
    QRect        pr(viewport()->rect());

    int dashX = m.width('M') * 72 + m.width('M')/2 + 1 - contentsX(); 

    p.setPen( QColor(230,230,230) );
    p.drawLine( dashX, pr.y(), dashX, pr.y()+pr.height() );

    p.setPen( QColor(150,150,150) );
    for( int d = pr.y()+(0 + pr.y())%2; d < pr.y()+pr.height(); d+=2 )
    {
      p.drawPoint( dashX, d );
    }

    int x, y;
    getCursorPosition( &y, &x );
    emit cursorChanged(x,y);
  }

  return res;
}




#if 0
void TextEdit::drawContents( QPainter* p, int clipx, int clipy, int clipw, int cliph )
{
  super::drawContents(p,clipx,clipy,clipw,cliph);

  QFontMetrics m(font());
  QRect        pr(clipx,clipy,clipw,cliph);

  int dashX = m.width('M') * 40 + m.width('M')/2 + 1; 

  p->setPen( QColor(230,230,230) );
  p->drawLine( dashX, pr.y(), dashX, pr.y()+pr.height() );

  p->setPen( QColor(150,150,150) );
  for( int d = pr.y()+(0 + pr.y())%2; d < pr.y()+pr.height(); d+=2 )
  {
    p->drawPoint( dashX, d );
  }

  printf("drawContents %d %d %d %d\n",clipx,clipy,clipw,cliph);
}
#endif

