module overlay-test
imports sunit

signature
  sorts AsFixTerm
  constructors
    layout : Sort
    lit    : String -> Sort
    sort   : String -> Sort
    lex    : Sort -> Sort

    prod   : List(Sort) * Sort * List(Attr) -> Prod

    appl   : Prod * List(AsFixTerm) -> AsFixTerm

overlays

  DefaultLayout = " "

  BinOp(o) = 
    prod([sort("E"), layout, lit(o), layout, sort("E")], sort("E"), [])

  BinExp(x, l1, o, l2, y) = 
    appl(BinOp(o), [x, l1, lit(o), l2, y])

  BinExp(x, o, y) =   
    appl(BinOp(o), [x, _ DefaultLayout, lit(o), _ DefaultLayout, y])

  Add(x, l1, l2, y) = BinExp(x, l1, "+", l2, y) 

  Add(x, y) = BinExp(x, "+", y)
  Mul(x, y) = BinExp(x, "*", y)

  Var(x) = appl(prod([lex(sort("Id"))], sort("E"), []), [x])

rules

  Dist : Mul(x, Add(y, z)) -> Add(Mul(x, y), Mul(x, z))  

strategies

  main =   
    test-suite(!"overlay-test",  
	//overlay-test1;
	overlay-test2//;
	//overlay-test3;
	//overlay-test4  
    )

  overlay-test1 = 
    apply-test(!"overlay-test1"
	      ,Add(id, id)
              ,!Add(Var("y"), Var("z"))
              ,!Add(Var("y"), Var("z"))
              )
	
  overlay-test2 = 
    apply-test(!"overlay-test2"
	      ,Dist
              ,!Mul(Var("x"), Add(Var("y"), Var("z")))
              ,!Add(Mul(Var("x"), Var("y")), Mul(Var("x"), Var("z")))
              )

  overlay-test3 = 
    apply-test(!"overlay-test3"
	      ,Add(Dist, id, id, id)
              ,!Add(Mul(Var("x"), Add(Var("y"), Var("z"))), " ", " ", Var("a"))
              ,!Add(Add(Mul(Var("x"), Var("y")), Mul(Var("x"), Var("z"))), " ", " ", Var("a"))
              )

  overlay-test4 = 
    apply-test(!"overlay-test4"
	      ,Add(Dist, id)
              ,!Add(Mul(Var("x"), Add(Var("y"), Var("z"))), "  ", "", Var("a"))
              ,!Add(Add(Mul(Var("x"), Var("y")), Mul(Var("x"), Var("z"))), "  ", "", Var("a"))
              )



