#!/usr/bin/perl -w
#
# Program to generate a PDF file with PNG images using a pre-defined layout
# with ImageMagick's montage tool.
#
# This script was written for Storymaps in order to make it possible to
# distribute all the cards in printable PDF files for offline use.
#
# This program is copyright 2011 by Javier Fernandez-Sanguino <jfs@debian.org>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# For more information please see
#  http://www.gnu.org/licenses/licenses.html#GPL
#
# -------------------------------------------------------------------------
# 
# TODO
# - Directory should be configurable through CLI
# - Page format (A4, Letter..) is not defined
# - Should check if montage is available before executing it
# - Command being run is not fully safe, use system() instead
# - Better error control, e.g. only add readable files


# Configuration for the script:
my $dir = "."; # Directory with the PNG files
my $images_per_page = 4; # number of images per page has to be even

# This can be redefined if you want a different layout, by default
# it sets the images in a square
my $row = $images_per_page/2 ;
my $col = $images_per_page/2 ;

opendir (DIR, $dir) || die "Cannot open dir $dir: $!";

@files= sort(grep { /\.png$/ && -f "$dir/$_" } readdir(DIR));
closedir DIR;

$countfiles = $#files + 1;
$total_pages = sprintf("%.0f", $countfiles / $images_per_page);
$total_pages ++ if $countfiles % $images_per_page  != 0 ;
print STDERR "There are $countfiles files. With $images_per_page, I will generate $total_pages pages\n";

$pagenum = 0;
for ($pagenum = 0;  $pagenum < $total_pages ; $pagenum++) {
    $file_list = "";
    for ($i = 0 ; $i < $images_per_page; $i ++ ) {
        if ( $#files >= 0 ) {
            $file_list = $file_list." ".(pop @files);
        }
    } 
    $command = "montage -mode concatenate -borderwidth 10 -bordercolor black -tile ${col}x${row} $file_list page${pagenum}.pdf";
    print STDERR "Running: $command\n";
    `$command`;
}

exit 0;
