inherit "/kernel/module";

import Graphic;

#include <macros.h>
#include <events.h>
#include <attributes.h>
#include <classes.h>

mixed getAttribute(object obj, string key)
{
  return obj->query_attribute(key);
}

void load_module()
{
  add_global_event(EVENT_UPLOAD, create_thumb, PHASE_NOTIFY);
}

object create_thumb(int e, object img, mixed ... args)
{
  object obj;

 
  if ( search(img->query_attribute(DOC_MIME_TYPE), "img") == -1 )
    return 0;

  MESSAGE("Creating thumb for " + img->get_identifier());
 
  obj = img->query_attribute(DOC_IMAGE_THUMBNAIL);
  if ( objectp(obj) )
    obj->delete();
  if ( get_content_size() == 0 )
    return 0;
  
  object factory = _Server->get_factory(CLASS_DOCUMENT);
  object thumb = factory->execute( 
				  ([ "name": "THUMB_"+img->get_identifier(),
				     "acquire": img, 
				  ]) 
				  );
  thumb->set_attribute("thumb", "true");
  thumb->set_content(query_thumbnail(img, 80, 80, true));
  thumb->set_attribute(DOC_IMAGE_SIZEX, 80);
  thumb->set_attribute(DOC_IMAGE_SIZEY, 80);
  img->set_attribute(DOC_IMAGE_THUMBNAIL, thumb);
  return thumb;
}

string get_identifier()
{
  return "thumbnails";
}









