 import Visconte;
// import Visconte.Onto;
// import Visconte.Onto.Item;
// import Visconte.Request;

class GenericAction
//{{{ 
{

/**
 * <p>class Action - A generic action which should  not be instanciated at all. Use the dynamic binding instead and define
 * sublcasses for new actions from this class. e.g GenericAction a = ClassAcion() </p>
 * Most of the Methods will return an Visconte.Request.Result object, which can be used for xml rendering and finding errors
 */


/**
 * <p>The type of the action, subclasses should  overwrite this value with its action type, e.g for ClassAction use class etc.</p>
 */
    public constant action_type ="GENERICACTION";


/**
 * <p>the language of the ontology retrieval</p>
 */
    protected string lang = "en";

/**
 * <p>The ontology object</p>
 */
    protected Visconte.Onto.Ontology ontology;

/**
 * <p>The Visconte.Onto.Item.OWLItem Factory to produce items</p>
 */
    protected Visconte.Onto.OWLItemFactory factory = Visconte.Onto.OWLItemFactory();

/**
 * <p>construcor of the specified action. Use it in dynamic binding style, e.g Action a = ClassAction(...) </p>
 * 
 * 
 * @param ontology the ontology
 *
 */
    public void create(Visconte.Onto.Ontology ontology) 
    {        
       this_program::ontology = ontology;
      
    } 
    
/**
 * <p>get a specific item</p>
 * 
 * 
 * @param ID id - the id of the item to get 
 * @return Visconte.Request.Result - the item
 */
    public Visconte.Request.Result get_Item(ID id)
    {        
       
	    
       Visconte.Request.Result res = Visconte.Request.Result();
       Visconte.Onto.Item.OWLItem owl_item;
       array error =catch
       {
	       if(ontology->item_exists(id->ref))
	       {
		       owl_item = ontology->get_Item(id->ref);
	       }
	       else
		       res->add_Message(Visconte.Request.Message( ({ "", backtrace(), 11, id->ref }) ));
       };
       if(error)
	       res->add_Message(Visconte.Request.Message(error));
       
       res->set_OWLItem(owl_item);
       
       return res;
	       
	       
    } 
    
/**
 * <p>get a specific item</p>
 * 
 * 
 * @param ID id - the id of the item to get 
 * @return Visconte.Onto.Item.OWLItem - the item as object
 */
    public Visconte.Onto.Item.OWLItem get_RawItem(ID id)
    {        
       Visconte.Onto.Item.OWLItem owl_item;
       array error =catch
       {
	       if(ontology->item_exists(id->ref))
	       {
		       return ontology->get_Item(id->ref);
	       }
	       else
		       return 0;
       };
      
    } 
    
/**
 * <p>Changes the name of any OWLItem
 * 
 * 
 * @param ID id - current id of the item to rename 
 * @param label - the new label of the item
 * @param string comment - a comment for the ontology log
 * @return Result - the renamed item
 */
    public Visconte.Request.Result rename(ID id, mapping label, string comment) 
    {
	Visconte.Request.Result res = Visconte.Request.Result(); 
	Visconte.Onto.Item.OWLItem  item;
	string oldname;
	
        array error=catch
	{
		    item = ontology->get_Item(id->ref); 
		    oldname= item->get_Label();
		    item->set_Label(label);
		    ontology->update(item);
	};
	
	if(error)
		res->add_Message(Visconte.Request.Message(error));
	else
	{
		string action;
		switch(item->ITEMTYPE)
		{
		//if class
		case Visconte.Onto.Item.OWLItem.CLASS:
		action = "class_renamed";
		break;
		
		case Visconte.Onto.Item.OWLItem.OBJECT_PROPERTY:
		action = "association_renamed";
		break;
		
		case Visconte.Onto.Item.OWLItem.DATATYPE_PROPERTY:
		action = "datatype_renamed";
		break;
		
		case Visconte.Onto.Item.OWLItem.INDIVIDUAL:
		action = "individual_renamed";
		break;
		
		default:
		action = "unspecified_item_renamed";
		break;
		
		}
		ontology->add_annotation(item,action,(string)comment,oldname);
	}
	res->set_OWLItem(item);
	return res;
		    
    }
} 
    
    
    

/**
 * <p>class ClassAction - Class related Actions take place in here</p>
 */    
class ClassAction
{
inherit GenericAction;


/**
 * <p>move a class to a new location.</p>
 * 
 * 
 * @param id the id of the class
 * @param new_parent the parent id where this class should be moved
 * @param with_subtree indicate if the subtree should be moved too
 * @param string comment - a comment for the ontology log
 * @return 
 */
    public Visconte.Request.Result move(ID class_id, ID new_parent_id, string comment) 
    {    
	Visconte.Request.Result res = Visconte.Request.Result(); 
	string move_class_label="";
	Visconte.Onto.Item.OWLItem  move_class;
	Visconte.Onto.Item.OWLItem  new_parent;
	
	if(ontology->item_exists(class_id->ref) && ontology->item_exists(new_parent_id->ref))
	{
		
		array error = catch{
			move_class = ontology->get_Item(class_id->ref);
			move_class_label=move_class->get_Label();
			new_parent = ontology->get_Item(new_parent_id->ref);
			//test for a possible move to a child of itself
			if(new_parent->is_descendant_of(move_class->get_Id()))
			{
				 res->add_Message(Visconte.Request.Message( ({ "", backtrace(), 221, class_id->ref }) ));
			}
			else
			{
				move_class->set_parent(ontology->get_Item(new_parent_id->ref));
				ontology->update(move_class);
			}
		};
		res->set_OWLItem(move_class);
		if(error)
			res->add_Message(Visconte.Request.Message(error));
		else
			ontology->add_annotation(move_class_label,"class_moved",(string)comment,new_parent->get_Label());
	}
	//check what not exists
	else
	{
		if(!ontology->item_exists(class_id->ref))
		 res->add_Message(Visconte.Request.Message( ({ "", backtrace(), 11, class_id->ref }) ));
		if(!ontology->item_exists(new_parent_id->ref))
		 res->add_Message(Visconte.Request.Message( ({ "", backtrace(), 11, new_parent_id->ref }) ));
	}
	return res;
    } 

/**
 * <p>Add a new class to the ontology</p>
 * 
 * 
 * @param ID new_id - the new id of the subclass
 * @param ID parent_id - the id this class should be subclass of
 * @param label - mapping with name value pairs: e.g. en->class, de->klasse etc 
 * @param string comment - a comment for the ontology log
 * @return 
 */
    public Visconte.Request.Result subclass(ID new_id, ID parent_id, mapping label, array equivalent_Class, array different_From , string comment) 
    {        
        Visconte.Request.Result res = Visconte.Request.Result(); 
	Visconte.Onto.Item.OWLItem  new_class;
	
	array error=catch
	{
		    new_class = factory->construct_Class(ontology,new_id,parent_id,label, equivalent_Class,  different_From,);
		    ontology->add_Item(new_class);
		    new_class->mirror_restrictions();
	};
	
	if(error)
		res->add_Message(Visconte.Request.Message(error));
	else
		ontology->add_annotation(new_class,"class_subclassed",(string)comment,parent_id->ref);
	res->set_OWLItem(new_class);
	return res;
	
	
    }
    
    
/**
 * <p>Delete all classes under this id recursive</p>
 * 
 * 
 * @param ID id the id to delete
 * @return 1
 *
*/
    private int delete_tree(ID id) 
    {                                   
	   
	    //first remove all restrictions;
	    set_restrictions(id,0,0,1,"");
	    Visconte.Onto.Item.OWLClass start_class = ontology->get_Item(id->ref);
	    if(!start_class) return 0;
	    
	    if(start_class->has_childs())
	    {
		    Visconte.Onto.OWLContainer container  = start_class->get_childs();
		    while(container->has_items())
		    {
			    delete_tree(ID(container->next()->get_Id(),1));
		    }
	    }
	    
	    delete(id,0,"");
	    return 1;
    }
	    
	    
/**
 * <p>Delete a class from the ontology</p>
 * 
 * 
 * @param ID id the id to delete
 * @param string comment - a comment for the ontology log
 * @param string comment - a comment for the ontology log
 * @return Result 
 *
*/
    public Visconte.Request.Result delete(ID id, int with_subtree, string comment) 
    {       
	    Visconte.Request.Result res = Visconte.Request.Result();
	    Visconte.Onto.Item.OWLClass class_to_remove;
	    string class_label;
	    array error = catch
	    {
		    //the whole subtree should be deleted go recursive
		    if(with_subtree)
			  delete_tree(id);
		    //delete the class
		    else
		    {
			    //test for the existence of the Class!
			    if(ontology->item_exists(id->ref))
			    {
				   
				    class_to_remove = ontology->get_Item(id->ref);
				    class_label=class_to_remove->get_Label();
				    //get the parent of this class
				   
				    Visconte.Onto.Item.OWLClass parent = class_to_remove->get_parent();
				    
				    //define the containers
				    Visconte.Onto.OWLContainer individuals = class_to_remove->get_individuals();
				    Visconte.Onto.OWLContainer child_container = class_to_remove->get_childs();
				    Visconte.Onto.OWLContainer class_is_domain_cnt = class_to_remove->get_domain_properties();
				    Visconte.Onto.OWLContainer class_is_range_cnt = class_to_remove->get_range_properties();
				    
				    //remove the individuals which have this class as constructor
				    while(individuals->has_items())
				    {
					    Visconte.Onto.Item.OWLIndividual i = individuals->next();
					    //get the indivduals pointing with an assocaition to this resp. i
					    //and unset this association
					    Visconte.Onto.OWLContainer in_associated = ontology->get_items_by_object(i->get_Id(),0,Visconte.Onto.Item.OWLItem.INDIVIDUAL);
					    while(in_associated->has_items())
					    {
						   Visconte.Onto.Item.OWLIndividual in_individual = in_associated->next();
						   in_individual->remove_associations_with(i);
						   ontology->update(in_individual);
					    }
					    ontology->remove(i);
				    }
				    //give the childs a new parent :)
				    while(child_container->has_items())
				    {
					    Visconte.Onto.Item.OWLItem i = child_container->next();
					    if(!with_subtree)
					    {
						    i->set_parent(parent);
						    ontology->update(i);
					    }
					    else
						   ontology->remove(i);  
				    }
				  
				    // remove all ObjectProperties where the class act as range
				    while(class_is_range_cnt->has_items())
				    {
					    Visconte.Onto.Item.OWLItem i = class_is_range_cnt->next();
					    if(i->ITEMTYPE==Visconte.Onto.Item.OWLItem.OBJECT_PROPERTY)
					    {
						    Visconte.Onto.OWLContainer inds_pointing_to_this = i->get_individuals();
						    ontology->remove(i);
					    }
				    }
				    //remove all properties where the class acta as the domain
				    while(class_is_domain_cnt->has_items())
				    {
					    Visconte.Onto.Item.OWLItem i = class_is_domain_cnt->next();
					    ontology->remove(i);
				    }
				    //finally remove the class itself
				    ontology->remove(class_to_remove);
				    
			    }
			    else
			    {
			    	//not exist message
				res->add_Message(Visconte.Request.Message( ({ "", backtrace(),11, id->ref }) )); 
			    }	
				    
		    }//end if with_subtree
		   
	    }; //end catch
	    
	    res->set_OWLItem(class_to_remove);
	    if(error)
		    res->add_Message(Visconte.Request.Message(error));
	    else
		    ontology->add_annotation(class_label,"class_deleted",(string)comment,0);
		    
	    return res;
    } 

/**
 * <p>Get individuals which match this (and sub) classes as template</p>
 * 
 * 
 * @param ID class_id - the id of the template class
 * @param void|int only_this - only return individuals of this class (not the ones of the subclasses)
 * @param void|int  with_associated - if set, the associated indivudals will be returned, too
 * @return Visconte.Request.Result - the result
 *
*/
    public Visconte.Request.Result get_matching_individuals(ID class_id, void|int only_this, void|int with_associated) 
    {
	    Visconte.Request.Result res = Visconte.Request.Result();
	    Visconte.Onto.Item.OWLClass class_ ;
	    Visconte.Onto.OWLContainer ind;
	    array error = catch{
		    if(ontology->item_exists(class_id->ref))
		    {
			    class_ = ontology->get_Item(class_id->ref);
			    if(only_this)
				    ind=class_->get_individuals();
			    else
				    ind=class_->get_individuals_down_to_leaf();
			    
			    if(with_associated)
			    {
				    
				 Visconte.Onto.OWLContainer associated_individuals =  Visconte.Onto.OWLContainer();
				 while(ind->has_items())
				 {
					
					associated_individuals->merge(ind->next()->get_associations());
					 write(associated_individuals->to_string());
				 }
				 ind->merge(associated_individuals);
				 ind->reset_iterator();
			    }
		    }
		    else
		    {
			//set a not existing error
			res->add_Message(Visconte.Request.Message( ({ "", backtrace(),11, class_id->ref }) ));

		    }
			    
	    };
	    if(error)
		res->add_Message(Visconte.Request.Message(error));
		
		res->set_OWLContainer(ind);
	
	return res;
    }

/**
 * <p>Get all associations of the given class (and its parents) is pointing to resp. is domain of</p>
 * 
 * @param ID class_id - the class id of the domain
 * @param int|void only_this - if set the inherited associations will not be included 
 * @return 
 * @param id the id to delete
 *
*/
    public Visconte.Request.Result get_all_associations(ID class_id, void|int only_this) 
    {
	    Visconte.Request.Result res = Visconte.Request.Result();
	    Visconte.Onto.Item.OWLClass class_ ;
	    Visconte.Onto.OWLContainer assoc;
	    array error = catch{
		    if(ontology->item_exists(class_id->ref))
		    {
			    class_ = ontology->get_Item(class_id->ref);
			    if(only_this)
				    assoc=class_->get_domain_properties();
			    else
				    assoc=class_->get_inherited_domain_properties();
		    }
		    else
		    {
			//set a not existing error
			res->add_Message(Visconte.Request.Message( ({ "", backtrace(),11, class_id->ref }) ));
		    }
			    
	    };
	    if(error)
		res->add_Message(Visconte.Request.Message(error));
		
		res->set_OWLContainer(assoc);
	
	return res;
    }   
    

/**
 * <p>Changes the id a OWLClass and all affected Inviduals and Properties
 * 
 * 
 * @param ID id - current id of the Class to rename 
 * @param new_id - the new id of the class
 * @param string comment - a comment for the ontology log
 * @return Result - the renamed class
 */
    public Visconte.Request.Result changeId(ID id, ID new_id, mapping label, string comment) 
    {     
	    
	Visconte.Request.Result res = Visconte.Request.Result(); 
	Visconte.Onto.Item.OWLItem  new_class;
	Visconte.Onto.Item.OWLItem  old_class;
	
        array error=catch
	{
		    old_class = ontology->get_Item(id->ref);
		    if(old_class && !ontology->item_exists(new_id->ref))
		    {
			    //if one want to rename the class thing, just change the label
			    if(old_class->is_root())
			    {
				    old_class->set_Label(label);
				    ontology->update(old_class);
			    }
			    else
			    {
				    string parent = old_class->get_parent()->get_Id();
				    ID parent_id;
				    if(!parent)
					    parent_id=ID("Thing");
				    else
					    parent_id=ID(parent);
				    new_class = factory->construct_Class(ontology,new_id,parent_id,label,({  }) ,({  }) );
				    ontology->add_Item(new_class);
				    new_class->mirror_restrictions();
				    
				    //change the individuals
				     Visconte.Onto.OWLContainer inds = old_class->get_individuals();
				     while(inds->has_items())
				     {
					     Visconte.Onto.Item.OWLIndividual ind = inds->next();
					     ind->set_model_class(new_class);
					     ontology->update(ind);
				     }
				     
				      //change  all properties where the old class is the domain
				     Visconte.Onto.OWLContainer domain_props = old_class->get_domain_properties();
				     while(domain_props->has_items())
				     {
					     Visconte.Onto.Item.OWLProperty domain_prop = domain_props->next();
					     domain_prop->set_domain(new_class);
					     ontology->update(domain_prop);
				     }
				     
				      //change all properties where the old class is the range
				     Visconte.Onto.OWLContainer range_props = old_class->get_range_properties();
				     while(range_props->has_items())
				     {
					     Visconte.Onto.Item.OWLProperty range_prop = range_props->next();
					     range_prop->set_range(new_class);
					     ontology->update(range_prop);
				     }
				     
				      //change all direct subclasses
				     Visconte.Onto.OWLContainer childs = old_class->get_childs();
				     while(childs->has_items())
				     {
					     Visconte.Onto.Item.OWLClass child = childs->next();
					     child->set_parent(new_class);
					     ontology->update(child);
				     }
				     
				     //finally remove the old class
				     ontology->remove(old_class);
			    }
		    } 
		    else
			//set a not existing error
			res->add_Message(Visconte.Request.Message( ({ "", backtrace(),11, id->ref }) ));
	};
	
	if(error)
		res->add_Message(Visconte.Request.Message(error));
	else
		ontology->add_annotation(new_class,"class_id_changed",(string)comment, old_class->get_Label());
	
	res->set_OWLItem(new_class);
	return res;
    } 
/**
 * <p>Set Restrictions to a class - has currently no effect</p>
 * 
 * 
 * 
 * @param id 
 * @param new_id 
 * @param string comment - a comment for the ontology log
 * @return 
 */
    public Visconte.Request.Result set_restrictions(ID id, array equivalent, array different, int remove, string comment) 
    {        
	 Visconte.Request.Result res = Visconte.Request.Result();
	 Visconte.Onto.Item.OWLClass class_to_restrict;
	 array error = catch{
		 
		 if(ontology->item_exists(id->ref))
		 {
			class_to_restrict = ontology->get_Item(id->ref);
			if(equivalent)
			foreach( equivalent,ID cid)
			{
				
				if(ontology->item_exists(cid->ref))
					if(remove)
						class_to_restrict->unset_equivalent_class(cid->ref);
					else
						class_to_restrict->set_equivalent_class(cid->ref);
			}
			
			if(different)
			foreach( different,ID cid)
			{
				
				if(ontology->item_exists(cid->ref))
					if(remove)
						class_to_restrict->unset_different_from_class(cid->ref);
					else
						class_to_restrict->set_different_from_class(cid->ref);
			}
			
			if(!different && !equivalent && remove)
			{
				class_to_restrict->unset_restrictions();
			}
			
			
			
			ontology->update(class_to_restrict);
		 }
		 else
			//set a not existing error
			res->add_Message(Visconte.Request.Message( ({ "", backtrace(),11, id->ref }) ));

	 };
	 
	 res->set_OWLItem(class_to_restrict);
	 if(error)
		 res->add_Message(Visconte.Request.Message(error));
	 else
		 ontology->add_annotation(class_to_restrict,"class_restricted",(string)comment, 0);
	 
	 return res;
		
    } 
    
    

} //}}}




/**
 * <p>class IndividualAction - Represents Actions on individuals in an ontology</p>
 */
class IndividualAction
{
//{{{ 
    inherit GenericAction;


/**
 * <p>Adds an Individual to the ontology</p>
 * 
 * @param ID individual_id - the id of the individual 
 * @param ID class_id - the id of the model class 
 * @param MVList properties - MultiValue List for the inserted properties
 * @param mapping same_as - no effect up to now, pass empty mapping 
 * @param different_from - no effect up to now, pass empty mapping 
 * @param string comment - a comment for the ontology log
 * @return Result - the new individual (if already exists, the current will be returned!)
 */
    public Visconte.Request.Result add(ID individual_id, ID class_id, mapping label, Visconte.MVList property_values, mapping same_as, mapping different_from , string comment) 
    {        
        Visconte.Request.Result res = Visconte.Request.Result();
	Visconte.Onto.Item.OWLIndividual new_individual;
	
	array error =catch
	{
		new_individual = factory->construct_Individual(ontology, individual_id, class_id, label,property_values);

		if(new_individual)
		{
			ontology->add_Item(new_individual);
		}
		else
			res->add_Message(Visconte.Request.Message( ({ "", backtrace(),11, individual_id->ref }) )); 
	};
	
	if(error)
		res->add_Message(Visconte.Request.Message(error));
	else
		ontology->add_annotation(new_individual,"individual_added",(string)comment,0);
	
	res->set_OWLItem(new_individual);
	
	return res;
    } 

/**
 * <p>Deletes an individual from the ontology.</p>
 * 
 * @param ID id the id of the individual to delete
 * @param string comment - a comment for the ontology log
 * @return Result
 */
    public Visconte.Request.Result delete(ID id, string comment) 
    {        
	    Visconte.Request.Result res = Visconte.Request.Result();
	    Visconte.Onto.Item.OWLItem individual_to_delete;
	    string individual_label;
	    array error = catch
	    {
		    if(ontology->item_exists(id->ref))
		    {
			     individual_to_delete = ontology->get_Item(id->ref);
			     individual_label=individual_to_delete->get_Label();
			     Visconte.Onto.Item.OWLClass class_ = ontology->get_Item("#Thing");
			     Visconte.Onto.OWLContainer all_inds = class_->get_individuals_down_to_leaf();
			     all_inds->reset_iterator();
			     while(all_inds->has_items())
			     { 
				     Visconte.Onto.Item.OWLIndividual ind = all_inds->next();
				     if(ind->is_associated_with(individual_to_delete))
				     ind->remove_associations_with(individual_to_delete);
				     ontology->update(ind);
			     }
			    ontology->remove(individual_to_delete);
		    }
		    else
			    res->add_Message(Visconte.Request.Message( ({ "", backtrace(), 11, id->ref }) ));
	    };
	    
	    if(error)
	    	res->add_Message(Visconte.Request.Message(error));
	    else
		ontology->add_annotation(individual_to_delete,"individual_deleted",(string)comment,0);
	    res->set_OWLItem(individual_to_delete);
	    
	    return res;
    } 



/**
 * <p>Updates an Individual</p>
 * Give a new MVList to update a given Individual
 * 
 * @param id - the id of the Indvidual
 * @param properties -  the properties
 * @param  comment - a comment for the ontology log
 * @return Result - the changed Individual
 */
    public Visconte.Request.Result update(ID id,  MVList properties, mapping label, string comment) 
    {        
	      Visconte.Request.Result res = Visconte.Request.Result();
	      Visconte.Onto.Item.OWLIndividual individual_to_update;
	      array error = catch
	      {
		    if(ontology->item_exists(id->ref))
		    {
			    individual_to_update = ontology->get_Item(id->ref);
			    individual_to_update->set_Label(label);
			    individual_to_update->reset_properties();
			    individual_to_update->set_Properties(properties);
			    ontology->update(individual_to_update);
		    }
		    else
			    res->add_Message(Visconte.Request.Message( ({ "", backtrace(), 11, id->ref }) ));
	      };
	    
	    if(error)
	    	res->add_Message(Visconte.Request.Message(error));
	    else
		ontology->add_annotation(individual_to_update,"individual_updated",(string)comment,0);
	    res->set_OWLItem(individual_to_update);
	    
	    return res;
    } 

/**
 * <p>Updates an Individual</p>
 * Give a new MVList to update a given Individual
 * 
 * @param id - the id of the Indvidual
 * @param properties -  the properties
 * @param  comment - a comment for the ontology log
 * @return Result - the changed Individual
 */
    public Visconte.Request.Result change_Id(ID id, ID new_id, mapping label, string comment) 
    {
	     Visconte.Request.Result res  = Visconte.Request.Result();
	     Visconte.Onto.Item.OWLIndividual current_ind;
	     Visconte.Onto.Item.OWLIndividual new_individual;
	      array error = catch
	      {
		    if(ontology->item_exists(id->ref) && !ontology->item_exists(new_id->ref))
		    {
			     current_ind = ontology->get_Item(id->ref);
			     ID model_class = ID(current_ind->get_model_class()->get_Id());
			     new_individual = factory->construct_Individual(ontology, new_id, model_class,label,current_ind->get_property_list());
			     ontology->add_Item(new_individual);
			     //change all interconnections
			     Visconte.Onto.Item.OWLClass class_ = ontology->get_Item("#Thing");
			     Visconte.Onto.OWLContainer all_inds = class_->get_individuals_down_to_leaf();
			     all_inds->reset_iterator();
			     while(all_inds->has_items())
			     { 
				     Visconte.Onto.Item.OWLIndividual ind = all_inds->next();
				     if(ind->is_associated_with(current_ind))
				     ind->replace_individual(current_ind,new_individual);
				     ontology->update(ind);
			     }
			     ontology->remove(current_ind);
		    }
		};
	    if(error)
		res->add_Message(Visconte.Request.Message(error));
	    else
		ontology->add_annotation(new_individual,"individual_id_changed",(string)comment,0);
	    res->set_OWLItem(new_individual);
	    
	    return res;
    }    
/**
 * <p>Retrieve all Individuals wich have a connection/association to and from  the current one </p>
 * 
 * 
 * @param ID  id - the id of the individual to retrive the references from
 * @param int no_back_refs - if set, no incoming assocaitions will be returned
 * @param int include_self - if set, the given individual will be included to Result 
 * @return Result - Referenced Individuals
 */
    public Visconte.Request.Result get_all_references(ID indivual_id,int no_back_refs, int include_self) 
    {        
	   Visconte.Request.Result res = Visconte.Request.Result();
	   Visconte.Onto.OWLContainer references =  Visconte.Onto.OWLContainer();
	  
	   array error = catch{
		   if(!no_back_refs)
		   {
			   //start at the root
			   Visconte.Onto.Item.OWLClass class_ = ontology->get_Item("#Thing");
			   Visconte.Onto.OWLContainer all_inds = class_->get_individuals_down_to_leaf();
			   all_inds->reset_iterator();
			   while(all_inds->has_items())
			   { 
				    Visconte.Onto.Item.OWLIndividual ind = all_inds->next();
				    if(ind->is_associated_with(indivual_id->ref))
					    references->add(ind);
			   }
		   }
		   Visconte.Onto.Item.OWLIndividual ind = ontology->get_Item(indivual_id->ref);
		   references->merge(ind->get_associations());
		   if(include_self)
			references->add(ind);   
	    };
	    
	    if(error)
		res->add_Message(Visconte.Request.Message(error));
	   
	    res->set_OWLContainer(references);
	
	return res;
    }
} 

/**
 * <p>class PropertyAction - Property related actions</p>
 */
class PropertyAction
//{{{ 
{

inherit GenericAction;



/**
 * <p>add a property to the ontology</p>
 * TODO: Add cardinality
 * @param id the new id of the property
 * @param mapping label - the labels of the property (currently only english) (["en":"Your Label"]) 
 * @param ID domain - the id of the domain (source) 
 * @param ID range - the id of the range (target)
 * @param mapping restrictions - symetric, transitive etc. (has currently no effect in the ontology)
 * @param string  comment - a comment for the ontology log
 * @return Result - the  new Property (if already exists, the current one will be returned) 
 */
    public Visconte.Request.Result add(ID id, mapping label, mapping restrictions, ID domain, ID range, string comment) 
    {  
	    
	Visconte.Request.Result res = Visconte.Request.Result();
        Visconte.Onto.Item.OWLProperty property;
	array error =catch
	{
		property = factory->construct_Property(ontology,id,label,restrictions,domain,range);
		ontology->add_Item(property);
		if(property->ITEMTYPE==Visconte.Onto.Item.OWLItem.OBJECT_PROPERTY)
			ontology->add_annotation(property,"add_association", comment,domain->ref);
		else
			ontology->add_annotation(property,"add_property", comment,domain->ref);
			
	};
	
	if(error)
		res->add_Message(Visconte.Request.Message(error));
	
	
	res->set_OWLItem(property);
	
	return res;
    } 

/**
 * <p>Delete a Property from the ontology</p>
 * 
 * @param ID id - the id of the property
 * @param string  comment - a comment for the ontology log
 * @return Result
 */
    public Visconte.Request.Result delete(ID id, string comment) 
    {        
       Visconte.Request.Result res = Visconte.Request.Result();
       Visconte.Onto.Item.OWLProperty prop;
       
       array error=catch
       {
       
	       if(ontology->item_exists(id->ref))
	       {
		  
		       prop =  ontology->get_Item(id->ref);
		       //get the class id of the domain
		       Visconte.Onto.OWLContainer container= prop->get_domain()->get_individuals_down_to_leaf();
		       //update the Individuals which hold this property, by removing it
		       while(container->has_items())
		       {
			       Visconte.Onto.Item.OWLIndividual i = container->next();
			       i->remove_Property(prop);
			       ontology->update(i);
		       }
		       
		       //remove the poperty
		       ontology->remove(prop);
	       }
	       else
		       res->add_Message(Visconte.Request.Message( ({ "", backtrace(), 11, id->ref }) ));
       };
       if(error)
	       res->add_Message(Visconte.Request.Message(error));
       else
		ontology->add_annotation(prop,"property_deleted",(string)comment,0);
       res->set_OWLItem(prop);
       
       return res;
       
    } 

    
    
    
/**
 * <p>Rename a Property</p>
 * 
 * @param ID id - the id of the property
 * @param ID newId - the new Id of the property
 * @param string  comment - a comment for the ontology log
 * @return Result
 */
    public Visconte.Request.Result change_Id(ID id,ID new_id, mapping label, string comment) 
    {        
       Visconte.Request.Result res = Visconte.Request.Result();
       Visconte.Onto.Item.OWLProperty prop_old;
       Visconte.Onto.Item.OWLProperty prop_new;
       
       array error=catch
       {
       
	       if(ontology->item_exists(id->ref) && !ontology->item_exists(new_id->ref))
	       {
		  
		       prop_old =  ontology->get_Item(id->ref);
		       ID domain = ID(prop_old->get_domain()->get_Id());
		       ID range;
		       if(prop_old->ITEMTYPE!=Visconte.Onto.Item.OWLItem.DATATYPE_PROPERTY)
			       range = ID(prop_old->get_range()->get_Id());
		       else
			       range = ID("xsd:"+prop_old->get_range());
		       prop_new = factory->construct_Property(ontology,new_id,label,([]),domain,range);
		       ontology->add_Item(prop_new);
		       Visconte.Onto.OWLContainer container= prop_old->get_domain()->get_individuals_down_to_leaf();
		       //update the Individuals which hold this property, by replacing it
		       while(container->has_items())
		       {
			       Visconte.Onto.Item.OWLIndividual i = container->next();
			       i->replace_Property(prop_old,prop_new);
			       ontology->update(i);
		       }
		       
		       //remove the poperty
		       ontology->remove(prop_old);
	       }
	       else
		       res->add_Message(Visconte.Request.Message( ({ "", backtrace(), 11, id->ref }) ));
       };
       if(error)
	       res->add_Message(Visconte.Request.Message(error));
       else
		ontology->add_annotation(prop_new,"property_id_changed",(string)comment,0);
       res->set_OWLItem(prop_new);
       
       return res;
       
    } 


/**
 * <p>Does ...</p>
 * 
 * 
 * @param id 
 * @param restrictions 
 * @return 
 */
    public Visconte.Request.Result set_Restrictions(ID id, mapping restrictions, string comment) {        
        // your code here
        return 0;
    } 
}


/**
 * <p>class OntologyAction - Action Class for special retrievals on the whole ontology</p>
 */
class OntologyAction
{
//{{{ 
inherit GenericAction;

/**
 * <p>Returns a hierarchical map of class dependencies for the representation in the visconte ontology browser.
 * An options mapping indicates which informations should be also insert in the map e.g Assocaitions Individuals etc</p>
 * 
 * 
 * @param root_id the root id of the map (class id)
 * @param options mappig with name value pairs
 * @return 
 */
    public Visconte.Request.Result get_Class_List(ID model_class_id, int|void with_myself) 
    {        
       Visconte.Request.Result res = Visconte.Request.Result();
       Visconte.Onto.OWLContainer all_child_container;
       Visconte.Onto.Item.OWLClass model;
       array error = catch
       {
	        model = ontology->get_Item(model_class_id->ref);
		all_child_container=model->get_all_childs();
		if(with_myself)
			all_child_container->add(model);
       };
       if(error)
	    res->add_Message(Visconte.Request.Message(error));
	       
       res->set_OWLContainer(all_child_container);
       
       return res;
    } 


/**
 * <p>Returns a hierarchical map of class dependencies for the representation in the visconte ontology browser.
 * An options mapping indicates which informations should be also insert in the map e.g Assocaitions Individuals etc</p>
 * 
 * 
 * @param root_id the root id of the map (class id)
 * @param options mappig with name value pairs
 * @return 
 */
    public Visconte.Request.Result get_Hierarchical_Map() 
    {        
       Visconte.Request.Result res = Visconte.Request.Result();
       Visconte.Onto.Item.OWLClass root;
       array error = catch
       {
	        root = ontology->get_Item("#Thing");
       };
       
       if(error)
	    	res->add_Message(Visconte.Request.Message(error));
       res->set_OWLItem(root,Visconte.Request.Result.RENDER_DEEP);
       
       return res;
    } 


/**
 * <p>Returns a hierarchical map of class dependencies for the representation in the visconte ontology browser.
 * An options mapping indicates which informations should be also insert in the map e.g Assocaitions Individuals etc</p>
 * 
 * 
 * @param root_id the root id of the map (class id)
 * @param options mappig with name value pairs
 * @return 
 */
    public Visconte.Request.Result get_Up_Map(ID model_class_id) 
    {        
       Visconte.Request.Result res = Visconte.Request.Result();
       Visconte.Onto.Item.OWLClass klass;
       array error = catch
       {
	        klass=ontology->get_Class(model_class_id->ref);
       };
       
       if(error)
	    	res->add_Message(Visconte.Request.Message(error));
       res->set_OWLItem(klass,Visconte.Request.Result.RENDER_UP);
       
       return res;
    }

/**
 * <p>Get a cluster of individuals which fit to the constrains in the statements mapping.</p>
 * 
 * 
 * @param statements mapping with matching attributes 
 * @return 
 */
    public Visconte.Request.Result get_Individuals_by_Class(ID model_class_id, int edge_restriction) 
    {        
	Visconte.Request.Result res = Visconte.Request.Result(); 
	Visconte.Onto.OWLContainer individuals_container;
	array error = catch
	{
		Visconte.Onto.Item.OWLClass model_class = ontology->get_Item(model_class_id->ref);
		write(model_class->get_Id());
		switch(edge_restriction)
		{
			
			case 0 :
				individuals_container = model_class->get_all_individuals();
				break;
			case 1 :
				individuals_container = model_class->get_individuals_up_to_root();
				break;
			case 2 :
				individuals_container = model_class->get_individuals_down_to_leaf();
				break;
				
			default:       
				individuals_container = model_class->get_all_individuals();
				break;
		}
	};
	
	if(error)
		res->add_Message(Visconte.Request.Message(error));
	else
		res->set_OWLContainer(individuals_container);
	
	return res;
    }
		
	
	
/**
 * <p>Get the annotations of an ontology</p>
 * 
 * 
 * @return string xml;
 */
    public string get_annotations() 
    { 
	    return ontology->get_annotations();
    } 

/**
 * <p>Get the Parser.XML.Tree.Node of the ontology annotations</p>
 * 
 * 
 * @return string xml;
 */
    public Parser.XML.Tree.Node get_annotation_node() 
    { 
	    return ontology->ontology_log;
    }
/**
 * <p>Retrieves Metainformations about the ontology</p>
 * 
 * 
 * @return int version number
 */
    public int get_version() {        
        
        return ontology->get_version();
    } 
    
/**
 * <p>Sets a comment for specified object</p>
 * 
 * 
 * @param id the id, the comment should linked with
 * @param author the author of the comment
 * @param msg the message
 * @return 
 */
    public int set_Comment(ID id,string comment) {        
        
	    	Visconte.Onto.Item.OWLItem i = ontology->get_Item(id->ref);
		if(i)
		{
			ontology->add_annotation(i,"comment_added",(string)comment,0);
			return 1;
		}
		else
			return 0;
			
    } 

} 





