/**
 * <p>Class MVList provides a simple multi value list, 
 * instead of a mapping there is no limitation on one single index value pair</p>
 */

 
/**
 * <p>the list</p>
 */
    private mapping(string:array(string)) list = ([]);
   
    
 
/**
 * <p>adds a index value pair. If the index exists, the value will be appendended</p>
 * 
 * 
 * @param index - the index for the multivalues 
 * @param value - the value for the index, either string or an array,  
 */
    public void  add(string index, string|array(string) value) 
    {  
	   
	    
	    if(has_index(list,index))
	    {
		    array valuelist = list[index];
		    if(arrayp(value))
			    valuelist+=value;
		    else if(stringp(value))
			    valuelist+=({ value });
		    
		    list[index]=valuelist;
	    }
	    else
	    {
		    if(arrayp(value))
			   list+=([ index : value ]);
		    else if(stringp(value))
			   list+=([ index : ({ value }) ]);
	    }    
    }
    

/**
 * <p>remove a value from the list</p>
 * 
 * 
 * @param index - the index of the value to remove
 * @param value - the value to remove
 * @retrun success
 */
    public int  remove(string index, string value) 
    {  		    
	       if(has_index(list,index))
	       {
		    array valuelist = list[index];
		    if(has_value(valuelist,value))
		    {
			    valuelist-=({ value });
			    list[index]=valuelist;
			    
			    return 1;
		    }
		    
		    return 0;
	       }
	       
	       return 0;
	       
    }
    
/**
 * <p>replaces a index</p>
 * 
 * 
 * @param string index_old - the index to replace
 * @param string index_new - the new index
 * @return int
 */
    public int  replace(string index_old, string index_new) 
    {  		    
	       if(has_index(list,index_old))
	       {
		    array valuelist = list[index_old];
		    m_delete(list, index_old);
		    add(index_new,valuelist);
		    return 1;
	       }
	       
	       return 0;
	       
    }
/**
 * <p>checks if a index - value pair exists in the list</p>
 * 
 * 
 * @param index - the index
 * @param value - the value
 * @return success
 */
    public int  has_index_value(string index, string value) 
    {  		    
	       if(has_index(list,index))
	       {
		    array valuelist = list[index];
		    if(has_value(valuelist,value))
		    {
			    return 1;
		    }
		    
		    return 0;
	       }
	       
	       return 0;
    }
   
/**
 * <p>removes an index and all connected values from the list</p>
 * 
 * 
 * @param index - the index to remove
 * @return success
 */
    public int  remove_index(string index) 
    {     
	     if(has_index(list,index))
	     {	
		     return m_delete(list, index);;
	     }
    }
		     
/**
 * <p>get all values of a given index</p>
 * 
 * 
 * @param index - the index of the values
 * @return values as array
 */
    public array  get(string index) 
    {   
	    if(has_index(list,index))
	    {
		    return list[index];
	    }
	    else
		    return ({});
    }
    
    
/**
 * <p>checks if a index exists in the list</p>
 * 
 * 
 * @param index - the index to check
 * @return success
 */
    public int  provides_index(string index) 
    {  
	  return  has_index(list,index);
    }
    
    
/**
 * <p>returns the list in the form of mapping(string:array(string))</p>
 * 
 * 
 * @return - the list as mapping 
 */
    public mapping  get_list()
    {
	    return list;
    }
    
    
/**
 * <p>get all indexes of the list</p>
 * 
 * 
 * @return array with all identifiers (indexes) 
 */
    public array get_indexes()
    {
	    return indices(list);
    }
