/* Copyright (C) 2000-2004  Thomas Bopp, Thorsten Hampel, Ludger Merkens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * $Id: database.h,v 1.1.1.1 2005/09/21 14:22:14 exodusd Exp $
 */

#ifndef _DATABASE_H
#define _DATABASE_H

#define ID_DATABASE 1

#define _SECURITY _Server->get_module("security")
#define _FILEPATH _Server->get_module("filepath:tree")
#define _TYPES _Server->get_module("types")
#define _LOG _Server->get_module("log")

#define OBJ(s) _FILEPATH->path_to_object(s)

#define MODULE_USERS   (_Server ? _Server->get_module("users") : 0)
#define MODULE_GROUPS  (_Server ? _Server->get_module("groups") : 0)
#define MODULE_OBJECTS (_Server ? _Server->get_module("objects") : 0)
#define MODULE_SMTP    (_Server ? _Server->get_module("smtp") : 0)
#define MODULE_URL     (_Server ? _Server->get_module("url") : 0)
#define MODULE_ICONS   (_Server ? _Server->get_module("icons") : 0)
#define SECURITY_CACHE (_Server ? _Server->get_module("Security:cache"):0)
#define MODULE_SERVICE (_Server ? _Server->get_module("ServiceManager"):0)

#define MOD(s) (_Server->get_module(s))
#define USER(s) MODULE_USERS->lookup(s)
#define GROUP(s) MODULE_GROUPS->lookup(s)

#define _ROOTROOM MODULE_OBJECTS->lookup("rootroom")
#define _STEAMUSER MODULE_GROUPS->lookup("sTeam")
#define _ROOT MODULE_USERS->lookup("root")
#define _GUEST MODULE_USERS->lookup("guest")

#define _ADMIN MODULE_GROUPS->lookup("Admin")
#define _WORLDUSER (MODULE_GROUPS?MODULE_GROUPS->lookup("Everyone"):0)
#define _AUTHORS MODULE_GROUPS->lookup("authors")
#define _REVIEWER MODULE_GROUPS->lookup("reviewer")
#define _BUILDER MODULE_GROUPS->lookup("builder")
#define _CODER MODULE_GROUPS->lookup("coder")


#define PSTAT_FAIL_DELETED       -3
#define PSTAT_FAIL_UNSERIALIZE   -2
#define PSTAT_FAIL_COMPILE       -1
#define PSTAT_DISK                0
#define PSTAT_SAVE_OK             1
#define PSTAT_SAVE_PENDING        2

#define PSTAT_NAMES ({ "deleted", "unserialize failed", "compile failed", \
"on disk", "Ok", "save pending" })

#define STORE_GROUP     "group"
#define STORE_ATTRIB    "attrib"
#define STORE_ACCESS    "access"
#define STORE_DATA      "data"
#define STORE_KEYWORDS  "keyword"
#define STORE_EVENTS    "events"
#define STORE_ANNOTS    "annots"
#define STORE_REFS      "refs"
#define STORE_CONTENT   "content"
#define STORE_CONTAINER "container"
#define STORE_HTMLLINK  "htmllink"
#define STORE_DOCLPC    "doclpc"
#define STORE_LINK      "link"
#define STORE_USER      "user"
#define STORE_ATTREG    "attreg"
#define STORE_ICONS     "icons"
#define STORE_NEWSGRP   "newsgrp"
#define STORE_QUOTA     "quota"
#define STORE_SMTP      "smtp"
#define STORE_TASKS     "tasks"
#define STORE_TEMPOBJ   "tempobj"
#define STORE_FORWARD   "forward"
#define STORE_SERVERS   "servers"

#define PSTAT(i) PSTAT_NAMES[(i+3)]
#define OID_BITS 28

#endif





