/* Copyright (C) 2000-2004  Thomas Bopp, Thorsten Hampel, Ludger Merkens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * $Id: loader.pike,v 1.2 2005/09/21 23:01:10 exodusd Exp $
 */

constant cvs_version="$Id: loader.pike,v 1.2 2005/09/21 23:01:10 exodusd Exp $";


#include <configure.h>

mapping env = ([
    "LD_LIBRARY_PATH":getcwd()+"/server/libraries:/usr/local/lib",
    ]);



string     pidfile;
Stdio.File outfile;
Stdio.File errfile;
int   run_once = 0;
int          t = 0;
string     gdb = 0;
string      logdir;

mapping    mServices;
mapping mServiceLogs;

object start_service(string service, string ticket) 
{
  array(string) runArr =  
  ({ "./steam", "--include-path=server/include",
     "--module-path=client", "--module-path=server/libraries", 
     "--program-path=server/" });
  Stdio.File serviceLog = Stdio.File(logdir + "/"+service + ".log", "wct");
  Stdio.File ipc = Stdio.File();

  if ( search(service, ".jar") > 0 ) {
    string java = "java";
    string java_home = getenv()["JAVA_HOME"];
    if ( stringp(java_home) )
      java = java_home + "/bin/java";
    runArr = ({ java, "-Djava.awt.headless=true", "-jar" });
  }
  serviceLog->write("Starting service with ticket %s\n", ticket);
  mServiceLogs[service] = serviceLog;
  return Process.create_process( runArr + ({ "services/"+service, ticket }),
				 ([ "env": getenv(),
				    "cwd": getcwd(),
				    "stdout": serviceLog,
				    "stderr": serviceLog,
				 ]));
}

void start_services()
{
  mServices = ([ ]);
  mServiceLogs = ([ ]);
  
  array dir = get_dir("services");
  write("Starting services: ");
  if ( arrayp(dir) ) {
    foreach(dir, string service) {
      if ( !Stdio.is_file("services/"+service) )
	continue;
      if ( search(service, "~") >= 0 || search(service, "CVS") >= 0 )
	continue;
      write(" " + service + ", ");
      mServices[service] = 1;
    }
  }
  write("\n");
  thread_create(check_services);
}

void check_services() 
{
  string ticket;

  while ( !stringp(ticket) ) {
    sleep(20);
    catch(ticket = Stdio.read_file("service.pass"));
  }
  
  catch(rm("service.pass"));
  

  while ( 1 ) {
    foreach(indices(mServices), string service) {
      if ( !objectp(mServices[service]) || mServices[service]->status() > 0 ) {
	mixed err = catch(mServices[service] = start_service(service, ticket));
	if ( err ) {
	    mServiceLogs[service]->write("Failed to start service %s\n%O\n",
					 service, err);
	}
	else {
	  if ( !mServices[service] )
	      mServiceLogs[service]->write(
		  "Fatal Error - failed to start service %s.\n", service);
	  else {
	      mServiceLogs[service]->write("PID: %d\n", 
					   mServices[service]->pid());
	      Stdio.append_file(pidfile, " " + mServices[service]->pid());
	  }
	}
      }
    }
    sleep(60);
  }
}

//! run the server
void run(array(string) params)
{
    int ret = 0;
    Stdio.File exitF;
    array(string) runArr =  
	    ({ "./steam", "--include-path=server/include",
               "--module-path=server/libraries", 
               "--program-path=server", "server/server.pike" }) + params[1..];
    if ( stringp(gdb) ) {
        runArr = ({ "gdb", "steam", "-x", "gdb.run" });
        Stdio.File gdb_file = Stdio.File("gdb.run", "wct");
        gdb_file->write(gdb);
        gdb_file->write((params[1..]*" ")+"\n");
        gdb_file->close();
    }

    rm(logdir+"/exit");
    while ( ret != 1 && ret != -1 && ret != 10 ) {
	write("\nCWD: " + getcwd() + " - Starting sTeam Server\n");
	write("------------------------------------------------------\n");
	write("Logfile: "+ sprintf("%O", outfile)+"\n");
	write("LogDir:  "+logdir+"\n");
	write("Params:  "+sprintf("%O", params[1..])+"\n");
	start_services();
	ret = Process.create_process( runArr,
	    ([ "env": getenv() + env,
	       "cwd": getcwd(),
               "stdout": outfile,
               "stderr": errfile,
	     ]))->wait();
	write("Returned: "+  ret+"\n");
        if ( ret > 0 ) {
            exitF = Stdio.File(logdir+"/exit", "wct");
            exitF->write("Server exited with error...\n");
            exitF->close();
        }
	if ( stringp(gdb) )
	    ret = 1;
	outfile->close();
	errfile->close();
	mv(logdir + "/server_4.log", logdir+"/server_5.log");
	mv(logdir + "/server_3.log", logdir+"/server_4.log");
	mv(logdir + "/server_2.log", logdir+"/server_3.log");
	mv(logdir + "/server_1.log", logdir+"/server_2.log");

	mv(logdir + "/server.log", logdir+"/server_1.log");

	mv(logdir + "/errors_4.log", logdir+"/errors_5.log");
	mv(logdir + "/errors_3.log", logdir+"/errors_4.log");
	mv(logdir + "/errors_2.log", logdir+"/errors_3.log");
	mv(logdir + "/errors_1.log", logdir+"/errors_2.log");

	mv(logdir + "/errors.log", logdir+"/errors_1.log");

	outfile = Stdio.File(logdir+"/server.log", "wct");
	errfile = Stdio.File(logdir+"/errors.log", "wct");
    }
    werror("sTeam Server Exited !\n");
    rm(pidfile);
    exit(ret);
}
    
void got_kill(int sig)
{
    werror("Server killed !\n");
    object f = Stdio.File(pidfile,"r");
    string pid = f->read();
    f->close();
    array pids = pid / " ";
    foreach ( pids, string p ) {
	if ( (int)p != getpid() ) {
	    werror("Killing: " + p + "\n");
	    kill((int)p, signum("QUIT"));
	}
    }
}

void got_hangup(int sig)
{
    if ( run_once )
        got_kill(sig);
}

int 
main(int argc, array(string) argv)
{
    int pid = getpid();
    
    signal(signum("QUIT"), got_kill);
    signal(signum("TERM"), got_kill);
    signal(signum("SIGHUP"), got_hangup);
    signal(signum("SIGINT"), got_hangup);

    pidfile = getcwd() + "/steam.pid";    
    logdir = LOG_DIR;
    foreach(argv, string p) {
	string a,b;
	if ( sscanf(p, "--%s=%s", a, b) == 2 ) {
	    switch( a ) {
	    case "pid":
		pidfile = b;
		break;
            case "stdout":
                outfile = Stdio.File(b, "wct"); 
		logdir="logs";
                break;
	    case "stderr":
                errfile = Stdio.File(b, "wct"); 
		break;
	    case "logdir":
		outfile = Stdio.File(b + "/server.log", "wct");
                errfile = Stdio.File(b + "/errors.log", "wct"); 
		logdir = b;
		break;
	    case "pidfile":
	      pidfile = b;
	      break;
	    }
	}
        if ( p == "--once" ) {
            outfile = Stdio.stdout;
	    errfile = Stdio.stderr;
            run_once = 1;
        }
        else if ( p == "--gdb" ) {
            gdb = "run -I server/include -M server/libraries -P server "+
                  "server/server.pike ";
	    outfile = Stdio.stdout;
	}	
    }

    if ( !objectp(errfile) )
      errfile = Stdio.File(logdir+"/errors.log", "wct");

    if ( !objectp(outfile) ) {
        outfile = Stdio.File(logdir+"/server.log", "wct");
	logdir = LOG_DIR;
    }

    Stdio.File f;
    f=Stdio.File (pidfile,"cwt");
    f->write((string)pid);
    f->close;
    thread_create(run, argv);
    return -17;
}
 
