package net.sf.statcvs.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.CommitScatterChartMaker;
import net.sf.statcvs.charts.ModifyAddChartMaker;
import net.sf.statcvs.charts.LOCChartMaker.AllDevelopersLOCChartMaker;
import net.sf.statcvs.charts.TimeBarChartMaker.HourBarChartMaker;
import net.sf.statcvs.charts.TimeBarChartMaker.WeekdayBarChartMaker;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.reports.DevelopersOfTheMonthTable;
import net.sf.statcvs.reports.DevelopersTableReport;

/**
 * @author anja
 * @author Richard Cyganiak (richard@cyganiak.de)
 * @version $Id: AllDevelopersPageMaker.java,v 1.12 2008/04/02 11:22:14 benoitx Exp $
 */
public class AllDevelopersPageMaker {
    private final ReportConfig config;

    public AllDevelopersPageMaker(final ReportConfig config) {
        this.config = config;
    }

    public NavigationNode toFile() {
        final DevelopersTableReport developers = new DevelopersTableReport(this.config);

        final Page page = this.config.createPage("developers", "Developers", this.config.getProjectName() + " Developers");
        if (developers.getDeveloperCount() > 1) {
            page.addAttribute("Number of Developers", developers.getDeveloperCount());
            page.add(developers);
            page.addRawContent(getOtherLoginsLinks());
            page.addSection("Lines of Code");
            final ChartImage allAuthorsLOCChart = new AllDevelopersLOCChartMaker(this.config, this.config.getLargeChartSize()).toFile();
            page.add(allAuthorsLOCChart);
        }

        final ChartImage hoursChart = new HourBarChartMaker(this.config, this.config.getRepository().getRevisions(), "Activity by Hour of Day",
                "activity_time.png").toFile();
        final ChartImage weekdaysChart = new WeekdayBarChartMaker(this.config, this.config.getRepository().getRevisions(), "Activity by Day of Week",
                "activity_day.png").toFile();
        final ChartImage scatterChart = new CommitScatterChartMaker(this.config, this.config.getLargeChartSize().width).toFile();
        final ChartImage modifyAddChart = new ModifyAddChartMaker(this.config, this.config.getSmallChartSize().width).toFile();

        final DevelopersOfTheMonthTable developerOfTheMonth = new DevelopersOfTheMonthTable(this.config);
        page.addSection("Developer of the Month");
        page.add(developerOfTheMonth);

        page.addSection("Developer Activity");
        page.add(scatterChart);
        page.add(modifyAddChart);

        page.addSection("Activity by Clock Time");
        page.add(hoursChart);
        page.add(weekdaysChart);

        if (this.config.getRepository().getAuthors().size() >= 1) {
            final PageGroup developerPages = new PageGroup("Developers", false);
            final Iterator it = this.config.getRepository().getAuthors().iterator();
            while (it.hasNext()) {
                final Author developer = (Author) it.next();
                developerPages.add(new DeveloperPageMaker(this.config, developer).toFile());
            }
            page.addChild(developerPages);
        }

        return page;
    }

    private String getOtherLoginsLinks() {
        final List nonDeveloperLogins = new ArrayList();
        Iterator it = this.config.getRepository().getAuthors().iterator();
        while (it.hasNext()) {
            final Author author = (Author) it.next();
            if (!this.config.isDeveloper(author)) {
                nonDeveloperLogins.add(author);
            }
        }
        if (nonDeveloperLogins.isEmpty()) {
            return "";
        }
        Collections.sort(nonDeveloperLogins);
        final StringBuffer s = new StringBuffer("<p>\n  Other Logins:\n  ");
        it = nonDeveloperLogins.iterator();
        while (it.hasNext()) {
            final Author author = (Author) it.next();
            s.append(HTML.getLink(DeveloperPageMaker.getURL(author), author.getRealName()));
            if (it.hasNext()) {
                s.append(", \n  ");
            }
        }
        s.append("</p>\n");
        return s.toString();
    }
}
