/*
 * SourceHighlightExceptionBox.cpp
 *
 *  Created on: Jul 16, 2009
 *      Author: Lorenzo Bettini <http://www.lorenzobettini.it>, (C) 2008
 *  Copyright: See COPYING file that comes with this distribution
 */

#include "SourceHighlightExceptionBox.h"

#include <srchilite/parserexception.h>

#include <QMessageBox>
#include <QObject>

#include <sstream>

namespace srchiliteqt {

void SourceHighlightExceptionBox::showMessageBox(
        const srchilite::ParserException &e, QWidget *parent) {
    std::ostringstream details;
    details << e;
    QMessageBox::warning(
            parent,
            QObject::tr("QSource-Highlight"),
            QObject::tr(
                    "Exception from Source-Highlight library:\n%1\n\ndetails: %2.") .arg(
                    e.what()).arg(details.str().c_str()));
}

void SourceHighlightExceptionBox::showMessageBox(const std::exception &e,
        QWidget *parent) {
    QMessageBox::warning(parent, QObject::tr("QSource-Highlight"), QObject::tr(
            "Exception from Source-Highlight library:\n%1.") .arg(e.what()));
}

}
