#include "StyleComboBox.h"
#include <srchilite/sourcehighlightutils.h>

namespace srchiliteqt {

StyleComboBox::StyleComboBox()
{
    srchilite::StringSet styleFiles = srchilite::SourceHighlightUtils::getStyleFileNames();
    for (srchilite::StringSet::const_iterator it = styleFiles.begin(); it != styleFiles.end(); ++it) {
        addItem(QString((*it).c_str()));
    }

    // a separator before .css files
    insertSeparator(count()+1);

    styleFiles = srchilite::SourceHighlightUtils::getCssStyleFileNames();
    for (srchilite::StringSet::const_iterator it = styleFiles.begin(); it != styleFiles.end(); ++it) {
        addItem(QString((*it).c_str()));
    }
}

void StyleComboBox::setCurrentStyle(const QString &styleFile) {
    int item = findText(styleFile);
    if (item != -1)
        setCurrentIndex(item);
}

const QString StyleComboBox::getCurrentStyle() const {
    return currentText();
}

}
