# Songwrite
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software. See README or LICENSE for the license terms.

PITCHS = {
  "C"  :  0,
  "D"  :  2,
  "E"  :  4,
  "F"  :  5,
  "G"  :  7,
  "A"  :  9,
  "B"  : 11,
  }

class MelodyNotePlacer:
  def __init__(self):
    self.pos = 1.0
    
  def __call__(self, note):
    if not note.time: note.time = self.pos
    self.pos = note.time + note.duration
    
class ChordNotePlacer:
  def __init__(self):
    self.pos = 1.0
    
  def __call__(self, note):
    if not note.time: note.time = self.pos
    else:             self.pos = note.time
    
class ComplexNotePlacer:
  def __init__(self, follow):
    self.pos    = 1.0
    try: self.offset = float(follow)
    except:
      a, b = follow.split("/")
      self.offset = a / b
      
  def __call__(self, note):
    if not note.time: note.time = self.pos
    self.pos = note.time + note.duration + self.offset
    
    
class Parser:
  def __init__(self):
    self.pitch    = 0
    self.octavo   = 48
    self.duration = 1.0
    self.volume   = 64
    
    self.parsers = {
      "pitch"    : self.parse_pitch,
      "duration" : self.parse_duration,
      "start"    : self.parse_start,
      }
    
  def parse_pitch(self, attr, pitch):
    try: self.cur_note.value = int(pitch)
    except:
      if ":" in pitch:
        pitch, octavo = pitch.split(":")
        self.octavo = octavo * 12
        
      self.pitch = PITCHS[pitch[0]]
      if len(pitch) > 1:
        if   pitch[1] == "#": self.pitch += 1
        elif pitch[1] == "b": self.pitch -= 1
      self.cur_note.value = self.pitch + self.octavo
      
  def parse_duration(self, attr, duration):
    try: self.cur_note.duration = float(duration)
    except:
      a, b = duration.split("/")
      self.cur_note.duration = a / b
      
  def parse_duration(self, attr, start):
    self.cur_note.time = float(start)
    
  def parse_other(self, attr, value):
    setattr(self.cur_note, attr, value)
    
