#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by SmartEiffel The GNU Eiffel Compiler, Eiffel tools and libraries
Release 2.3 (???? February ??th 2007) [Antoine-Auguste Parmentier]
Copyright (C), 1994-2002 - INRIA - LORIA - ESIAL UHP Nancy 1 - FRANCE
Copyright (C), 2003-2005 - INRIA - LORIA - IUT Charlemagne Nancy 2 - FRANCE
D.COLNET, P.RIBET, C.ADRIAN, V.CROIZIER F.MERIZEN - SmartEiffel@loria.fr
http://SmartEiffel.loria.fr
C Compiler options used: -pipe -g
*/

/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
/*
  This file (SmartEiffel/sys/runtime/base.h) contains all basic Eiffel
  type definitions.
  This file is automatically included in the header for all modes of
  compilation: -boost, -no_check, -require_check, -ensure_check, ...
  This file is also included in the header of any cecil file (when the
  -cecil option is used).
  This file is also included in the header file of C++ wrappers (when
  using the external "C++" clause).
*/

#ifndef _BASE_H
#define _BASE_H

#if defined(_MSC_VER) && (_MSC_VER >= 1400)       /* VC8+ */
# ifndef _CRT_SECURE_NO_DEPRECATE
#  define _CRT_SECURE_NO_DEPRECATE
# endif
# ifndef _CRT_NONSTDC_NO_DEPRECATE
#  define _CRT_NONSTDC_NO_DEPRECATE
# endif
#endif   /* VC8+ */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
#  include <unistd.h>
#endif
#if !defined(WIN32) && \
       (defined(WINVER) || defined(_WIN32_WINNT) || defined(_WIN32) || \
	defined(__WIN32__) || defined(__TOS_WIN__) || defined(_MSC_VER))
#  define WIN32 1
#endif
#ifdef WIN32
#  include <windows.h>
#else
#  ifndef O_RDONLY
#    include <sys/file.h>
#  endif
#  ifndef O_RDONLY
#    define O_RDONLY 0000
#  endif
#endif

#if defined(_MSC_VER) && (_MSC_VER < 1500) /* MSVC older than v9 */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "d"
#  define PRId64 "I64d"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c
#  define INT64_C(c) c ## i64
#elif defined(__WATCOMC__) && (__WATCOMC__ <= 1220) /* WATCOM 12.2 or lower */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "d"
#  define PRId64 "Ld"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## i64
#elif defined(__BORLANDC__) && (__BORLANDC__ < 0x600) /* Borland before 6.0 */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "ld"
#  define PRId64 "I64Ld"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## i64
#elif defined(__FreeBSD__) && (__FreeBSD__ < 5) /* FreeBSD before 5.0 */ && !defined (_SYS_INTTYPES_H_)
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed long long int int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned long long int uint64_t;
#elif defined(__CYGWIN__) && defined(__BIT_TYPES_DEFINED__) /* Cygwin defines intxx_t in sys/types.h instead of inttypes.h */
#  include <cygwin/version.h>
#  if defined(CYGWIN_VERSION_DLL_MAJOR) && (CYGWIN_VERSION_DLL_MAJOR<1005)
typedef unsigned char uint8_t;
typedef __uint16_t uint16_t;
typedef __uint32_t uint32_t;
typedef __uint64_t uint64_t;
#  endif
#elif defined(SASC)
#    error("Too old SAS/C compiler, sorry.");
#elif defined(__SASC__)
#  if (__SASC__ < 750 ) /*  SAS/C before 7.50 */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed long long int int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned long long int uint64_t;
#  endif
#else
#  include <inttypes.h>
#  if !defined(INT8_MAX) && defined(INT16_MAX)
/* int8_t is not mandatory */
typedef int_least8_t int8_t;
#  endif
#endif

#if !defined(PRId16)
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "ld"
#  define PRId64 "lld"
#elif !defined(PRId8)
#  define PRId8 "d"
#endif
#if !defined(INT16_C)
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## LL
#elif !defined(INT8_C)
#  define INT8_C(c) c
#endif
#if !defined(INT16_MIN)
#  define INT8_MIN (-INT8_C(127)-1)
#  define INT8_MAX (INT8_C(127))
#  define INT16_MIN (-INT16_C(32767)-1)
#  define INT16_MAX (INT16_C(32767))
#  define INT32_MIN (-INT32_C(2147483647)-1)
#  define INT32_MAX (INT32_C(2147483647))
#  define INT64_MIN (-INT64_C(9223372036854775807)-1)
#  define INT64_MAX (INT64_C(9223372036854775807))
#elif !defined(INT8_MIN)
#  define INT8_MIN (-INT8_C(127)-1)
#endif


/*
  Endian stuff
*/
#if defined(BSD) && (BSD >= 199103)
#  include <machine/endian.h>
#elif defined(__alpha__) || defined(__alpha) || defined(_M_ALPHA)
/* bi-endian processor, current mode should be find in machine/endian.h file */
#  include <machine/endian.h>
#elif defined(linux)
#  include <endian.h>
#endif



#if !defined(BYTE_ORDER) && defined(__BYTE_ORDER)
#  define BYTE_ORDER      __BYTE_ORDER
#endif

#if !defined(LITTLE_ENDIAN) && defined(__LITTLE_ENDIAN)
#  define LITTLE_ENDIAN      __LITTLE_ENDIAN
#endif

#if !defined(BIG_ENDIAN) && defined(__BIG_ENDIAN)
#  define BIG_ENDIAN      __BIG_ENDIAN
#endif

#if !defined(LITTLE_ENDIAN)
#  define LITTLE_ENDIAN   1234    /* LSB first (vax, pc) */
#endif
#if !defined(BIG_ENDIAN)
#  define BIG_ENDIAN      4321    /* MSB first (IBM, net) */
#endif
#if !defined(PDP_ENDIAN)
#  define PDP_ENDIAN      3412    /* LSB first in word, MSW first in long */
#endif

#if !defined(BYTE_ORDER) && defined(BIT_ZERO_ON_RIGHT)
#  define BYTE_ORDER      LITTLE_ENDIAN
#elif !defined(BYTE_ORDER) && defined(BIT_ZERO_ON_LEFT)
#  define BYTE_ORDER      BIG_ENDIAN
#elif !defined(BYTE_ORDER)

/* ARM */
#  if defined(__ARMEL__)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  elif defined(__ARMEB__)
#    define BYTE_ORDER      BIG_ENDIAN
#  elif defined(__arm__)
#    error "ARMs are bi-endian processors. Endianness is unknown for this system, please drop an e-mail to SmartEiffel@loria.fr"
#  endif

/* HP RISC */
#  if defined(__hppa__) || defined(__hppa) || defined(__hp9000) || \
      defined(__hp9000s300) || defined(hp9000s300) || \
      defined(__hp9000s700) || defined(hp9000s700) || \
      defined(__hp9000s800) || defined(hp9000s800) || defined(hp9000s820)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* IBM */
#  if defined(ibm032) || defined(ibm370) || defined(_IBMR2) || \
      defined(IBM370) || defined(__MVS__)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* Intel x86 */
#  if defined(i386) || defined(__i386__) || defined(__i386) || \
      defined(_M_IX86) || defined(_X86_) || defined(__THW_INTEL) || \
      defined(sun386)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Intel Itanium */
#  if defined(__ia64__) || defined(_IA64) || defined(__IA64__) || \
      defined(_M_IA64)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Nationnal Semiconductor 32000 serie */
#  if  defined(ns32000)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Motorola 68000 */
#  if defined(mc68000) || defined(is68k) || defined(macII) || defined(m68k)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* MIPS */
#  if defined(MIPSEL) || defined(_MIPSEL)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  elif defined(MIPSEB) || defined(_MIPSEB)
#    define BYTE_ORDER      BIG_ENDIAN
#  elif defined(__mips__) || defined(__mips) || defined(__MIPS__)
#    error "MIPS are bi-endian processors. Endianness is unknown for this system, please drop an e-mail to SmartEiffel@loria.fr"
#  endif

/* Power PC */
/* this processor is bi-endian, how to know if little-endian is set? */
#  if defined(__powerpc) || defined(__powerpc__) || defined(__POWERPC__) || \
      defined(__ppc__) || defined(__ppc) || defined(_M_PPC) || \
      defined(__PPC) || defined(__PPC__)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* Pyramid 9810 */
#  if defined(pyr)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* RS/6000 */
#  if defined(__THW_RS6000) || defined(_IBMR2) || defined(_POWER) || \
      defined(_ARCH_PWR) || defined(_ARCH_PWR2)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* SPARC */
#  if defined(__sparc__) || defined(sparc) || defined(__sparc)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* CCI Tahoe */
#  if defined(tahoe)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* VAX */
#  if defined(vax) || defined(VAX) || defined(__vax__) || defined(_vax_) || \
      defined(__vax) || defined(__VAX)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* ELATE is a virtual OS with a little endian Virtual Processor */
#  if defined(__ELATE__)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Miscellaneous little endian */
#  if defined(wrltitan)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Miscellaneous big endian */
#  if defined(apollo) || defined(__convex__) || defined(_CRAY) || defined(sel)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif
#endif


#if !defined(BYTE_ORDER)
#  error "Unknown byte order. Add your system in above macros once you know your system type. Please drop an e-mail to SmartEiffel@loria.fr"
#endif
#if (BYTE_ORDER != BIG_ENDIAN && BYTE_ORDER != LITTLE_ENDIAN)
#  error "Only little-endian and big-endian are valid at this time. Please drop an e-mail to SmartEiffel@loria.fr"
#endif


/*
  Byte swapping stuff
*/
extern void copy_swap_16(const uint16_t *src, uint16_t *dest, int count);


/* Because ANSI C EXIT_* are not always defined: */
#ifndef EXIT_FAILURE
#  define EXIT_FAILURE 1
#endif
#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS 0
#endif

/*
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.

   NOTE: with gcc, -ansi is used for SmartEiffel generated files EXCEPT in
   -no_split mode. ANSI only recognizes the non-sig versions.
*/
#if (defined(_SIGSET_H_types) && !defined(__STRICT_ANSI__))
#  define JMP_BUF    sigjmp_buf
#  define SETJMP(x)  sigsetjmp( (x), 1)
#  define LONGJMP    siglongjmp
#else
#  define JMP_BUF    jmp_buf
#  define SETJMP(x)  setjmp( (x) )
#  define LONGJMP    longjmp
#endif

/*
   Type to store reference objects Id:
 */
typedef int Tid;
typedef struct S0 T0;
struct S0{Tid id;};

/*
   The default channel used to print runtime error messages:
*/
#define SE_ERR stderr

/*
   Eiffel type INTEGER_8 is #1:
*/
typedef int8_t T1;
#define EIF_INTEGER_8 T1
#define M1 (INT8_C(0))
#define EIF_INTEGER_8_BITS (CHAR_BIT)
#define EIF_MINIMUM_INTEGER_8 (INT8_MIN)
#define EIF_MAXIMUM_INTEGER_8 (INT8_MAX)

/*
  Eiffel type INTEGER_16 is #10:
*/
typedef int16_t T10;
#define EIF_INTEGER_16 T10
#define M10 (INT16_C(0))
#define EIF_INTEGER_16_BITS (CHAR_BIT*sizeof(T10t))
#define EIF_MINIMUM_INTEGER_16 (INT16_MIN) /*-32768*/
#define EIF_MAXIMUM_INTEGER_16 (INT16_MAX) /*+32767*/

/*
  Eiffel type INTEGER or INTEGER_32 is #2:
*/
typedef int32_t T2;
#define EIF_INTEGER T2
#define EIF_INTEGER_32 T2
#define M2 (INT32_C(0))
#define EIF_INTEGER_BITS ((T2)(CHAR_BIT*sizeof(T2)))
#define EIF_INTEGER_32_BITS EIF_INTEGER_BITS
#define EIF_MINIMUM_INTEGER (INT32_MIN)
#define EIF_MAXIMUM_INTEGER (INT32_MAX)

/*
  Eiffel type INTEGER_64 is #11:
*/
typedef int64_t T11;
#define EIF_INTEGER_64 T11
#define M11 (INT64_C(0))
#define EIF_INTEGER_64_BITS (CHAR_BIT*sizeof(T11))
#define EIF_MINIMUM_INTEGER_64 (INT64_MIN)
#define EIF_MAXIMUM_INTEGER_64 (INT64_MAX)

/*
  Eiffel type CHARACTER is #3:
*/
typedef unsigned char T3;
#define EIF_CHARACTER T3
#define M3 (0)
#define EIF_CHARACTER_BITS (CHAR_BIT)
#define EIF_MINIMUM_CHARACTER_CODE (0)
#define EIF_MAXIMUM_CHARACTER_CODE (255)
#define T3code(x) ((T10)(x))
#define T3to_integer(x) ((signed char)(x))
#define T3to_integer_8(x) ((signed char)(x))
#define T3to_bit(x) (x)

/*
  Eiffel type REAL_32 is #4:
*/
typedef float T4;
typedef T4 real32_t;
#define EIF_REAL_32 T4
#define M4 (0.0)
#define EIF_MINIMUM_REAL_32 (-(FLT_MAX))
#define EIF_MAXIMUM_REAL_32 (FLT_MAX)

/*
  Eiffel type REAL or REAL_64 is #5:
*/
typedef double T5;
typedef T5 real64_t;
#define EIF_REAL_64 T5
#define M5 (0.0)
#define EIF_MINIMUM_REAL_64 (-(DBL_MAX))
#define EIF_MINIMUM_REAL (EIF_MINIMUM_REAL_64)
#define EIF_MAXIMUM_REAL_64 (DBL_MAX)
#define EIF_MAXIMUM_REAL (EIF_MAXIMUM_REAL_64)

/*
  Eiffel type REAL_EXTENDED is #12:
*/
typedef long double T12;
typedef T12 real_extended_t;
#define EIF_REAL_EXTENDED T12
#define M12 (0.0)
#define EIF_MINIMUM_REAL_EXTENDED (-(DBL_MAX))
#define EIF_MAXIMUM_REAL_EXTENDED (DBL_MAX)

/*
  Eiffel type BOOLEAN is #6:
*/
typedef char T6;
#define EIF_BOOLEAN T6
#define M6 (0)
#define EIF_BOOLEAN_BITS (CHAR_BIT)

/*
   Eiffel type POINTER is #8:
*/
typedef void* T8;
#define EIF_POINTER T8
/* Sometimes, NULL is defined as 0 */
#define M8 ((void*)NULL)
#define EIF_POINTER_BITS (CHAR_BIT*sizeof(void*))

/*
  To use type STRING on the C side:
*/
#define EIF_STRING T7*

/*
  Some Other EIF_* defined in ETL:
*/
#define eif_access(x) ((char*)(x))
#define EIF_REFERENCE T0*
#define EIF_OBJ T0*
#define EIF_OBJECT EIF_OBJ

/*
   Wrappers for `malloc' and `calloc':
*/
void* se_malloc(size_t size);
void* se_calloc(size_t nmemb, size_t size);
void* se_realloc(void* src, size_t size);

/*
   die method.
 */
void se_die(int code);

/*
    Runtime hooks. They allow different runtime modules to be quite independant. In time, they will also allow
    thread-safe operations.

    Currently known modules:
      - boost
      - no_check
      - sedb
      - gc
      - profile
      - scoop
      - plugins

    However, currently only profile uses this method. It will be extended to other modules later.

    The currently defined hooks are described in the enum below (the names should be self-explanatory).
 */
typedef enum {
  SE_HANDLE_EXCEPTION_SET, /* called when an exception handler is set, prior to SETJMP */
  SE_HANDLE_EXCEPTION_CLEAR, /* called when a feature with an exception handler normally returns */
  SE_HANDLE_EXCEPTION_THROWN, /* called when an exception is thrown, prior to the LONGJMP */
  SE_HANDLE_ENTER_GC, /* called when gc_start() begins */
  SE_HANDLE_EXIT_GC, /* called when gc_start() ends */
  SE_HANDLE_NO_MORE_MEMORY, /* called by se_alloc() and co */
  SE_HANDLE_SEDB_BREAK, /* called when sedb stops the program */
  SE_HANDLE_SEDB_CONTINUE, /* called when sedb continues the program */
  SE_HANDLE_RUNTIME_ERROR, /* called when a runtime error is raised and not caught by an exception. Cannot be raised in boost mode. */
  SE_HANDLE_DIE_WITH_CODE, /* called when the program is stopped by the die_with_code feature. The data points to the int code. */
  SE_HANDLE_NORMAL_EXIT /* called when the program correctly terminates. The data is null. */
} se_handler_action_t;

extern int handlers_count;
typedef void se_runtime_handler_t(se_handler_action_t action, void*data);
void register_handler(se_runtime_handler_t*handler);
void _handle(se_handler_action_t action, void*data);

#define handle(action,data) do{if(handlers_count>0)_handle(action,data);}while(0)

#endif /* #ifndef _BASE_H */
#define SE_BOOST 1
/* C Header Pass 1: */
typedef union _se_agent se_agent;
typedef struct _se_agent0 se_agent0;
typedef struct S292 T292;
typedef struct S480 T480;
typedef struct S1151 T1151;
typedef struct S1150 T1150;
typedef struct S481 T481;
typedef struct S493 T493;
typedef struct S1132 T1132;
typedef struct S359 T359;
typedef struct S1142 T1142;
typedef int T1141;
typedef struct S1140 T1140;
typedef struct S380 T380;
typedef struct S1139 T1139;
typedef struct S1138 T1138;
typedef struct S426 T426;
typedef struct S288 T288;
typedef struct S1137 T1137;
typedef struct S1136 T1136;
typedef struct S1135 T1135;
typedef int T499;
typedef struct S1134 T1134;
typedef struct S492 T492;
typedef struct S491 T491;
typedef struct S490 T490;
typedef struct S489 T489;
typedef struct S488 T488;
typedef struct S487 T487;
typedef struct S486 T486;
typedef struct S1133 T1133;
typedef int T1130;
typedef T0 T1128;
typedef struct S1126 T1126;
typedef struct S503 T503;
typedef struct S701 T701;
typedef struct S1125 T1125;
typedef struct S1124 T1124;
typedef struct S1122 T1122;
typedef struct S1121 T1121;
typedef struct S1110 T1110;
typedef struct S1100 T1100;
typedef struct S1117 T1117;
typedef struct S1116 T1116;
typedef struct S1113 T1113;
typedef struct S1112 T1112;
typedef struct S1111 T1111;
typedef struct S1109 T1109;
typedef struct S1102 T1102;
typedef struct S1101 T1101;
typedef struct S1099 T1099;
typedef struct S1106 T1106;
typedef struct S1105 T1105;
typedef struct S553 T553;
typedef struct S415 T415;
typedef struct S1096 T1096;
typedef struct S1095 T1095;
typedef struct S1069 T1069;
typedef int T1092;
typedef struct S516 T516;
typedef struct S685 T685;
typedef struct S1081 T1081;
typedef struct S1080 T1080;
typedef struct S1090 T1090;
typedef struct S1089 T1089;
typedef struct S1087 T1087;
typedef struct S1086 T1086;
typedef struct S1084 T1084;
typedef struct S1083 T1083;
typedef struct S421 T421;
typedef struct S428 T428;
typedef struct S1076 T1076;
typedef struct S472 T472;
typedef struct S285 T285;
typedef struct S1074 T1074;
typedef struct S1073 T1073;
typedef struct S1072 T1072;
typedef struct S681 T681;
typedef struct S680 T680;
typedef struct S679 T679;
typedef struct S677 T677;
typedef struct S1068 T1068;
typedef struct S1067 T1067;
typedef struct S626 T626;
typedef struct S479 T479;
typedef struct S614 T614;
typedef struct S1066 T1066;
typedef struct S624 T624;
typedef struct S383 T383;
typedef struct S87 T87;
typedef struct S1057 T1057;
typedef struct S475 T475;
typedef struct S627 T627;
typedef struct S445 T445;
typedef struct S556 T556;
typedef struct S457 T457;
typedef struct S1058 T1058;
typedef struct S226 T226;
typedef struct S623 T623;
typedef struct S615 T615;
typedef struct S1064 T1064;
typedef struct S1063 T1063;
typedef struct S1059 T1059;
typedef struct S625 T625;
typedef struct S1052 T1052;
typedef struct S1051 T1051;
typedef int T1049;
typedef struct S450 T450;
typedef struct S1047 T1047;
typedef struct S1046 T1046;
typedef struct S597 T597;
typedef struct S441 T441;
typedef struct S1045 T1045;
typedef struct S381 T381;
typedef void*T221;
typedef struct S470 T470;
typedef struct S412 T412;
typedef struct S1044 T1044;
typedef struct S1043 T1043;
typedef struct S1042 T1042;
typedef struct S1040 T1040;
typedef struct S1039 T1039;
typedef struct S1037 T1037;
typedef struct S1159 T1159;
typedef struct S1036 T1036;
typedef struct S1035 T1035;
typedef struct S322 T322;
typedef struct S1033 T1033;
typedef struct S1032 T1032;
typedef struct S1030 T1030;
typedef struct S1029 T1029;
typedef struct S242 T242;
typedef struct S1158 T1158;
typedef struct S593 T593;
typedef struct S592 T592;
typedef struct S591 T591;
typedef struct S596 T596;
typedef struct S595 T595;
typedef struct S594 T594;
typedef struct S1026 T1026;
typedef struct S1025 T1025;
typedef struct S1023 T1023;
typedef struct S1021 T1021;
typedef struct S1020 T1020;
typedef struct S1017 T1017;
typedef struct S1016 T1016;
typedef struct S618 T618;
typedef struct S1013 T1013;
typedef struct S1012 T1012;
typedef struct S548 T548;
typedef struct S549 T549;
typedef struct S547 T547;
typedef struct S1007 T1007;
typedef struct S1006 T1006;
typedef struct S1004 T1004;
typedef struct S1003 T1003;
typedef struct S1001 T1001;
typedef struct S1000 T1000;
typedef struct S998 T998;
typedef struct S387 T387;
typedef struct S476 T476;
typedef struct S77 T77;
typedef struct S245 T245;
typedef struct S521 T521;
typedef struct S989 T989;
typedef struct S988 T988;
typedef struct S986 T986;
typedef struct S985 T985;
typedef struct S983 T983;
typedef struct S982 T982;
typedef struct S980 T980;
typedef struct S294 T294;
typedef struct S978 T978;
typedef struct S977 T977;
typedef struct S975 T975;
typedef struct S974 T974;
typedef struct S1156 T1156;
typedef struct S314 T314;
typedef struct S970 T970;
typedef struct S969 T969;
typedef struct S968 T968;
typedef struct S966 T966;
typedef struct S965 T965;
typedef struct S964 T964;
typedef struct S432 T432;
typedef struct S961 T961;
typedef struct S960 T960;
typedef struct S958 T958;
typedef struct S957 T957;
typedef struct S956 T956;
typedef struct S954 T954;
typedef struct S952 T952;
typedef struct S805 T805;
typedef struct S950 T950;
typedef struct S949 T949;
typedef struct S947 T947;
typedef struct S946 T946;
typedef struct S944 T944;
typedef struct S943 T943;
typedef struct S941 T941;
typedef struct S940 T940;
typedef struct S938 T938;
typedef struct S937 T937;
typedef struct S935 T935;
typedef struct S934 T934;
typedef struct S67 T67;
typedef struct S931 T931;
typedef struct S930 T930;
typedef struct S929 T929;
typedef struct S926 T926;
typedef struct S924 T924;
typedef struct S802 T802;
typedef struct S911 T911;
typedef struct S910 T910;
typedef struct S921 T921;
typedef struct S920 T920;
typedef struct S500 T500;
typedef struct S917 T917;
typedef struct S916 T916;
typedef struct S914 T914;
typedef struct S913 T913;
typedef struct S908 T908;
typedef struct S906 T906;
typedef struct S905 T905;
typedef struct S898 T898;
typedef struct S903 T903;
typedef struct S902 T902;
typedef struct S900 T900;
typedef struct S899 T899;
typedef struct S897 T897;
typedef struct S896 T896;
typedef struct S73 T73;
typedef struct S892 T892;
typedef struct S889 T889;
typedef struct S888 T888;
typedef struct S862 T862;
typedef struct S861 T861;
typedef struct S859 T859;
typedef struct S858 T858;
typedef struct S886 T886;
typedef struct S546 T546;
typedef struct S884 T884;
typedef struct S324 T324;
typedef struct S76 T76;
typedef struct S494 T494;
typedef struct S498 T498;
typedef struct S879 T879;
typedef struct S877 T877;
typedef struct S628 T628;
typedef struct S315 T315;
typedef struct S875 T875;
typedef struct S555 T555;
typedef struct S874 T874;
typedef struct S631 T631;
typedef struct S873 T873;
typedef struct S872 T872;
typedef struct S419 T419;
typedef struct S378 T378;
typedef struct S369 T369;
typedef struct S364 T364;
typedef struct S370 T370;
typedef struct S374 T374;
typedef struct S373 T373;
typedef struct S368 T368;
typedef struct S377 T377;
typedef struct S375 T375;
typedef struct S362 T362;
typedef struct S871 T871;
typedef struct S379 T379;
typedef struct S371 T371;
typedef struct S376 T376;
typedef struct S366 T366;
typedef struct S870 T870;
typedef struct S482 T482;
typedef struct S630 T630;
typedef struct S629 T629;
typedef struct S868 T868;
typedef struct S867 T867;
typedef struct S866 T866;
typedef struct S865 T865;
typedef struct S520 T520;
typedef struct S760 T760;
typedef struct S855 T855;
typedef struct S854 T854;
typedef struct S296 T296;
typedef struct S851 T851;
typedef struct S850 T850;
typedef struct S848 T848;
typedef struct S847 T847;
typedef struct S846 T846;
typedef struct S844 T844;
typedef struct S843 T843;
typedef struct S840 T840;
typedef struct S416 T416;
typedef struct S533 T533;
typedef struct S422 T422;
typedef struct S467 T467;
typedef struct S839 T839;
typedef struct S622 T622;
typedef struct S583 T583;
typedef struct S301 T301;
typedef struct S60 T60;
typedef struct S834 T834;
typedef struct S833 T833;
typedef struct S831 T831;
typedef struct S576 T576;
typedef int T830;
typedef struct S575 T575;
typedef struct S828 T828;
typedef struct S827 T827;
typedef struct S826 T826;
typedef struct S637 T637;
typedef struct S711 T711;
typedef struct S824 T824;
typedef struct S823 T823;
typedef struct S822 T822;
typedef struct S484 T484;
typedef struct S820 T820;
typedef struct S819 T819;
typedef struct S818 T818;
typedef struct S817 T817;
typedef struct S816 T816;
typedef struct S308 T308;
typedef struct S812 T812;
typedef struct S811 T811;
typedef struct S808 T808;
typedef struct S346 T346;
typedef struct S807 T807;
typedef struct S317 T317;
typedef struct S803 T803;
typedef struct S519 T519;
typedef struct S801 T801;
typedef struct S791 T791;
typedef struct S796 T796;
typedef struct S795 T795;
typedef struct S794 T794;
typedef struct S793 T793;
typedef struct S304 T304;
typedef struct S792 T792;
typedef struct S790 T790;
typedef struct S789 T789;
typedef struct S787 T787;
typedef struct S786 T786;
typedef struct S551 T551;
typedef struct S785 T785;
typedef struct S347 T347;
typedef struct S323 T323;
typedef struct S348 T348;
typedef struct S246 T246;
typedef struct S329 T329;
typedef struct S784 T784;
typedef struct S783 T783;
typedef struct S781 T781;
typedef struct S363 T363;
typedef struct S779 T779;
typedef struct S782 T782;
typedef struct S290 T290;
typedef struct S778 T778;
typedef struct S777 T777;
typedef struct S581 T581;
typedef struct S775 T775;
typedef struct S764 T764;
typedef struct S762 T762;
typedef struct S582 T582;
typedef struct S773 T773;
typedef struct S321 T321;
typedef struct S772 T772;
typedef struct S325 T325;
typedef struct S771 T771;
typedef struct S770 T770;
typedef struct S529 T529;
typedef struct S528 T528;
typedef struct S769 T769;
typedef struct S360 T360;
typedef struct S356 T356;
typedef struct S358 T358;
typedef struct S361 T361;
typedef struct S84 T84;
typedef struct S345 T345;
typedef struct S397 T397;
typedef struct S395 T395;
typedef struct S768 T768;
typedef struct S349 T349;
typedef struct S385 T385;
typedef struct S392 T392;
typedef struct S532 T532;
typedef struct S531 T531;
typedef struct S400 T400;
typedef struct S398 T398;
typedef struct S401 T401;
typedef struct S394 T394;
typedef struct S403 T403;
typedef struct S393 T393;
typedef struct S665 T665;
typedef struct S300 T300;
typedef struct S64 T64;
typedef struct S767 T767;
typedef struct S437 T437;
typedef struct S430 T430;
typedef struct S453 T453;
typedef struct S452 T452;
typedef struct S418 T418;
typedef struct S429 T429;
typedef struct S463 T463;
typedef struct S471 T471;
typedef struct S458 T458;
typedef struct S464 T464;
typedef struct S410 T410;
typedef struct S455 T455;
typedef struct S466 T466;
typedef struct S420 T420;
typedef struct S444 T444;
typedef struct S443 T443;
typedef struct S462 T462;
typedef struct S404 T404;
typedef struct S417 T417;
typedef struct S431 T431;
typedef struct S438 T438;
typedef struct S473 T473;
typedef struct S442 T442;
typedef struct S409 T409;
typedef struct S293 T293;
typedef struct S474 T474;
typedef struct S434 T434;
typedef struct S413 T413;
typedef struct S456 T456;
typedef struct S448 T448;
typedef struct S530 T530;
typedef struct S344 T344;
typedef struct S332 T332;
typedef struct S545 T545;
typedef struct S517 T517;
typedef struct S544 T544;
typedef struct S543 T543;
typedef struct S542 T542;
typedef struct S541 T541;
typedef struct S540 T540;
typedef struct S338 T338;
typedef struct S538 T538;
typedef struct S536 T536;
typedef struct S534 T534;
typedef struct S526 T526;
typedef struct S525 T525;
typedef struct S522 T522;
typedef struct S436 T436;
typedef struct S451 T451;
typedef struct S334 T334;
typedef struct S469 T469;
typedef struct S411 T411;
typedef struct S355 T355;
typedef struct S408 T408;
typedef struct S396 T396;
typedef struct S388 T388;
typedef struct S391 T391;
typedef struct S414 T414;
typedef struct S447 T447;
typedef struct S461 T461;
typedef struct S287 T287;
typedef struct S227 T227;
typedef struct S454 T454;
typedef struct S459 T459;
typedef struct S460 T460;
typedef struct S433 T433;
typedef struct S766 T766;
typedef struct S465 T465;
typedef struct S765 T765;
typedef struct S759 T759;
typedef struct S758 T758;
typedef struct S757 T757;
typedef struct S754 T754;
typedef struct S68 T68;
typedef struct S244 T244;
typedef struct S751 T751;
typedef struct S748 T748;
typedef int T573;
typedef struct S747 T747;
typedef int T744;
typedef struct S743 T743;
typedef struct S742 T742;
typedef struct S282 T282;
typedef struct S7 T7;
typedef struct S738 T738;
typedef struct S737 T737;
typedef struct S734 T734;
typedef struct S261 T261;
typedef struct S309 T309;
typedef struct S598 T598;
typedef struct S353 T353;
typedef struct S733 T733;
typedef struct S732 T732;
typedef struct S731 T731;
typedef struct S225 T225;
typedef struct S276 T276;
typedef struct S730 T730;
typedef struct S352 T352;
typedef struct S514 T514;
typedef struct S511 T511;
typedef struct S510 T510;
typedef struct S509 T509;
typedef struct S508 T508;
typedef struct S507 T507;
typedef struct S506 T506;
typedef struct S729 T729;
typedef struct S496 T496;
typedef struct S728 T728;
typedef int T279;
typedef struct S726 T726;
typedef struct S539 T539;
typedef void*T234;
typedef void*T220;
typedef int T710;
typedef struct S224 T224;
typedef void*T217;
typedef struct S239 T239;
typedef struct S725 T725;
typedef void*T238;
typedef struct S231 T231;
typedef struct S518 T518;
typedef struct S724 T724;
typedef struct S722 T722;
typedef int T302;
typedef struct S721 T721;
typedef struct S718 T718;
typedef struct S45 T45;
typedef struct S32 T32;
typedef struct S280 T280;
typedef int T477;
typedef int T254;
typedef struct S232 T232;
typedef struct S63 T63;
typedef struct S59 T59;
typedef struct S717 T717;
typedef struct S219 T219;
typedef struct S716 T716;
typedef void*T704;
typedef struct S241 T241;
typedef struct S80 T80;
typedef struct S235 T235;
typedef struct S236 T236;
typedef struct S66 T66;
typedef void*T85;
typedef struct S218 T218;
typedef int T255;
typedef struct S25 T25;
/* C Header Pass 2: */
typedef T0**T1153;
#define M1153 NULL
typedef T0**T1152;
#define M1152 NULL
typedef T0**T1149;
#define M1149 NULL
typedef T0**T1148;
#define M1148 NULL
typedef T0**T1147;
#define M1147 NULL
typedef T0**T1146;
#define M1146 NULL
typedef T0**T1145;
#define M1145 NULL
typedef T0**T1144;
#define M1144 NULL
typedef T0**T1143;
#define M1143 NULL
typedef T0**T1123;
#define M1123 NULL
typedef T0**T1120;
#define M1120 NULL
typedef T0**T1119;
#define M1119 NULL
typedef T0**T1118;
#define M1118 NULL
typedef T0**T1104;
#define M1104 NULL
typedef T0**T1103;
#define M1103 NULL
typedef T0**T1097;
#define M1097 NULL
typedef T0**T1094;
#define M1094 NULL
typedef T0**T1093;
#define M1093 NULL
typedef T8*T1091;
#define M1091 NULL
typedef T0**T1079;
#define M1079 NULL
typedef T0**T1088;
#define M1088 NULL
typedef T0**T1085;
#define M1085 NULL
typedef T0**T1082;
#define M1082 NULL
typedef T0**T1078;
#define M1078 NULL
typedef T0**T1077;
#define M1077 NULL
typedef T0**T1075;
#define M1075 NULL
typedef T0**T1048;
#define M1048 NULL
typedef T0**T1041;
#define M1041 NULL
typedef T0**T1038;
#define M1038 NULL
typedef T0**T1160;
#define M1160 NULL
typedef T0**T1034;
#define M1034 NULL
typedef T0**T1031;
#define M1031 NULL
typedef T0**T1028;
#define M1028 NULL
typedef T0**T1027;
#define M1027 NULL
typedef T0**T1024;
#define M1024 NULL
typedef T0**T1019;
#define M1019 NULL
typedef T0**T1018;
#define M1018 NULL
typedef T0**T1015;
#define M1015 NULL
typedef T0**T1014;
#define M1014 NULL
typedef T0**T1011;
#define M1011 NULL
typedef T0**T1008;
#define M1008 NULL
typedef T0**T1010;
#define M1010 NULL
typedef T0**T1009;
#define M1009 NULL
typedef T0**T1005;
#define M1005 NULL
typedef T0**T1002;
#define M1002 NULL
typedef T0**T999;
#define M999 NULL
typedef T0**T997;
#define M997 NULL
typedef T0**T996;
#define M996 NULL
typedef T0**T995;
#define M995 NULL
typedef T0**T994;
#define M994 NULL
typedef T0**T993;
#define M993 NULL
typedef T0**T992;
#define M992 NULL
typedef T0**T991;
#define M991 NULL
typedef T0**T990;
#define M990 NULL
typedef T0**T987;
#define M987 NULL
typedef T0**T984;
#define M984 NULL
typedef T0**T981;
#define M981 NULL
typedef T0**T979;
#define M979 NULL
typedef T0**T976;
#define M976 NULL
typedef T0**T972;
#define M972 NULL
typedef T0**T963;
#define M963 NULL
typedef T0**T962;
#define M962 NULL
typedef T0**T959;
#define M959 NULL
typedef T0**T955;
#define M955 NULL
typedef T0**T953;
#define M953 NULL
typedef T0**T951;
#define M951 NULL
typedef T0**T948;
#define M948 NULL
typedef T0**T945;
#define M945 NULL
typedef T0**T942;
#define M942 NULL
typedef T0**T939;
#define M939 NULL
typedef T0**T936;
#define M936 NULL
typedef T0**T933;
#define M933 NULL
typedef T0**T932;
#define M932 NULL
typedef T0**T928;
#define M928 NULL
typedef T0**T925;
#define M925 NULL
typedef T1*T923;
#define M923 NULL
typedef T0**T922;
#define M922 NULL
typedef T0**T909;
#define M909 NULL
typedef T0**T919;
#define M919 NULL
typedef T0**T918;
#define M918 NULL
typedef T0**T915;
#define M915 NULL
typedef T0**T912;
#define M912 NULL
typedef T0**T904;
#define M904 NULL
typedef T0**T901;
#define M901 NULL
typedef T0**T895;
#define M895 NULL
typedef T0**T893;
#define M893 NULL
typedef T0**T890;
#define M890 NULL
typedef T0**T894;
#define M894 NULL
typedef T0**T887;
#define M887 NULL
typedef T0**T860;
#define M860 NULL
typedef T0**T857;
#define M857 NULL
typedef T0**T885;
#define M885 NULL
typedef T0**T882;
#define M882 NULL
typedef T0**T881;
#define M881 NULL
typedef T0**T880;
#define M880 NULL
typedef T0**T878;
#define M878 NULL
typedef T0**T876;
#define M876 NULL
typedef T0**T869;
#define M869 NULL
typedef T0**T864;
#define M864 NULL
typedef T0**T863;
#define M863 NULL
typedef T0**T856;
#define M856 NULL
typedef T0**T853;
#define M853 NULL
typedef T296*T852;
#define M852 NULL
typedef T0**T849;
#define M849 NULL
typedef T0**T845;
#define M845 NULL
typedef T0**T842;
#define M842 NULL
typedef T10*T841;
#define M841 NULL
typedef T2*T837;
#define M837 NULL
typedef T0**T836;
#define M836 NULL
typedef T0**T835;
#define M835 NULL
typedef T0**T832;
#define M832 NULL
typedef T0**T829;
#define M829 NULL
typedef T0**T806;
#define M806 NULL
typedef T0**T788;
#define M788 NULL
typedef T0**T776;
#define M776 NULL
typedef T0**T753;
#define M753 NULL
typedef T0**T752;
#define M752 NULL
typedef T0**T746;
#define M746 NULL
typedef T0**T740;
#define M740 NULL
typedef T3*T9;
#define M9 NULL
/* C Header Pass 3: */
extern T1141 M1141;
extern T1130 M1130;
extern T1092 M1092;
extern T1049 M1049;
struct S597{T0* _first_error;T2 _first_error_index;T2 _first_error_character;};
int se_cmpT597(T597 o1,T597 o2);
struct S314{T6 _keep_environment;T0* _group;T6 _direct_input;T6 _direct_output;T6 _direct_error;};
int se_cmpT314(T314 o1,T314 o2);
extern T830 M830;
struct S304{T0* _class_name;T0* _feature_name;T2 _hash_code;};
int se_cmpT304(T304 o1,T304 o2);
struct S665{T0* _arguments;T0* _type;T0* _header_comment;T0* _obsolete_mark;T0* _require_assertion;T0* _local_vars;T0* _routine_body;};
int se_cmpT665(T665 o1,T665 o2);
extern T744 M744;
struct S598{T2 _line;T2 _column;T0* _hashed_string_memory;};
int se_cmpT598(T598 o1,T598 o2);
struct S353{int _file_tools;};
int se_cmpT353(T353 o1,T353 o2);
struct S496{T8 _directory_stream;T8 _current_entry;};
int se_cmpT496(T496 o1,T496 o2);
struct S296{T2 _mangling;};
int se_cmpT296(T296 o1,T296 o2);
/* C Header Pass 4: */
struct S1151{Tid id;T0* _item;};
extern T1151 M1151;
struct S1150{T0* _item;T0* _key;T0* _next;};
extern T1150 M1150;
struct S1142{T1153 _storage;T2 _capacity;T2 _upper;};
extern T1142 M1142;
struct S1140{T1152 _storage;T2 _capacity;T2 _upper;};
extern T1140 M1140;
struct S380{Tid id;T0* _compound;};
extern T380 M380;
struct S1139{T1149 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T1139 M1139;
struct S1138{T1148 _storage;T2 _capacity;T2 _upper;};
extern T1138 M1138;
struct S426{Tid id;T0* _captured;T2 _number;};
extern T426 M426;
struct S288{Tid id;T0* _declaration_type;T0* _result_type;T2 _rank;};
extern T288 M288;
struct S1137{Tid id;T0* _dictionary;T2 _item_index;};
extern T1137 M1137;
struct S1136{T1146 _storage;T2 _capacity;T2 _upper;};
extern T1136 M1136;
struct S1135{T1147 _storage;T2 _capacity;T2 _upper;};
extern T1135 M1135;
extern T499 M499;
struct S1134{T1146 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1134 M1134;
struct S492{Tid id;T0* _type_memory;T0* _anonymous_feature_memory;T0* _target_memory;T0* _effective_arguments_memory;T0* _static_type_memory;T0* _internal_c_local_memory;};
extern T492 M492;
struct S491{Tid id;T0* _type_memory;T0* _anonymous_feature_memory;T0* _target_memory;T0* _effective_arguments_memory;T0* _static_type_memory;T0* _internal_c_local_memory;};
extern T491 M491;
struct S490{Tid id;T0* _type_memory;T0* _anonymous_feature_memory;T0* _target_memory;T0* _effective_arguments_memory;T0* _static_type_memory;T0* _internal_c_local_memory;};
extern T490 M490;
struct S489{Tid id;T0* _type_memory;T0* _anonymous_feature_memory;T0* _target_memory;T0* _effective_arguments_memory;T0* _static_type_memory;T0* _internal_c_local_memory;};
extern T489 M489;
struct S488{Tid id;T0* _type_memory;T0* _anonymous_feature_memory;T0* _target_memory;T0* _effective_arguments_memory;T0* _static_type_memory;T0* _internal_c_local_memory;};
extern T488 M488;
struct S487{Tid id;T0* _type_memory;T0* _anonymous_feature_memory;T0* _target_memory;T0* _effective_arguments_memory;T0* _static_type_memory;T0* _internal_c_local_memory;};
extern T487 M487;
struct S486{Tid id;T0* _type_memory;T0* _anonymous_feature_memory;T0* _target_memory;T0* _effective_arguments_memory;T0* _static_type_memory;T0* _internal_c_local_memory;};
extern T486 M486;
struct S1133{T1145 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1133 M1133;
struct S1132{T1144 _storage;T2 _capacity;T2 _upper;};
extern T1132 M1132;
struct S292{T2 _number;T0* _type;T6 _is_locked;T6 _is_member_of_pending_c_function_locals;};
extern T292 M292;
struct S1126{T1143 _storage;T2 _capacity;T2 _upper;};
extern T1126 M1126;
struct S503{T2 _information_declared_item_counter;};
extern T503 M503;
struct S701{T2 _hash_code;T0* _name;T0* _path;T496 _bd;T6 _auto_init_done;T6 _is_included;T296 _start_position;T0* _c_sources;T0* _c_headers;T0* _c_header_paths;T0* _c_libraries;T0* _c_library_paths;T0* _c_linker_options;T0* _c_compiler_options;T0* _c_auto_init_function_name;T0* _c_auto_init_plugin_deps_location;T0* _c_auto_init_plugin_deps_name;};
extern T701 M701;
struct S1125{Tid id;T0* _item;};
extern T1125 M1125;
struct S1124{T0* _item;T0* _key;T0* _next;};
extern T1124 M1124;
struct S1122{Tid id;T0* _item;};
extern T1122 M1122;
struct S1121{T0* _item;T0* _key;T0* _next;};
extern T1121 M1121;
struct S1117{T1123 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T1117 M1117;
struct S1116{T0* _item;};
extern T1116 M1116;
struct S1113{T0* _item;T0* _next;};
extern T1113 M1113;
struct S1112{T1120 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T1112 M1112;
struct S1111{T1119 _storage;T2 _capacity;T2 _upper;};
extern T1111 M1111;
struct S1110{T0* _left;T0* _right;T2 _key;T2 _balance;T2 _value;};
extern T1110 M1110;
struct S1109{T0* _item;};
extern T1109 M1109;
struct S1102{T1118 _storage;T2 _capacity;T2 _upper;};
extern T1102 M1102;
struct S1101{T3 _item_1;T2 _item_2;};
extern T1101 M1101;
struct S1100{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;T0* _free_nodes;};
extern T1100 M1100;
struct S1099{T2 _count;T0* _root;T6 _rebalance;T2 _key_memory;T0* _map;T6 _map_dirty;T0* _lost_nodes;T2 _value_memory;};
extern T1099 M1099;
struct S1106{Tid id;T0* _item;};
extern T1106 M1106;
struct S1105{T0* _item;T0* _key;T0* _next;};
extern T1105 M1105;
struct S1096{Tid id;T0* _item;};
extern T1096 M1096;
struct S1095{T0* _item;T0* _key;T0* _next;};
extern T1095 M1095;
struct S685{T6 _has_empty;T2 _maxstate;T2 _id;T2 _empty_idx;T0* _tag_state;T0* _headers;T0* _transitions;};
extern T685 M685;
struct S1081{T1104 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T1081 M1081;
struct S1080{T1103 _storage;T2 _capacity;T2 _upper;};
extern T1080 M1080;
struct S1090{Tid id;T0* _item;};
extern T1090 M1090;
struct S1089{T0* _item;T0* _key;T0* _next;};
extern T1089 M1089;
struct S1087{Tid id;T0* _item;};
extern T1087 M1087;
struct S1086{T0* _item;T0* _key;T0* _next;};
extern T1086 M1086;
struct S1084{Tid id;T0* _item;};
extern T1084 M1084;
struct S1083{T0* _item;T0* _next;};
extern T1083 M1083;
struct S1076{T1097 _storage;T2 _capacity;T2 _upper;};
extern T1076 M1076;
struct S472{T296 _start_position;T0* _list;};
extern T472 M472;
struct S1074{T1094 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T1074 M1074;
struct S1073{T1093 _storage;T2 _capacity;T2 _upper;};
extern T1073 M1073;
struct S1072{T0* _item;};
extern T1072 M1072;
struct S1069{T0* _left;T0* _right;T296 _item;T2 _balance;};
extern T1069 M1069;
struct S681{Tid id;T8 _pipe;T6 _is_connected;T0* _process;T8 _handle;};
extern T681 M681;
struct S680{Tid id;T8 _pipe;T6 _can_unread_character;T6 _end_of_input;T6 _is_connected;T6 _has_unread_character;T3 _unread_buffer;T3 _filtered_last_character;T0* _process;T8 _handle;};
extern T680 M680;
struct S679{Tid id;T8 _pipe;T6 _is_connected;T2 _filtered_descriptor;T0* _process;};
extern T679 M679;
struct S677{Tid id;T8 _pipe;T6 _can_unread_character;T6 _end_of_input;T6 _is_connected;T6 _has_unread_character;T3 _unread_buffer;T3 _filtered_last_character;T2 _filtered_descriptor;T0* _process;};
extern T677 M677;
struct S1068{T1091 _storage;T2 _capacity;T2 _upper;};
extern T1068 M1068;
struct S1067{T837 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1067 M1067;
struct S481{Tid id;T0* _type_of_current;T0* _name;T0* _old_list;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _internal_locals;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T481 M481;
struct S480{Tid id;T0* _type_of_current;T0* _name;T0* _old_list;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _internal_locals;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T480 M480;
struct S626{Tid id;T0* _type_of_current;T0* _name;T0* _old_list;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _internal_locals;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T626 M626;
struct S479{Tid id;T0* _type_of_current;T0* _name;T0* _old_list;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _internal_locals;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;T6 _side_effect_free_flag;};
extern T479 M479;
struct S614{Tid id;T0* _type_of_current;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _value;T0* _result_type;};
extern T614 M614;
struct S1066{T0* _item_1;T0* _item_2;T0* _item_3;T0* _item_4;};
extern T1066 M1066;
struct S553{Tid id;T296 _start_position;T0* _name;T0* _anchor_expression;T0* _base_type;T0* _tag;};
extern T553 M553;
struct S624{Tid id;T0* _type_of_current;T0* _name;T0* _old_list;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _ensure_assertion;T0* _local_vars;T0* _internal_locals;T0* _routine_body;};
extern T624 M624;
struct S383{Tid id;T296 _start_position;T0* _feature_stamp;T0* _target_type;};
extern T383 M383;
struct S87{Tid id;T6 _precomputable;T6 _can_be_dropped_flag;};
extern T87 M87;
struct S516{T0* _instruction;T0* _expression_memory;};
extern T516 M516;
struct S1057{T1079 _storage;T2 _capacity;T2 _upper;};
extern T1057 M1057;
struct S475{Tid id;T296 _start_position;T0* _feature_stamp;T0* _target_type;};
extern T475 M475;
struct S627{T0* _string_pool;T0* _headers;T296 _empty_position;};
extern T627 M627;
struct S445{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;};
extern T445 M445;
struct S556{Tid id;T296 _start_position;T0* _explicit_type;T0* _writable;T0* _call;T6 _default_create_call;};
extern T556 M556;
struct S457{Tid id;T296 _start_position;T0* _target_type;T3 _array_name;};
extern T457 M457;
struct S1058{T932 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1058 M1058;
struct S226{T6 _used;};
extern T226 M226;
struct S623{Tid id;T0* _type_of_current;T0* _name;T0* _old_list;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _ensure_assertion;T0* _local_vars;T0* _internal_locals;T0* _routine_body;};
extern T623 M623;
struct S615{T0* _locals;T0* _collected;};
extern T615 M615;
struct S1064{T1088 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T1064 M1064;
struct S1063{T1085 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T1063 M1063;
struct S1059{T1082 _buckets;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T2 _capacity;T2 _count;T0* _free_nodes;};
extern T1059 M1059;
struct S625{Tid id;T0* _type_of_current;T0* _name;T0* _old_list;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _ensure_assertion;};
extern T625 M625;
struct S1052{T864 _storage;T2 _capacity;T2 _upper;};
extern T1052 M1052;
struct S1051{T890 _storage;T2 _capacity;T2 _upper;};
extern T1051 M1051;
struct S493{Tid id;T0* _type_of_current;T0* _name;T0* _old_list;T2 _use_current_state;T0* _base_feature;T0* _result_type;T2 _order;T0* _require_assertion;T0* _ensure_assertion;};
extern T493 M493;
struct S1047{T1078 _storage;T2 _capacity;T2 _upper;};
extern T1047 M1047;
struct S1046{T0* _item;};
extern T1046 M1046;
extern T597 M597;
struct S441{Tid id;T296 _start_position;T0* _type_mark;};
extern T441 M441;
struct S1045{T1077 _storage;T2 _capacity;T2 _upper;};
extern T1045 M1045;
struct S381{Tid id;T0* _agent_type;T0* _target;T0* _fake_tuple;T0* _agent_args;T0* _written_link;};
extern T381 M381;
extern T221 M221;
struct S470{Tid id;T0* _resolved_memory;T0* _expression;T0* _expression_type;};
extern T470 M470;
struct S412{Tid id;T0* _agent_type;T0* _target;T0* _fake_tuple;T0* _agent_args;T0* _written_link;};
extern T412 M412;
struct S1044{T1075 _storage;T2 _capacity;T2 _upper;};
extern T1044 M1044;
struct S1043{T2 _count;T0* _root;T6 _rebalance;T296 _item_memory;T0* _map;T6 _map_dirty;T0* _lost_nodes;};
extern T1043 M1043;
struct S1042{Tid id;T0* _item;};
extern T1042 M1042;
struct S1040{T0* _item;T2 _key;T0* _next;};
extern T1040 M1040;
struct S1039{Tid id;T0* _item;};
extern T1039 M1039;
struct S1037{T0* _item;T2 _key;T0* _next;};
extern T1037 M1037;
struct S1036{T1041 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T1036 M1036;
struct S1035{T1038 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T1035 M1035;
struct S1033{Tid id;T0* _item;};
extern T1033 M1033;
struct S1032{T0* _item;T0* _next;};
extern T1032 M1032;
struct S1030{Tid id;T0* _item;};
extern T1030 M1030;
struct S1029{T0* _item;T0* _key;T0* _next;};
extern T1029 M1029;
struct S1159{T0* _item;};
extern T1159 M1159;
struct S1158{T1160 _storage;T2 _capacity;T2 _upper;T2 _lower;T2 _storage_lower;};
extern T1158 M1158;
struct S593{Tid id;T0* _handle_map;T6 _handle_list_dirty;T8 _data;};
extern T593 M593;
struct S592{Tid id;};
extern T592 M592;
struct S591{Tid id;T0* _id_map;T8 _data;};
extern T591 M591;
struct S596{Tid id;T6 _direct_input;T6 _direct_output;T6 _direct_error;T6 _is_connected;T0* _input;T0* _output;T0* _error;T0* _group;T0* _instream;T0* _errstream;T0* _outstream;T8 _data;};
extern T596 M596;
struct S595{Tid id;T6 _direct_input;T6 _direct_output;T6 _direct_error;T0* _group;};
extern T595 M595;
struct S594{Tid id;T6 _direct_input;T6 _direct_output;T6 _direct_error;T6 _is_connected;T0* _input;T0* _output;T0* _error;T0* _group;T0* _instream;T0* _errstream;T0* _outstream;T8 _data;};
extern T594 M594;
struct S1026{Tid id;T0* _item;};
extern T1026 M1026;
struct S1025{T0* _item;T0* _key;T0* _next;};
extern T1025 M1025;
struct S1023{Tid id;T0* _item;};
extern T1023 M1023;
struct S1021{Tid id;T0* _traversable;T2 _item_index;};
extern T1021 M1021;
struct S1020{T0* _item;T0* _key;T0* _next;};
extern T1020 M1020;
struct S1017{Tid id;T0* _item;};
extern T1017 M1017;
struct S1016{T0* _item;T0* _key;T0* _next;};
extern T1016 M1016;
struct S1013{Tid id;T0* _item;};
extern T1013 M1013;
struct S1012{T0* _item;T0* _key;T0* _next;};
extern T1012 M1012;
struct S1007{Tid id;T0* _item;};
extern T1007 M1007;
struct S1006{T0* _item;T0* _next;};
extern T1006 M1006;
struct S1004{Tid id;T0* _item;};
extern T1004 M1004;
struct S1003{T0* _item;T0* _key;T0* _next;};
extern T1003 M1003;
struct S1001{Tid id;T0* _item;};
extern T1001 M1001;
struct S1000{T0* _item;T0* _key;T0* _next;};
extern T1000 M1000;
struct S998{T1034 _storage;T2 _capacity;T2 _upper;};
extern T998 M998;
struct S989{Tid id;T0* _item;};
extern T989 M989;
struct S988{T0* _item;T0* _key;T0* _next;};
extern T988 M988;
struct S986{Tid id;T0* _item;};
extern T986 M986;
struct S985{T0* _item;T0* _key;T0* _next;};
extern T985 M985;
struct S983{Tid id;T0* _item;};
extern T983 M983;
struct S982{T0* _item;T0* _key;T0* _next;};
extern T982 M982;
struct S980{T1031 _buckets;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T2 _capacity;T2 _count;T0* _free_nodes;};
extern T980 M980;
struct S978{Tid id;T0* _item;};
extern T978 M978;
struct S977{T0* _item;T0* _key;T0* _next;};
extern T977 M977;
struct S975{T1028 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T975 M975;
struct S974{T1027 _storage;T2 _capacity;T2 _upper;};
extern T974 M974;
struct S1156{T2 _cursor;T0* _ring;};
extern T1156 M1156;
extern T314 M314;
struct S970{T1024 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T970 M970;
struct S969{T1019 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;T0* _ordered_keys;};
extern T969 M969;
struct S968{Tid id;T832 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;T0* _ordered_keys;};
extern T968 M968;
struct S966{T1018 _storage;T2 _capacity;T2 _upper;};
extern T966 M966;
struct S965{Tid id;T0* _item;};
extern T965 M965;
struct S964{T0* _item;T0* _next;};
extern T964 M964;
struct S961{Tid id;T0* _item;};
extern T961 M961;
struct S960{T0* _item;T0* _key;T0* _next;};
extern T960 M960;
struct S958{T1015 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T958 M958;
struct S957{Tid id;T0* _item;};
extern T957 M957;
struct S956{T0* _item;T0* _next;};
extern T956 M956;
struct S954{Tid id;T0* _item;};
extern T954 M954;
struct S952{T0* _item;T0* _key;T0* _next;};
extern T952 M952;
struct S950{Tid id;T0* _item;};
extern T950 M950;
struct S949{T0* _item;T0* _key;T0* _next;};
extern T949 M949;
struct S947{Tid id;T0* _item;};
extern T947 M947;
struct S946{T0* _item;T0* _key;T0* _next;};
extern T946 M946;
struct S944{Tid id;T0* _item;};
extern T944 M944;
struct S943{T0* _item;T0* _key;T0* _next;};
extern T943 M943;
struct S941{Tid id;T0* _item;};
extern T941 M941;
struct S940{T0* _item;T0* _next;};
extern T940 M940;
struct S938{Tid id;T0* _item;};
extern T938 M938;
struct S937{T0* _item;T0* _key;T0* _next;};
extern T937 M937;
struct S935{Tid id;T0* _item;};
extern T935 M935;
struct S934{T0* _item;T0* _key;T0* _next;};
extern T934 M934;
struct S618{T296 _start_position;T0* _header_comment;T0* _list;};
extern T618 M618;
struct S931{T1014 _storage;T2 _capacity;T2 _upper;};
extern T931 M931;
struct S930{Tid id;T0* _item;};
extern T930 M930;
struct S929{T0* _item;T0* _next;};
extern T929 M929;
struct S926{Tid id;T0* _item;};
extern T926 M926;
struct S924{T0* _item;T0* _key;T0* _next;};
extern T924 M924;
struct S911{Tid id;T0* _item;};
extern T911 M911;
struct S910{T0* _item;T0* _key;T0* _next;};
extern T910 M910;
struct S921{Tid id;T0* _item;};
extern T921 M921;
struct S920{T0* _item;T0* _key;T0* _next;};
extern T920 M920;
struct S917{Tid id;T0* _item;};
extern T917 M917;
struct S916{T304 _item;T0* _next;};
extern T916 M916;
struct S914{Tid id;T0* _item;};
extern T914 M914;
struct S913{T0* _item;T304 _key;T0* _next;};
extern T913 M913;
struct S908{T0* _item;};
extern T908 M908;
struct S906{T1011 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T906 M906;
struct S905{T0* _val;T0* _key;T0* _next_key;T0* _next_val;};
extern T905 M905;
struct S898{T1008 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T898 M898;
struct S903{Tid id;T0* _item;};
extern T903 M903;
struct S902{T0* _item;T0* _key;T0* _next;};
extern T902 M902;
struct S900{T1010 _storage;T2 _capacity;T2 _upper;};
extern T900 M900;
struct S899{T1009 _storage;T2 _capacity;T2 _upper;};
extern T899 M899;
struct S897{Tid id;T0* _item;};
extern T897 M897;
struct S896{T0* _item;T0* _key;T0* _next;};
extern T896 M896;
struct S892{T1005 _buckets;T2 _cache_user;T2 _capacity;T2 _count;T0* _free_nodes;};
extern T892 M892;
struct S889{Tid id;T0* _item;};
extern T889 M889;
struct S888{T0* _item;T0* _key;T0* _next;};
extern T888 M888;
struct S862{Tid id;T0* _item;};
extern T862 M862;
struct S861{T0* _item;T0* _next;};
extern T861 M861;
struct S859{Tid id;T0* _item;};
extern T859 M859;
struct S858{T2 _item;T0* _key;T0* _next;};
extern T858 M858;
struct S886{T1002 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T886 M886;
struct S884{T999 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T884 M884;
struct S324{T0* _list;};
extern T324 M324;
struct S879{Tid id;T997 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T879 M879;
struct S877{T996 _storage;T2 _capacity;T2 _upper;};
extern T877 M877;
struct S628{T296 _start_position;T0* _header_comment;T0* _list;};
extern T628 M628;
struct S875{T995 _storage;T2 _capacity;T2 _upper;};
extern T875 M875;
struct S555{Tid id;T0* _expression;T0* _manifest_expression;T2 _expression_value;};
extern T555 M555;
struct S874{T994 _storage;T2 _capacity;T2 _upper;};
extern T874 M874;
struct S631{Tid id;T0* _lower;T0* _upper;T0* _upper_manifest_expression;T0* _lower_manifest_expression;T2 _lower_value;T2 _upper_value;};
extern T631 M631;
struct S873{T993 _storage;T2 _capacity;T2 _upper;};
extern T873 M873;
struct S872{T0* _item;};
extern T872 M872;
struct S419{Tid id;T0* _writable;T0* _type_mark;T0* _declaration_type;};
extern T419 M419;
struct S378{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _result_type;T0* _obsolete_mark;T0* _value_memory;};
extern T378 M378;
struct S369{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _arguments;T0* _obsolete_mark;T0* _end_comment;T0* _local_vars;T0* _internal_locals;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;T0* _inline_result;T0* _result_type;};
extern T369 M369;
struct S364{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _arguments;T0* _obsolete_mark;T0* _end_comment;T0* _local_vars;T0* _internal_locals;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T364 M364;
struct S370{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _result_type;T0* _obsolete_mark;T0* _value_memory;};
extern T370 M370;
struct S374{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _result_type;T0* _obsolete_mark;T0* _value_memory;T2 _rank;};
extern T374 M374;
struct S373{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _result_type;T0* _obsolete_mark;T0* _value_memory;};
extern T373 M373;
struct S368{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _result_type;T0* _obsolete_mark;T0* _value_memory;};
extern T368 M368;
struct S377{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _arguments;T0* _obsolete_mark;T0* _end_comment;T0* _local_vars;T0* _internal_locals;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;T0* _result_type;};
extern T377 M377;
struct S375{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _arguments;T0* _obsolete_mark;T0* _end_comment;T0* _local_vars;T0* _internal_locals;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T375 M375;
struct S362{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _result_type;T0* _obsolete_mark;T2 _rank;T0* _value_memory;};
extern T362 M362;
struct S871{T992 _storage;T2 _capacity;T2 _upper;};
extern T871 M871;
struct S379{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _arguments;T0* _obsolete_mark;T0* _end_comment;T0* _local_vars;T0* _internal_locals;T0* _routine_body;T0* _native;T0* _alias_string;T6 _is_generated_eiffel;T0* _result_type;};
extern T379 M379;
struct S371{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _arguments;T0* _obsolete_mark;T0* _end_comment;T0* _local_vars;T0* _internal_locals;T0* _routine_body;T0* _native;T0* _alias_string;T6 _is_generated_eiffel;};
extern T371 M371;
struct S376{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _arguments;T0* _obsolete_mark;T0* _end_comment;T0* _local_vars;T0* _internal_locals;T0* _routine_body;T0* _result_type;};
extern T376 M376;
struct S366{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _arguments;T0* _obsolete_mark;T0* _end_comment;T0* _local_vars;T0* _internal_locals;T0* _routine_body;};
extern T366 M366;
struct S870{T991 _storage;T2 _capacity;T2 _upper;};
extern T870 M870;
struct S630{Tid id;T2 _last_rank;T1 _status;T0* _type;T0* _last_open_argument;};
extern T630 M630;
struct S629{T0* _capture_list;T0* _delayed_call;T0* _delayed_proc_call;T0* _mold_id;};
extern T629 M629;
struct S868{T990 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T868 M868;
struct S867{T987 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T867 M867;
struct S866{T984 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T866 M866;
struct S865{T981 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T865 M865;
struct S855{Tid id;T0* _item;};
extern T855 M855;
struct S854{T0* _item;T0* _key;T0* _next;};
extern T854 M854;
struct S851{Tid id;T0* _item;};
extern T851 M851;
struct S850{T0* _item;T0* _key;T0* _next;};
extern T850 M850;
struct S294{T0* _c_name;T0* _type_mark;T0* _feature_name;T0* _type;T0* _feature_stamp;T6 _is_creation;};
extern T294 M294;
struct S848{T979 _storage;T2 _capacity;T2 _upper;};
extern T848 M848;
struct S847{Tid id;T0* _item;};
extern T847 M847;
struct S846{T0* _item;T0* _key;T0* _next;};
extern T846 M846;
struct S844{Tid id;T0* _item;};
extern T844 M844;
struct S843{T0* _item;T0* _key;T0* _next;};
extern T843 M843;
struct S840{T841 _storage;T2 _capacity;T2 _upper;};
extern T840 M840;
struct S416{Tid id;T0* _feature_name;T0* _feature_stamp;T0* _written_declaration_type_mark;T0* _declaration_type;};
extern T416 M416;
struct S533{T0* _hashed_name;T296 _start_position;};
extern T533 M533;
struct S422{Tid id;T296 _start_position;T2 _rank;T0* _declaration_type;T0* _written_declaration_type_mark;T0* _local_var_list;};
extern T422 M422;
struct S467{Tid id;T296 _start_position;T2 _rank;T0* _declaration_type;T0* _formal_arg_list;};
extern T467 M467;
struct S839{T976 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T839 M839;
struct S622{Tid id;T0* _parent;T2 _distance;T496 _basic_directory;T0* _classeses;T0* _name;T0* _path;};
extern T622 M622;
struct S583{Tid id;T0* _parent;T2 _distance;T496 _basic_directory;T0* _classeses;T0* _cluster;T0* _name;T0* _path;};
extern T583 M583;
struct S834{T972 _storage;T2 _capacity;T2 _upper;};
extern T834 M834;
struct S833{Tid id;T0* _item;};
extern T833 M833;
struct S831{T0* _item;T0* _key;T0* _next;};
extern T831 M831;
struct S576{Tid id;T0* _bin;T0* _sys;T0* _short;T0* _os;T0* _flavor;T2 _jobs;T0* _jar;T0* _java_virtual_machine;T0* _java_compiler;T0* _my_environment;T0* _my_loadpaths;T0* _my_tools;T0* _my_c_modes;};
extern T576 M576;
struct S575{Tid id;T0* _config;};
extern T575 M575;
struct S828{T963 _buckets;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T2 _capacity;T2 _count;T0* _free_nodes;};
extern T828 M828;
struct S432{Tid id;T0* _dynamic_type;T0* _feature_stamp;T0* _context_type;T0* _run_feature;};
extern T432 M432;
struct S827{T962 _storage;T2 _capacity;T2 _upper;};
extern T827 M827;
struct S826{T959 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T826 M826;
struct S637{T0* _current_type;T0* _feature_name;T0* _result_type;T0* _arguments;T2 _id;T0* _features;};
extern T637 M637;
struct S711{T0* _type;T0* _branches;};
extern T711 M711;
struct S824{T955 _buckets;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T2 _capacity;T2 _count;T0* _free_nodes;};
extern T824 M824;
struct S823{T1048 _storage;T2 _capacity;T2 _upper;};
extern T823 M823;
struct S822{T953 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T822 M822;
struct S484{T0* _signature;T0* _agent_type;};
extern T484 M484;
struct S820{T951 _storage;T2 _capacity;T2 _upper;};
extern T820 M820;
struct S819{T948 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T819 M819;
struct S818{T945 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T818 M818;
struct S817{T942 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T817 M817;
struct S816{T939 _buckets;T2 _cache_user;T2 _capacity;T2 _count;T0* _free_nodes;};
extern T816 M816;
struct S308{T2 _value;};
extern T308 M308;
struct S812{T936 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T812 M812;
struct S811{T933 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T811 M811;
struct S808{T932 _storage;T2 _capacity;T2 _upper;};
extern T808 M808;
struct S346{T6 _is_require_else;T0* _list;};
extern T346 M346;
struct S807{T894 _storage;T2 _capacity;T2 _upper;};
extern T807 M807;
struct S805{T928 _buckets;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T2 _capacity;T2 _count;T0* _free_nodes;};
extern T805 M805;
struct S803{T925 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T803 M803;
struct S519{T0* _source_type;T2 _hash_code;T0* _destination_graph_nodes;};
extern T519 M519;
struct S802{T923 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T802 M802;
struct S801{T922 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T801 M801;
struct S791{T909 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T791 M791;
struct S796{T919 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T796 M796;
struct S500{T1 _computing_result_type;T0* _feature_name;T0* _parents_af;T0* _parents_type;T0* _parents_edges;T0* _build_definition;T0* _body_feature;T0* _body_type;T0* _body_inherit;T6 _signature_ready;T6 _local_definition;};
extern T500 M500;
struct S795{T918 _storage;T2 _capacity;T2 _upper;};
extern T795 M795;
struct S794{T890 _storage;T2 _capacity;T2 _upper;T2 _lower;T2 _storage_lower;};
extern T794 M794;
struct S793{T915 _buckets;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T2 _capacity;T2 _count;T0* _free_nodes;};
extern T793 M793;
extern T304 M304;
struct S792{T912 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T792 M792;
struct S790{Tid id;T0* _item;};
extern T790 M790;
struct S789{T0* _item;T0* _key;T0* _next;};
extern T789 M789;
struct S787{T890 _storage;T2 _capacity;T2 _upper;};
extern T787 M787;
struct S786{T2 _count;T904 _key_buckets;T904 _val_buckets;T2 _capacity;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T786 M786;
struct S551{T0* _list;};
extern T551 M551;
struct S785{T901 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T785 M785;
struct S347{T0* _list;};
extern T347 M347;
struct S323{T0* _class_text;T0* _inherit_comment;T0* _insert_comment;T6 _default_insert_any_added_flag;T0* _inherit_list;T0* _insert_list;};
extern T323 M323;
struct S348{T0* _list;};
extern T348 M348;
struct S246{T0* _valid_generating_type_for_internals_prelude;T0* _internals_from_generating_type_prelude;T0* _valid_generating_type_for_native_array_internals_prelude;T0* _native_array_internals_from_generating_type_prelude;T0* _external_routine;T0* _new_type;T0* _target_type;T0* _native_array_element_type;T6 _can_twin;T6 _has_capacity;T296 _internals_from_generating_type_position;T296 _native_array_internals_from_generating_type_position;T0* _native_array_internals_from_generating_type_args;};
extern T246 M246;
struct S329{T296 _start_position;T0* _header_comment;T0* _list;};
extern T329 M329;
struct S784{T895 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T784 M784;
struct S783{T752 _storage;T2 _capacity;T2 _upper;};
extern T783 M783;
struct S781{T893 _storage;T2 _capacity;T2 _upper;};
extern T781 M781;
struct S363{Tid id;T0* _feature_text;T0* _header_comment;T0* _require_assertion;T0* _ensure_assertion;T0* _permissions;T0* _result_type;T0* _obsolete_mark;T0* _specialized_feature_stamp;T0* _end_comment;T2 _rank;};
extern T363 M363;
struct S779{T890 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T779 M779;
struct S782{T894 _storage;T2 _capacity;T2 _upper;};
extern T782 M782;
struct S290{T0* _owner;T0* _set;T0* _sorted;};
extern T290 M290;
struct S778{Tid id;T0* _item;};
extern T778 M778;
struct S777{T10 _item;T0* _key;T0* _next;};
extern T777 M777;
struct S581{T0* _class_name;T0* _cluster;T0* _path;};
extern T581 M581;
struct S775{T887 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T775 M775;
struct S764{T860 _buckets;T2 _cache_user;T2 _capacity;T2 _count;T0* _free_nodes;};
extern T764 M764;
struct S762{T857 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T762 M762;
struct S582{T0* _classes;T0* _cluster;};
extern T582 M582;
struct S548{T0* _tag;T0* _list;};
extern T548 M548;
struct S322{T0* _new_name;T0* _old_name;};
extern T322 M322;
struct S546{T0* _clients;T0* _list;};
extern T546 M546;
struct S773{T885 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T773 M773;
struct S321{T296 _start_position;T0* _for_all;T0* _items;T0* _permissions;};
extern T321 M321;
struct S76{T0* _type_mark;T0* _class_text;T0* _class_text_name;T0* _parent_lists;T6 _is_insert_member;T0* _rename_list;T0* _export_list;T0* _undefine_list;T0* _redefine_list;T0* _comment;};
extern T76 M76;
struct S772{T882 _storage;T2 _capacity;T2 _upper;};
extern T772 M772;
struct S325{T0* _first;T0* _remainder;};
extern T325 M325;
struct S547{T296 _start_position;T0* _clients;T0* _comment;T0* _procedure_list;};
extern T547 M547;
struct S771{Tid id;T881 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T771 M771;
struct S770{Tid id;T880 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T770 M770;
struct S498{Tid id;T296 _start_position;T0* _hashed_string;T0* _to_string;T0* _result_type;T2 _rank;T2 _parsing_reference_counter;T2 _live_reference_counter;};
extern T498 M498;
struct S494{Tid id;T296 _start_position;T0* _hashed_string;T0* _to_string;T0* _result_type;T2 _rank;};
extern T494 M494;
struct S529{Tid id;T0* _name;};
extern T529 M529;
struct S528{Tid id;T0* _name_list;};
extern T528 M528;
struct S769{T878 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T769 M769;
struct S360{Tid id;T0* _external_tag;};
extern T360 M360;
struct S356{Tid id;T0* _external_tag;T0* _feature_name;T0* _plugin;T2 _hash_code;};
extern T356 M356;
struct S359{Tid id;T0* _external_tag;T0* _rf7_memory;T0* _rf8_memory;};
extern T359 M359;
struct S358{Tid id;T0* _external_tag;T6 _need_prototype;T6 _parsing_done;T6 _macro;T0* _struct;T0* _access;T0* _type;T2 _access_mode;T0* _signature;T6 _c_inline;};
extern T358 M358;
struct S361{Tid id;T0* _external_tag;};
extern T361 M361;
struct S84{T0* _manifest_string;T0* _to_string;T2 _count;T2 _idx;};
extern T84 M84;
struct S345{T296 _start_position;T0* _header_comment;T0* _list;T6 _is_ensure_then;};
extern T345 M345;
struct S397{Tid id;T0* _list;};
extern T397 M397;
struct S395{Tid id;T0* _check_invariant;};
extern T395 M395;
struct S768{T876 _storage;T2 _capacity;T2 _upper;};
extern T768 M768;
struct S349{Tid id;T296 _start_position;T0* _key_list;T0* _compound;};
extern T349 M349;
struct S387{Tid id;T296 _start_position;T0* _expression;T0* _then_compound;};
extern T387 M387;
struct S385{Tid id;T296 _start_position;T0* _expression;T0* _then_compound;T0* _elseif_list;T296 _else_position;T0* _else_compound;};
extern T385 M385;
struct S476{T296 _start_position;T0* _header_comment;T0* _compound;T0* _list;T0* _values;T0* _strip_condition;};
extern T476 M476;
struct S392{Tid id;T296 _start_position;T0* _expression;T0* _when_list;T296 _else_position;T0* _else_compound;T0* _manifest_string_inspector;T0* _condition_type;T0* _first_one;};
extern T392 M392;
struct S532{T296 _start_position;T0* _header_comment;T0* _list;};
extern T532 M532;
struct S531{T0* _comment1;T0* _tag;T0* _comment2;T0* _expression;};
extern T531 M531;
struct S400{Tid id;T296 _start_position;T0* _initialize;T0* _loop_invariant;T0* _loop_variant;T0* _until_expression;T0* _loop_body;};
extern T400 M400;
struct S398{Tid id;T296 _start_position;T0* _explicit_type;T0* _writable;T0* _call;T6 _default_create_call;};
extern T398 M398;
struct S401{Tid id;T296 _start_position;T0* _arguments;T0* _specialized_anonymous_feature;T0* _specialized_parent;T0* _parent;T0* _run_feature;};
extern T401 M401;
struct S394{Tid id;T0* _left_side;T0* _right_side;T6 _forced_flag;};
extern T394 M394;
struct S403{Tid id;T0* _left_side;T0* _right_side;};
extern T403 M403;
struct S393{Tid id;T296 _start_position;};
extern T393 M393;
extern T665 M665;
struct S300{T0* _first;T0* _remainder;};
extern T300 M300;
struct S64{T296 _start_position;T0* _class_name_list;T0* _eiffel_view_memory;};
extern T64 M64;
struct S549{T0* _clients;T0* _comment;T0* _class_text;T0* _list;};
extern T549 M549;
struct S482{T0* _feature_clause;T0* _names;T0* _arguments;T0* _result_type;T0* _anonymous_feature;T0* _header_comment;T0* _obsolete_mark;T296 _sedb_trace_before_exit;};
extern T482 M482;
struct S767{T869 _storage;T2 _capacity;T2 _upper;};
extern T767 M767;
struct S437{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T437 M437;
struct S430{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T430 M430;
struct S453{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T453 M453;
struct S452{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T452 M452;
struct S418{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T418 M418;
struct S429{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T429 M429;
struct S463{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T463 M463;
struct S471{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T471 M471;
struct S458{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T458 M458;
struct S464{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T464 M464;
struct S410{Tid id;T6 _eq_flag;T296 _operator_position;T0* _left_side;T0* _right_side;};
extern T410 M410;
struct S455{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T455 M455;
struct S466{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T466 M466;
struct S420{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T420 M420;
struct S444{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T444 M444;
struct S443{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T443 M443;
struct S462{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T462 M462;
struct S404{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T404 M404;
struct S417{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T417 M417;
struct S421{Tid id;T296 _start_position;T0* _expression;T0* _local_c_name_memory;};
extern T421 M421;
struct S431{Tid id;T296 _start_position;T0* _effective_arg_list;T0* _create_expression;};
extern T431 M431;
struct S438{Tid id;T296 _start_position;};
extern T438 M438;
struct S473{Tid id;T296 _start_position;};
extern T473 M473;
struct S442{Tid id;T296 _start_position;T3 _value;T0* _pretty_view;};
extern T442 M442;
struct S315{Tid id;T296 _start_position;T6 _once_flag;T6 _unicode_flag;T0* _to_string;T0* _unicode_string;T0* _alias_link;T0* _initial_storage_id;T0* _once_variable;T0* _source_view;T2 _hash_code_memory;};
extern T315 M315;
struct S409{Tid id;T296 _start_position;T0* _arguments;T0* _specialized_anonymous_feature;T0* _specialized_parent;T0* _parent;T0* _run_feature;};
extern T409 M409;
struct S293{Tid id;T296 _start_position;T0* _explicit_type_mark;T0* _declaration_type_memory;};
extern T293 M293;
struct S474{Tid id;T296 _start_position;T0* _explicit_type;T0* _writable;T0* _call;T6 _default_create_call;};
extern T474 M474;
struct S450{Tid id;T296 _start_position;T0* _delayed_call;T0* _delayed_proc_call;T0* _capture_list;T0* _agent_equal;T0* _open_list;T0* _open_type_list;};
extern T450 M450;
struct S434{Tid id;T296 _start_position;T0* _declaration_type;};
extern T434 M434;
struct S413{Tid id;T296 _start_position;};
extern T413 M413;
struct S456{Tid id;T296 _start_position;T0* _declaration_type;};
extern T456 M456;
struct S448{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;};
extern T448 M448;
struct S530{Tid id;T0* _class_text_memory;T0* _written_name;T6 _already_checking;T0* _formal_name;T0* _formal_generic_arg;T2 _rank;};
extern T530 M530;
struct S521{T0* _name;T0* _constraint;T2 _rank;};
extern T521 M521;
struct S344{T296 _start_position;T0* _list;T6 _no_generic_constraint_flag;};
extern T344 M344;
struct S332{Tid id;T0* _class_text_memory;T0* _long_name_memory;T0* _class_text_name;T0* _generic_list;T0* _written_name_memory;T0* _declaration_type_memory;T0* _type_memory;T0* _static_memory;T0* _signature_resolved_memory;};
extern T332 M332;
struct S545{Tid id;T0* _class_text_memory;T0* _class_text_name;};
extern T545 M545;
struct S517{Tid id;T0* _class_text_memory;T0* _long_name_memory;T0* _class_text_name;T0* _generic_list;T0* _written_name_memory;T0* _declaration_type_memory;T0* _type_memory;T0* _static_memory;T0* _signature_resolved_memory;};
extern T517 M517;
struct S544{Tid id;T0* _class_text_memory;T0* _long_name_memory;T0* _class_text_name;T0* _generic_list;T0* _written_name_memory;T0* _declaration_type_memory;T0* _type_memory;T0* _static_memory;T0* _signature_resolved_memory;};
extern T544 M544;
struct S543{Tid id;T0* _class_text_memory;T0* _class_text_name;};
extern T543 M543;
struct S542{Tid id;T0* _class_text_memory;T0* _class_text_name;};
extern T542 M542;
struct S541{Tid id;T0* _class_text_memory;T0* _long_name_memory;T0* _class_text_name;T0* _type_memory;};
extern T541 M541;
struct S540{Tid id;T0* _class_text_memory;T0* _class_text_name;};
extern T540 M540;
struct S338{Tid id;T0* _class_text_memory;T0* _class_text_name;T0* _pretty_name;T2 _bit_count;};
extern T338 M338;
struct S538{Tid id;T0* _class_text_memory;T0* _class_text_name;T0* _type_memory;};
extern T538 M538;
struct S536{Tid id;T0* _class_text_memory;T0* _long_name_memory;T0* _class_text_name;T0* _generic_list;T0* _written_name_memory;T0* _declaration_type_memory;T0* _type_memory;T0* _static_memory;T0* _signature_resolved_memory;};
extern T536 M536;
struct S534{Tid id;T0* _class_text_memory;T0* _long_name_memory;T0* _class_text_name;T0* _generic_list;T0* _written_name_memory;T0* _declaration_type_memory;T0* _type_memory;T0* _static_memory;T0* _signature_resolved_memory;T2 _pretty_code;};
extern T534 M534;
struct S526{Tid id;T0* _class_text_memory;T296 _start_position;T0* _like_what;T0* _written_name;T0* _declaration_type;T0* _feature_stamp_memory;};
extern T526 M526;
struct S525{Tid id;T0* _class_text_memory;T296 _start_position;T0* _like_what;T0* _written_name;T0* _type_marks_memory;T6 _like_argument_computing;};
extern T525 M525;
struct S285{Tid id;T0* _list;T0* _flat_list;};
extern T285 M285;
struct S522{Tid id;T0* _class_text_memory;T296 _start_position;};
extern T522 M522;
struct S428{Tid id;T296 _start_position;T0* _curly_type;T2 _rank;T0* _notify_memory;};
extern T428 M428;
struct S436{Tid id;T0* _left_type_mark;T0* _left_writable;T0* _right_side;};
extern T436 M436;
struct S451{Tid id;T296 _start_position;T0* _result_type;T0* _pretty_view;T0* _normalized_memory;};
extern T451 M451;
struct S334{Tid id;T0* _class_text_memory;T0* _class_text_name;T0* _pretty_name;T2 _bit_count_memory;};
extern T334 M334;
struct S469{Tid id;T296 _start_position;T11 _value_memory;T2 _size;T0* _result_type_memory;T0* _pretty_view;};
extern T469 M469;
struct S411{Tid id;T296 _start_position;T0* _type_mark;T0* _optional_arguments;T0* _item_list;T2 _semicolon_count;T0* _created_type;T0* _manifest_make_feature_stamp;T0* _manifest_put_feature_stamp;T296 _irregular_position;};
extern T411 M411;
struct S355{Tid id;T0* _list;T0* _flat_list;};
extern T355 M355;
struct S408{Tid id;T296 _start_position;T0* _declaration_type;T0* _type_mark_memory;T0* _enclosing_function;T0* _once_function;};
extern T408 M408;
struct S415{Tid id;T0* _local_name;T0* _feature_name;T0* _feature_stamp;T0* _run_feature;};
extern T415 M415;
struct S396{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _creation_type;T0* _arguments;};
extern T396 M396;
struct S388{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _creation_type;};
extern T388 M388;
struct S391{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _creation_type;T0* _arguments;};
extern T391 M391;
struct S414{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T414 M414;
struct S447{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;};
extern T447 M447;
struct S461{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;T0* _arguments;};
extern T461 M461;
struct S287{T0* _first_one;T0* _remainder;};
extern T287 M287;
struct S227{T2 _mode;};
extern T227 M227;
struct S454{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;};
extern T454 M454;
struct S459{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;};
extern T459 M459;
struct S460{Tid id;T0* _feature_stamp;T0* _target;T0* _feature_name;T0* _declaration_type_memory;};
extern T460 M460;
struct S77{T2 _name_type;T296 _start_position;T0* _name;};
extern T77 M77;
struct S433{Tid id;T0* _expression;T0* _comment;};
extern T433 M433;
struct S766{T864 _storage;T2 _capacity;T2 _upper;};
extern T766 M766;
struct S465{Tid id;T296 _start_position;T0* _list;};
extern T465 M465;
struct S520{T0* _tag;T0* _expression;T0* _comment;};
extern T520 M520;
struct S765{T863 _storage;T2 _capacity;T2 _upper;};
extern T765 M765;
struct S760{T0* _item;T0* _key;T0* _next;};
extern T760 M760;
struct S759{Tid id;T0* _item;};
extern T759 M759;
struct S758{T856 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T758 M758;
struct S757{Tid id;T0* _item;};
extern T757 M757;
struct S754{T0* _item;T0* _key;T0* _next;};
extern T754 M754;
struct S68{T2 _column;T2 _line;T0* _current_line;T3 _cc;T0* _last_manifest_string;T0* _last_comment;T6 _drop_comments;T2 _start_line;T2 _start_column;T598 _token_buffer;T0* _file_path;T10 _id;T6 _expand_var;T6 _expand_execute;T0* _last_section;T0* _last_key;T0* _default_section;T0* _sections;};
extern T68 M68;
struct S751{T853 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T751 M751;
struct S748{Tid id;T0* _item;};
extern T748 M748;
extern T573 M573;
struct S747{T0* _item;T0* _next;};
extern T747 M747;
struct S743{T852 _storage;T2 _capacity;T2 _upper;};
extern T743 M743;
struct S742{T849 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T742 M742;
struct S282{T0* _path;T0* _path_h;T0* _entries;};
extern T282 M282;
struct S738{T845 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T738 M738;
struct S737{T842 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T737 M737;
struct S734{T6 _item;};
extern T734 M734;
struct S261{T841 _storage;T2 _count;T2 _capacity;T0* _low_surrogate_indexes;T0* _low_surrogate_values;};
extern T261 M261;
struct S309{Tid id;T296 _start_position;T0* _list;};
extern T309 M309;
extern T598 M598;
extern T353 M353;
struct S733{T837 _storage;T2 _capacity;T2 _upper;};
extern T733 M733;
struct S732{T836 _storage;T2 _capacity;T2 _upper;};
extern T732 M732;
struct S731{Tid id;T740 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T731 M731;
struct S225{T0* _hashed_path;T0* _cluster;T2 _count;T0* _text;};
extern T225 M225;
struct S276{T0* _path;T6 _last_scan_status;T496 _basic_directory;T0* _name_list;};
extern T276 M276;
struct S730{T835 _storage;T2 _capacity;T2 _upper;};
extern T730 M730;
struct S352{Tid id;T0* _parent;T2 _distance;T496 _basic_directory;T0* _classeses;};
extern T352 M352;
struct S514{T0* _c_compiler;T0* _c_compiler_path;T0* _c_linker_path;T0* _c_strip_path;T0* _c_compiler_options;T0* _c_linker_options;T0* _cpp_compiler;T0* _cpp_compiler_path;T0* _cpp_strip_path;T0* _cpp_linker_path;T0* _cpp_compiler_options;T0* _cpp_linker_options;T0* _smarteiffel_options;};
extern T514 M514;
struct S511{Tid id;};
extern T511 M511;
struct S510{Tid id;};
extern T510 M510;
struct S509{Tid id;};
extern T509 M509;
struct S508{Tid id;};
extern T508 M508;
struct S507{Tid id;};
extern T507 M507;
struct S506{Tid id;};
extern T506 M506;
struct S729{T0* _item;};
extern T729 M729;
extern T496 M496;
struct S728{Tid id;T832 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T728 M728;
extern T279 M279;
struct S726{T829 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T726 M726;
struct S539{Tid id;T0* _class_text_memory;T0* _class_text_name;};
extern T539 M539;
extern T234 M234;
extern T220 M220;
extern T710 M710;
struct S224{T6 _agent_creation_collected_flag;};
extern T224 M224;
extern T217 M217;
struct S239{T6 _first_manifest_string_collected_flag;T6 _first_unicode_manifest_string_collected_flag;T0* _unicode_string_manifest_initialize_stamp;T0* _unicode_string_type;T0* _se_ums;};
extern T239 M239;
struct S67{T0* _name;T2 _hash_code;T0* _roots;T0* _anonymous_features;T0* _rename_up_context_class;T0* _rename_up_parent_class;T0* _rename_up_edge;T0* _rename_up_parent_feature_stamp;T0* _rename_down_context_class;T0* _rename_down_child_class;T0* _rename_down_edge;T0* _rename_down_child_feature_stamp;T0* _run_features;};
extern T67 M67;
struct S725{T806 _storage;T2 _capacity;T2 _upper;};
extern T725 M725;
extern T238 M238;
struct S231{T0* _context_type;T0* _current_fn;T0* _pending_list;T0* _specialize_2_list;T6 _specialize_2_in_progress;T0* _current_mixer;T2 _waiting_type;T1 _state;T0* _feature_stamp;T0* _features;T0* _free;T0* _features_dictionary;T0* _feature_stamps_memory;T0* _seeds_of_current_feature;T0* _seeds;};
extern T231 M231;
struct S518{T2 _phase;T2 _safety_check_state;T0* _specializing_type_memory;T6 _collecting_done;};
extern T518 M518;
struct S724{T788 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _free_nodes;};
extern T724 M724;
struct S73{T0* _item;T0* _parents;T0* _children;T0* _parents_edge;T0* _children_edge;T6 _mark;T0* _parents_edge_load;T0* _children_edge_load;T0* _default_rescue_compound;T6 _default_rescue_collected;T0* _live_type;T0* _canonical_type_mark;T0* _name;T0* _class_text;T0* _private_generic_list;T2 _hash_code;T0* _class_invariant;T6 _is_deferred;T0* _feature_stamps;T0* _writable_attributes_memory;T0* _temporary_simple_feature_name;};
extern T73 M73;
struct S244{T10 _id;T0* _path;T0* _cluster;T0* _index_list;T0* _heading_comment1;T6 _is_deferred;T6 _is_expanded;T0* _name;T0* _formal_generic_list;T0* _heading_comment2;T0* _obsolete_mark;T0* _parent_lists;T0* _creation_clause_list;T0* _feature_clause_list;T0* _class_invariant;T0* _end_comment;T6 _sedb_trace;T2 _hash_code;T2 _native_array_collector_memory;T0* _check_expanded_with_flag;T0* _feature_dictionary;T0* _declaration_type_of_like_current_memory;T2 _assertion_level;T0* _once_mark_list;T6 _creation_list_check_done;};
extern T244 M244;
struct S317{T0* _type;T0* _canonical_type_mark;T0* _name;T0* _class_text;T0* _class_text_name;T2 _id;T6 _at_run_time;T0* _run_time_set;T6 _compile_to_c_done;T2 _hash_code;T0* _precursor_features;T0* _precursor_classes;T0* _precursor_run_features;T0* _live_features;T6 _is_collecting;T6 _has_been_collected;T2 _generating_type_level;T2 _native_array_collector_memory;T2 _tagged_memory;T0* _default_create_stamp;T0* _memory_dispose_stamp;T0* _actual_clients;T0* _structure_signature_memory;T6 _collecting_deep_twin;T1 _collect_is_deep_equal_status;T0* _create_blank_internals_instruction;T0* _to_internals_stamp;T0* _create_function_list;T0* _default_create_run_feature_memory;T0* _writable_attributes_mem;T2 _c_header_pass_level_done;};
extern T317 M317;
struct S722{T776 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T722 M722;
struct S301{T0* _default_debug_keys;T0* _tree;T0* _class_text_map;T0* _name;T0* _directory_path;T2 _default_assertion_level;T3 _default_trace;T0* _option_assertion_level;T0* _option_debug_keys;T0* _option_trace;T0* _include_list;T0* _exclude_list;T0* _type_dictionary;T0* _pool;};
extern T301 M301;
struct S242{T0* _filter;T0* _path;T6 _end_of_input;T3 _filtered_last_character;T8 _input_stream;T9 _buffer;T6 _end_reached;T2 _buffer_size;T2 _buffer_position;T2 _capacity;};
extern T242 M242;
extern T302 M302;
struct S245{T296 _start_position;T0* _hashed_name;T0* _to_string;T2 _hash_code;T0* _class_text_memory;T6 _has_tried_to_load;};
extern T245 M245;
struct S721{T753 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T0* _free_nodes;};
extern T721 M721;
extern T296 M296;
struct S60{T0* _to_string;T2 _hash_code;};
extern T60 M60;
struct S718{T746 _buckets;T2 _cache_user;T2 _capacity;T2 _count;T0* _free_nodes;};
extern T718 M718;
struct S45{Tid id;T0* _filter;T2 _buffer_position;T9 _buffer;T2 _capacity;};
extern T45 M45;
struct S32{Tid id;T0* _filter;};
extern T32 M32;
struct S280{Tid id;T0* _filter;T0* _path;T11 _flushed_character_count;T9 _buffer;T2 _buffer_position;T2 _capacity;T8 _output_stream;};
extern T280 M280;
extern T477 M477;
extern T254 M254;
struct S232{T2 _inlined_procedure_count;T2 _inlined_function_count;T2 _procedure_count;T2 _function_count;T2 _precursor_routine_count;T2 _real_procedure_count;T2 _real_function_count;T2 _top;T0* _unused_contexts;T2 _direct_call_count;T2 _check_id_call_count;T2 _sure_void_count;T2 _switched_call_count;T6 _pending_c_function;T6 _assertion_checks_disabled;T2 _function_count_in_file;T2 _inspect_tmp;T0* _c_plus_plus;T0* _out_c;T0* _out_h;T0* _check_assertion_mode;T2 _split_count;T6 _executable_is_up_to_date;T0* _include_memory;};
extern T232 M232;
struct S63{T2 _error_counter;T2 _warning_counter;T6 _no_warning;};
extern T63 M63;
struct S59{T2 _state;T0* _cecil_files;};
extern T59 M59;
struct S717{T0* _item;};
extern T717 M717;
struct S219{T6 _is_off;T6 _info_flag;T6 _dispose_flag;};
extern T219 M219;
struct S716{Tid id;T740 _storage;T2 _capacity;T2 _upper;};
extern T716 M716;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
extern T704 M704;
struct S241{T2 _column;T2 _line;T0* _current_line;T3 _cc;T0* _last_manifest_string;T0* _last_comment;T6 _drop_comments;T2 _start_line;T2 _start_column;T598 _token_buffer;T6 _no_style_warning;T6 _is_running;T10 _current_id;T0* _cluster;T0* _last_class_text;T6 _inside_function_flag;T6 _inside_ensure_flag;T6 _inside_rescue_flag;T6 _tuple_flag;T0* _formal_generic_list;T0* _arguments;T0* _local_vars;T6 _ok;T0* _last_expression;T0* _last_type_mark;T0* _last_class_name;T0* _last_feature_declaration;T0* _last_feature_name;T0* _last_feature_name_list;T0* _last_formal_generic_type_mark;T0* _last_instruction;T0* _last_parent_edge;T0* _last_tag_mark;T665 _tmp_feature;};
extern T241 M241;
struct S80{T2 _column;T2 _line;T0* _current_line;T3 _cc;T0* _last_comment;T6 _drop_comments;T2 _start_line;T2 _start_column;T598 _token_buffer;T0* _default_debug_keys;T0* _file_path;T0* _executable_name;T6 _flat_check;T6 _no_main;T6 _safety_check;T6 _manifest_string_trace;T6 _high_memory_compiler;T6 _profile;T6 _relax;T6 _precompile_header;T6 _clean;T2 _highest_encountered_level;T6 _default_trace;T2 _default_assertion_level;T6 _no_split;T0* _root_procedure_name_memory;T6 _sedb_flag;};
extern T80 M80;
struct S235{T0* _system_name;T0* _system_flavor;T0* _seconf;T0* _config;T0* _sys_directory;T0* _bin_directory;T0* _short_directory;T6 _no_strip;T0* _is_win_like;T0* _is_unix_like;T496 _basic_directory;T6 _is_alternate_c_mode;T0* _c_compiler;T2 _c_compiler_mode;T0* _c_compiler_path;T0* _c_linker_path;T0* _c_strip_path;T0* _cpp_compiler;T0* _cpp_compiler_path;T0* _cpp_linker_path;T0* _cpp_strip_path;T0* _ace_compiler_options;T0* _ace_linker_options;T0* _smarteiffel_options;T6 _c_mode_has_explicit_linker_path_or_option;T0* _extra_loadpath_files;T0* _config_loadpath_files;T0* _config_loadpath_names;T0* _plugins;T0* _plugin_factory;};
extern T235 M235;
struct S236{T6 _short_or_class_check_flag;T6 _pretty_flag;T6 _no_id;T6 _generating_type_used;T6 _generator_used;T6 _deep_twin_used;T0* _root_procedure;T0* _run_features;T0* _class_invariants;T0* _agent_creations;T0* _agent_switches;T2 _magic_count;T6 _simplify_done;T0* _se_atexit_stamp;T2 _se_atexit_id;T0* _specializing_feature_local_var_list;T0* _type_any_memory;T0* _type_boolean_memory;T0* _type_character_memory;T0* _type_string_memory;T0* _type_unicode_string_memory;T0* _type_pointer_memory;T0* _type_integer_8_memory;T0* _type_integer_16_memory;T0* _type_integer_32_memory;T0* _type_integer_64_memory;T0* _type_real_32_memory;T0* _type_real_64_memory;T0* _type_real_extended_memory;T0* _old_list;};
extern T236 M236;
struct S66{T10 _max_id;T10 _min_id;};
extern T66 M66;
extern T85 M85;
struct S218{T6 _is_verbose;T2 _output_state;T0* _output_stream;T0* _error_stream;T0* _output_path;};
extern T218 M218;
extern T255 M255;
struct S25{T6 _help_flag;T6 _version_flag;T0* _level_flag;};
extern T25 M25;
extern char*s390_1195446850;
extern char*s66_0;
extern char*s239_1418906530;
extern char*s30_424424;
extern char*s317_25969530;
extern char*s231_10;
extern char*s30_424430;
extern char*s403_1114345928;
extern char*s500_1983193131;
extern char*s26_199827552;
extern char*s232_1564992795;
extern char*s360_59375621;
extern char*s360_1911859989;
extern char*s232_1772404517;
extern char*s407_1203129469;
extern char*s547_772854717;
extern char*s241_1078639380;
extern char*s241_1138390195;
extern char*s232_12331;
extern char*s236_34;
extern char*s450_1880914324;
extern char*s30_38;
extern char*s234_40;
extern char*s432_41;
extern char*s469_7233618;
extern char*s30_42;
extern char*s30_43;
extern char*s232_36951;
extern char*s30_45;
extern char*s238_46;
extern char*s30_47;
extern char*s25_1889925553;
extern char*s218_1071750288;
extern char*s416_532898088;
extern char*s241_12362;
extern char*s30_60;
extern char*s30_61;
extern char*s360_2017590;
extern char*s30_62;
extern char*s26_63;
extern char*s30_64;
extern char*s68_1684808173;
extern char*s493_1216329562;
extern char*s241_67;
extern char*s358_219498506;
extern char*s26_1202957293;
extern char*s29_212160365;
extern char*s493_80037;
extern char*s30_12376;
extern char*s231_325166540;
extern char*s484_77;
extern char*s309_77;
extern char*s622_79;
extern char*s232_441192857;
extern char*s232_1206795525;
extern char*s289_82;
extern char*s291_306811962;
extern char*s291_1665297219;
extern char*s317_84;
extern char*s234_1645835456;
extern char*s239_2189840;
extern char*s235_301485;
extern char*s232_392938270;
extern char*s360_91;
extern char*s329_585895143;
extern char*s241_1656587411;
extern char*s232_93;
extern char*s30_94;
extern char*s241_916596;
extern char*s622_2008215484;
extern char*s235_99;
extern char*s544_101;
extern char*s80_376816512;
extern char*s235_273430505;
extern char*s219_158634393;
extern char*s26_104;
extern char*s627_105;
extern char*s235_109;
extern char*s301_178490;
extern char*s30_112335826;
extern char*s234_114;
extern char*s244_772983982;
extern char*s26_118;
extern char*s219_6271;
extern char*s385_10007800;
extern char*s411_123;
extern char*s30_124;
extern char*s30_126;
extern char*s217_273430530;
extern char*s232_391886489;
extern char*s241_629850238;
extern char*s232_2145444338;
extern char*s232_1629400044;
extern char*s30_80109;
extern char*s394_252339;
extern char*s413_2066164109;
extern char*s301_202915491;
extern char*s476_6305;
extern char*s241_280897875;
extern char*s627_227751;
extern char*s29_1473988901;
extern char*s614_37074;
extern char*s294_168;
extern char*s520_145102259;
extern char*s235_539873441;
extern char*s239_1853640928;
extern char*s665_1876110531;
extern char*s392_1470642763;
extern char*s241_470853074;
extern char*s239_6330;
extern char*s235_180;
extern char*s239_1368099455;
extern char*s287_37095;
extern char*s317_61699;
extern char*s29_436911;
extern char*s63_192;
extern char*s80_1341859296;
extern char*s69_1604340919;
extern char*s500_42706587;
extern char*s241_194;
extern char*s232_475921520;
extern char*s317_619030689;
extern char*s63_200;
extern char*s59_6355;
extern char*s239_204;
extern char*s460_205;
extern char*s238_580488532;
extern char*s291_212314278;
extern char*s315_905138318;
extern char*s317_215;
extern char*s236_216;
extern char*s30_217;
extern char*s30_218;
extern char*s360_160146;
extern char*s232_993675817;
extern char*s30_220;
extern char*s241_873294598;
extern char*s30_54688766;
extern char*s360_4638080;
extern char*s410_226;
extern char*s241_1922692108;
extern char*s59_227;
extern char*s80_1302880443;
extern char*s618_228;
extern char*s232_585944489;
extern char*s407_230;
extern char*s411_230;
extern char*s442_236;
extern char*s291_237;
extern char*s410_240;
extern char*s85_240;
extern char*s358_241;
extern char*s241_241;
extern char*s499_242;
extern char*s469_36137368;
extern char*s291_244;
extern char*s360_6396;
extern char*s410_245;
extern char*s436_246;
extern char*s360_247;
extern char*s30_1682815431;
extern char*s499_248;
extern char*s232_249;
extern char*s232_251;
extern char*s244_251;
extern char*s63_252;
extern char*s289_254;
extern char*s360_255;
extern char*s291_255;
extern char*s357_257;
extern char*s232_257;
extern char*s407_258;
extern char*s450_259;
extern char*s360_6411;
extern char*s29_10703002;
extern char*s236_262;
extern char*s232_1312728230;
extern char*s394_264;
extern char*s360_265;
extern char*s457_184795;
extern char*s534_1428348580;
extern char*s309_270;
extern char*s520_271;
extern char*s232_272;
extern char*s360_6425;
extern char*s289_274;
extern char*s69_116346440;
extern char*s239_1017947719;
extern char*s506_276;
extern char*s232_277a;
extern char*s224_277;
extern char*s232_277;
extern char*s622_277;
extern char*s469_278;
extern char*s236_1255776138;
extern char*s236_1131876546;
extern char*s220_282;
extern char*s30_282;
extern char*s317_284;
extern char*s232_284;
extern char*s519_287;
extern char*s519_80251;
extern char*s334_293;
extern char*s334_294;
extern char*s411_594795843;
extern char*s338_295;
extern char*s360_296;
extern char*s30_296;
extern char*s235_297;
extern char*s392_244699380;
extern char*s235_298;
extern char*s301_299;
extern char*s63_300;
extern char*s630_541688116;
extern char*s235_301;
extern char*s701_302;
extern char*s232_6455;
extern char*s411_305;
extern char*s394_2042716661;
extern char*s224_317;
extern char*s30_406284;
extern char*s30_42134669;
extern char*s547_325449730;
extern char*s232_1238750212;
extern char*s218_322;
extern char*s241_1088075316;
extern char*s76_90592250;
extern char*s219_35343969;
extern char*s594_324;
extern char*s317_325;
extern char*s235_326;
extern char*s553_327;
extern char*s450_327;
extern char*s219_197159;
extern char*s235_327;
extern char*s28_329;
extern char*s291_1710309;
extern char*s28_331;
extern char*s235_333;
extern char*s235_334;
extern char*s28_334;
extern char*s231_107193812;
extern char*s27_336;
extern char*s294_142931125;
extern char*s235_340;
extern char*s235_341;
extern char*s358_345;
extern char*s241_727030093;
extern char*s30_1501191;
extern char*s359_348;
extern char*s29_437070;
extern char*s226_1568216255;
extern char*s236_36611104;
extern char*s30_1578334651;
extern char*s382_301503927;
extern char*s465_360;
extern char*s469_360;
extern char*s30_361;
extern char*s399_1136256141;
extern char*s317_754574290;
extern char*s410_366;
extern char*s317_775396;
extern char*s69_1700247488;
extern char*s30_371;
extern char*s465_372;
extern char*s394_376;
extern char*s291_377;
extern char*s234_379;
extern char*s30_548214405;
extern char*s442_898426;
extern char*s234_175857472;
extern char*s317_382;
extern char*s360_6534;
extern char*s317_197373672;
extern char*s232_301786;
extern char*s235_62728285;
extern char*s441_1639500234;
extern char*s220_397;
extern char*s219_6550;
extern char*s665_1962655329;
extern char*s235_402;
extern char*s317_2054563574;
extern char*s410_1442631340;
extern char*s450_404;
extern char*s29_9909665;
extern char*s291_1748680500;
extern char*s234_6559;
extern char*s241_1011636926;
extern char*s289_1484470448;
extern char*s629_1212159;
extern char*s241_1733505988;
extern char*s317_419;
extern char*s232_1601653158;
extern char*s232_1957408550;
extern char*s232_781060556;
extern char*s220_726728775;
extern char*s399_343527626;
extern char*s547_1604599495;
extern char*s69_74239;
extern char*s450_6580;
extern char*s554_1808265259;
extern char*s301_205111678;
extern char*s232_738637120;
extern char*s69_696478167;
extern char*s73_38905513;
extern char*s665_1604408825;
extern char*s500_1447552176;
extern char*s317_526175446;
extern char*s30_80416;
extern char*s232_1793244543;
extern char*s30_878996813;
extern char*s232_10666295;
extern char*s224_339308075;
extern char*s317_6614;
extern char*s701_1935504882;
extern char*s360_471;
extern char*s382_1084920002;
extern char*s59_471;
extern char*s309_1240817101;
extern char*s540_476;
extern char*s235_1192507148;
extern char*s30_1639475718;
extern char*s450_1938986363;
extern char*s360_529853775;
extern char*s419_1937147216;
extern char*s301_397816412;
extern char*s235_1721407046;
extern char*s629_283801480;
extern char*s500_1655357614;
extern char*s627_499;
extern char*s29_2073386;
extern char*s232_6651;
extern char*s241_2117894368;
extern char*s241_924385084;
extern char*s219_6655;
extern char*s26_613587359;
extern char*s457_506;
extern char*s239_215791;
extern char*s627_1181502;
extern char*s701_1942892277;
extern char*s241_1524784203;
extern char*s232_365905049;
extern char*s400_334725631;
extern char*s305_25373399;
extern char*s232_526;
extern char*s30_534;
extern char*s358_535;
extern char*s235_6687;
extern char*s232_932172292;
extern char*s241_955638361;
extern char*s29_10315778;
extern char*s241_9897510;
extern char*s30_552;
extern char*s232_1901889757;
extern char*s291_25822456;
extern char*s241_1471861047;
extern char*s393_550508910;
extern char*s29_1532343833;
extern char*s576_68224;
extern char*s63_22396357;
extern char*s415_178948;
extern char*s442_570;
extern char*s217_570;
extern char*s627_574;
extern char*s29_54418471;
extern char*s241_1228072329;
extern char*s627_576;
extern char*s232_1988895671;
extern char*s80_1476966395;
extern char*s232_1290234339;
extern char*s241_1961160815;
extern char*s625_1894299446;
extern char*s410_1037594318;
extern char*s241_751585121;
extern char*s29_2233396;
extern char*s26_1724187394;
extern char*s29_48390502;
extern char*s239_589;
extern char*s235_2077353217;
extern char*s80_2132072515;
extern char*s27_594;
extern char*s30_9713026;
extern char*s30_36193081;
extern char*s444_2080244194;
extern char*s29_600;
extern char*s69_1317175740;
extern char*s235_603;
extern char*s291_604;
extern char*s291_6755;
extern char*s241_1207921682;
extern char*s236_801894175;
extern char*s241_437331;
extern char*s521_1773450779;
extern char*s399_1260488135;
extern char*s29_611;
extern char*s30_548331507;
extern char*s291_614;
extern char*s239_1419097826;
extern char*s219_185146;
extern char*s235_179868158;
extern char*s360_475042348;
extern char*s301_620;
extern char*s629_68284;
extern char*s394_6775;
extern char*s232_625;
extern char*s232_5395053;
extern char*s29_627;
extern char*s218_354654986;
extern char*s30_51915068;
extern char*s69_85511833;
extern char*s411_1367878466;
extern char*s317_635;
extern char*s30_636;
extern char*s82_1861287086;
extern char*s358_449661;
extern char*s29_640;
extern char*s392_2251910;
extern char*s499_1552636066;
extern char*s232_651;
extern char*s29_1690381566;
extern char*s232_934202231;
extern char*s30_1744399653;
extern char*s360_6810;
extern char*s239_660;
extern char*s29_661;
extern char*s232_203646;
extern char*s238_97543221;
extern char*s13_1432888418;
extern char*s627_1175100011;
extern char*s30_669;
extern char*s360_670;
extern char*s29_670;
extern char*s294_671;
extern char*s386_925886099;
extern char*s329_43730;
extern char*s317_351281;
extern char*s235_674;
extern char*s241_1135641353;
extern char*s544_6830;
extern char*s500_378711602;
extern char*s235_1087245292;
extern char*s246_685;
extern char*s235_686;
extern char*s235_689;
extern char*s217_1713607783;
extern char*s630_448217916;
extern char*s239_905827712;
extern char*s219_1824264277;
extern char*s291_699;
extern char*s544_619166512;
extern char*s59_228498053;
extern char*s76_875060418;
extern char*s30_1115958189;
extern char*s30_1206543966;
extern char*s500_1197649626;
extern char*s25_1325879523;
extern char*s241_316863332;
extern char*s317_10937200;
extern char*s232_6877;
extern char*s235_13028;
extern char*s30_80694;
extern char*s291_1290234494;
extern char*s68_1385667261;
extern char*s30_849712179;
extern char*s232_1365405869;
extern char*s64_740;
extern char*s219_101227749;
extern char*s476_744;
extern char*s235_1772235;
extern char*s394_1261705;
extern char*s394_750;
extern char*s236_1460051321;
extern char*s80_527202963;
extern char*s232_1195084695;
extern char*s428_207996821;
extern char*s411_589832448;
extern char*s219_40031469;
extern char*s360_68406039;
extern char*s360_1449951397;
extern char*s291_5161461;
extern char*s224_644847010;
extern char*s30_567319806;
extern char*s229_6926;
extern char*s235_51699930;
extern char*s394_7867907;
extern char*s30_1597390874;
extern char*s30_567319812;
extern char*s232_7720290;
extern char*s226_899910547;
extern char*s317_2092663259;
extern char*s360_6946;
extern char*s232_1994813154;
extern char*s547_282823780;
extern char*s317_1824713404;
extern char*s30_9676326;
extern char*s317_926003101;
extern char*s450_80771;
extern char*s28_1473362143;
extern char*s80_1091711046;
extern char*s329_49159605;
extern char*s360_6965;
extern char*s30_1671553525;
extern char*s217_1981256377;
extern char*s629_173055;
extern char*s235_10937305;
extern char*s358_55156846;
extern char*s241_52979396;
extern char*s525_1083118122;
extern char*s385_400650;
extern char*s29_400652;
extern char*s360_427390771;
extern char*s80_1707020207;
extern char*s360_6995;
extern char*s244_142319;
extern char*s29_11251026;
extern char*s547_170383550;
extern char*s317_7006;
extern char*s235_373286592;
extern char*s232_282430172;
extern char*s241_1275558331;
extern char*s241_888875725;
extern char*s291_1648235130;
extern char*s30_1498845794;
extern char*s400_31625;
extern char*s701_1331532446;
extern char*s410_1769582063;
extern char*s360_7025;
extern char*s530_672729595;
extern char*s544_1288623074;
extern char*s291_730579755;
extern char*s80_1130154866;
extern char*s701_7037;
extern char*s236_1814748872;
extern char*s305_345225764;
extern char*s627_1291760099;
extern char*s30_80854;
extern char*s30_13194;
extern char*s73_1820580025;
extern char*s358_1689502217;
extern char*s29_10193105;
extern char*s30_10377643;
extern char*s235_703496930;
extern char*s544_1295032451;
extern char*s236_604558099;
extern char*s291_7066;
extern char*s382_501491947;
extern char*s236_1786429697;
extern char*s29_1975394;
extern char*s30_1594034;
extern char*s30_2246041;
extern char*s544_1012357115;
extern char*s84_51017327;
extern char*s239_934;
extern char*s317_1809213019;
extern char*s29_1839765037;
extern char*s235_830570470;
extern char*s360_240830;
extern char*s231_1752297822;
extern char*s232_1642367158;
extern char*s317_273431355;
extern char*s80_708319;
extern char*s317_915251302;
extern char*s344_171706123;
extern char*s235_50863580;
extern char*s279_1747846;
extern char*s627_7118;
extern char*s30_1607595572;
extern char*s500_557767498;
extern char*s29_1992063831;
extern char*s59_207160501;
extern char*s317_124454155;
extern char*s411_1496963692;
extern char*s232_54714119;
extern char*s360_87090;
extern char*s239_1586448448;
extern char*s544_77282146;
extern char*s360_185515;
extern char*s534_540477054;
extern char*s428_13290;
extern char*s59_1761241425;
extern char*s232_1500500537;
extern char*s239_437715;
extern char*s241_1587734026;
extern char*s291_160930;
extern char*s241_1703575813;
extern char*s630_2131482433;
extern char*s493_160937;
extern char*s80_89867121;
extern char*s232_514187710;
extern char*s348_1615634978;
extern char*s241_2080029331;
extern char*s232_1346694814;
extern char*s241_1090616383;
extern char*s236_1365578385;
extern char*s484_308580;
extern char*s236_713806135;
extern char*s241_1581435442;
extern char*s332_743946038;
extern char*s350_1043;
extern char*s235_17494489;
extern char*s351_1047;
extern char*s63_7207;
extern char*s29_10876026;
extern char*s239_437780;
extern char*s241_1380562254;
extern char*s500_1092806174;
extern char*s544_1719402393;
extern char*s238_23085765;
extern char*s291_1574324912;
extern char*s232_1102979933;
extern char*s27_87180;
extern char*s244_439490016;
extern char*s236_385188989;
extern char*s241_1934613587;
extern char*s232_965818786;
extern char*s428_79072176;
extern char*s428_68732;
extern char*s80_208962844;
extern char*s241_2091587115;
extern char*s394_1016822887;
extern char*s26_142550;
extern char*s232_4620481;
extern char*s26_1090;
extern char*s360_1102979958;
extern char*s232_901897617;
extern char*s279_1027113524;
extern char*s220_1901755;
extern char*s416_580292587;
extern char*s415_99702656;
extern char*s236_1839715989;
extern char*s224_302501127;
extern char*s665_1630520481;
extern char*s622_1101;
extern char*s321_1554555636;
extern char*s239_893005;
extern char*s411_1034900711;
extern char*s317_2136427942;
extern char*s301_1112;
extern char*s232_2110526086;
extern char*s241_1617443474;
extern char*s465_1330923746;
extern char*s232_588411932;
extern char*s244_1121;
extern char*s392_327012886;
extern char*s241_1717397235;
extern char*s627_1132;
extern char*s241_1003875089;
extern char*s27_2141685;
extern char*s469_1446625;
extern char*s390_1759986771;
extern char*s232_4620546;
extern char*s317_7296;
extern char*s290_927498134;
extern char*s219_10322525;
extern char*s416_1099750743;
extern char*s360_1628970485;
extern char*s66_1133285999;
extern char*s30_1157;
extern char*s25_840215460;
extern char*s232_273443870;
extern char*s357_7317;
extern char*s232_1350760769;
extern char*s499_2092688244;
extern char*s544_419443;
extern char*s400_1867518592;
extern char*s235_1964046235;
extern char*s236_1142598643;
extern char*s80_305465997;
extern char*s30_1944903;
extern char*s340_235492225;
extern char*s30_55040341;
extern char*s279_28418819;
extern char*s29_10648581;
extern char*s241_1819737650;
extern char*s13_1210;
extern char*s27_2246326;
extern char*s235_1215;
extern char*s80_767646015;
extern char*s450_1096872141;
extern char*s239_1839365502;
extern char*s30_9529116;
extern char*s464_11300605;
extern char*s220_43088975;
extern char*s627_628172096;
extern char*s236_1091330094;
extern char*s544_7374;
extern char*s59_738514888;
extern char*s218_1430004157;
extern char*s63_188916891;
extern char*s241_155929078;
extern char*s236_646243744;
extern char*s30_1235;
extern char*s241_911265735;
extern char*s59_178134198;
extern char*s405_1240;
extern char*s291_407207;
extern char*s547_1700082283;
extern char*s360_520388145;
extern char*s30_55040391;
extern char*s360_704592146;
extern char*s30_1247;
extern char*s321_1377394679;
extern char*s554_1088174660;
extern char*s241_445001496;
extern char*s219_52555395;
extern char*s26_513843490;
extern char*s30_55040401;
extern char*s232_499425548;
extern char*s63_4479182;
extern char*s450_1485929081;
extern char*s291_1029549485;
extern char*s30_2067995;
extern char*s360_870841390;
extern char*s239_1264;
extern char*s232_1919660703;
extern char*s66_1265;
extern char*s484_2115846852;
extern char*s450_281920051;
extern char*s450_1269;
extern char*s484_1271;
extern char*s219_1271;
extern char*s244_74133124;
extern char*s220_148900;
extern char*s625_182255408;
extern char*s360_1280;
extern char*s219_1284;
extern char*s231_4774460;
extern char*s410_1285;
extern char*s499_2000361;
extern char*s360_1291;
extern char*s235_932412928;
extern char*s419_1083579905;
extern char*s394_1295;
extern char*s232_1295;
extern char*s627_25900;
extern char*s627_1297;
extern char*s301_1642232185;
extern char*s665_1952642401;
extern char*s627_685204250;
extern char*s29_877484516;
extern char*s493_1312;
extern char*s26_1511689536;
extern char*s29_1988096;
extern char*s450_7475;
extern char*s30_747962924;
extern char*s234_32080;
extern char*s518_902076231;
extern char*s408_1686701;
extern char*s29_945182441;
extern char*s232_1330;
extern char*s544_26635163;
extern char*s30_1245671098;
extern char*s235_1335;
extern char*s541_13637;
extern char*s241_2097430832;
extern char*s69_140920753;
extern char*s625_37202594;
extern char*s411_412142950;
extern char*s547_1304837581;
extern char*s294_918554786;
extern char*s29_87466;
extern char*s232_411134193;
extern char*s360_618933431;
extern char*s321_413151726;
extern char*s317_1068122514;
extern char*s219_2077255577;
extern char*s358_116864219;
extern char*s547_1081673178;
extern char*s305_590983311;
extern char*s403_762122588;
extern char*s80_139303084;
extern char*s329_2028521226;
extern char*s69_996106634;
extern char*s232_1880060695;
extern char*s241_1910692676;
extern char*s241_1466196812;
extern char*s544_1396;
extern char*s232_1618833880;
extern char*s500_1846931416;
extern char*s80_86060043;
extern char*s701_1807195960;
extern char*s436_1127350535;
extern char*s64_87520;
extern char*s291_1994331;
extern char*s219_1407;
extern char*s28_711020104;
extern char*s291_1414;
extern char*s69_181806522;
extern char*s217_1417;
extern char*s627_32175;
extern char*s493_32176;
extern char*s500_39109479;
extern char*s399_1732344459;
extern char*s241_2110077371;
extern char*s329_1426;
extern char*s30_87541;
extern char*s30_1427;
extern char*s224_489233515;
extern char*s236_1459510708;
extern char*s218_210310269;
extern char*s399_1382321814;
extern char*s286_1318898854;
extern char*s360_29107967;
extern char*s232_1540494783;
extern char*s235_1438;
extern char*s232_2087300232;
extern char*s317_1124779458;
extern char*s26_941571923;
extern char*s351_1452;
extern char*s526_90494969;
extern char*s80_1689176777;
extern char*s232_78906490;
extern char*s239_1924772383;
extern char*s291_81437;
extern char*s232_1476;
extern char*s360_813409;
extern char*s338_1478;
extern char*s239_188283590;
extern char*s305_934695142;
extern char*s232_1273572186;
extern char*s26_579450289;
extern char*s241_54634669;
extern char*s317_340114884;
extern char*s232_1493;
extern char*s30_1375414302;
extern char*s241_1744209811;
extern char*s232_13801;
extern char*s232_586511651;
extern char*s236_1500;
extern char*s324_511703191;
extern char*s291_479982486;
extern char*s232_1404852998;
extern char*s394_35382059;
extern char*s241_49203356;
extern char*s232_2142659303;
extern char*s394_354065377;
extern char*s231_582925635;
extern char*s360_842325609;
extern char*s241_2047201942;
extern char*s241_1909979286;
extern char*s218_1680762272;
extern char*s30_880412606;
extern char*s29_2234341;
extern char*s236_1709309070;
extern char*s235_1102814319;
extern char*s493_1530;
extern char*s241_833080669;
extern char*s360_1679636650;
extern char*s219_49806180;
extern char*s358_413651;
extern char*s291_129037214;
extern char*s30_279656751;
extern char*s241_962885232;
extern char*s30_859431564;
extern char*s232_490869799;
extern char*s241_791727511;
extern char*s232_1164920984;
extern char*s403_1940475971;
extern char*s241_2099054905;
extern char*s382_643795973;
extern char*s450_1111954737;
extern char*s29_1957581;
extern char*s80_1553744164;
extern char*s219_1565;
extern char*s360_511943145;
extern char*s241_2037548;
extern char*s291_1111960899;
extern char*s217_1471782099;
extern char*s29_407540;
extern char*s241_955584028;
extern char*s30_438300;
extern char*s389_237128790;
extern char*s219_1203432441;
extern char*s232_1661632742;
extern char*s219_2006740748;
extern char*s30_761722990;
extern char*s411_1319735562;
extern char*s241_1208507031;
extern char*s289_1185483839;
extern char*s239_341357508;
extern char*s218_3556890;
extern char*s69_1038536453;
extern char*s317_1191155066;
extern char*s235_2011772281;
extern char*s235_1626;
extern char*s26_7779;
extern char*s241_2055333675;
extern char*s232_1607940692;
extern char*s232_860532685;
extern char*s235_2139128753;
extern char*s224_1783951564;
extern char*s29_1532344910;
extern char*s30_619776399;
extern char*s29_479921113;
extern char*s622_1644;
extern char*s360_32400;
extern char*s289_1923813010;
extern char*s291_1646;
extern char*s241_1182051618;
extern char*s321_2141380032;
extern char*s241_1254996328;
extern char*s317_687744958;
extern char*s392_1650;
extern char*s291_1651;
extern char*s547_265238926;
extern char*s392_180037;
extern char*s235_7809;
extern char*s241_401981819;
extern char*s232_1164208;
extern char*s294_1046299075;
extern char*s291_349661420;
extern char*s317_23313965;
extern char*s450_1676;
extern char*s30_1326673961;
extern char*s360_32435;
extern char*s291_44739;
extern char*s241_1668608056;
extern char*s27_1994621;
extern char*s241_1289042164;
extern char*s360_32456;
extern char*s232_14005;
extern char*s239_192841706;
extern char*s231_1875884480;
extern char*s521_1110386385;
extern char*s421_680166993;
extern char*s239_7869;
extern char*s63_2082988666;
extern char*s416_183516812;
extern char*s394_1727;
extern char*s235_7878;
extern char*s360_1586596820;
extern char*s360_29126717;
extern char*s627_620926730;
extern char*s29_14036;
extern char*s30_55926626;
extern char*s544_161665;
extern char*s547_1857191624;
extern char*s226_1797674551;
extern char*s235_1744;
extern char*s556_1115076;
extern char*s392_180128;
extern char*s241_941240074;
extern char*s451_1753;
extern char*s80_608446371;
extern char*s411_112048371;
extern char*s234_1852104762;
extern char*s294_22612837;
extern char*s234_1765;
extern char*s399_176104896;
extern char*s69_256559978;
extern char*s469_1712194128;
extern char*s399_1458557644;
extern char*s244_1052333303;
extern char*s241_1296817101;
extern char*s630_1851557341;
extern char*s235_1775;
extern char*s435_7506001;
extern char*s234_1364588829;
extern char*s236_36778611;
extern char*s241_970900228;
extern char*s232_565063403;
extern char*s665_2108232434;
extern char*s629_1172831412;
extern char*s234_308542101;
extern char*s232_4049151;
extern char*s360_1220661594;
extern char*s291_1523807481;
extern char*s394_1801;
extern char*s500_1658151484;
extern char*s241_1917483795;
extern char*s236_89019087;
extern char*s29_2185421;
extern char*s29_251171752;
extern char*s241_1778077539;
extern char*s30_312005144;
extern char*s241_1665385073;
extern char*s446_1771711260;
extern char*s279_1826;
extern char*s411_1832;
extern char*s360_1651828280;
extern char*s219_54714979;
extern char*s305_1813679543;
extern char*s360_1840;
extern char*s360_108351709;
extern char*s30_94407393;
extern char*s499_11319686;
extern char*s30_14150;
extern char*s291_32605;
extern char*s241_50040236;
extern char*s232_1154403080;
extern char*s232_426087775;
extern char*s232_57150800;
extern char*s241_1021024803;
extern char*s317_47598300;
extern char*s73_1188332009;
extern char*s241_603076667;
extern char*s360_534333098;
extern char*s317_692075493;
extern char*s232_107312226;
extern char*s665_90390825;
extern char*s232_267478119;
extern char*s27_2191641;
extern char*s232_565069653;
extern char*s241_2047202317;
extern char*s360_32650;
extern char*s232_438660461;
extern char*s241_502181838;
extern char*s241_307717976;
extern char*s66_327902;
extern char*s360_10089540;
extern char*s360_1900;
extern char*s241_1938643327;
extern char*s291_1747685533;
extern char*s232_1580612071;
extern char*s30_50778415;
extern char*s236_1105551897;
extern char*s450_505232755;
extern char*s469_36126743;
extern char*s534_413927315;
extern char*s232_7918258;
extern char*s66_1185293475;
extern char*s219_1994852;
extern char*s30_1530432238;
extern char*s360_5654700;
extern char*s360_887295984;
extern char*s241_2061122069;
extern char*s241_945201499;
extern char*s241_1933;
extern char*s30_88048;
extern char*s499_342169763;
extern char*s232_950675891;
extern char*s30_88049;
extern char*s239_942808765;
extern char*s241_246527867;
extern char*s235_69601;
extern char*s30_55041091;
extern char*s241_119995654;
extern char*s241_4492176;
extern char*s289_2111741;
extern char*s544_27909038;
extern char*s30_36200588;
extern char*s235_683870135;
extern char*s30_261093457;
extern char*s411_909851733;
extern char*s241_1991246741;
extern char*s30_1286698901;
extern char*s241_1505459217;
extern char*s241_1421116705;
extern char*s235_1115301;
extern char*s289_2072064738;
extern char*s30_1680885744;
extern char*s317_525205114;
extern char*s232_11086084;
extern char*s629_4996600;
extern char*s29_451011;
extern char*s241_676728857;
extern char*s30_55041141;
extern char*s231_1127406485;
extern char*s232_1492394528;
extern char*s30_55041151;
extern char*s317_19199275;
extern char*s218_1711985232;
extern char*s317_2039095413;
extern char*s241_1284361566;
extern char*s236_1378502623;
extern char*s410_729510616;
extern char*s394_28032126;
extern char*s411_1646704683;
extern char*s232_1965252672;
extern char*s291_2121801775;
extern char*s474_161951;
extern char*s236_772432310;
extern char*s73_169314461;
extern char*s30_586229245;
extern char*s358_484454800;
extern char*s317_1150927957;
extern char*s30_1395184171;
extern char*s360_10089690;
extern char*s232_1186179343;
extern char*s232_1605087047;
extern char*s232_1307483215;
extern char*s236_891552598;
extern char*s239_1724182721;
extern char*s317_476433922;
extern char*s630_1932215703;
extern char*s69_446380143;
extern char*s627_121515080;
extern char*s224_2075;
extern char*s317_826425832;
extern char*s410_21020045;
extern char*s317_9954400;
extern char*s627_1779043510;
extern char*s235_186217457;
extern char*s360_162010;
extern char*s232_1656195746;
extern char*s442_162019;
extern char*s360_162020;
extern char*s436_1993565801;
extern char*s317_5279655;
extern char*s232_506210947;
extern char*s30_1300046706;
extern char*s710_670393442;
extern char*s30_2104;
extern char*s499_69237763;
extern char*s630_2145870723;
extern char*s59_8260;
extern char*s26_1042405932;
extern char*s232_32869;
extern char*s450_646287685;
extern char*s241_2001191;
extern char*s450_1032053803;
extern char*s411_1427483140;
extern char*s29_408086;
extern char*s232_531983658;
extern char*s29_251916328;
extern char*s241_1176245553;
extern char*s244_1781104140;
extern char*s235_57487;
extern char*s232_451157;
extern char*s360_8291;
extern char*s317_205124;
extern char*s451_2009909053;
extern char*s360_162070;
extern char*s29_69805;
extern char*s317_1113554587;
extern char*s232_389672;
extern char*s317_1927425;
extern char*s291_14464;
extern char*s239_389675;
extern char*s317_202031759;
extern char*s241_2051403723;
extern char*s403_162095;
extern char*s360_2138778683;
extern char*s73_32926;
extern char*s218_461074983;
extern char*s235_2178;
extern char*s29_401994;
extern char*s27_2020550321;
extern char*s30_2035472654;
extern char*s701_482960256;
extern char*s235_69851;
extern char*s232_1826935309;
extern char*s29_2032026;
extern char*s317_1726920051;
extern char*s29_264667428;
extern char*s232_351488799;
extern char*s241_4750778;
extern char*s224_383570;
extern char*s360_340514;
extern char*s358_1240185282;
extern char*s29_820292;
extern char*s231_1585514726;
extern char*s498_529996976;
extern char*s317_1637927398;
extern char*s80_698011541;
extern char*s231_1297180456;
extern char*s30_1447702;
extern char*s235_1255802680;
extern char*s465_922867504;
extern char*s29_88336;
extern char*s241_599810839;
extern char*s317_1112927266;
extern char*s30_840111968;
extern char*s411_115013643;
extern char*s241_1023251859;
extern char*s236_601041072;
extern char*s547_797085749;
extern char*s30_1297432701;
extern char*s544_5839580;
extern char*s30_2067759348;
extern char*s627_2092258783;
extern char*s450_832670;
extern char*s317_8436;
extern char*s301_408035024;
extern char*s282_864187036;
extern char*s500_1679625106;
extern char*s360_1155996628;
extern char*s30_1209184326;
extern char*s241_700613496;
extern char*s317_45355;
extern char*s317_1245850444;
extern char*s629_2301;
extern char*s241_1689577436;
extern char*s428_1111112795;
extern char*s30_1604515261;
extern char*s317_1096165867;
extern char*s360_245384155;
extern char*s236_1816632501;
extern char*s30_728963476;
extern char*s30_9647090;
extern char*s450_8475;
extern char*s355_2327;
extern char*s241_28789007;
extern char*s235_395994;
extern char*s360_8485;
extern char*s26_546635553;
extern char*s317_1553763390;
extern char*s232_20552830;
extern char*s503_1664721281;
extern char*s241_1752914319;
extern char*s241_2020913390;
extern char*s29_414461;
extern char*s224_1426099398;
extern char*s241_156243902;
extern char*s80_1955866577;
extern char*s503_1025503229;
extern char*s325_914877497;
extern char*s317_244793715;
extern char*s291_1360462097;
extern char*s594_1121854;
extern char*s305_2084982239;
extern char*s30_175767198;
extern char*s500_1238684603;
extern char*s291_737599544;
extern char*s235_45436;
extern char*s239_2382;
extern char*s244_1452647150;
extern char*s356_1040364076;
extern char*s235_217674;
extern char*s232_149822297;
extern char*s357_8545;
extern char*s289_126319331;
extern char*s224_2395;
extern char*s241_1478844272;
extern char*s241_1223700793;
extern char*s241_529554293;
extern char*s63_63912;
extern char*s360_2403;
extern char*s241_2117988535;
extern char*s410_1222747401;
extern char*s232_1530032908;
extern char*s80_2070822678;
extern char*s29_76226;
extern char*s241_439136;
extern char*s539_2417;
extern char*s301_146113272;
extern char*s244_2123229206;
extern char*s80_763815152;
extern char*s80_957054969;
extern char*s402_180503525;
extern char*s235_2440;
extern char*s80_556698697;
extern char*s235_6159594;
extern char*s218_1974940930;
extern char*s360_168532;
extern char*s481_1956008156;
extern char*s69_274238642;
extern char*s30_2090604340;
extern char*s30_591414963;
extern char*s229_1753572602;
extern char*s544_11381817;
extern char*s394_48939825;
extern char*s69_332623945;
extern char*s291_8624;
extern char*s219_1119207694;
extern char*s219_118716790;
extern char*s627_48939847;
extern char*s241_1439398002;
extern char*s380_279959115;
extern char*s241_277837020;
extern char*s30_2504;
extern char*s68_1656731300;
extern char*s219_49917876;
extern char*s279_193194;
extern char*s235_207986277;
extern char*s241_180894;
extern char*s255_1477688005;
extern char*s415_1096645863;
extern char*s29_402346;
extern char*s239_1916291223;
extern char*s360_33291;
extern char*s218_2537;
extern char*s241_761631659;
extern char*s469_2126200255;
extern char*s226_584218374;
extern char*s232_2545;
extern char*s450_1575353618;
extern char*s428_169013584;
extern char*s544_2082029949;
extern char*s500_1711825865;
extern char*s394_1784247739;
extern char*s235_2565;
extern char*s241_1909918820;
extern char*s30_744845610;
extern char*s428_663160333;
extern char*s410_1182157125;
extern char*s317_1489891655;
extern char*s360_37173080;
extern char*s235_76405;
extern char*s499_1858133582;
extern char*s232_1361175839;
extern char*s80_22915075;
extern char*s232_218061703;
extern char*s629_193284;
extern char*s235_98806116;
extern char*s29_82570;
extern char*s220_411283072;
extern char*s241_1731250773;
extern char*s241_1564737054;
extern char*s26_8771;
extern char*s219_689812670;
extern char*s69_894954671;
extern char*s294_950159899;
extern char*s241_2992013;
extern char*s232_2630;
extern char*s29_114085235;
extern char*s235_1247935972;
extern char*s232_1308400309;
extern char*s360_1773508175;
extern char*s235_8801;
extern char*s235_530877013;
extern char*s665_789877170;
extern char*s241_1098712729;
extern char*s231_1039546267;
extern char*s665_783418632;
extern char*s232_33425;
extern char*s360_2670;
extern char*s544_1069766146;
extern char*s30_88795;
extern char*s236_1572647306;
extern char*s346_8835;
extern char*s544_585110409;
extern char*s232_1082664800;
extern char*s225_138929174;
extern char*s360_1263916320;
extern char*s26_1010347497;
extern char*s29_2063276;
extern char*s30_201970776;
extern char*s29_396356;
extern char*s317_1023363018;
extern char*s356_1089314041;
extern char*s29_1939265372;
extern char*s710_103345652;
extern char*s30_201970793;
extern char*s73_2089269822;
extern char*s30_756809447;
extern char*s360_1903915589;
extern char*s27_234165132;
extern char*s30_201970799;
extern char*s29_479922190;
extern char*s360_15020;
extern char*s224_33475;
extern char*s321_1172758533;
extern char*s500_1912840703;
extern char*s239_1934139;
extern char*s305_1646268668;
extern char*s403_112006287;
extern char*s239_8880;
extern char*s235_8884;
extern char*s360_8885;
extern char*s518_520647979;
extern char*s410_112006296;
extern char*s235_8889;
extern char*s232_941548611;
extern char*s219_1637595774;
extern char*s28_8897;
extern char*s241_45224899;
extern char*s239_162838175;
extern char*s30_30191860;
extern char*s232_2753;
extern char*s291_1341105285;
extern char*s80_1251030042;
extern char*s59_900404594;
extern char*s25_1525604536;
extern char*s30_1673345408;
extern char*s30_954385774;
extern char*s63_10926944;
extern char*s344_1666936074;
extern char*s244_672350142;
extern char*s400_946986142;
extern char*s291_236525;
extern char*s30_827429162;
extern char*s291_2142119302;
extern char*s219_444775459;
extern char*s84_758913190;
extern char*s30_253393261;
extern char*s232_1040899642;
extern char*s84_319940936;
extern char*s29_1509818;
extern char*s235_8976;
extern char*s69_1581369567;
extern char*s360_1905022886;
extern char*s30_378799862;
extern char*s219_1246644455;
extern char*s224_1136523103;
extern char*s235_2833;
extern char*s547_1529695024;
extern char*s305_556920526;
extern char*s301_1026844627;
extern char*s450_567426438;
extern char*s360_2217200;
extern char*s235_8991;
extern char*s235_1331737400;
extern char*s450_76659;
extern char*s232_985140858;
extern char*s80_961330339;
extern char*s360_177459204;
extern char*s416_936707889;
extern char*s231_612334905;
extern char*s235_1431838787;
extern char*s291_52067;
extern char*s541_1721243342;
extern char*s241_1207880883;
extern char*s239_400297641;
extern char*s317_2870;
extern char*s217_1746979137;
extern char*s710_1556476521;
extern char*s232_1591358844;
extern char*s30_52347889;
extern char*s30_76691;
extern char*s236_1574136045;
extern char*s282_36115402;
extern char*s315_527180488;
extern char*s234_2883;
extern char*s241_1910823336;
extern char*s291_618166083;
extern char*s30_1095772782;
extern char*s235_218174;
extern char*s400_1057882626;
extern char*s77_15195;
extern char*s30_869539012;
extern char*s630_210551631;
extern char*s329_1728089446;
extern char*s59_522142839;
extern char*s360_965636096;
extern char*s232_54734511;
extern char*s500_1691484858;
extern char*s360_520377520;
extern char*s30_1574640467;
extern char*s235_9073;
extern char*s360_39831;
extern char*s629_205909;
extern char*s30_48958735;
extern char*s241_727272566;
extern char*s68_1377150320;
extern char*s30_170256464;
extern char*s241_1953566687;
extern char*s255_624587783;
extern char*s500_81368369;
extern char*s220_2947;
extern char*s29_8054609;
extern char*s235_9107;
extern char*s665_947318471;
extern char*s235_9121;
extern char*s236_1737672775;
extern char*s317_181352;
extern char*s392_1236593865;
extern char*s219_497096041;
extern char*s701_387651299;
extern char*s317_2118444283;
extern char*s232_9130;
extern char*s235_2109537640;
extern char*s289_759184012;
extern char*s232_374291339;
extern char*s232_712350300;
extern char*s235_415107;
extern char*s241_1775667520;
extern char*s360_2996;
extern char*s544_998144220;
extern char*s232_1582839830;
extern char*s30_180965424;
extern char*s317_732402575;
extern char*s232_316342789;
extern char*s30_180965430;
extern char*s232_3015;
extern char*s317_44462444;
extern char*s232_1281004126;
extern char*s241_188494264;
extern char*s234_1982839385;
extern char*s30_180965447;
extern char*s241_167445550;
extern char*s30_10945665;
extern char*s217_3040;
extern char*s219_1757386798;
extern char*s69_1708886163;
extern char*s63_1661812564;
extern char*s80_2028436769;
extern char*s360_1516064621;
extern char*s232_15351;
extern char*s500_214672950;
extern char*s30_2174354;
extern char*s289_1111279623;
extern char*s500_1961403182;
extern char*s317_2117730851;
extern char*s77_15370;
extern char*s235_9220;
extern char*s235_3069;
extern char*s231_69115705;
extern char*s76_1492303331;
extern char*s235_9222;
extern char*s241_723705127;
extern char*s29_3073;
extern char*s231_1294001247;
extern char*s30_3075;
extern char*s241_1922694958;
extern char*s360_21064105;
extern char*s291_33836;
extern char*s80_817932306;
extern char*s29_3085;
extern char*s29_51843716;
extern char*s224_1145546877;
extern char*s394_1896547075;
extern char*s235_3094;
extern char*s450_1125599189;
extern char*s26_546820847;
extern char*s235_1663868;
extern char*s217_3100;
extern char*s493_138425;
extern char*s360_384465;
extern char*s317_15405;
extern char*s69_1923039443;
extern char*s219_1197879602;
extern char*s30_1856946950;
extern char*s28_1947489674;
extern char*s30_39154229;
extern char*s628_3118;
extern char*s241_370754643;
extern char*s241_188014584;
extern char*s291_33875;
extern char*s241_1502870799;
extern char*s217_1737592965;
extern char*s241_1409701608;
extern char*s219_1087364605;
extern char*s241_1550836304;
extern char*s547_1134247532;
extern char*s469_30745830;
extern char*s232_375072661;
extern char*s597_849265556;
extern char*s236_298390;
extern char*s241_734506354;
extern char*s235_721564652;
extern char*s30_15448;
extern char*s289_26975282;
extern char*s372_3147;
extern char*s241_822318035;
extern char*s232_756717624;
extern char*s30_207673214;
extern char*s503_1901947715;
extern char*s421_26975293;
extern char*s431_1329824754;
extern char*s235_3169;
extern char*s30_207673231;
extern char*s291_3175;
extern char*s27_2248290;
extern char*s29_3175;
extern char*s317_653639191;
extern char*s231_938738041;
extern char*s317_884381655;
extern char*s360_3181;
extern char*s69_1452518781;
extern char*s345_3190;
extern char*s80_1389956963;
extern char*s484_36460172;
extern char*s30_7095298;
extern char*s358_3196;
extern char*s232_323348966;
extern char*s232_2101369329;
extern char*s30_280482649;
extern char*s291_244523906;
extern char*s317_3209;
extern char*s360_1679626025;
extern char*s360_802840;
extern char*s431_2088401;
extern char*s287_97896378;
extern char*s219_159025018;
extern char*s235_9366;
extern char*s241_1898638542;
extern char*s241_1460213717;
extern char*s69_92397395;
extern char*s469_7224500;
extern char*s360_15533;
extern char*s241_1452100558;
extern char*s241_850458948;
extern char*s30_421505;
extern char*s392_336696676;
extern char*s631_2068836731;
extern char*s407_1947010027;
extern char*s241_1389575653;
extern char*s411_1088102843;
extern char*s394_4179775;
extern char*s231_2035830473;
extern char*s29_3249;
extern char*s394_1645291191;
extern char*s317_80501401;
extern char*s333_835850355;
extern char*s499_1156329759;
extern char*s625_1610470399;
extern char*s317_834589410;
extern char*s80_1811847991;
extern char*s232_660780608;
extern char*s360_7704337;
extern char*s317_1206509635;
extern char*s234_15589;
extern char*s235_3291;
extern char*s28_640734509;
extern char*s235_1346168095;
extern char*s220_46350;
extern char*s329_3293;
extern char*s30_33120277;
extern char*s219_38305571;
extern char*s235_3294;
extern char*s305_70962;
extern char*s236_1928938448;
extern char*s224_960414291;
extern char*s29_1072344038;
extern char*s241_1725672511;
extern char*s220_287218105;
extern char*s217_2115332211;
extern char*s241_2008366323;
extern char*s360_83277;
extern char*s356_1932272303;
extern char*s73_1897894366;
extern char*s359_1810101146;
extern char*s235_3320;
extern char*s294_13424808;
extern char*s359_34086;
extern char*s500_58505493;
extern char*s241_147793411;
extern char*s29_1223234252;
extern char*s665_221949868;
extern char*s317_3337;
extern char*s532_3343;
extern char*s219_259021955;
extern char*s235_150382995;
extern char*s66_360205908;
extern char*s29_3349;
extern char*s469_1731781;
extern char*s28_30358538;
extern char*s241_760340765;
extern char*s597_1398420907;
extern char*s360_129654140;
extern char*s627_89481;
extern char*s232_511465169;
extern char*s392_240593583;
extern char*s392_611824887;
extern char*s234_3374;
extern char*s287_192265186;
extern char*s360_83345;
extern char*s26_1102047298;
extern char*s241_1109293176;
extern char*s244_292482;
extern char*s30_698215697;
extern char*s236_763853019;
extern char*s239_3393;
extern char*s399_739187517;
extern char*s241_883016350;
extern char*s30_89510;
extern char*s30_1297876698;
extern char*s232_42279221;
extern char*s80_1977886;
extern char*s29_3415;
extern char*s382_22122412;
extern char*s235_15721;
extern char*s30_3421;
extern char*s232_5164112;
extern char*s232_3430;
extern char*s241_2053250287;
extern char*s630_276669260;
extern char*s627_169510;
extern char*s232_1855175789;
extern char*s235_759424351;
extern char*s241_2060176323;
extern char*s358_83406;
extern char*s30_15751;
extern char*s232_2123070311;
extern char*s544_1242450095;
extern char*s241_239621812;
extern char*s76_1534075159;
extern char*s410_362752532;
extern char*s389_1742784741;
extern char*s30_3460;
extern char*s59_1203674198;
extern char*s235_1067454155;
extern char*s618_3468;
extern char*s291_46525;
extern char*s30_3472;
extern char*s235_270309168;
extern char*s30_3474;
extern char*s224_3475;
extern char*s232_2038260346;
extern char*s701_10220290;
extern char*s484_3485;
extern char*s235_592781506;
extern char*s232_120095614;
extern char*s30_1418282620;
extern char*s235_3494;
extern char*s358_3496;
extern char*s232_325655889;
extern char*s287_176211197;
extern char*s317_1317154036;
extern char*s30_3501;
extern char*s234_1572014572;
extern char*s241_46597328;
extern char*s235_62380794;
extern char*s241_1631593164;
extern char*s544_1973244310;
extern char*s291_1173325215;
extern char*s226_253892190;
extern char*s291_27492334;
extern char*s317_1199805276;
extern char*s436_256961544;
extern char*s246_3520;
extern char*s235_15828;
extern char*s291_1058430701;
extern char*s232_1728206941;
extern char*s30_15831;
extern char*s665_1606367935;
extern char*s30_1947246;
extern char*s25_1767481079;
extern char*s30_1947251;
extern char*s29_77350;
extern char*s344_1379248421;
extern char*s241_1931146896;
extern char*s544_692716864;
extern char*s241_1582009998;
extern char*s317_646768902;
extern char*s241_1167481808;
extern char*s246_1462938943;
extern char*s292_3557;
extern char*s394_1965730;
extern char*s69_176469602;
extern char*s80_2100317873;
extern char*s218_902010809;
extern char*s355_134876560;
extern char*s285_134876562;
extern char*s234_357794960;
extern char*s241_161325869;
extern char*s360_304601115;
extern char*s29_3595;
extern char*s359_852437;
extern char*s217_77412;
extern char*s29_3601;
extern char*s244_1229059519;
extern char*s232_726227573;
extern char*s232_434116584;
extern char*s219_15915;
extern char*s219_1193180751;
extern char*s245_1554312113;
extern char*s30_279523519;
extern char*s80_551231644;
extern char*s244_620670284;
extern char*s360_1243717377;
extern char*s499_2746980;
extern char*s232_1065652086;
extern char*s627_206626;
extern char*s219_1549077634;
extern char*s29_3645;
extern char*s359_54686040;
extern char*s26_1009954795;
extern char*s232_1723513855;
extern char*s29_89771;
extern char*s236_2106290588;
extern char*s360_1037332903;
extern char*s30_577213499;
extern char*s232_34415;
extern char*s289_1115628985;
extern char*s241_375534514;
extern char*s30_3669;
extern char*s503_1750246116;
extern char*s317_1199620901;
extern char*s30_911175911;
extern char*s701_28287;
extern char*s80_261396584;
extern char*s30_169371474;
extern char*s232_1187263559;
extern char*s66_1539722017;
extern char*s239_30604924;
extern char*s29_16001;
extern char*s217_395316170;
extern char*s30_1947419;
extern char*s399_581709925;
extern char*s232_1565125654;
extern char*s482_1087076085;
extern char*s291_89821;
extern char*s232_1773201687;
extern char*s244_1914699291;
extern char*s231_429361964;
extern char*s241_1453066751;
extern char*s234_1059359695;
extern char*s498_56845112;
extern char*s220_1288915017;
extern char*s360_1458627261;
extern char*s450_784909;
extern char*s622_1635136368;
extern char*s236_1014346693;
extern char*s29_937397683;
extern char*s450_129254700;
extern char*s305_1524252299;
extern char*s30_2218105;
extern char*s235_89862;
extern char*s66_411001267;
extern char*s436_1933023161;
extern char*s386_1140411454;
extern char*s30_203589551;
extern char*s317_9905;
extern char*s360_34510;
extern char*s220_3760;
extern char*s244_510352234;
extern char*s630_806307600;
extern char*s360_1326669899;
extern char*s394_1128496981;
extern char*s627_560556710;
extern char*s232_22971612;
extern char*s232_1316373138;
extern char*s317_2030510390;
extern char*s416_1931700734;
extern char*s475_638047023;
extern char*s80_1737556726;
extern char*s30_275488632;
extern char*s27_77608;
extern char*s80_2044479327;
extern char*s317_9980719;
extern char*s218_113009969;
extern char*s239_122027336;
extern char*s29_2593373;
extern char*s321_907165587;
extern char*s317_2187411;
extern char*s701_1760616840;
extern char*s80_1799491166;
extern char*s301_892969089;
extern char*s241_1943393816;
extern char*s359_9808515;
extern char*s481_2187432;
extern char*s382_1864907075;
extern char*s69_372047073;
extern char*s30_440571;
extern char*s241_2082787810;
extern char*s30_1604522960;
extern char*s450_16159;
extern char*s63_2064444;
extern char*s30_2187464;
extern char*s232_697705640;
extern char*s66_188525860;
extern char*s29_49076540;
extern char*s85_1587749191;
extern char*s235_143937264;
extern char*s80_452889;
extern char*s232_1450791030;
extern char*s544_1411018665;
extern char*s547_2134616155;
extern char*s410_333554149;
extern char*s232_397592212;
extern char*s27_16177;
extern char*s410_461679483;
extern char*s30_2187483;
extern char*s291_11241768;
extern char*s29_59251;
extern char*s63_1224218969;
extern char*s291_54686284;
extern char*s63_1750778;
extern char*s68_745978733;
extern char*s382_191115496;
extern char*s232_522691310;
extern char*s238_1442714837;
extern char*s360_2187545;
extern char*s235_1058443417;
extern char*s403_453584834;
extern char*s241_1687580001;
extern char*s241_1301660112;
extern char*s450_277826165;
extern char*s400_779913846;
extern char*s220_1136118256;
extern char*s403_389128515;
extern char*s500_7440512;
extern char*s360_77767;
extern char*s80_641030424;
extern char*s360_77773;
extern char*s29_16264;
extern char*s29_9790205;
extern char*s534_1476287022;
extern char*s241_99041221;
extern char*s469_7225250;
extern char*s29_265093627;
extern char*s232_1234811086;
extern char*s386_435568604;
extern char*s69_175744216;
extern char*s232_700572143;
extern char*s30_1223936132;
extern char*s241_331100035;
extern char*s622_1847764413;
extern char*s410_2187619;
extern char*s436_809795;
extern char*s317_4488096;
extern char*s289_208313786;
extern char*s69_175744241;
extern char*s30_77832;
extern char*s80_1667312535;
extern char*s80_90141;
extern char*s498_1814961148;
extern char*s665_161769183;
extern char*s291_432936020;
extern char*s232_889346373;
extern char*s232_4980205;
extern char*s241_872019014;
extern char*s526_26108892;
extern char*s231_7612837;
extern char*s80_1984169029;
extern char*s241_1476889913;
extern char*s232_2039472678;
extern char*s294_26108906;
extern char*s30_65574;
extern char*s329_240932594;
extern char*s360_388821092;
extern char*s224_533301931;
extern char*s241_902126;
extern char*s232_485090394;
extern char*s291_2051940780;
extern char*s232_1777292479;
extern char*s30_550709268;
extern char*s232_1156367484;
extern char*s232_253935823;
extern char*s244_1468715266;
extern char*s241_732932648;
extern char*s329_657822788;
extern char*s69_1836169859;
extern char*s29_434665;
extern char*s69_175744316;
extern char*s416_626532654;
extern char*s359_397949195;
extern char*s239_1099040180;
extern char*s80_1805205737;
extern char*s30_573080478;
extern char*s410_2089449608;
extern char*s597_1139569132;
extern char*s235_1832417772;
extern char*s360_84085;
extern char*s241_1732402521;
extern char*s291_742356016;
extern char*s627_207112;
extern char*s627_47187;
extern char*s357_1152812249;
extern char*s231_1248054333;
extern char*s30_53339;
extern char*s26_1335263213;
extern char*s291_1085305030;
extern char*s232_218198560;
extern char*s66_838840612;
extern char*s238_1616517694;
extern char*s291_742356033;
extern char*s30_49076823;
extern char*s239_1858528797;
extern char*s450_1949908058;
extern char*s232_10940631;
extern char*s301_397660162;
extern char*s26_375350487;
extern char*s235_1361085152;
extern char*s291_1403828457;
extern char*s421_53548636;
extern char*s217_16487;
extern char*s241_398318341;
extern char*s69_595894613;
extern char*s241_1174611449;
extern char*s29_78002;
extern char*s392_165601417;
extern char*s597_1927020241;
extern char*s305_1246984134;
extern char*s317_16510;
extern char*s30_1202672333;
extern char*s241_897447412;
extern char*s235_19761224;
extern char*s234_1201497496;
extern char*s622_1959331451;
extern char*s317_1990989;
extern char*s232_5367889;
extern char*s241_586311386;
extern char*s220_47278;
extern char*s241_1093012317;
extern char*s317_41131;
extern char*s241_1437345301;
extern char*s701_2072196164;
extern char*s30_1744612358;
extern char*s534_1118729658;
extern char*s232_2096892436;
extern char*s317_1659544035;
extern char*s241_4235;
extern char*s241_1154110220;
extern char*s84_956361723;
extern char*s232_1110850242;
extern char*s232_1377391529;
extern char*s317_884813300;
extern char*s360_4881995;
extern char*s450_41159;
extern char*s217_1197714671;
extern char*s69_543076045;
extern char*s291_280766651;
extern char*s68_42698349;
extern char*s232_246893097;
extern char*s232_928596125;
extern char*s234_1911279888;
extern char*s232_1604142009;
extern char*s234_163909964;
extern char*s394_332834879;
extern char*s317_78082;
extern char*s235_1223801083;
extern char*s436_1907958363;
extern char*s411_94643563;
extern char*s360_17743770;
extern char*s232_1964848975;
extern char*s241_688657949;
extern char*s291_1772045883;
extern char*s29_90408;
extern char*s544_1314337673;
extern char*s69_1242149539;
extern char*s30_7748406;
extern char*s465_840796792;
extern char*s241_126038302;
extern char*s30_16616;
extern char*s235_2121681051;
extern char*s469_36122993;
extern char*s29_16630;
extern char*s241_494839979;
extern char*s68_1784452489;
extern char*s29_10208843;
extern char*s29_56255230;
extern char*s235_725963810;
extern char*s30_16639;
extern char*s30_78150;
extern char*s534_1888871872;
extern char*s241_2016523575;
extern char*s29_1730514379;
extern char*s421_1879799154;
extern char*s356_52798383;
extern char*s394_1469029227;
extern char*s367_1166590709;
extern char*s544_1396798042;
extern char*s30_705019679;
extern char*s30_1339128;
extern char*s30_451899881;
extern char*s235_59731;
extern char*s235_39204698;
extern char*s290_2014364610;
extern char*s241_768172015;
extern char*s360_17743865;
extern char*s69_1226144723;
extern char*s392_61858840;
extern char*s30_16686;
extern char*s291_1279738389;
extern char*s27_385751;
extern char*s291_41300;
extern char*s235_355003;
extern char*s235_2023966344;
extern char*s217_561301605;
extern char*s232_988839165;
extern char*s469_31214580;
extern char*s317_106047655;
extern char*s80_2085574777;
extern char*s235_84381;
extern char*s476_4425;
extern char*s317_1511378937;
extern char*s241_1330797882;
extern char*s30_90544;
extern char*s239_280139425;
extern char*s394_29037;
extern char*s597_888288799;
extern char*s394_847125;
extern char*s29_427898753;
extern char*s317_111269879;
extern char*s403_1881300092;
extern char*s305_2084824380;
extern char*s84_988261007;
extern char*s232_1240218271;
extern char*s232_255270944;
extern char*s69_175744666;
extern char*s279_32450971;
extern char*s470_920950;
extern char*s29_78263;
extern char*s360_804085;
extern char*s234_561947515;
extern char*s29_16761;
extern char*s241_1559455194;
extern char*s232_21391495;
extern char*s69_175744691;
extern char*s241_1421961899;
extern char*s407_1479430694;
extern char*s301_597973944;
extern char*s232_16782;
extern char*s29_84443;
extern char*s352_161074567;
extern char*s399_182862;
extern char*s236_1450022771;
extern char*s236_1914558593;
extern char*s232_923503323;
extern char*s289_430519127;
extern char*s241_611217054;
extern char*s394_138555764;
extern char*s235_1615398571;
extern char*s598_1400894751;
extern char*s597_263008962;
extern char*s30_839855894;
extern char*s241_1075925125;
extern char*s241_488830629;
extern char*s305_2050169721;
extern char*s360_1174230416;
extern char*s236_1661328107;
extern char*s30_2126626;
extern char*s232_179423058;
extern char*s236_42846255;
extern char*s394_1816745449;
extern char*s394_1385443480;
extern char*s220_614557109;
extern char*s701_10559665;
extern char*s291_1208522276;
extern char*s360_1923619084;
extern char*s219_1215177661;
extern char*s231_49655428;
extern char*s30_324411;
extern char*s30_1739790308;
extern char*s244_15142174;
extern char*s239_1483072174;
extern char*s360_195246;
extern char*s235_149455415;
extern char*s324_1345295929;
extern char*s317_1605175681;
extern char*s236_22271191;
extern char*s665_375578482;
extern char*s329_948421114;
extern char*s231_784841421;
extern char*s241_107634778;
extern char*s360_269141588;
extern char*s68_1043946153;
extern char*s235_1515266530;
extern char*s239_283387313;
extern char*s232_1065942137;
extern char*s218_1662662954;
extern char*s410_401707956;
extern char*s359_16902;
extern char*s547_1878889060;
extern char*s224_18131599;
extern char*s279_1185594;
extern char*s291_784300160;
extern char*s30_243411981;
extern char*s30_1419919903;
extern char*s241_2102385657;
extern char*s241_762747069;
extern char*s235_466551816;
extern char*s220_1743948446;
extern char*s544_1682659883;
extern char*s219_16927;
extern char*s317_1007239;
extern char*s241_2028592127;
extern char*s244_1838187926;
extern char*s359_1163823042;
extern char*s360_18482240;
extern char*s29_16942;
extern char*s627_989731302;
extern char*s394_897982986;
extern char*s29_10049231;
extern char*s236_1783880762;
extern char*s393_206419907;
extern char*s291_35404;
extern char*s291_931143030;
extern char*s73_1973946666;
extern char*s232_1704274529;
extern char*s241_1062177790;
extern char*s701_1994165009;
extern char*s289_46733806;
extern char*s360_1008067448;
extern char*s400_2101296982;
extern char*s236_485115581;
extern char*s484_731500039;
extern char*s291_90782;
extern char*s701_1508488213;
extern char*s291_90792;
extern char*s29_78490;
extern char*s360_188188376;
extern char*s27_78495;
extern char*s235_146157;
extern char*s219_1428771266;
extern char*s701_1942675017;
extern char*s287_931579788;
extern char*s317_252669317;
extern char*s30_41849945;
extern char*s218_27561173;
extern char*s232_1533928773;
extern char*s622_2007377394;
extern char*s69_1658160521;
extern char*s360_933501;
extern char*s358_1136691048;
extern char*s360_1923619234;
extern char*s232_1170250908;
extern char*s317_35157672;
extern char*s241_1436398529;
extern char*s30_447584;
extern char*s241_1414519430;
extern char*s484_958964069;
extern char*s239_1404148845;
extern char*s317_90405963;
extern char*s322_439056951;
extern char*s30_1554777;
extern char*s323_22861847;
extern char*s232_530940601;
extern char*s224_724500276;
extern char*s234_2109816196;
extern char*s30_591417242;
extern char*s360_10895;
extern char*s701_1439959996;
extern char*s392_1094507536;
extern char*s236_1253172581;
extern char*s360_10430693;
extern char*s291_176986;
extern char*s239_997623147;
extern char*s232_2055072316;
extern char*s235_631091213;
extern char*s30_1735712398;
extern char*s291_73472312;
extern char*s493_4052132;
extern char*s244_625881326;
extern char*s394_507413068;
extern char*s479_4636482;
extern char*s29_78591;
extern char*s469_561523426;
extern char*s436_1490189105;
extern char*s80_2108992007;
extern char*s305_1060258809;
extern char*s30_1192911276;
extern char*s241_631447998;
extern char*s29_10990481;
extern char*s317_1514442508;
extern char*s241_1632732392;
extern char*s30_167970159;
extern char*s356_999609966;
extern char*s232_1253959973;
extern char*s232_565060278;
extern char*s317_78629;
extern char*s236_1605895597;
extern char*s68_126291003;
extern char*s357_1031515224;
extern char*s235_1327605911;
extern char*s80_1658492806;
extern char*s30_48856070;
extern char*s30_1622700141;
extern char*s30_1957775868;
extern char*s450_1694771411;
extern char*s232_78646;
extern char*s76_722230651;
extern char*s241_844703215;
extern char*s359_2237652;
extern char*s231_573677857;
extern char*s436_1256137461;
extern char*s500_1465905014;
extern char*s68_618869258;
extern char*s25_1852009437;
extern char*s69_174945438;
extern char*s27_1777434714;
extern char*s232_1220584686;
extern char*s499_593760881;
extern char*s241_501268295;
extern char*s317_605650769;
extern char*s236_313299890;
extern char*s241_1950357785;
extern char*s241_2077708091;
extern char*s360_189390;
extern char*s232_850522083;
extern char*s235_447734;
extern char*s232_824324978;
extern char*s407_793028699;
extern char*s399_2007408328;
extern char*s29_17176;
extern char*s410_1090404950;
extern char*s236_1957259232;
extern char*s544_913822046;
extern char*s241_2141291014;
extern char*s500_1548937422;
extern char*s218_210141519;
extern char*s29_2065491;
extern char*s220_1423844543;
extern char*s232_565066528;
extern char*s232_27063164;
extern char*s218_349372;
extern char*s224_106460275;
extern char*s30_84881;
extern char*s29_17221;
extern char*s232_1917882;
extern char*s544_576790349;
extern char*s235_129391217;
extern char*s30_2038667775;
extern char*s317_1497878015;
extern char*s576_1854402277;
extern char*s241_2127445170;
extern char*s30_50246319;
extern char*s241_23410;
extern char*s232_545118879;
extern char*s544_77562923;
extern char*s665_1790874766;
extern char*s392_7238542;
extern char*s241_469031018;
extern char*s219_453998;
extern char*s400_1952787551;
extern char*s291_1739163321;
extern char*s30_447851;
extern char*s73_689575137;
extern char*s411_29585;
extern char*s30_2098363273;
extern char*s236_1004555549;
extern char*s30_349117293;
extern char*s26_1812938425;
extern char*s69_1861857328;
extern char*s500_1541882313;
extern char*s241_928941315;
extern char*s218_195766720;
extern char*s360_467677827;
extern char*s241_1680421289;
extern char*s531_427019719;
extern char*s231_938709111;
extern char*s30_84969;
extern char*s629_2142146116;
extern char*s26_739945705;
extern char*s317_204519611;
extern char*s701_838816886;
extern char*s241_75828399;
extern char*s241_1204389280;
extern char*s301_1628100917;
extern char*s69_1578831409;
extern char*s241_1690004585;
extern char*s317_486352305;
extern char*s547_1627141371;
extern char*s27_914215870;
extern char*s235_1588150185;
extern char*s235_91157;
extern char*s576_1932458562;
extern char*s244_8198176;
extern char*s360_60405;
extern char*s665_1875641781;
extern char*s291_1831440704;
extern char*s436_29662;
extern char*s631_1309017823;
extern char*s80_1453633985;
extern char*s232_495363549;
extern char*s219_1240206596;
extern char*s241_1545228536;
extern char*s235_561720547;
extern char*s241_973007162;
extern char*s403_511485336;
extern char*s236_1950567157;
extern char*s450_1387812168;
extern char*s555_668815628;
extern char*s241_2108887750;
extern char*s30_240810599;
extern char*s232_2022630;
extern char*s235_11253;
extern char*s30_240810604;
extern char*s235_5528704;
extern char*s227_128358027;
extern char*s629_4999725;
extern char*s241_199494346;
extern char*s329_706329;
extern char*s534_1777096676;
extern char*s382_143852403;
extern char*s500_831146693;
extern char*s400_56655830;
extern char*s30_17422;
extern char*s30_2054549840;
extern char*s503_265537649;
extern char*s382_167300030;
extern char*s291_110557057;
extern char*s219_1384921237;
extern char*s241_66884963;
extern char*s241_922446006;
extern char*s239_1581747096;
extern char*s241_134219969;
extern char*s232_471553120;
extern char*s317_1253917267;
extern char*s219_1374304640;
extern char*s554_128333478;
extern char*s393_1888091524;
extern char*s235_262628264;
extern char*s359_1809088081;
extern char*s224_1367009564;
extern char*s360_114321512;
extern char*s241_216477320;
extern char*s241_1701980726;
extern char*s30_337331;
extern char*s232_17480;
extern char*s282_1542436092;
extern char*s244_1056980719;
extern char*s232_1680956616;
extern char*s241_2060540980;
extern char*s317_5313505;
extern char*s27_17498;
extern char*s218_1293738877;
extern char*s30_1483884743;
extern char*s500_139854341;
extern char*s241_2176510;
extern char*s360_35966;
extern char*s236_1556970935;
extern char*s317_5313530;
extern char*s360_1416678934;
extern char*s555_492964813;
extern char*s69_1538234998;
extern char*s29_306165094;
extern char*s360_46980416;
extern char*s291_1843146228;
extern char*s231_870131842;
extern char*s219_2072467813;
extern char*s236_572614135;
extern char*s76_867234734;
extern char*s544_97510;
extern char*s244_445214625;
extern char*s360_1836355544;
extern char*s80_929353692;
extern char*s231_790667100;
extern char*s630_607754817;
extern char*s465_637371887;
extern char*s239_1130602126;
extern char*s629_558682149;
extern char*s279_11429;
extern char*s360_23692781;
extern char*s710_1199364167;
extern char*s289_5284;
extern char*s219_398948;
extern char*s360_1567661459;
extern char*s219_1231257120;
extern char*s241_2087550139;
extern char*s360_306706;
extern char*s629_21632225;
extern char*s544_775406525;
extern char*s553_5317;
extern char*s451_1370872538;
extern char*s360_520373770;
extern char*s27_10714216;
extern char*s358_1836091144;
extern char*s241_300594;
extern char*s30_1740332382;
extern char*s30_1644425991;
extern char*s500_1677586033;
extern char*s625_4434071;
extern char*s627_2057047375;
extern char*s627_4766225;
extern char*s399_1119905623;
extern char*s29_75797981;
extern char*s219_49680837;
extern char*s69_744085684;
extern char*s232_1173628471;
extern char*s627_99866859;
extern char*s30_267647687;
extern char*s358_380590;
extern char*s410_988692517;
extern char*s500_2025498932;
extern char*s241_96053257;
extern char*s80_17696;
extern char*s241_1066804080;
extern char*s627_867204131;
extern char*s241_1062283098;
extern char*s236_109671582;
extern char*s63_1831619428;
extern char*s282_1262756502;
extern char*s232_444175272;
extern char*s29_17715;
extern char*s80_880804011;
extern char*s553_5417;
extern char*s317_300665;
extern char*s305_1001314405;
extern char*s69_2004339522;
extern char*s76_92467250;
extern char*s63_878860;
extern char*s241_112999293;
extern char*s287_700665835;
extern char*s392_1090184065;
extern char*s219_30034;
extern char*s232_1968768303;
extern char*s450_180709512;
extern char*s241_1984637890;
extern char*s232_1435285930;
extern char*s241_79251;
extern char*s294_219885238;
extern char*s241_756929053;
extern char*s241_142936234;
extern char*s500_21306364;
extern char*s232_738771309;
extern char*s289_386819;
extern char*s403_22401251;
extern char*s69_348041349;
extern char*s232_401124480;
extern char*s547_1837585965;
extern char*s450_1642168697;
extern char*s554_305790140;
extern char*s493_60837;
extern char*s629_56760755;
extern char*s289_1367040625;
extern char*s30_1979951;
extern char*s232_471707221;
extern char*s415_1809998749;
extern char*s392_1099072322;
extern char*s235_17794;
extern char*s30_386854;
extern char*s224_1844536619;
extern char*s360_60855;
extern char*s241_776600004;
extern char*s372_2014931627;
extern char*s291_1126647264;
extern char*s241_150329797;
extern char*s239_802495724;
extern char*s232_719604853;
extern char*s235_39617954;
extern char*s235_25704393;
extern char*s294_5515;
extern char*s241_397329363;
extern char*s232_1881374985;
extern char*s360_134878499;
extern char*s232_713312393;
extern char*s241_676769302;
extern char*s30_79341;
extern char*s450_882065083;
extern char*s232_862271166;
extern char*s63_60894;
extern char*s30_48672249;
extern char*s232_23988287;
extern char*s234_1682814572;
extern char*s236_1019367716;
extern char*s392_485184123;
extern char*s219_189437896;
extern char*s289_560761477;
extern char*s232_1672511676;
extern char*s236_479236135;
extern char*s231_1534858458;
extern char*s710_5580;
extern char*s236_1865554673;
extern char*s241_922212712;
extern char*s291_992457137;
extern char*s289_674382779;
extern char*s630_109825546;
extern char*s236_1546692995;
extern char*s411_1411247976;
extern char*s232_4692662;
extern char*s300_2068414678;
extern char*s356_1182732191;
extern char*s232_1994596535;
extern char*s236_5615;
extern char*s220_4631170;
extern char*s282_1413407004;
extern char*s360_1887064762;
extern char*s30_1680926299;
extern char*s29_436196;
extern char*s411_1142240176;
extern char*s544_28263330;
extern char*s235_120239233;
extern char*s30_506823435;
extern char*s27_10554609;
extern char*s80_816126476;
extern char*s241_2009918711;
extern char*s30_39002989;
extern char*s25_85614;
extern char*s518_456083848;
extern char*s544_291421585;
extern char*s239_1586354711;
extern char*s665_865125357;
extern char*s241_971408488;
extern char*s236_866669263;
extern char*s359_1961687;
extern char*s226_51895507;
extern char*s218_1635864124;
extern char*s356_305531998;
extern char*s291_1815688614;
extern char*s499_607189345;
extern char*s241_210812758;
extern char*s394_1250079569;
extern char*s500_1722095007;
extern char*s627_999291000;
extern char*s547_1333985363;
extern char*s390_786054293;
extern char*s232_2041682;
extern char*s450_988243818;
extern char*s30_1937220099;
extern char*s360_829308144;
extern char*s329_5720;
extern char*s544_598811726;
extern char*s597_1613492996;
extern char*s241_18036;
extern char*s30_247239028;
extern char*s360_1942608409;
extern char*s219_41125176;
extern char*s544_1506490209;
extern char*s291_69352117;
extern char*s614_1084568520;
extern char*s73_5757;
extern char*s232_2103819988;
extern char*s410_1816888147;
extern char*s241_720902969;
extern char*s241_1694969179;
extern char*s630_410006827;
extern char*s232_1836282258;
extern char*s241_825716016;
extern char*s231_308853638;
extern char*s353_1955986872;
extern char*s30_1549680;
extern char*s291_130382376;
extern char*s305_1642968637;
extern char*s291_1040644265;
extern char*s224_1042003640;
extern char*s29_18090;
extern char*s360_946895;
extern char*s323_114137597;
extern char*s30_1549697;
extern char*s239_1352413868;
extern char*s30_1549703;
extern char*s236_98784712;
extern char*s84_1968202785;
extern char*s30_18110;
extern char*s356_1861439882;
extern char*s627_202642;
extern char*s232_1063704391;
extern char*s289_1566831588;
extern char*s232_1339521386;
extern char*s80_374877;
extern char*s291_2021999449;
extern char*s499_11977;
extern char*s500_1849347035;
extern char*s232_1460025642;
extern char*s241_1052189738;
extern char*s544_484169497;
extern char*s411_14429929;
extern char*s218_809686569;
extern char*s627_6575105;
extern char*s235_18144;
extern char*s241_18150;
extern char*s360_2122389958;
extern char*s234_1624663341;
extern char*s241_1320619413;
extern char*s241_442256615;
extern char*s494_2015374870;
extern char*s629_472574902;
extern char*s80_1325140408;
extern char*s291_171955;
extern char*s27_267875778;
extern char*s358_18186;
extern char*s291_1985327250;
extern char*s291_1196941282;
extern char*s30_1176378494;
extern char*s279_1096544670;
extern char*s218_203714719;
extern char*s30_55924644;
extern char*s544_2097247;
extern char*s224_2120987577;
extern char*s394_5912;
extern char*s76_1153312264;
extern char*s232_163413385;
extern char*s291_1800342110;
extern char*s329_1992825354;
extern char*s701_1067567332;
extern char*s30_1673348567;
extern char*s236_5873980;
extern char*s338_399591;
extern char*s244_1539816514;
extern char*s360_1400582480;
extern char*s218_44975894;
extern char*s29_56927287;
extern char*s25_1950832492;
extern char*s360_4680700;
extern char*s241_518055462;
extern char*s411_84293096;
extern char*s30_1831158645;
extern char*s241_732257893;
extern char*s394_352968782;
extern char*s219_49152444;
extern char*s317_18257;
extern char*s436_902517583;
extern char*s317_496139469;
extern char*s63_927785894;
extern char*s476_1664909434;
extern char*s241_1387339410;
extern char*s241_445504446;
extern char*s236_1242126608;
extern char*s27_10714862;
extern char*s235_1494914262;
extern char*s344_983618541;
extern char*s665_827998241;
extern char*s219_1869700848;
extern char*s235_448859;
extern char*s30_1553736287;
extern char*s317_744114;
extern char*s241_1181926797;
extern char*s232_8359055;
extern char*s241_1978106088;
extern char*s30_9712276;
extern char*s219_172080;
extern char*s317_705408837;
extern char*s29_1168210079;
extern char*s25_24284008;
extern char*s291_249330648;
extern char*s76_1145998825;
extern char*s232_431043495;
extern char*s59_21571428;
extern char*s232_490486762;
extern char*s241_727903062;
extern char*s235_165012750;
extern char*s235_2075119688;
extern char*s520_306215109;
extern char*s236_1377208779;
extern char*s317_153655;
extern char*s236_212031001;
extern char*s241_12184;
extern char*s238_1152235958;
extern char*s239_1160736641;
extern char*s232_12188;
extern char*s236_113036818;
extern char*s317_2076497529;
extern char*s317_876720377;
extern char*s232_12201;
extern char*s241_34383990;
extern char*s69_35386613;
extern char*s348_498169402;
extern char*s241_2018315248;
extern char*s241_1593742473;
extern char*s232_1009317511;
extern char*s241_124311631;
extern char*s465_1359629264;
extern char*s344_1920465143;
extern char*s352_8777401;
extern char*s484_1838958244;
extern char*s241_1962710217;
extern char*s291_365929075;
extern char*s544_958639438;
extern char*s317_680177517;
extern char*s219_1328320695;
extern char*s235_5578901;
extern char*s631_911129123;
extern char*s469_7227375;
extern char*s239_443468597;
extern char*s241_431394186;
extern char*s629_9589368;
extern char*s27_388005040;
extern char*s235_1319327951;
extern char*s500_374042271;
extern char*s236_3579844;
extern char*s29_1747646688;
extern char*s218_141444;
extern char*s69_432335312;
extern char*s544_1265395998;
extern char*s80_1598804806;
extern char*s68_356743;
extern char*s484_209121;
extern char*s241_1615234134;
extern char*s236_2146569824;
extern char*s625_338723264;
extern char*s665_1573210512;
extern char*s232_1790869799;
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void se_signal_handler(int sig);
/*The generic se_agent0 definition:*/
struct _se_agent0{
Tid id;
Tid creation_mold_id;
void(*afp)(se_agent*);int(*eq)(se_agent*,se_agent*);
};
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#include <errno.h>

#define text_file_read_open(p) (fopen(((char*)(p)),"r"))
#define text_file_write_open(p) (fopen(((char*)(p)),"w"))
#define text_file_write_append(p) (fopen(((char*)(p)),"a"))
#define text_file_read_write_open(p) (fopen(((char*)(p)),"r+"))
#define text_file_read_write_append(p) (fopen(((char*)(p)),"a+"))
#define binary_file_read_open(p) (fopen(((char*)(p)),"rb"))
#define binary_file_write_open(p) (fopen(((char*)(p)),"wb"))
#define binary_file_write_append(p) (fopen(((char*)(p)),"ab"))
#define io_fclose(p) (fclose((FILE*)(p)))
#define io_flush(p) (fflush((FILE*)(p)))
#define io_getc(f) (getc(((FILE*)(f))))
#define io_putc(b, f) (putc((b),((FILE*)(f))))
#define io_fread(b, n, f) (fread((void *)(b),(size_t)(1), (size_t)(n),(FILE*)(f)))
#define io_fwrite(b, n, f) (fwrite((void *)(b),(size_t)(1), (size_t)(n),(FILE*)(f)))
#define io_feof(f) (feof(((FILE*)(f))))
#define io_rename(o, n) (rename(((char*)(o)),((char*)(n))))
#define io_remove(f) (remove(((char*)(f))))
#define io_fseek(f, o) (fseek((FILE*)(f),(o),SEEK_SET))
#define io_ftell(f) ((EIF_INTEGER_64)ftell((FILE*)(f)))

#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
#  define read_stdin(b, s) (read(STDIN_FILENO, b, s))
#else
   extern int read_stdin(EIF_CHARACTER *buffer, int size);
#endif

extern void io_copy(char*source, char*target);
extern int io_file_exists(char*source);
extern int io_same_physical_file(char*path1,char*path2);
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#define basic_exec_system_none  0
#define basic_exec_system_posix 1
#define basic_exec_system_win32 2

/***************************
 * Common macros and types *
 * basic_exec_xxx          *
 ***************************/

#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE || defined  __APPLE__

/*#  include <unistd.h> done in base.h */
/*#  include <sys/types.h> done in base.h */
#include <sys/wait.h>

typedef struct se_exec_data se_exec_data_t;
struct se_exec_data {
  pid_t id;
  int running;
  int status;
};

extern char** environ;

#define basic_exec_id(data) (((se_exec_data_t*)data)->id)
#define basic_exec_status(data) (((se_exec_data_t*)data)->status)
#define basic_exec_alloc_pipe() (calloc(2, sizeof(int)))
#define basic_exec_free_pipe(p) (free(p))
#define basic_exec_alloc_data() ((se_exec_data_t*)se_malloc(sizeof(se_exec_data_t)))
#define basic_exec_free_data(p) (free(p))
#define basic_exec_init_pipe(p) ((EIF_BOOLEAN)(pipe(p)>=0))
#define basic_exec_system basic_exec_system_posix

#elif defined WIN32
/*#  include <windows.h> done in base.h */

typedef struct se_exec_data se_exec_data_t;
struct se_exec_data {
  PROCESS_INFORMATION process_information;
  int running;
  DWORD status;
};

#define basic_exec_id(data) (((se_exec_data_t*)data)->process_information.dwProcessId)
#define basic_exec_status(data) (((se_exec_data_t*)data)->status)

#define basic_exec_alloc_pipe() (calloc(2, sizeof(HANDLE)))
#define basic_exec_free_pipe(p) (free(p))
#define basic_exec_alloc_data() ((se_exec_data_t*)se_malloc(sizeof(se_exec_data_t)))
#define basic_exec_free_data(p) (free(p))
#define basic_exec_system basic_exec_system_win32

extern EIF_BOOLEAN basic_exec_init_pipe(HANDLE*p);

#else
/* Dummy implementation that always reports an error back to the Eiffel side */
typedef int se_exec_data_t;

#define basic_exec_id(data) (-1)
#define basic_exec_status(data) (0)

#define basic_exec_alloc_pipe() (NULL)
#define basic_exec_free_pipe(p) /* dummy */
#define basic_exec_alloc_data() ((se_exec_data_t*)NULL)
#define basic_exec_free_data(p) /* dummy */
#define basic_exec_init_pipe(p) ((EIF_BOOLEAN)0)
#define basic_exec_system basic_exec_system_none

#endif

/***********************************
 * Prototypes for common functions *
 * basic_exec_xxx                  *
 ***********************************/

extern EIF_BOOLEAN basic_exec_is_finished(se_exec_data_t*data);
extern void basic_exec_wait(se_exec_data_t*data);
extern void basic_exec_cleanup(se_exec_data_t*data, int status);

/*************************************************
 * Posix-specific function prototypes and macros *
 * basic_exec_posix_xxx                          *
 *************************************************/

extern EIF_BOOLEAN basic_exec_posix_execute(se_exec_data_t*data, char*prog, char**args, EIF_BOOLEAN keep_env, char**add_env, int*in_fd, int*out_fd, int*err_fd);
extern EIF_INTEGER basic_exec_posix_get_character (EIF_INTEGER fd);
extern void basic_exec_posix_put_character(EIF_INTEGER fd, EIF_CHARACTER c);
extern void basic_exec_posix_wait_any(se_exec_data_t*data);
extern void basic_exec_posix_any_finished(se_exec_data_t*data);

#if basic_exec_system == basic_exec_system_posix
#define basic_exec_posix_flush(fd) (fsync(fd))
#define basic_exec_posix_close(fd) (close(fd))
#define basic_exec_posix_kill(data, sig) (kill((data)->id, (sig)))
#define basic_exec_posix_get_in_descriptor(pipe) (((int*)pipe)[0])
#define basic_exec_posix_get_out_descriptor(pipe) (((int*)pipe)[1])
#else
#define basic_exec_posix_flush(fd) /* dummy */
#define basic_exec_posix_close(fd) /* dummy */
#define basic_exec_posix_kill(data, sig) /* dummy */
#define basic_exec_posix_get_in_descriptor(pipe) 0
#define basic_exec_posix_get_out_descriptor(pipe) 0
#endif

/*************************************************
 * Win32-specific function prototypes and macros *
 * basic_exec_win32_xxx                          *
 *************************************************/

#if basic_exec_system == basic_exec_system_win32
#define basic_exec_win32_flush(h) FlushFileBuffers((HANDLE)h)
#define basic_exec_win32_close(h) CloseHandle((HANDLE)h)
#define basic_exec_win32_handle(data) ((int)((se_exec_data_t*)data)->process_information.hProcess)
#define basic_exec_win32_maximum_wait (MAXIMUM_WAIT_OBJECTS)
extern EIF_BOOLEAN basic_exec_win32_execute(se_exec_data_t*data, char*args, EIF_BOOLEAN keep_env, char*add_env, HANDLE*in_h, HANDLE*out_h, HANDLE*err_h);
extern EIF_BOOLEAN basic_exec_win32_wait_any(HANDLE*handles, DWORD count, se_exec_data_t*data);
extern EIF_BOOLEAN basic_exec_win32_any_finished(HANDLE*handles, DWORD count, se_exec_data_t*data);
extern void basic_exec_win32_put_character(HANDLE h, EIF_CHARACTER c);
extern EIF_INTEGER basic_exec_win32_get_character (HANDLE h);
#define basic_exec_win32_get_in_handle(pipe) (((HANDLE*)pipe)[0])
#define basic_exec_win32_get_out_handle(pipe) (((HANDLE*)pipe)[1])
#else
#define basic_exec_win32_flush(h) /* dummy */
#define basic_exec_win32_close(h) /* dummy */
#define basic_exec_win32_handle(data) (0)
#define basic_exec_win32_maximum_wait (0)
extern EIF_BOOLEAN basic_exec_win32_execute(se_exec_data_t*data, char*args, EIF_BOOLEAN keep_env, char*add_env, void*in_h, void*out_h, void*err_h);
extern EIF_BOOLEAN basic_exec_win32_wait_any(void*handles, int count, se_exec_data_t*data);
extern EIF_BOOLEAN basic_exec_win32_any_finished(void*handles, int count, se_exec_data_t*data);
extern void basic_exec_win32_put_character(void*h, EIF_CHARACTER c);
extern EIF_INTEGER basic_exec_win32_get_character (void*h);
#define basic_exec_win32_get_in_handle(pipe) NULL
#define basic_exec_win32_get_out_handle(pipe) NULL
#endif
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#ifndef WIN32
#  include <dirent.h>
#endif
#ifndef WIN32
#  include <unistd.h>
#endif

EIF_POINTER directory_open(EIF_POINTER path);
EIF_POINTER directory_read_entry(EIF_POINTER dirstream);
EIF_POINTER directory_get_entry_name(EIF_POINTER entry);
EIF_BOOLEAN directory_close(EIF_POINTER dirstream);
#define directory_current_working_directory (directory_cwd())
EIF_POINTER directory_cwd(void);
EIF_BOOLEAN directory_chdir(EIF_POINTER destination);
EIF_BOOLEAN directory_mkdir(EIF_POINTER directory_path);
EIF_BOOLEAN directory_rmdir(EIF_POINTER directory_path);
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/

EIF_INTEGER fstat_st_size(EIF_POINTER path);
EIF_INTEGER_64 fstat_st_mtime(EIF_POINTER path);
EIF_BOOLEAN fstat_st_is_file(EIF_POINTER path);
EIF_BOOLEAN fstat_st_is_dir(EIF_POINTER path);
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#define sprintf_pointer(buffer, pointer) sprintf((char*)(buffer),"%p",pointer)
void sprintf_real_64(EIF_CHARACTER* b, EIF_CHARACTER m, int32_t f, real64_t r);
void sprintf_real_extended(EIF_CHARACTER* b, EIF_CHARACTER m, int32_t f, real_extended_t r);
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#define basic_getenv(v) (getenv((char*)v))
extern T9 oBC260sprintf_buffer;
/*REAL_64*/void r5append_in_format(T5 C,T0* a1,T2 a2);
/*INTEGER_64*/T6 r11fit_integer_8(T11 C);
/*INTEGER_64*/void r11append_in(T11 C,T0* a1);
/*INTEGER_64*/T11 r11_ix_4747(T11 C,T11 a1);
/*INTEGER_64*/T11 r11_ix_94(T11 C,T11 a1);
/*INTEGER_64*/T6 r11is_odd(T11 C);
/*INTEGER_64*/T3 r11decimal_digit(T11 C);
extern T0*oBC61string_buffer;
extern int fBC61string_buffer;
/*INTEGER_64*/T0* r11string_buffer(void);
/*INTEGER_64*/T11 r11_ix_9292(T11 C,T11 a1);
/*INTEGER_64*/T0* r11to_string(T11 C);
/*INTEGER_64*/T6 r11fit_integer_32(T11 C);
/*INTEGER_64*/T6 r11fit_integer_16(T11 C);
/*INTEGER_16*/void r10append_in(T10 C,T0* a1);
/*INTEGER_16*/T10 r10max(T10 C,T10 a1);
/*INTEGER_16*/T6 r10in_range(T10 C,T10 a1,T10 a2);
/*INTEGER_16*/T10 r10min(T10 C,T10 a1);
/*INTEGER_16*/T3 r10decimal_digit(T10 C);
/*INTEGER_16*/T2 r10to_integer_32(T10 C);
/*BOOLEAN*/T6 r6_ix_or(T6 C,T6 a1);
/*CHARACTER*/T6 r3is_lower(T3 C);
/*CHARACTER*/T1 r3hexadecimal_value(T3 C);
/*CHARACTER*/T6 r3_ix_60(T3 C,T3 a1);
/*CHARACTER*/T6 r3in_range(T3 C,T3 a1,T3 a2);
/*CHARACTER*/T6 r3_ix_6061(T3 C,T3 a1);
/*CHARACTER*/T6 r3_ix_6261(T3 C,T3 a1);
/*CHARACTER*/T6 r3is_digit(T3 C);
/*CHARACTER*/T6 r3is_separator(T3 C);
/*CHARACTER*/T6 r3is_hexadecimal_digit(T3 C);
/*CHARACTER*/T1 r3value(T3 C);
/*CHARACTER*/T6 r3is_letter(T3 C);
/*CHARACTER*/T6 r3same_as(T3 C,T3 a1);
/*CHARACTER*/T1 r3decimal_value(T3 C);
/*CHARACTER*/T3 r3to_upper(T3 C);
/*CHARACTER*/T6 r3is_upper(T3 C);
/*CHARACTER*/T3 r3to_lower(T3 C);
/*INTEGER_32*/void r2to_hexadecimal_in(T2 C,T0* a1);
/*INTEGER_32*/void r2append_in(T2 C,T0* a1);
/*INTEGER_32*/T6 r2is_even(T2 C);
/*INTEGER_32*/T2 r2max(T2 C,T2 a1);
/*INTEGER_32*/T6 r2in_range(T2 C,T2 a1,T2 a2);
/*INTEGER_32*/T6 r2is_odd(T2 C);
/*INTEGER_32*/T2 r2min(T2 C,T2 a1);
/*INTEGER_32*/T3 r2decimal_digit(T2 C);
/*INTEGER_32*/T2 r2_ix_43(T2 C,T2 a1);
/*INTEGER_32*/T0* r2string_buffer(void);
/*INTEGER_32*/T0* r2to_string(T2 C);
/*INTEGER_32*/T2 r2_ix_9292(T2 C,T2 a1);
/*INTEGER_32*/T3 r2hexadecimal_digit(T2 C);
/*INTEGER_32*/T2 r2_ix_45(T2 C,T2 a1);
/*INTEGER_32*/T6 r2bit_test(T2 C,T1 a1);
/*INTEGER_8*/T1 r1min(T1 C,T1 a1);
/*INTEGER_8*/T3 r1decimal_digit(T1 C);
/*INTEGER_8*/void r1to_octal_in(T1 C,T0* a1);
/*NATIVE_ARRAY[INTERNAL_C_LOCAL]*/void r1153copy_from(T1153 C,T1153 a1,T2 a2);
/*NATIVE_ARRAY[INTERNAL_C_LOCAL]*/void r1153clear(T1153 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTERNAL_C_LOCAL]*/void r1153clear_all(T1153 C,T2 a1);
/*NATIVE_ARRAY[INTERNAL_C_LOCAL]*/T1153 r1153realloc(T1153 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_5]*/void r1152copy_from(T1152 C,T1152 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_5]*/void r1152clear(T1152 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_5]*/void r1152clear_all(T1152 C,T2 a1);
/*NATIVE_ARRAY[RUN_FEATURE_5]*/T1152 r1152realloc(T1152 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[AGENT_ARGS,STRING]]*/void r1149clear_all(T1149 C,T2 a1);
/*NATIVE_ARRAY[EXTERNAL_ROUTINE]*/T2 r1148fast_index_of(T1148 C,T0* a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[EXTERNAL_ROUTINE]*/void r1148copy_from(T1148 C,T1148 a1,T2 a2);
/*NATIVE_ARRAY[EXTERNAL_ROUTINE]*/void r1148clear(T1148 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[EXTERNAL_ROUTINE]*/void r1148clear_all(T1148 C,T2 a1);
/*NATIVE_ARRAY[EXTERNAL_ROUTINE]*/T1148 r1148realloc(T1148 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_6]*/void r1147copy_from(T1147 C,T1147 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_6]*/void r1147clear(T1147 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_6]*/void r1147clear_all(T1147 C,T2 a1);
/*NATIVE_ARRAY[RUN_FEATURE_6]*/T1147 r1147realloc(T1147 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_2]*/void r1146copy_from(T1146 C,T1146 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_2]*/void r1146clear(T1146 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_2]*/void r1146clear_all(T1146 C,T2 a1);
/*NATIVE_ARRAY[RUN_FEATURE_2]*/T1146 r1146realloc(T1146 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_2]*/void r1146set_all_with(T1146 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1145copy_from(T1145 C,T1145 a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1145clear(T1145 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1145clear_all(T1145 C,T2 a1);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/T1145 r1145realloc(T1145 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1145move(T1145 C,T2 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1145set_all_with(T1145 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[CODE_CONTEXT]*/void r1144copy_from(T1144 C,T1144 a1,T2 a2);
/*NATIVE_ARRAY[CODE_CONTEXT]*/void r1144clear(T1144 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CODE_CONTEXT]*/void r1144clear_all(T1144 C,T2 a1);
/*NATIVE_ARRAY[CODE_CONTEXT]*/T1144 r1144realloc(T1144 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[NATIVE_C_PLUS_PLUS]*/void r1143copy_from(T1143 C,T1143 a1,T2 a2);
/*NATIVE_ARRAY[NATIVE_C_PLUS_PLUS]*/void r1143clear(T1143 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[NATIVE_C_PLUS_PLUS]*/void r1143clear_all(T1143 C,T2 a1);
/*NATIVE_ARRAY[NATIVE_C_PLUS_PLUS]*/T1143 r1143realloc(T1143 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]]*/void r1123clear_all(T1123 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_AVL_DICTIONARY_NODE],STRING]]*/void r1120clear_all(T1120 C,T2 a1);
/*NATIVE_ARRAY[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1119clear_all(T1119 C,T2 a1);
/*NATIVE_ARRAY[LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]]*/void r1118clear_all(T1118 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[FAST_ARRAY[INTERNAL_LOCAL],TYPE]]*/void r1104clear_all(T1104 C,T2 a1);
/*NATIVE_ARRAY[INTERNAL_LOCAL]*/void r1103copy_from(T1103 C,T1103 a1,T2 a2);
/*NATIVE_ARRAY[INTERNAL_LOCAL]*/void r1103clear_all(T1103 C,T2 a1);
/*NATIVE_ARRAY[INTERNAL_LOCAL]*/T1103 r1103realloc(T1103 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ADDRESS_OF]*/void r1097copy_from(T1097 C,T1097 a1,T2 a2);
/*NATIVE_ARRAY[ADDRESS_OF]*/void r1097clear(T1097 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ADDRESS_OF]*/void r1097clear_all(T1097 C,T2 a1);
/*NATIVE_ARRAY[ADDRESS_OF]*/T1097 r1097realloc(T1097 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_AVL_SET_NODE],STRING]]*/void r1094clear_all(T1094 C,T2 a1);
/*NATIVE_ARRAY[AVL_SET_NODE[POSITION]]*/void r1093clear_all(T1093 C,T2 a1);
/*NATIVE_ARRAY[POINTER]*/void r1091clear_all(T1091 C,T2 a1);
/*NATIVE_ARRAY[INLINE_MEMO]*/void r1079copy_from(T1079 C,T1079 a1,T2 a2);
/*NATIVE_ARRAY[INLINE_MEMO]*/void r1079clear(T1079 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INLINE_MEMO]*/void r1079clear_all(T1079 C,T2 a1);
/*NATIVE_ARRAY[INLINE_MEMO]*/T1079 r1079realloc(T1079 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[DICTIONARY[PLUGIN,STRING],STRING]]*/void r1088clear_all(T1088 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[PLUGIN,STRING]]*/void r1085clear_all(T1085 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET_NODE[NATIVE_PLUG_IN]]*/void r1082clear_all(T1082 C,T2 a1);
/*NATIVE_ARRAY[E_OLD]*/void r1078copy_from(T1078 C,T1078 a1,T2 a2);
/*NATIVE_ARRAY[E_OLD]*/void r1078clear(T1078 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[E_OLD]*/void r1078clear_all(T1078 C,T2 a1);
/*NATIVE_ARRAY[E_OLD]*/T1078 r1078realloc(T1078 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[OPEN_OPERAND]*/void r1077copy_from(T1077 C,T1077 a1,T2 a2);
/*NATIVE_ARRAY[OPEN_OPERAND]*/void r1077clear(T1077 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[OPEN_OPERAND]*/void r1077clear_all(T1077 C,T2 a1);
/*NATIVE_ARRAY[OPEN_OPERAND]*/T1077 r1077realloc(T1077 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FORMAL_ARG_LIST]*/void r1075copy_from(T1075 C,T1075 a1,T2 a2);
/*NATIVE_ARRAY[FORMAL_ARG_LIST]*/void r1075clear(T1075 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FORMAL_ARG_LIST]*/void r1075clear_all(T1075 C,T2 a1);
/*NATIVE_ARRAY[FORMAL_ARG_LIST]*/T1075 r1075realloc(T1075 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[AGENT_CREATION]*/T2 r1048fast_index_of(T1048 C,T0* a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[AGENT_CREATION]*/void r1048copy_from(T1048 C,T1048 a1,T2 a2);
/*NATIVE_ARRAY[AGENT_CREATION]*/void r1048clear(T1048 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[AGENT_CREATION]*/void r1048clear_all(T1048 C,T2 a1);
/*NATIVE_ARRAY[AGENT_CREATION]*/T1048 r1048realloc(T1048 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[PROCESS_WIN32,INTEGER_32]]*/void r1041clear_all(T1041 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[PROCESS_POSIX,INTEGER_32]]*/void r1038clear_all(T1038 C,T2 a1);
/*NATIVE_ARRAY[WEAK_REFERENCE[STRING]]*/void r1160copy_from(T1160 C,T1160 a1,T2 a2);
/*NATIVE_ARRAY[WEAK_REFERENCE[STRING]]*/void r1160clear_all(T1160 C,T2 a1);
/*NATIVE_ARRAY[WEAK_REFERENCE[STRING]]*/T1160 r1160realloc(T1160 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RENAME_PAIR]*/void r1034copy_from(T1034 C,T1034 a1,T2 a2);
/*NATIVE_ARRAY[RENAME_PAIR]*/void r1034clear(T1034 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RENAME_PAIR]*/void r1034clear_all(T1034 C,T2 a1);
/*NATIVE_ARRAY[RENAME_PAIR]*/T1034 r1034realloc(T1034 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_SET_NODE[GRAPH_NODE]]*/void r1031clear_all(T1031 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[TEXT_FILE_READ,STRING]]*/void r1028clear_all(T1028 C,T2 a1);
/*NATIVE_ARRAY[TEXT_FILE_READ]*/void r1027clear_all(T1027 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[SE_C_MODE,STRING]]*/void r1024clear_all(T1024 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[ORDERED_DICTIONARY[STRING,STRING],STRING]]*/void r1019clear_all(T1019 C,T2 a1);
/*NATIVE_ARRAY[SE_CONFIG]*/void r1018copy_from(T1018 C,T1018 a1,T2 a2);
/*NATIVE_ARRAY[SE_CONFIG]*/void r1018clear_all(T1018 C,T2 a1);
/*NATIVE_ARRAY[SE_CONFIG]*/T1018 r1018realloc(T1018 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[SWITCH_SITE,FEATURE_NAME]]*/void r1015clear_all(T1015 C,T2 a1);
/*NATIVE_ARRAY[REQUIRE_ITEM]*/void r1014copy_from(T1014 C,T1014 a1,T2 a2);
/*NATIVE_ARRAY[REQUIRE_ITEM]*/void r1014clear(T1014 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[REQUIRE_ITEM]*/void r1014clear_all(T1014 C,T2 a1);
/*NATIVE_ARRAY[REQUIRE_ITEM]*/T1014 r1014realloc(T1014 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]]*/void r1011clear_all(T1011 C,T2 a1);
/*NATIVE_ARRAY[INDEX_CLAUSE]*/void r1008copy_from(T1008 C,T1008 a1,T2 a2);
/*NATIVE_ARRAY[INDEX_CLAUSE]*/void r1008clear_all(T1008 C,T2 a1);
/*NATIVE_ARRAY[INDEX_CLAUSE]*/T1008 r1008realloc(T1008 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INDEX_CLAUSE]*/void r1008set_all_with(T1008 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_CLAUSE]*/void r1010copy_from(T1010 C,T1010 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_CLAUSE]*/void r1010clear(T1010 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_CLAUSE]*/void r1010clear_all(T1010 C,T2 a1);
/*NATIVE_ARRAY[FEATURE_CLAUSE]*/T1010 r1010realloc(T1010 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CREATION_CLAUSE]*/void r1009copy_from(T1009 C,T1009 a1,T2 a2);
/*NATIVE_ARRAY[CREATION_CLAUSE]*/void r1009clear(T1009 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CREATION_CLAUSE]*/void r1009clear_all(T1009 C,T2 a1);
/*NATIVE_ARRAY[CREATION_CLAUSE]*/T1009 r1009realloc(T1009 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_SET_NODE[LIVE_TYPE]]*/void r1005clear_all(T1005 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[CLUSTER_CLASS,HASHED_STRING]]*/void r1002clear_all(T1002 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[CLIENT_LIST,FEATURE_NAME]]*/void r999clear_all(T999 C,T2 a1);
/*NATIVE_ARRAY[LOCAL_ARGUMENT1]*/void r997clear_all(T997 C,T2 a1);
/*NATIVE_ARRAY[LOCAL_ARGUMENT1]*/void r997set_all_with(T997 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[INSTRUCTION]*/void r996copy_from(T996 C,T996 a1,T2 a2);
/*NATIVE_ARRAY[INSTRUCTION]*/void r996clear(T996 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INSTRUCTION]*/void r996remove_first(T996 C,T2 a1);
/*NATIVE_ARRAY[INSTRUCTION]*/void r996clear_all(T996 C,T2 a1);
/*NATIVE_ARRAY[INSTRUCTION]*/T996 r996realloc(T996 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[IFTHEN]*/void r995copy_from(T995 C,T995 a1,T2 a2);
/*NATIVE_ARRAY[IFTHEN]*/void r995remove(T995 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[IFTHEN]*/void r995clear(T995 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[IFTHEN]*/void r995remove_first(T995 C,T2 a1);
/*NATIVE_ARRAY[IFTHEN]*/void r995clear_all(T995 C,T2 a1);
/*NATIVE_ARRAY[IFTHEN]*/T995 r995realloc(T995 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[WHEN_CLAUSE]*/void r994copy_from(T994 C,T994 a1,T2 a2);
/*NATIVE_ARRAY[WHEN_CLAUSE]*/void r994clear(T994 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[WHEN_CLAUSE]*/void r994clear_all(T994 C,T2 a1);
/*NATIVE_ARRAY[WHEN_CLAUSE]*/T994 r994realloc(T994 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[WHEN_ITEM]*/void r993copy_from(T993 C,T993 a1,T2 a2);
/*NATIVE_ARRAY[WHEN_ITEM]*/void r993clear(T993 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[WHEN_ITEM]*/void r993clear_all(T993 C,T2 a1);
/*NATIVE_ARRAY[WHEN_ITEM]*/T993 r993realloc(T993 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_NAME]*/void r992copy_from(T992 C,T992 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_NAME]*/void r992clear(T992 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_NAME]*/void r992clear_all(T992 C,T2 a1);
/*NATIVE_ARRAY[FEATURE_NAME]*/T992 r992realloc(T992 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CLASS_NAME]*/void r991copy_from(T991 C,T991 a1,T2 a2);
/*NATIVE_ARRAY[CLASS_NAME]*/void r991clear(T991 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CLASS_NAME]*/void r991clear_all(T991 C,T2 a1);
/*NATIVE_ARRAY[CLASS_NAME]*/T991 r991realloc(T991 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FORMAL_GENERIC_ARG]*/void r990copy_from(T990 C,T990 a1,T2 a2);
/*NATIVE_ARRAY[FORMAL_GENERIC_ARG]*/void r990clear_all(T990 C,T2 a1);
/*NATIVE_ARRAY[FORMAL_GENERIC_ARG]*/T990 r990realloc(T990 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FORMAL_GENERIC_ARG]*/void r990set_all_with(T990 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[FEATURE_STAMP,TYPE]]*/void r987clear_all(T987 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[TYPE_MARK,TYPE]]*/void r984clear_all(T984 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[TYPE,TYPE]]*/void r981clear_all(T981 C,T2 a1);
/*NATIVE_ARRAY[CECIL_ENTRY]*/void r979copy_from(T979 C,T979 a1,T2 a2);
/*NATIVE_ARRAY[CECIL_ENTRY]*/void r979clear(T979 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CECIL_ENTRY]*/void r979clear_all(T979 C,T2 a1);
/*NATIVE_ARRAY[CECIL_ENTRY]*/T979 r979realloc(T979 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[CLASSES,STRING]]*/void r976clear_all(T976 C,T2 a1);
/*NATIVE_ARRAY[CLASSES]*/void r972copy_from(T972 C,T972 a1,T2 a2);
/*NATIVE_ARRAY[CLASSES]*/void r972clear(T972 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CLASSES]*/void r972clear_all(T972 C,T2 a1);
/*NATIVE_ARRAY[CLASSES]*/T972 r972realloc(T972 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_SET_NODE[MANIFEST_GENERIC]]*/void r963clear_all(T963 C,T2 a1);
/*NATIVE_ARRAY[NON_VOID_NO_DISPATCH]*/T2 r962fast_index_of(T962 C,T0* a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[NON_VOID_NO_DISPATCH]*/void r962copy_from(T962 C,T962 a1,T2 a2);
/*NATIVE_ARRAY[NON_VOID_NO_DISPATCH]*/void r962clear(T962 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[NON_VOID_NO_DISPATCH]*/void r962clear_all(T962 C,T2 a1);
/*NATIVE_ARRAY[NON_VOID_NO_DISPATCH]*/T962 r962realloc(T962 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[SWITCH_TYPE,LIVE_TYPE]]*/void r959clear_all(T959 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET_NODE[AGENT_ARGS]]*/void r955clear_all(T955 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[FAST_ARRAY[AGENT_CREATION],TYPE]]*/void r953clear_all(T953 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET[TYPE]]*/void r951copy_from(T951 C,T951 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_SET[TYPE]]*/void r951clear(T951 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_SET[TYPE]]*/void r951clear_all(T951 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET[TYPE]]*/T951 r951realloc(T951 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[HASHED_SET[TYPE],TYPE]]*/void r948clear_all(T948 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[MANIFEST_STRING,MANIFEST_STRING]]*/void r945clear_all(T945 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[MANIFEST_STRING,STRING]]*/void r942clear_all(T942 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET_NODE[STRING]]*/void r939clear_all(T939 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,TYPE]]*/void r936clear_all(T936 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[RUN_FEATURE,TYPE]]*/void r933clear_all(T933 C,T2 a1);
/*NATIVE_ARRAY[FEATURE_STAMP]*/T2 r932fast_index_of(T932 C,T0* a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[FEATURE_STAMP]*/void r932copy_from(T932 C,T932 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_STAMP]*/void r932clear(T932 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_STAMP]*/void r932clear_all(T932 C,T2 a1);
/*NATIVE_ARRAY[FEATURE_STAMP]*/T932 r932realloc(T932 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_STAMP]*/void r932set_all_with(T932 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[HASHED_SET_NODE[TYPE]]*/void r928clear_all(T928 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[GRAPH_NODE,TYPE]]*/void r925clear_all(T925 C,T2 a1);
/*NATIVE_ARRAY[INTEGER_8]*/void r923clear_all(T923 C,T2 a1);
/*NATIVE_ARRAY[INTEGER_8]*/void r923set_all_with(T923 C,T1 a1,T2 a2);
/*NATIVE_ARRAY[ARRAY[INTEGER_8]]*/void r922clear_all(T922 C,T2 a1);
/*NATIVE_ARRAY[ARRAY[INTEGER_8]]*/void r922set_all_with(T922 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[FEATURE_STAMP,FEATURE_NAME]]*/void r909clear_all(T909 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]]*/void r919clear_all(T919 C,T2 a1);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r918copy_from(T918 C,T918 a1,T2 a2);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r918clear(T918 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r918clear_all(T918 C,T2 a1);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE_MIXER]*/T918 r918realloc(T918 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_SET_NODE[ABSOLUTE_FEATURE_NAME]]*/void r915clear_all(T915 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]]*/void r912clear_all(T912 C,T2 a1);
/*NATIVE_ARRAY[HASHED_BIJECTIVE_DICTIONARY_NODE[FEATURE_STAMP,FEATURE_NAME]]*/void r904clear_all(T904 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,FEATURE_NAME]]*/void r901clear_all(T901 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,FEATURE_STAMP]]*/void r895clear_all(T895 C,T2 a1);
/*NATIVE_ARRAY[RUN_FEATURE]*/T2 r893fast_index_of(T893 C,T0* a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[RUN_FEATURE]*/void r893copy_from(T893 C,T893 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE]*/void r893clear(T893 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE]*/void r893clear_all(T893 C,T2 a1);
/*NATIVE_ARRAY[RUN_FEATURE]*/T893 r893realloc(T893 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TYPE]*/T2 r890fast_index_of(T890 C,T0* a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[TYPE]*/void r890copy_from(T890 C,T890 a1,T2 a2);
/*NATIVE_ARRAY[TYPE]*/void r890remove(T890 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TYPE]*/void r890clear(T890 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TYPE]*/void r890clear_all(T890 C,T2 a1);
/*NATIVE_ARRAY[TYPE]*/T890 r890realloc(T890 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TYPE]*/void r890set_all_with(T890 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE]*/T2 r894fast_index_of(T894 C,T0* a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE]*/void r894copy_from(T894 C,T894 a1,T2 a2);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE]*/void r894clear(T894 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE]*/void r894clear_all(T894 C,T2 a1);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE]*/T894 r894realloc(T894 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[FAST_ARRAY[STRING],CLASS_NAME]]*/void r887clear_all(T887 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET_NODE[CLASS_NAME]]*/void r860clear_all(T860 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[INTEGER_32,CLASS_NAME]]*/void r857clear_all(T857 C,T2 a1);
/*NATIVE_ARRAY[EXPORT_ITEM]*/void r885copy_from(T885 C,T885 a1,T2 a2);
/*NATIVE_ARRAY[EXPORT_ITEM]*/void r885clear_all(T885 C,T2 a1);
/*NATIVE_ARRAY[EXPORT_ITEM]*/T885 r885realloc(T885 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[EXPORT_ITEM]*/void r885set_all_with(T885 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[PARENT_EDGE]*/T2 r882fast_index_of(T882 C,T0* a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[PARENT_EDGE]*/void r882copy_from(T882 C,T882 a1,T2 a2);
/*NATIVE_ARRAY[PARENT_EDGE]*/void r882remove(T882 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[PARENT_EDGE]*/void r882clear(T882 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[PARENT_EDGE]*/void r882clear_all(T882 C,T2 a1);
/*NATIVE_ARRAY[PARENT_EDGE]*/T882 r882realloc(T882 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ARGUMENT_NAME1]*/void r881copy_from(T881 C,T881 a1,T2 a2);
/*NATIVE_ARRAY[ARGUMENT_NAME1]*/void r881clear_all(T881 C,T2 a1);
/*NATIVE_ARRAY[ARGUMENT_NAME1]*/T881 r881realloc(T881 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ARGUMENT_NAME1]*/void r881set_all_with(T881 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[LOCAL_NAME1]*/void r880copy_from(T880 C,T880 a1,T2 a2);
/*NATIVE_ARRAY[LOCAL_NAME1]*/void r880clear_all(T880 C,T2 a1);
/*NATIVE_ARRAY[LOCAL_NAME1]*/T880 r880realloc(T880 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LOCAL_NAME1]*/void r880set_all_with(T880 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[DECLARATION]*/void r878copy_from(T878 C,T878 a1,T2 a2);
/*NATIVE_ARRAY[DECLARATION]*/void r878clear_all(T878 C,T2 a1);
/*NATIVE_ARRAY[DECLARATION]*/T878 r878realloc(T878 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DECLARATION]*/void r878set_all_with(T878 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[MANIFEST_STRING]*/void r876copy_from(T876 C,T876 a1,T2 a2);
/*NATIVE_ARRAY[MANIFEST_STRING]*/void r876clear(T876 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[MANIFEST_STRING]*/void r876clear_all(T876 C,T2 a1);
/*NATIVE_ARRAY[MANIFEST_STRING]*/T876 r876realloc(T876 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_TEXT]*/void r869copy_from(T869 C,T869 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_TEXT]*/void r869clear(T869 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_TEXT]*/void r869clear_all(T869 C,T2 a1);
/*NATIVE_ARRAY[FEATURE_TEXT]*/T869 r869realloc(T869 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[EXPRESSION]*/void r864copy_from(T864 C,T864 a1,T2 a2);
/*NATIVE_ARRAY[EXPRESSION]*/T2 r864first_index_of(T864 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[EXPRESSION]*/void r864clear(T864 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[EXPRESSION]*/T6 r864safe_equal(T0* a1,T0* a2);
/*NATIVE_ARRAY[EXPRESSION]*/void r864clear_all(T864 C,T2 a1);
/*NATIVE_ARRAY[EXPRESSION]*/T864 r864realloc(T864 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ASSERTION]*/void r863copy_from(T863 C,T863 a1,T2 a2);
/*NATIVE_ARRAY[ASSERTION]*/void r863clear(T863 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ASSERTION]*/void r863clear_all(T863 C,T2 a1);
/*NATIVE_ARRAY[ASSERTION]*/T863 r863realloc(T863 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]]*/void r856clear_all(T856 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]]*/void r853clear_all(T853 C,T2 a1);
/*NATIVE_ARRAY[POSITION]*/void r852copy_from(T852 C,T852 a1,T2 a2);
/*NATIVE_ARRAY[POSITION]*/void r852clear(T852 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[POSITION]*/void r852clear_all(T852 C,T2 a1);
/*NATIVE_ARRAY[POSITION]*/T852 r852realloc(T852 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[CECIL_FILE,STRING]]*/void r849clear_all(T849 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]]*/void r845clear_all(T845 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[CLASS_TEXT,HASHED_STRING]]*/void r842clear_all(T842 C,T2 a1);
/*NATIVE_ARRAY[INTEGER_16]*/void r841copy_from(T841 C,T841 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_16]*/void r841clear_all(T841 C,T2 a1);
/*NATIVE_ARRAY[INTEGER_16]*/T841 r841realloc(T841 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_32]*/T2 r837fast_index_of(T837 C,T2 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[INTEGER_32]*/void r837copy_from(T837 C,T837 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_32]*/void r837remove(T837 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_32]*/void r837clear(T837 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_32]*/void r837clear_all(T837 C,T2 a1);
/*NATIVE_ARRAY[INTEGER_32]*/T837 r837realloc(T837 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_32]*/void r837move(T837 C,T2 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[INTEGER_32]*/void r837set_all_with(T837 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CLUSTER]*/void r836copy_from(T836 C,T836 a1,T2 a2);
/*NATIVE_ARRAY[CLUSTER]*/void r836clear_all(T836 C,T2 a1);
/*NATIVE_ARRAY[CLUSTER]*/T836 r836realloc(T836 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_STRING]*/void r835copy_from(T835 C,T835 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_STRING]*/void r835clear(T835 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_STRING]*/void r835clear_all(T835 C,T2 a1);
/*NATIVE_ARRAY[HASHED_STRING]*/T835 r835realloc(T835 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[STRING,STRING]]*/void r832clear_all(T832 C,T2 a1);
/*NATIVE_ARRAY[TYPE_MARK]*/void r829copy_from(T829 C,T829 a1,T2 a2);
/*NATIVE_ARRAY[TYPE_MARK]*/void r829clear_all(T829 C,T2 a1);
/*NATIVE_ARRAY[TYPE_MARK]*/T829 r829realloc(T829 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TYPE_MARK]*/void r829set_all_with(T829 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[LIVE_TYPE]*/T2 r806fast_index_of(T806 C,T0* a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[LIVE_TYPE]*/void r806copy_from(T806 C,T806 a1,T2 a2);
/*NATIVE_ARRAY[LIVE_TYPE]*/void r806clear(T806 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LIVE_TYPE]*/void r806clear_all(T806 C,T2 a1);
/*NATIVE_ARRAY[LIVE_TYPE]*/T806 r806realloc(T806 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[TYPE,HASHED_STRING]]*/void r788clear_all(T788 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[INTEGER_16,HASHED_STRING]]*/void r776clear_all(T776 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]]*/void r753clear_all(T753 C,T2 a1);
/*NATIVE_ARRAY[CLASS_TEXT]*/void r752copy_from(T752 C,T752 a1,T2 a2);
/*NATIVE_ARRAY[CLASS_TEXT]*/void r752clear(T752 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CLASS_TEXT]*/void r752clear_all(T752 C,T2 a1);
/*NATIVE_ARRAY[CLASS_TEXT]*/T752 r752realloc(T752 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_SET_NODE[HASHED_STRING]]*/void r746clear_all(T746 C,T2 a1);
/*NATIVE_ARRAY[STRING]*/T2 r740fast_index_of(T740 C,T0* a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[STRING]*/void r740copy_from(T740 C,T740 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/T2 r740first_index_of(T740 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/void r740clear(T740 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/T6 r740safe_equal(T0* a1,T0* a2);
/*NATIVE_ARRAY[STRING]*/void r740clear_all(T740 C,T2 a1);
/*NATIVE_ARRAY[STRING]*/T740 r740realloc(T740 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/void r740set_all_with(T740 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/T2 r9fast_index_of(T9 C,T3 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/void r9copy_from(T9 C,T9 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/void r9clear(T9 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/void r9remove_first(T9 C,T2 a1);
/*NATIVE_ARRAY[CHARACTER]*/void r9clear_all(T9 C,T2 a1);
/*NATIVE_ARRAY[CHARACTER]*/T2 r9fast_occurrences(T9 C,T3 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/T9 r9realloc(T9 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/void r9slice_copy(T9 C,T2 a1,T9 a2,T2 a3,T2 a4);
/*NATIVE_ARRAY[CHARACTER]*/void r9set_all_with(T9 C,T3 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/T6 r9fast_has(T9 C,T3 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
/*STRING*/T0* r7split(T7* C);
extern T0*oBC7split_buffer;
extern int fBC7split_buffer;
/*STRING*/T0* r7split_buffer(void);
/*STRING*/void r7copy(T7* C,T0* a1);
/*STRING*/void r7append(T7* C,T0* a1);
/*STRING*/T6 r7is_equal(T7* C,T0* a1);
/*STRING*/T6 r7has_substring(T7* C,T0* a1);
/*STRING*/T2 r7index_of(T7* C,T3 a1,T2 a2);
/*STRING*/void r7make_empty(T7* C);
/*STRING*/T6 r7has_suffix(T7* C,T0* a1);
/*STRING*/T6 r7is_integer(T7* C);
/*STRING*/void r7remove_tail(T7* C,T2 a1);
/*STRING*/T6 r7has_prefix(T7* C,T0* a1);
/*STRING*/void r7append_string(T7* C,T0* a1);
/*STRING*/void r7make_filled(T7* C,T3 a1,T2 a2);
/*STRING*/void r7remove(T7* C,T2 a1);
/*STRING*/void r7add_first(T7* C,T3 a1);
/*STRING*/void r7append_substring(T7* C,T0* a1,T2 a2,T2 a3);
/*STRING*/T6 r7_ix_60(T7* C,T0* a1);
/*STRING*/void r7extend(T7* C,T3 a1);
/*STRING*/void r7remove_last(T7* C);
/*STRING*/T6 r7has(T7* C,T3 a1);
/*STRING*/void r7keep_head(T7* C,T2 a1);
/*STRING*/T2 r7hash_code(T7* C);
/*STRING*/void r7fill_with(T7* C,T3 a1);
/*STRING*/void r7make(T7* C,T2 a1);
/*STRING*/T0* r7twin(T7* C);
/*STRING*/void r7extend_unless(T7* C,T3 a1);
/*STRING*/void r7add_last(T7* C,T3 a1);
/*STRING*/void r7shrink(T7* C,T2 a1,T2 a2);
/*STRING*/void r7resize(T7* C,T2 a1);
/*STRING*/T2 r7substring_index(T7* C,T0* a1,T2 a2);
/*STRING*/void r7from_external_copy(T7* C,T8 a1);
/*STRING*/T6 r7is_integer_64(T7* C);
/*STRING*/T8 r7to_external(T7* C);
/*STRING*/void r7extend_multiple(T7* C,T3 a1,T2 a2);
/*STRING*/T2 r7to_integer(T7* C);
/*STRING*/T6 r7same_as(T7* C,T0* a1);
/*STRING*/void r7with_capacity(T7* C,T2 a1);
/*STRING*/void r7to_upper(T7* C);
/*STRING*/void r7to_lower(T7* C);
/*STRING*/void r7remove_head(T7* C,T2 a1);
/*STRING*/T11 r7to_integer_64(T7* C);
/*STRING*/void r7split_in(T7* C,T0* a1);
/*STRING*/T3 r7last(T7* C);
/*STRING*/void r7swap(T7* C,T2 a1,T2 a2);
/*STRING*/T6 r7valid_index(T7* C,T2 a1);
/*STRING*/T3 r7first(T7* C);
/*STRING*/T2 r7first_index_of(T7* C,T3 a1);
/*STRING*/T2 r7occurrences(T7* C,T3 a1);
/*STRING*/void r7remove_prefix(T7* C,T0* a1);
/*STRING*/void r7remove_first(T7* C);
/*STRING*/void r7remove_suffix(T7* C,T0* a1);
/*STRING*/void r7put(T7* C,T3 a1,T2 a2);
/*STRING*/void r7remove_between(T7* C,T2 a1,T2 a2);
/*STRING*/T0* r7_ix_43(T7* C,T0* a1);
extern T0*oBC7string_buffer;
extern int fBC7string_buffer;
/*STRING*/T0* r7string_buffer(void);
/*FAST_ARRAY[INTERNAL_C_LOCAL]*/T0* r1142last(T1142* C);
/*FAST_ARRAY[INTERNAL_C_LOCAL]*/T6 r1142is_empty(T1142* C);
/*FAST_ARRAY[INTERNAL_C_LOCAL]*/void r1142remove_last(T1142* C);
/*FAST_ARRAY[INTERNAL_C_LOCAL]*/void r1142add_last(T1142* C,T0* a1);
/*FAST_ARRAY[INTERNAL_C_LOCAL]*/void r1142with_capacity(T1142* C,T2 a1);
/*FAST_ARRAY[RUN_FEATURE_5]*/void r1140add_last(T1140* C,T0* a1);
/*FAST_ARRAY[RUN_FEATURE_5]*/void r1140with_capacity(T1140* C,T2 a1);
/*FAST_ARRAY[EXTERNAL_ROUTINE]*/T2 r1138fast_first_index_of(T1138* C,T0* a1);
/*FAST_ARRAY[EXTERNAL_ROUTINE]*/T6 r1138valid_index(T1138* C,T2 a1);
/*FAST_ARRAY[EXTERNAL_ROUTINE]*/void r1138add_last(T1138* C,T0* a1);
/*FAST_ARRAY[EXTERNAL_ROUTINE]*/void r1138with_capacity(T1138* C,T2 a1);
/*FAST_ARRAY[EXTERNAL_ROUTINE]*/T6 r1138fast_has(T1138* C,T0* a1);
/*FAST_ARRAY[RUN_FEATURE_2]*/T2 r1136count(T1136* C);
/*FAST_ARRAY[RUN_FEATURE_2]*/T6 r1136is_empty(T1136* C);
/*FAST_ARRAY[RUN_FEATURE_2]*/void r1136add_last(T1136* C,T0* a1);
/*FAST_ARRAY[RUN_FEATURE_2]*/void r1136with_capacity(T1136* C,T2 a1);
/*FAST_ARRAY[RUN_FEATURE_6]*/void r1135add_last(T1135* C,T0* a1);
/*FAST_ARRAY[RUN_FEATURE_6]*/void r1135with_capacity(T1135* C,T2 a1);
/*ARRAY[RUN_FEATURE_2]*/T2 r1134count(T1134* C);
/*ARRAY[RUN_FEATURE_2]*/T0* r1134item(T1134* C,T2 a1);
/*ARRAY[RUN_FEATURE_2]*/void r1134add_last(T1134* C,T0* a1);
/*ARRAY[RUN_FEATURE_2]*/void r1134ensure_capacity_and_bounds(T1134* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[RUN_FEATURE_2]*/void r1134put(T1134* C,T0* a1,T2 a2);
/*ARRAY[RUN_FEATURE_2]*/void r1134with_capacity(T1134* C,T2 a1,T2 a2);
/*ARRAY[RUN_FEATURE_2]*/void r1134clear_all(T1134* C);
/*ARRAY[RUN_FEATURE_2]*/void r1134set_all_with(T1134* C,T0* a1);
/*ARRAY[RUN_FEATURE_2]*/void r1134swap(T1134* C,T2 a1,T2 a2);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/T2 r1133count(T1133* C);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/T0* r1133item(T1133* C,T2 a1);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/T6 r1133valid_index(T1133* C,T2 a1);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1133add_last(T1133* C,T0* a1);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1133resize(T1133* C,T2 a1,T2 a2);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1133ensure_capacity_and_bounds(T1133* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1133put(T1133* C,T0* a1,T2 a2);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1133make(T1133* C,T2 a1,T2 a2);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1133clear_all(T1133* C);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1133force(T1133* C,T0* a1,T2 a2);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1133set_all_with(T1133* C,T0* a1);
/*FAST_ARRAY[CODE_CONTEXT]*/T2 r1132count(T1132* C);
/*FAST_ARRAY[CODE_CONTEXT]*/T0* r1132last(T1132* C);
/*FAST_ARRAY[CODE_CONTEXT]*/T6 r1132is_empty(T1132* C);
/*FAST_ARRAY[CODE_CONTEXT]*/void r1132remove_last(T1132* C);
/*FAST_ARRAY[CODE_CONTEXT]*/void r1132add_last(T1132* C,T0* a1);
/*FAST_ARRAY[CODE_CONTEXT]*/void r1132resize(T1132* C,T2 a1);
/*FAST_ARRAY[CODE_CONTEXT]*/void r1132make(T1132* C,T2 a1);
/*FAST_ARRAY[CODE_CONTEXT]*/void r1132with_capacity(T1132* C,T2 a1);
/*FAST_ARRAY[NATIVE_C_PLUS_PLUS]*/void r1126add_last(T1126* C,T0* a1);
/*FAST_ARRAY[NATIVE_C_PLUS_PLUS]*/void r1126with_capacity(T1126* C,T2 a1);
/*FAST_ARRAY[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1111make(T1111* C,T2 a1);
/*FAST_ARRAY[LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]]*/void r1102make(T1102* C,T2 a1);
/*FAST_ARRAY[INTERNAL_LOCAL]*/T2 r1080count(T1080* C);
/*FAST_ARRAY[INTERNAL_LOCAL]*/void r1080add_last(T1080* C,T0* a1);
/*FAST_ARRAY[INTERNAL_LOCAL]*/void r1080make(T1080* C,T2 a1);
/*FAST_ARRAY[ADDRESS_OF]*/void r1076add_last(T1076* C,T0* a1);
/*FAST_ARRAY[ADDRESS_OF]*/void r1076with_capacity(T1076* C,T2 a1);
/*FAST_ARRAY[AVL_SET_NODE[POSITION]]*/void r1073make(T1073* C,T2 a1);
/*FAST_ARRAY[POINTER]*/void r1068manifest_put(T1068* C,T2 a1,T8 a2);
/*FAST_ARRAY[POINTER]*/void r1068manifest_make(T1068* C,T2 a1);
/*FAST_ARRAY[POINTER]*/void r1068make(T1068* C,T2 a1);
/*ARRAY[INTEGER_32]*/T2 r1067item(T1067* C,T2 a1);
/*ARRAY[INTEGER_32]*/void r1067ensure_capacity_and_bounds(T1067* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[INTEGER_32]*/void r1067resize(T1067* C,T2 a1,T2 a2);
/*ARRAY[INTEGER_32]*/void r1067put(T1067* C,T2 a1,T2 a2);
/*ARRAY[INTEGER_32]*/void r1067make(T1067* C,T2 a1,T2 a2);
/*ARRAY[INTEGER_32]*/void r1067clear_all(T1067* C);
/*ARRAY[INTEGER_32]*/void r1067set_all_with(T1067* C,T2 a1);
/*FAST_ARRAY[INLINE_MEMO]*/T0* r1057last(T1057* C);
/*FAST_ARRAY[INLINE_MEMO]*/T6 r1057is_empty(T1057* C);
/*FAST_ARRAY[INLINE_MEMO]*/void r1057remove_last(T1057* C);
/*FAST_ARRAY[INLINE_MEMO]*/void r1057add_last(T1057* C,T0* a1);
/*FAST_ARRAY[INLINE_MEMO]*/void r1057with_capacity(T1057* C,T2 a1);
/*ARRAY[FEATURE_STAMP]*/T2 r1058count(T1058* C);
/*ARRAY[FEATURE_STAMP]*/T0* r1058item(T1058* C,T2 a1);
/*ARRAY[FEATURE_STAMP]*/T6 r1058is_empty(T1058* C);
/*ARRAY[FEATURE_STAMP]*/void r1058add_last(T1058* C,T0* a1);
/*ARRAY[FEATURE_STAMP]*/void r1058ensure_capacity_and_bounds(T1058* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[FEATURE_STAMP]*/void r1058put(T1058* C,T0* a1,T2 a2);
/*ARRAY[FEATURE_STAMP]*/void r1058with_capacity(T1058* C,T2 a1,T2 a2);
/*ARRAY[FEATURE_STAMP]*/void r1058clear_all(T1058* C);
/*ARRAY[FEATURE_STAMP]*/void r1058set_all_with(T1058* C,T0* a1);
/*FAST_ARRAY[E_OLD]*/void r1047add_last(T1047* C,T0* a1);
/*FAST_ARRAY[E_OLD]*/void r1047with_capacity(T1047* C,T2 a1);
/*FAST_ARRAY[OPEN_OPERAND]*/T2 r1045count(T1045* C);
/*FAST_ARRAY[OPEN_OPERAND]*/T6 r1045is_empty(T1045* C);
/*FAST_ARRAY[OPEN_OPERAND]*/void r1045add_last(T1045* C,T0* a1);
/*FAST_ARRAY[OPEN_OPERAND]*/void r1045with_capacity(T1045* C,T2 a1);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/T2 r1044count(T1044* C);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/void r1044add_last(T1044* C,T0* a1);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/void r1044resize(T1044* C,T2 a1);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/void r1044with_capacity(T1044* C,T2 a1);
/*FAST_ARRAY[RENAME_PAIR]*/T2 r998count(T998* C);
/*FAST_ARRAY[RENAME_PAIR]*/void r998add_last(T998* C,T0* a1);
/*FAST_ARRAY[RENAME_PAIR]*/void r998with_capacity(T998* C,T2 a1);
/*FAST_ARRAY[TEXT_FILE_READ]*/T0* r974last(T974* C);
/*FAST_ARRAY[TEXT_FILE_READ]*/T6 r974is_empty(T974* C);
/*FAST_ARRAY[TEXT_FILE_READ]*/void r974remove_last(T974* C);
/*FAST_ARRAY[TEXT_FILE_READ]*/void r974make(T974* C,T2 a1);
/*FAST_ARRAY[SE_CONFIG]*/T6 r966is_empty(T966* C);
/*FAST_ARRAY[SE_CONFIG]*/void r966add_last(T966* C,T0* a1);
/*FAST_ARRAY[SE_CONFIG]*/void r966make(T966* C,T2 a1);
/*FAST_ARRAY[REQUIRE_ITEM]*/void r931copy(T931* C,T0* a1);
/*FAST_ARRAY[REQUIRE_ITEM]*/T2 r931count(T931* C);
/*FAST_ARRAY[REQUIRE_ITEM]*/T0* r931first(T931* C);
/*FAST_ARRAY[REQUIRE_ITEM]*/void r931add_last(T931* C,T0* a1);
/*FAST_ARRAY[REQUIRE_ITEM]*/void r931with_capacity(T931* C,T2 a1);
/*FAST_ARRAY[REQUIRE_ITEM]*/T0* r931twin(T931* C);
/*ARRAY[INDEX_CLAUSE]*/T2 r898count(T898* C);
/*ARRAY[INDEX_CLAUSE]*/void r898add_last(T898* C,T0* a1);
/*ARRAY[INDEX_CLAUSE]*/void r898ensure_capacity_and_bounds(T898* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[INDEX_CLAUSE]*/void r898put(T898* C,T0* a1,T2 a2);
/*ARRAY[INDEX_CLAUSE]*/void r898with_capacity(T898* C,T2 a1,T2 a2);
/*ARRAY[INDEX_CLAUSE]*/void r898clear_all(T898* C);
/*ARRAY[INDEX_CLAUSE]*/void r898set_all_with(T898* C,T0* a1);
/*FAST_ARRAY[FEATURE_CLAUSE]*/void r900add_last(T900* C,T0* a1);
/*FAST_ARRAY[FEATURE_CLAUSE]*/void r900with_capacity(T900* C,T2 a1);
/*FAST_ARRAY[CREATION_CLAUSE]*/T0* r899first(T899* C);
/*FAST_ARRAY[CREATION_CLAUSE]*/void r899add_last(T899* C,T0* a1);
/*FAST_ARRAY[CREATION_CLAUSE]*/void r899with_capacity(T899* C,T2 a1);
/*ARRAY[LOCAL_ARGUMENT1]*/T2 r879count(T879* C);
/*ARRAY[LOCAL_ARGUMENT1]*/void r879from_collection(T879* C,T0* a1);
/*ARRAY[LOCAL_ARGUMENT1]*/T0* r879item(T879* C,T2 a1);
/*ARRAY[LOCAL_ARGUMENT1]*/void r879ensure_capacity_and_bounds(T879* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[LOCAL_ARGUMENT1]*/void r879put(T879* C,T0* a1,T2 a2);
/*ARRAY[LOCAL_ARGUMENT1]*/void r879with_capacity(T879* C,T2 a1,T2 a2);
/*ARRAY[LOCAL_ARGUMENT1]*/void r879clear_all(T879* C);
/*ARRAY[LOCAL_ARGUMENT1]*/void r879set_all_with(T879* C,T0* a1);
/*FAST_ARRAY[INSTRUCTION]*/void r877copy(T877* C,T0* a1);
/*FAST_ARRAY[INSTRUCTION]*/T2 r877count(T877* C);
/*FAST_ARRAY[INSTRUCTION]*/T0* r877last(T877* C);
/*FAST_ARRAY[INSTRUCTION]*/T0* r877first(T877* C);
/*FAST_ARRAY[INSTRUCTION]*/void r877remove_first(T877* C);
/*FAST_ARRAY[INSTRUCTION]*/void r877add_last(T877* C,T0* a1);
/*FAST_ARRAY[INSTRUCTION]*/void r877make(T877* C,T2 a1);
/*FAST_ARRAY[INSTRUCTION]*/void r877with_capacity(T877* C,T2 a1);
/*FAST_ARRAY[INSTRUCTION]*/T0* r877twin(T877* C);
/*FAST_ARRAY[IFTHEN]*/void r875remove_tail(T875* C,T2 a1);
/*FAST_ARRAY[IFTHEN]*/void r875copy(T875* C,T0* a1);
/*FAST_ARRAY[IFTHEN]*/T2 r875count(T875* C);
/*FAST_ARRAY[IFTHEN]*/T0* r875last(T875* C);
/*FAST_ARRAY[IFTHEN]*/void r875remove(T875* C,T2 a1);
/*FAST_ARRAY[IFTHEN]*/T6 r875is_empty(T875* C);
/*FAST_ARRAY[IFTHEN]*/T0* r875first(T875* C);
/*FAST_ARRAY[IFTHEN]*/void r875remove_last(T875* C);
/*FAST_ARRAY[IFTHEN]*/void r875remove_first(T875* C);
/*FAST_ARRAY[IFTHEN]*/void r875add_last(T875* C,T0* a1);
/*FAST_ARRAY[IFTHEN]*/void r875with_capacity(T875* C,T2 a1);
/*FAST_ARRAY[IFTHEN]*/T0* r875twin(T875* C);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r874remove_tail(T874* C,T2 a1);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r874copy(T874* C,T0* a1);
/*FAST_ARRAY[WHEN_CLAUSE]*/T2 r874count(T874* C);
/*FAST_ARRAY[WHEN_CLAUSE]*/T6 r874is_empty(T874* C);
/*FAST_ARRAY[WHEN_CLAUSE]*/T0* r874first(T874* C);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r874add_last(T874* C,T0* a1);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r874with_capacity(T874* C,T2 a1);
/*FAST_ARRAY[WHEN_CLAUSE]*/T0* r874twin(T874* C);
/*FAST_ARRAY[WHEN_ITEM]*/void r873copy(T873* C,T0* a1);
/*FAST_ARRAY[WHEN_ITEM]*/T2 r873count(T873* C);
/*FAST_ARRAY[WHEN_ITEM]*/T6 r873is_empty(T873* C);
/*FAST_ARRAY[WHEN_ITEM]*/T0* r873first(T873* C);
/*FAST_ARRAY[WHEN_ITEM]*/void r873add_last(T873* C,T0* a1);
/*FAST_ARRAY[WHEN_ITEM]*/void r873with_capacity(T873* C,T2 a1);
/*FAST_ARRAY[WHEN_ITEM]*/T0* r873twin(T873* C);
/*FAST_ARRAY[FEATURE_NAME]*/T0* r871first(T871* C);
/*FAST_ARRAY[FEATURE_NAME]*/void r871add_last(T871* C,T0* a1);
/*FAST_ARRAY[FEATURE_NAME]*/void r871make(T871* C,T2 a1);
/*FAST_ARRAY[FEATURE_NAME]*/void r871with_capacity(T871* C,T2 a1);
/*FAST_ARRAY[CLASS_NAME]*/void r870add_last(T870* C,T0* a1);
/*FAST_ARRAY[CLASS_NAME]*/void r870with_capacity(T870* C,T2 a1);
/*ARRAY[FORMAL_GENERIC_ARG]*/T2 r868count(T868* C);
/*ARRAY[FORMAL_GENERIC_ARG]*/T0* r868item(T868* C,T2 a1);
/*ARRAY[FORMAL_GENERIC_ARG]*/void r868add_last(T868* C,T0* a1);
/*ARRAY[FORMAL_GENERIC_ARG]*/void r868ensure_capacity_and_bounds(T868* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[FORMAL_GENERIC_ARG]*/void r868put(T868* C,T0* a1,T2 a2);
/*ARRAY[FORMAL_GENERIC_ARG]*/void r868with_capacity(T868* C,T2 a1,T2 a2);
/*ARRAY[FORMAL_GENERIC_ARG]*/void r868clear_all(T868* C);
/*ARRAY[FORMAL_GENERIC_ARG]*/void r868set_all_with(T868* C,T0* a1);
/*FAST_ARRAY[CECIL_ENTRY]*/void r848add_last(T848* C,T0* a1);
/*FAST_ARRAY[CECIL_ENTRY]*/void r848with_capacity(T848* C,T2 a1);
/*FAST_ARRAY[INTEGER_16]*/T2 r840count(T840* C);
/*FAST_ARRAY[INTEGER_16]*/void r840add_last(T840* C,T10 a1);
/*FAST_ARRAY[INTEGER_16]*/void r840make(T840* C,T2 a1);
/*FAST_ARRAY[CLASSES]*/void r834add(T834* C,T0* a1,T2 a2);
/*FAST_ARRAY[CLASSES]*/T6 r834is_empty(T834* C);
/*FAST_ARRAY[CLASSES]*/void r834add_last(T834* C,T0* a1);
/*FAST_ARRAY[CLASSES]*/void r834with_capacity(T834* C,T2 a1);
/*FAST_ARRAY[CLASSES]*/void r834move(T834* C,T2 a1,T2 a2,T2 a3);
/*FAST_ARRAY[NON_VOID_NO_DISPATCH]*/T2 r827fast_first_index_of(T827* C,T0* a1);
/*FAST_ARRAY[NON_VOID_NO_DISPATCH]*/T6 r827valid_index(T827* C,T2 a1);
/*FAST_ARRAY[NON_VOID_NO_DISPATCH]*/void r827add_last(T827* C,T0* a1);
/*FAST_ARRAY[NON_VOID_NO_DISPATCH]*/void r827with_capacity(T827* C,T2 a1);
/*FAST_ARRAY[NON_VOID_NO_DISPATCH]*/T6 r827fast_has(T827* C,T0* a1);
/*FAST_ARRAY[AGENT_CREATION]*/T2 r823fast_first_index_of(T823* C,T0* a1);
/*FAST_ARRAY[AGENT_CREATION]*/T2 r823count(T823* C);
/*FAST_ARRAY[AGENT_CREATION]*/T6 r823valid_index(T823* C,T2 a1);
/*FAST_ARRAY[AGENT_CREATION]*/void r823add_last(T823* C,T0* a1);
/*FAST_ARRAY[AGENT_CREATION]*/void r823with_capacity(T823* C,T2 a1);
/*FAST_ARRAY[AGENT_CREATION]*/T6 r823fast_has(T823* C,T0* a1);
/*FAST_ARRAY[HASHED_SET[TYPE]]*/T0* r820last(T820* C);
/*FAST_ARRAY[HASHED_SET[TYPE]]*/T6 r820is_empty(T820* C);
/*FAST_ARRAY[HASHED_SET[TYPE]]*/void r820remove_last(T820* C);
/*FAST_ARRAY[HASHED_SET[TYPE]]*/void r820add_last(T820* C,T0* a1);
/*FAST_ARRAY[HASHED_SET[TYPE]]*/void r820with_capacity(T820* C,T2 a1);
/*FAST_ARRAY[FEATURE_STAMP]*/T2 r808fast_first_index_of(T808* C,T0* a1);
/*FAST_ARRAY[FEATURE_STAMP]*/T6 r808valid_index(T808* C,T2 a1);
/*FAST_ARRAY[FEATURE_STAMP]*/T6 r808is_empty(T808* C);
/*FAST_ARRAY[FEATURE_STAMP]*/void r808add_last(T808* C,T0* a1);
/*FAST_ARRAY[FEATURE_STAMP]*/void r808with_capacity(T808* C,T2 a1);
/*FAST_ARRAY[FEATURE_STAMP]*/T6 r808fast_has(T808* C,T0* a1);
/*ARRAY[INTEGER_8]*/void r802manifest_put(T802* C,T2 a1,T1 a2);
/*ARRAY[INTEGER_8]*/T1 r802item(T802* C,T2 a1);
/*ARRAY[INTEGER_8]*/void r802manifest_make(T802* C,T2 a1,T2 a2);
/*ARRAY[INTEGER_8]*/void r802ensure_capacity_and_bounds(T802* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[INTEGER_8]*/void r802make(T802* C,T2 a1,T2 a2);
/*ARRAY[INTEGER_8]*/void r802clear_all(T802* C);
/*ARRAY[INTEGER_8]*/void r802set_all_with(T802* C,T1 a1);
/*ARRAY[ARRAY[INTEGER_8]]*/void r801manifest_put(T801* C,T2 a1,T0* a2);
/*ARRAY[ARRAY[INTEGER_8]]*/T0* r801item(T801* C,T2 a1);
/*ARRAY[ARRAY[INTEGER_8]]*/void r801manifest_make(T801* C,T2 a1,T2 a2);
/*ARRAY[ARRAY[INTEGER_8]]*/void r801ensure_capacity_and_bounds(T801* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[ARRAY[INTEGER_8]]*/void r801make(T801* C,T2 a1,T2 a2);
/*ARRAY[ARRAY[INTEGER_8]]*/void r801clear_all(T801* C);
/*ARRAY[ARRAY[INTEGER_8]]*/void r801set_all_with(T801* C,T0* a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE_MIXER]*/T0* r795last(T795* C);
/*FAST_ARRAY[ANONYMOUS_FEATURE_MIXER]*/T6 r795is_empty(T795* C);
/*FAST_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r795remove_last(T795* C);
/*FAST_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r795add_last(T795* C,T0* a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r795with_capacity(T795* C,T2 a1);
/*FAST_ARRAY[TYPE]*/T2 r787fast_first_index_of(T787* C,T0* a1);
/*FAST_ARRAY[TYPE]*/T2 r787count(T787* C);
/*FAST_ARRAY[TYPE]*/T0* r787last(T787* C);
/*FAST_ARRAY[TYPE]*/void r787remove(T787* C,T2 a1);
/*FAST_ARRAY[TYPE]*/T6 r787valid_index(T787* C,T2 a1);
/*FAST_ARRAY[TYPE]*/T0* r787first(T787* C);
/*FAST_ARRAY[TYPE]*/void r787remove_last(T787* C);
/*FAST_ARRAY[TYPE]*/void r787add_last(T787* C,T0* a1);
/*FAST_ARRAY[TYPE]*/void r787resize(T787* C,T2 a1);
/*FAST_ARRAY[TYPE]*/void r787make(T787* C,T2 a1);
/*FAST_ARRAY[TYPE]*/void r787with_capacity(T787* C,T2 a1);
/*FAST_ARRAY[TYPE]*/T6 r787fast_has(T787* C,T0* a1);
/*FAST_ARRAY[CLASS_TEXT]*/void r783add_last(T783* C,T0* a1);
/*FAST_ARRAY[CLASS_TEXT]*/void r783with_capacity(T783* C,T2 a1);
/*FAST_ARRAY[RUN_FEATURE]*/T2 r781fast_first_index_of(T781* C,T0* a1);
/*FAST_ARRAY[RUN_FEATURE]*/T2 r781count(T781* C);
/*FAST_ARRAY[RUN_FEATURE]*/T6 r781valid_index(T781* C,T2 a1);
/*FAST_ARRAY[RUN_FEATURE]*/void r781add_last(T781* C,T0* a1);
/*FAST_ARRAY[RUN_FEATURE]*/void r781make(T781* C,T2 a1);
/*FAST_ARRAY[RUN_FEATURE]*/void r781with_capacity(T781* C,T2 a1);
/*FAST_ARRAY[RUN_FEATURE]*/T6 r781fast_has(T781* C,T0* a1);
/*ARRAY[TYPE]*/T2 r779count(T779* C);
/*ARRAY[TYPE]*/T0* r779item(T779* C,T2 a1);
/*ARRAY[TYPE]*/T0* r779first(T779* C);
/*ARRAY[TYPE]*/void r779add_last(T779* C,T0* a1);
/*ARRAY[TYPE]*/void r779ensure_capacity_and_bounds(T779* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[TYPE]*/void r779put(T779* C,T0* a1,T2 a2);
/*ARRAY[TYPE]*/void r779with_capacity(T779* C,T2 a1,T2 a2);
/*ARRAY[TYPE]*/void r779clear_all(T779* C);
/*ARRAY[TYPE]*/void r779set_all_with(T779* C,T0* a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/T2 r782fast_first_index_of(T782* C,T0* a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/T2 r782count(T782* C);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/T0* r782last(T782* C);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/T6 r782valid_index(T782* C,T2 a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/T6 r782is_empty(T782* C);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/T0* r782first(T782* C);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/void r782remove_last(T782* C);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/void r782add_last(T782* C,T0* a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/void r782make(T782* C,T2 a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/void r782with_capacity(T782* C,T2 a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/T6 r782fast_has(T782* C,T0* a1);
/*ARRAY[EXPORT_ITEM]*/T2 r773count(T773* C);
/*ARRAY[EXPORT_ITEM]*/T0* r773item(T773* C,T2 a1);
/*ARRAY[EXPORT_ITEM]*/void r773add_last(T773* C,T0* a1);
/*ARRAY[EXPORT_ITEM]*/void r773ensure_capacity_and_bounds(T773* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[EXPORT_ITEM]*/void r773put(T773* C,T0* a1,T2 a2);
/*ARRAY[EXPORT_ITEM]*/void r773with_capacity(T773* C,T2 a1,T2 a2);
/*ARRAY[EXPORT_ITEM]*/void r773clear_all(T773* C);
/*ARRAY[EXPORT_ITEM]*/void r773set_all_with(T773* C,T0* a1);
/*FAST_ARRAY[PARENT_EDGE]*/T2 r772fast_first_index_of(T772* C,T0* a1);
/*FAST_ARRAY[PARENT_EDGE]*/T2 r772fast_index_of(T772* C,T0* a1,T2 a2);
/*FAST_ARRAY[PARENT_EDGE]*/T2 r772count(T772* C);
/*FAST_ARRAY[PARENT_EDGE]*/T0* r772last(T772* C);
/*FAST_ARRAY[PARENT_EDGE]*/void r772remove(T772* C,T2 a1);
/*FAST_ARRAY[PARENT_EDGE]*/T6 r772valid_index(T772* C,T2 a1);
/*FAST_ARRAY[PARENT_EDGE]*/T6 r772is_empty(T772* C);
/*FAST_ARRAY[PARENT_EDGE]*/void r772add_last(T772* C,T0* a1);
/*FAST_ARRAY[PARENT_EDGE]*/void r772make(T772* C,T2 a1);
/*FAST_ARRAY[PARENT_EDGE]*/void r772with_capacity(T772* C,T2 a1);
/*FAST_ARRAY[PARENT_EDGE]*/void r772swap(T772* C,T2 a1,T2 a2);
/*FAST_ARRAY[PARENT_EDGE]*/T6 r772fast_has(T772* C,T0* a1);
/*ARRAY[ARGUMENT_NAME1]*/void r771from_collection(T771* C,T0* a1);
/*ARRAY[ARGUMENT_NAME1]*/T2 r771count(T771* C);
/*ARRAY[ARGUMENT_NAME1]*/T0* r771item(T771* C,T2 a1);
/*ARRAY[ARGUMENT_NAME1]*/T0* r771first(T771* C);
/*ARRAY[ARGUMENT_NAME1]*/void r771add_last(T771* C,T0* a1);
/*ARRAY[ARGUMENT_NAME1]*/void r771ensure_capacity_and_bounds(T771* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[ARGUMENT_NAME1]*/void r771put(T771* C,T0* a1,T2 a2);
/*ARRAY[ARGUMENT_NAME1]*/void r771make(T771* C,T2 a1,T2 a2);
/*ARRAY[ARGUMENT_NAME1]*/void r771with_capacity(T771* C,T2 a1,T2 a2);
/*ARRAY[ARGUMENT_NAME1]*/void r771clear_all(T771* C);
/*ARRAY[ARGUMENT_NAME1]*/void r771set_all_with(T771* C,T0* a1);
/*ARRAY[LOCAL_NAME1]*/void r770from_collection(T770* C,T0* a1);
/*ARRAY[LOCAL_NAME1]*/T2 r770count(T770* C);
/*ARRAY[LOCAL_NAME1]*/T0* r770item(T770* C,T2 a1);
/*ARRAY[LOCAL_NAME1]*/void r770add_last(T770* C,T0* a1);
/*ARRAY[LOCAL_NAME1]*/void r770ensure_capacity_and_bounds(T770* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[LOCAL_NAME1]*/void r770put(T770* C,T0* a1,T2 a2);
/*ARRAY[LOCAL_NAME1]*/void r770make(T770* C,T2 a1,T2 a2);
/*ARRAY[LOCAL_NAME1]*/void r770with_capacity(T770* C,T2 a1,T2 a2);
/*ARRAY[LOCAL_NAME1]*/void r770clear_all(T770* C);
/*ARRAY[LOCAL_NAME1]*/void r770set_all_with(T770* C,T0* a1);
/*ARRAY[DECLARATION]*/void r769from_collection(T769* C,T0* a1);
/*ARRAY[DECLARATION]*/T2 r769count(T769* C);
/*ARRAY[DECLARATION]*/void r769manifest_put(T769* C,T2 a1,T0* a2);
/*ARRAY[DECLARATION]*/T0* r769item(T769* C,T2 a1);
/*ARRAY[DECLARATION]*/void r769manifest_make(T769* C,T2 a1,T2 a2);
/*ARRAY[DECLARATION]*/T6 r769is_empty(T769* C);
/*ARRAY[DECLARATION]*/void r769add_last(T769* C,T0* a1);
/*ARRAY[DECLARATION]*/void r769ensure_capacity_and_bounds(T769* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[DECLARATION]*/void r769put(T769* C,T0* a1,T2 a2);
/*ARRAY[DECLARATION]*/void r769make(T769* C,T2 a1,T2 a2);
/*ARRAY[DECLARATION]*/void r769with_capacity(T769* C,T2 a1,T2 a2);
/*ARRAY[DECLARATION]*/void r769clear_all(T769* C);
/*ARRAY[DECLARATION]*/void r769set_all_with(T769* C,T0* a1);
/*FAST_ARRAY[MANIFEST_STRING]*/T6 r768is_empty(T768* C);
/*FAST_ARRAY[MANIFEST_STRING]*/void r768add_last(T768* C,T0* a1);
/*FAST_ARRAY[MANIFEST_STRING]*/void r768with_capacity(T768* C,T2 a1);
/*FAST_ARRAY[FEATURE_TEXT]*/void r767copy(T767* C,T0* a1);
/*FAST_ARRAY[FEATURE_TEXT]*/T6 r767is_empty(T767* C);
/*FAST_ARRAY[FEATURE_TEXT]*/void r767add_last(T767* C,T0* a1);
/*FAST_ARRAY[FEATURE_TEXT]*/void r767with_capacity(T767* C,T2 a1);
/*FAST_ARRAY[FEATURE_TEXT]*/T0* r767twin(T767* C);
/*FAST_ARRAY[EXPRESSION]*/void r766copy(T766* C,T0* a1);
/*FAST_ARRAY[EXPRESSION]*/T2 r766count(T766* C);
/*FAST_ARRAY[EXPRESSION]*/T6 r766valid_index(T766* C,T2 a1);
/*FAST_ARRAY[EXPRESSION]*/T0* r766first(T766* C);
/*FAST_ARRAY[EXPRESSION]*/T2 r766first_index_of(T766* C,T0* a1);
/*FAST_ARRAY[EXPRESSION]*/void r766add_last(T766* C,T0* a1);
/*FAST_ARRAY[EXPRESSION]*/void r766make(T766* C,T2 a1);
/*FAST_ARRAY[EXPRESSION]*/void r766with_capacity(T766* C,T2 a1);
/*FAST_ARRAY[EXPRESSION]*/T0* r766twin(T766* C);
/*FAST_ARRAY[ASSERTION]*/void r765copy(T765* C,T0* a1);
/*FAST_ARRAY[ASSERTION]*/void r765manifest_put(T765* C,T2 a1,T0* a2);
/*FAST_ARRAY[ASSERTION]*/void r765manifest_make(T765* C,T2 a1);
/*FAST_ARRAY[ASSERTION]*/T6 r765is_empty(T765* C);
/*FAST_ARRAY[ASSERTION]*/void r765add_last(T765* C,T0* a1);
/*FAST_ARRAY[ASSERTION]*/void r765make(T765* C,T2 a1);
/*FAST_ARRAY[ASSERTION]*/void r765with_capacity(T765* C,T2 a1);
/*FAST_ARRAY[ASSERTION]*/T0* r765twin(T765* C);
/*FAST_ARRAY[POSITION]*/T2 r743count(T743* C);
/*FAST_ARRAY[POSITION]*/T296 r743last(T743* C);
/*FAST_ARRAY[POSITION]*/T296 r743item(T743* C,T2 a1);
/*FAST_ARRAY[POSITION]*/T6 r743valid_index(T743* C,T2 a1);
/*FAST_ARRAY[POSITION]*/T6 r743is_empty(T743* C);
/*FAST_ARRAY[POSITION]*/T296 r743first(T743* C);
/*FAST_ARRAY[POSITION]*/void r743remove_last(T743* C);
/*FAST_ARRAY[POSITION]*/void r743add_last(T743* C,T296 a1);
/*FAST_ARRAY[POSITION]*/void r743put(T743* C,T296 a1,T2 a2);
/*FAST_ARRAY[POSITION]*/void r743with_capacity(T743* C,T2 a1);
/*FAST_ARRAY[POSITION]*/void r743swap(T743* C,T2 a1,T2 a2);
/*FAST_ARRAY[INTEGER_32]*/T2 r733fast_first_index_of(T733* C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/void r733add(T733* C,T2 a1,T2 a2);
/*FAST_ARRAY[INTEGER_32]*/T2 r733count(T733* C);
/*FAST_ARRAY[INTEGER_32]*/T2 r733last(T733* C);
/*FAST_ARRAY[INTEGER_32]*/T2 r733item(T733* C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/void r733remove(T733* C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/T2 r733first(T733* C);
/*FAST_ARRAY[INTEGER_32]*/void r733remove_last(T733* C);
/*FAST_ARRAY[INTEGER_32]*/void r733add_last(T733* C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/void r733make(T733* C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/void r733with_capacity(T733* C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/void r733move(T733* C,T2 a1,T2 a2,T2 a3);
/*FAST_ARRAY[INTEGER_32]*/void r733set_all_with(T733* C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/void r733swap(T733* C,T2 a1,T2 a2);
/*FAST_ARRAY[CLUSTER]*/void r732add(T732* C,T0* a1,T2 a2);
/*FAST_ARRAY[CLUSTER]*/T2 r732count(T732* C);
/*FAST_ARRAY[CLUSTER]*/T6 r732is_empty(T732* C);
/*FAST_ARRAY[CLUSTER]*/T0* r732first(T732* C);
/*FAST_ARRAY[CLUSTER]*/void r732add_last(T732* C,T0* a1);
/*FAST_ARRAY[CLUSTER]*/void r732make(T732* C,T2 a1);
/*FAST_ARRAY[CLUSTER]*/void r732move(T732* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[STRING]*/void r731add(T731* C,T0* a1,T2 a2);
/*ARRAY[STRING]*/void r731copy(T731* C,T0* a1);
/*ARRAY[STRING]*/void r731clear_count(T731* C);
/*ARRAY[STRING]*/T2 r731count(T731* C);
/*ARRAY[STRING]*/T0* r731item(T731* C,T2 a1);
/*ARRAY[STRING]*/T6 r731valid_index(T731* C,T2 a1);
/*ARRAY[STRING]*/T6 r731is_empty(T731* C);
/*ARRAY[STRING]*/T0* r731first(T731* C);
/*ARRAY[STRING]*/void r731add_last(T731* C,T0* a1);
/*ARRAY[STRING]*/void r731ensure_capacity_and_bounds(T731* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[STRING]*/void r731put(T731* C,T0* a1,T2 a2);
/*ARRAY[STRING]*/void r731with_capacity(T731* C,T2 a1,T2 a2);
/*ARRAY[STRING]*/T0* r731twin(T731* C);
/*ARRAY[STRING]*/void r731clear_all(T731* C);
/*ARRAY[STRING]*/void r731move(T731* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[STRING]*/void r731swap(T731* C,T2 a1,T2 a2);
/*ARRAY[STRING]*/void r731set_all_with(T731* C,T0* a1);
/*FAST_ARRAY[HASHED_STRING]*/T2 r730count(T730* C);
/*FAST_ARRAY[HASHED_STRING]*/T0* r730last(T730* C);
/*FAST_ARRAY[HASHED_STRING]*/void r730add_last(T730* C,T0* a1);
/*FAST_ARRAY[HASHED_STRING]*/void r730with_capacity(T730* C,T2 a1);
/*ARRAY[TYPE_MARK]*/void r726copy(T726* C,T0* a1);
/*ARRAY[TYPE_MARK]*/T2 r726count(T726* C);
/*ARRAY[TYPE_MARK]*/T0* r726last(T726* C);
/*ARRAY[TYPE_MARK]*/void r726manifest_put(T726* C,T2 a1,T0* a2);
/*ARRAY[TYPE_MARK]*/T0* r726item(T726* C,T2 a1);
/*ARRAY[TYPE_MARK]*/T6 r726valid_index(T726* C,T2 a1);
/*ARRAY[TYPE_MARK]*/void r726manifest_make(T726* C,T2 a1,T2 a2);
/*ARRAY[TYPE_MARK]*/T0* r726first(T726* C);
/*ARRAY[TYPE_MARK]*/void r726add_last(T726* C,T0* a1);
/*ARRAY[TYPE_MARK]*/void r726ensure_capacity_and_bounds(T726* C,T2 a1,T2 a2,T2 a3);
/*ARRAY[TYPE_MARK]*/void r726put(T726* C,T0* a1,T2 a2);
/*ARRAY[TYPE_MARK]*/void r726make(T726* C,T2 a1,T2 a2);
/*ARRAY[TYPE_MARK]*/void r726with_capacity(T726* C,T2 a1,T2 a2);
/*ARRAY[TYPE_MARK]*/T0* r726twin(T726* C);
/*ARRAY[TYPE_MARK]*/void r726clear_all(T726* C);
/*ARRAY[TYPE_MARK]*/void r726set_all_with(T726* C,T0* a1);
/*FAST_ARRAY[LIVE_TYPE]*/T2 r725fast_first_index_of(T725* C,T0* a1);
/*FAST_ARRAY[LIVE_TYPE]*/T2 r725count(T725* C);
/*FAST_ARRAY[LIVE_TYPE]*/T0* r725item(T725* C,T2 a1);
/*FAST_ARRAY[LIVE_TYPE]*/T6 r725valid_index(T725* C,T2 a1);
/*FAST_ARRAY[LIVE_TYPE]*/T0* r725first(T725* C);
/*FAST_ARRAY[LIVE_TYPE]*/void r725add_last(T725* C,T0* a1);
/*FAST_ARRAY[LIVE_TYPE]*/void r725put(T725* C,T0* a1,T2 a2);
/*FAST_ARRAY[LIVE_TYPE]*/void r725with_capacity(T725* C,T2 a1);
/*FAST_ARRAY[LIVE_TYPE]*/void r725swap(T725* C,T2 a1,T2 a2);
/*FAST_ARRAY[LIVE_TYPE]*/T6 r725fast_has(T725* C,T0* a1);
/*FAST_ARRAY[STRING]*/T2 r716fast_first_index_of(T716* C,T0* a1);
/*FAST_ARRAY[STRING]*/void r716add(T716* C,T0* a1,T2 a2);
/*FAST_ARRAY[STRING]*/void r716from_collection(T716* C,T0* a1);
/*FAST_ARRAY[STRING]*/T2 r716count(T716* C);
/*FAST_ARRAY[STRING]*/void r716manifest_put(T716* C,T2 a1,T0* a2);
/*FAST_ARRAY[STRING]*/T0* r716item(T716* C,T2 a1);
/*FAST_ARRAY[STRING]*/T6 r716valid_index(T716* C,T2 a1);
/*FAST_ARRAY[STRING]*/void r716manifest_make(T716* C,T2 a1);
/*FAST_ARRAY[STRING]*/T0* r716get_new_iterator(T716* C);
/*FAST_ARRAY[STRING]*/T2 r716first_index_of(T716* C,T0* a1);
/*FAST_ARRAY[STRING]*/T6 r716has(T716* C,T0* a1);
/*FAST_ARRAY[STRING]*/void r716add_last(T716* C,T0* a1);
/*FAST_ARRAY[STRING]*/void r716resize(T716* C,T2 a1);
/*FAST_ARRAY[STRING]*/void r716put(T716* C,T0* a1,T2 a2);
/*FAST_ARRAY[STRING]*/void r716make(T716* C,T2 a1);
/*FAST_ARRAY[STRING]*/void r716with_capacity(T716* C,T2 a1);
/*FAST_ARRAY[STRING]*/void r716move(T716* C,T2 a1,T2 a2,T2 a3);
/*FAST_ARRAY[STRING]*/void r716swap(T716* C,T2 a1,T2 a2);
/*FAST_ARRAY[STRING]*/T6 r716fast_has(T716* C,T0* a1);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[AGENT_ARGS,STRING]]*/void r1151set_item(T1151* C,T0* a1);
/*HASHED_DICTIONARY_NODE[AGENT_ARGS,STRING]*/void r1150make(T1150* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/T6 r1139key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/T0* r1139new_node(T1139* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/void r1139increase_capacity(T1139* C);
extern T0*oBC277common_free_nodes;
extern int fBC277common_free_nodes;
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/T0* r1139common_free_nodes(void);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/T0* r1139reference_at(T1139* C,T0* a1);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/void r1139put(T1139* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/void r1139make(T1139* C);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/void r1139with_capacity(T1139* C,T2 a1);
/*ITERATOR_ON_DICTIONARY_KEYS[STRING,STRING]*/T0* r1137item(T1137* C);
/*ITERATOR_ON_DICTIONARY_KEYS[STRING,STRING]*/void r1137next(T1137* C);
/*ITERATOR_ON_DICTIONARY_KEYS[STRING,STRING]*/void r1137make(T1137* C,T0* a1);
/*ITERATOR_ON_DICTIONARY_KEYS[STRING,STRING]*/T6 r1137is_off(T1137* C);
/*COLLECTION_SORTER[LIVE_TYPE]*/T6 r1130is_sorted(T0* a1);
/*COLLECTION_SORTER[LIVE_TYPE]*/void r1130quick_sort(T0* a1);
/*COLLECTION_SORTER[LIVE_TYPE]*/void r1130quick_sort_region(T0* a1,T2 a2,T2 a3);
/*COLLECTION_SORTER[LIVE_TYPE]*/T6 r1130lt(T0* a1,T0* a2);
/*COLLECTION_SORTER[LIVE_TYPE]*/void r1130sort(T0* a1);
/*COLLECTION_SORTER[LIVE_TYPE]*/T6 r1130lte(T0* a1,T0* a2);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]]*/void r1125set_item(T1125* C,T0* a1);
/*HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/void r1124make(T1124* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_AVL_DICTIONARY_NODE],STRING]]*/void r1122set_item(T1122* C,T0* a1);
/*HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_AVL_DICTIONARY_NODE],STRING]*/void r1121make(T1121* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/void r1117add(T1117* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/T0* r1117new_node(T1117* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/void r1117increase_capacity(T1117* C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/T0* r1117common_free_nodes(void);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/T0* r1117fast_reference_at(T1117* C,T0* a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/void r1117make(T1117* C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/void r1117with_capacity(T1117* C,T2 a1);
/*WEAK_REFERENCE[LINKED_LIST_NODE[TUPLE[CHARACTER,INTEGER_32]]]*/void r1116set_item(T1116* C,T0* a1);
/*LINKED_LIST_NODE[TUPLE[CHARACTER,INTEGER_32]]*/void r1113make(T1113* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_DICTIONARY_NODE],STRING]*/T6 r1112key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_DICTIONARY_NODE],STRING]*/void r1112add(T1112* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_DICTIONARY_NODE],STRING]*/T0* r1112new_node(T1112* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_DICTIONARY_NODE],STRING]*/void r1112increase_capacity(T1112* C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_DICTIONARY_NODE],STRING]*/T0* r1112common_free_nodes(void);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_DICTIONARY_NODE],STRING]*/T0* r1112reference_at(T1112* C,T0* a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_DICTIONARY_NODE],STRING]*/void r1112make(T1112* C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_DICTIONARY_NODE],STRING]*/void r1112with_capacity(T1112* C,T2 a1);
/*AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]*/T0* r1110rotate_left(T1110* C);
/*AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]*/T0* r1110fast_at(T1110* C,T2 a1);
/*AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]*/void r1110make(T1110* C,T2 a1,T2 a2);
/*AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]*/T0* r1110rotate_right(T1110* C);
/*WEAK_REFERENCE[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1109set_item(T1109* C,T0* a1);
T1101*create1101make_2(T3 a1,T2 a2);
/*TUPLE[CHARACTER,INTEGER_32]*/void r1101make_2(T1101* C,T3 a1,T2 a2);
T1100*create1100make(void);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/T0* r1100new_node(T1100* C,T0* a1,T0* a2);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/void r1100clear_count(T1100* C);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/T0* r1100item(T1100* C,T2 a1);
extern T0*oBC683common_free_nodes;
extern int fBC683common_free_nodes;
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/T0* r1100common_free_nodes(void);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/T0* r1100dispose_node(T1100* C,T0* a1);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/void r1100add_last(T1100* C,T0* a1);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/void r1100go_item(T1100* C,T2 a1);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/void r1100make(T1100* C);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0* r1099new_node(T1099* C);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1099clear_count(T1099* C);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1099fast_put(T1099* C,T2 a1,T2 a2);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T2 r1099fast_at(T1099* C,T2 a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0* r1099right_grown(T1099* C,T0* a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1099discard_node(T1099* C,T0* a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0* r1099a_new_node(void);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0* r1099fast_do_insert(T1099* C,T0* a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0* r1099left_grown(T1099* C,T0* a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1099clear_nodes(T1099* C,T0* a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1099set_value_and_key(T1099* C,T0* a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0* r1099do_insert(T1099* C,T0* a1);
extern T0*oBC697common_lost_nodes;
extern int fBC697common_lost_nodes;
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0* r1099common_lost_nodes(void);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1099make(T1099* C);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1099set_value(T1099* C,T0* a1);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[FAST_ARRAY[INTERNAL_LOCAL],TYPE]]*/void r1106set_item(T1106* C,T0* a1);
/*HASHED_DICTIONARY_NODE[FAST_ARRAY[INTERNAL_LOCAL],TYPE]*/void r1105make(T1105* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_AVL_SET_NODE],STRING]]*/void r1096set_item(T1096* C,T0* a1);
/*HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_AVL_SET_NODE],STRING]*/void r1095make(T1095* C,T0* a1,T0* a2,T0* a3);
/*SAFE_EQUAL[POSITION]*/T6 r1092test(T296 a1,T296 a2);
/*HASHED_DICTIONARY[FAST_ARRAY[INTERNAL_LOCAL],TYPE]*/T6 r1081key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[FAST_ARRAY[INTERNAL_LOCAL],TYPE]*/void r1081add(T1081* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[FAST_ARRAY[INTERNAL_LOCAL],TYPE]*/T0* r1081new_node(T1081* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[FAST_ARRAY[INTERNAL_LOCAL],TYPE]*/T0* r1081at(T1081* C,T0* a1);
/*HASHED_DICTIONARY[FAST_ARRAY[INTERNAL_LOCAL],TYPE]*/void r1081increase_capacity(T1081* C);
/*HASHED_DICTIONARY[FAST_ARRAY[INTERNAL_LOCAL],TYPE]*/T0* r1081common_free_nodes(void);
/*HASHED_DICTIONARY[FAST_ARRAY[INTERNAL_LOCAL],TYPE]*/T0* r1081reference_at(T1081* C,T0* a1);
/*HASHED_DICTIONARY[FAST_ARRAY[INTERNAL_LOCAL],TYPE]*/void r1081make(T1081* C);
/*HASHED_DICTIONARY[FAST_ARRAY[INTERNAL_LOCAL],TYPE]*/void r1081with_capacity(T1081* C,T2 a1);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[DICTIONARY[PLUGIN,STRING],STRING]]*/void r1090set_item(T1090* C,T0* a1);
/*HASHED_DICTIONARY_NODE[DICTIONARY[PLUGIN,STRING],STRING]*/void r1089make(T1089* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[PLUGIN,STRING]]*/void r1087set_item(T1087* C,T0* a1);
/*HASHED_DICTIONARY_NODE[PLUGIN,STRING]*/void r1086make(T1086* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_SET_NODE[NATIVE_PLUG_IN]]*/void r1084set_item(T1084* C,T0* a1);
/*HASHED_SET_NODE[NATIVE_PLUG_IN]*/void r1083make(T1083* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_SET_NODE],STRING]*/T6 r1074key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_SET_NODE],STRING]*/void r1074add(T1074* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_SET_NODE],STRING]*/T0* r1074new_node(T1074* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_SET_NODE],STRING]*/void r1074increase_capacity(T1074* C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_SET_NODE],STRING]*/T0* r1074common_free_nodes(void);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_SET_NODE],STRING]*/T0* r1074reference_at(T1074* C,T0* a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_SET_NODE],STRING]*/void r1074make(T1074* C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_AVL_SET_NODE],STRING]*/void r1074with_capacity(T1074* C,T2 a1);
/*WEAK_REFERENCE[AVL_SET_NODE[POSITION]]*/void r1072set_item(T1072* C,T0* a1);
/*AVL_SET_NODE[POSITION]*/T0* r1069rotate_left(T1069* C);
/*AVL_SET_NODE[POSITION]*/T6 r1069has(T1069* C,T296 a1);
/*AVL_SET_NODE[POSITION]*/void r1069make(T1069* C,T296 a1);
/*AVL_SET_NODE[POSITION]*/T0* r1069rotate_right(T1069* C);
T1066*create1066make_4(T0* a1,T0* a2,T0* a3,T0* a4);
/*TUPLE[ASSIGNMENT,INTERNAL_LOCAL,CALL_1_C,CALL_0_C]*/T0* r1066first(T1066* C);
/*TUPLE[ASSIGNMENT,INTERNAL_LOCAL,CALL_1_C,CALL_0_C]*/T0* r1066second(T1066* C);
/*TUPLE[ASSIGNMENT,INTERNAL_LOCAL,CALL_1_C,CALL_0_C]*/T0* r1066third(T1066* C);
/*TUPLE[ASSIGNMENT,INTERNAL_LOCAL,CALL_1_C,CALL_0_C]*/T0* r1066fourth(T1066* C);
/*TUPLE[ASSIGNMENT,INTERNAL_LOCAL,CALL_1_C,CALL_0_C]*/void r1066make_4(T1066* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T6 r1064key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/void r1064add(T1064* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T0* r1064new_node(T1064* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/void r1064set_cache_user(T1064* C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T2 r1064upper(T1064* C);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/void r1064increase_capacity(T1064* C);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T0* r1064item(T1064* C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T0* r1064common_free_nodes(void);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T0* r1064reference_at(T1064* C,T0* a1);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/void r1064make(T1064* C);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/void r1064with_capacity(T1064* C,T2 a1);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T6 r1063key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/void r1063add(T1063* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T0* r1063new_node(T1063* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/void r1063set_cache_user(T1063* C,T2 a1);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T2 r1063upper(T1063* C);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/void r1063increase_capacity(T1063* C);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T0* r1063item(T1063* C,T2 a1);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T0* r1063common_free_nodes(void);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T0* r1063reference_at(T1063* C,T0* a1);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/void r1063make(T1063* C);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/void r1063with_capacity(T1063* C,T2 a1);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1059add(T1059* C,T0* a1);
/*HASHED_SET[NATIVE_PLUG_IN]*/T0* r1059new_node(T1059* C,T0* a1,T0* a2);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1059set_cache_user(T1059* C,T2 a1);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1059clear_count(T1059* C);
/*HASHED_SET[NATIVE_PLUG_IN]*/T2 r1059upper(T1059* C);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1059increase_capacity(T1059* C);
/*HASHED_SET[NATIVE_PLUG_IN]*/T0* r1059item(T1059* C,T2 a1);
extern T0*oBC306common_free_nodes;
extern int fBC306common_free_nodes;
/*HASHED_SET[NATIVE_PLUG_IN]*/T0* r1059common_free_nodes(void);
/*HASHED_SET[NATIVE_PLUG_IN]*/T0* r1059dispose_node(T1059* C,T0* a1);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1059make(T1059* C);
/*HASHED_SET[NATIVE_PLUG_IN]*/T6 r1059safe_equal(T0* a1,T0* a2);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1059with_capacity(T1059* C,T2 a1);
/*STACK[EXPRESSION]*/void r1052pop(T1052* C);
/*STACK[EXPRESSION]*/void r1052push(T1052* C,T0* a1);
/*STACK[EXPRESSION]*/void r1052make(T1052* C);
/*STACK[EXPRESSION]*/void r1052with_capacity(T1052* C,T2 a1);
/*STACK[TYPE]*/void r1051pop(T1051* C);
/*STACK[TYPE]*/void r1051push(T1051* C,T0* a1);
/*STACK[TYPE]*/void r1051make(T1051* C);
/*STACK[TYPE]*/void r1051with_capacity(T1051* C,T2 a1);
/*STACK[TYPE]*/T0* r1051top(T1051* C);
/*COLLECTION_SORTER[INTEGER_32]*/T2 r1049insert_index(T0* a1,T2 a2);
/*COLLECTION_SORTER[INTEGER_32]*/T6 r1049lt(T2 a1,T2 a2);
/*COLLECTION_SORTER[INTEGER_32]*/T6 r1049lte(T2 a1,T2 a2);
/*REFERENCE[E_OLD]*/void r1046clear(T1046* C);
/*AVL_SET[POSITION]*/void r1043add(T1043* C,T296 a1);
/*AVL_SET[POSITION]*/T0* r1043new_node(T1043* C);
/*AVL_SET[POSITION]*/void r1043clear_count(T1043* C);
/*AVL_SET[POSITION]*/T0* r1043right_grown(T1043* C,T0* a1);
/*AVL_SET[POSITION]*/void r1043discard_node(T1043* C,T0* a1);
/*AVL_SET[POSITION]*/void r1043set_item(T1043* C,T0* a1);
/*AVL_SET[POSITION]*/T0* r1043a_new_node(void);
/*AVL_SET[POSITION]*/T6 r1043has(T1043* C,T296 a1);
/*AVL_SET[POSITION]*/T0* r1043left_grown(T1043* C,T0* a1);
/*AVL_SET[POSITION]*/void r1043clear_nodes(T1043* C,T0* a1);
/*AVL_SET[POSITION]*/T0* r1043do_insert(T1043* C,T0* a1);
extern T0*oBC585common_lost_nodes;
extern int fBC585common_lost_nodes;
/*AVL_SET[POSITION]*/T0* r1043common_lost_nodes(void);
/*AVL_SET[POSITION]*/void r1043make(T1043* C);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[PROCESS_WIN32,INTEGER_32]]*/void r1042set_item(T1042* C,T0* a1);
/*HASHED_DICTIONARY_NODE[PROCESS_WIN32,INTEGER_32]*/void r1040make(T1040* C,T0* a1,T2 a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[PROCESS_POSIX,INTEGER_32]]*/void r1039set_item(T1039* C,T0* a1);
/*HASHED_DICTIONARY_NODE[PROCESS_POSIX,INTEGER_32]*/void r1037make(T1037* C,T0* a1,T2 a2,T0* a3);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/T6 r1036key_safe_equal(T2 a1,T2 a2);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/T0* r1036new_node(T1036* C,T0* a1,T2 a2,T0* a3);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/void r1036increase_capacity(T1036* C);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/void r1036remove(T1036* C,T2 a1);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/T0* r1036common_free_nodes(void);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/T0* r1036dispose_node(T1036* C,T0* a1);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/void r1036put(T1036* C,T0* a1,T2 a2);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/void r1036make(T1036* C);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/void r1036with_capacity(T1036* C,T2 a1);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/T6 r1035key_safe_equal(T2 a1,T2 a2);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/T0* r1035new_node(T1035* C,T0* a1,T2 a2,T0* a3);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/void r1035increase_capacity(T1035* C);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/void r1035remove(T1035* C,T2 a1);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/T0* r1035common_free_nodes(void);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/T0* r1035dispose_node(T1035* C,T0* a1);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/void r1035put(T1035* C,T0* a1,T2 a2);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/void r1035make(T1035* C);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/void r1035with_capacity(T1035* C,T2 a1);
/*WEAK_REFERENCE[HASHED_SET_NODE[GRAPH_NODE]]*/void r1033set_item(T1033* C,T0* a1);
/*HASHED_SET_NODE[GRAPH_NODE]*/void r1032make(T1032* C,T0* a1,T0* a2);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[TEXT_FILE_READ,STRING]]*/void r1030set_item(T1030* C,T0* a1);
/*HASHED_DICTIONARY_NODE[TEXT_FILE_READ,STRING]*/void r1029make(T1029* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[STRING]*/void r1159set_item(T1159* C,T0* a1);
/*RING_ARRAY[WEAK_REFERENCE[STRING]]*/T2 r1158count(T1158* C);
/*RING_ARRAY[WEAK_REFERENCE[STRING]]*/T0* r1158item(T1158* C,T2 a1);
/*RING_ARRAY[WEAK_REFERENCE[STRING]]*/T2 r1158storage_index(T1158* C,T2 a1);
/*RING_ARRAY[WEAK_REFERENCE[STRING]]*/void r1158make_space_for_one(T1158* C);
/*RING_ARRAY[WEAK_REFERENCE[STRING]]*/void r1158squeeze_bubble(T1158* C,T2 a1,T2 a2,T2 a3,T2 a4);
/*RING_ARRAY[WEAK_REFERENCE[STRING]]*/T2 r1158wrap_point(T1158* C);
/*RING_ARRAY[WEAK_REFERENCE[STRING]]*/T2 r1158storage_upper(T1158* C);
/*RING_ARRAY[WEAK_REFERENCE[STRING]]*/void r1158add_last(T1158* C,T0* a1);
/*RING_ARRAY[WEAK_REFERENCE[STRING]]*/void r1158put(T1158* C,T0* a1,T2 a2);
/*RING_ARRAY[WEAK_REFERENCE[STRING]]*/void r1158with_capacity(T1158* C,T2 a1,T2 a2);
/*RING_ARRAY[WEAK_REFERENCE[STRING]]*/void r1158move(T1158* C,T2 a1,T2 a2,T2 a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[SE_C_MODE,STRING]]*/void r1026set_item(T1026* C,T0* a1);
/*HASHED_DICTIONARY_NODE[SE_C_MODE,STRING]*/void r1025make(T1025* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[ORDERED_DICTIONARY[STRING,STRING],STRING]]*/void r1023set_item(T1023* C,T0* a1);
/*ITERATOR_ON_TRAVERSABLE[STRING]*/T0* r1021item(T1021* C);
/*ITERATOR_ON_TRAVERSABLE[STRING]*/void r1021next(T1021* C);
/*ITERATOR_ON_TRAVERSABLE[STRING]*/void r1021make(T1021* C,T0* a1);
/*ITERATOR_ON_TRAVERSABLE[STRING]*/T6 r1021is_off(T1021* C);
/*HASHED_DICTIONARY_NODE[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r1020make(T1020* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[SWITCH_SITE,FEATURE_NAME]]*/void r1017set_item(T1017* C,T0* a1);
/*HASHED_DICTIONARY_NODE[SWITCH_SITE,FEATURE_NAME]*/void r1016make(T1016* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]]*/void r1013set_item(T1013* C,T0* a1);
/*HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/void r1012make(T1012* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_SET_NODE[LIVE_TYPE]]*/void r1007set_item(T1007* C,T0* a1);
/*HASHED_SET_NODE[LIVE_TYPE]*/void r1006make(T1006* C,T0* a1,T0* a2);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[CLUSTER_CLASS,HASHED_STRING]]*/void r1004set_item(T1004* C,T0* a1);
/*HASHED_DICTIONARY_NODE[CLUSTER_CLASS,HASHED_STRING]*/void r1003make(T1003* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[CLIENT_LIST,FEATURE_NAME]]*/void r1001set_item(T1001* C,T0* a1);
/*HASHED_DICTIONARY_NODE[CLIENT_LIST,FEATURE_NAME]*/void r1000make(T1000* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[FEATURE_STAMP,TYPE]]*/void r989set_item(T989* C,T0* a1);
/*HASHED_DICTIONARY_NODE[FEATURE_STAMP,TYPE]*/void r988make(T988* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[TYPE_MARK,TYPE]]*/void r986set_item(T986* C,T0* a1);
/*HASHED_DICTIONARY_NODE[TYPE_MARK,TYPE]*/void r985make(T985* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[TYPE,TYPE]]*/void r983set_item(T983* C,T0* a1);
/*HASHED_DICTIONARY_NODE[TYPE,TYPE]*/void r982make(T982* C,T0* a1,T0* a2,T0* a3);
/*HASHED_SET[GRAPH_NODE]*/T0* r980new_node(T980* C,T0* a1,T0* a2);
/*HASHED_SET[GRAPH_NODE]*/void r980set_cache_user(T980* C,T2 a1);
/*HASHED_SET[GRAPH_NODE]*/void r980clear_count(T980* C);
/*HASHED_SET[GRAPH_NODE]*/T2 r980upper(T980* C);
/*HASHED_SET[GRAPH_NODE]*/void r980increase_capacity(T980* C);
/*HASHED_SET[GRAPH_NODE]*/T0* r980item(T980* C,T2 a1);
/*HASHED_SET[GRAPH_NODE]*/T6 r980is_empty(T980* C);
/*HASHED_SET[GRAPH_NODE]*/T0* r980common_free_nodes(void);
/*HASHED_SET[GRAPH_NODE]*/T0* r980dispose_node(T980* C,T0* a1);
/*HASHED_SET[GRAPH_NODE]*/void r980make(T980* C);
/*HASHED_SET[GRAPH_NODE]*/void r980with_capacity(T980* C,T2 a1);
/*HASHED_SET[GRAPH_NODE]*/void r980fast_add(T980* C,T0* a1);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[CLASSES,STRING]]*/void r978set_item(T978* C,T0* a1);
/*HASHED_DICTIONARY_NODE[CLASSES,STRING]*/void r977make(T977* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/T6 r975key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/T0* r975new_node(T975* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/void r975increase_capacity(T975* C);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/T0* r975common_free_nodes(void);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/T6 r975has(T975* C,T0* a1);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/void r975put(T975* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/void r975make(T975* C);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/void r975with_capacity(T975* C,T2 a1);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/T6 r970key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/T0* r970new_node(T970* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/void r970increase_capacity(T970* C);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/T0* r970common_free_nodes(void);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/T0* r970reference_at(T970* C,T0* a1);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/void r970put(T970* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/void r970make(T970* C);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/void r970with_capacity(T970* C,T2 a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r969add(T969* C,T0* a1,T0* a2);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T6 r969key_safe_equal(T0* a1,T0* a2);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T0* r969new_node(T969* C,T0* a1,T0* a2,T0* a3);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T0* r969at(T969* C,T0* a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r969clear_count(T969* C);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r969increase_capacity(T969* C);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T0* r969common_free_nodes(void);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T0* r969dispose_node(T969* C,T0* a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T0* r969reference_at(T969* C,T0* a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T6 r969has(T969* C,T0* a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r969make(T969* C);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r969with_capacity(T969* C,T2 a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T0* r969get_new_iterator_on_keys(T969* C);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r969_P_277_clear_count(T969* C);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r969_P_277_with_capacity(T969* C,T2 a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r969_P_277_add(T969* C,T0* a1,T0* a2);
T968*create968make(void);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r968add(T968* C,T0* a1,T0* a2);
/*ORDERED_DICTIONARY[STRING,STRING]*/T6 r968key_safe_equal(T0* a1,T0* a2);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0* r968key(T968* C,T2 a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0* r968new_node(T968* C,T0* a1,T0* a2,T0* a3);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0* r968at(T968* C,T0* a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r968set_cache_user(T968* C,T2 a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r968clear_count(T968* C);
/*ORDERED_DICTIONARY[STRING,STRING]*/T2 r968upper(T968* C);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0* r968item(T968* C,T2 a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r968increase_capacity(T968* C);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0* r968common_free_nodes(void);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0* r968dispose_node(T968* C,T0* a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0* r968reference_at(T968* C,T0* a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/T6 r968has(T968* C,T0* a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r968put(T968* C,T0* a1,T0* a2);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r968make(T968* C);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r968with_capacity(T968* C,T2 a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0* r968get_new_iterator_on_keys(T968* C);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r968_P_277_clear_count(T968* C);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r968_P_277_with_capacity(T968* C,T2 a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r968_P_277_add(T968* C,T0* a1,T0* a2);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r968_P_277_put(T968* C,T0* a1,T0* a2);
/*WEAK_REFERENCE[HASHED_SET_NODE[MANIFEST_GENERIC]]*/void r965set_item(T965* C,T0* a1);
/*HASHED_SET_NODE[MANIFEST_GENERIC]*/void r964make(T964* C,T0* a1,T0* a2);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[SWITCH_TYPE,LIVE_TYPE]]*/void r961set_item(T961* C,T0* a1);
/*HASHED_DICTIONARY_NODE[SWITCH_TYPE,LIVE_TYPE]*/void r960make(T960* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[SWITCH_SITE,FEATURE_NAME]*/T6 r958key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[SWITCH_SITE,FEATURE_NAME]*/void r958add(T958* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[SWITCH_SITE,FEATURE_NAME]*/T0* r958new_node(T958* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[SWITCH_SITE,FEATURE_NAME]*/void r958set_cache_user(T958* C,T2 a1);
/*HASHED_DICTIONARY[SWITCH_SITE,FEATURE_NAME]*/T0* r958item(T958* C,T2 a1);
/*HASHED_DICTIONARY[SWITCH_SITE,FEATURE_NAME]*/void r958increase_capacity(T958* C);
/*HASHED_DICTIONARY[SWITCH_SITE,FEATURE_NAME]*/T0* r958common_free_nodes(void);
/*HASHED_DICTIONARY[SWITCH_SITE,FEATURE_NAME]*/T0* r958reference_at(T958* C,T0* a1);
/*HASHED_DICTIONARY[SWITCH_SITE,FEATURE_NAME]*/void r958make(T958* C);
/*HASHED_DICTIONARY[SWITCH_SITE,FEATURE_NAME]*/void r958with_capacity(T958* C,T2 a1);
/*WEAK_REFERENCE[HASHED_SET_NODE[AGENT_ARGS]]*/void r957set_item(T957* C,T0* a1);
/*HASHED_SET_NODE[AGENT_ARGS]*/void r956make(T956* C,T0* a1,T0* a2);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[FAST_ARRAY[AGENT_CREATION],TYPE]]*/void r954set_item(T954* C,T0* a1);
/*HASHED_DICTIONARY_NODE[FAST_ARRAY[AGENT_CREATION],TYPE]*/void r952make(T952* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[HASHED_SET[TYPE],TYPE]]*/void r950set_item(T950* C,T0* a1);
/*HASHED_DICTIONARY_NODE[HASHED_SET[TYPE],TYPE]*/void r949make(T949* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[MANIFEST_STRING,MANIFEST_STRING]]*/void r947set_item(T947* C,T0* a1);
/*HASHED_DICTIONARY_NODE[MANIFEST_STRING,MANIFEST_STRING]*/void r946make(T946* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[MANIFEST_STRING,STRING]]*/void r944set_item(T944* C,T0* a1);
/*HASHED_DICTIONARY_NODE[MANIFEST_STRING,STRING]*/void r943make(T943* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_SET_NODE[STRING]]*/void r941set_item(T941* C,T0* a1);
/*HASHED_SET_NODE[STRING]*/void r940make(T940* C,T0* a1,T0* a2);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,TYPE]]*/void r938set_item(T938* C,T0* a1);
/*HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,TYPE]*/void r937make(T937* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[RUN_FEATURE,TYPE]]*/void r935set_item(T935* C,T0* a1);
/*HASHED_DICTIONARY_NODE[RUN_FEATURE,TYPE]*/void r934make(T934* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_SET_NODE[TYPE]]*/void r930set_item(T930* C,T0* a1);
/*HASHED_SET_NODE[TYPE]*/void r929make(T929* C,T0* a1,T0* a2);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[GRAPH_NODE,TYPE]]*/void r926set_item(T926* C,T0* a1);
/*HASHED_DICTIONARY_NODE[GRAPH_NODE,TYPE]*/void r924make(T924* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[FEATURE_STAMP,FEATURE_NAME]]*/void r911set_item(T911* C,T0* a1);
/*HASHED_DICTIONARY_NODE[FEATURE_STAMP,FEATURE_NAME]*/void r910make(T910* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]]*/void r921set_item(T921* C,T0* a1);
/*HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/void r920make(T920* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_SET_NODE[ABSOLUTE_FEATURE_NAME]]*/void r917set_item(T917* C,T0* a1);
/*HASHED_SET_NODE[ABSOLUTE_FEATURE_NAME]*/void r916make(T916* C,T304 a1,T0* a2);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]]*/void r914set_item(T914* C,T0* a1);
/*HASHED_DICTIONARY_NODE[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r913make(T913* C,T0* a1,T304 a2,T0* a3);
/*WEAK_REFERENCE[HASHED_BIJECTIVE_DICTIONARY_NODE[FEATURE_STAMP,FEATURE_NAME]]*/void r908set_item(T908* C,T0* a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/void r906add(T906* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/T0* r906new_node(T906* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/void r906increase_capacity(T906* C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/T0* r906common_free_nodes(void);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/T0* r906fast_reference_at(T906* C,T0* a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/void r906make(T906* C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/void r906with_capacity(T906* C,T2 a1);
/*HASHED_BIJECTIVE_DICTIONARY_NODE[FEATURE_STAMP,FEATURE_NAME]*/void r905make(T905* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,FEATURE_NAME]]*/void r903set_item(T903* C,T0* a1);
/*HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,FEATURE_NAME]*/void r902make(T902* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,FEATURE_STAMP]]*/void r897set_item(T897* C,T0* a1);
/*HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r896make(T896* C,T0* a1,T0* a2,T0* a3);
/*HASHED_SET[LIVE_TYPE]*/T0* r892new_node(T892* C,T0* a1,T0* a2);
/*HASHED_SET[LIVE_TYPE]*/void r892clear_count(T892* C);
/*HASHED_SET[LIVE_TYPE]*/void r892increase_capacity(T892* C);
/*HASHED_SET[LIVE_TYPE]*/T0* r892common_free_nodes(void);
/*HASHED_SET[LIVE_TYPE]*/T0* r892dispose_node(T892* C,T0* a1);
/*HASHED_SET[LIVE_TYPE]*/void r892make(T892* C);
/*HASHED_SET[LIVE_TYPE]*/void r892with_capacity(T892* C,T2 a1);
/*HASHED_SET[LIVE_TYPE]*/void r892fast_add(T892* C,T0* a1);
/*HASHED_SET[LIVE_TYPE]*/T6 r892fast_has(T892* C,T0* a1);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[FAST_ARRAY[STRING],CLASS_NAME]]*/void r889set_item(T889* C,T0* a1);
/*HASHED_DICTIONARY_NODE[FAST_ARRAY[STRING],CLASS_NAME]*/void r888make(T888* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_SET_NODE[CLASS_NAME]]*/void r862set_item(T862* C,T0* a1);
/*HASHED_SET_NODE[CLASS_NAME]*/void r861make(T861* C,T0* a1,T0* a2);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[INTEGER_32,CLASS_NAME]]*/void r859set_item(T859* C,T0* a1);
/*HASHED_DICTIONARY_NODE[INTEGER_32,CLASS_NAME]*/void r858make(T858* C,T2 a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/void r886add(T886* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/T0* r886new_node(T886* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/void r886increase_capacity(T886* C);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/T0* r886common_free_nodes(void);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/T0* r886fast_reference_at(T886* C,T0* a1);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/void r886make(T886* C);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/void r886with_capacity(T886* C,T2 a1);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/T6 r886fast_has(T886* C,T0* a1);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T6 r884key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/void r884add(T884* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T0* r884new_node(T884* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/void r884increase_capacity(T884* C);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T0* r884internal_key(T884* C,T0* a1);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T0* r884common_free_nodes(void);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T0* r884reference_at(T884* C,T0* a1);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/void r884put(T884* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/void r884with_capacity(T884* C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T6 r867key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r867add(T867* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0* r867key(T867* C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0* r867new_node(T867* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r867copy(T867* C,T0* a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r867clear_count(T867* C);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r867set_cache_user(T867* C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r867fast_put(T867* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0* r867item(T867* C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r867increase_capacity(T867* C);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0* r867common_free_nodes(void);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0* r867dispose_node(T867* C,T0* a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0* r867fast_reference_at(T867* C,T0* a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r867put(T867* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r867make(T867* C);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r867with_capacity(T867* C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0* r867twin(T867* C);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/T0* r866new_node(T866* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/void r866fast_put(T866* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/void r866increase_capacity(T866* C);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/T0* r866common_free_nodes(void);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/T0* r866fast_reference_at(T866* C,T0* a1);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/void r866with_capacity(T866* C,T2 a1);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T6 r865key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T0* r865new_node(T865* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[TYPE,TYPE]*/void r865fast_put(T865* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[TYPE,TYPE]*/void r865increase_capacity(T865* C);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T0* r865fast_at(T865* C,T0* a1);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T0* r865common_free_nodes(void);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T0* r865fast_reference_at(T865* C,T0* a1);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T0* r865reference_at(T865* C,T0* a1);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T6 r865has(T865* C,T0* a1);
/*HASHED_DICTIONARY[TYPE,TYPE]*/void r865put(T865* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[TYPE,TYPE]*/void r865make(T865* C);
/*HASHED_DICTIONARY[TYPE,TYPE]*/void r865with_capacity(T865* C,T2 a1);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]]*/void r855set_item(T855* C,T0* a1);
/*HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/void r854make(T854* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[CECIL_FILE,STRING]]*/void r851set_item(T851* C,T0* a1);
/*HASHED_DICTIONARY_NODE[CECIL_FILE,STRING]*/void r850make(T850* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]]*/void r847set_item(T847* C,T0* a1);
/*HASHED_DICTIONARY_NODE[DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/void r846make(T846* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[CLASS_TEXT,HASHED_STRING]]*/void r844set_item(T844* C,T0* a1);
/*HASHED_DICTIONARY_NODE[CLASS_TEXT,HASHED_STRING]*/void r843make(T843* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[CLASSES,STRING]*/T6 r839key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[CLASSES,STRING]*/void r839add(T839* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[CLASSES,STRING]*/T0* r839new_node(T839* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[CLASSES,STRING]*/void r839increase_capacity(T839* C);
/*HASHED_DICTIONARY[CLASSES,STRING]*/T0* r839common_free_nodes(void);
/*HASHED_DICTIONARY[CLASSES,STRING]*/T0* r839reference_at(T839* C,T0* a1);
/*HASHED_DICTIONARY[CLASSES,STRING]*/void r839make(T839* C);
/*HASHED_DICTIONARY[CLASSES,STRING]*/void r839with_capacity(T839* C,T2 a1);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[STRING,STRING]]*/void r833set_item(T833* C,T0* a1);
/*HASHED_DICTIONARY_NODE[STRING,STRING]*/void r831make(T831* C,T0* a1,T0* a2,T0* a3);
/*COLLECTION_SORTER[STRING]*/void r830add(T0* a1,T0* a2);
/*COLLECTION_SORTER[STRING]*/T6 r830is_sorted(T0* a1);
/*COLLECTION_SORTER[STRING]*/void r830quick_sort(T0* a1);
/*COLLECTION_SORTER[STRING]*/T2 r830insert_index(T0* a1,T0* a2);
/*COLLECTION_SORTER[STRING]*/void r830quick_sort_region(T0* a1,T2 a2,T2 a3);
/*COLLECTION_SORTER[STRING]*/T6 r830lt(T0* a1,T0* a2);
/*COLLECTION_SORTER[STRING]*/void r830sort(T0* a1);
/*COLLECTION_SORTER[STRING]*/T6 r830lte(T0* a1,T0* a2);
/*HASHED_SET[MANIFEST_GENERIC]*/void r828add(T828* C,T0* a1);
/*HASHED_SET[MANIFEST_GENERIC]*/T0* r828new_node(T828* C,T0* a1,T0* a2);
/*HASHED_SET[MANIFEST_GENERIC]*/void r828set_cache_user(T828* C,T2 a1);
/*HASHED_SET[MANIFEST_GENERIC]*/void r828clear_count(T828* C);
/*HASHED_SET[MANIFEST_GENERIC]*/void r828increase_capacity(T828* C);
/*HASHED_SET[MANIFEST_GENERIC]*/T0* r828item(T828* C,T2 a1);
/*HASHED_SET[MANIFEST_GENERIC]*/T0* r828common_free_nodes(void);
/*HASHED_SET[MANIFEST_GENERIC]*/T0* r828dispose_node(T828* C,T0* a1);
/*HASHED_SET[MANIFEST_GENERIC]*/void r828make(T828* C);
/*HASHED_SET[MANIFEST_GENERIC]*/T6 r828safe_equal(T0* a1,T0* a2);
/*HASHED_SET[MANIFEST_GENERIC]*/void r828with_capacity(T828* C,T2 a1);
/*HASHED_DICTIONARY[SWITCH_TYPE,LIVE_TYPE]*/T0* r826new_node(T826* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[SWITCH_TYPE,LIVE_TYPE]*/void r826set_cache_user(T826* C,T2 a1);
/*HASHED_DICTIONARY[SWITCH_TYPE,LIVE_TYPE]*/void r826fast_put(T826* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[SWITCH_TYPE,LIVE_TYPE]*/void r826increase_capacity(T826* C);
/*HASHED_DICTIONARY[SWITCH_TYPE,LIVE_TYPE]*/T0* r826item(T826* C,T2 a1);
/*HASHED_DICTIONARY[SWITCH_TYPE,LIVE_TYPE]*/T6 r826is_empty(T826* C);
/*HASHED_DICTIONARY[SWITCH_TYPE,LIVE_TYPE]*/T0* r826common_free_nodes(void);
/*HASHED_DICTIONARY[SWITCH_TYPE,LIVE_TYPE]*/T0* r826fast_reference_at(T826* C,T0* a1);
/*HASHED_DICTIONARY[SWITCH_TYPE,LIVE_TYPE]*/void r826with_capacity(T826* C,T2 a1);
/*HASHED_SET[AGENT_ARGS]*/void r824add(T824* C,T0* a1);
/*HASHED_SET[AGENT_ARGS]*/T0* r824new_node(T824* C,T0* a1,T0* a2);
/*HASHED_SET[AGENT_ARGS]*/void r824set_cache_user(T824* C,T2 a1);
/*HASHED_SET[AGENT_ARGS]*/void r824clear_count(T824* C);
/*HASHED_SET[AGENT_ARGS]*/T2 r824upper(T824* C);
/*HASHED_SET[AGENT_ARGS]*/void r824increase_capacity(T824* C);
/*HASHED_SET[AGENT_ARGS]*/T0* r824item(T824* C,T2 a1);
/*HASHED_SET[AGENT_ARGS]*/T0* r824common_free_nodes(void);
/*HASHED_SET[AGENT_ARGS]*/T0* r824dispose_node(T824* C,T0* a1);
/*HASHED_SET[AGENT_ARGS]*/T6 r824has(T824* C,T0* a1);
/*HASHED_SET[AGENT_ARGS]*/void r824make(T824* C);
/*HASHED_SET[AGENT_ARGS]*/T6 r824safe_equal(T0* a1,T0* a2);
/*HASHED_SET[AGENT_ARGS]*/void r824with_capacity(T824* C,T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T6 r822key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/void r822add(T822* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T0* r822new_node(T822* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T0* r822key(T822* C,T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/void r822set_cache_user(T822* C,T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/void r822increase_capacity(T822* C);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T0* r822item(T822* C,T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T0* r822common_free_nodes(void);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T0* r822reference_at(T822* C,T0* a1);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/void r822make(T822* C);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/void r822with_capacity(T822* C,T2 a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T0* r819new_node(T819* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T0* r819key(T819* C,T2 a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/void r819set_cache_user(T819* C,T2 a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/void r819clear_count(T819* C);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/void r819fast_put(T819* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/void r819increase_capacity(T819* C);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T0* r819item(T819* C,T2 a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T0* r819common_free_nodes(void);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T0* r819fast_reference_at(T819* C,T0* a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T0* r819dispose_node(T819* C,T0* a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/void r819make(T819* C);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/void r819with_capacity(T819* C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T6 r818key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T0* r818new_node(T818* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/void r818set_cache_user(T818* C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/void r818clear_count(T818* C);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/void r818increase_capacity(T818* C);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T0* r818item(T818* C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T0* r818common_free_nodes(void);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T0* r818dispose_node(T818* C,T0* a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T0* r818reference_at(T818* C,T0* a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/void r818put(T818* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/void r818with_capacity(T818* C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T6 r817key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T0* r817new_node(T817* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/void r817set_cache_user(T817* C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/void r817clear_count(T817* C);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/void r817increase_capacity(T817* C);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T0* r817item(T817* C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T0* r817common_free_nodes(void);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T0* r817dispose_node(T817* C,T0* a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T6 r817has(T817* C,T0* a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/void r817put(T817* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/void r817with_capacity(T817* C,T2 a1);
/*HASHED_SET[STRING]*/void r816add(T816* C,T0* a1);
/*HASHED_SET[STRING]*/T0* r816new_node(T816* C,T0* a1,T0* a2);
/*HASHED_SET[STRING]*/void r816clear_count(T816* C);
/*HASHED_SET[STRING]*/void r816manifest_put(T816* C,T2 a1,T0* a2);
/*HASHED_SET[STRING]*/void r816increase_capacity(T816* C);
/*HASHED_SET[STRING]*/void r816manifest_make(T816* C,T2 a1);
/*HASHED_SET[STRING]*/T0* r816common_free_nodes(void);
/*HASHED_SET[STRING]*/T0* r816dispose_node(T816* C,T0* a1);
/*HASHED_SET[STRING]*/T6 r816has(T816* C,T0* a1);
/*HASHED_SET[STRING]*/void r816make(T816* C);
/*HASHED_SET[STRING]*/T6 r816safe_equal(T0* a1,T0* a2);
/*HASHED_SET[STRING]*/void r816with_capacity(T816* C,T2 a1);
/*HASHED_SET[STRING]*/T6 r816fast_has(T816* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/void r812add(T812* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T0* r812new_node(T812* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/void r812fast_put(T812* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/void r812increase_capacity(T812* C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T0* r812fast_at(T812* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T0* r812common_free_nodes(void);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T0* r812fast_reference_at(T812* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/void r812with_capacity(T812* C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T6 r812fast_has(T812* C,T0* a1);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/void r811add(T811* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/T0* r811new_node(T811* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/void r811increase_capacity(T811* C);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/T0* r811common_free_nodes(void);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/T0* r811fast_reference_at(T811* C,T0* a1);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/void r811with_capacity(T811* C,T2 a1);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/T6 r811fast_has(T811* C,T0* a1);
/*STACK[ANONYMOUS_FEATURE]*/void r807pop(T807* C);
/*STACK[ANONYMOUS_FEATURE]*/void r807push(T807* C,T0* a1);
/*STACK[ANONYMOUS_FEATURE]*/void r807make(T807* C);
/*STACK[ANONYMOUS_FEATURE]*/void r807with_capacity(T807* C,T2 a1);
/*STACK[ANONYMOUS_FEATURE]*/T0* r807top(T807* C);
/*HASHED_SET[TYPE]*/void r805add(T805* C,T0* a1);
/*HASHED_SET[TYPE]*/T0* r805new_node(T805* C,T0* a1,T0* a2);
/*HASHED_SET[TYPE]*/void r805set_cache_user(T805* C,T2 a1);
/*HASHED_SET[TYPE]*/void r805clear_count(T805* C);
/*HASHED_SET[TYPE]*/T2 r805upper(T805* C);
/*HASHED_SET[TYPE]*/T0* r805item(T805* C,T2 a1);
/*HASHED_SET[TYPE]*/void r805increase_capacity(T805* C);
/*HASHED_SET[TYPE]*/void r805remove(T805* C,T0* a1);
/*HASHED_SET[TYPE]*/T0* r805common_free_nodes(void);
/*HASHED_SET[TYPE]*/T0* r805dispose_node(T805* C,T0* a1);
/*HASHED_SET[TYPE]*/T6 r805has(T805* C,T0* a1);
/*HASHED_SET[TYPE]*/void r805make(T805* C);
/*HASHED_SET[TYPE]*/T6 r805safe_equal(T0* a1,T0* a2);
/*HASHED_SET[TYPE]*/void r805with_capacity(T805* C,T2 a1);
/*HASHED_SET[TYPE]*/void r805fast_add(T805* C,T0* a1);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/void r803add(T803* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/T0* r803new_node(T803* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/void r803set_cache_user(T803* C,T2 a1);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/void r803increase_capacity(T803* C);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/T0* r803item(T803* C,T2 a1);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/T0* r803common_free_nodes(void);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/T0* r803fast_reference_at(T803* C,T0* a1);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/void r803with_capacity(T803* C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T6 r791key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r791add(T791* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0* r791new_node(T791* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r791set_cache_user(T791* C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0* r791item(T791* C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r791increase_capacity(T791* C);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0* r791common_free_nodes(void);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0* r791reference_at(T791* C,T0* a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r791with_capacity(T791* C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T6 r796key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/void r796add(T796* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T0* r796new_node(T796* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/void r796clear_count(T796* C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/void r796increase_capacity(T796* C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T0* r796common_free_nodes(void);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T0* r796dispose_node(T796* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T0* r796reference_at(T796* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T6 r796has(T796* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/void r796with_capacity(T796* C,T2 a1);
/*QUEUE[TYPE]*/void r794add(T794* C,T0* a1);
/*QUEUE[TYPE]*/T2 r794count(T794* C);
/*QUEUE[TYPE]*/T0* r794item(T794* C,T2 a1);
/*QUEUE[TYPE]*/T2 r794storage_index(T794* C,T2 a1);
/*QUEUE[TYPE]*/void r794make_space_for_one(T794* C);
/*QUEUE[TYPE]*/void r794remove(T794* C);
/*QUEUE[TYPE]*/void r794squeeze_bubble(T794* C,T2 a1,T2 a2,T2 a3,T2 a4);
/*QUEUE[TYPE]*/T6 r794is_empty(T794* C);
/*QUEUE[TYPE]*/T2 r794wrap_point(T794* C);
/*QUEUE[TYPE]*/T0* r794first(T794* C);
/*QUEUE[TYPE]*/T2 r794storage_upper(T794* C);
/*QUEUE[TYPE]*/void r794collection_with_capacity(T794* C,T2 a1,T2 a2);
/*QUEUE[TYPE]*/void r794put(T794* C,T0* a1,T2 a2);
/*QUEUE[TYPE]*/void r794with_capacity(T794* C,T2 a1);
/*QUEUE[TYPE]*/void r794move(T794* C,T2 a1,T2 a2,T2 a3);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/void r793add(T793* C,T304 a1);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T0* r793new_node(T793* C,T304 a1,T0* a2);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/void r793set_cache_user(T793* C,T2 a1);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/void r793clear_count(T793* C);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T2 r793upper(T793* C);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/void r793increase_capacity(T793* C);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T304 r793item(T793* C,T2 a1);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T0* r793common_free_nodes(void);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T0* r793dispose_node(T793* C,T0* a1);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/void r793make(T793* C);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T6 r793safe_equal(T304 a1,T304 a2);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/void r793with_capacity(T793* C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T6 r792key_safe_equal(T304 a1,T304 a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r792add(T792* C,T0* a1,T304 a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T0* r792new_node(T792* C,T0* a1,T304 a2,T0* a3);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r792clear_count(T792* C);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r792increase_capacity(T792* C);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T0* r792common_free_nodes(void);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T0* r792dispose_node(T792* C,T0* a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T0* r792reference_at(T792* C,T304 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r792make(T792* C);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r792with_capacity(T792* C,T2 a1);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[TYPE,HASHED_STRING]]*/void r790set_item(T790* C,T0* a1);
/*HASHED_DICTIONARY_NODE[TYPE,HASHED_STRING]*/void r789make(T789* C,T0* a1,T0* a2,T0* a3);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r786add(T786* C,T0* a1,T0* a2);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T6 r786key_safe_equal(T0* a1,T0* a2);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0* r786key(T786* C,T2 a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0* r786new_node(T786* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0* r786fast_key_at(T786* C,T0* a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r786set_cache_user(T786* C,T2 a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r786increase_capacity(T786* C);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0* r786item(T786* C,T2 a1);
extern T0*oBC326common_free_nodes;
extern int fBC326common_free_nodes;
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0* r786common_free_nodes(void);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0* r786internal_key(T786* C,T0* a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0* r786reference_at(T786* C,T0* a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T6 r786has(T786* C,T0* a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r786with_capacity(T786* C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T6 r785key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/void r785add(T785* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0* r785new_node(T785* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0* r785key(T785* C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0* r785at(T785* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/void r785set_cache_user(T785* C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T2 r785upper(T785* C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/void r785increase_capacity(T785* C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0* r785item(T785* C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0* r785internal_key(T785* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0* r785common_free_nodes(void);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0* r785reference_at(T785* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T6 r785has(T785* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/void r785make(T785* C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/void r785with_capacity(T785* C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T6 r784key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r784add(T784* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T0* r784new_node(T784* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T0* r784key(T784* C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r784set_cache_user(T784* C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r784clear_count(T784* C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r784fast_put(T784* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T2 r784upper(T784* C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r784fast_remove(T784* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T0* r784fast_at(T784* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r784increase_capacity(T784* C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T0* r784item(T784* C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r784remove(T784* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T6 r784is_empty(T784* C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T0* r784common_free_nodes(void);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T0* r784dispose_node(T784* C,T0* a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r784with_capacity(T784* C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T6 r784fast_has(T784* C,T0* a1);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[INTEGER_16,HASHED_STRING]]*/void r778set_item(T778* C,T0* a1);
/*HASHED_DICTIONARY_NODE[INTEGER_16,HASHED_STRING]*/void r777make(T777* C,T10 a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/T6 r775key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/void r775add(T775* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/T0* r775new_node(T775* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/void r775increase_capacity(T775* C);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/T0* r775common_free_nodes(void);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/T0* r775reference_at(T775* C,T0* a1);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/void r775make(T775* C);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/void r775with_capacity(T775* C,T2 a1);
/*HASHED_SET[CLASS_NAME]*/void r764add(T764* C,T0* a1);
/*HASHED_SET[CLASS_NAME]*/T0* r764new_node(T764* C,T0* a1,T0* a2);
/*HASHED_SET[CLASS_NAME]*/void r764clear_count(T764* C);
/*HASHED_SET[CLASS_NAME]*/void r764increase_capacity(T764* C);
/*HASHED_SET[CLASS_NAME]*/T0* r764common_free_nodes(void);
/*HASHED_SET[CLASS_NAME]*/T0* r764dispose_node(T764* C,T0* a1);
/*HASHED_SET[CLASS_NAME]*/T6 r764has(T764* C,T0* a1);
/*HASHED_SET[CLASS_NAME]*/void r764make(T764* C);
/*HASHED_SET[CLASS_NAME]*/T6 r764safe_equal(T0* a1,T0* a2);
/*HASHED_SET[CLASS_NAME]*/void r764with_capacity(T764* C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T6 r762key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T0* r762new_node(T762* C,T2 a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T2 r762at(T762* C,T0* a1);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/void r762increase_capacity(T762* C);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T0* r762internal_key(T762* C,T0* a1);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T0* r762common_free_nodes(void);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T6 r762has(T762* C,T0* a1);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/void r762put(T762* C,T2 a1,T0* a2);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/void r762make(T762* C);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/void r762with_capacity(T762* C,T2 a1);
/*HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/void r760make(T760* C,T0* a1,T0* a2,T0* a3);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]]*/void r759set_item(T759* C,T0* a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/void r758add(T758* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/T0* r758new_node(T758* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/void r758special_common_dictionary(T758* C,T0* a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/void r758increase_capacity(T758* C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/T0* r758fast_reference_at(T758* C,T0* a1);
/*WEAK_REFERENCE[HASHED_DICTIONARY_NODE[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]]*/void r757set_item(T757* C,T0* a1);
/*HASHED_DICTIONARY_NODE[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/void r754make(T754* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/void r751add(T751* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/T0* r751new_node(T751* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/void r751increase_capacity(T751* C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/T0* r751common_free_nodes(void);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/T0* r751fast_reference_at(T751* C,T0* a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/void r751make(T751* C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/void r751with_capacity(T751* C,T2 a1);
/*WEAK_REFERENCE[HASHED_SET_NODE[HASHED_STRING]]*/void r748set_item(T748* C,T0* a1);
/*HASHED_SET_NODE[HASHED_STRING]*/void r747make(T747* C,T0* a1,T0* a2);
/*REVERSE_COLLECTION_SORTER[POSITION]*/T6 r744is_sorted(T0* a1);
/*REVERSE_COLLECTION_SORTER[POSITION]*/void r744quick_sort(T0* a1);
/*REVERSE_COLLECTION_SORTER[POSITION]*/void r744quick_sort_region(T0* a1,T2 a2,T2 a3);
/*REVERSE_COLLECTION_SORTER[POSITION]*/T6 r744lt(T296 a1,T296 a2);
/*REVERSE_COLLECTION_SORTER[POSITION]*/void r744sort(T0* a1);
/*REVERSE_COLLECTION_SORTER[POSITION]*/T6 r744lte(T296 a1,T296 a2);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T6 r742key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/void r742add(T742* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T0* r742new_node(T742* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/void r742set_cache_user(T742* C,T2 a1);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T2 r742upper(T742* C);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/void r742increase_capacity(T742* C);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T0* r742item(T742* C,T2 a1);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T0* r742common_free_nodes(void);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T6 r742has(T742* C,T0* a1);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/void r742make(T742* C);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/void r742with_capacity(T742* C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/T6 r738key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/T0* r738new_node(T738* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/void r738increase_capacity(T738* C);
/*HASHED_DICTIONARY[DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/T0* r738common_free_nodes(void);
/*HASHED_DICTIONARY[DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/T0* r738reference_at(T738* C,T0* a1);
/*HASHED_DICTIONARY[DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/void r738put(T738* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/void r738make(T738* C);
/*HASHED_DICTIONARY[DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/void r738with_capacity(T738* C,T2 a1);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T6 r737key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/void r737add(T737* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T0* r737new_node(T737* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/void r737set_cache_user(T737* C,T2 a1);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T2 r737upper(T737* C);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T0* r737item(T737* C,T2 a1);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/void r737increase_capacity(T737* C);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T0* r737common_free_nodes(void);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T0* r737reference_at(T737* C,T0* a1);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/void r737put(T737* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/void r737make(T737* C);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/void r737with_capacity(T737* C,T2 a1);
/*HASHED_DICTIONARY[STRING,STRING]*/void r728add(T728* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[STRING,STRING]*/T6 r728key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[STRING,STRING]*/T0* r728new_node(T728* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[STRING,STRING]*/T0* r728key(T728* C,T2 a1);
/*HASHED_DICTIONARY[STRING,STRING]*/void r728set_cache_user(T728* C,T2 a1);
/*HASHED_DICTIONARY[STRING,STRING]*/T2 r728upper(T728* C);
/*HASHED_DICTIONARY[STRING,STRING]*/void r728increase_capacity(T728* C);
/*HASHED_DICTIONARY[STRING,STRING]*/T0* r728item(T728* C,T2 a1);
/*HASHED_DICTIONARY[STRING,STRING]*/T0* r728common_free_nodes(void);
/*HASHED_DICTIONARY[STRING,STRING]*/T0* r728reference_at(T728* C,T0* a1);
/*HASHED_DICTIONARY[STRING,STRING]*/T6 r728has(T728* C,T0* a1);
/*HASHED_DICTIONARY[STRING,STRING]*/void r728put(T728* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[STRING,STRING]*/void r728make(T728* C);
/*HASHED_DICTIONARY[STRING,STRING]*/void r728with_capacity(T728* C,T2 a1);
/*HASHED_DICTIONARY[STRING,STRING]*/T0* r728get_new_iterator_on_keys(T728* C);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/void r724add(T724* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/T0* r724new_node(T724* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/void r724increase_capacity(T724* C);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/T0* r724common_free_nodes(void);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/T0* r724fast_reference_at(T724* C,T0* a1);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/void r724make(T724* C);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/void r724with_capacity(T724* C,T2 a1);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/T6 r724fast_has(T724* C,T0* a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/void r722add(T722* C,T10 a1,T0* a2);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T0* r722new_node(T722* C,T10 a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T0* r722key(T722* C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/void r722set_cache_user(T722* C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T0* r722fast_key_at(T722* C,T10 a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/void r722fast_put(T722* C,T10 a1,T0* a2);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T2 r722upper(T722* C);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/void r722increase_capacity(T722* C);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T10 r722item(T722* C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T10 r722fast_at(T722* C,T0* a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T0* r722common_free_nodes(void);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/void r722with_capacity(T722* C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T6 r722fast_has(T722* C,T0* a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T6 r721key_safe_equal(T0* a1,T0* a2);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/void r721add(T721* C,T0* a1,T0* a2);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T0* r721new_node(T721* C,T0* a1,T0* a2,T0* a3);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T0* r721key(T721* C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/void r721set_cache_user(T721* C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T2 r721upper(T721* C);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/void r721increase_capacity(T721* C);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T0* r721item(T721* C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T0* r721common_free_nodes(void);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T0* r721reference_at(T721* C,T0* a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/void r721with_capacity(T721* C,T2 a1);
/*HASHED_SET[HASHED_STRING]*/void r718add(T718* C,T0* a1);
/*HASHED_SET[HASHED_STRING]*/T0* r718new_node(T718* C,T0* a1,T0* a2);
/*HASHED_SET[HASHED_STRING]*/void r718clear_count(T718* C);
/*HASHED_SET[HASHED_STRING]*/void r718manifest_put(T718* C,T2 a1,T0* a2);
/*HASHED_SET[HASHED_STRING]*/void r718increase_capacity(T718* C);
/*HASHED_SET[HASHED_STRING]*/void r718manifest_make(T718* C,T2 a1);
/*HASHED_SET[HASHED_STRING]*/T0* r718common_free_nodes(void);
/*HASHED_SET[HASHED_STRING]*/T0* r718dispose_node(T718* C,T0* a1);
/*HASHED_SET[HASHED_STRING]*/T0* r718reference_at(T718* C,T0* a1);
/*HASHED_SET[HASHED_STRING]*/void r718make(T718* C);
/*HASHED_SET[HASHED_STRING]*/T6 r718safe_equal(T0* a1,T0* a2);
/*HASHED_SET[HASHED_STRING]*/void r718with_capacity(T718* C,T2 a1);
/*NO_INVARIANT_WRAPPER*/void r380copy(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/T0* r380simplify_routine_body_first(T380* C,T0* a1,T0* a2);
extern T0*oBC28ace;
/*NO_INVARIANT_WRAPPER*/T0* r380specialize_2(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/T0* r380simplify(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/void r380collect(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/T0* r380current_or_twin_init(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/T0* r380specialize_thru(T380* C,T0* a1,T0* a2,T0* a3);
extern T0*oBC28cpp;
/*NO_INVARIANT_WRAPPER*/void r380compile_to_c_with_internal_c_local_saving(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/T0* r380specialize_in(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/void r380compile_to_c(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/T6 r380use_current(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/T0* r380specialize_2_without_checks(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/void r380accept(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/T6 r380side_effect_free(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/T0* r380adapt_for(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/void r380make(T380* C,T0* a1);
/*NO_INVARIANT_WRAPPER*/T0* r380twin(T380* C);
/*NO_INVARIANT_WRAPPER*/T296 r380start_position(T380* C);
/*NO_INVARIANT_WRAPPER*/void r380safety_check(T380* C,T0* a1);
/*NUMBERED_CAPTURE*/void r426mapping_c_target(T426* C,T0* a1,T0* a2);
/*NUMBERED_CAPTURE*/void r426standard_mapping_c_target(T426* C,T0* a1,T0* a2);
/*NUMBERED_CAPTURE*/void r426copy(T426* C,T0* a1);
/*NUMBERED_CAPTURE*/T0* r426non_void_no_dispatch_type(T426* C,T0* a1);
/*NUMBERED_CAPTURE*/T6 r426is_equal(T426* C,T0* a1);
/*NUMBERED_CAPTURE*/T0* r426specialize_2(T0* a1);
/*NUMBERED_CAPTURE*/T0* r426static_simplify(T426* C);
/*NUMBERED_CAPTURE*/T0* r426simplify(T426* C,T0* a1);
/*NUMBERED_CAPTURE*/T0* r426collect(T426* C,T0* a1);
/*NUMBERED_CAPTURE*/T0* r426specialize_thru(T0* a1,T0* a2,T0* a3);
/*NUMBERED_CAPTURE*/void r426compile_to_c_with_internal_c_local_saving(T426* C,T0* a1);
/*NUMBERED_CAPTURE*/T0* r426specialize_in(T0* a1);
/*NUMBERED_CAPTURE*/void r426compile_to_c(T426* C,T0* a1);
/*NUMBERED_CAPTURE*/T6 r426use_current(T0* a1);
/*NUMBERED_CAPTURE*/void r426accept(T426* C,T0* a1);
/*NUMBERED_CAPTURE*/T6 r426side_effect_free(T0* a1);
/*NUMBERED_CAPTURE*/T0* r426declaration_type(void);
/*NUMBERED_CAPTURE*/T0* r426adapt_for(T0* a1);
/*NUMBERED_CAPTURE*/T0* r426resolve_in(T426* C,T0* a1);
/*NUMBERED_CAPTURE*/void r426make(T426* C,T0* a1,T2 a2);
/*NUMBERED_CAPTURE*/T0* r426written_declaration_type_mark(void);
/*NUMBERED_CAPTURE*/T0* r426twin(T426* C);
/*NUMBERED_CAPTURE*/T296 r426start_position(T426* C);
/*NUMBERED_CAPTURE*/T6 r426extra_bracket_flag(void);
/*NUMBERED_CAPTURE*/void r426mapping_c_arg(T426* C,T0* a1);
/*NUMBERED_CAPTURE*/T2 r426precedence(void);
/*NUMBERED_CAPTURE*/T6 r426is_static(T426* C);
/*NUMBERED_CAPTURE*/T6 r426is_default_value(void);
/*FAKE_ARGUMENT*/void r288copy(T288* C,T0* a1);
/*FAKE_ARGUMENT*/T0* r288non_void_no_dispatch_type(T0* a1);
/*FAKE_ARGUMENT*/T6 r288is_equal(T288* C,T0* a1);
/*FAKE_ARGUMENT*/T0* r288specialize_2(T288* C,T0* a1);
/*FAKE_ARGUMENT*/T0* r288static_simplify(T288* C);
/*FAKE_ARGUMENT*/T0* r288simplify(T288* C,T0* a1);
/*FAKE_ARGUMENT*/T0* r288collect(T288* C,T0* a1);
/*FAKE_ARGUMENT*/T0* r288specialize_thru(T288* C,T0* a1,T0* a2,T0* a3);
/*FAKE_ARGUMENT*/void r288compile_to_c_with_internal_c_local_saving(T288* C,T0* a1);
/*FAKE_ARGUMENT*/T0* r288specialize_in(T288* C,T0* a1);
/*FAKE_ARGUMENT*/void r288compile_to_c(T288* C,T0* a1);
/*FAKE_ARGUMENT*/T6 r288use_current(T0* a1);
/*FAKE_ARGUMENT*/void r288accept(T288* C,T0* a1);
/*FAKE_ARGUMENT*/T6 r288side_effect_free(T0* a1);
/*FAKE_ARGUMENT*/T0* r288adapt_for(T288* C,T0* a1);
/*FAKE_ARGUMENT*/T0* r288resolve_in(T288* C,T0* a1);
/*FAKE_ARGUMENT*/void r288make(T288* C,T0* a1,T2 a2);
/*FAKE_ARGUMENT*/T0* r288written_declaration_type_mark(void);
/*FAKE_ARGUMENT*/T0* r288twin(T288* C);
/*FAKE_ARGUMENT*/T296 r288start_position(T288* C);
/*FAKE_ARGUMENT*/void r288mapping_c_arg(T288* C,T0* a1);
/*FAKE_ARGUMENT*/T2 r288precedence(void);
/*FAKE_ARGUMENT*/T6 r288is_default_value(void);
/*SWITCH*/void r499start_profile(T0* a1);
/*SWITCH*/void r499stop_profile(void);
/*SWITCH*/void r499local_profile(void);
/*SWITCH*/void r499c_define(T0* a1);
/*SWITCH*/void r499name_in(T0* a1,T0* a2);
/*SWITCH*/void r499c_switch(T0* a1);
/*SWITCH*/void r499c_dichotomatic(T0* a1,T2 a2,T2 a3);
/*CODE_CONTEXT_DIRECT_CALL*/void r492set_type(T492* C,T0* a1);
/*CODE_CONTEXT_DIRECT_CALL*/void r492set_internal_c_local(T492* C,T0* a1);
/*CODE_CONTEXT_DIRECT_CALL*/void r492set_static_type(T492* C,T0* a1);
/*CODE_CONTEXT_DIRECT_CALL*/T0* r492static_type(T492* C);
/*CODE_CONTEXT_DIRECT_CALL*/T0* r492internal_c_local(T492* C);
/*CODE_CONTEXT_DIRECT_CALL*/void r492reserve(T492* C);
/*CODE_CONTEXT_DIRECT_CALL*/void r492set_anonymous_feature(T492* C,T0* a1);
/*CODE_CONTEXT_DIRECT_CALL*/void r492set_effective_arguments(T492* C,T0* a1);
/*CODE_CONTEXT_DIRECT_CALL*/T0* r492effective_arguments(T492* C);
/*CODE_CONTEXT_DIRECT_CALL*/T0* r492target(T492* C);
/*CODE_CONTEXT_DIRECT_CALL*/T0* r492type(T492* C);
/*CODE_CONTEXT_DIRECT_CALL*/T0* r492anonymous_feature(T492* C);
/*CODE_CONTEXT_DIRECT_CALL*/T2 r492code(void);
/*CODE_CONTEXT_DIRECT_CALL*/void r492set_target(T492* C,T0* a1);
/*CODE_CONTEXT_CHECK_ID*/void r491set_type(T491* C,T0* a1);
/*CODE_CONTEXT_CHECK_ID*/void r491set_internal_c_local(T491* C,T0* a1);
/*CODE_CONTEXT_CHECK_ID*/void r491set_static_type(T491* C,T0* a1);
/*CODE_CONTEXT_CHECK_ID*/T0* r491static_type(T491* C);
/*CODE_CONTEXT_CHECK_ID*/T0* r491internal_c_local(T491* C);
/*CODE_CONTEXT_CHECK_ID*/void r491reserve(T491* C);
/*CODE_CONTEXT_CHECK_ID*/void r491set_anonymous_feature(T491* C,T0* a1);
/*CODE_CONTEXT_CHECK_ID*/void r491set_effective_arguments(T491* C,T0* a1);
/*CODE_CONTEXT_CHECK_ID*/T0* r491effective_arguments(T491* C);
/*CODE_CONTEXT_CHECK_ID*/T0* r491target(T491* C);
/*CODE_CONTEXT_CHECK_ID*/T0* r491type(T491* C);
/*CODE_CONTEXT_CHECK_ID*/T0* r491anonymous_feature(T491* C);
/*CODE_CONTEXT_CHECK_ID*/T2 r491code(void);
/*CODE_CONTEXT_CHECK_ID*/void r491set_target(T491* C,T0* a1);
/*CODE_CONTEXT_SWITCH*/void r490set_type(T490* C,T0* a1);
/*CODE_CONTEXT_SWITCH*/void r490set_internal_c_local(T490* C,T0* a1);
/*CODE_CONTEXT_SWITCH*/void r490set_static_type(T490* C,T0* a1);
/*CODE_CONTEXT_SWITCH*/T0* r490static_type(T490* C);
/*CODE_CONTEXT_SWITCH*/T0* r490internal_c_local(T490* C);
/*CODE_CONTEXT_SWITCH*/void r490reserve(T490* C);
/*CODE_CONTEXT_SWITCH*/void r490set_anonymous_feature(T490* C,T0* a1);
/*CODE_CONTEXT_SWITCH*/void r490set_effective_arguments(T490* C,T0* a1);
/*CODE_CONTEXT_SWITCH*/T0* r490effective_arguments(T490* C);
/*CODE_CONTEXT_SWITCH*/T0* r490target(T490* C);
/*CODE_CONTEXT_SWITCH*/T0* r490type(T490* C);
/*CODE_CONTEXT_SWITCH*/T0* r490anonymous_feature(T490* C);
/*CODE_CONTEXT_SWITCH*/T2 r490code(void);
/*CODE_CONTEXT_SWITCH*/void r490set_target(T490* C,T0* a1);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/void r489set_type(T489* C,T0* a1);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/void r489set_internal_c_local(T489* C,T0* a1);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/void r489set_static_type(T489* C,T0* a1);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/T0* r489static_type(T489* C);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/T0* r489internal_c_local(T489* C);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/void r489reserve(T489* C);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/void r489set_anonymous_feature(T489* C,T0* a1);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/void r489set_effective_arguments(T489* C,T0* a1);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/T0* r489effective_arguments(T489* C);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/T0* r489target(T489* C);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/T0* r489type(T489* C);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/T0* r489anonymous_feature(T489* C);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/T2 r489code(void);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/void r489set_target(T489* C,T0* a1);
/*CODE_CONTEXT_CREATE_EXPRESSION*/void r488set_type(T488* C,T0* a1);
/*CODE_CONTEXT_CREATE_EXPRESSION*/void r488set_internal_c_local(T488* C,T0* a1);
/*CODE_CONTEXT_CREATE_EXPRESSION*/void r488set_static_type(T488* C,T0* a1);
/*CODE_CONTEXT_CREATE_EXPRESSION*/T0* r488static_type(T488* C);
/*CODE_CONTEXT_CREATE_EXPRESSION*/T0* r488internal_c_local(T488* C);
/*CODE_CONTEXT_CREATE_EXPRESSION*/void r488reserve(T488* C);
/*CODE_CONTEXT_CREATE_EXPRESSION*/void r488set_anonymous_feature(T488* C,T0* a1);
/*CODE_CONTEXT_CREATE_EXPRESSION*/void r488set_effective_arguments(T488* C,T0* a1);
/*CODE_CONTEXT_CREATE_EXPRESSION*/T0* r488effective_arguments(T488* C);
/*CODE_CONTEXT_CREATE_EXPRESSION*/T0* r488target(T488* C);
/*CODE_CONTEXT_CREATE_EXPRESSION*/T0* r488type(T488* C);
/*CODE_CONTEXT_CREATE_EXPRESSION*/T0* r488anonymous_feature(T488* C);
/*CODE_CONTEXT_CREATE_EXPRESSION*/T2 r488code(void);
/*CODE_CONTEXT_CREATE_EXPRESSION*/void r488set_target(T488* C,T0* a1);
/*CODE_CONTEXT_INSIDE_TWIN*/void r487set_type(T487* C,T0* a1);
/*CODE_CONTEXT_INSIDE_TWIN*/void r487set_internal_c_local(T487* C,T0* a1);
/*CODE_CONTEXT_INSIDE_TWIN*/void r487set_static_type(T487* C,T0* a1);
/*CODE_CONTEXT_INSIDE_TWIN*/T0* r487static_type(T487* C);
/*CODE_CONTEXT_INSIDE_TWIN*/T0* r487internal_c_local(T487* C);
/*CODE_CONTEXT_INSIDE_TWIN*/void r487reserve(T487* C);
/*CODE_CONTEXT_INSIDE_TWIN*/void r487set_anonymous_feature(T487* C,T0* a1);
/*CODE_CONTEXT_INSIDE_TWIN*/void r487set_effective_arguments(T487* C,T0* a1);
/*CODE_CONTEXT_INSIDE_TWIN*/T0* r487effective_arguments(T487* C);
/*CODE_CONTEXT_INSIDE_TWIN*/T0* r487target(T487* C);
/*CODE_CONTEXT_INSIDE_TWIN*/T0* r487type(T487* C);
/*CODE_CONTEXT_INSIDE_TWIN*/T0* r487anonymous_feature(T487* C);
/*CODE_CONTEXT_INSIDE_TWIN*/T2 r487code(void);
/*CODE_CONTEXT_INSIDE_TWIN*/void r487set_target(T487* C,T0* a1);
/*CODE_CONTEXT_PRECURSOR*/void r486set_type(T486* C,T0* a1);
/*CODE_CONTEXT_PRECURSOR*/void r486set_internal_c_local(T486* C,T0* a1);
/*CODE_CONTEXT_PRECURSOR*/void r486set_static_type(T486* C,T0* a1);
/*CODE_CONTEXT_PRECURSOR*/T0* r486static_type(T486* C);
/*CODE_CONTEXT_PRECURSOR*/T0* r486internal_c_local(T486* C);
/*CODE_CONTEXT_PRECURSOR*/void r486reserve(T486* C);
/*CODE_CONTEXT_PRECURSOR*/void r486set_anonymous_feature(T486* C,T0* a1);
/*CODE_CONTEXT_PRECURSOR*/void r486set_effective_arguments(T486* C,T0* a1);
/*CODE_CONTEXT_PRECURSOR*/T0* r486effective_arguments(T486* C);
/*CODE_CONTEXT_PRECURSOR*/T0* r486target(T486* C);
/*CODE_CONTEXT_PRECURSOR*/T0* r486type(T486* C);
/*CODE_CONTEXT_PRECURSOR*/T0* r486anonymous_feature(T486* C);
/*CODE_CONTEXT_PRECURSOR*/T2 r486code(void);
/*CODE_CONTEXT_PRECURSOR*/void r486set_target(T486* C,T0* a1);
/*INTERNAL_C_LOCAL*/void r292append_in(T292* C,T0* a1);
extern T0*oBC292counter;
/*INTERNAL_C_LOCAL*/T6 r292has_the_same_c_type_than(T292* C,T0* a1);
/*INTERNAL_C_LOCAL*/void r292c_type_in(T292* C,T0* a1);
/*INTERNAL_C_LOCAL*/void r292un_lock_after_dump(T292* C);
/*INTERNAL_C_LOCAL*/void r292make(T292* C,T0* a1);
/*INTERNAL_C_LOCAL*/void r292recycle(T292* C,T0* a1);
extern T0*oBC503pending_locked_stack;
extern int fBC503pending_locked_stack;
/*INTERNAL_C_LOCAL_LIST*/T0* r503pending_locked_stack(void);
/*INTERNAL_C_LOCAL_LIST*/void r503unlock(T2 a1);
/*INTERNAL_C_LOCAL_LIST*/T0* r503lock_local(T0* a1);
extern T0*oBC503pending_c_function_locals;
extern int fBC503pending_c_function_locals;
/*INTERNAL_C_LOCAL_LIST*/T0* r503pending_c_function_locals(void);
extern T0*oBC503internal_c_local_pool;
extern int fBC503internal_c_local_pool;
/*INTERNAL_C_LOCAL_LIST*/T0* r503internal_c_local_pool(void);
/*INTERNAL_C_LOCAL_LIST*/void r503declaration_dump(T503* C,T0* a1);
/*INTERNAL_C_LOCAL_LIST*/T2 r503stack_level(void);
extern T0*oBC28echo;
extern int fBC28echo;
/*INTERNAL_C_LOCAL_LIST*/T0* r503echo(void);
/*INTERNAL_C_LOCAL_LIST*/void r503echo_information(T503* C);
extern T0*oBC28plugin_config;
/*C_PLUGIN*/T6 r701is_equal(T701* C,T0* a1);
extern T0*oBC28system_tools;
extern int fBC28system_tools;
/*C_PLUGIN*/T0* r701system_tools(void);
/*C_PLUGIN*/T0* r701read(T0* a1);
extern T0*oBC504tfr;
/*C_PLUGIN*/T0* r701cecil_pool(void);
/*C_PLUGIN*/void r701try_auto_init(T701* C);
extern T0*oBC28cecil_pool_memory;
/*C_PLUGIN*/void r701add_c_source(T701* C,T0* a1);
/*C_PLUGIN*/void r701include(T701* C,T296 a1);
/*C_PLUGIN*/T0* r701absolute_path(T701* C,T0* a1);
extern T0*oBC28parser_buffer;
extern int fBC28parser_buffer;
/*C_PLUGIN*/T0* r701parser_buffer(void);
extern T0*oBC28error_handler;
/*C_PLUGIN*/void r701read_auto_init(T701* C,T0* a1);
/*C_PLUGIN*/void r701make(T701* C,T296 a1,T0* a2,T0* a3);
/*C_PLUGIN*/void r701add_c_header(T701* C,T0* a1);
/*C_PLUGIN*/T0* r701echo(void);
/*TUPLE_STRING_POOL*/void r685from_collection(T685* C,T0* a1);
extern T0*oBC686counter;
/*TUPLE_STRING_POOL*/T2 r685state(T685* C,T2 a1,T3 a2);
/*TUPLE_STRING_POOL*/void r685make_transitions_array(T685* C);
/*TUPLE_STRING_POOL*/T2 r685the_final_state(T685* C,T0* a1,T2 a2,T2 a3);
/*TUPLE_STRING_POOL*/void r685count_states(T685* C);
extern T0*oBC686transition_memory;
extern int fBC686transition_memory;
/*TUPLE_STRING_POOL*/T0* r685transition_memory(void);
/*TUPLE_STRING_POOL*/void r685compile_headers(T685* C);
/*TUPLE_STRING_POOL*/void r685externalize_tags(T685* C,T0* a1);
/*TUPLE_STRING_POOL*/void r685set_state(T685* C,T2 a1,T2 a2,T3 a3);
/*TUPLE_STRING_POOL*/T2 r685external_state(T685* C,T2 a1);
/*FAKE_TUPLE*/void r472copy(T472* C,T0* a1);
/*FAKE_TUPLE*/T2 r472count(T472* C);
extern T0*oBC28assignment_handler;
/*FAKE_TUPLE*/T0* r472specialize_2(T472* C,T0* a1);
/*FAKE_TUPLE*/T0* r472specialize_thru(T472* C,T0* a1,T0* a2,T0* a3);
/*FAKE_TUPLE*/void r472compile_to_c(T472* C,T0* a1);
/*FAKE_TUPLE*/T6 r472use_current(T472* C,T0* a1);
/*FAKE_TUPLE*/T0* r472implicit_cast(T472* C,T0* a1,T0* a2);
/*FAKE_TUPLE*/T0* r472adapt_for(T472* C,T0* a1);
/*FAKE_TUPLE*/void r472make(T472* C,T0* a1);
/*FAKE_TUPLE*/T0* r472twin(T472* C);
/*FAKE_TUPLE*/void r472safety_check(T472* C,T0* a1);
/*EXEC_OUTPUT_STREAM_WIN32*/void r681flush(T681* C);
/*EXEC_OUTPUT_STREAM_WIN32*/void r681disconnect(T681* C);
/*EXEC_OUTPUT_STREAM_WIN32*/void r681create_pipe(T681* C);
/*EXEC_OUTPUT_STREAM_WIN32*/void r681put_new_line(T681* C);
extern T0*oBC37tmp_string;
extern int fBC37tmp_string;
/*EXEC_OUTPUT_STREAM_WIN32*/T0* r681tmp_string(void);
/*EXEC_OUTPUT_STREAM_WIN32*/void r681put_integer(T681* C,T11 a1);
/*EXEC_OUTPUT_STREAM_WIN32*/void r681put_real_format(T681* C,T5 a1,T2 a2);
/*EXEC_OUTPUT_STREAM_WIN32*/void r681put_character(T681* C,T3 a1);
/*EXEC_OUTPUT_STREAM_WIN32*/void r681put_string(T681* C,T0* a1);
/*EXEC_OUTPUT_STREAM_WIN32*/void r681filtered_put_character(T681* C,T3 a1);
/*EXEC_OUTPUT_STREAM_WIN32*/void r681make(T681* C,T0* a1);
/*EXEC_OUTPUT_STREAM_WIN32*/void r681filtered_flush(T681* C);
/*EXEC_INPUT_STREAM_WIN32*/void r680disconnect(T680* C);
/*EXEC_INPUT_STREAM_WIN32*/void r680create_pipe(T680* C);
/*EXEC_INPUT_STREAM_WIN32*/void r680swap_unread_buffer(T680* C);
/*EXEC_INPUT_STREAM_WIN32*/void r680filtered_read_character(T680* C);
/*EXEC_INPUT_STREAM_WIN32*/void r680make(T680* C,T0* a1);
/*EXEC_INPUT_STREAM_WIN32*/void r680read_character(T680* C);
/*EXEC_INPUT_STREAM_WIN32*/T3 r680last_character(T680* C);
/*EXEC_OUTPUT_STREAM_POSIX*/void r679flush(T679* C);
/*EXEC_OUTPUT_STREAM_POSIX*/void r679disconnect(T679* C);
/*EXEC_OUTPUT_STREAM_POSIX*/void r679create_pipe(T679* C);
/*EXEC_OUTPUT_STREAM_POSIX*/void r679put_new_line(T679* C);
/*EXEC_OUTPUT_STREAM_POSIX*/T0* r679tmp_string(void);
/*EXEC_OUTPUT_STREAM_POSIX*/void r679put_integer(T679* C,T11 a1);
/*EXEC_OUTPUT_STREAM_POSIX*/void r679put_real_format(T679* C,T5 a1,T2 a2);
/*EXEC_OUTPUT_STREAM_POSIX*/void r679put_character(T679* C,T3 a1);
/*EXEC_OUTPUT_STREAM_POSIX*/void r679put_string(T679* C,T0* a1);
/*EXEC_OUTPUT_STREAM_POSIX*/void r679filtered_put_character(T679* C,T3 a1);
/*EXEC_OUTPUT_STREAM_POSIX*/void r679make(T679* C,T0* a1);
/*EXEC_OUTPUT_STREAM_POSIX*/void r679filtered_flush(T679* C);
/*EXEC_INPUT_STREAM_POSIX*/void r677disconnect(T677* C);
/*EXEC_INPUT_STREAM_POSIX*/void r677create_pipe(T677* C);
/*EXEC_INPUT_STREAM_POSIX*/void r677swap_unread_buffer(T677* C);
/*EXEC_INPUT_STREAM_POSIX*/void r677filtered_read_character(T677* C);
/*EXEC_INPUT_STREAM_POSIX*/void r677make(T677* C,T0* a1);
/*EXEC_INPUT_STREAM_POSIX*/void r677read_character(T677* C);
/*EXEC_INPUT_STREAM_POSIX*/T3 r677last_character(T677* C);
/*RUN_FEATURE_6*/T6 r481use_current(T481* C);
/*RUN_FEATURE_6*/void r481default_mapping_arg(T481* C,T6 a1,T6 a2,T6 a3);
extern T0*oBC28smart_eiffel;
/*RUN_FEATURE_6*/void r481compute_use_current(T481* C);
/*RUN_FEATURE_6*/void r481c_define_opening(T481* C);
/*RUN_FEATURE_6*/void r481for(T481* C,T0* a1,T0* a2,T0* a3);
/*RUN_FEATURE_6*/T6 r481prepare_introspection2(T481* C,T6 a1);
/*RUN_FEATURE_6*/T0* r481cecil_pool(void);
/*RUN_FEATURE_6*/void r481address_of_c_mapping(T481* C);
/*RUN_FEATURE_6*/void r481address_of_c_define(T481* C,T0* a1);
/*RUN_FEATURE_6*/T0* r481feature_stamp(T481* C);
/*RUN_FEATURE_6*/void r481do_adapt(T481* C);
/*RUN_FEATURE_6*/T6 r481prepare_introspection(T481* C,T6 a1);
/*RUN_FEATURE_6*/void r481c_initialize_frame_information(T481* C,T2 a1);
/*RUN_FEATURE_6*/void r481c_define(T481* C);
/*RUN_FEATURE_6*/void r481address_of_c_define_wrapper(T481* C,T0* a1);
/*RUN_FEATURE_6*/void r481mapping_name_in(T481* C,T0* a1);
extern T0*oBC28exceptions_handler;
/*RUN_FEATURE_6*/void r481adapt(T481* C);
/*RUN_FEATURE_6*/void r481default_mapping_function(T481* C);
/*RUN_FEATURE_6*/void r481c_define_closing(T481* C);
extern T0*oBC28once_routine_pool;
/*RUN_FEATURE_6*/void r481c_frame_descriptor(T481* C);
/*RUN_FEATURE_6*/T296 r481start_position(T481* C);
/*RUN_FEATURE_6*/void r481c_set_dump_stack_top(T481* C,T0* a1,T0* a2);
/*RUN_FEATURE_6*/void r481set_result_type(T481* C);
/*RUN_FEATURE_6*/T6 r481is_precomputable_once(T481* C);
/*RUN_FEATURE_6*/void r481address_of_wrapper_name_in(T481* C,T0* a1);
/*RUN_FEATURE_6*/void r481mapping_c(T481* C);
/*RUN_FEATURE_6*/void r481define_c_signature(T481* C);
/*RUN_FEATURE_6*/void r481put_c_name_tag(T481* C);
/*RUN_FEATURE_6*/void r481std_compute_use_current(T481* C);
/*RUN_FEATURE_6*/void r481address_of_c_mapping_wrapper(T481* C);
extern T0*oBC28manifest_string_pool;
/*RUN_FEATURE_5*/T6 r480use_current(T480* C);
/*RUN_FEATURE_5*/void r480default_mapping_arg(T480* C,T6 a1,T6 a2,T6 a3);
/*RUN_FEATURE_5*/void r480compute_use_current(T480* C);
/*RUN_FEATURE_5*/void r480c_define_opening(T480* C);
/*RUN_FEATURE_5*/void r480for(T480* C,T0* a1,T0* a2,T0* a3);
/*RUN_FEATURE_5*/T6 r480prepare_introspection2(T6 a1);
/*RUN_FEATURE_5*/T0* r480cecil_pool(void);
/*RUN_FEATURE_5*/void r480address_of_c_mapping(T480* C);
/*RUN_FEATURE_5*/void r480address_of_c_define(T480* C,T0* a1);
/*RUN_FEATURE_5*/T0* r480feature_stamp(T480* C);
/*RUN_FEATURE_5*/void r480do_adapt(T480* C);
/*RUN_FEATURE_5*/T6 r480prepare_introspection(T6 a1);
/*RUN_FEATURE_5*/void r480c_initialize_frame_information(T480* C,T2 a1);
/*RUN_FEATURE_5*/void r480c_define(T480* C);
/*RUN_FEATURE_5*/void r480address_of_c_define_wrapper(T480* C,T0* a1);
/*RUN_FEATURE_5*/void r480mapping_name_in(T480* C,T0* a1);
/*RUN_FEATURE_5*/void r480adapt(T480* C);
/*RUN_FEATURE_5*/void r480default_mapping_function(T480* C);
/*RUN_FEATURE_5*/void r480c_define_closing(T480* C);
/*RUN_FEATURE_5*/void r480c_frame_descriptor(T480* C);
/*RUN_FEATURE_5*/T296 r480start_position(T480* C);
/*RUN_FEATURE_5*/T0* r480result_type(void);
/*RUN_FEATURE_5*/void r480c_set_dump_stack_top(T480* C,T0* a1,T0* a2);
/*RUN_FEATURE_5*/void r480default_mapping_procedure(T480* C);
/*RUN_FEATURE_5*/void r480address_of_wrapper_name_in(T480* C,T0* a1);
/*RUN_FEATURE_5*/void r480mapping_c(T480* C);
/*RUN_FEATURE_5*/void r480define_c_signature(T480* C);
/*RUN_FEATURE_5*/void r480put_c_name_tag(T480* C);
/*RUN_FEATURE_5*/void r480std_compute_use_current(T480* C);
/*RUN_FEATURE_5*/void r480address_of_c_mapping_wrapper(T480* C);
/*RUN_FEATURE_4*/T6 r626use_current(T626* C);
/*RUN_FEATURE_4*/void r626default_mapping_arg(T626* C,T6 a1,T6 a2,T6 a3);
/*RUN_FEATURE_4*/void r626compute_use_current(T626* C);
/*RUN_FEATURE_4*/void r626c_define_opening(T626* C);
/*RUN_FEATURE_4*/void r626for(T626* C,T0* a1,T0* a2,T0* a3);
/*RUN_FEATURE_4*/T6 r626prepare_introspection2(T6 a1);
/*RUN_FEATURE_4*/T0* r626cecil_pool(void);
/*RUN_FEATURE_4*/void r626address_of_c_mapping(T626* C);
/*RUN_FEATURE_4*/void r626address_of_c_define(T626* C,T0* a1);
/*RUN_FEATURE_4*/T0* r626feature_stamp(T626* C);
/*RUN_FEATURE_4*/void r626do_adapt(T626* C);
/*RUN_FEATURE_4*/T6 r626prepare_introspection(T6 a1);
/*RUN_FEATURE_4*/void r626c_initialize_frame_information(T626* C,T2 a1);
/*RUN_FEATURE_4*/void r626c_define(T626* C);
/*RUN_FEATURE_4*/void r626address_of_c_define_wrapper(T626* C,T0* a1);
/*RUN_FEATURE_4*/void r626mapping_name_in(T626* C,T0* a1);
/*RUN_FEATURE_4*/void r626adapt(T626* C);
/*RUN_FEATURE_4*/void r626default_mapping_function(T626* C);
/*RUN_FEATURE_4*/void r626c_define_closing(T626* C);
/*RUN_FEATURE_4*/void r626c_frame_descriptor(T626* C);
/*RUN_FEATURE_4*/T296 r626start_position(T626* C);
/*RUN_FEATURE_4*/void r626c_set_dump_stack_top(T626* C,T0* a1,T0* a2);
/*RUN_FEATURE_4*/void r626set_result_type(T626* C);
/*RUN_FEATURE_4*/void r626address_of_wrapper_name_in(T626* C,T0* a1);
/*RUN_FEATURE_4*/void r626mapping_c(T626* C);
/*RUN_FEATURE_4*/void r626define_c_signature(T626* C);
/*RUN_FEATURE_4*/void r626put_c_name_tag(T626* C);
/*RUN_FEATURE_4*/void r626std_compute_use_current(T626* C);
/*RUN_FEATURE_4*/void r626address_of_c_mapping_wrapper(T626* C);
/*RUN_FEATURE_3*/T6 r479use_current(T479* C);
/*RUN_FEATURE_3*/void r479default_mapping_arg(T479* C,T6 a1,T6 a2,T6 a3);
/*RUN_FEATURE_3*/T6 r479side_effect_free(T479* C);
/*RUN_FEATURE_3*/void r479compute_use_current(T479* C);
/*RUN_FEATURE_3*/void r479c_define_opening(T479* C);
/*RUN_FEATURE_3*/void r479for(T479* C,T0* a1,T0* a2,T0* a3);
/*RUN_FEATURE_3*/T6 r479prepare_introspection2(T6 a1);
/*RUN_FEATURE_3*/T0* r479cecil_pool(void);
/*RUN_FEATURE_3*/void r479address_of_c_mapping(T479* C);
/*RUN_FEATURE_3*/void r479address_of_c_define(T479* C,T0* a1);
/*RUN_FEATURE_3*/T0* r479feature_stamp(T479* C);
/*RUN_FEATURE_3*/void r479do_adapt(T479* C);
/*RUN_FEATURE_3*/T6 r479prepare_introspection(T6 a1);
/*RUN_FEATURE_3*/void r479c_initialize_frame_information(T479* C,T2 a1);
/*RUN_FEATURE_3*/void r479c_define(T479* C);
/*RUN_FEATURE_3*/void r479address_of_c_define_wrapper(T479* C,T0* a1);
/*RUN_FEATURE_3*/void r479mapping_name_in(T479* C,T0* a1);
/*RUN_FEATURE_3*/void r479adapt(T479* C);
/*RUN_FEATURE_3*/void r479default_mapping_function(T479* C);
/*RUN_FEATURE_3*/void r479c_define_closing(T479* C);
/*RUN_FEATURE_3*/void r479c_frame_descriptor(T479* C);
/*RUN_FEATURE_3*/T296 r479start_position(T479* C);
/*RUN_FEATURE_3*/T0* r479memory_dispose(T479* C);
/*RUN_FEATURE_3*/T0* r479result_type(void);
/*RUN_FEATURE_3*/void r479c_set_dump_stack_top(T479* C,T0* a1,T0* a2);
extern int fBC479mapping_c_root;
/*RUN_FEATURE_3*/void r479mapping_c_root(T479* C);
/*RUN_FEATURE_3*/T6 r479is_empty_or_null_body(T479* C);
/*RUN_FEATURE_3*/void r479default_mapping_procedure(T479* C);
/*RUN_FEATURE_3*/T6 r479empty_body_side_effect_free_in_boost(T479* C);
/*RUN_FEATURE_3*/void r479address_of_wrapper_name_in(T479* C,T0* a1);
/*RUN_FEATURE_3*/void r479mapping_c(T479* C);
/*RUN_FEATURE_3*/void r479define_c_signature(T479* C);
/*RUN_FEATURE_3*/void r479put_c_name_tag(T479* C);
/*RUN_FEATURE_3*/void r479std_compute_use_current(T479* C);
/*RUN_FEATURE_3*/void r479address_of_c_mapping_wrapper(T479* C);
/*RUN_FEATURE_1*/void r614set_result_type(T614* C);
/*RUN_FEATURE_1*/T0* r614routine_body(void);
/*RUN_FEATURE_1*/void r614mapping_c(T614* C);
/*RUN_FEATURE_1*/T0* r614require_assertion(void);
/*RUN_FEATURE_1*/T0* r614arguments(void);
/*RUN_FEATURE_1*/void r614for(T614* C,T0* a1,T0* a2,T0* a3);
/*RUN_FEATURE_1*/T6 r614prepare_introspection2(T6 a1);
/*RUN_FEATURE_1*/void r614address_of_c_define(T614* C,T0* a1);
/*RUN_FEATURE_1*/T6 r614prepare_introspection(T6 a1);
/*RUN_FEATURE_1*/T296 r614start_position(T614* C);
/*RUN_FEATURE_1*/void r614mapping_name_in(T614* C,T0* a1);
/*RUN_FEATURE_1*/void r614adapt(T614* C);
/*RUN_FEATURE_1*/T0* r614feature_stamp(T614* C);
/*RUN_FEATURE_1*/void r614c_set_dump_stack_top(T614* C,T0* a1,T0* a2);
/*RUN_FEATURE_1*/T0* r614ensure_assertion(void);
/*RUN_FEATURE_1*/T0* r614local_vars(void);
/*INTERNAL_LOCAL*/void r553mapping_c_target(T553* C,T0* a1,T0* a2);
/*INTERNAL_LOCAL*/void r553standard_mapping_c_target(T553* C,T0* a1,T0* a2);
/*INTERNAL_LOCAL*/void r553copy(T553* C,T0* a1);
/*INTERNAL_LOCAL*/T0* r553non_void_no_dispatch_type(T553* C,T0* a1);
/*INTERNAL_LOCAL*/T6 r553is_equal(T553* C,T0* a1);
/*INTERNAL_LOCAL*/void r553typed(T553* C,T0* a1,T0* a2,T296 a3,T0* a4);
/*INTERNAL_LOCAL*/T0* r553specialize_2(T0* a1);
/*INTERNAL_LOCAL*/T0* r553static_simplify(T553* C);
/*INTERNAL_LOCAL*/T0* r553simplify(T553* C,T0* a1);
/*INTERNAL_LOCAL*/T0* r553collect(T553* C,T0* a1);
/*INTERNAL_LOCAL*/T0* r553specialize_thru(T0* a1,T0* a2,T0* a3);
/*INTERNAL_LOCAL*/void r553c_declare(T553* C,T0* a1,T6 a2);
/*INTERNAL_LOCAL*/void r553compile_to_c_with_internal_c_local_saving(T553* C,T0* a1);
/*INTERNAL_LOCAL*/T0* r553specialize_in(T0* a1);
/*INTERNAL_LOCAL*/void r553compile_to_c(T553* C,T0* a1);
/*INTERNAL_LOCAL*/T6 r553use_current(T0* a1);
/*INTERNAL_LOCAL*/void r553accept(T553* C,T0* a1);
/*INTERNAL_LOCAL*/T6 r553side_effect_free(T0* a1);
/*INTERNAL_LOCAL*/T0* r553declaration_type(T553* C);
/*INTERNAL_LOCAL*/T0* r553adapt_for(T553* C,T0* a1);
/*INTERNAL_LOCAL*/T0* r553resolve_in(T553* C,T0* a1);
/*INTERNAL_LOCAL*/T0* r553written_declaration_type_mark(T553* C);
/*INTERNAL_LOCAL*/T0* r553twin(T553* C);
/*INTERNAL_LOCAL*/T6 r553extra_bracket_flag(void);
/*INTERNAL_LOCAL*/void r553mapping_c_arg(T553* C,T0* a1);
/*INTERNAL_LOCAL*/T2 r553precedence(void);
/*INTERNAL_LOCAL*/T6 r553is_default_value(void);
/*RUN_FEATURE_8*/void r624set_result_type(T624* C);
/*RUN_FEATURE_8*/void r624mapping_c(T624* C);
/*RUN_FEATURE_8*/void r624define_c_signature(T624* C);
/*RUN_FEATURE_8*/void r624put_c_name_tag(T624* C);
/*RUN_FEATURE_8*/void r624std_compute_use_current(T624* C);
/*RUN_FEATURE_8*/void r624c_closing(T624* C);
/*RUN_FEATURE_8*/void r624c_opening(T624* C);
/*RUN_FEATURE_8*/T2 r624arg_count(T624* C);
/*RUN_FEATURE_8*/void r624default_mapping_arg(T624* C,T6 a1,T6 a2,T6 a3);
/*RUN_FEATURE_8*/void r624c_frame_descriptor(T624* C);
/*RUN_FEATURE_8*/void r624compute_use_current(T624* C);
/*RUN_FEATURE_8*/void r624c_define_opening(T624* C);
/*RUN_FEATURE_8*/void r624for(T624* C,T0* a1,T0* a2,T0* a3);
/*RUN_FEATURE_8*/void r624c_define(T624* C);
/*RUN_FEATURE_8*/T6 r624use_current(T624* C);
/*RUN_FEATURE_8*/T6 r624prepare_introspection2(T6 a1);
/*RUN_FEATURE_8*/void r624address_of_c_mapping(T624* C);
/*RUN_FEATURE_8*/void r624do_adapt(T624* C);
/*RUN_FEATURE_8*/T6 r624prepare_introspection(T6 a1);
/*RUN_FEATURE_8*/void r624c_initialize_frame_information(T624* C,T2 a1);
/*RUN_FEATURE_8*/T296 r624start_position(T624* C);
/*RUN_FEATURE_8*/void r624mapping_name_in(T624* C,T0* a1);
/*RUN_FEATURE_8*/void r624adapt(T624* C);
/*RUN_FEATURE_8*/T0* r624feature_stamp(T624* C);
/*RUN_FEATURE_8*/void r624default_mapping_function(T624* C);
/*RUN_FEATURE_8*/void r624c_define_closing(T624* C);
/*RUN_FEATURE_8*/void r624c_set_dump_stack_top(T624* C,T0* a1,T0* a2);
/*VOID_PROC_CALL*/T0* r383simplify_routine_body_first(T383* C,T0* a1,T0* a2);
/*VOID_PROC_CALL*/T0* r383specialize_2(T0* a1);
/*VOID_PROC_CALL*/T0* r383simplify(T383* C,T0* a1);
/*VOID_PROC_CALL*/T0* r383specialize_thru(T0* a1,T0* a2,T0* a3);
/*VOID_PROC_CALL*/void r383compile_to_c_with_internal_c_local_saving(T383* C,T0* a1);
/*VOID_PROC_CALL*/T0* r383specialize_in(T0* a1);
/*VOID_PROC_CALL*/void r383compile_to_c(T383* C,T0* a1);
/*VOID_PROC_CALL*/T6 r383use_current(T0* a1);
/*VOID_PROC_CALL*/T0* r383specialize_2_without_checks(T0* a1);
/*VOID_PROC_CALL*/void r383accept(T383* C,T0* a1);
/*VOID_PROC_CALL*/T6 r383side_effect_free(T0* a1);
/*VOID_PROC_CALL*/T0* r383adapt_for(T383* C,T0* a1);
/*VOID_PROC_CALL*/void r383make(T383* C,T296 a1,T0* a2,T0* a3);
/*VOID_PROC_CALL*/void r383safety_check(T383* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_1(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_0(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_fast_array_of_expression(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/T6 r87visit(T87* C,T0* a1,T0* a2);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call(T87* C,T0* a1,T0* a2);
extern T0*oBC87anonymous_feature_stack;
extern int fBC87anonymous_feature_stack;
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/T0* r87anonymous_feature_stack(void);
extern T0*oBC87type_stack;
extern int fBC87type_stack;
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/T0* r87type_stack(void);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_anonymous_feature(T87* C,T0* a1,T0* a2,T0* a3);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_effective_arg_list(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_local_var_list(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_native_java(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_native_c(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_native_c_plus_plus(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_native_plug_in(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_native_built_in(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_writable_attribute(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_deferred_procedure(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_deferred_function(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_external_procedure(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_external_function(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_e_function(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_once_procedure(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_once_function(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_e_procedure(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_e_loop(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_assignment(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_compound(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_precursor_instruction(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_e_debug(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_e_retry(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_create_instruction(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_proc_call_n(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_proc_call_1(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_proc_call_0(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_e_check(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_ifthen(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_assignment_attempt(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_void_proc_call(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_inspect_statement(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_agent_instruction(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_ifthenelse(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_no_invariant_wrapper(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_address_of(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_fake_target(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_assignment_test(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_agent_creation(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_n(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_and(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_div(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_or_else(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_times(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_int_rem(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_power(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_and_then(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_plus(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_xor(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_ge(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_gt(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_le(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_lt(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_int_div(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_or(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_minus(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_freeop(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_infix_implies(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_1_c(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_static_call_0_c(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_prefix_not(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_prefix_plus(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_prefix_freeop(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_prefix_minus(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_call_0_c(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_implicit_cast(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_void_call(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_expression_with_comment(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_open_operand(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_agent_expression(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_e_old(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_manifest_generic(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_built_in_eq_neq(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_manifest_tuple(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_precursor_expression(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_create_expression(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r87visit_fake_argument(T87* C,T0* a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/T6 r87can_be_dropped(T87* C,T0* a1,T0* a2,T0* a3);
/*INLINE_MEMO*/void r516clear(T516* C);
/*VOID_CALL*/void r475mapping_c_target(T475* C,T0* a1,T0* a2);
/*VOID_CALL*/void r475copy(T475* C,T0* a1);
/*VOID_CALL*/T0* r475non_void_no_dispatch_type(T0* a1);
/*VOID_CALL*/T6 r475is_equal(T475* C,T0* a1);
/*VOID_CALL*/T0* r475specialize_2(T0* a1);
/*VOID_CALL*/T0* r475static_simplify(T475* C);
/*VOID_CALL*/T0* r475simplify(T475* C,T0* a1);
/*VOID_CALL*/T0* r475collect(T475* C,T0* a1);
/*VOID_CALL*/T0* r475specialize_thru(T0* a1,T0* a2,T0* a3);
/*VOID_CALL*/void r475compile_to_c_with_internal_c_local_saving(T475* C,T0* a1);
/*VOID_CALL*/T0* r475specialize_in(T0* a1);
/*VOID_CALL*/void r475compile_to_c(T475* C,T0* a1);
/*VOID_CALL*/T6 r475use_current(T0* a1);
/*VOID_CALL*/void r475accept(T475* C,T0* a1);
/*VOID_CALL*/T6 r475side_effect_free(T0* a1);
/*VOID_CALL*/T0* r475declaration_type(T475* C);
/*VOID_CALL*/T0* r475adapt_for(T475* C,T0* a1);
/*VOID_CALL*/T0* r475resolve_in(T475* C,T0* a1);
/*VOID_CALL*/void r475make(T475* C,T296 a1,T0* a2,T0* a3);
/*VOID_CALL*/T0* r475written_declaration_type_mark(void);
/*VOID_CALL*/T0* r475twin(T475* C);
/*VOID_CALL*/T6 r475extra_bracket_flag(void);
/*VOID_CALL*/void r475mapping_c_arg(T475* C,T0* a1);
/*VOID_CALL*/T2 r475precedence(void);
/*VOID_CALL*/void r475safety_check(T475* C,T0* a1);
/*VOID_CALL*/T6 r475is_default_value(void);
extern T0*oBC28strings;
extern int fBC28strings;
/*MANIFEST_STRING_INSPECTOR*/T0* r627strings(void);
/*MANIFEST_STRING_INSPECTOR*/T0* r627simplify(T627* C,T0* a1,T0* a2,T0* a3);
/*MANIFEST_STRING_INSPECTOR*/void r627c_compile(T627* C,T0* a1,T0* a2);
/*MANIFEST_STRING_INSPECTOR*/void r627put_var(T0* a1);
/*MANIFEST_STRING_INSPECTOR*/T6 r627has_empty(T627* C);
/*MANIFEST_STRING_INSPECTOR*/T0* r627inline_inspect(T627* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T296 a6);
/*MANIFEST_STRING_INSPECTOR*/void r627make(T627* C,T0* a1);
/*STATIC_CALL_0_C*/T6 r445use_current(T445* C,T0* a1);
/*STATIC_CALL_0_C*/T6 r445side_effect_free(T445* C,T0* a1);
/*STATIC_CALL_0_C*/void r445copy(T445* C,T0* a1);
/*STATIC_CALL_0_C*/T0* r445declaration_type(T445* C);
/*STATIC_CALL_0_C*/T0* r445manifest_expression(T445* C,T0* a1);
/*STATIC_CALL_0_C*/T6 r445simplify_limit_reached(T445* C);
/*STATIC_CALL_0_C*/T0* r445adapt_for(T445* C,T0* a1);
/*STATIC_CALL_0_C*/T6 r445is_equal(T445* C,T0* a1);
/*STATIC_CALL_0_C*/T0* r445resolve_in(T445* C,T0* a1);
/*STATIC_CALL_0_C*/T0* r445current_or_twin_init(T445* C,T0* a1,T0* a2);
/*STATIC_CALL_0_C*/T0* r445extra_local_expanded(T445* C,T0* a1);
/*STATIC_CALL_0_C*/void r445function_and_argument_count_check(T445* C,T0* a1,T0* a2);
/*STATIC_CALL_0_C*/T0* r445written_declaration_type_mark(void);
/*STATIC_CALL_0_C*/T0* r445collect(T445* C,T0* a1);
/*STATIC_CALL_0_C*/void r445mapping_c_arg(T445* C,T0* a1);
extern T0*oBC28feature_accumulator;
extern int fBC28feature_accumulator;
/*STATIC_CALL_0_C*/T0* r445feature_accumulator(void);
/*STATIC_CALL_0_C*/T2 r445precedence(void);
/*STATIC_CALL_0_C*/T6 r445is_default_value(void);
extern T0*oBC28pretty_printer;
/*STATIC_CALL_0_C*/void r445mapping_c_target(T445* C,T0* a1,T0* a2);
/*STATIC_CALL_0_C*/T0* r445non_void_no_dispatch_type(T445* C,T0* a1);
/*STATIC_CALL_0_C*/void r445accept(T445* C,T0* a1);
/*STATIC_CALL_0_C*/T0* r445echo(void);
extern T0*oBC390use_current_stack;
extern int fBC390use_current_stack;
/*STATIC_CALL_0_C*/T0* r445use_current_stack(void);
/*STATIC_CALL_0_C*/T0* r445arguments(void);
/*STATIC_CALL_0_C*/void r445set_target(T445* C,T0* a1);
/*STATIC_CALL_0_C*/T0* r445call_support_collect(T445* C,T0* a1);
/*STATIC_CALL_0_C*/void r445make(T445* C,T0* a1,T0* a2);
/*STATIC_CALL_0_C*/void r445standard_check_export_and_obsolete_calls(T445* C,T0* a1,T0* a2,T0* a3);
/*STATIC_CALL_0_C*/T0* r445twin(T445* C);
/*STATIC_CALL_0_C*/void r445set_feature_stamp(T445* C,T0* a1);
/*STATIC_CALL_0_C*/void r445pretty(T445* C,T2 a1);
/*STATIC_CALL_0_C*/T296 r445start_position(T445* C);
/*STATIC_CALL_0_C*/T0* r445inline_with(T445* C,T0* a1);
/*STATIC_CALL_0_C*/void r445bracketed_pretty(T445* C,T2 a1);
/*STATIC_CALL_0_C*/void r445pretty_target(T445* C,T2 a1);
/*STATIC_CALL_0_C*/void r445safety_check(T445* C,T0* a1);
/*STATIC_CALL_0_C*/T0* r445specialize_2(T445* C,T0* a1);
/*STATIC_CALL_0_C*/T0* r445simplify(T445* C,T0* a1);
/*STATIC_CALL_0_C*/T0* r445specialize_thru(T445* C,T0* a1,T0* a2,T0* a3);
/*STATIC_CALL_0_C*/T0* r445static_simplify(T445* C);
/*STATIC_CALL_0_C*/T0* r445run_feature_for(T445* C,T0* a1);
/*STATIC_CALL_0_C*/void r445compile_to_c_with_internal_c_local_saving(T445* C,T0* a1);
/*STATIC_CALL_0_C*/T0* r445specialize_in(T445* C,T0* a1);
/*STATIC_CALL_0_C*/void r445compile_to_c(T445* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/void r556copy(T556* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/T0* r556simplify_routine_body_first(T556* C,T0* a1,T0* a2);
extern T0*oBC28string_aliaser;
/*RAW_CREATE_INSTRUCTION*/void r556init(T556* C,T0* a1,T0* a2,T0* a3);
/*RAW_CREATE_INSTRUCTION*/T0* r556specialize_2(T556* C,T0* a1);
extern T0*oBC28any_default_create_fs;
extern int fBC28any_default_create_fs;
/*RAW_CREATE_INSTRUCTION*/T0* r556any_default_create_fs(void);
/*RAW_CREATE_INSTRUCTION*/T0* r556simplify(T556* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/void r556collect(T556* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/T0* r556current_or_twin_init(T556* C,T0* a1,T0* a2,T0* a3);
/*RAW_CREATE_INSTRUCTION*/T0* r556specialize_thru(T556* C,T0* a1,T0* a2,T0* a3);
/*RAW_CREATE_INSTRUCTION*/T0* r556arguments(T556* C);
/*RAW_CREATE_INSTRUCTION*/void r556compile_to_c_with_internal_c_local_saving(T556* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/T0* r556specialize_in(T556* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/void r556compile_to_c(T556* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/T6 r556use_current(T556* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/T0* r556specialize_2_without_checks(T556* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/void r556accept(T556* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/T6 r556side_effect_free(T0* a1);
/*RAW_CREATE_INSTRUCTION*/T0* r556adapt_for(T556* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/void r556make(T556* C,T296 a1,T0* a2,T0* a3);
/*RAW_CREATE_INSTRUCTION*/void r556create_instruction_make(T556* C,T296 a1,T0* a2,T0* a3,T0* a4);
/*RAW_CREATE_INSTRUCTION*/T0* r556twin(T556* C);
extern T0*oBC28gc_handler;
/*RAW_CREATE_INSTRUCTION*/void r556specialize_2_checks(T556* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/T0* r556created_type(T556* C,T0* a1);
extern T0*oBC28default_create_name;
extern int fBC28default_create_name;
/*RAW_CREATE_INSTRUCTION*/T0* r556default_create_name(void);
/*RAW_CREATE_INSTRUCTION*/T0* r556creation_procedure(T556* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/void r556safety_check(T556* C,T0* a1);
/*RAW_CREATE_INSTRUCTION*/void r556typed_internals(T556* C,T296 a1,T0* a2);
/*RAW_CREATE_INSTRUCTION*/void r556make_specialized(T556* C,T296 a1,T0* a2,T0* a3,T0* a4);
/*GENERATOR_GENERATING_TYPE*/void r457mapping_c_target(T457* C,T0* a1,T0* a2);
/*GENERATOR_GENERATING_TYPE*/void r457standard_mapping_c_target(T457* C,T0* a1,T0* a2);
/*GENERATOR_GENERATING_TYPE*/void r457copy(T457* C,T0* a1);
/*GENERATOR_GENERATING_TYPE*/T0* r457non_void_no_dispatch_type(T0* a1);
/*GENERATOR_GENERATING_TYPE*/T6 r457is_equal(T457* C,T0* a1);
/*GENERATOR_GENERATING_TYPE*/T0* r457specialize_2(T457* C,T0* a1);
/*GENERATOR_GENERATING_TYPE*/T0* r457static_simplify(T457* C);
/*GENERATOR_GENERATING_TYPE*/T0* r457simplify(T457* C,T0* a1);
/*GENERATOR_GENERATING_TYPE*/void r457make_generating_type(T457* C,T296 a1,T0* a2);
/*GENERATOR_GENERATING_TYPE*/T0* r457collect(T457* C,T0* a1);
/*GENERATOR_GENERATING_TYPE*/void r457make_generator(T457* C,T296 a1,T0* a2);
/*GENERATOR_GENERATING_TYPE*/T0* r457specialize_thru(T457* C,T0* a1,T0* a2,T0* a3);
/*GENERATOR_GENERATING_TYPE*/void r457compile_to_c_with_internal_c_local_saving(T457* C,T0* a1);
/*GENERATOR_GENERATING_TYPE*/T0* r457specialize_in(T457* C,T0* a1);
/*GENERATOR_GENERATING_TYPE*/void r457compile_to_c(T457* C,T0* a1);
/*GENERATOR_GENERATING_TYPE*/T6 r457use_current(T0* a1);
/*GENERATOR_GENERATING_TYPE*/void r457accept(T457* C,T0* a1);
/*GENERATOR_GENERATING_TYPE*/T6 r457side_effect_free(T0* a1);
/*GENERATOR_GENERATING_TYPE*/T0* r457declaration_type(void);
/*GENERATOR_GENERATING_TYPE*/T0* r457adapt_for(T457* C,T0* a1);
/*GENERATOR_GENERATING_TYPE*/T0* r457resolve_in(T0* a1);
/*GENERATOR_GENERATING_TYPE*/T0* r457written_declaration_type_mark(void);
/*GENERATOR_GENERATING_TYPE*/T0* r457twin(T457* C);
/*GENERATOR_GENERATING_TYPE*/void r457mapping_c_arg(T457* C,T0* a1);
/*GENERATOR_GENERATING_TYPE*/T2 r457precedence(void);
/*GENERATOR_GENERATING_TYPE*/T6 r457is_default_value(void);
/*EXCEPTIONS_HANDLER*/void r226se_evobt(T226* C);
/*EXCEPTIONS_HANDLER*/void r226customize_c_runtime(T226* C);
/*EXCEPTIONS_HANDLER*/void r226bad_inspect_value(T226* C,T296 a1);
/*EXCEPTIONS_HANDLER*/void r226initialize_runtime(T226* C);
/*RUN_FEATURE_7*/T6 r623use_current(T623* C);
/*RUN_FEATURE_7*/void r623default_mapping_arg(T623* C,T6 a1,T6 a2,T6 a3);
/*RUN_FEATURE_7*/void r623compute_use_current(T623* C);
/*RUN_FEATURE_7*/void r623c_define_opening(T623* C);
/*RUN_FEATURE_7*/void r623for(T623* C,T0* a1,T0* a2,T0* a3);
/*RUN_FEATURE_7*/T6 r623prepare_introspection2(T6 a1);
/*RUN_FEATURE_7*/void r623address_of_c_mapping(T623* C);
/*RUN_FEATURE_7*/T0* r623feature_stamp(T623* C);
/*RUN_FEATURE_7*/void r623do_adapt(T623* C);
/*RUN_FEATURE_7*/T6 r623prepare_introspection(T6 a1);
/*RUN_FEATURE_7*/void r623c_initialize_frame_information(T623* C,T2 a1);
/*RUN_FEATURE_7*/void r623c_define(T623* C);
/*RUN_FEATURE_7*/void r623mapping_name_in(T623* C,T0* a1);
/*RUN_FEATURE_7*/void r623adapt(T623* C);
/*RUN_FEATURE_7*/void r623default_mapping_function(T623* C);
/*RUN_FEATURE_7*/void r623c_define_closing(T623* C);
/*RUN_FEATURE_7*/void r623c_opening(T623* C);
/*RUN_FEATURE_7*/void r623c_frame_descriptor(T623* C);
/*RUN_FEATURE_7*/T296 r623start_position(T623* C);
/*RUN_FEATURE_7*/T0* r623result_type(void);
/*RUN_FEATURE_7*/void r623c_set_dump_stack_top(T623* C,T0* a1,T0* a2);
/*RUN_FEATURE_7*/void r623default_mapping_procedure(T623* C);
/*RUN_FEATURE_7*/void r623mapping_c(T623* C);
/*RUN_FEATURE_7*/T2 r623arg_count(T623* C);
/*RUN_FEATURE_7*/void r623define_c_signature(T623* C);
/*RUN_FEATURE_7*/void r623put_c_name_tag(T623* C);
/*RUN_FEATURE_7*/void r623std_compute_use_current(T623* C);
/*INTERNAL_LOCAL_LIST*/T0* r615name(T0* a1);
/*INTERNAL_LOCAL_LIST*/T0* r615typed(T615* C,T0* a1,T0* a2,T296 a3,T0* a4);
/*INTERNAL_LOCAL_LIST*/void r615collect(T615* C,T0* a1);
/*INTERNAL_LOCAL_LIST*/void r615c_declare(T615* C,T0* a1,T6 a2);
/*INTERNAL_LOCAL_LIST*/void r615make(T615* C);
/*RUN_FEATURE_9*/void r625set_result_type(T625* C);
/*RUN_FEATURE_9*/T0* r625routine_body(void);
/*RUN_FEATURE_9*/void r625mapping_c(T625* C);
/*RUN_FEATURE_9*/void r625define_c_signature(T625* C);
/*RUN_FEATURE_9*/void r625put_c_name_tag(T625* C);
/*RUN_FEATURE_9*/void r625default_mapping_arg(T625* C,T6 a1,T6 a2,T6 a3);
/*RUN_FEATURE_9*/void r625c_frame_descriptor(T625* C);
/*RUN_FEATURE_9*/void r625c_define_opening(T625* C);
/*RUN_FEATURE_9*/void r625for(T625* C,T0* a1,T0* a2,T0* a3);
/*RUN_FEATURE_9*/void r625c_define(T625* C);
/*RUN_FEATURE_9*/T6 r625use_current(T625* C);
/*RUN_FEATURE_9*/T6 r625prepare_introspection2(T6 a1);
/*RUN_FEATURE_9*/void r625address_of_c_define(T625* C,T0* a1);
/*RUN_FEATURE_9*/void r625do_adapt(T625* C);
/*RUN_FEATURE_9*/T6 r625prepare_introspection(T6 a1);
/*RUN_FEATURE_9*/void r625c_initialize_frame_information(T625* C,T2 a1);
/*RUN_FEATURE_9*/T296 r625start_position(T625* C);
/*RUN_FEATURE_9*/void r625mapping_name_in(T625* C,T0* a1);
/*RUN_FEATURE_9*/void r625adapt(T625* C);
/*RUN_FEATURE_9*/T0* r625feature_stamp(T625* C);
/*RUN_FEATURE_9*/void r625default_mapping_function(T625* C);
/*RUN_FEATURE_9*/void r625c_define_closing(T625* C);
/*RUN_FEATURE_9*/void r625c_set_dump_stack_top(T625* C,T0* a1,T0* a2);
/*RUN_FEATURE_9*/void r625default_mapping_procedure(T625* C);
/*RUN_FEATURE_9*/T0* r625local_vars(void);
/*RUN_FEATURE_2*/void r493set_result_type(T493* C);
/*RUN_FEATURE_2*/T0* r493routine_body(void);
/*RUN_FEATURE_2*/void r493mapping_c(T493* C);
/*RUN_FEATURE_2*/void r493define_c_signature(T493* C);
/*RUN_FEATURE_2*/void r493put_c_name_tag(T493* C);
/*RUN_FEATURE_2*/void r493put_c_field_name(T493* C);
/*RUN_FEATURE_2*/T6 r493need_c_function(T493* C);
/*RUN_FEATURE_2*/void r493default_mapping_arg(T493* C,T6 a1,T6 a2,T6 a3);
/*RUN_FEATURE_2*/void r493mapping_c_inside_introspect(T493* C);
/*RUN_FEATURE_2*/void r493c_frame_descriptor(T493* C);
/*RUN_FEATURE_2*/T0* r493arguments(void);
/*RUN_FEATURE_2*/void r493c_define_opening(T493* C);
/*RUN_FEATURE_2*/void r493for(T493* C,T0* a1,T0* a2,T0* a3);
/*RUN_FEATURE_2*/void r493c_define(T493* C);
/*RUN_FEATURE_2*/T6 r493use_current(T493* C);
/*RUN_FEATURE_2*/T6 r493prepare_introspection2(T493* C,T6 a1);
/*RUN_FEATURE_2*/void r493address_of_c_mapping(T493* C);
/*RUN_FEATURE_2*/void r493do_adapt(T493* C);
/*RUN_FEATURE_2*/T6 r493prepare_introspection(T493* C,T6 a1);
/*RUN_FEATURE_2*/void r493c_initialize_frame_information(T493* C,T2 a1);
/*RUN_FEATURE_2*/T296 r493start_position(T493* C);
/*RUN_FEATURE_2*/void r493mapping_name_in(T493* C,T0* a1);
/*RUN_FEATURE_2*/void r493adapt(T493* C);
/*RUN_FEATURE_2*/T0* r493feature_stamp(T493* C);
/*RUN_FEATURE_2*/void r493default_mapping_function(T493* C);
/*RUN_FEATURE_2*/void r493c_define_closing(T493* C);
/*RUN_FEATURE_2*/void r493c_set_dump_stack_top(T493* C,T0* a1,T0* a2);
/*RUN_FEATURE_2*/T0* r493local_vars(void);
/*UTF8_PARSER*/void r597decode(T597* C,T0* a1,T0* a2);
/*NULL_POINTER*/void r441mapping_c_target(T0* a1,T0* a2);
/*NULL_POINTER*/void r441copy(T441* C,T0* a1);
/*NULL_POINTER*/T0* r441non_void_no_dispatch_type(T0* a1);
/*NULL_POINTER*/T6 r441is_equal(T441* C,T0* a1);
/*NULL_POINTER*/T0* r441specialize_2(T0* a1);
/*NULL_POINTER*/T0* r441static_simplify(T441* C);
/*NULL_POINTER*/T0* r441simplify(T441* C,T0* a1);
/*NULL_POINTER*/T0* r441collect(T0* a1);
/*NULL_POINTER*/T0* r441specialize_thru(T0* a1,T0* a2,T0* a3);
/*NULL_POINTER*/void r441compile_to_c_with_internal_c_local_saving(T0* a1);
/*NULL_POINTER*/T0* r441specialize_in(T0* a1);
/*NULL_POINTER*/void r441compile_to_c(T0* a1);
/*NULL_POINTER*/T6 r441use_current(T0* a1);
/*NULL_POINTER*/void r441accept(T441* C,T0* a1);
/*NULL_POINTER*/T6 r441side_effect_free(T0* a1);
extern T0*oBC441declaration_type;
extern int fBC441declaration_type;
/*NULL_POINTER*/T0* r441declaration_type(void);
/*NULL_POINTER*/T0* r441adapt_for(T441* C,T0* a1);
/*NULL_POINTER*/T0* r441resolve_in(T0* a1);
/*NULL_POINTER*/void r441make(T441* C,T296 a1,T0* a2);
/*NULL_POINTER*/T0* r441written_declaration_type_mark(void);
/*NULL_POINTER*/T0* r441twin(T441* C);
/*NULL_POINTER*/T6 r441extra_bracket_flag(void);
/*NULL_POINTER*/void r441mapping_c_arg(T0* a1);
/*NULL_POINTER*/T2 r441precedence(void);
/*NULL_POINTER*/T6 r441is_default_value(void);
/*AGENT_INSTRUCTION*/void r381copy(T381* C,T0* a1);
/*AGENT_INSTRUCTION*/T0* r381simplify_routine_body_first(T381* C,T0* a1,T0* a2);
/*AGENT_INSTRUCTION*/void r381agent_launcher_collect(T381* C,T0* a1);
/*AGENT_INSTRUCTION*/void r381init(T381* C,T0* a1,T0* a2);
/*AGENT_INSTRUCTION*/T0* r381specialize_2(T381* C,T0* a1);
/*AGENT_INSTRUCTION*/T0* r381simplify(T381* C,T0* a1);
/*AGENT_INSTRUCTION*/void r381collect(T381* C,T0* a1);
/*AGENT_INSTRUCTION*/T0* r381current_or_twin_init(T381* C,T0* a1,T0* a2);
/*AGENT_INSTRUCTION*/T0* r381specialize_thru(T381* C,T0* a1,T0* a2,T0* a3);
/*AGENT_INSTRUCTION*/void r381specialize_2_check(T381* C,T0* a1);
/*AGENT_INSTRUCTION*/void r381compile_to_c_with_internal_c_local_saving(T381* C,T0* a1);
/*AGENT_INSTRUCTION*/void r381compile_to_c_void_call(T381* C,T0* a1,T296 a2,T0* a3);
/*AGENT_INSTRUCTION*/T0* r381specialize_in(T0* a1);
/*AGENT_INSTRUCTION*/void r381compile_to_c(T381* C,T0* a1);
/*AGENT_INSTRUCTION*/T6 r381use_current(T381* C,T0* a1);
/*AGENT_INSTRUCTION*/T0* r381specialize_2_without_checks(T381* C,T0* a1);
/*AGENT_INSTRUCTION*/void r381accept(T381* C,T0* a1);
/*AGENT_INSTRUCTION*/T6 r381side_effect_free(T0* a1);
/*AGENT_INSTRUCTION*/T0* r381adapt_for(T381* C,T0* a1);
extern T0*oBC28agent_pool;
/*AGENT_INSTRUCTION*/void r381make(T381* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*AGENT_INSTRUCTION*/T0* r381twin(T381* C);
/*AGENT_INSTRUCTION*/T296 r381start_position(T381* C);
/*AGENT_INSTRUCTION*/void r381safety_check(T381* C,T0* a1);
/*ADDRESS_OF_POOL*/void r221c_define(void);
/*ADDRESS_OF_POOL*/void r221register_for(T0* a1);
extern T0*oBC221caller_memory;
extern int fBC221caller_memory;
/*ADDRESS_OF_POOL*/T0* r221caller_memory(void);
extern T0*oBC221registered;
extern int fBC221registered;
/*ADDRESS_OF_POOL*/T0* r221registered(void);
/*IMPLICIT_CAST*/void r470pretty_target(T470* C,T2 a1);
/*IMPLICIT_CAST*/void r470mapping_c_target(T470* C,T0* a1,T0* a2);
/*IMPLICIT_CAST*/void r470copy(T470* C,T0* a1);
/*IMPLICIT_CAST*/T0* r470non_void_no_dispatch_type(T0* a1);
/*IMPLICIT_CAST*/T6 r470is_implicit_current(void);
/*IMPLICIT_CAST*/T6 r470is_equal(T470* C,T0* a1);
/*IMPLICIT_CAST*/T6 r470is_current(void);
/*IMPLICIT_CAST*/T0* r470specialize_2(T470* C,T0* a1);
/*IMPLICIT_CAST*/T0* r470static_simplify(T470* C);
/*IMPLICIT_CAST*/T0* r470simplify(T470* C,T0* a1);
/*IMPLICIT_CAST*/T0* r470collect(T470* C,T0* a1);
/*IMPLICIT_CAST*/T0* r470specialize_thru(T470* C,T0* a1,T0* a2,T0* a3);
/*IMPLICIT_CAST*/void r470compile_to_c_with_internal_c_local_saving(T470* C,T0* a1);
/*IMPLICIT_CAST*/T0* r470specialize_in(T0* a1);
/*IMPLICIT_CAST*/void r470compile_to_c(T470* C,T0* a1);
/*IMPLICIT_CAST*/T6 r470use_current(T470* C,T0* a1);
/*IMPLICIT_CAST*/void r470accept(T470* C,T0* a1);
/*IMPLICIT_CAST*/T6 r470side_effect_free(T470* C,T0* a1);
/*IMPLICIT_CAST*/T0* r470declaration_type(T470* C);
/*IMPLICIT_CAST*/T0* r470adapt_for(T470* C,T0* a1);
/*IMPLICIT_CAST*/T0* r470resolve_in(T470* C,T0* a1);
/*IMPLICIT_CAST*/T6 r470is_manifest_string(T470* C);
/*IMPLICIT_CAST*/void r470make(T470* C,T0* a1,T0* a2,T0* a3);
/*IMPLICIT_CAST*/T0* r470written_declaration_type_mark(void);
/*IMPLICIT_CAST*/T0* r470twin(T470* C);
/*IMPLICIT_CAST*/void r470pretty(T470* C,T2 a1);
/*IMPLICIT_CAST*/T6 r470is_void(T470* C);
/*IMPLICIT_CAST*/T296 r470start_position(T470* C);
/*IMPLICIT_CAST*/T6 r470is_result(T470* C);
/*IMPLICIT_CAST*/T6 r470extra_bracket_flag(T470* C);
/*IMPLICIT_CAST*/void r470mapping_c_arg(T470* C,T0* a1);
/*IMPLICIT_CAST*/T2 r470precedence(T470* C);
/*IMPLICIT_CAST*/void r470safety_check(T470* C,T0* a1);
/*IMPLICIT_CAST*/void r470bracketed_pretty(T470* C,T2 a1);
/*IMPLICIT_CAST*/T6 r470is_static(T470* C);
/*IMPLICIT_CAST*/T6 r470is_default_value(void);
/*AGENT_EXPRESSION*/T6 r412use_current(T412* C,T0* a1);
/*AGENT_EXPRESSION*/T6 r412side_effect_free(T0* a1);
/*AGENT_EXPRESSION*/void r412copy(T412* C,T0* a1);
/*AGENT_EXPRESSION*/T0* r412declaration_type(T412* C);
/*AGENT_EXPRESSION*/T0* r412adapt_for(T412* C,T0* a1);
/*AGENT_EXPRESSION*/T0* r412resolve_in(T412* C,T0* a1);
/*AGENT_EXPRESSION*/T6 r412is_equal(T412* C,T0* a1);
/*AGENT_EXPRESSION*/void r412agent_launcher_collect(T412* C,T0* a1);
/*AGENT_EXPRESSION*/T0* r412current_or_twin_init(T412* C,T0* a1,T0* a2);
/*AGENT_EXPRESSION*/T0* r412written_declaration_type_mark(void);
/*AGENT_EXPRESSION*/T0* r412collect(T412* C,T0* a1);
/*AGENT_EXPRESSION*/void r412specialize_2_check(T412* C,T0* a1);
/*AGENT_EXPRESSION*/void r412compile_to_c_void_call(T412* C,T0* a1,T296 a2,T0* a3);
/*AGENT_EXPRESSION*/void r412mapping_c_arg(T412* C,T0* a1);
/*AGENT_EXPRESSION*/T2 r412precedence(void);
/*AGENT_EXPRESSION*/T6 r412is_default_value(void);
/*AGENT_EXPRESSION*/void r412mapping_c_target(T412* C,T0* a1,T0* a2);
/*AGENT_EXPRESSION*/void r412standard_mapping_c_target(T412* C,T0* a1,T0* a2);
/*AGENT_EXPRESSION*/T0* r412non_void_no_dispatch_type(T0* a1);
/*AGENT_EXPRESSION*/void r412accept(T412* C,T0* a1);
/*AGENT_EXPRESSION*/void r412make(T412* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*AGENT_EXPRESSION*/T0* r412twin(T412* C);
/*AGENT_EXPRESSION*/void r412pretty(T412* C,T2 a1);
/*AGENT_EXPRESSION*/T296 r412start_position(T412* C);
/*AGENT_EXPRESSION*/void r412init(T412* C,T0* a1,T0* a2);
/*AGENT_EXPRESSION*/void r412bracketed_pretty(T412* C,T2 a1);
/*AGENT_EXPRESSION*/void r412pretty_target(T412* C,T2 a1);
/*AGENT_EXPRESSION*/void r412safety_check(T412* C,T0* a1);
/*AGENT_EXPRESSION*/T0* r412specialize_2(T412* C,T0* a1);
/*AGENT_EXPRESSION*/T0* r412simplify(T412* C,T0* a1);
/*AGENT_EXPRESSION*/T0* r412specialize_thru(T412* C,T0* a1,T0* a2,T0* a3);
/*AGENT_EXPRESSION*/T0* r412static_simplify(T412* C);
/*AGENT_EXPRESSION*/void r412compile_to_c_with_internal_c_local_saving(T412* C,T0* a1);
/*AGENT_EXPRESSION*/T0* r412specialize_in(T0* a1);
/*AGENT_EXPRESSION*/void r412compile_to_c(T412* C,T0* a1);
/*PROCESS_GROUP_WIN32*/void r593unregister(T593* C,T0* a1);
/*PROCESS_GROUP_WIN32*/void r593make(T593* C);
/*PROCESS_GROUP_WIN32*/void r593register(T593* C,T0* a1);
/*PROCESS_GROUP_POSIX*/void r591make(T591* C);
/*PROCESS_GROUP_POSIX*/void r591unregister(T591* C,T0* a1);
/*PROCESS_GROUP_POSIX*/void r591register(T591* C,T0* a1);
/*PROCESS_WIN32*/void r596do_cleanup(T596* C);
/*PROCESS_WIN32*/void r596execute_command_line(T596* C,T0* a1,T6 a2);
/*PROCESS_WIN32*/void r596do_execute(T596* C,T8 a1,T6 a2);
/*PROCESS_WIN32*/void r596set_direct_output(T596* C,T6 a1);
/*PROCESS_WIN32*/T6 r596is_finished(T596* C);
/*PROCESS_WIN32*/T2 r596handle(T596* C);
/*PROCESS_WIN32*/void r596cleanup_streams(T596* C);
/*PROCESS_WIN32*/void r596set_direct_error(T596* C,T6 a1);
/*PROCESS_WIN32*/void r596dispose(T596* C);
/*PROCESS_WIN32*/void r596set_group(T596* C,T0* a1);
/*PROCESS_WIN32*/void r596set_direct_input(T596* C,T6 a1);
/*PROCESS_WIN32*/void r596wait(T596* C);
/*PROCESS_WIN32*/void r596make(T596* C);
/*PROCESS_NONE*/void r595execute_command_line(T595* C,T0* a1,T6 a2);
/*PROCESS_NONE*/void r595set_direct_output(T595* C,T6 a1);
/*PROCESS_NONE*/T0* r595output(void);
/*PROCESS_NONE*/void r595set_direct_error(T595* C,T6 a1);
/*PROCESS_NONE*/void r595set_group(T595* C,T0* a1);
/*PROCESS_NONE*/void r595set_direct_input(T595* C,T6 a1);
/*PROCESS_NONE*/void r595make(T595* C);
/*PROCESS_POSIX*/void r594do_cleanup(T594* C);
/*PROCESS_POSIX*/void r594execute_command_line(T594* C,T0* a1,T6 a2);
/*PROCESS_POSIX*/void r594do_execute(T594* C,T8 a1,T8 a2,T6 a3,T8 a4);
/*PROCESS_POSIX*/void r594set_direct_output(T594* C,T6 a1);
/*PROCESS_POSIX*/T6 r594is_finished(T594* C);
/*PROCESS_POSIX*/void r594cleanup_streams(T594* C);
/*PROCESS_POSIX*/void r594set_direct_error(T594* C,T6 a1);
/*PROCESS_POSIX*/void r594dispose(T594* C);
/*PROCESS_POSIX*/void r594set_group(T594* C,T0* a1);
/*PROCESS_POSIX*/void r594set_direct_input(T594* C,T6 a1);
/*PROCESS_POSIX*/void r594wait(T594* C);
/*PROCESS_POSIX*/T2 r594id(T594* C);
/*PROCESS_POSIX*/void r594make(T594* C);
/*STRING_WEAK_ARRAY*/T0* r1156item(T1156* C);
/*STRING_WEAK_ARRAY*/T2 r1156next(T1156* C,T2 a1);
/*STRING_WEAK_ARRAY*/void r1156make(T1156* C);
/*STRING_WEAK_ARRAY*/void r1156recycle(T1156* C,T0* a1);
/*STRING_WEAK_ARRAY*/T0* r1156item_at(T1156* C,T2 a1);
/*STRING_WEAK_ARRAY*/T0* r1156best_fit(T1156* C,T2 a1);
/*STRING_WEAK_ARRAY*/T0* r1156new_twin(T1156* C,T0* a1);
/*STRING_WEAK_ARRAY*/T0* r1156new(T1156* C);
/*PROCESS_FACTORY*/void r314not_yet_implemented(T314* C);
/*PROCESS_FACTORY*/T0* r314create_process(T314* C);
/*PROCESS_FACTORY*/void r314crash(T314* C);
extern T0*oBC314default_group;
extern int fBC314default_group;
/*PROCESS_FACTORY*/T0* r314default_group(T314* C);
/*PROCESS_FACTORY*/T0* r314create_group(T314* C);
/*PROCESS_FACTORY*/void r314default_create(T314* C);
extern T0*oBC13std_error;
T618*create618make(T296 a1,T0* a2,T0* a3);
/*REQUIRE_ITEM*/void r618copy(T618* C,T0* a1);
/*REQUIRE_ITEM*/void r618non_upper_most_compile_to_c(T618* C,T0* a1);
/*REQUIRE_ITEM*/T0* r618specialize_2(T618* C,T0* a1);
/*REQUIRE_ITEM*/void r618compile_to_c_(T618* C,T0* a1,T6 a2,T6 a3);
/*REQUIRE_ITEM*/void r618collect(T618* C,T0* a1);
/*REQUIRE_ITEM*/T6 r618is_always_true(T618* C);
/*REQUIRE_ITEM*/T0* r618specialize_thru(T618* C,T0* a1,T0* a2,T0* a3);
/*REQUIRE_ITEM*/void r618c_compile_assertion(T618* C,T0* a1,T0* a2);
/*REQUIRE_ITEM*/T0* r618specialize_in(T618* C,T0* a1);
/*REQUIRE_ITEM*/void r618compile_to_c(T618* C,T0* a1);
/*REQUIRE_ITEM*/T6 r618use_current(T618* C,T0* a1);
/*REQUIRE_ITEM*/T6 r618side_effect_free(T618* C,T0* a1);
/*REQUIRE_ITEM*/T0* r618adapt_for(T618* C,T0* a1);
/*REQUIRE_ITEM*/void r618make(T618* C,T296 a1,T0* a2,T0* a3);
/*REQUIRE_ITEM*/T0* r618twin(T618* C);
/*RENAME_LIST*/T0* r324name_in_child(T324* C,T0* a1);
/*RENAME_LIST*/T0* r324name_in_parent(T324* C,T0* a1);
/*RENAME_LIST*/T2 r324count(T324* C);
/*RENAME_LIST*/void r324initialize_and_check_level_1(T324* C);
/*RENAME_LIST*/void r324make(T324* C,T0* a1);
/*RENAME_LIST*/T6 r324is_target_of_rename(T324* C,T0* a1);
/*RENAME_LIST*/void r324check_level_2(T324* C,T0* a1);
/*CHECK_INVARIANT*/void r628copy(T628* C,T0* a1);
/*CHECK_INVARIANT*/T0* r628specialize_2(T628* C,T0* a1);
/*CHECK_INVARIANT*/void r628compile_to_c_(T628* C,T0* a1,T6 a2,T6 a3);
/*CHECK_INVARIANT*/void r628collect(T628* C,T0* a1);
/*CHECK_INVARIANT*/T6 r628is_always_true(T628* C);
/*CHECK_INVARIANT*/T0* r628specialize_thru(T628* C,T0* a1,T0* a2,T0* a3);
/*CHECK_INVARIANT*/void r628c_compile_assertion(T628* C,T0* a1,T0* a2);
/*CHECK_INVARIANT*/T0* r628specialize_in(T628* C,T0* a1);
/*CHECK_INVARIANT*/void r628compile_to_c(T628* C,T0* a1);
/*CHECK_INVARIANT*/T6 r628use_current(T628* C,T0* a1);
/*CHECK_INVARIANT*/T0* r628adapt_for(T628* C,T0* a1);
/*CHECK_INVARIANT*/void r628make(T628* C,T296 a1,T0* a2,T0* a3);
/*CHECK_INVARIANT*/T0* r628twin(T628* C);
/*CHECK_INVARIANT*/void r628safety_check(T628* C,T0* a1);
/*WHEN_ITEM_1*/void r555compute_values(T555* C,T0* a1);
/*WHEN_ITEM_1*/void r555copy(T555* C,T0* a1);
/*WHEN_ITEM_1*/T0* r555specialize_2_character(T555* C,T0* a1);
/*WHEN_ITEM_1*/T6 r555validity_check_continued(T555* C,T0* a1);
/*WHEN_ITEM_1*/void r555validity_check(T555* C,T0* a1);
/*WHEN_ITEM_1*/void r555collect(T555* C,T0* a1);
/*WHEN_ITEM_1*/T0* r555current_or_twin_init(T555* C,T0* a1);
/*WHEN_ITEM_1*/T0* r555specialize_thru(T555* C,T0* a1,T0* a2,T0* a3);
/*WHEN_ITEM_1*/T0* r555specialize_in(T555* C,T0* a1);
/*WHEN_ITEM_1*/T2 r555character_check(T0* a1,T0* a2);
/*WHEN_ITEM_1*/void r555validity_check_continued_(T555* C,T0* a1);
/*WHEN_ITEM_1*/T0* r555manifest_expression_check(T0* a1,T0* a2);
/*WHEN_ITEM_1*/void r555explain_fatal_error(T0* a1,T0* a2);
/*WHEN_ITEM_1*/void r555validity_check_continued_when_item_2(T555* C,T0* a1);
/*WHEN_ITEM_1*/void r555validity_check_continued_when_item_1(T555* C,T0* a1);
/*WHEN_ITEM_1*/T2 r555integer_check(T0* a1,T0* a2);
/*WHEN_ITEM_1*/T0* r555adapt_for(T555* C,T0* a1);
/*WHEN_ITEM_1*/void r555set_expression_value_integer(T555* C);
/*WHEN_ITEM_1*/T0* r555specialize_2_string(T555* C,T0* a1);
/*WHEN_ITEM_1*/void r555set_expression_value_character(T555* C);
/*WHEN_ITEM_1*/void r555set_manifest_expression(T555* C,T0* a1);
/*WHEN_ITEM_1*/void r555make(T555* C,T0* a1);
/*WHEN_ITEM_1*/T6 r555match_value(T555* C,T2 a1);
/*WHEN_ITEM_1*/T0* r555twin(T555* C);
/*WHEN_ITEM_1*/T0* r555specialize_2_integer(T555* C,T0* a1);
/*WHEN_ITEM_1*/void r555force_internal_character_values(T555* C,T0* a1,T0* a2);
/*WHEN_ITEM_1*/T296 r555start_position(T555* C);
/*WHEN_ITEM_1*/void r555force_internal_integer_values(T555* C,T0* a1,T0* a2);
/*WHEN_ITEM_2*/void r631compute_values(T631* C,T0* a1);
/*WHEN_ITEM_2*/void r631copy(T631* C,T0* a1);
/*WHEN_ITEM_2*/void r631lower_upper_value_check(T631* C);
/*WHEN_ITEM_2*/void r631set_values_integer(T631* C);
/*WHEN_ITEM_2*/void r631set_lower_upper_manifest_expression(T631* C,T0* a1);
/*WHEN_ITEM_2*/T0* r631specialize_2_character(T631* C,T0* a1);
/*WHEN_ITEM_2*/void r631set_values_character(T631* C);
/*WHEN_ITEM_2*/void r631init(T631* C,T0* a1,T0* a2);
/*WHEN_ITEM_2*/T6 r631validity_check_continued(T631* C,T0* a1);
/*WHEN_ITEM_2*/void r631validity_check(T631* C,T0* a1);
/*WHEN_ITEM_2*/void r631collect(T631* C,T0* a1);
/*WHEN_ITEM_2*/T0* r631current_or_twin_init(T631* C,T0* a1,T0* a2);
/*WHEN_ITEM_2*/T0* r631specialize_thru(T631* C,T0* a1,T0* a2,T0* a3);
/*WHEN_ITEM_2*/T0* r631specialize_in(T631* C,T0* a1);
/*WHEN_ITEM_2*/T2 r631character_check(T0* a1,T0* a2);
/*WHEN_ITEM_2*/void r631validity_check_continued_(T631* C,T0* a1);
/*WHEN_ITEM_2*/T0* r631manifest_expression_check(T0* a1,T0* a2);
/*WHEN_ITEM_2*/void r631explain_fatal_error(T0* a1,T0* a2);
/*WHEN_ITEM_2*/void r631validity_check_continued_when_item_2(T631* C,T0* a1);
/*WHEN_ITEM_2*/void r631validity_check_continued_when_item_1(T631* C,T0* a1);
/*WHEN_ITEM_2*/T2 r631integer_check(T0* a1,T0* a2);
/*WHEN_ITEM_2*/T0* r631adapt_for(T631* C,T0* a1);
/*WHEN_ITEM_2*/T0* r631specialize_2_string(T631* C,T0* a1);
/*WHEN_ITEM_2*/void r631make(T631* C,T0* a1,T0* a2);
/*WHEN_ITEM_2*/T6 r631match_value(T631* C,T2 a1);
/*WHEN_ITEM_2*/T0* r631twin(T631* C);
/*WHEN_ITEM_2*/T0* r631specialize_2_integer(T631* C,T0* a1);
/*WHEN_ITEM_2*/void r631force_internal_character_values(T631* C,T0* a1,T0* a2);
/*WHEN_ITEM_2*/T296 r631start_position(T631* C);
/*WHEN_ITEM_2*/void r631force_internal_integer_values(T631* C,T0* a1,T0* a2);
/*CREATE_WRITABLE*/void r419mapping_c_target(T419* C,T0* a1,T0* a2);
/*CREATE_WRITABLE*/void r419pretty_target(T419* C,T2 a1);
/*CREATE_WRITABLE*/void r419copy(T419* C,T0* a1);
/*CREATE_WRITABLE*/T0* r419non_void_no_dispatch_type(T0* a1);
/*CREATE_WRITABLE*/T6 r419is_equal(T419* C,T0* a1);
/*CREATE_WRITABLE*/void r419init(T419* C,T0* a1,T0* a2);
/*CREATE_WRITABLE*/void r419validity_check(T419* C,T0* a1);
/*CREATE_WRITABLE*/T0* r419specialize_2(T419* C,T0* a1);
/*CREATE_WRITABLE*/T0* r419static_simplify(T419* C);
/*CREATE_WRITABLE*/T0* r419simplify(T419* C,T0* a1);
/*CREATE_WRITABLE*/T0* r419collect(T419* C,T0* a1);
/*CREATE_WRITABLE*/T0* r419current_or_twin_init(T419* C,T0* a1,T0* a2);
/*CREATE_WRITABLE*/T0* r419specialize_thru(T419* C,T0* a1,T0* a2,T0* a3);
/*CREATE_WRITABLE*/void r419compile_to_c_with_internal_c_local_saving(T419* C,T0* a1);
/*CREATE_WRITABLE*/T0* r419specialize_in(T419* C,T0* a1);
/*CREATE_WRITABLE*/void r419compile_to_c(T419* C,T0* a1);
/*CREATE_WRITABLE*/T6 r419use_current(T419* C,T0* a1);
/*CREATE_WRITABLE*/T6 r419side_effect_free(T419* C,T0* a1);
/*CREATE_WRITABLE*/void r419accept(T419* C,T0* a1);
/*CREATE_WRITABLE*/T0* r419adapt_for(T419* C,T0* a1);
/*CREATE_WRITABLE*/T0* r419resolve_in(T419* C,T0* a1);
/*CREATE_WRITABLE*/void r419make(T419* C,T0* a1,T0* a2);
/*CREATE_WRITABLE*/T0* r419written_declaration_type_mark(void);
/*CREATE_WRITABLE*/T0* r419twin(T419* C);
/*CREATE_WRITABLE*/void r419pretty(T419* C,T2 a1);
/*CREATE_WRITABLE*/T296 r419start_position(T419* C);
/*CREATE_WRITABLE*/T6 r419is_result(T419* C);
/*CREATE_WRITABLE*/void r419mapping_c_arg(T419* C,T0* a1);
/*CREATE_WRITABLE*/T6 r419extra_bracket_flag(T419* C);
/*CREATE_WRITABLE*/void r419bracketed_pretty(T419* C,T2 a1);
/*CREATE_WRITABLE*/void r419safety_check(T419* C,T0* a1);
/*CREATE_WRITABLE*/T2 r419precedence(T419* C);
/*CREATE_WRITABLE*/T6 r419is_default_value(void);
/*CREATE_WRITABLE*/void r419make_specialized(T419* C,T0* a1,T0* a2);
/*CST_ATT_BOOLEAN*/T6 r378use_current(T0* a1);
/*CST_ATT_BOOLEAN*/void r378set_ensure(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/T0* r378specialized_require_thru(T378* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_BOOLEAN*/T6 r378side_effect_free(T0* a1);
/*CST_ATT_BOOLEAN*/T0* r378first_name(T378* C);
/*CST_ATT_BOOLEAN*/void r378copy(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/T0* r378inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_BOOLEAN*/T0* r378inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*CST_ATT_BOOLEAN*/void r378collect_body(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/T0* r378class_text(T378* C);
/*CST_ATT_BOOLEAN*/T0* r378names(T378* C);
/*CST_ATT_BOOLEAN*/T0* r378specialize_require_in(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/void r378add_into(T378* C,T0* a1,T0* a2);
/*CST_ATT_BOOLEAN*/T0* r378merge_signature_thru(T378* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*CST_ATT_BOOLEAN*/T0* r378try_to_undefine(T378* C,T0* a1,T0* a2);
/*CST_ATT_BOOLEAN*/void r378add_into_(T378* C,T0* a1,T0* a2);
/*CST_ATT_BOOLEAN*/void r378collect(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/T0* r378new_run_feature_for(T378* C,T0* a1,T0* a2);
/*CST_ATT_BOOLEAN*/void r378valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_BOOLEAN*/void r378collect_precursor(T378* C,T0* a1,T0* a2);
/*CST_ATT_BOOLEAN*/T0* r378inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*CST_ATT_BOOLEAN*/T0* r378change_ensure(T378* C,T0* a1,T6 a2);
/*CST_ATT_BOOLEAN*/T0* r378brand_new_run_feature_for(T378* C,T0* a1,T0* a2,T6 a3);
/*CST_ATT_BOOLEAN*/T0* r378specialize_permissions(T378* C,T0* a1,T6 a2);
/*CST_ATT_BOOLEAN*/T6 r378same_body_as(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/T0* r378specialize_body_thru(T378* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*CST_ATT_BOOLEAN*/T6 r378same_signature(T378* C,T0* a1,T0* a2);
/*CST_ATT_BOOLEAN*/void r378set_header_comment(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/T0* r378specialize_signature_thru(T378* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_BOOLEAN*/T0* r378specialize_ensure_in(T378* C,T0* a1,T6 a2);
/*CST_ATT_BOOLEAN*/T0* r378specialize_ensure_thru(T378* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*CST_ATT_BOOLEAN*/void r378accept(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/void r378add_into_shared(T378* C,T0* a1,T0* a2);
/*CST_ATT_BOOLEAN*/void r378set_ensure_assertion(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/T0* r378arguments(void);
/*CST_ATT_BOOLEAN*/T0* r378clients(T378* C);
/*CST_ATT_BOOLEAN*/T0* r378inline_expression_1(T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*CST_ATT_BOOLEAN*/T0* r378inline_expression_0(T378* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*CST_ATT_BOOLEAN*/void r378make(T378* C,T0* a1,T0* a2);
/*CST_ATT_BOOLEAN*/T0* r378twin(T378* C);
/*CST_ATT_BOOLEAN*/T6 r378valid_redefinition(T378* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_BOOLEAN*/T0* r378change_require(T378* C,T0* a1,T6 a2);
/*CST_ATT_BOOLEAN*/void r378set_require(T378* C,T0* a1);
extern T0*oBC305obsolete_warning_check_memory;
extern int fBC305obsolete_warning_check_memory;
/*CST_ATT_BOOLEAN*/T0* r378obsolete_warning_check_memory(void);
/*CST_ATT_BOOLEAN*/T296 r378start_position(T378* C);
/*CST_ATT_BOOLEAN*/void r378set_rescue_compound(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/T0* r378specialize_body_in(T378* C,T0* a1,T6 a2);
/*CST_ATT_BOOLEAN*/T0* r378value(T378* C);
/*CST_ATT_BOOLEAN*/void r378obsolete_warning_check(T378* C,T0* a1,T296 a2);
/*CST_ATT_BOOLEAN*/T0* r378specialize_2(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/T0* r378simplify(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/void r378set_permissions(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/T0* r378specialize_signature_in(T378* C,T0* a1);
/*CST_ATT_BOOLEAN*/T0* r378specialized_ensure_thru(T378* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_BOOLEAN*/T0* r378inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_BOOLEAN*/T0* r378try_to_undefine_aux(T378* C,T0* a1,T0* a2);
/*CST_ATT_BOOLEAN*/T0* r378specialize_require_thru(T378* C,T0* a1,T0* a2,T0* a3);
/*ONCE_FUNCTION*/void r369copy(T369* C,T0* a1);
/*ONCE_FUNCTION*/T0* r369typed_internal_local(T369* C,T0* a1,T0* a2,T296 a3,T0* a4);
/*ONCE_FUNCTION*/void r369make_routine(T369* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*ONCE_FUNCTION*/T0* r369rescue_compound_in(T369* C,T0* a1);
extern T0*oBC369type_std_output;
extern int fBC369type_std_output;
/*ONCE_FUNCTION*/T0* r369type_std_output(void);
/*ONCE_FUNCTION*/T6 r369no_rescue_no_local_expanded_in(T369* C,T0* a1);
/*ONCE_FUNCTION*/void r369make_effective_routine(T369* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*ONCE_FUNCTION*/T6 r369use_current(T369* C,T0* a1);
/*ONCE_FUNCTION*/T6 r369side_effect_free(T0* a1);
/*ONCE_FUNCTION*/void r369accept(T369* C,T0* a1);
/*ONCE_FUNCTION*/T0* r369twin(T369* C);
/*ONCE_FUNCTION*/void r369make(T369* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*ONCE_FUNCTION*/void r369init(T369* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*ONCE_FUNCTION*/T296 r369start_position(T369* C);
/*ONCE_FUNCTION*/T0* r369specialize_2(T369* C,T0* a1);
/*ONCE_FUNCTION*/T0* r369simplify(T369* C,T0* a1);
/*ONCE_FUNCTION*/void r369set_permissions(T369* C,T0* a1);
/*ONCE_FUNCTION*/T0* r369specialize_signature_in(T369* C,T0* a1);
/*ONCE_FUNCTION*/T0* r369specialized_ensure_thru(T369* C,T0* a1,T0* a2,T0* a3);
/*ONCE_FUNCTION*/T0* r369inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*ONCE_FUNCTION*/T0* r369class_text(T369* C);
/*ONCE_FUNCTION*/T0* r369try_to_undefine_aux(T369* C,T0* a1,T0* a2);
/*ONCE_FUNCTION*/void r369collect(T369* C,T0* a1);
/*ONCE_FUNCTION*/T0* r369specialize_require_thru(T369* C,T0* a1,T0* a2,T0* a3);
extern T0*oBC28flush_name;
extern int fBC28flush_name;
/*ONCE_FUNCTION*/T0* r369flush_name(void);
/*ONCE_FUNCTION*/void r369set_ensure(T369* C,T0* a1);
/*ONCE_FUNCTION*/T0* r369specialized_require_thru(T369* C,T0* a1,T0* a2,T0* a3);
/*ONCE_FUNCTION*/T0* r369first_name(T369* C);
/*ONCE_FUNCTION*/T0* r369inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*ONCE_FUNCTION*/T0* r369inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*ONCE_FUNCTION*/void r369collect_body(T369* C,T0* a1);
/*ONCE_FUNCTION*/T0* r369names(T369* C);
/*ONCE_FUNCTION*/T0* r369specialize_require_in(T369* C,T0* a1);
/*ONCE_FUNCTION*/void r369add_into(T369* C,T0* a1,T0* a2);
/*ONCE_FUNCTION*/T0* r369merge_signature_thru(T369* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*ONCE_FUNCTION*/T0* r369try_to_undefine(T369* C,T0* a1,T0* a2);
/*ONCE_FUNCTION*/void r369add_into_(T369* C,T0* a1,T0* a2);
/*ONCE_FUNCTION*/T0* r369new_run_feature_for(T369* C,T0* a1,T0* a2);
/*ONCE_FUNCTION*/void r369valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*ONCE_FUNCTION*/void r369collect_precursor(T369* C,T0* a1,T0* a2);
/*ONCE_FUNCTION*/T0* r369inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*ONCE_FUNCTION*/T0* r369change_ensure(T369* C,T0* a1,T6 a2);
/*ONCE_FUNCTION*/T0* r369brand_new_run_feature_for(T369* C,T0* a1,T0* a2,T6 a3);
/*ONCE_FUNCTION*/T0* r369specialize_permissions(T369* C,T0* a1,T6 a2);
/*ONCE_FUNCTION*/void r369hook_collect(T369* C,T0* a1);
/*ONCE_FUNCTION*/T6 r369same_body_as(T369* C,T0* a1);
/*ONCE_FUNCTION*/T0* r369specialize_body_thru(T369* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*ONCE_FUNCTION*/T6 r369same_signature(T369* C,T0* a1,T0* a2);
/*ONCE_FUNCTION*/void r369set_header_comment(T369* C,T0* a1);
/*ONCE_FUNCTION*/T296 r369sedb_trace_before_exit(T369* C);
/*ONCE_FUNCTION*/T0* r369specialize_signature_thru(T369* C,T0* a1,T0* a2,T0* a3);
/*ONCE_FUNCTION*/T0* r369specialize_ensure_in(T369* C,T0* a1,T6 a2);
/*ONCE_FUNCTION*/T0* r369specialize_ensure_thru(T369* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*ONCE_FUNCTION*/void r369add_into_shared(T369* C,T0* a1,T0* a2);
/*ONCE_FUNCTION*/void r369set_ensure_assertion(T369* C,T0* a1);
/*ONCE_FUNCTION*/T0* r369clients(T369* C);
/*ONCE_FUNCTION*/T0* r369inline_expression_1(T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*ONCE_FUNCTION*/T0* r369inline_expression_0(T369* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*ONCE_FUNCTION*/T6 r369valid_redefinition(T369* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*ONCE_FUNCTION*/void r369set_end_comment(T369* C,T0* a1);
/*ONCE_FUNCTION*/T0* r369change_require(T369* C,T0* a1,T6 a2);
/*ONCE_FUNCTION*/void r369set_require(T369* C,T0* a1);
/*ONCE_FUNCTION*/T0* r369obsolete_warning_check_memory(void);
/*ONCE_FUNCTION*/void r369set_rescue_compound(T369* C,T0* a1);
/*ONCE_FUNCTION*/T0* r369specialize_body_in(T369* C,T0* a1,T6 a2);
/*ONCE_FUNCTION*/void r369obsolete_warning_check(T369* C,T0* a1,T296 a2);
/*ONCE_FUNCTION*/T6 r369_P_305_same_body_as(T369* C,T0* a1);
/*ONCE_PROCEDURE*/T6 r364use_current(T364* C,T0* a1);
/*ONCE_PROCEDURE*/void r364set_ensure(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T0* r364specialized_require_thru(T364* C,T0* a1,T0* a2,T0* a3);
/*ONCE_PROCEDURE*/T6 r364side_effect_free(T0* a1);
/*ONCE_PROCEDURE*/T0* r364first_name(T364* C);
/*ONCE_PROCEDURE*/void r364copy(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T0* r364inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*ONCE_PROCEDURE*/T0* r364inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*ONCE_PROCEDURE*/void r364collect_body(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T0* r364class_text(T364* C);
/*ONCE_PROCEDURE*/T0* r364names(T364* C);
/*ONCE_PROCEDURE*/T0* r364specialize_require_in(T364* C,T0* a1);
/*ONCE_PROCEDURE*/void r364add_into(T364* C,T0* a1,T0* a2);
/*ONCE_PROCEDURE*/T0* r364merge_signature_thru(T364* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*ONCE_PROCEDURE*/T0* r364try_to_undefine(T364* C,T0* a1,T0* a2);
/*ONCE_PROCEDURE*/void r364add_into_(T364* C,T0* a1,T0* a2);
/*ONCE_PROCEDURE*/void r364collect(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T0* r364new_run_feature_for(T364* C,T0* a1,T0* a2);
/*ONCE_PROCEDURE*/void r364valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*ONCE_PROCEDURE*/void r364collect_precursor(T364* C,T0* a1,T0* a2);
/*ONCE_PROCEDURE*/T0* r364inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*ONCE_PROCEDURE*/T0* r364change_ensure(T364* C,T0* a1,T6 a2);
/*ONCE_PROCEDURE*/T0* r364brand_new_run_feature_for(T364* C,T0* a1,T0* a2,T6 a3);
/*ONCE_PROCEDURE*/T0* r364specialize_permissions(T364* C,T0* a1,T6 a2);
/*ONCE_PROCEDURE*/T6 r364same_body_as(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T0* r364specialize_body_thru(T364* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*ONCE_PROCEDURE*/T6 r364same_signature(T364* C,T0* a1,T0* a2);
/*ONCE_PROCEDURE*/void r364set_header_comment(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T296 r364sedb_trace_before_exit(T364* C);
/*ONCE_PROCEDURE*/T0* r364specialize_signature_thru(T364* C,T0* a1,T0* a2,T0* a3);
/*ONCE_PROCEDURE*/T0* r364specialize_ensure_in(T364* C,T0* a1,T6 a2);
/*ONCE_PROCEDURE*/T0* r364specialize_ensure_thru(T364* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*ONCE_PROCEDURE*/void r364accept(T364* C,T0* a1);
/*ONCE_PROCEDURE*/void r364add_into_shared(T364* C,T0* a1,T0* a2);
/*ONCE_PROCEDURE*/void r364set_ensure_assertion(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T0* r364clients(T364* C);
/*ONCE_PROCEDURE*/T0* r364inline_expression_1(T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*ONCE_PROCEDURE*/T0* r364inline_expression_0(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*ONCE_PROCEDURE*/void r364make(T364* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*ONCE_PROCEDURE*/T0* r364twin(T364* C);
/*ONCE_PROCEDURE*/T6 r364valid_redefinition(T364* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*ONCE_PROCEDURE*/T0* r364change_require(T364* C,T0* a1,T6 a2);
/*ONCE_PROCEDURE*/void r364set_require(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T0* r364obsolete_warning_check_memory(void);
/*ONCE_PROCEDURE*/void r364set_end_comment(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T296 r364start_position(T364* C);
/*ONCE_PROCEDURE*/void r364set_rescue_compound(T364* C,T0* a1);
/*ONCE_PROCEDURE*/void r364init(T364* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*ONCE_PROCEDURE*/T0* r364specialize_body_in(T364* C,T0* a1,T6 a2);
/*ONCE_PROCEDURE*/T0* r364result_type(void);
/*ONCE_PROCEDURE*/void r364obsolete_warning_check(T364* C,T0* a1,T296 a2);
/*ONCE_PROCEDURE*/T0* r364specialize_2(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T0* r364simplify(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T0* r364typed_internal_local(T364* C,T0* a1,T0* a2,T296 a3,T0* a4);
/*ONCE_PROCEDURE*/void r364make_routine(T364* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*ONCE_PROCEDURE*/void r364set_permissions(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T0* r364specialize_signature_in(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T0* r364rescue_compound_in(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T0* r364specialized_ensure_thru(T364* C,T0* a1,T0* a2,T0* a3);
/*ONCE_PROCEDURE*/T6 r364no_rescue_no_local_expanded_in(T364* C,T0* a1);
/*ONCE_PROCEDURE*/T0* r364inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*ONCE_PROCEDURE*/T0* r364try_to_undefine_aux(T364* C,T0* a1,T0* a2);
/*ONCE_PROCEDURE*/T0* r364specialize_require_thru(T364* C,T0* a1,T0* a2,T0* a3);
/*ONCE_PROCEDURE*/T6 r364_P_305_same_body_as(T364* C,T0* a1);
/*CST_ATT_CHARACTER*/T6 r370use_current(T0* a1);
/*CST_ATT_CHARACTER*/void r370set_ensure(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/T0* r370specialized_require_thru(T370* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_CHARACTER*/T6 r370side_effect_free(T0* a1);
/*CST_ATT_CHARACTER*/T0* r370first_name(T370* C);
/*CST_ATT_CHARACTER*/void r370copy(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/T0* r370inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_CHARACTER*/T0* r370inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*CST_ATT_CHARACTER*/void r370collect_body(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/T0* r370class_text(T370* C);
/*CST_ATT_CHARACTER*/T0* r370names(T370* C);
/*CST_ATT_CHARACTER*/T0* r370specialize_require_in(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/void r370add_into(T370* C,T0* a1,T0* a2);
/*CST_ATT_CHARACTER*/T0* r370merge_signature_thru(T370* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*CST_ATT_CHARACTER*/T0* r370try_to_undefine(T370* C,T0* a1,T0* a2);
/*CST_ATT_CHARACTER*/void r370add_into_(T370* C,T0* a1,T0* a2);
/*CST_ATT_CHARACTER*/void r370collect(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/T0* r370new_run_feature_for(T370* C,T0* a1,T0* a2);
/*CST_ATT_CHARACTER*/void r370valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_CHARACTER*/void r370collect_precursor(T370* C,T0* a1,T0* a2);
/*CST_ATT_CHARACTER*/T0* r370inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*CST_ATT_CHARACTER*/T0* r370change_ensure(T370* C,T0* a1,T6 a2);
/*CST_ATT_CHARACTER*/T0* r370brand_new_run_feature_for(T370* C,T0* a1,T0* a2,T6 a3);
/*CST_ATT_CHARACTER*/T0* r370specialize_permissions(T370* C,T0* a1,T6 a2);
/*CST_ATT_CHARACTER*/T6 r370same_body_as(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/T0* r370specialize_body_thru(T370* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*CST_ATT_CHARACTER*/T6 r370same_signature(T370* C,T0* a1,T0* a2);
/*CST_ATT_CHARACTER*/void r370set_header_comment(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/T0* r370specialize_signature_thru(T370* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_CHARACTER*/T0* r370specialize_ensure_in(T370* C,T0* a1,T6 a2);
/*CST_ATT_CHARACTER*/T0* r370specialize_ensure_thru(T370* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*CST_ATT_CHARACTER*/void r370accept(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/void r370add_into_shared(T370* C,T0* a1,T0* a2);
/*CST_ATT_CHARACTER*/void r370set_ensure_assertion(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/T0* r370arguments(void);
/*CST_ATT_CHARACTER*/T0* r370clients(T370* C);
/*CST_ATT_CHARACTER*/T0* r370inline_expression_1(T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*CST_ATT_CHARACTER*/T0* r370inline_expression_0(T370* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*CST_ATT_CHARACTER*/void r370make(T370* C,T0* a1,T0* a2);
/*CST_ATT_CHARACTER*/T0* r370twin(T370* C);
/*CST_ATT_CHARACTER*/T6 r370valid_redefinition(T370* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_CHARACTER*/T0* r370change_require(T370* C,T0* a1,T6 a2);
/*CST_ATT_CHARACTER*/void r370set_require(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/T0* r370obsolete_warning_check_memory(void);
/*CST_ATT_CHARACTER*/T296 r370start_position(T370* C);
/*CST_ATT_CHARACTER*/void r370set_rescue_compound(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/T0* r370specialize_body_in(T370* C,T0* a1,T6 a2);
/*CST_ATT_CHARACTER*/T0* r370value(T370* C);
/*CST_ATT_CHARACTER*/void r370obsolete_warning_check(T370* C,T0* a1,T296 a2);
/*CST_ATT_CHARACTER*/T0* r370specialize_2(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/T0* r370simplify(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/void r370set_permissions(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/T0* r370specialize_signature_in(T370* C,T0* a1);
/*CST_ATT_CHARACTER*/T0* r370specialized_ensure_thru(T370* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_CHARACTER*/T0* r370inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_CHARACTER*/T0* r370try_to_undefine_aux(T370* C,T0* a1,T0* a2);
/*CST_ATT_CHARACTER*/T0* r370specialize_require_thru(T370* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_STRING*/T6 r374use_current(T0* a1);
/*CST_ATT_STRING*/void r374set_ensure(T374* C,T0* a1);
/*CST_ATT_STRING*/T0* r374specialized_require_thru(T374* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_STRING*/T6 r374side_effect_free(T0* a1);
/*CST_ATT_STRING*/T0* r374first_name(T374* C);
/*CST_ATT_STRING*/void r374copy(T374* C,T0* a1);
/*CST_ATT_STRING*/T0* r374inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_STRING*/T0* r374inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*CST_ATT_STRING*/void r374collect_body(T374* C,T0* a1);
/*CST_ATT_STRING*/T0* r374class_text(T374* C);
/*CST_ATT_STRING*/T0* r374names(T374* C);
/*CST_ATT_STRING*/T0* r374specialize_require_in(T374* C,T0* a1);
/*CST_ATT_STRING*/void r374add_into(T374* C,T0* a1,T0* a2);
/*CST_ATT_STRING*/T0* r374merge_signature_thru(T374* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*CST_ATT_STRING*/T0* r374try_to_undefine(T374* C,T0* a1,T0* a2);
/*CST_ATT_STRING*/void r374add_into_(T374* C,T0* a1,T0* a2);
/*CST_ATT_STRING*/void r374collect(T374* C,T0* a1);
/*CST_ATT_STRING*/T0* r374new_run_feature_for(T374* C,T0* a1,T0* a2);
/*CST_ATT_STRING*/void r374valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_STRING*/void r374collect_precursor(T374* C,T0* a1,T0* a2);
/*CST_ATT_STRING*/T0* r374inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*CST_ATT_STRING*/T0* r374change_ensure(T374* C,T0* a1,T6 a2);
/*CST_ATT_STRING*/T0* r374brand_new_run_feature_for(T374* C,T0* a1,T0* a2,T6 a3);
/*CST_ATT_STRING*/T0* r374specialize_permissions(T374* C,T0* a1,T6 a2);
/*CST_ATT_STRING*/T6 r374same_body_as(T374* C,T0* a1);
/*CST_ATT_STRING*/T0* r374specialize_body_thru(T374* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*CST_ATT_STRING*/T6 r374same_signature(T374* C,T0* a1,T0* a2);
/*CST_ATT_STRING*/void r374set_header_comment(T374* C,T0* a1);
/*CST_ATT_STRING*/T0* r374specialize_signature_thru(T374* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_STRING*/T0* r374specialize_ensure_in(T374* C,T0* a1,T6 a2);
/*CST_ATT_STRING*/T0* r374specialize_ensure_thru(T374* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*CST_ATT_STRING*/void r374accept(T374* C,T0* a1);
/*CST_ATT_STRING*/void r374set_ensure_assertion(T374* C,T0* a1);
/*CST_ATT_STRING*/T0* r374arguments(void);
/*CST_ATT_STRING*/T0* r374clients(T374* C);
/*CST_ATT_STRING*/T0* r374inline_expression_1(T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*CST_ATT_STRING*/T0* r374inline_expression_0(T374* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*CST_ATT_STRING*/void r374make(T374* C,T0* a1,T0* a2);
/*CST_ATT_STRING*/T0* r374twin(T374* C);
/*CST_ATT_STRING*/T6 r374valid_redefinition(T374* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_STRING*/T0* r374change_require(T374* C,T0* a1,T6 a2);
/*CST_ATT_STRING*/void r374set_require(T374* C,T0* a1);
/*CST_ATT_STRING*/T0* r374obsolete_warning_check_memory(void);
/*CST_ATT_STRING*/T296 r374start_position(T374* C);
/*CST_ATT_STRING*/void r374set_rescue_compound(T374* C,T0* a1);
/*CST_ATT_STRING*/T0* r374specialize_body_in(T374* C,T0* a1,T6 a2);
/*CST_ATT_STRING*/T0* r374value(T374* C);
/*CST_ATT_STRING*/void r374obsolete_warning_check(T374* C,T0* a1,T296 a2);
/*CST_ATT_STRING*/T0* r374specialize_2(T374* C,T0* a1);
/*CST_ATT_STRING*/T0* r374simplify(T374* C,T0* a1);
/*CST_ATT_STRING*/void r374with(T374* C,T0* a1,T0* a2,T2 a3);
/*CST_ATT_STRING*/void r374set_permissions(T374* C,T0* a1);
/*CST_ATT_STRING*/T0* r374specialize_signature_in(T374* C,T0* a1);
/*CST_ATT_STRING*/T0* r374specialized_ensure_thru(T374* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_STRING*/T0* r374inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_STRING*/T0* r374try_to_undefine_aux(T374* C,T0* a1,T0* a2);
/*CST_ATT_STRING*/T0* r374specialize_require_thru(T374* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_REAL*/T6 r373use_current(T0* a1);
/*CST_ATT_REAL*/void r373set_ensure(T373* C,T0* a1);
/*CST_ATT_REAL*/T0* r373specialized_require_thru(T373* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_REAL*/T6 r373side_effect_free(T0* a1);
/*CST_ATT_REAL*/T0* r373first_name(T373* C);
/*CST_ATT_REAL*/void r373copy(T373* C,T0* a1);
/*CST_ATT_REAL*/T0* r373inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_REAL*/T0* r373inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*CST_ATT_REAL*/void r373collect_body(T373* C,T0* a1);
/*CST_ATT_REAL*/T0* r373class_text(T373* C);
/*CST_ATT_REAL*/T0* r373names(T373* C);
/*CST_ATT_REAL*/T0* r373specialize_require_in(T373* C,T0* a1);
/*CST_ATT_REAL*/void r373add_into(T373* C,T0* a1,T0* a2);
/*CST_ATT_REAL*/T0* r373merge_signature_thru(T373* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*CST_ATT_REAL*/T0* r373try_to_undefine(T373* C,T0* a1,T0* a2);
/*CST_ATT_REAL*/void r373add_into_(T373* C,T0* a1,T0* a2);
/*CST_ATT_REAL*/void r373collect(T373* C,T0* a1);
/*CST_ATT_REAL*/T0* r373new_run_feature_for(T373* C,T0* a1,T0* a2);
/*CST_ATT_REAL*/void r373valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_REAL*/void r373collect_precursor(T373* C,T0* a1,T0* a2);
/*CST_ATT_REAL*/T0* r373inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*CST_ATT_REAL*/T0* r373change_ensure(T373* C,T0* a1,T6 a2);
/*CST_ATT_REAL*/T0* r373brand_new_run_feature_for(T373* C,T0* a1,T0* a2,T6 a3);
/*CST_ATT_REAL*/T0* r373specialize_permissions(T373* C,T0* a1,T6 a2);
/*CST_ATT_REAL*/T6 r373same_body_as(T373* C,T0* a1);
/*CST_ATT_REAL*/T0* r373specialize_body_thru(T373* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*CST_ATT_REAL*/T6 r373same_signature(T373* C,T0* a1,T0* a2);
/*CST_ATT_REAL*/void r373set_header_comment(T373* C,T0* a1);
/*CST_ATT_REAL*/T0* r373specialize_signature_thru(T373* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_REAL*/T0* r373specialize_ensure_in(T373* C,T0* a1,T6 a2);
/*CST_ATT_REAL*/T0* r373specialize_ensure_thru(T373* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*CST_ATT_REAL*/void r373accept(T373* C,T0* a1);
/*CST_ATT_REAL*/void r373add_into_shared(T373* C,T0* a1,T0* a2);
/*CST_ATT_REAL*/void r373set_ensure_assertion(T373* C,T0* a1);
/*CST_ATT_REAL*/T0* r373arguments(void);
/*CST_ATT_REAL*/T0* r373clients(T373* C);
/*CST_ATT_REAL*/T0* r373inline_expression_1(T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*CST_ATT_REAL*/T0* r373inline_expression_0(T373* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*CST_ATT_REAL*/void r373make(T373* C,T0* a1,T0* a2);
/*CST_ATT_REAL*/T0* r373twin(T373* C);
/*CST_ATT_REAL*/T6 r373valid_redefinition(T373* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_REAL*/T0* r373change_require(T373* C,T0* a1,T6 a2);
/*CST_ATT_REAL*/void r373set_require(T373* C,T0* a1);
/*CST_ATT_REAL*/T0* r373obsolete_warning_check_memory(void);
/*CST_ATT_REAL*/T296 r373start_position(T373* C);
/*CST_ATT_REAL*/void r373set_rescue_compound(T373* C,T0* a1);
/*CST_ATT_REAL*/T0* r373specialize_body_in(T373* C,T0* a1,T6 a2);
/*CST_ATT_REAL*/T0* r373value(T373* C);
/*CST_ATT_REAL*/void r373obsolete_warning_check(T373* C,T0* a1,T296 a2);
/*CST_ATT_REAL*/T0* r373specialize_2(T373* C,T0* a1);
/*CST_ATT_REAL*/T0* r373simplify(T373* C,T0* a1);
/*CST_ATT_REAL*/void r373set_permissions(T373* C,T0* a1);
/*CST_ATT_REAL*/T0* r373specialize_signature_in(T373* C,T0* a1);
/*CST_ATT_REAL*/T0* r373specialized_ensure_thru(T373* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_REAL*/T0* r373inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_REAL*/T0* r373try_to_undefine_aux(T373* C,T0* a1,T0* a2);
/*CST_ATT_REAL*/T0* r373specialize_require_thru(T373* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_INTEGER*/T6 r368use_current(T0* a1);
/*CST_ATT_INTEGER*/void r368set_ensure(T368* C,T0* a1);
/*CST_ATT_INTEGER*/T0* r368specialized_require_thru(T368* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_INTEGER*/T6 r368side_effect_free(T0* a1);
/*CST_ATT_INTEGER*/T0* r368first_name(T368* C);
/*CST_ATT_INTEGER*/void r368copy(T368* C,T0* a1);
/*CST_ATT_INTEGER*/T0* r368inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_INTEGER*/T0* r368inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*CST_ATT_INTEGER*/void r368collect_body(T368* C,T0* a1);
/*CST_ATT_INTEGER*/T0* r368class_text(T368* C);
/*CST_ATT_INTEGER*/T0* r368names(T368* C);
/*CST_ATT_INTEGER*/T0* r368specialize_require_in(T368* C,T0* a1);
/*CST_ATT_INTEGER*/void r368add_into(T368* C,T0* a1,T0* a2);
/*CST_ATT_INTEGER*/T0* r368merge_signature_thru(T368* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*CST_ATT_INTEGER*/T0* r368try_to_undefine(T368* C,T0* a1,T0* a2);
/*CST_ATT_INTEGER*/void r368add_into_(T368* C,T0* a1,T0* a2);
/*CST_ATT_INTEGER*/void r368collect(T368* C,T0* a1);
/*CST_ATT_INTEGER*/T0* r368new_run_feature_for(T368* C,T0* a1,T0* a2);
/*CST_ATT_INTEGER*/void r368valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_INTEGER*/void r368collect_precursor(T368* C,T0* a1,T0* a2);
/*CST_ATT_INTEGER*/T0* r368inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*CST_ATT_INTEGER*/T0* r368change_ensure(T368* C,T0* a1,T6 a2);
/*CST_ATT_INTEGER*/T0* r368brand_new_run_feature_for(T368* C,T0* a1,T0* a2,T6 a3);
/*CST_ATT_INTEGER*/T0* r368specialize_permissions(T368* C,T0* a1,T6 a2);
/*CST_ATT_INTEGER*/T6 r368same_body_as(T368* C,T0* a1);
/*CST_ATT_INTEGER*/T0* r368specialize_body_thru(T368* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*CST_ATT_INTEGER*/T6 r368same_signature(T368* C,T0* a1,T0* a2);
/*CST_ATT_INTEGER*/void r368set_header_comment(T368* C,T0* a1);
/*CST_ATT_INTEGER*/T0* r368specialize_signature_thru(T368* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_INTEGER*/T0* r368specialize_ensure_in(T368* C,T0* a1,T6 a2);
/*CST_ATT_INTEGER*/T0* r368specialize_ensure_thru(T368* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*CST_ATT_INTEGER*/void r368accept(T368* C,T0* a1);
/*CST_ATT_INTEGER*/void r368add_into_shared(T368* C,T0* a1,T0* a2);
/*CST_ATT_INTEGER*/void r368set_ensure_assertion(T368* C,T0* a1);
/*CST_ATT_INTEGER*/T0* r368arguments(void);
/*CST_ATT_INTEGER*/T0* r368clients(T368* C);
/*CST_ATT_INTEGER*/T0* r368inline_expression_1(T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*CST_ATT_INTEGER*/T0* r368inline_expression_0(T368* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*CST_ATT_INTEGER*/void r368make(T368* C,T0* a1);
/*CST_ATT_INTEGER*/T0* r368twin(T368* C);
/*CST_ATT_INTEGER*/T6 r368valid_redefinition(T368* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_INTEGER*/T0* r368change_require(T368* C,T0* a1,T6 a2);
/*CST_ATT_INTEGER*/void r368set_require(T368* C,T0* a1);
/*CST_ATT_INTEGER*/T0* r368obsolete_warning_check_memory(void);
/*CST_ATT_INTEGER*/T296 r368start_position(T368* C);
/*CST_ATT_INTEGER*/void r368set_rescue_compound(T368* C,T0* a1);
/*CST_ATT_INTEGER*/T0* r368specialize_body_in(T368* C,T0* a1,T6 a2);
/*CST_ATT_INTEGER*/T0* r368value(T368* C);
/*CST_ATT_INTEGER*/void r368obsolete_warning_check(T368* C,T0* a1,T296 a2);
/*CST_ATT_INTEGER*/T0* r368specialize_2(T368* C,T0* a1);
/*CST_ATT_INTEGER*/T0* r368simplify(T368* C,T0* a1);
/*CST_ATT_INTEGER*/void r368set_permissions(T368* C,T0* a1);
/*CST_ATT_INTEGER*/T0* r368specialize_signature_in(T368* C,T0* a1);
/*CST_ATT_INTEGER*/T0* r368specialized_ensure_thru(T368* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_INTEGER*/T0* r368inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_INTEGER*/T0* r368try_to_undefine_aux(T368* C,T0* a1,T0* a2);
/*CST_ATT_INTEGER*/T0* r368specialize_require_thru(T368* C,T0* a1,T0* a2,T0* a3);
/*E_FUNCTION*/void r377copy(T377* C,T0* a1);
/*E_FUNCTION*/T0* r377typed_internal_local(T377* C,T0* a1,T0* a2,T296 a3,T0* a4);
/*E_FUNCTION*/void r377make_routine(T377* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*E_FUNCTION*/T0* r377rescue_compound_in(T377* C,T0* a1);
/*E_FUNCTION*/T6 r377no_rescue_no_local_expanded_in(T377* C,T0* a1);
/*E_FUNCTION*/void r377make_effective_routine(T377* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*E_FUNCTION*/T6 r377use_current(T377* C,T0* a1);
/*E_FUNCTION*/T6 r377side_effect_free(T0* a1);
/*E_FUNCTION*/T0* r377left_most_current_direct_call_0_sequence_inline(T0* a1,T0* a2,T0* a3,T0* a4);
/*E_FUNCTION*/T0* r377left_most_current_direct_call_0_sequence(T0* a1,T0* a2);
/*E_FUNCTION*/T0* r377inline_eq_neq1(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*E_FUNCTION*/T0* r377inline_eq_neq0(T0* a1,T0* a2,T0* a3,T0* a4);
/*E_FUNCTION*/T0* r377inline_call_1(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*E_FUNCTION*/T0* r377inline_eq_neq0_(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*E_FUNCTION*/void r377accept(T377* C,T0* a1);
/*E_FUNCTION*/T0* r377twin(T377* C);
/*E_FUNCTION*/void r377make(T377* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*E_FUNCTION*/void r377init(T377* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*E_FUNCTION*/T296 r377start_position(T377* C);
/*E_FUNCTION*/T0* r377specialize_2(T377* C,T0* a1);
/*E_FUNCTION*/T0* r377simplify(T377* C,T0* a1);
/*E_FUNCTION*/void r377set_permissions(T377* C,T0* a1);
/*E_FUNCTION*/T0* r377specialize_signature_in(T377* C,T0* a1);
/*E_FUNCTION*/T0* r377specialized_ensure_thru(T377* C,T0* a1,T0* a2,T0* a3);
/*E_FUNCTION*/T0* r377inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*E_FUNCTION*/T0* r377class_text(T377* C);
/*E_FUNCTION*/T0* r377try_to_undefine_aux(T377* C,T0* a1,T0* a2);
/*E_FUNCTION*/void r377collect(T377* C,T0* a1);
/*E_FUNCTION*/T0* r377specialize_require_thru(T377* C,T0* a1,T0* a2,T0* a3);
/*E_FUNCTION*/void r377set_ensure(T377* C,T0* a1);
/*E_FUNCTION*/T0* r377specialized_require_thru(T377* C,T0* a1,T0* a2,T0* a3);
/*E_FUNCTION*/T0* r377first_name(T377* C);
/*E_FUNCTION*/T0* r377inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*E_FUNCTION*/T0* r377inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*E_FUNCTION*/void r377collect_body(T377* C,T0* a1);
/*E_FUNCTION*/T0* r377names(T377* C);
/*E_FUNCTION*/T0* r377specialize_require_in(T377* C,T0* a1);
/*E_FUNCTION*/void r377add_into(T377* C,T0* a1,T0* a2);
/*E_FUNCTION*/T0* r377merge_signature_thru(T377* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*E_FUNCTION*/T0* r377try_to_undefine(T377* C,T0* a1,T0* a2);
/*E_FUNCTION*/void r377add_into_(T377* C,T0* a1,T0* a2);
/*E_FUNCTION*/T0* r377new_run_feature_for(T377* C,T0* a1,T0* a2);
/*E_FUNCTION*/void r377valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*E_FUNCTION*/void r377collect_precursor(T377* C,T0* a1,T0* a2);
/*E_FUNCTION*/T0* r377inline_expression_n(T377* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*E_FUNCTION*/T0* r377change_ensure(T377* C,T0* a1,T6 a2);
/*E_FUNCTION*/T0* r377brand_new_run_feature_for(T377* C,T0* a1,T0* a2,T6 a3);
/*E_FUNCTION*/T0* r377specialize_permissions(T377* C,T0* a1,T6 a2);
/*E_FUNCTION*/T6 r377same_body_as(T377* C,T0* a1);
/*E_FUNCTION*/T0* r377specialize_body_thru(T377* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*E_FUNCTION*/T6 r377same_signature(T377* C,T0* a1,T0* a2);
/*E_FUNCTION*/void r377set_header_comment(T377* C,T0* a1);
/*E_FUNCTION*/T296 r377sedb_trace_before_exit(T377* C);
/*E_FUNCTION*/T0* r377specialize_signature_thru(T377* C,T0* a1,T0* a2,T0* a3);
/*E_FUNCTION*/T0* r377specialize_ensure_in(T377* C,T0* a1,T6 a2);
/*E_FUNCTION*/T0* r377specialize_ensure_thru(T377* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*E_FUNCTION*/void r377add_into_shared(T377* C,T0* a1,T0* a2);
/*E_FUNCTION*/void r377set_ensure_assertion(T377* C,T0* a1);
/*E_FUNCTION*/T0* r377clients(T377* C);
/*E_FUNCTION*/T0* r377inline_expression_1(T377* C,T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*E_FUNCTION*/T0* r377inline_expression_0(T377* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*E_FUNCTION*/T6 r377valid_redefinition(T377* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*E_FUNCTION*/void r377set_end_comment(T377* C,T0* a1);
/*E_FUNCTION*/T0* r377change_require(T377* C,T0* a1,T6 a2);
/*E_FUNCTION*/void r377set_require(T377* C,T0* a1);
/*E_FUNCTION*/T0* r377obsolete_warning_check_memory(void);
/*E_FUNCTION*/void r377set_rescue_compound(T377* C,T0* a1);
/*E_FUNCTION*/T0* r377specialize_body_in(T377* C,T0* a1,T6 a2);
/*E_FUNCTION*/void r377obsolete_warning_check(T377* C,T0* a1,T296 a2);
/*E_FUNCTION*/T6 r377_P_305_same_body_as(T377* C,T0* a1);
/*E_PROCEDURE*/T0* r375left_most_current_direct_call_0_sequence_inline(T0* a1,T0* a2,T0* a3,T0* a4);
/*E_PROCEDURE*/T6 r375use_current(T375* C,T0* a1);
/*E_PROCEDURE*/void r375set_ensure(T375* C,T0* a1);
/*E_PROCEDURE*/T0* r375specialized_require_thru(T375* C,T0* a1,T0* a2,T0* a3);
/*E_PROCEDURE*/T0* r375left_most_current_direct_call_0_sequence(T0* a1,T0* a2);
/*E_PROCEDURE*/T6 r375side_effect_free(T0* a1);
/*E_PROCEDURE*/T0* r375first_name(T375* C);
/*E_PROCEDURE*/void r375copy(T375* C,T0* a1);
/*E_PROCEDURE*/T0* r375inline_proc_call_1(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*E_PROCEDURE*/T0* r375inline_instruction_1(T375* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*E_PROCEDURE*/T0* r375inline_proc_call_0(T0* a1,T0* a2,T0* a3,T0* a4);
/*E_PROCEDURE*/T0* r375inline_instruction_0(T375* C,T0* a1,T0* a2,T0* a3);
/*E_PROCEDURE*/T0* r375inline_proc_call_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*E_PROCEDURE*/void r375collect_body(T375* C,T0* a1);
/*E_PROCEDURE*/T0* r375class_text(T375* C);
/*E_PROCEDURE*/T0* r375names(T375* C);
/*E_PROCEDURE*/T0* r375specialize_require_in(T375* C,T0* a1);
/*E_PROCEDURE*/void r375add_into(T375* C,T0* a1,T0* a2);
/*E_PROCEDURE*/T0* r375merge_signature_thru(T375* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*E_PROCEDURE*/T0* r375try_to_undefine(T375* C,T0* a1,T0* a2);
/*E_PROCEDURE*/void r375add_into_(T375* C,T0* a1,T0* a2);
/*E_PROCEDURE*/void r375collect(T375* C,T0* a1);
/*E_PROCEDURE*/T0* r375new_run_feature_for(T375* C,T0* a1,T0* a2);
/*E_PROCEDURE*/void r375valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*E_PROCEDURE*/void r375collect_precursor(T375* C,T0* a1,T0* a2);
/*E_PROCEDURE*/T0* r375inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*E_PROCEDURE*/T0* r375change_ensure(T375* C,T0* a1,T6 a2);
/*E_PROCEDURE*/T0* r375brand_new_run_feature_for(T375* C,T0* a1,T0* a2,T6 a3);
/*E_PROCEDURE*/T0* r375specialize_permissions(T375* C,T0* a1,T6 a2);
/*E_PROCEDURE*/T6 r375same_body_as(T375* C,T0* a1);
/*E_PROCEDURE*/T0* r375specialize_body_thru(T375* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*E_PROCEDURE*/T6 r375same_signature(T375* C,T0* a1,T0* a2);
/*E_PROCEDURE*/void r375set_header_comment(T375* C,T0* a1);
/*E_PROCEDURE*/T296 r375sedb_trace_before_exit(T375* C);
/*E_PROCEDURE*/T0* r375specialize_signature_thru(T375* C,T0* a1,T0* a2,T0* a3);
/*E_PROCEDURE*/T0* r375specialize_ensure_in(T375* C,T0* a1,T6 a2);
/*E_PROCEDURE*/T0* r375specialize_ensure_thru(T375* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*E_PROCEDURE*/void r375accept(T375* C,T0* a1);
/*E_PROCEDURE*/void r375add_into_shared(T375* C,T0* a1,T0* a2);
/*E_PROCEDURE*/void r375set_ensure_assertion(T375* C,T0* a1);
/*E_PROCEDURE*/T0* r375clients(T375* C);
/*E_PROCEDURE*/T0* r375inline_expression_1(T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*E_PROCEDURE*/T0* r375inline_expression_0(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*E_PROCEDURE*/void r375make(T375* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*E_PROCEDURE*/T0* r375twin(T375* C);
/*E_PROCEDURE*/T6 r375valid_redefinition(T375* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*E_PROCEDURE*/T0* r375change_require(T375* C,T0* a1,T6 a2);
/*E_PROCEDURE*/void r375set_require(T375* C,T0* a1);
/*E_PROCEDURE*/T0* r375obsolete_warning_check_memory(void);
/*E_PROCEDURE*/void r375set_end_comment(T375* C,T0* a1);
/*E_PROCEDURE*/T296 r375start_position(T375* C);
/*E_PROCEDURE*/void r375set_rescue_compound(T375* C,T0* a1);
/*E_PROCEDURE*/void r375init(T375* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*E_PROCEDURE*/T0* r375specialize_body_in(T375* C,T0* a1,T6 a2);
/*E_PROCEDURE*/T0* r375result_type(void);
/*E_PROCEDURE*/void r375obsolete_warning_check(T375* C,T0* a1,T296 a2);
/*E_PROCEDURE*/T0* r375specialize_2(T375* C,T0* a1);
/*E_PROCEDURE*/T0* r375simplify(T375* C,T0* a1);
/*E_PROCEDURE*/T0* r375typed_internal_local(T375* C,T0* a1,T0* a2,T296 a3,T0* a4);
/*E_PROCEDURE*/void r375make_routine(T375* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*E_PROCEDURE*/void r375set_permissions(T375* C,T0* a1);
/*E_PROCEDURE*/T0* r375specialize_signature_in(T375* C,T0* a1);
/*E_PROCEDURE*/T0* r375rescue_compound_in(T375* C,T0* a1);
/*E_PROCEDURE*/T0* r375specialized_ensure_thru(T375* C,T0* a1,T0* a2,T0* a3);
/*E_PROCEDURE*/T6 r375no_rescue_no_local_expanded_in(T375* C,T0* a1);
/*E_PROCEDURE*/T0* r375inline_instruction_n(T375* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*E_PROCEDURE*/T0* r375try_to_undefine_aux(T375* C,T0* a1,T0* a2);
/*E_PROCEDURE*/T0* r375specialize_require_thru(T375* C,T0* a1,T0* a2,T0* a3);
/*E_PROCEDURE*/T6 r375_P_305_same_body_as(T375* C,T0* a1);
T362*create362with(T0* a1,T2 a2,T0* a3,T0* a4);
/*CST_ATT_UNIQUE*/T6 r362use_current(T0* a1);
/*CST_ATT_UNIQUE*/void r362set_ensure(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/T0* r362specialized_require_thru(T362* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_UNIQUE*/T6 r362side_effect_free(T0* a1);
/*CST_ATT_UNIQUE*/T0* r362first_name(T362* C);
extern T0*oBC362counter;
/*CST_ATT_UNIQUE*/void r362copy(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/T0* r362inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_UNIQUE*/T0* r362inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*CST_ATT_UNIQUE*/void r362collect_body(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/T0* r362class_text(T362* C);
/*CST_ATT_UNIQUE*/T0* r362names(T362* C);
/*CST_ATT_UNIQUE*/T0* r362specialize_require_in(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/void r362add_into(T362* C,T0* a1,T0* a2);
/*CST_ATT_UNIQUE*/T0* r362merge_signature_thru(T362* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*CST_ATT_UNIQUE*/T0* r362try_to_undefine(T362* C,T0* a1,T0* a2);
/*CST_ATT_UNIQUE*/void r362add_into_(T362* C,T0* a1,T0* a2);
/*CST_ATT_UNIQUE*/void r362collect(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/T0* r362new_run_feature_for(T362* C,T0* a1,T0* a2);
/*CST_ATT_UNIQUE*/void r362valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_UNIQUE*/void r362collect_precursor(T362* C,T0* a1,T0* a2);
/*CST_ATT_UNIQUE*/T0* r362inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*CST_ATT_UNIQUE*/T0* r362change_ensure(T362* C,T0* a1,T6 a2);
/*CST_ATT_UNIQUE*/T0* r362brand_new_run_feature_for(T362* C,T0* a1,T0* a2,T6 a3);
/*CST_ATT_UNIQUE*/T0* r362specialize_permissions(T362* C,T0* a1,T6 a2);
/*CST_ATT_UNIQUE*/T6 r362same_body_as(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/T0* r362specialize_body_thru(T362* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*CST_ATT_UNIQUE*/T6 r362same_signature(T362* C,T0* a1,T0* a2);
/*CST_ATT_UNIQUE*/void r362set_header_comment(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/T0* r362specialize_signature_thru(T362* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_UNIQUE*/T0* r362specialize_ensure_in(T362* C,T0* a1,T6 a2);
/*CST_ATT_UNIQUE*/T0* r362specialize_ensure_thru(T362* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*CST_ATT_UNIQUE*/void r362accept(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/void r362set_ensure_assertion(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/T0* r362arguments(void);
/*CST_ATT_UNIQUE*/T0* r362clients(T362* C);
/*CST_ATT_UNIQUE*/T0* r362inline_expression_1(T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*CST_ATT_UNIQUE*/T0* r362inline_expression_0(T362* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*CST_ATT_UNIQUE*/void r362make(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/T0* r362twin(T362* C);
/*CST_ATT_UNIQUE*/T6 r362valid_redefinition(T362* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_UNIQUE*/T0* r362change_require(T362* C,T0* a1,T6 a2);
/*CST_ATT_UNIQUE*/void r362set_require(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/T0* r362obsolete_warning_check_memory(void);
/*CST_ATT_UNIQUE*/T296 r362start_position(T362* C);
/*CST_ATT_UNIQUE*/void r362set_rescue_compound(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/T0* r362specialize_body_in(T362* C,T0* a1,T6 a2);
/*CST_ATT_UNIQUE*/T0* r362value(T362* C);
/*CST_ATT_UNIQUE*/void r362obsolete_warning_check(T362* C,T0* a1,T296 a2);
/*CST_ATT_UNIQUE*/T0* r362specialize_2(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/T0* r362simplify(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/void r362with(T362* C,T0* a1,T2 a2,T0* a3,T0* a4);
/*CST_ATT_UNIQUE*/void r362set_permissions(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/T0* r362specialize_signature_in(T362* C,T0* a1);
/*CST_ATT_UNIQUE*/T0* r362specialized_ensure_thru(T362* C,T0* a1,T0* a2,T0* a3);
/*CST_ATT_UNIQUE*/T0* r362inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*CST_ATT_UNIQUE*/T0* r362try_to_undefine_aux(T362* C,T0* a1,T0* a2);
/*CST_ATT_UNIQUE*/T0* r362specialize_require_thru(T362* C,T0* a1,T0* a2,T0* a3);
/*EXTERNAL_FUNCTION*/void r379copy(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379typed_internal_local(T379* C,T0* a1,T0* a2,T296 a3,T0* a4);
/*EXTERNAL_FUNCTION*/void r379make_routine(T379* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*EXTERNAL_FUNCTION*/T0* r379current_or_twin_init_no_body(T379* C,T0* a1,T6 a2,T0* a3,T0* a4,T6 a5);
/*EXTERNAL_FUNCTION*/void r379make_external_routine(T379* C,T0* a1,T0* a2);
/*EXTERNAL_FUNCTION*/void r379set_routine_body(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T6 r379use_current(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379adapt_routine_body_for(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T6 r379side_effect_free(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379external_name(T379* C);
/*EXTERNAL_FUNCTION*/T2 r379argument_rank_of(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379c_plus_plus_name(T379* C);
/*EXTERNAL_FUNCTION*/T0* r379current_or_twin_init(T379* C,T0* a1,T0* a2,T6 a3,T0* a4,T0* a5,T6 a6);
/*EXTERNAL_FUNCTION*/T0* r379true_or_false(T6 a1,T296 a2);
/*EXTERNAL_FUNCTION*/void r379accept(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379twin(T379* C);
/*EXTERNAL_FUNCTION*/void r379make(T379* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*EXTERNAL_FUNCTION*/void r379init(T379* C,T0* a1,T0* a2,T6 a3,T0* a4,T0* a5);
/*EXTERNAL_FUNCTION*/T296 r379start_position(T379* C);
/*EXTERNAL_FUNCTION*/T0* r379specialize_2(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379simplify(T379* C,T0* a1);
extern T0*oBC28introspection_handler;
/*EXTERNAL_FUNCTION*/void r379set_permissions(T379* C,T0* a1);
extern T0*oBC28clear_all_name;
extern int fBC28clear_all_name;
/*EXTERNAL_FUNCTION*/T0* r379clear_all_name(void);
/*EXTERNAL_FUNCTION*/T0* r379specialize_signature_in(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379specialized_ensure_thru(T379* C,T0* a1,T0* a2,T0* a3);
/*EXTERNAL_FUNCTION*/T0* r379inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*EXTERNAL_FUNCTION*/T0* r379class_text(T379* C);
/*EXTERNAL_FUNCTION*/T0* r379try_to_undefine_aux(T379* C,T0* a1,T0* a2);
/*EXTERNAL_FUNCTION*/void r379collect(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379specialize_require_thru(T379* C,T0* a1,T0* a2,T0* a3);
/*EXTERNAL_FUNCTION*/void r379set_ensure(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379specialized_require_thru(T379* C,T0* a1,T0* a2,T0* a3);
/*EXTERNAL_FUNCTION*/T0* r379first_name(T379* C);
/*EXTERNAL_FUNCTION*/T0* r379inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*EXTERNAL_FUNCTION*/T0* r379inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*EXTERNAL_FUNCTION*/void r379collect_body(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379names(T379* C);
/*EXTERNAL_FUNCTION*/T0* r379specialize_require_in(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/void r379add_into(T379* C,T0* a1,T0* a2);
/*EXTERNAL_FUNCTION*/T0* r379merge_signature_thru(T379* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*EXTERNAL_FUNCTION*/T0* r379try_to_undefine(T379* C,T0* a1,T0* a2);
/*EXTERNAL_FUNCTION*/void r379add_into_(T379* C,T0* a1,T0* a2);
/*EXTERNAL_FUNCTION*/T0* r379new_run_feature_for(T379* C,T0* a1,T0* a2);
/*EXTERNAL_FUNCTION*/void r379valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*EXTERNAL_FUNCTION*/void r379collect_precursor(T379* C,T0* a1,T0* a2);
/*EXTERNAL_FUNCTION*/T0* r379inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*EXTERNAL_FUNCTION*/T0* r379change_ensure(T379* C,T0* a1,T6 a2);
/*EXTERNAL_FUNCTION*/T0* r379brand_new_run_feature_for(T379* C,T0* a1,T0* a2,T6 a3);
/*EXTERNAL_FUNCTION*/T0* r379specialize_permissions(T379* C,T0* a1,T6 a2);
/*EXTERNAL_FUNCTION*/void r379hook_collect(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T6 r379same_body_as(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379specialize_body_thru(T379* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*EXTERNAL_FUNCTION*/T6 r379same_signature(T379* C,T0* a1,T0* a2);
/*EXTERNAL_FUNCTION*/void r379set_header_comment(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T296 r379sedb_trace_before_exit(T379* C);
/*EXTERNAL_FUNCTION*/T0* r379specialize_signature_thru(T379* C,T0* a1,T0* a2,T0* a3);
/*EXTERNAL_FUNCTION*/T0* r379specialize_ensure_in(T379* C,T0* a1,T6 a2);
/*EXTERNAL_FUNCTION*/T0* r379specialize_ensure_thru(T379* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*EXTERNAL_FUNCTION*/void r379add_into_shared(T379* C,T0* a1,T0* a2);
/*EXTERNAL_FUNCTION*/void r379set_ensure_assertion(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379clients(T379* C);
/*EXTERNAL_FUNCTION*/T0* r379inline_expression_1(T379* C,T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*EXTERNAL_FUNCTION*/T0* r379inline_expression_0(T379* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*EXTERNAL_FUNCTION*/T6 r379valid_redefinition(T379* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*EXTERNAL_FUNCTION*/void r379set_end_comment(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379change_require(T379* C,T0* a1,T6 a2);
/*EXTERNAL_FUNCTION*/void r379set_require(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379obsolete_warning_check_memory(void);
/*EXTERNAL_FUNCTION*/void r379set_rescue_compound(T379* C,T0* a1);
/*EXTERNAL_FUNCTION*/T0* r379specialize_body_in(T379* C,T0* a1,T6 a2);
extern T0*oBC28copy_name;
extern int fBC28copy_name;
/*EXTERNAL_FUNCTION*/T0* r379copy_name(void);
extern T0*oBC28any_copy_fs;
extern int fBC28any_copy_fs;
/*EXTERNAL_FUNCTION*/T0* r379any_copy_fs(void);
/*EXTERNAL_FUNCTION*/void r379obsolete_warning_check(T379* C,T0* a1,T296 a2);
/*EXTERNAL_PROCEDURE*/void r371copy(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371typed_internal_local(T371* C,T0* a1,T0* a2,T296 a3,T0* a4);
/*EXTERNAL_PROCEDURE*/void r371make_routine(T371* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*EXTERNAL_PROCEDURE*/T0* r371current_or_twin_init_no_body(T371* C,T0* a1,T6 a2,T0* a3,T0* a4,T6 a5);
/*EXTERNAL_PROCEDURE*/void r371make_external_routine(T371* C,T0* a1,T0* a2);
/*EXTERNAL_PROCEDURE*/void r371set_routine_body(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T6 r371use_current(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371adapt_routine_body_for(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T6 r371side_effect_free(T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371external_name(T371* C);
/*EXTERNAL_PROCEDURE*/T2 r371argument_rank_of(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371c_plus_plus_name(T371* C);
/*EXTERNAL_PROCEDURE*/T0* r371current_or_twin_init(T371* C,T0* a1,T0* a2,T6 a3,T0* a4,T0* a5,T6 a6);
/*EXTERNAL_PROCEDURE*/void r371accept(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371twin(T371* C);
/*EXTERNAL_PROCEDURE*/void r371make(T371* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*EXTERNAL_PROCEDURE*/void r371init(T371* C,T0* a1,T0* a2,T6 a3,T0* a4,T0* a5);
/*EXTERNAL_PROCEDURE*/T296 r371start_position(T371* C);
/*EXTERNAL_PROCEDURE*/T0* r371specialize_2(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371simplify(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371result_type(void);
/*EXTERNAL_PROCEDURE*/void r371set_permissions(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371specialize_signature_in(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371specialized_ensure_thru(T371* C,T0* a1,T0* a2,T0* a3);
/*EXTERNAL_PROCEDURE*/T0* r371inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*EXTERNAL_PROCEDURE*/T0* r371class_text(T371* C);
/*EXTERNAL_PROCEDURE*/T0* r371try_to_undefine_aux(T371* C,T0* a1,T0* a2);
/*EXTERNAL_PROCEDURE*/void r371collect(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371specialize_require_thru(T371* C,T0* a1,T0* a2,T0* a3);
/*EXTERNAL_PROCEDURE*/void r371set_ensure(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371specialized_require_thru(T371* C,T0* a1,T0* a2,T0* a3);
/*EXTERNAL_PROCEDURE*/T0* r371first_name(T371* C);
/*EXTERNAL_PROCEDURE*/T0* r371inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*EXTERNAL_PROCEDURE*/T0* r371inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*EXTERNAL_PROCEDURE*/void r371collect_body(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371names(T371* C);
/*EXTERNAL_PROCEDURE*/T0* r371specialize_require_in(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/void r371add_into(T371* C,T0* a1,T0* a2);
/*EXTERNAL_PROCEDURE*/T0* r371merge_signature_thru(T371* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*EXTERNAL_PROCEDURE*/T0* r371try_to_undefine(T371* C,T0* a1,T0* a2);
/*EXTERNAL_PROCEDURE*/void r371add_into_(T371* C,T0* a1,T0* a2);
/*EXTERNAL_PROCEDURE*/T0* r371new_run_feature_for(T371* C,T0* a1,T0* a2);
/*EXTERNAL_PROCEDURE*/void r371valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*EXTERNAL_PROCEDURE*/void r371collect_precursor(T371* C,T0* a1,T0* a2);
/*EXTERNAL_PROCEDURE*/T0* r371inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*EXTERNAL_PROCEDURE*/T0* r371change_ensure(T371* C,T0* a1,T6 a2);
/*EXTERNAL_PROCEDURE*/T0* r371brand_new_run_feature_for(T371* C,T0* a1,T0* a2,T6 a3);
/*EXTERNAL_PROCEDURE*/T0* r371specialize_permissions(T371* C,T0* a1,T6 a2);
/*EXTERNAL_PROCEDURE*/void r371hook_collect(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T6 r371same_body_as(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371specialize_body_thru(T371* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*EXTERNAL_PROCEDURE*/T6 r371same_signature(T371* C,T0* a1,T0* a2);
/*EXTERNAL_PROCEDURE*/void r371set_header_comment(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T296 r371sedb_trace_before_exit(T371* C);
/*EXTERNAL_PROCEDURE*/T0* r371specialize_signature_thru(T371* C,T0* a1,T0* a2,T0* a3);
/*EXTERNAL_PROCEDURE*/T0* r371specialize_ensure_in(T371* C,T0* a1,T6 a2);
/*EXTERNAL_PROCEDURE*/T0* r371specialize_ensure_thru(T371* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*EXTERNAL_PROCEDURE*/void r371add_into_shared(T371* C,T0* a1,T0* a2);
/*EXTERNAL_PROCEDURE*/void r371set_ensure_assertion(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371clients(T371* C);
/*EXTERNAL_PROCEDURE*/T0* r371inline_expression_1(T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*EXTERNAL_PROCEDURE*/T0* r371inline_expression_0(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*EXTERNAL_PROCEDURE*/T6 r371valid_redefinition(T371* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*EXTERNAL_PROCEDURE*/void r371set_end_comment(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371change_require(T371* C,T0* a1,T6 a2);
/*EXTERNAL_PROCEDURE*/void r371set_require(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371obsolete_warning_check_memory(void);
/*EXTERNAL_PROCEDURE*/void r371set_rescue_compound(T371* C,T0* a1);
/*EXTERNAL_PROCEDURE*/T0* r371specialize_body_in(T371* C,T0* a1,T6 a2);
/*EXTERNAL_PROCEDURE*/void r371obsolete_warning_check(T371* C,T0* a1,T296 a2);
/*DEFERRED_FUNCTION*/T6 r376use_current(T0* a1);
/*DEFERRED_FUNCTION*/void r376set_ensure(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/T0* r376specialized_require_thru(T376* C,T0* a1,T0* a2,T0* a3);
/*DEFERRED_FUNCTION*/T6 r376side_effect_free(T0* a1);
/*DEFERRED_FUNCTION*/T0* r376first_name(T376* C);
/*DEFERRED_FUNCTION*/void r376copy(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/T0* r376inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*DEFERRED_FUNCTION*/T0* r376inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*DEFERRED_FUNCTION*/T0* r376class_text(T376* C);
/*DEFERRED_FUNCTION*/T0* r376names(T376* C);
/*DEFERRED_FUNCTION*/T0* r376specialize_require_in(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/void r376add_into(T376* C,T0* a1,T0* a2);
/*DEFERRED_FUNCTION*/T0* r376merge_signature_thru(T376* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*DEFERRED_FUNCTION*/T0* r376try_to_undefine(T376* C,T0* a1,T0* a2);
/*DEFERRED_FUNCTION*/void r376add_into_(T376* C,T0* a1,T0* a2);
/*DEFERRED_FUNCTION*/void r376collect(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/T0* r376new_run_feature_for(T376* C,T0* a1,T0* a2);
/*DEFERRED_FUNCTION*/void r376valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*DEFERRED_FUNCTION*/void r376collect_precursor(T376* C,T0* a1,T0* a2);
/*DEFERRED_FUNCTION*/T0* r376inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*DEFERRED_FUNCTION*/T0* r376change_ensure(T376* C,T0* a1,T6 a2);
/*DEFERRED_FUNCTION*/T0* r376brand_new_run_feature_for(T376* C,T0* a1,T0* a2,T6 a3);
/*DEFERRED_FUNCTION*/T0* r376specialize_permissions(T376* C,T0* a1,T6 a2);
/*DEFERRED_FUNCTION*/T6 r376same_body_as(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/T0* r376specialize_body_thru(T376* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*DEFERRED_FUNCTION*/T6 r376same_signature(T376* C,T0* a1,T0* a2);
/*DEFERRED_FUNCTION*/void r376set_header_comment(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/T296 r376sedb_trace_before_exit(T376* C);
/*DEFERRED_FUNCTION*/T0* r376specialize_signature_thru(T376* C,T0* a1,T0* a2,T0* a3);
/*DEFERRED_FUNCTION*/T0* r376specialize_ensure_in(T376* C,T0* a1,T6 a2);
/*DEFERRED_FUNCTION*/T0* r376specialize_ensure_thru(T376* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*DEFERRED_FUNCTION*/void r376accept(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/void r376add_into_shared(T376* C,T0* a1,T0* a2);
/*DEFERRED_FUNCTION*/void r376set_ensure_assertion(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/T0* r376clients(T376* C);
/*DEFERRED_FUNCTION*/T0* r376inline_expression_1(T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*DEFERRED_FUNCTION*/T0* r376inline_expression_0(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*DEFERRED_FUNCTION*/void r376make(T376* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*DEFERRED_FUNCTION*/T0* r376twin(T376* C);
/*DEFERRED_FUNCTION*/T6 r376valid_redefinition(T376* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*DEFERRED_FUNCTION*/T0* r376change_require(T376* C,T0* a1,T6 a2);
/*DEFERRED_FUNCTION*/void r376set_require(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/T0* r376obsolete_warning_check_memory(void);
/*DEFERRED_FUNCTION*/void r376set_end_comment(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/T296 r376start_position(T376* C);
/*DEFERRED_FUNCTION*/void r376set_rescue_compound(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/T0* r376specialize_body_in(T376* C,T0* a1,T6 a2);
/*DEFERRED_FUNCTION*/void r376obsolete_warning_check(T376* C,T0* a1,T296 a2);
/*DEFERRED_FUNCTION*/T0* r376specialize_2(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/T0* r376simplify(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/T0* r376typed_internal_local(T376* C,T0* a1,T0* a2,T296 a3,T0* a4);
/*DEFERRED_FUNCTION*/void r376from_effective(T376* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*DEFERRED_FUNCTION*/void r376make_routine(T376* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*DEFERRED_FUNCTION*/void r376set_permissions(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/T0* r376specialize_signature_in(T376* C,T0* a1);
/*DEFERRED_FUNCTION*/T0* r376specialized_ensure_thru(T376* C,T0* a1,T0* a2,T0* a3);
/*DEFERRED_FUNCTION*/T0* r376inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*DEFERRED_FUNCTION*/T0* r376try_to_undefine_aux(T376* C,T0* a1,T0* a2);
/*DEFERRED_FUNCTION*/T0* r376specialize_require_thru(T376* C,T0* a1,T0* a2,T0* a3);
/*DEFERRED_PROCEDURE*/T6 r366use_current(T0* a1);
/*DEFERRED_PROCEDURE*/void r366set_ensure(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/T0* r366specialized_require_thru(T366* C,T0* a1,T0* a2,T0* a3);
/*DEFERRED_PROCEDURE*/T6 r366side_effect_free(T0* a1);
/*DEFERRED_PROCEDURE*/T0* r366first_name(T366* C);
/*DEFERRED_PROCEDURE*/void r366copy(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/T0* r366inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*DEFERRED_PROCEDURE*/T0* r366inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*DEFERRED_PROCEDURE*/T0* r366class_text(T366* C);
/*DEFERRED_PROCEDURE*/T0* r366names(T366* C);
/*DEFERRED_PROCEDURE*/T0* r366specialize_require_in(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/void r366add_into(T366* C,T0* a1,T0* a2);
/*DEFERRED_PROCEDURE*/T0* r366merge_signature_thru(T366* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*DEFERRED_PROCEDURE*/T0* r366try_to_undefine(T366* C,T0* a1,T0* a2);
/*DEFERRED_PROCEDURE*/void r366add_into_(T366* C,T0* a1,T0* a2);
/*DEFERRED_PROCEDURE*/void r366collect(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/T0* r366new_run_feature_for(T366* C,T0* a1,T0* a2);
/*DEFERRED_PROCEDURE*/void r366valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*DEFERRED_PROCEDURE*/void r366collect_precursor(T366* C,T0* a1,T0* a2);
/*DEFERRED_PROCEDURE*/T0* r366inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*DEFERRED_PROCEDURE*/T0* r366change_ensure(T366* C,T0* a1,T6 a2);
/*DEFERRED_PROCEDURE*/T0* r366brand_new_run_feature_for(T366* C,T0* a1,T0* a2,T6 a3);
/*DEFERRED_PROCEDURE*/T0* r366specialize_permissions(T366* C,T0* a1,T6 a2);
/*DEFERRED_PROCEDURE*/T6 r366same_body_as(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/T0* r366specialize_body_thru(T366* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*DEFERRED_PROCEDURE*/T6 r366same_signature(T366* C,T0* a1,T0* a2);
/*DEFERRED_PROCEDURE*/void r366set_header_comment(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/T296 r366sedb_trace_before_exit(T366* C);
/*DEFERRED_PROCEDURE*/T0* r366specialize_signature_thru(T366* C,T0* a1,T0* a2,T0* a3);
/*DEFERRED_PROCEDURE*/T0* r366specialize_ensure_in(T366* C,T0* a1,T6 a2);
/*DEFERRED_PROCEDURE*/T0* r366specialize_ensure_thru(T366* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*DEFERRED_PROCEDURE*/void r366accept(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/void r366add_into_shared(T366* C,T0* a1,T0* a2);
/*DEFERRED_PROCEDURE*/void r366set_ensure_assertion(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/T0* r366clients(T366* C);
/*DEFERRED_PROCEDURE*/T0* r366inline_expression_1(T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*DEFERRED_PROCEDURE*/T0* r366inline_expression_0(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*DEFERRED_PROCEDURE*/void r366make(T366* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*DEFERRED_PROCEDURE*/T0* r366twin(T366* C);
/*DEFERRED_PROCEDURE*/T6 r366valid_redefinition(T366* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*DEFERRED_PROCEDURE*/T0* r366change_require(T366* C,T0* a1,T6 a2);
/*DEFERRED_PROCEDURE*/void r366set_require(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/T0* r366obsolete_warning_check_memory(void);
/*DEFERRED_PROCEDURE*/void r366set_end_comment(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/T296 r366start_position(T366* C);
/*DEFERRED_PROCEDURE*/void r366set_rescue_compound(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/T0* r366specialize_body_in(T366* C,T0* a1,T6 a2);
/*DEFERRED_PROCEDURE*/T0* r366result_type(void);
/*DEFERRED_PROCEDURE*/void r366obsolete_warning_check(T366* C,T0* a1,T296 a2);
/*DEFERRED_PROCEDURE*/T0* r366specialize_2(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/T0* r366simplify(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/T0* r366typed_internal_local(T366* C,T0* a1,T0* a2,T296 a3,T0* a4);
/*DEFERRED_PROCEDURE*/void r366from_effective(T366* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*DEFERRED_PROCEDURE*/void r366make_routine(T366* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*DEFERRED_PROCEDURE*/void r366set_permissions(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/T0* r366specialize_signature_in(T366* C,T0* a1);
/*DEFERRED_PROCEDURE*/T0* r366specialized_ensure_thru(T366* C,T0* a1,T0* a2,T0* a3);
/*DEFERRED_PROCEDURE*/T0* r366inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*DEFERRED_PROCEDURE*/T0* r366try_to_undefine_aux(T366* C,T0* a1,T0* a2);
/*DEFERRED_PROCEDURE*/T0* r366specialize_require_thru(T366* C,T0* a1,T0* a2,T0* a3);
/*AGENT_CREATION_HELPER*/void r630visit_fake_target(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_assignment_test(T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_n(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_and(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_div(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_or_else(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_times(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_int_rem(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_power(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_and_then(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_plus(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_xor(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_ge(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_gt(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_le(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_lt(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_int_div(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_or(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_minus(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_freeop(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_infix_implies(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_1_c(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_static_call_0_c(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_prefix_not(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_prefix_plus(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_prefix_freeop(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_prefix_minus(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call_0_c(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_implicit_cast(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/T6 r630is_open_operand(T0* a1);
/*AGENT_CREATION_HELPER*/void r630push_pop(T630* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*AGENT_CREATION_HELPER*/void r630limitation_error(T0* a1);
/*AGENT_CREATION_HELPER*/void r630syntactical_flat_check_(T630* C,T0* a1,T0* a2);
extern T0*oBC630target_stack;
extern int fBC630target_stack;
/*AGENT_CREATION_HELPER*/T0* r630target_stack(void);
/*AGENT_CREATION_HELPER*/void r630resolve_open_operands(T630* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*AGENT_CREATION_HELPER*/void r630visit_expression_with_comment(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630search_open_argument_in(T630* C,T0* a1);
extern T0*oBC630target_type_stack;
extern int fBC630target_type_stack;
/*AGENT_CREATION_HELPER*/T0* r630target_type_stack(void);
/*AGENT_CREATION_HELPER*/void r630visit_open_operand(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630syntactical_flat_check(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_agent_expression(T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_e_old(T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_manifest_generic(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_effective_arg_list(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_built_in_eq_neq(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_manifest_tuple(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_precursor_expression(T0* a1);
/*AGENT_CREATION_HELPER*/void r630under_agent_scope_notify(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_create_expression(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_fast_array_of_expression(T630* C,T0* a1);
/*AGENT_CREATION_HELPER*/void r630visit_call(T630* C,T0* a1);
extern T0*oBC630anonymous_feature_stack;
extern int fBC630anonymous_feature_stack;
/*AGENT_CREATION_HELPER*/T0* r630anonymous_feature_stack(void);
/*AGENT_EQUAL*/void r629c_define_type(T629* C,T0* a1);
/*AGENT_EQUAL*/void r629c_define_function(T629* C,T0* a1);
extern T0*oBC629function_generated;
extern int fBC629function_generated;
/*AGENT_EQUAL*/T0* r629function_generated(void);
extern T0*oBC629type_generated;
extern int fBC629type_generated;
/*AGENT_EQUAL*/T0* r629type_generated(void);
/*AGENT_EQUAL*/void r629compute_mold_id(T629* C,T0* a1);
/*AGENT_EQUAL*/void r629make(T629* C);
/*AGENT_EQUAL*/void r629set_call(T629* C,T0* a1,T0* a2);
/*CECIL_ENTRY*/T0* r294any_default_create_fs(void);
/*CECIL_ENTRY*/void r294collect(T294* C);
/*CECIL_ENTRY*/void r294on_echo(T294* C,T0* a1);
/*CECIL_ENTRY*/T0* r294run_feature(T294* C);
/*CECIL_ENTRY*/void r294get_started(T294* C,T0* a1);
/*CECIL_ENTRY*/void r294make(T294* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*CECIL_ENTRY*/T0* r294echo(void);
/*CECIL_ENTRY*/T0* r294default_create_name(void);
/*WRITABLE_ATTRIBUTE_NAME*/void r416copy(T416* C,T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0* r416non_void_no_dispatch_type(T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/T6 r416is_equal(T416* C,T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/void r416set_feature_stamp_and_type(T416* C,T0* a1,T0* a2);
/*WRITABLE_ATTRIBUTE_NAME*/T0* r416specialize_2(T416* C,T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0* r416static_simplify(T416* C);
/*WRITABLE_ATTRIBUTE_NAME*/T0* r416simplify(T416* C,T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0* r416collect(T416* C,T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0* r416specialize_thru(T416* C,T0* a1,T0* a2,T0* a3);
/*WRITABLE_ATTRIBUTE_NAME*/void r416compile_to_c_with_internal_c_local_saving(T416* C,T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0* r416specialize_in(T416* C,T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0* r416feature_accumulator(void);
/*WRITABLE_ATTRIBUTE_NAME*/void r416compile_to_c(T416* C,T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/T6 r416use_current(T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/T6 r416side_effect_free(T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/void r416accept(T416* C,T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0* r416adapt_for(T416* C,T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0* r416resolve_in(T416* C,T0* a1);
/*WRITABLE_ATTRIBUTE_NAME*/void r416make(T416* C,T0* a1,T296 a2);
/*WRITABLE_ATTRIBUTE_NAME*/T0* r416twin(T416* C);
/*WRITABLE_ATTRIBUTE_NAME*/void r416pretty(T416* C,T2 a1);
/*WRITABLE_ATTRIBUTE_NAME*/T296 r416start_position(T416* C);
/*WRITABLE_ATTRIBUTE_NAME*/void r416bracketed_pretty(T416* C,T2 a1);
/*WRITABLE_ATTRIBUTE_NAME*/T2 r416precedence(void);
/*WRITABLE_ATTRIBUTE_NAME*/T6 r416is_default_value(void);
/*TAG_NAME*/void r533make(T533* C,T0* a1,T296 a2);
/*LOCAL_NAME2*/void r422mapping_c_target(T422* C,T0* a1,T0* a2);
/*LOCAL_NAME2*/void r422pretty_target(T422* C,T2 a1);
/*LOCAL_NAME2*/void r422standard_mapping_c_target(T422* C,T0* a1,T0* a2);
/*LOCAL_NAME2*/void r422copy(T422* C,T0* a1);
/*LOCAL_NAME2*/T0* r422non_void_no_dispatch_type(T422* C,T0* a1);
/*LOCAL_NAME2*/T6 r422is_equal(T422* C,T0* a1);
/*LOCAL_NAME2*/T0* r422specialize_2(T422* C,T0* a1);
/*LOCAL_NAME2*/T0* r422static_simplify(T422* C);
/*LOCAL_NAME2*/T0* r422simplify(T422* C,T0* a1);
/*LOCAL_NAME2*/T0* r422collect(T422* C,T0* a1);
/*LOCAL_NAME2*/T0* r422specialize_thru(T422* C,T0* a1,T0* a2,T0* a3);
/*LOCAL_NAME2*/void r422refer_to(T422* C,T296 a1,T0* a2,T2 a3);
/*LOCAL_NAME2*/void r422compile_to_c_with_internal_c_local_saving(T422* C,T0* a1);
/*LOCAL_NAME2*/T0* r422specialize_in(T422* C,T0* a1);
/*LOCAL_NAME2*/void r422compile_to_c(T422* C,T0* a1);
/*LOCAL_NAME2*/T6 r422use_current(T0* a1);
/*LOCAL_NAME2*/T6 r422side_effect_free(T0* a1);
/*LOCAL_NAME2*/void r422accept(T422* C,T0* a1);
/*LOCAL_NAME2*/T0* r422to_string(T422* C);
/*LOCAL_NAME2*/T0* r422adapt_for(T422* C,T0* a1);
/*LOCAL_NAME2*/T0* r422resolve_in(T422* C,T0* a1);
/*LOCAL_NAME2*/T0* r422twin(T422* C);
/*LOCAL_NAME2*/void r422pretty(T422* C,T2 a1);
/*LOCAL_NAME2*/void r422mapping_c_arg(T422* C,T0* a1);
/*LOCAL_NAME2*/void r422bracketed_pretty(T422* C,T2 a1);
/*LOCAL_NAME2*/T2 r422precedence(void);
/*LOCAL_NAME2*/T6 r422is_default_value(void);
/*ARGUMENT_NAME2*/void r467mapping_c_target(T467* C,T0* a1,T0* a2);
/*ARGUMENT_NAME2*/void r467pretty_target(T467* C,T2 a1);
/*ARGUMENT_NAME2*/void r467standard_mapping_c_target(T467* C,T0* a1,T0* a2);
/*ARGUMENT_NAME2*/void r467copy(T467* C,T0* a1);
/*ARGUMENT_NAME2*/T0* r467non_void_no_dispatch_type(T467* C,T0* a1);
/*ARGUMENT_NAME2*/T6 r467is_equal(T467* C,T0* a1);
/*ARGUMENT_NAME2*/T0* r467specialize_2(T467* C,T0* a1);
/*ARGUMENT_NAME2*/T0* r467static_simplify(T467* C);
/*ARGUMENT_NAME2*/T0* r467simplify(T467* C,T0* a1);
/*ARGUMENT_NAME2*/T0* r467collect(T467* C,T0* a1);
/*ARGUMENT_NAME2*/T0* r467specialize_thru(T467* C,T0* a1,T0* a2,T0* a3);
/*ARGUMENT_NAME2*/void r467refer_to(T467* C,T296 a1,T0* a2,T2 a3);
/*ARGUMENT_NAME2*/void r467compile_to_c_with_internal_c_local_saving(T467* C,T0* a1);
/*ARGUMENT_NAME2*/T0* r467specialize_in(T467* C,T0* a1);
/*ARGUMENT_NAME2*/T0* r467feature_accumulator(void);
/*ARGUMENT_NAME2*/void r467compile_to_c(T467* C,T0* a1);
/*ARGUMENT_NAME2*/T6 r467use_current(T0* a1);
/*ARGUMENT_NAME2*/T6 r467side_effect_free(T0* a1);
/*ARGUMENT_NAME2*/void r467accept(T467* C,T0* a1);
/*ARGUMENT_NAME2*/T0* r467to_string(T467* C);
/*ARGUMENT_NAME2*/T0* r467adapt_for(T467* C,T0* a1);
/*ARGUMENT_NAME2*/T0* r467resolve_in(T467* C,T0* a1);
/*ARGUMENT_NAME2*/T0* r467written_declaration_type_mark(void);
/*ARGUMENT_NAME2*/T0* r467twin(T467* C);
/*ARGUMENT_NAME2*/void r467pretty(T467* C,T2 a1);
/*ARGUMENT_NAME2*/void r467mapping_c_arg(T467* C,T0* a1);
/*ARGUMENT_NAME2*/void r467bracketed_pretty(T467* C,T2 a1);
/*ARGUMENT_NAME2*/T2 r467precedence(void);
/*ARGUMENT_NAME2*/T6 r467is_default_value(void);
/*LOADPATH*/void r622set_parent(T622* C,T0* a1);
/*LOADPATH*/void r622clusters_of(T622* C,T0* a1,T6 a2,T0* a3,T0* a4,T0* a5,T2 a6);
/*LOADPATH*/T0* r622classes_path_to_system_path(T622* C,T0* a1);
extern T0*oBC351system_notation;
extern int fBC351system_notation;
/*LOADPATH*/T0* r622system_notation(T622* C);
/*LOADPATH*/T2 r622cluster_count(T622* C);
/*LOADPATH*/T0* r622find_physical_cluster(T622* C,T0* a1);
extern T0*oBC351classes_notation;
/*LOADPATH*/void r622show_tabs(T2 a1);
/*LOADPATH*/void r622show_name(T622* C);
/*LOADPATH*/T0* r622strings(void);
/*LOADPATH*/void r622add_classes(T622* C,T0* a1);
/*LOADPATH*/T0* r622new_path(T0* a1,T0* a2,T0* a3);
/*LOADPATH*/void r622error_cycle(T622* C);
extern T0*oBC622connected;
extern int fBC622connected;
/*LOADPATH*/T0* r622connected(void);
/*LOADPATH*/T0* r622system_tools(void);
extern T0*oBC622files;
extern int fBC622files;
/*LOADPATH*/T0* r622files(void);
/*LOADPATH*/void r622create_subtree(T622* C,T0* a1,T0* a2,T0* a3);
/*LOADPATH*/void r622show_cycle(T622* C,T0* a1);
/*LOADPATH*/void r622generic_formal_arguments_check(T622* C);
/*LOADPATH*/T0* r622connect(T622* C,T0* a1,T0* a2);
/*LOADPATH*/void r622show(T622* C,T2 a1);
/*LOADPATH*/T0* r622cluster_named(T622* C,T0* a1);
/*LOADPATH*/void r622for_all(T622* C,T0* a1);
/*LOADPATH*/void r622view_in(T622* C,T0* a1);
/*LOADPATH*/void r622get_started(T622* C,T2 a1);
/*LOADPATH*/void r622parse_include(T622* C);
/*LOADPATH*/T2 r622loaded_class_count(T622* C);
/*LOADPATH*/T0* r622to_string(T622* C);
/*LOADPATH*/void r622make(T622* C,T2 a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*LOADPATH*/T0* r622new_name(T622* C,T0* a1,T2 a2);
/*LOADPATH*/T0* r622echo(void);
/*LOADPATH*/T0* r622system_path_to_classes_path(T622* C,T0* a1);
/*CLASSES_TREE*/void r583set_parent(T583* C,T0* a1);
/*CLASSES_TREE*/void r583clusters_of(T583* C,T0* a1,T6 a2,T0* a3,T0* a4,T0* a5,T2 a6);
/*CLASSES_TREE*/T0* r583classes_path_to_system_path(T583* C,T0* a1);
/*CLASSES_TREE*/T0* r583system_notation(T583* C);
/*CLASSES_TREE*/T2 r583cluster_count(T583* C);
/*CLASSES_TREE*/T0* r583find_physical_cluster(T583* C,T0* a1);
/*CLASSES_TREE*/void r583show_tabs(T2 a1);
/*CLASSES_TREE*/void r583show_name(T583* C);
/*CLASSES_TREE*/void r583generic_formal_arguments_check(T583* C);
/*CLASSES_TREE*/void r583show(T583* C,T2 a1);
/*CLASSES_TREE*/T0* r583cluster_named(T583* C,T0* a1);
/*CLASSES_TREE*/void r583for_all(T583* C,T0* a1);
/*CLASSES_TREE*/void r583view_in(T583* C,T0* a1);
/*CLASSES_TREE*/void r583get_started(T583* C,T2 a1);
/*CLASSES_TREE*/void r583parse_include(T583* C);
/*CLASSES_TREE*/T2 r583loaded_class_count(T583* C);
/*CLASSES_TREE*/T0* r583to_string(T583* C);
/*CLASSES_TREE*/void r583make(T583* C,T2 a1,T0* a2,T0* a3,T0* a4);
/*CLASSES_TREE*/T0* r583echo(void);
/*CLASSES_TREE*/T2 r583_P_350_loaded_class_count(T583* C);
/*CLASSES_TREE*/void r583_P_350_parse_include(T583* C);
/*CLASSES_TREE*/void r583_P_350_get_started(T583* C,T2 a1);
/*CLASSES_TREE*/void r583_P_350_view_in(T583* C,T0* a1);
/*CLASSES_TREE*/void r583_P_350_for_all(T583* C,T0* a1);
/*CLASSES_TREE*/T0* r583_P_350_cluster_named(T583* C,T0* a1);
/*CLASSES_TREE*/void r583_P_350_generic_formal_arguments_check(T583* C);
/*CLASSES_TREE*/T0* r583_P_350_find_physical_cluster(T583* C,T0* a1);
/*CLASSES_TREE*/T2 r583_P_350_cluster_count(T583* C);
/*CLASSES_TREE*/void r583_P_350_clusters_of(T583* C,T0* a1,T6 a2,T0* a3,T0* a4,T0* a5,T2 a6);
/*SERC*/T0* r576c_mode(T576* C,T0* a1);
/*SERC*/void r576loadpaths_in(T576* C,T0* a1);
/*SERC*/T0* r576environment(T576* C,T0* a1);
extern T0*oBC28ini_parser;
/*SERC*/T0* r576parser_buffer(void);
/*SERC*/void r576make(T576* C);
/*SERC*/T0* r576echo(void);
/*SERC*/void r576add_all(T0* a1,T0* a2);
/*SERC_CHAIN*/T0* r575os(T575* C);
/*SERC_CHAIN*/T0* r575sys(T575* C);
/*SERC_CHAIN*/T0* r575c_mode(T575* C,T0* a1);
/*SERC_CHAIN*/void r575loadpaths_in(T575* C,T0* a1);
/*SERC_CHAIN*/T0* r575flavor(T575* C);
/*SERC_CHAIN*/T0* r575bin(T575* C);
/*SERC_CHAIN*/T0* r575short(T575* C);
/*SERC_CHAIN*/T0* r575environment(T575* C,T0* a1);
/*SERC_CHAIN*/void r575make(T575* C);
T432*create432make(T0* a1,T0* a2,T0* a3);
/*NON_VOID_NO_DISPATCH*/void r432mapping_c_target(T432* C,T0* a1,T0* a2);
/*NON_VOID_NO_DISPATCH*/void r432copy(T432* C,T0* a1);
/*NON_VOID_NO_DISPATCH*/T0* r432non_void_no_dispatch_type(T432* C,T0* a1);
/*NON_VOID_NO_DISPATCH*/T6 r432is_equal(T432* C,T0* a1);
/*NON_VOID_NO_DISPATCH*/T0* r432specialize_2(T0* a1);
/*NON_VOID_NO_DISPATCH*/T0* r432static_simplify(T432* C);
/*NON_VOID_NO_DISPATCH*/T0* r432simplify(T432* C,T0* a1);
/*NON_VOID_NO_DISPATCH*/T0* r432collect(T432* C,T0* a1);
/*NON_VOID_NO_DISPATCH*/T0* r432once_function(T432* C);
/*NON_VOID_NO_DISPATCH*/T0* r432specialize_thru(T0* a1,T0* a2,T0* a3);
/*NON_VOID_NO_DISPATCH*/void r432compile_to_c_with_internal_c_local_saving(T432* C,T0* a1);
/*NON_VOID_NO_DISPATCH*/T0* r432specialize_in(T0* a1);
/*NON_VOID_NO_DISPATCH*/void r432compile_to_c(T432* C,T0* a1);
/*NON_VOID_NO_DISPATCH*/T6 r432use_current(T0* a1);
/*NON_VOID_NO_DISPATCH*/void r432accept(T432* C,T0* a1);
/*NON_VOID_NO_DISPATCH*/T6 r432side_effect_free(T0* a1);
/*NON_VOID_NO_DISPATCH*/T0* r432declaration_type(T432* C);
/*NON_VOID_NO_DISPATCH*/T0* r432adapt_for(T432* C,T0* a1);
/*NON_VOID_NO_DISPATCH*/T0* r432resolve_in(T432* C,T0* a1);
/*NON_VOID_NO_DISPATCH*/T0* r432external_function(T432* C);
/*NON_VOID_NO_DISPATCH*/void r432make(T432* C,T0* a1,T0* a2,T0* a3);
/*NON_VOID_NO_DISPATCH*/T0* r432written_declaration_type_mark(void);
/*NON_VOID_NO_DISPATCH*/T0* r432twin(T432* C);
/*NON_VOID_NO_DISPATCH*/T296 r432start_position(T432* C);
/*NON_VOID_NO_DISPATCH*/T6 r432extra_bracket_flag(void);
/*NON_VOID_NO_DISPATCH*/void r432mapping_c_arg(T432* C,T0* a1);
/*NON_VOID_NO_DISPATCH*/T2 r432precedence(void);
/*NON_VOID_NO_DISPATCH*/T6 r432is_default_value(void);
/*SWITCH_SITE*/T2 r637count(T637* C);
/*SWITCH_SITE*/void r637make(T637* C,T0* a1,T0* a2,T0* a3,T0* a4);
extern T710 oBC28switch_collection;
extern int fBC28switch_collection;
/*SWITCH_SITE*/int r637switch_collection(void);
/*SWITCH_TYPE*/T2 r711count(T711* C);
/*SWITCH_TYPE*/void r711make(T711* C,T0* a1);
/*SWITCH_TYPE*/void r711add_site(T711* C,T0* a1);
/*AGENT_ARGS*/T6 r484is_equal(T484* C,T0* a1);
/*AGENT_ARGS*/T2 r484hash_code(T484* C);
/*AGENT_ARGS*/void r484make(T484* C,T0* a1,T0* a2);
/*AGENT_ARGS*/T0* r484echo(void);
/*AGENT_ARGS*/void r484c_agent_definition_call(T484* C,T0* a1,T0* a2,T0* a3);
/*AGENT_ARGS*/T6 r484c_define_agent_launcher_heading(T484* C,T0* a1);
/*AGENT_ARGS*/void r484c_define_agent_launcher(T484* C);
/*COUNTER*/void r308increment(T308* C);
/*E_REQUIRE*/void r346copy(T346* C,T0* a1);
/*E_REQUIRE*/T0* r346specialize_2(T346* C,T0* a1);
/*E_REQUIRE*/void r346collect(T346* C,T0* a1);
/*E_REQUIRE*/T6 r346is_always_true(T346* C);
/*E_REQUIRE*/T0* r346specialize_thru(T346* C,T0* a1,T0* a2,T0* a3);
/*E_REQUIRE*/T0* r346specialize_in(T346* C,T0* a1);
/*E_REQUIRE*/void r346compile_to_c(T346* C,T0* a1);
/*E_REQUIRE*/T6 r346use_current(T346* C,T0* a1);
/*E_REQUIRE*/T6 r346side_effect_free(T346* C,T0* a1);
/*E_REQUIRE*/T0* r346adapt_for(T346* C,T0* a1);
/*E_REQUIRE*/T6 r346has_require_item_located_at(T346* C,T296 a1);
/*E_REQUIRE*/void r346make(T346* C,T296 a1,T6 a2,T0* a3,T0* a4);
/*E_REQUIRE*/T0* r346twin(T346* C);
/*E_REQUIRE*/T0* r346add_parent_require(T346* C,T0* a1);
/*E_REQUIRE*/T296 r346start_position(T346* C);
/*GRAPH_NODE*/T2 r519destination_count(T519* C);
/*GRAPH_NODE*/void r519collect_way_to(T519* C,T0* a1);
/*GRAPH_NODE*/T2 r519run_time_set_add(T519* C,T0* a1);
/*GRAPH_NODE*/void r519id_extra_information(T519* C,T0* a1);
/*GRAPH_NODE*/T2 r519recompute_run_time_set(T519* C,T2 a1);
/*GRAPH_NODE*/void r519reset(T519* C);
/*GRAPH_NODE*/void r519make(T519* C,T0* a1);
extern T0*oBC500implicit_any;
extern int fBC500implicit_any;
/*ANONYMOUS_FEATURE_MIXER*/T0* r500implicit_any(void);
/*ANONYMOUS_FEATURE_MIXER*/T0* r500build_precursor(T500* C,T0* a1,T0* a2);
/*ANONYMOUS_FEATURE_MIXER*/void r500set_body(T500* C,T0* a1,T0* a2,T0* a3);
/*ANONYMOUS_FEATURE_MIXER*/void r500specialize_feature(T500* C,T0* a1);
/*ANONYMOUS_FEATURE_MIXER*/T0* r500formal_arg_list(T500* C,T0* a1);
/*ANONYMOUS_FEATURE_MIXER*/void r500make(T500* C,T0* a1);
/*ANONYMOUS_FEATURE_MIXER*/void r500specialize_signature(T500* C,T0* a1);
/*ANONYMOUS_FEATURE_MIXER*/void r500add_local_definition(T500* C,T0* a1);
/*ANONYMOUS_FEATURE_MIXER*/T0* r500result_type(T500* C,T0* a1);
/*ANONYMOUS_FEATURE_MIXER*/void r500error_handler_show_resulting_client_list(T0* a1);
/*ANONYMOUS_FEATURE_MIXER*/T0* r500export_status_for(T500* C,T0* a1,T0* a2);
/*ANONYMOUS_FEATURE_MIXER*/void r500error_handler_add_export_positions(T500* C,T0* a1);
/*ANONYMOUS_FEATURE_MIXER*/void r500remove_body(T500* C);
/*ANONYMOUS_FEATURE_MIXER*/T0* r500specialize_precursor(T500* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*ANONYMOUS_FEATURE_MIXER*/void r500add_inherited_definition(T500* C,T0* a1,T0* a2,T0* a3);
/*ABSOLUTE_FEATURE_NAME*/T6 r304is_equal(T304* C,T304 a1);
/*ABSOLUTE_FEATURE_NAME*/void r304make(T304* C,T0* a1,T0* a2);
/*ABSOLUTE_FEATURE_NAME*/T6 r304matches(T304* C,T0* a1,T0* a2);
/*INDEX_LIST*/void r551make(T551* C,T0* a1);
/*FEATURE_CLAUSE_LIST*/void r347get_started(T347* C,T0* a1);
/*FEATURE_CLAUSE_LIST*/void r347make(T347* C,T0* a1);
/*PARENT_LISTS*/void r323initialize_and_check_level_1(T323* C);
/*PARENT_LISTS*/void r323set_insert_member(T323* C,T2 a1);
/*PARENT_LISTS*/void r323id_extra_information(T323* C,T0* a1);
/*PARENT_LISTS*/void r323make(T323* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*PARENT_LISTS*/T6 r323get_permission_of(T323* C,T0* a1);
/*PARENT_LISTS*/T2 r323inherit_count(T323* C);
/*PARENT_LISTS*/T2 r323insert_count(T323* C);
/*PARENT_LISTS*/T6 r323is_native_array_collector_enabled(T323* C);
/*PARENT_LISTS*/T296 r323undefine_position_of(T323* C,T0* a1);
/*PARENT_LISTS*/void r323check_level_2(T323* C,T0* a1);
/*CREATION_CLAUSE_LIST*/T0* r348root_creation_search(T348* C,T0* a1);
/*CREATION_CLAUSE_LIST*/void r348all_positions_in_error_handler(T348* C);
/*CREATION_CLAUSE_LIST*/void r348extra_expanded_check(T348* C,T0* a1);
/*CREATION_CLAUSE_LIST*/T0* r348user_expanded_default_create_stamp(T348* C,T0* a1);
/*CREATION_CLAUSE_LIST*/void r348make(T348* C,T0* a1);
/*CREATION_CLAUSE_LIST*/T0* r348default_root(T348* C);
/*CREATION_CLAUSE_LIST*/void r348check_for(T348* C,T0* a1);
/*CREATION_CLAUSE_LIST*/T0* r348get_clause(T348* C,T0* a1);
/*CREATION_CLAUSE_LIST*/T296 r348start_position(T348* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_type_attribute_generating_type(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_na_type_item_generator(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_na_object_attribute(T246* C);
/*INTROSPECTION_HANDLER*/T6 r246is_introspectable_static_type(T0* a1);
/*INTROSPECTION_HANDLER*/T0* r246finalized_body_for_typed_internals(T246* C,T0* a1,T0* a2);
/*INTROSPECTION_HANDLER*/T0* r246finalized_body_for_valid_generating_type_for_na_internals(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_na_set_object_attribute(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_object_attribute(T246* C);
/*INTROSPECTION_HANDLER*/T0* r246finalized_body_for_internals_handler(T246* C,T0* a1,T0* a2);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_na_type_can_be_assigned_to_item(T246* C);
/*INTROSPECTION_HANDLER*/T0* r246finalized_body_for_na_internals_from_generating_type(T246* C);
/*INTROSPECTION_HANDLER*/T0* r246create_blank_internals_instruction_for(T246* C,T0* a1);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_na_type_item_is_expanded(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_type_attribute_count(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_na_type_item_generating_type(T246* C);
/*INTROSPECTION_HANDLER*/void r246collect_internals_from_generating_type(T246* C,T0* a1,T296 a2,T0* a3);
/*INTROSPECTION_HANDLER*/void r246collect_native_array_internals_from_generating_type(T246* C,T0* a1,T296 a2,T0* a3,T0* a4);
/*INTROSPECTION_HANDLER*/void r246start_new_body_for(T246* C,T0* a1,T0* a2,T6 a3);
/*INTROSPECTION_HANDLER*/T0* r246finalized_body_for_type_attribute_count(T246* C);
/*INTROSPECTION_HANDLER*/T296 r246start_position(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_make_blank(T246* C);
/*INTROSPECTION_HANDLER*/T0* r246finalized_body_for_to_internals(T246* C,T0* a1,T0* a2);
/*INTROSPECTION_HANDLER*/T0* r246specialize_body_for_any_to_internals(T246* C,T0* a1,T0* a2,T6 a3);
/*INTROSPECTION_HANDLER*/T0* r246internals_of(T246* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*INTROSPECTION_HANDLER*/T0* r246specialize_body_for_internals_handler(T246* C,T0* a1,T0* a2,T6 a3);
/*INTROSPECTION_HANDLER*/void r246collect_valid_generating_type_for_internals(T246* C,T0* a1,T0* a2);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_type_attribute_is_expanded(T246* C);
/*INTROSPECTION_HANDLER*/T0* r246specialize_body_for_native_array_internals(T246* C,T0* a1,T0* a2,T6 a3);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_type_attribute_generator(T246* C);
/*INTROSPECTION_HANDLER*/T6 r246is_introspectable_dynamic_type(T0* a1);
/*INTROSPECTION_HANDLER*/T0* r246simplify_and_wrap(T246* C,T0* a1,T0* a2);
/*INTROSPECTION_HANDLER*/T0* r246finalized_body_for_native_array_internals(T246* C,T0* a1,T0* a2);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_set_object_attribute(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_na_attribute_count(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_is_equal(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_type_can_be_assigned_to_attribute(T246* C);
/*INTROSPECTION_HANDLER*/T0* r246finalized_body_for_internals_from_generating_type(T246* C);
/*INTROSPECTION_HANDLER*/T0* r246collect_prelude(T0* a1,T0* a2,T0* a3);
/*INTROSPECTION_HANDLER*/T6 r246is_internals_from_generating_type_used(T246* C);
/*INTROSPECTION_HANDLER*/void r246collect_valid_generating_type_for_native_array_internals(T246* C,T0* a1,T0* a2);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_type_generator(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_na_make_blank(T246* C);
/*INTROSPECTION_HANDLER*/T0* r246specialize_body_for_typed_internals(T246* C,T0* a1,T0* a2,T6 a3);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_type_attribute_name(T246* C);
/*INTROSPECTION_HANDLER*/void r246set_and_specialize_body(T246* C,T0* a1,T0* a2);
/*INTROSPECTION_HANDLER*/T0* r246wrap(T0* a1);
/*INTROSPECTION_HANDLER*/T0* r246finalized_body_for_valid_generating_type_for_internals(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_type_is_expanded(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_object_as_pointer(T246* C);
/*INTROSPECTION_HANDLER*/void r246specialize_body_for_type_generating_type(T246* C);
/*INTROSPECTION_HANDLER*/T6 r246is_introspectable_attribute_type(T246* C,T0* a1);
/*INTROSPECTION_HANDLER*/T0* r246arguments(T246* C);
/*CLASS_INVARIANT*/void r329copy(T329* C,T0* a1);
/*CLASS_INVARIANT*/T0* r329specialize_2(T329* C,T0* a1);
/*CLASS_INVARIANT*/void r329compile_to_c_(T329* C,T0* a1,T6 a2,T6 a3);
/*CLASS_INVARIANT*/void r329collect(T329* C,T0* a1);
/*CLASS_INVARIANT*/T6 r329has_assertion_located_at(T329* C,T296 a1);
/*CLASS_INVARIANT*/T6 r329is_always_true(T329* C);
/*CLASS_INVARIANT*/T0* r329specialize_thru(T329* C,T0* a1,T0* a2,T0* a3);
/*CLASS_INVARIANT*/void r329c_compile_assertion(T329* C,T0* a1,T0* a2);
/*CLASS_INVARIANT*/T0* r329add_parent_class_invariant(T329* C,T0* a1);
/*CLASS_INVARIANT*/void r329define_check_invariant_c_function(T329* C,T0* a1);
/*CLASS_INVARIANT*/T0* r329specialize_in(T329* C,T0* a1);
/*CLASS_INVARIANT*/void r329compile_to_c(T329* C,T0* a1);
/*CLASS_INVARIANT*/T0* r329adapt_for(T329* C,T0* a1);
/*CLASS_INVARIANT*/void r329make(T329* C,T296 a1,T0* a2,T0* a3);
/*CLASS_INVARIANT*/T0* r329twin(T329* C);
/*WRITABLE_ATTRIBUTE*/T6 r363use_current(T0* a1);
/*WRITABLE_ATTRIBUTE*/void r363set_ensure(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/T0* r363specialized_require_thru(T363* C,T0* a1,T0* a2,T0* a3);
/*WRITABLE_ATTRIBUTE*/T6 r363side_effect_free(T0* a1);
/*WRITABLE_ATTRIBUTE*/T0* r363first_name(T363* C);
/*WRITABLE_ATTRIBUTE*/void r363copy(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/T0* r363inline_instruction_1(T0* a1,T0* a2,T0* a3,T0* a4);
/*WRITABLE_ATTRIBUTE*/T0* r363inline_instruction_0(T0* a1,T0* a2,T0* a3);
/*WRITABLE_ATTRIBUTE*/T0* r363class_text(T363* C);
/*WRITABLE_ATTRIBUTE*/T0* r363names(T363* C);
/*WRITABLE_ATTRIBUTE*/T0* r363specialize_require_in(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/void r363add_into(T363* C,T0* a1,T0* a2);
/*WRITABLE_ATTRIBUTE*/T0* r363merge_signature_thru(T363* C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
/*WRITABLE_ATTRIBUTE*/T0* r363try_to_undefine(T363* C,T0* a1,T0* a2);
/*WRITABLE_ATTRIBUTE*/void r363add_into_(T363* C,T0* a1,T0* a2);
/*WRITABLE_ATTRIBUTE*/void r363collect(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/T0* r363new_run_feature_for(T363* C,T0* a1,T0* a2);
/*WRITABLE_ATTRIBUTE*/void r363valid_redefinition_error(T0* a1,T0* a2,T0* a3,T0* a4);
/*WRITABLE_ATTRIBUTE*/void r363collect_precursor(T363* C,T0* a1,T0* a2);
/*WRITABLE_ATTRIBUTE*/T0* r363inline_expression_n(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*WRITABLE_ATTRIBUTE*/T0* r363change_ensure(T363* C,T0* a1,T6 a2);
/*WRITABLE_ATTRIBUTE*/T0* r363brand_new_run_feature_for(T363* C,T0* a1,T0* a2,T6 a3);
/*WRITABLE_ATTRIBUTE*/T0* r363specialize_permissions(T363* C,T0* a1,T6 a2);
/*WRITABLE_ATTRIBUTE*/T6 r363same_body_as(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/T0* r363specialize_body_thru(T363* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*WRITABLE_ATTRIBUTE*/T6 r363same_signature(T363* C,T0* a1,T0* a2);
/*WRITABLE_ATTRIBUTE*/void r363set_header_comment(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/T296 r363sedb_trace_before_exit(T363* C);
/*WRITABLE_ATTRIBUTE*/T0* r363specialize_signature_thru(T363* C,T0* a1,T0* a2,T0* a3);
/*WRITABLE_ATTRIBUTE*/T0* r363specialize_ensure_in(T363* C,T0* a1,T6 a2);
/*WRITABLE_ATTRIBUTE*/T0* r363specialize_ensure_thru(T363* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*WRITABLE_ATTRIBUTE*/void r363accept(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/void r363set_ensure_assertion(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/T0* r363arguments(void);
/*WRITABLE_ATTRIBUTE*/T0* r363clients(T363* C);
/*WRITABLE_ATTRIBUTE*/T0* r363inline_expression_1(T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*WRITABLE_ATTRIBUTE*/T0* r363inline_expression_0(T363* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*WRITABLE_ATTRIBUTE*/void r363make(T363* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*WRITABLE_ATTRIBUTE*/T0* r363twin(T363* C);
/*WRITABLE_ATTRIBUTE*/T6 r363valid_redefinition(T363* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*WRITABLE_ATTRIBUTE*/T0* r363change_require(T363* C,T0* a1,T6 a2);
/*WRITABLE_ATTRIBUTE*/void r363set_require(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/T0* r363obsolete_warning_check_memory(void);
/*WRITABLE_ATTRIBUTE*/void r363set_end_comment(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/T296 r363start_position(T363* C);
/*WRITABLE_ATTRIBUTE*/void r363set_rescue_compound(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/T0* r363specialize_body_in(T363* C,T0* a1,T6 a2);
/*WRITABLE_ATTRIBUTE*/void r363obsolete_warning_check(T363* C,T0* a1,T296 a2);
/*WRITABLE_ATTRIBUTE*/T0* r363specialize_2(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/T0* r363simplify(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/void r363with(T363* C,T0* a1,T0* a2,T2 a3);
/*WRITABLE_ATTRIBUTE*/void r363set_permissions(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/T0* r363specialize_signature_in(T363* C,T0* a1);
/*WRITABLE_ATTRIBUTE*/T0* r363specialized_ensure_thru(T363* C,T0* a1,T0* a2,T0* a3);
/*WRITABLE_ATTRIBUTE*/T0* r363inline_instruction_n(T0* a1,T0* a2,T0* a3,T0* a4);
/*WRITABLE_ATTRIBUTE*/T0* r363try_to_undefine_aux(T363* C,T0* a1,T0* a2);
/*WRITABLE_ATTRIBUTE*/T0* r363specialize_require_thru(T363* C,T0* a1,T0* a2,T0* a3);
/*RUN_TIME_SET*/T2 r290add_set(T290* C,T0* a1);
/*RUN_TIME_SET*/void r290force_add(T290* C,T0* a1);
/*RUN_TIME_SET*/T2 r290count(T290* C);
/*RUN_TIME_SET*/void r290id_extra_information(T290* C,T0* a1);
/*RUN_TIME_SET*/T6 r290has(T290* C,T0* a1);
/*RUN_TIME_SET*/void r290reset(T290* C);
/*RUN_TIME_SET*/void r290make(T290* C,T0* a1);
/*CLUSTER_CLASS*/void r581make(T581* C,T0* a1,T0* a2,T0* a3);
/*CLUSTER_POOL_DATA*/void r582add_cluster_class(T582* C,T0* a1,T0* a2);
/*CLUSTER_POOL_DATA*/T0* r582cluster_class(T582* C,T0* a1);
/*CLUSTER_POOL_DATA*/T2 r582class_count(T582* C);
extern T0*oBC582hash_tuple;
extern int fBC582hash_tuple;
/*CLUSTER_POOL_DATA*/T0* r582hash_tuple(void);
/*CLUSTER_POOL_DATA*/T6 r582has(T582* C,T0* a1);
/*CLUSTER_POOL_DATA*/void r582make(T582* C,T0* a1);
/*INDEX_CLAUSE*/void r548without_tag(T548* C,T0* a1);
/*INDEX_CLAUSE*/void r548with_tag(T548* C,T0* a1);
/*INDEX_CLAUSE*/void r548add_last(T548* C,T0* a1);
/*RENAME_PAIR*/void r322make(T322* C,T0* a1,T0* a2);
/*EXPORT_ITEM*/void r546make_all(T546* C,T0* a1);
/*EXPORT_ITEM*/void r546make(T546* C,T0* a1,T0* a2);
/*EXPORT_LIST*/void r321make(T321* C,T296 a1,T0* a2);
/*EXPORT_LIST*/T0* r321clients_for(T321* C,T0* a1);
/*EXPORT_LIST*/void r321check_level_2(T321* C,T0* a1,T0* a2);
T76*create76make(T6 a1,T0* a2);
/*PARENT_EDGE*/T2 r76rename_count(T76* C);
/*PARENT_EDGE*/T0* r76exports_for_all(T76* C);
/*PARENT_EDGE*/T0* r76do_rename(T76* C,T0* a1);
/*PARENT_EDGE*/T0* r76exports_for(T76* C,T0* a1);
/*PARENT_EDGE*/void r76initialize_and_check_level_1(T76* C,T0* a1);
/*PARENT_EDGE*/void r76id_extra_information(T76* C,T0* a1);
/*PARENT_EDGE*/T0* r76get_redefine(T76* C,T0* a1);
/*PARENT_EDGE*/T0* r76get_undefine(T76* C,T0* a1);
/*PARENT_EDGE*/void r76make(T76* C,T6 a1,T0* a2);
/*PARENT_EDGE*/T0* r76get_name_in_child(T76* C,T0* a1);
/*PARENT_EDGE*/T6 r76is_target_of_rename(T76* C,T0* a1);
extern T0*oBC76forbidden_parent_list;
extern int fBC76forbidden_parent_list;
/*PARENT_EDGE*/T0* r76forbidden_parent_list(void);
/*PARENT_EDGE*/T296 r76start_position(T76* C);
/*PARENT_EDGE*/void r76add_rename(T76* C,T0* a1);
/*PARENT_EDGE*/void r76check_level_2(T76* C,T0* a1);
/*FEATURE_NAME_LIST*/T0* r325root_creation_search(T325* C,T0* a1);
/*FEATURE_NAME_LIST*/void r325all_positions_in_error_handler(T325* C);
/*FEATURE_NAME_LIST*/T0* r325internal_name(T325* C,T0* a1);
/*FEATURE_NAME_LIST*/T2 r325count(T325* C);
/*FEATURE_NAME_LIST*/void r325fe_multiple(T0* a1,T0* a2);
/*FEATURE_NAME_LIST*/T6 r325has_make(T325* C);
/*FEATURE_NAME_LIST*/T0* r325item(T325* C,T2 a1);
/*FEATURE_NAME_LIST*/T6 r325has(T325* C,T0* a1);
/*FEATURE_NAME_LIST*/void r325make_1(T325* C,T0* a1);
/*FEATURE_NAME_LIST*/void r325add_last(T325* C,T0* a1);
/*FEATURE_NAME_LIST*/void r325make_n(T325* C,T0* a1);
/*FEATURE_NAME_LIST*/T2 r325index_of(T325* C,T0* a1);
/*CREATION_CLAUSE*/void r547check_manifest_put(T0* a1,T0* a2);
/*CREATION_CLAUSE*/void r547check_manifest_semicolon_check(T547* C,T0* a1,T0* a2);
/*CREATION_CLAUSE*/T0* r547extra_expanded_check(T547* C,T0* a1,T0* a2);
extern T0*oBC28manifest_make_name;
extern int fBC28manifest_make_name;
/*CREATION_CLAUSE*/T0* r547manifest_make_name(void);
/*CREATION_CLAUSE*/void r547check_manifest_make(T0* a1,T0* a2);
extern T0*oBC28manifest_semicolon_check_name;
extern int fBC28manifest_semicolon_check_name;
/*CREATION_CLAUSE*/T0* r547manifest_semicolon_check_name(void);
extern T0*oBC28manifest_put_name;
extern int fBC28manifest_put_name;
/*CREATION_CLAUSE*/T0* r547manifest_put_name(void);
/*CREATION_CLAUSE*/T0* r547user_expanded_default_create_stamp(T547* C,T0* a1);
/*CREATION_CLAUSE*/void r547make(T547* C,T296 a1,T0* a2,T0* a3,T0* a4);
/*CREATION_CLAUSE*/T0* r547default_root(T547* C);
/*CREATION_CLAUSE*/void r547check_for(T547* C,T0* a1);
/*LOCAL_NAME1*/void r498set_result_type(T498* C,T0* a1);
/*LOCAL_NAME1*/void r498copy(T498* C,T0* a1);
/*LOCAL_NAME1*/T0* r498collect(T498* C,T0* a1);
/*LOCAL_NAME1*/T0* r498specialize_thru(T498* C,T0* a1,T0* a2,T0* a3);
/*LOCAL_NAME1*/void r498c_declare(T498* C,T0* a1,T6 a2);
/*LOCAL_NAME1*/void r498name_clash_check_(T498* C,T0* a1,T0* a2);
/*LOCAL_NAME1*/T0* r498specialize_in(T498* C,T0* a1);
/*LOCAL_NAME1*/void r498parsing_reference_counter_increment(T498* C);
/*LOCAL_NAME1*/void r498usage_warning_check(T498* C,T0* a1);
/*LOCAL_NAME1*/void r498live_reference_counter_increment(T498* C);
/*LOCAL_NAME1*/T6 r498produce_c(T498* C,T0* a1);
/*LOCAL_NAME1*/T0* r498adapt_for(T498* C,T0* a1);
/*LOCAL_NAME1*/void r498make(T498* C,T296 a1,T0* a2);
/*LOCAL_NAME1*/T0* r498twin(T498* C);
/*LOCAL_NAME1*/void r498set_rank(T498* C,T2 a1);
/*ARGUMENT_NAME1*/void r494set_result_type(T494* C,T0* a1);
/*ARGUMENT_NAME1*/void r494copy(T494* C,T0* a1);
/*ARGUMENT_NAME1*/T0* r494collect(T494* C,T0* a1);
/*ARGUMENT_NAME1*/T0* r494specialize_thru(T494* C,T0* a1,T0* a2,T0* a3);
/*ARGUMENT_NAME1*/void r494name_clash_check_(T494* C,T0* a1,T0* a2);
/*ARGUMENT_NAME1*/T0* r494specialize_in(T494* C,T0* a1);
/*ARGUMENT_NAME1*/T0* r494adapt_for(T494* C,T0* a1);
/*ARGUMENT_NAME1*/T0* r494resolve_in(T494* C,T0* a1);
/*ARGUMENT_NAME1*/void r494make(T494* C,T296 a1,T0* a2);
/*ARGUMENT_NAME1*/T0* r494twin(T494* C);
/*ARGUMENT_NAME1*/void r494set_rank(T494* C,T2 a1);
/*DECLARATION_1*/void r529append_in(T529* C,T0* a1);
/*DECLARATION_1*/void r529copy(T529* C,T0* a1);
/*DECLARATION_1*/T0* r529specialize_thru(T529* C,T0* a1,T0* a2,T0* a3);
/*DECLARATION_1*/T0* r529specialize_in(T529* C,T0* a1);
/*DECLARATION_1*/void r529make(T529* C,T0* a1,T0* a2);
/*DECLARATION_1*/T0* r529twin(T529* C);
/*DECLARATION_GROUP*/void r528append_in(T528* C,T0* a1);
/*DECLARATION_GROUP*/void r528copy(T528* C,T0* a1);
/*DECLARATION_GROUP*/T2 r528count(T528* C);
/*DECLARATION_GROUP*/T0* r528specialize_thru(T528* C,T0* a1,T0* a2,T0* a3);
/*DECLARATION_GROUP*/T0* r528specialize_in(T528* C,T0* a1);
/*DECLARATION_GROUP*/void r528make(T528* C,T0* a1,T0* a2);
/*DECLARATION_GROUP*/T0* r528twin(T528* C);
/*NATIVE_BUILT_IN*/T6 r360use_current(T0* a1);
/*NATIVE_BUILT_IN*/T6 r360side_effect_free(T0* a1,T0* a2);
/*NATIVE_BUILT_IN*/void r360accept(T360* C,T0* a1);
/*NATIVE_BUILT_IN*/void r360make(T360* C,T0* a1);
/*NATIVE_BUILT_IN*/T296 r360start_position(T360* C);
/*NATIVE_BUILT_IN*/void r360c_define_function(T360* C,T0* a1,T0* a2,T0* a3);
/*NATIVE_BUILT_IN*/void r360c_mapping_procedure(T0* a1,T0* a2,T0* a3);
/*NATIVE_BUILT_IN*/void r360c_define_procedure(T0* a1,T0* a2,T0* a3);
/*NATIVE_BUILT_IN*/void r360c_mapping_function(T0* a1,T0* a2,T0* a3);
/*NATIVE_BUILT_IN*/T0* r360system_tools(void);
/*NATIVE_BUILT_IN*/void r360c_define_standard_twin(T0* a1,T0* a2);
/*NATIVE_BUILT_IN*/void r360c_mapping_integer_procedure(T0* a1,T0* a2);
/*NATIVE_BUILT_IN*/void r360c_mapping_integer_function(T0* a1,T0* a2);
/*NATIVE_BUILT_IN*/void r360c_mapping_real(T0* a1,T0* a2,T2 a3);
/*NATIVE_BUILT_IN*/T6 r360expanded_initializer(T0* a1);
/*NATIVE_BUILT_IN*/void r360c_mapping_native_array_procedure(T0* a1,T0* a2);
/*NATIVE_BUILT_IN*/void r360c_define_integer_to_integer(T2 a1,T0* a2);
/*NATIVE_BUILT_IN*/void r360c_mapping_native_array_function(T0* a1,T0* a2);
/*NATIVE_BUILT_IN*/void r360c_mapping_standard_twin(T0* a1,T0* a2);
/*NATIVE_BUILT_IN*/void r360c_mapping_integer_to_integer(T2 a1,T0* a2);
/*NATIVE_BUILT_IN*/void r360c_define_twin(T0* a1,T0* a2,T0* a3);
/*NATIVE_BUILT_IN*/void r360to_integer(T2 a1,T6 a2);
/*NATIVE_PLUG_IN*/T6 r356is_equal(T356* C,T0* a1);
extern T0*oBC28mini_buffer;
/*NATIVE_PLUG_IN*/void r356customize_runtime(T356* C);
/*NATIVE_PLUG_IN*/T0* r356system_tools(void);
/*NATIVE_PLUG_IN*/void r356collect(T356* C,T0* a1,T0* a2);
/*NATIVE_PLUG_IN*/void r356c_mapping_procedure(T356* C,T0* a1,T0* a2,T0* a3);
/*NATIVE_PLUG_IN*/T6 r356use_current(T0* a1);
/*NATIVE_PLUG_IN*/void r356accept(T356* C,T0* a1);
/*NATIVE_PLUG_IN*/T6 r356side_effect_free(T0* a1,T0* a2);
/*NATIVE_PLUG_IN*/void r356c_mapping_function(T356* C,T0* a1,T0* a2,T0* a3);
/*NATIVE_PLUG_IN*/void r356make(T356* C,T0* a1);
/*NATIVE_PLUG_IN*/void r356c_mapping(T356* C,T0* a1);
/*NATIVE_PLUG_IN*/void r356parse_alias_string(T356* C,T0* a1);
/*NATIVE_PLUG_IN*/T296 r356start_position(T356* C);
/*NATIVE_C_PLUS_PLUS*/void r359parse_external_in(T359* C,T0* a1,T2 a2,T0* a3,T0* a4);
extern T0*oBC359include_memory;
extern int fBC359include_memory;
/*NATIVE_C_PLUS_PLUS*/T0* r359include_memory(void);
/*NATIVE_C_PLUS_PLUS*/void r359c_plus_plus_function_definition(T359* C,T0* a1);
/*NATIVE_C_PLUS_PLUS*/T2 r359parse_args_in(T359* C,T0* a1,T2 a2,T0* a3,T2 a4,T2 a5);
extern T0*oBC359external_routine_memory;
extern int fBC359external_routine_memory;
/*NATIVE_C_PLUS_PLUS*/T0* r359external_routine_memory(void);
/*NATIVE_C_PLUS_PLUS*/void r359standard_c_define_function(T359* C,T0* a1,T0* a2,T0* a3);
/*NATIVE_C_PLUS_PLUS*/void r359standard_c_define_procedure(T359* C,T0* a1,T0* a2,T0* a3);
extern T0*oBC357buffer;
extern int fBC357buffer;
/*NATIVE_C_PLUS_PLUS*/T0* r359buffer(void);
/*NATIVE_C_PLUS_PLUS*/void r359c_mapping_external(T0* a1,T2 a2);
/*NATIVE_C_PLUS_PLUS*/void r359c_plus_plus_definition(T359* C);
/*NATIVE_C_PLUS_PLUS*/T2 r359parse_cpp_class_in(T359* C,T0* a1,T2 a2,T0* a3);
/*NATIVE_C_PLUS_PLUS*/void r359c_plus_plus_procedure_definition(T359* C,T0* a1);
/*NATIVE_C_PLUS_PLUS*/T2 r359error_at(T359* C,T2 a1,T0* a2,T2 a3);
/*NATIVE_C_PLUS_PLUS*/void r359wrapped_external_call_in(T0* a1,T0* a2,T2 a3);
/*NATIVE_C_PLUS_PLUS*/void r359collect(T0* a1,T0* a2);
/*NATIVE_C_PLUS_PLUS*/void r359c_define_function(T359* C,T0* a1,T0* a2,T0* a3);
/*NATIVE_C_PLUS_PLUS*/void r359extra_c_prototype_in_cpp_out_h_buffer(T296 a1,T0* a2,T0* a3);
/*NATIVE_C_PLUS_PLUS*/void r359c_mapping_procedure(T0* a1,T0* a2,T0* a3);
/*NATIVE_C_PLUS_PLUS*/T2 r359parse_include(T359* C,T2 a1,T0* a2);
/*NATIVE_C_PLUS_PLUS*/void r359extra_c_prototype(T296 a1,T0* a2,T0* a3);
/*NATIVE_C_PLUS_PLUS*/T6 r359use_current(T0* a1);
/*NATIVE_C_PLUS_PLUS*/void r359notify_external_assignments(T0* a1,T0* a2);
/*NATIVE_C_PLUS_PLUS*/void r359accept(T359* C,T0* a1);
/*NATIVE_C_PLUS_PLUS*/void r359c_define_procedure(T359* C,T0* a1,T0* a2,T0* a3);
/*NATIVE_C_PLUS_PLUS*/T6 r359side_effect_free(T0* a1,T0* a2);
/*NATIVE_C_PLUS_PLUS*/void r359c_mapping_function(T0* a1,T0* a2,T0* a3);
/*NATIVE_C_PLUS_PLUS*/void r359make(T359* C,T0* a1);
/*NATIVE_C_PLUS_PLUS*/T296 r359start_position(T359* C);
/*NATIVE_C*/void r358parse_external_tag(T358* C);
/*NATIVE_C*/void r358collect(T0* a1,T0* a2);
/*NATIVE_C*/void r358c_define_function(T358* C,T0* a1,T0* a2,T0* a3);
/*NATIVE_C*/void r358extra_c_prototype_in_cpp_out_h_buffer(T296 a1,T0* a2,T0* a3);
/*NATIVE_C*/void r358c_mapping_procedure(T358* C,T0* a1,T0* a2,T0* a3);
/*NATIVE_C*/void r358extra_c_prototype(T296 a1,T0* a2,T0* a3);
/*NATIVE_C*/T6 r358use_current(T0* a1);
/*NATIVE_C*/void r358notify_external_assignments(T0* a1,T0* a2);
/*NATIVE_C*/void r358accept(T358* C,T0* a1);
/*NATIVE_C*/void r358c_define_procedure(T358* C,T0* a1,T0* a2,T0* a3);
/*NATIVE_C*/T6 r358side_effect_free(T0* a1,T0* a2);
/*NATIVE_C*/void r358c_mapping_function(T358* C,T0* a1,T0* a2,T0* a3);
/*NATIVE_C*/void r358make(T358* C,T0* a1);
/*NATIVE_C*/void r358c_mapping(T358* C,T0* a1,T6 a2,T6 a3,T2 a4);
/*NATIVE_C*/void r358bad_external(T358* C,T0* a1);
/*NATIVE_C*/T296 r358start_position(T358* C);
/*NATIVE_JAVA*/void r361collect(T0* a1,T0* a2);
/*NATIVE_JAVA*/void r361c_define_function(T0* a1,T0* a2,T0* a3);
/*NATIVE_JAVA*/void r361c_mapping_procedure(T0* a1,T0* a2,T0* a3);
/*NATIVE_JAVA*/T6 r361use_current(T0* a1);
/*NATIVE_JAVA*/void r361notify_external_assignments(T0* a1,T0* a2);
/*NATIVE_JAVA*/void r361accept(T361* C,T0* a1);
/*NATIVE_JAVA*/void r361c_define_procedure(T0* a1,T0* a2,T0* a3);
/*NATIVE_JAVA*/T6 r361side_effect_free(T0* a1,T0* a2);
/*NATIVE_JAVA*/void r361c_mapping_function(T0* a1,T0* a2,T0* a3);
/*NATIVE_JAVA*/void r361fe_c2c(T0* a1);
/*NATIVE_JAVA*/void r361make(T361* C,T0* a1);
/*MINI_BUFFER*/T3 r84item(T84* C);
/*MINI_BUFFER*/T0* r84system_tools(void);
/*MINI_BUFFER*/void r84next(T84* C);
/*MINI_BUFFER*/T0* r84a_type_cast(T84* C);
/*MINI_BUFFER*/T6 r84a_word(T84* C,T0* a1);
/*MINI_BUFFER*/void r84start_with(T84* C,T0* a1);
/*MINI_BUFFER*/T0* r84a_file_or_directory_path(T84* C);
/*MINI_BUFFER*/T0* r84a_include(T84* C);
/*MINI_BUFFER*/T0* r84a_signature(T84* C);
/*MINI_BUFFER*/T6 r84is_off(T84* C);
/*MINI_BUFFER*/void r84show_position_with_fatal_error(T84* C,T0* a1);
/*MINI_BUFFER*/void r84skip_separators(T84* C);
/*MINI_BUFFER*/T6 r84a_keyword(T84* C,T0* a1);
T345*create345make(T296 a1,T6 a2,T0* a3,T0* a4);
/*E_ENSURE*/void r345copy(T345* C,T0* a1);
/*E_ENSURE*/T0* r345specialize_2(T345* C,T0* a1);
/*E_ENSURE*/void r345compile_to_c_(T345* C,T0* a1,T6 a2,T6 a3);
/*E_ENSURE*/void r345collect(T345* C,T0* a1);
/*E_ENSURE*/T6 r345has_assertion_located_at(T345* C,T296 a1);
/*E_ENSURE*/T6 r345is_always_true(T345* C);
/*E_ENSURE*/T0* r345specialize_thru(T345* C,T0* a1,T0* a2,T0* a3);
/*E_ENSURE*/void r345c_compile_assertion(T345* C,T0* a1,T0* a2);
/*E_ENSURE*/T0* r345specialize_in(T345* C,T0* a1);
/*E_ENSURE*/void r345compile_to_c(T345* C,T0* a1);
/*E_ENSURE*/T6 r345use_current(T345* C,T0* a1);
/*E_ENSURE*/T6 r345side_effect_free(T345* C,T0* a1);
/*E_ENSURE*/void r345assertion_list_make(T345* C,T296 a1,T0* a2,T0* a3);
/*E_ENSURE*/T0* r345adapt_for(T345* C,T0* a1);
/*E_ENSURE*/T0* r345add_parent_ensure(T345* C,T0* a1);
/*E_ENSURE*/void r345make(T345* C,T296 a1,T6 a2,T0* a3,T0* a4);
/*E_ENSURE*/T0* r345twin(T345* C);
/*COMPOUND*/T0* r397simplify_routine_body_first(T397* C,T0* a1,T0* a2);
/*COMPOUND*/void r397copy(T397* C,T0* a1);
/*COMPOUND*/T0* r397specialize_2(T397* C,T0* a1);
/*COMPOUND*/T0* r397simplify(T397* C,T0* a1);
/*COMPOUND*/void r397collect(T397* C,T0* a1);
/*COMPOUND*/T0* r397specialize_thru(T397* C,T0* a1,T0* a2,T0* a3);
/*COMPOUND*/void r397compile_to_c_with_internal_c_local_saving(T397* C,T0* a1);
/*COMPOUND*/T0* r397specialize_in(T397* C,T0* a1);
/*COMPOUND*/void r397compile_to_c(T397* C,T0* a1);
/*COMPOUND*/T6 r397use_current(T397* C,T0* a1);
/*COMPOUND*/void r397make_2(T397* C,T0* a1,T0* a2);
/*COMPOUND*/T0* r397specialize_2_without_checks(T397* C,T0* a1);
/*COMPOUND*/T6 r397side_effect_free(T397* C,T0* a1);
/*COMPOUND*/void r397accept(T397* C,T0* a1);
/*COMPOUND*/void r397make_n(T397* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*COMPOUND*/T0* r397adapt_for(T397* C,T0* a1);
/*COMPOUND*/void r397make_3(T397* C,T0* a1,T0* a2,T0* a3);
/*COMPOUND*/void r397make_4(T397* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*COMPOUND*/T0* r397twin(T397* C);
/*COMPOUND*/T0* r397simplify_add(T0* a1,T0* a2);
/*COMPOUND*/T296 r397start_position(T397* C);
/*COMPOUND*/void r397safety_check(T397* C,T0* a1);
/*E_CHECK*/T0* r395simplify_routine_body_first(T395* C,T0* a1,T0* a2);
/*E_CHECK*/void r395copy(T395* C,T0* a1);
/*E_CHECK*/T0* r395specialize_2(T395* C,T0* a1);
/*E_CHECK*/T0* r395simplify(T0* a1);
/*E_CHECK*/void r395collect(T395* C,T0* a1);
/*E_CHECK*/T0* r395current_or_twin_init(T395* C,T0* a1);
/*E_CHECK*/T0* r395specialize_thru(T395* C,T0* a1,T0* a2,T0* a3);
/*E_CHECK*/void r395compile_to_c_with_internal_c_local_saving(T395* C,T0* a1);
/*E_CHECK*/T0* r395specialize_in(T395* C,T0* a1);
/*E_CHECK*/void r395compile_to_c(T395* C,T0* a1);
/*E_CHECK*/T6 r395use_current(T395* C,T0* a1);
/*E_CHECK*/T0* r395specialize_2_without_checks(T395* C,T0* a1);
/*E_CHECK*/T6 r395side_effect_free(T0* a1);
/*E_CHECK*/void r395accept(T395* C,T0* a1);
/*E_CHECK*/T0* r395adapt_for(T395* C,T0* a1);
/*E_CHECK*/void r395make(T395* C,T296 a1,T0* a2,T0* a3);
/*E_CHECK*/T0* r395twin(T395* C);
/*E_CHECK*/T6 r395must_be_generated(T395* C,T0* a1);
/*E_CHECK*/T296 r395start_position(T395* C);
/*E_CHECK*/void r395safety_check(T395* C,T0* a1);
/*E_DEBUG*/T0* r349simplify_routine_body_first(T349* C,T0* a1,T0* a2);
/*E_DEBUG*/void r349copy(T349* C,T0* a1);
/*E_DEBUG*/T0* r349specialize_2(T349* C,T0* a1);
/*E_DEBUG*/T0* r349simplify(T0* a1);
/*E_DEBUG*/void r349collect(T349* C,T0* a1);
/*E_DEBUG*/T0* r349current_or_twin_init(T349* C,T0* a1);
/*E_DEBUG*/T0* r349specialize_thru(T349* C,T0* a1,T0* a2,T0* a3);
/*E_DEBUG*/void r349compile_to_c_with_internal_c_local_saving(T349* C,T0* a1);
/*E_DEBUG*/T0* r349specialize_in(T349* C,T0* a1);
/*E_DEBUG*/void r349compile_to_c(T349* C,T0* a1);
/*E_DEBUG*/T6 r349use_current(T349* C,T0* a1);
/*E_DEBUG*/T0* r349specialize_2_without_checks(T349* C,T0* a1);
/*E_DEBUG*/T6 r349side_effect_free(T0* a1);
/*E_DEBUG*/void r349accept(T349* C,T0* a1);
/*E_DEBUG*/T0* r349adapt_for(T349* C,T0* a1);
/*E_DEBUG*/void r349make(T349* C,T296 a1,T0* a2,T0* a3);
/*E_DEBUG*/T0* r349twin(T349* C);
/*E_DEBUG*/T6 r349must_be_generated(T349* C,T0* a1);
/*E_DEBUG*/T6 r349match_debug_key(T349* C,T0* a1);
/*E_DEBUG*/void r349safety_check(T349* C,T0* a1);
T387*create387make(T296 a1,T0* a2,T0* a3);
/*IFTHEN*/T0* r387simplify_routine_body_first(T387* C,T0* a1,T0* a2);
/*IFTHEN*/void r387copy(T387* C,T0* a1);
extern T0*oBC28and_then_name;
extern int fBC28and_then_name;
/*IFTHEN*/T0* r387and_then_name(void);
/*IFTHEN*/void r387init(T387* C,T0* a1,T0* a2);
/*IFTHEN*/T0* r387specialize_2(T387* C,T0* a1);
extern T0*oBC28boolean_and_then_fs;
extern int fBC28boolean_and_then_fs;
/*IFTHEN*/T0* r387boolean_and_then_fs(void);
/*IFTHEN*/T0* r387simplify(T387* C,T0* a1);
/*IFTHEN*/void r387collect(T387* C,T0* a1);
/*IFTHEN*/T0* r387current_or_twin_init(T387* C,T0* a1,T0* a2);
/*IFTHEN*/T0* r387specialize_thru(T387* C,T0* a1,T0* a2,T0* a3);
/*IFTHEN*/void r387compile_to_c_with_internal_c_local_saving(T387* C,T0* a1);
/*IFTHEN*/T0* r387specialize_in(T387* C,T0* a1);
/*IFTHEN*/void r387compile_to_c(T387* C,T0* a1);
/*IFTHEN*/T6 r387use_current(T387* C,T0* a1);
/*IFTHEN*/T0* r387specialize_2_without_checks(T387* C,T0* a1);
/*IFTHEN*/T6 r387side_effect_free(T0* a1);
/*IFTHEN*/void r387accept(T387* C,T0* a1);
/*IFTHEN*/void r387specialize_2_check_(T387* C,T0* a1);
/*IFTHEN*/T0* r387adapt_for(T387* C,T0* a1);
/*IFTHEN*/void r387make(T387* C,T296 a1,T0* a2,T0* a3);
/*IFTHEN*/T0* r387twin(T387* C);
/*IFTHEN*/void r387safety_check(T387* C,T0* a1);
/*IFTHENELSE*/T0* r385simplify_routine_body_first(T385* C,T0* a1,T0* a2);
/*IFTHENELSE*/void r385copy(T385* C,T0* a1);
/*IFTHENELSE*/void r385init(T385* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*IFTHENELSE*/T0* r385specialize_2(T385* C,T0* a1);
/*IFTHENELSE*/T0* r385simplify(T385* C,T0* a1);
/*IFTHENELSE*/void r385collect(T385* C,T0* a1);
/*IFTHENELSE*/T0* r385current_or_twin_init(T385* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*IFTHENELSE*/T0* r385specialize_thru(T385* C,T0* a1,T0* a2,T0* a3);
/*IFTHENELSE*/void r385specialize_2_check(T385* C,T0* a1);
/*IFTHENELSE*/void r385compile_to_c_with_internal_c_local_saving(T385* C,T0* a1);
/*IFTHENELSE*/T0* r385specialize_in(T385* C,T0* a1);
/*IFTHENELSE*/void r385compile_to_c(T385* C,T0* a1);
/*IFTHENELSE*/T6 r385use_current(T385* C,T0* a1);
/*IFTHENELSE*/T0* r385specialize_2_without_checks(T385* C,T0* a1);
/*IFTHENELSE*/T6 r385side_effect_free(T0* a1);
/*IFTHENELSE*/void r385accept(T385* C,T0* a1);
/*IFTHENELSE*/void r385specialize_2_check_(T385* C,T0* a1);
/*IFTHENELSE*/T0* r385adapt_for(T385* C,T0* a1);
/*IFTHENELSE*/void r385ifelseifelse(T385* C,T296 a1,T0* a2,T0* a3,T0* a4,T296 a5,T0* a6);
/*IFTHENELSE*/T0* r385simplify_elseif_list(T0* a1,T6 a2,T0* a3);
/*IFTHENELSE*/void r385ifthenelse(T385* C,T296 a1,T0* a2,T0* a3,T296 a4,T0* a5);
/*IFTHENELSE*/T0* r385twin(T385* C);
/*IFTHENELSE*/void r385set_else(T385* C,T296 a1,T0* a2);
/*IFTHENELSE*/void r385ifelseif(T385* C,T296 a1,T0* a2,T0* a3,T0* a4);
/*IFTHENELSE*/void r385safety_check(T385* C,T0* a1);
/*WHEN_CLAUSE*/T2 r476locate_in_values(T476* C,T2 a1);
/*WHEN_CLAUSE*/T0* r476specialize_2_when_items_integer(T476* C,T0* a1,T0* a2);
/*WHEN_CLAUSE*/void r476compute_values(T476* C);
/*WHEN_CLAUSE*/void r476copy(T476* C,T0* a1);
/*WHEN_CLAUSE*/void r476add_slice(T476* C,T0* a1,T0* a2);
/*WHEN_CLAUSE*/void r476compute_values_with_item_1(T476* C,T0* a1);
/*WHEN_CLAUSE*/void r476compute_values_with_item_2(T476* C,T0* a1);
/*WHEN_CLAUSE*/T0* r476specialize_2_character(T476* C,T0* a1);
/*WHEN_CLAUSE*/void r476init(T476* C,T0* a1,T0* a2);
/*WHEN_CLAUSE*/T6 r476validity_check_continued(T476* C,T0* a1);
/*WHEN_CLAUSE*/void r476share_values_of(T476* C,T0* a1);
/*WHEN_CLAUSE*/void r476validity_check(T476* C,T0* a1,T0* a2);
/*WHEN_CLAUSE*/void r476make_strippable(T476* C,T0* a1,T0* a2);
/*WHEN_CLAUSE*/void r476collect(T476* C,T0* a1,T0* a2);
/*WHEN_CLAUSE*/T0* r476specialize_thru(T476* C,T0* a1,T0* a2,T0* a3);
/*WHEN_CLAUSE*/T0* r476specialize_in(T476* C,T0* a1);
/*WHEN_CLAUSE*/void r476compile_to_c(T476* C,T0* a1);
/*WHEN_CLAUSE*/T6 r476use_current(T476* C,T0* a1);
/*WHEN_CLAUSE*/T2 r476largest_range_of_values(T476* C);
/*WHEN_CLAUSE*/void r476compile_to_c_switch(T476* C,T0* a1);
/*WHEN_CLAUSE*/T0* r476adapt_for(T476* C,T0* a1);
/*WHEN_CLAUSE*/T0* r476specialize_2_string(T476* C,T0* a1);
/*WHEN_CLAUSE*/void r476make(T476* C,T0* a1,T296 a2,T0* a3);
/*WHEN_CLAUSE*/T6 r476match_value(T476* C,T2 a1);
/*WHEN_CLAUSE*/T0* r476specialize_2_integer(T476* C,T0* a1);
/*WHEN_CLAUSE*/T0* r476twin(T476* C);
/*WHEN_CLAUSE*/void r476force_internal_character_values(T476* C,T0* a1);
/*WHEN_CLAUSE*/void r476add_value(T476* C,T0* a1);
/*WHEN_CLAUSE*/T6 r476is_live(T476* C,T0* a1);
/*WHEN_CLAUSE*/void r476no_manifest_string_slice_check(T0* a1);
/*WHEN_CLAUSE*/void r476force_internal_integer_values(T476* C,T0* a1);
/*WHEN_CLAUSE*/void r476safety_check(T476* C,T0* a1);
/*WHEN_CLAUSE*/T0* r476strip_or_set_value(T476* C,T2 a1,T0* a2,T0* a3);
/*INSPECT_STATEMENT*/T6 r392use_current(T392* C,T0* a1);
/*INSPECT_STATEMENT*/T0* r392specialize_2_without_checks(T392* C,T0* a1);
/*INSPECT_STATEMENT*/T6 r392side_effect_free(T0* a1);
/*INSPECT_STATEMENT*/void r392copy(T392* C,T0* a1);
/*INSPECT_STATEMENT*/T0* r392adapt_for(T392* C,T0* a1);
/*INSPECT_STATEMENT*/T0* r392current_or_twin_init(T392* C,T0* a1,T0* a2,T0* a3);
extern T0*oBC28count_name;
extern int fBC28count_name;
/*INSPECT_STATEMENT*/T0* r392count_name(void);
/*INSPECT_STATEMENT*/void r392collect(T392* C,T0* a1);
/*INSPECT_STATEMENT*/void r392accept(T392* C,T0* a1);
/*INSPECT_STATEMENT*/void r392make(T392* C,T296 a1,T0* a2);
/*INSPECT_STATEMENT*/T0* r392twin(T392* C);
/*INSPECT_STATEMENT*/void r392init(T392* C,T0* a1,T0* a2,T0* a3);
/*INSPECT_STATEMENT*/void r392compile_to_c_if(T392* C,T0* a1);
/*INSPECT_STATEMENT*/void r392force_internal_values(T392* C,T0* a1);
/*INSPECT_STATEMENT*/T0* r392simplify_routine_body_first(T392* C,T0* a1,T0* a2);
/*INSPECT_STATEMENT*/T0* r392count_call(T392* C,T0* a1,T0* a2);
/*INSPECT_STATEMENT*/void r392validity_check_continued(T392* C,T0* a1);
extern T0*oBC28item_name;
extern int fBC28item_name;
/*INSPECT_STATEMENT*/T0* r392item_name(void);
/*INSPECT_STATEMENT*/void r392share_values_of(T392* C,T0* a1);
/*INSPECT_STATEMENT*/void r392add_when(T392* C,T0* a1);
/*INSPECT_STATEMENT*/T0* r392simplify_with_prelude(T392* C,T0* a1,T0* a2);
/*INSPECT_STATEMENT*/void r392safety_check(T392* C,T0* a1);
/*INSPECT_STATEMENT*/void r392make_strippable(T392* C,T296 a1,T0* a2,T0* a3);
/*INSPECT_STATEMENT*/T0* r392prelude(T392* C,T0* a1);
/*INSPECT_STATEMENT*/T0* r392item_call(T392* C,T0* a1,T0* a2);
/*INSPECT_STATEMENT*/void r392set_else_compound(T392* C,T296 a1,T0* a2);
/*INSPECT_STATEMENT*/T0* r392exp_local(T392* C,T0* a1,T0* a2);
/*INSPECT_STATEMENT*/T0* r392state_local(T392* C,T0* a1);
/*INSPECT_STATEMENT*/void r392validity_check_and_compute_values(T392* C,T0* a1);
/*INSPECT_STATEMENT*/T0* r392specialize_2(T392* C,T0* a1);
/*INSPECT_STATEMENT*/T2 r392largest_range_of_values(T392* C);
/*INSPECT_STATEMENT*/T0* r392simplify_when_clause(T0* a1,T0* a2);
/*INSPECT_STATEMENT*/T0* r392simplify(T392* C,T0* a1);
/*INSPECT_STATEMENT*/T6 r392use_c_switch_statement(T392* C);
/*INSPECT_STATEMENT*/void r392compile_to_c_switch(T392* C,T0* a1);
/*INSPECT_STATEMENT*/T0* r392specialize_thru(T392* C,T0* a1,T0* a2,T0* a3);
/*INSPECT_STATEMENT*/void r392compile_to_c_with_internal_c_local_saving(T392* C,T0* a1);
/*INSPECT_STATEMENT*/T0* r392specialize_in(T392* C,T0* a1);
/*INSPECT_STATEMENT*/void r392compile_to_c(T392* C,T0* a1);
/*LOOP_INVARIANT*/void r532copy(T532* C,T0* a1);
/*LOOP_INVARIANT*/T0* r532specialize_2(T532* C,T0* a1);
/*LOOP_INVARIANT*/void r532compile_to_c_(T532* C,T0* a1,T6 a2,T6 a3);
/*LOOP_INVARIANT*/void r532collect(T532* C,T0* a1);
/*LOOP_INVARIANT*/T6 r532is_always_true(T532* C);
/*LOOP_INVARIANT*/T0* r532specialize_thru(T532* C,T0* a1,T0* a2,T0* a3);
/*LOOP_INVARIANT*/void r532c_compile_assertion(T532* C,T0* a1,T0* a2);
/*LOOP_INVARIANT*/T0* r532specialize_in(T532* C,T0* a1);
/*LOOP_INVARIANT*/void r532compile_to_c(T532* C,T0* a1);
/*LOOP_INVARIANT*/T6 r532use_current(T532* C,T0* a1);
/*LOOP_INVARIANT*/T0* r532adapt_for(T532* C,T0* a1);
/*LOOP_INVARIANT*/void r532make(T532* C,T296 a1,T0* a2,T0* a3);
/*LOOP_INVARIANT*/T0* r532twin(T532* C);
/*LOOP_VARIANT*/void r531copy(T531* C,T0* a1);
/*LOOP_VARIANT*/T0* r531specialize_2(T531* C,T0* a1);
/*LOOP_VARIANT*/void r531collect(T531* C,T0* a1);
/*LOOP_VARIANT*/T0* r531specialize_thru(T531* C,T0* a1,T0* a2,T0* a3);
/*LOOP_VARIANT*/T0* r531specialize_in(T531* C,T0* a1);
/*LOOP_VARIANT*/T6 r531use_current(T531* C,T0* a1);
/*LOOP_VARIANT*/T0* r531adapt_for(T531* C,T0* a1);
/*LOOP_VARIANT*/void r531make(T531* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*LOOP_VARIANT*/T0* r531twin(T531* C);
/*E_LOOP*/T0* r400simplify_routine_body_first(T400* C,T0* a1,T0* a2);
/*E_LOOP*/T0* r400specialize_2(T400* C,T0* a1);
/*E_LOOP*/T0* r400simplify(T400* C,T0* a1);
/*E_LOOP*/void r400collect(T400* C,T0* a1);
/*E_LOOP*/T0* r400specialize_thru(T400* C,T0* a1,T0* a2,T0* a3);
/*E_LOOP*/void r400compile_to_c_with_internal_c_local_saving(T400* C,T0* a1);
/*E_LOOP*/T6 r400loop_check(T400* C);
/*E_LOOP*/T0* r400specialize_in(T400* C,T0* a1);
/*E_LOOP*/void r400compile_to_c(T400* C,T0* a1);
/*E_LOOP*/T6 r400use_current(T400* C,T0* a1);
/*E_LOOP*/T0* r400specialize_2_without_checks(T400* C,T0* a1);
/*E_LOOP*/T6 r400side_effect_free(T0* a1);
/*E_LOOP*/void r400accept(T400* C,T0* a1);
/*E_LOOP*/T0* r400adapt_for(T400* C,T0* a1);
/*E_LOOP*/void r400make(T400* C,T296 a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*E_LOOP*/void r400specialize_2_checks(T400* C,T0* a1);
/*E_LOOP*/void r400safety_check(T400* C,T0* a1);
/*CREATE_INSTRUCTION*/T0* r398simplify_routine_body_first(T398* C,T0* a1,T0* a2);
/*CREATE_INSTRUCTION*/void r398copy(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/void r398init(T398* C,T0* a1,T0* a2,T0* a3);
/*CREATE_INSTRUCTION*/T0* r398any_default_create_fs(void);
/*CREATE_INSTRUCTION*/T0* r398specialize_2(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/T0* r398simplify(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/void r398collect(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/T0* r398current_or_twin_init(T398* C,T0* a1,T0* a2,T0* a3);
/*CREATE_INSTRUCTION*/T0* r398specialize_thru(T398* C,T0* a1,T0* a2,T0* a3);
/*CREATE_INSTRUCTION*/T0* r398arguments(T398* C);
/*CREATE_INSTRUCTION*/void r398compile_to_c_with_internal_c_local_saving(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/T0* r398specialize_in(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/void r398compile_to_c(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/T6 r398use_current(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/T0* r398specialize_2_without_checks(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/T6 r398side_effect_free(T0* a1);
/*CREATE_INSTRUCTION*/void r398accept(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/T0* r398adapt_for(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/void r398make(T398* C,T296 a1,T0* a2,T0* a3,T0* a4);
/*CREATE_INSTRUCTION*/T0* r398twin(T398* C);
/*CREATE_INSTRUCTION*/void r398specialize_2_checks(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/T0* r398created_type(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/T0* r398default_create_name(void);
/*CREATE_INSTRUCTION*/T0* r398creation_procedure(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/void r398safety_check(T398* C,T0* a1);
/*CREATE_INSTRUCTION*/void r398typed_internals(T398* C,T296 a1,T0* a2);
/*CREATE_INSTRUCTION*/void r398make_specialized(T398* C,T296 a1,T0* a2,T0* a3,T0* a4);
/*PRECURSOR_INSTRUCTION*/T0* r401simplify_routine_body_first(T401* C,T0* a1,T0* a2);
/*PRECURSOR_INSTRUCTION*/void r401copy(T401* C,T0* a1);
/*PRECURSOR_INSTRUCTION*/void r401set_specialized_parent(T401* C,T0* a1);
/*PRECURSOR_INSTRUCTION*/void r401init(T401* C,T0* a1,T0* a2);
/*PRECURSOR_INSTRUCTION*/T0* r401specialize_2(T401* C,T0* a1);
/*PRECURSOR_INSTRUCTION*/T0* r401simplify(T401* C,T0* a1);
/*PRECURSOR_INSTRUCTION*/void r401collect(T401* C,T0* a1);
/*PRECURSOR_INSTRUCTION*/T0* r401current_or_twin_init(T401* C,T0* a1,T0* a2);
/*PRECURSOR_INSTRUCTION*/T0* r401specialize_thru(T401* C,T0* a1,T0* a2,T0* a3);
/*PRECURSOR_INSTRUCTION*/void r401compile_to_c_with_internal_c_local_saving(T401* C,T0* a1);
/*PRECURSOR_INSTRUCTION*/T0* r401specialize_in(T401* C,T0* a1);
/*PRECURSOR_INSTRUCTION*/T0* r401feature_accumulator(void);
/*PRECURSOR_INSTRUCTION*/void r401compile_to_c(T401* C,T0* a1);
/*PRECURSOR_INSTRUCTION*/T6 r401use_current(T0* a1);
/*PRECURSOR_INSTRUCTION*/T0* r401specialize_2_without_checks(T401* C,T0* a1);
/*PRECURSOR_INSTRUCTION*/T6 r401side_effect_free(T0* a1);
/*PRECURSOR_INSTRUCTION*/void r401accept(T401* C,T0* a1);
/*PRECURSOR_INSTRUCTION*/T0* r401adapt_for(T401* C,T0* a1);
/*PRECURSOR_INSTRUCTION*/void r401make(T401* C,T296 a1,T0* a2,T0* a3);
/*PRECURSOR_INSTRUCTION*/T0* r401twin(T401* C);
/*PRECURSOR_INSTRUCTION*/void r401safety_check(T401* C,T0* a1);
/*ASSIGNMENT_ATTEMPT*/T0* r394simplify_routine_body_first(T394* C,T0* a1,T0* a2);
/*ASSIGNMENT_ATTEMPT*/T0* r394specialize_2(T394* C,T0* a1);
/*ASSIGNMENT_ATTEMPT*/T0* r394simplify(T394* C,T0* a1);
/*ASSIGNMENT_ATTEMPT*/void r394collect(T394* C,T0* a1);
/*ASSIGNMENT_ATTEMPT*/T0* r394specialize_thru(T394* C,T0* a1,T0* a2,T0* a3);
/*ASSIGNMENT_ATTEMPT*/void r394compile_to_c_with_internal_c_local_saving(T394* C,T0* a1);
/*ASSIGNMENT_ATTEMPT*/T0* r394specialize_in(T394* C,T0* a1);
/*ASSIGNMENT_ATTEMPT*/void r394compile_to_c(T394* C,T0* a1);
/*ASSIGNMENT_ATTEMPT*/T6 r394use_current(T394* C,T0* a1);
/*ASSIGNMENT_ATTEMPT*/T0* r394specialize_2_without_checks(T394* C,T0* a1);
/*ASSIGNMENT_ATTEMPT*/T6 r394side_effect_free(T0* a1);
/*ASSIGNMENT_ATTEMPT*/void r394accept(T394* C,T0* a1);
/*ASSIGNMENT_ATTEMPT*/T0* r394adapt_for(T394* C,T0* a1);
/*ASSIGNMENT_ATTEMPT*/void r394make(T394* C,T0* a1,T0* a2,T6 a3);
/*ASSIGNMENT_ATTEMPT*/T296 r394start_position(T394* C);
/*ASSIGNMENT_ATTEMPT*/void r394safety_check(T394* C,T0* a1);
T403*create403make(T0* a1,T0* a2);
T403*create403inline_make(T0* a1,T0* a2);
/*ASSIGNMENT*/T0* r403simplify_routine_body_first(T403* C,T0* a1,T0* a2);
/*ASSIGNMENT*/void r403inline_make(T403* C,T0* a1,T0* a2);
/*ASSIGNMENT*/void r403fatal_error_for(T403* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*ASSIGNMENT*/T0* r403specialize_2(T403* C,T0* a1);
/*ASSIGNMENT*/T0* r403simplify(T403* C,T0* a1);
/*ASSIGNMENT*/void r403collect(T403* C,T0* a1);
/*ASSIGNMENT*/T0* r403specialize_thru(T403* C,T0* a1,T0* a2,T0* a3);
/*ASSIGNMENT*/void r403compile_to_c_with_internal_c_local_saving(T403* C,T0* a1);
/*ASSIGNMENT*/T0* r403specialize_in(T403* C,T0* a1);
/*ASSIGNMENT*/void r403compile_to_c(T403* C,T0* a1);
/*ASSIGNMENT*/T6 r403use_current(T403* C,T0* a1);
/*ASSIGNMENT*/T0* r403specialize_2_without_checks(T403* C,T0* a1);
/*ASSIGNMENT*/T6 r403side_effect_free(T0* a1);
/*ASSIGNMENT*/void r403accept(T403* C,T0* a1);
/*ASSIGNMENT*/T0* r403adapt_for(T403* C,T0* a1);
/*ASSIGNMENT*/void r403make(T403* C,T0* a1,T0* a2);
/*ASSIGNMENT*/T296 r403start_position(T403* C);
/*ASSIGNMENT*/void r403safety_check(T403* C,T0* a1);
/*E_RETRY*/T0* r393simplify_routine_body_first(T393* C,T0* a1,T0* a2);
/*E_RETRY*/T0* r393specialize_2(T393* C,T0* a1);
/*E_RETRY*/T0* r393simplify(T393* C,T0* a1);
/*E_RETRY*/T0* r393specialize_thru(T393* C,T0* a1,T0* a2,T0* a3);
/*E_RETRY*/void r393compile_to_c_with_internal_c_local_saving(T0* a1);
/*E_RETRY*/T0* r393specialize_in(T393* C,T0* a1);
/*E_RETRY*/void r393compile_to_c(T0* a1);
/*E_RETRY*/T6 r393use_current(T0* a1);
/*E_RETRY*/T0* r393specialize_2_without_checks(T393* C,T0* a1);
/*E_RETRY*/T6 r393side_effect_free(T0* a1);
/*E_RETRY*/void r393accept(T393* C,T0* a1);
/*E_RETRY*/T0* r393adapt_for(T393* C,T0* a1);
/*E_RETRY*/void r393make(T393* C,T296 a1);
/*TMP_FEATURE*/void r665constant_attribute_common_checks(T665* C,T0* a1);
/*TMP_FEATURE*/T0* r665as_deferred_routine(T665* C);
/*TMP_FEATURE*/T0* r665as_external_routine(T665* C,T0* a1,T0* a2);
/*TMP_FEATURE*/void r665initialize(T665* C);
extern T0*oBC665names;
extern int fBC665names;
/*TMP_FEATURE*/T0* r665names(void);
/*TMP_FEATURE*/T0* r665as_writable_attribute(T665* C);
/*TMP_FEATURE*/T0* r665as_unique_constant(T665* C);
/*TMP_FEATURE*/T0* r665as_procedure_or_function(T665* C);
/*TMP_FEATURE*/void r665set_require(T665* C,T296 a1,T6 a2,T0* a3,T0* a4);
/*TMP_FEATURE*/T0* r665as_constant(T665* C,T0* a1);
/*TMP_FEATURE*/T0* r665as_string_constant(T665* C,T0* a1);
/*TMP_FEATURE*/T0* r665as_character_constant(T665* C,T0* a1);
/*TMP_FEATURE*/T0* r665as_once_routine(T665* C);
/*TMP_FEATURE*/T0* r665n(void);
/*TMP_FEATURE*/T0* r665as_boolean_constant(T665* C,T0* a1);
/*CLASS_NAME_LIST*/void r300append_in(T300* C,T0* a1);
/*CLASS_NAME_LIST*/T2 r300count(T300* C);
/*CLASS_NAME_LIST*/T0* r300item(T300* C,T2 a1);
/*CLASS_NAME_LIST*/void r300make_1(T300* C,T0* a1);
/*CLASS_NAME_LIST*/void r300add_last(T300* C,T0* a1);
/*CLASS_NAME_LIST*/T6 r300gives_permission_to(T300* C,T0* a1);
/*CLASS_NAME_LIST*/void r300merge(T300* C,T0* a1,T0* a2);
/*CLASS_NAME_LIST*/void r300locate_in_error_handler(T300* C);
/*CLASS_NAME_LIST*/T6 r300gives_permission_to_any(T300* C);
/*CLASS_NAME_LIST*/T6 r300wider_than(T300* C,T0* a1);
/*CLASS_NAME_LIST*/T2 r300index_of(T300* C,T0* a1);
/*CLIENT_LIST*/void r64append_in(T64* C,T0* a1);
/*CLIENT_LIST*/T6 r64gives_permission_to(T64* C,T0* a1);
/*CLIENT_LIST*/void r64merge(T64* C,T296 a1,T0* a2,T0* a3);
/*CLIENT_LIST*/void r64locate_in_error_handler(T64* C);
/*CLIENT_LIST*/T6 r64gives_permission_to_any(T64* C);
/*CLIENT_LIST*/T6 r64gives_no_permission(T64* C);
/*CLIENT_LIST*/void r64make(T64* C,T296 a1,T0* a2);
/*CLIENT_LIST*/T6 r64is_omitted(T64* C);
/*CLIENT_LIST*/T6 r64wider_than(T64* C,T0* a1);
/*CLIENT_LIST*/T0* r64merge_with(T64* C,T0* a1);
/*CLIENT_LIST*/T0* r64eiffel_view(T64* C);
/*FEATURE_CLAUSE*/void r549add_into(T549* C,T0* a1);
/*FEATURE_CLAUSE*/void r549make(T549* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*FEATURE_TEXT*/void r482add_into(T482* C,T0* a1,T0* a2);
/*FEATURE_TEXT*/void r482real_constant(T482* C,T0* a1,T0* a2,T0* a3);
/*FEATURE_TEXT*/void r482e_function(T482* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
/*FEATURE_TEXT*/void r482once_function(T482* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
/*FEATURE_TEXT*/void r482once_procedure(T482* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*FEATURE_TEXT*/void r482non_written_one(T482* C,T0* a1,T0* a2,T0* a3);
/*FEATURE_TEXT*/void r482writable_attribute(T482* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*FEATURE_TEXT*/void r482e_procedure(T482* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*FEATURE_TEXT*/void r482deferred_function(T482* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*FEATURE_TEXT*/void r482set_header_comment(T482* C,T0* a1);
/*FEATURE_TEXT*/void r482deferred_procedure(T482* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*FEATURE_TEXT*/void r482integer_constant(T482* C,T0* a1,T0* a2,T0* a3);
/*FEATURE_TEXT*/void r482unique_constant(T482* C,T0* a1,T0* a2);
/*FEATURE_TEXT*/void r482boolean_constant(T482* C,T0* a1,T0* a2,T0* a3);
/*FEATURE_TEXT*/void r482character_constant(T482* C,T0* a1,T0* a2,T0* a3);
/*FEATURE_TEXT*/void r482external_procedure(T482* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
/*FEATURE_TEXT*/void r482string_constant(T482* C,T0* a1,T0* a2,T0* a3);
/*FEATURE_TEXT*/void r482external_function(T482* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
/*FEATURE_TEXT*/void r482set_ensure_assertion(T482* C,T0* a1);
/*FEATURE_TEXT*/void r482set_rescue_compound(T482* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T6 r437use_current(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T6 r437side_effect_free(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/void r437copy(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T0* r437declaration_type(T437* C);
/*CALL_INFIX_IMPLIES*/T0* r437adapt_for(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T6 r437is_equal(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T0* r437resolve_in(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T0* r437current_or_twin_init(T437* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_IMPLIES*/T0* r437extra_local_expanded(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/void r437function_and_argument_count_check(T437* C,T0* a1,T0* a2);
/*CALL_INFIX_IMPLIES*/T0* r437written_declaration_type_mark(void);
/*CALL_INFIX_IMPLIES*/T0* r437collect(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T6 r437is_balanced_operator(T0* a1);
/*CALL_INFIX_IMPLIES*/void r437mapping_c_arg(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T0* r437feature_accumulator(void);
/*CALL_INFIX_IMPLIES*/T6 r437is_default_value(void);
/*CALL_INFIX_IMPLIES*/void r437mapping_c_target(T437* C,T0* a1,T0* a2);
/*CALL_INFIX_IMPLIES*/T0* r437non_void_no_dispatch_type(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/void r437accept(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/void r437call_proc_call_c2c(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T0* r437use_current_stack(void);
/*CALL_INFIX_IMPLIES*/void r437set_target(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T0* r437call_support_collect(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/void r437make(T437* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_IMPLIES*/void r437standard_check_export_and_obsolete_calls(T437* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_IMPLIES*/T0* r437twin(T437* C);
/*CALL_INFIX_IMPLIES*/void r437set_feature_stamp(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/void r437pretty(T437* C,T2 a1);
/*CALL_INFIX_IMPLIES*/T296 r437start_position(T437* C);
/*CALL_INFIX_IMPLIES*/void r437init(T437* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_IMPLIES*/T0* r437inline_with(T437* C,T0* a1,T0* a2);
/*CALL_INFIX_IMPLIES*/T0* r437arg1(T437* C);
/*CALL_INFIX_IMPLIES*/void r437bracketed_pretty(T437* C,T2 a1);
/*CALL_INFIX_IMPLIES*/void r437pretty_target(T437* C,T2 a1);
/*CALL_INFIX_IMPLIES*/void r437safety_check(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T0* r437specialize_2(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T0* r437simplify(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T0* r437specialize_thru(T437* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_IMPLIES*/T0* r437static_simplify(T437* C);
/*CALL_INFIX_IMPLIES*/void r437set_arguments(T437* C,T0* a1);
extern T0*oBC28eiffel_parser;
/*CALL_INFIX_IMPLIES*/T0* r437run_feature_for(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/void r437compile_to_c_with_internal_c_local_saving(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T0* r437specialize_in(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/void r437compile_to_c(T437* C,T0* a1);
/*CALL_INFIX_IMPLIES*/T0* r437_P_407_declaration_type(T437* C);
/*CALL_INFIX_XOR*/T6 r430use_current(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T6 r430side_effect_free(T430* C,T0* a1);
/*CALL_INFIX_XOR*/void r430copy(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T0* r430declaration_type(T430* C);
/*CALL_INFIX_XOR*/T0* r430adapt_for(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T6 r430is_equal(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T0* r430resolve_in(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T0* r430current_or_twin_init(T430* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_XOR*/T0* r430extra_local_expanded(T430* C,T0* a1);
/*CALL_INFIX_XOR*/void r430function_and_argument_count_check(T430* C,T0* a1,T0* a2);
/*CALL_INFIX_XOR*/T0* r430written_declaration_type_mark(void);
/*CALL_INFIX_XOR*/T0* r430collect(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T6 r430is_balanced_operator(T0* a1);
/*CALL_INFIX_XOR*/void r430mapping_c_arg(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T0* r430feature_accumulator(void);
/*CALL_INFIX_XOR*/T6 r430is_default_value(void);
/*CALL_INFIX_XOR*/void r430mapping_c_target(T430* C,T0* a1,T0* a2);
/*CALL_INFIX_XOR*/T0* r430non_void_no_dispatch_type(T430* C,T0* a1);
/*CALL_INFIX_XOR*/void r430accept(T430* C,T0* a1);
/*CALL_INFIX_XOR*/void r430call_proc_call_c2c(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T0* r430use_current_stack(void);
/*CALL_INFIX_XOR*/void r430set_target(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T0* r430call_support_collect(T430* C,T0* a1);
/*CALL_INFIX_XOR*/void r430make(T430* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_XOR*/void r430standard_check_export_and_obsolete_calls(T430* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_XOR*/T0* r430twin(T430* C);
/*CALL_INFIX_XOR*/void r430set_feature_stamp(T430* C,T0* a1);
/*CALL_INFIX_XOR*/void r430pretty(T430* C,T2 a1);
/*CALL_INFIX_XOR*/T296 r430start_position(T430* C);
/*CALL_INFIX_XOR*/void r430init(T430* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_XOR*/T0* r430inline_with(T430* C,T0* a1,T0* a2);
/*CALL_INFIX_XOR*/T0* r430arg1(T430* C);
/*CALL_INFIX_XOR*/void r430bracketed_pretty(T430* C,T2 a1);
/*CALL_INFIX_XOR*/void r430pretty_target(T430* C,T2 a1);
/*CALL_INFIX_XOR*/void r430safety_check(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T0* r430specialize_2(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T0* r430simplify(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T0* r430specialize_thru(T430* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_XOR*/T0* r430static_simplify(T430* C);
/*CALL_INFIX_XOR*/void r430set_arguments(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T0* r430run_feature_for(T430* C,T0* a1);
/*CALL_INFIX_XOR*/void r430compile_to_c_with_internal_c_local_saving(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T0* r430specialize_in(T430* C,T0* a1);
/*CALL_INFIX_XOR*/void r430compile_to_c(T430* C,T0* a1);
/*CALL_INFIX_XOR*/T0* r430_P_407_declaration_type(T430* C);
/*CALL_INFIX_OR*/T6 r453use_current(T453* C,T0* a1);
/*CALL_INFIX_OR*/T6 r453side_effect_free(T453* C,T0* a1);
/*CALL_INFIX_OR*/void r453copy(T453* C,T0* a1);
/*CALL_INFIX_OR*/T0* r453declaration_type(T453* C);
/*CALL_INFIX_OR*/T0* r453adapt_for(T453* C,T0* a1);
/*CALL_INFIX_OR*/T6 r453is_equal(T453* C,T0* a1);
/*CALL_INFIX_OR*/T0* r453resolve_in(T453* C,T0* a1);
/*CALL_INFIX_OR*/T0* r453current_or_twin_init(T453* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_OR*/T0* r453extra_local_expanded(T453* C,T0* a1);
/*CALL_INFIX_OR*/void r453function_and_argument_count_check(T453* C,T0* a1,T0* a2);
/*CALL_INFIX_OR*/T0* r453written_declaration_type_mark(void);
/*CALL_INFIX_OR*/T0* r453collect(T453* C,T0* a1);
/*CALL_INFIX_OR*/T6 r453is_balanced_operator(T0* a1);
/*CALL_INFIX_OR*/void r453mapping_c_arg(T453* C,T0* a1);
/*CALL_INFIX_OR*/T0* r453feature_accumulator(void);
/*CALL_INFIX_OR*/T6 r453is_default_value(void);
/*CALL_INFIX_OR*/void r453mapping_c_target(T453* C,T0* a1,T0* a2);
/*CALL_INFIX_OR*/T0* r453non_void_no_dispatch_type(T453* C,T0* a1);
/*CALL_INFIX_OR*/void r453accept(T453* C,T0* a1);
/*CALL_INFIX_OR*/void r453call_proc_call_c2c(T453* C,T0* a1);
/*CALL_INFIX_OR*/T0* r453use_current_stack(void);
/*CALL_INFIX_OR*/void r453set_target(T453* C,T0* a1);
/*CALL_INFIX_OR*/T0* r453call_support_collect(T453* C,T0* a1);
/*CALL_INFIX_OR*/void r453make(T453* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_OR*/void r453standard_check_export_and_obsolete_calls(T453* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_OR*/T0* r453twin(T453* C);
/*CALL_INFIX_OR*/void r453set_feature_stamp(T453* C,T0* a1);
/*CALL_INFIX_OR*/void r453pretty(T453* C,T2 a1);
/*CALL_INFIX_OR*/T296 r453start_position(T453* C);
/*CALL_INFIX_OR*/void r453init(T453* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_OR*/T0* r453inline_with(T453* C,T0* a1,T0* a2);
/*CALL_INFIX_OR*/T0* r453arg1(T453* C);
/*CALL_INFIX_OR*/void r453bracketed_pretty(T453* C,T2 a1);
/*CALL_INFIX_OR*/void r453pretty_target(T453* C,T2 a1);
/*CALL_INFIX_OR*/void r453safety_check(T453* C,T0* a1);
/*CALL_INFIX_OR*/T0* r453specialize_2(T453* C,T0* a1);
/*CALL_INFIX_OR*/T0* r453simplify(T453* C,T0* a1);
/*CALL_INFIX_OR*/T0* r453specialize_thru(T453* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_OR*/T0* r453static_simplify(T453* C);
/*CALL_INFIX_OR*/void r453set_arguments(T453* C,T0* a1);
/*CALL_INFIX_OR*/T0* r453run_feature_for(T453* C,T0* a1);
/*CALL_INFIX_OR*/void r453compile_to_c_with_internal_c_local_saving(T453* C,T0* a1);
/*CALL_INFIX_OR*/T0* r453specialize_in(T453* C,T0* a1);
/*CALL_INFIX_OR*/void r453compile_to_c(T453* C,T0* a1);
/*CALL_INFIX_OR*/T0* r453_P_407_declaration_type(T453* C);
/*CALL_INFIX_OR_ELSE*/T6 r452use_current(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T6 r452side_effect_free(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/void r452copy(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T0* r452declaration_type(T452* C);
/*CALL_INFIX_OR_ELSE*/T0* r452adapt_for(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T6 r452is_equal(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T0* r452resolve_in(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T0* r452current_or_twin_init(T452* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_OR_ELSE*/T0* r452extra_local_expanded(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/void r452function_and_argument_count_check(T452* C,T0* a1,T0* a2);
/*CALL_INFIX_OR_ELSE*/T0* r452written_declaration_type_mark(void);
/*CALL_INFIX_OR_ELSE*/T0* r452collect(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T6 r452is_balanced_operator(T0* a1);
/*CALL_INFIX_OR_ELSE*/void r452mapping_c_arg(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T0* r452feature_accumulator(void);
/*CALL_INFIX_OR_ELSE*/T6 r452is_default_value(void);
/*CALL_INFIX_OR_ELSE*/void r452mapping_c_target(T452* C,T0* a1,T0* a2);
/*CALL_INFIX_OR_ELSE*/T0* r452non_void_no_dispatch_type(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/void r452accept(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/void r452call_proc_call_c2c(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T0* r452use_current_stack(void);
/*CALL_INFIX_OR_ELSE*/void r452set_target(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T0* r452call_support_collect(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/void r452make(T452* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_OR_ELSE*/void r452standard_check_export_and_obsolete_calls(T452* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_OR_ELSE*/T0* r452twin(T452* C);
/*CALL_INFIX_OR_ELSE*/void r452set_feature_stamp(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/void r452pretty(T452* C,T2 a1);
/*CALL_INFIX_OR_ELSE*/T296 r452start_position(T452* C);
/*CALL_INFIX_OR_ELSE*/void r452init(T452* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_OR_ELSE*/T0* r452inline_with(T452* C,T0* a1,T0* a2);
/*CALL_INFIX_OR_ELSE*/T0* r452arg1(T452* C);
/*CALL_INFIX_OR_ELSE*/void r452bracketed_pretty(T452* C,T2 a1);
extern T0*oBC28or_else_name;
extern int fBC28or_else_name;
/*CALL_INFIX_OR_ELSE*/T0* r452or_else_name(void);
/*CALL_INFIX_OR_ELSE*/void r452pretty_target(T452* C,T2 a1);
/*CALL_INFIX_OR_ELSE*/void r452safety_check(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T0* r452specialize_2(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T0* r452simplify(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T0* r452specialize_thru(T452* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_OR_ELSE*/T0* r452static_simplify(T452* C);
/*CALL_INFIX_OR_ELSE*/void r452set_arguments(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T0* r452run_feature_for(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/void r452compile_to_c_with_internal_c_local_saving(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T0* r452specialize_in(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/void r452compile_to_c(T452* C,T0* a1);
/*CALL_INFIX_OR_ELSE*/T0* r452_P_407_declaration_type(T452* C);
/*CALL_INFIX_AND*/T6 r418use_current(T418* C,T0* a1);
/*CALL_INFIX_AND*/T6 r418side_effect_free(T418* C,T0* a1);
/*CALL_INFIX_AND*/void r418copy(T418* C,T0* a1);
/*CALL_INFIX_AND*/T0* r418declaration_type(T418* C);
/*CALL_INFIX_AND*/T0* r418adapt_for(T418* C,T0* a1);
/*CALL_INFIX_AND*/T6 r418is_equal(T418* C,T0* a1);
/*CALL_INFIX_AND*/T0* r418resolve_in(T418* C,T0* a1);
/*CALL_INFIX_AND*/T0* r418current_or_twin_init(T418* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_AND*/T0* r418extra_local_expanded(T418* C,T0* a1);
/*CALL_INFIX_AND*/void r418function_and_argument_count_check(T418* C,T0* a1,T0* a2);
/*CALL_INFIX_AND*/T0* r418written_declaration_type_mark(void);
/*CALL_INFIX_AND*/T0* r418collect(T418* C,T0* a1);
/*CALL_INFIX_AND*/T6 r418is_balanced_operator(T0* a1);
/*CALL_INFIX_AND*/void r418mapping_c_arg(T418* C,T0* a1);
/*CALL_INFIX_AND*/T0* r418feature_accumulator(void);
/*CALL_INFIX_AND*/T6 r418is_default_value(void);
/*CALL_INFIX_AND*/void r418mapping_c_target(T418* C,T0* a1,T0* a2);
/*CALL_INFIX_AND*/T0* r418non_void_no_dispatch_type(T418* C,T0* a1);
/*CALL_INFIX_AND*/void r418accept(T418* C,T0* a1);
/*CALL_INFIX_AND*/void r418call_proc_call_c2c(T418* C,T0* a1);
/*CALL_INFIX_AND*/T0* r418use_current_stack(void);
/*CALL_INFIX_AND*/void r418set_target(T418* C,T0* a1);
/*CALL_INFIX_AND*/T0* r418call_support_collect(T418* C,T0* a1);
/*CALL_INFIX_AND*/void r418make(T418* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_AND*/void r418standard_check_export_and_obsolete_calls(T418* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_AND*/T0* r418twin(T418* C);
/*CALL_INFIX_AND*/void r418set_feature_stamp(T418* C,T0* a1);
/*CALL_INFIX_AND*/void r418pretty(T418* C,T2 a1);
/*CALL_INFIX_AND*/T296 r418start_position(T418* C);
/*CALL_INFIX_AND*/void r418init(T418* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_AND*/T0* r418inline_with(T418* C,T0* a1,T0* a2);
/*CALL_INFIX_AND*/T0* r418arg1(T418* C);
/*CALL_INFIX_AND*/void r418bracketed_pretty(T418* C,T2 a1);
/*CALL_INFIX_AND*/void r418pretty_target(T418* C,T2 a1);
/*CALL_INFIX_AND*/void r418safety_check(T418* C,T0* a1);
/*CALL_INFIX_AND*/T0* r418specialize_2(T418* C,T0* a1);
/*CALL_INFIX_AND*/T0* r418simplify(T418* C,T0* a1);
/*CALL_INFIX_AND*/T0* r418specialize_thru(T418* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_AND*/T0* r418static_simplify(T418* C);
/*CALL_INFIX_AND*/void r418set_arguments(T418* C,T0* a1);
/*CALL_INFIX_AND*/T0* r418run_feature_for(T418* C,T0* a1);
/*CALL_INFIX_AND*/void r418compile_to_c_with_internal_c_local_saving(T418* C,T0* a1);
/*CALL_INFIX_AND*/T0* r418specialize_in(T418* C,T0* a1);
/*CALL_INFIX_AND*/void r418compile_to_c(T418* C,T0* a1);
/*CALL_INFIX_AND*/T0* r418_P_407_declaration_type(T418* C);
/*CALL_INFIX_AND_THEN*/T6 r429use_current(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T6 r429side_effect_free(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/void r429copy(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T0* r429declaration_type(T429* C);
/*CALL_INFIX_AND_THEN*/T0* r429adapt_for(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T6 r429is_equal(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T0* r429resolve_in(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T0* r429current_or_twin_init(T429* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_AND_THEN*/T0* r429extra_local_expanded(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/void r429function_and_argument_count_check(T429* C,T0* a1,T0* a2);
/*CALL_INFIX_AND_THEN*/T0* r429written_declaration_type_mark(void);
/*CALL_INFIX_AND_THEN*/T0* r429collect(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T6 r429is_balanced_operator(T0* a1);
/*CALL_INFIX_AND_THEN*/void r429mapping_c_arg(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T0* r429feature_accumulator(void);
/*CALL_INFIX_AND_THEN*/T6 r429is_default_value(void);
/*CALL_INFIX_AND_THEN*/void r429mapping_c_target(T429* C,T0* a1,T0* a2);
/*CALL_INFIX_AND_THEN*/T0* r429non_void_no_dispatch_type(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/void r429accept(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/void r429call_proc_call_c2c(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T0* r429use_current_stack(void);
/*CALL_INFIX_AND_THEN*/void r429set_target(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T0* r429call_support_collect(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/void r429make(T429* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_AND_THEN*/void r429standard_check_export_and_obsolete_calls(T429* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_AND_THEN*/T0* r429twin(T429* C);
/*CALL_INFIX_AND_THEN*/void r429set_feature_stamp(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/void r429pretty(T429* C,T2 a1);
/*CALL_INFIX_AND_THEN*/T296 r429start_position(T429* C);
/*CALL_INFIX_AND_THEN*/void r429init(T429* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_AND_THEN*/T0* r429inline_with(T429* C,T0* a1,T0* a2);
/*CALL_INFIX_AND_THEN*/T0* r429arg1(T429* C);
/*CALL_INFIX_AND_THEN*/T0* r429and_then_name(void);
/*CALL_INFIX_AND_THEN*/void r429bracketed_pretty(T429* C,T2 a1);
/*CALL_INFIX_AND_THEN*/void r429pretty_target(T429* C,T2 a1);
/*CALL_INFIX_AND_THEN*/void r429safety_check(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T0* r429specialize_2(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T0* r429simplify(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T0* r429specialize_thru(T429* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_AND_THEN*/T0* r429static_simplify(T429* C);
/*CALL_INFIX_AND_THEN*/void r429set_arguments(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T0* r429run_feature_for(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/void r429compile_to_c_with_internal_c_local_saving(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T0* r429specialize_in(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/void r429compile_to_c(T429* C,T0* a1);
/*CALL_INFIX_AND_THEN*/T0* r429_P_407_declaration_type(T429* C);
/*CALL_INFIX_LE*/T6 r463use_current(T463* C,T0* a1);
/*CALL_INFIX_LE*/T6 r463side_effect_free(T463* C,T0* a1);
/*CALL_INFIX_LE*/void r463copy(T463* C,T0* a1);
/*CALL_INFIX_LE*/T0* r463declaration_type(T463* C);
/*CALL_INFIX_LE*/T0* r463adapt_for(T463* C,T0* a1);
/*CALL_INFIX_LE*/T6 r463is_equal(T463* C,T0* a1);
/*CALL_INFIX_LE*/T0* r463resolve_in(T463* C,T0* a1);
/*CALL_INFIX_LE*/T0* r463current_or_twin_init(T463* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_LE*/T0* r463extra_local_expanded(T463* C,T0* a1);
/*CALL_INFIX_LE*/void r463function_and_argument_count_check(T463* C,T0* a1,T0* a2);
/*CALL_INFIX_LE*/T0* r463written_declaration_type_mark(void);
/*CALL_INFIX_LE*/T0* r463collect(T463* C,T0* a1);
/*CALL_INFIX_LE*/T6 r463is_balanced_operator(T0* a1);
/*CALL_INFIX_LE*/void r463c2c_cast_op(T463* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_LE*/void r463mapping_c_arg(T463* C,T0* a1);
/*CALL_INFIX_LE*/T0* r463feature_accumulator(void);
/*CALL_INFIX_LE*/T6 r463is_default_value(void);
/*CALL_INFIX_LE*/void r463mapping_c_target(T463* C,T0* a1,T0* a2);
/*CALL_INFIX_LE*/T0* r463non_void_no_dispatch_type(T463* C,T0* a1);
/*CALL_INFIX_LE*/void r463accept(T463* C,T0* a1);
/*CALL_INFIX_LE*/void r463call_proc_call_c2c(T463* C,T0* a1);
/*CALL_INFIX_LE*/T0* r463use_current_stack(void);
/*CALL_INFIX_LE*/void r463set_target(T463* C,T0* a1);
/*CALL_INFIX_LE*/T0* r463call_support_collect(T463* C,T0* a1);
/*CALL_INFIX_LE*/void r463make(T463* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_LE*/void r463standard_check_export_and_obsolete_calls(T463* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_LE*/T0* r463twin(T463* C);
/*CALL_INFIX_LE*/void r463set_feature_stamp(T463* C,T0* a1);
/*CALL_INFIX_LE*/void r463pretty(T463* C,T2 a1);
/*CALL_INFIX_LE*/T296 r463start_position(T463* C);
/*CALL_INFIX_LE*/void r463init(T463* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_LE*/T0* r463inline_with(T463* C,T0* a1,T0* a2);
/*CALL_INFIX_LE*/T0* r463arg1(T463* C);
/*CALL_INFIX_LE*/void r463bracketed_pretty(T463* C,T2 a1);
/*CALL_INFIX_LE*/void r463pretty_target(T463* C,T2 a1);
/*CALL_INFIX_LE*/void r463safety_check(T463* C,T0* a1);
/*CALL_INFIX_LE*/T0* r463specialize_2(T463* C,T0* a1);
/*CALL_INFIX_LE*/T0* r463simplify(T463* C,T0* a1);
/*CALL_INFIX_LE*/T0* r463specialize_thru(T463* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_LE*/T0* r463static_simplify(T463* C);
/*CALL_INFIX_LE*/void r463set_arguments(T463* C,T0* a1);
/*CALL_INFIX_LE*/T0* r463run_feature_for(T463* C,T0* a1);
/*CALL_INFIX_LE*/void r463compile_to_c_with_internal_c_local_saving(T463* C,T0* a1);
/*CALL_INFIX_LE*/T0* r463specialize_in(T463* C,T0* a1);
/*CALL_INFIX_LE*/void r463compile_to_c(T463* C,T0* a1);
/*CALL_INFIX_LE*/T0* r463_P_407_declaration_type(T463* C);
/*CALL_INFIX_GE*/T6 r471use_current(T471* C,T0* a1);
/*CALL_INFIX_GE*/T6 r471side_effect_free(T471* C,T0* a1);
/*CALL_INFIX_GE*/void r471copy(T471* C,T0* a1);
/*CALL_INFIX_GE*/T0* r471declaration_type(T471* C);
/*CALL_INFIX_GE*/T0* r471adapt_for(T471* C,T0* a1);
/*CALL_INFIX_GE*/T6 r471is_equal(T471* C,T0* a1);
/*CALL_INFIX_GE*/T0* r471resolve_in(T471* C,T0* a1);
/*CALL_INFIX_GE*/T0* r471current_or_twin_init(T471* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_GE*/T0* r471extra_local_expanded(T471* C,T0* a1);
/*CALL_INFIX_GE*/void r471function_and_argument_count_check(T471* C,T0* a1,T0* a2);
/*CALL_INFIX_GE*/T0* r471written_declaration_type_mark(void);
/*CALL_INFIX_GE*/T0* r471collect(T471* C,T0* a1);
/*CALL_INFIX_GE*/T6 r471is_balanced_operator(T0* a1);
/*CALL_INFIX_GE*/void r471c2c_cast_op(T471* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_GE*/void r471mapping_c_arg(T471* C,T0* a1);
/*CALL_INFIX_GE*/T0* r471feature_accumulator(void);
/*CALL_INFIX_GE*/T6 r471is_default_value(void);
/*CALL_INFIX_GE*/void r471mapping_c_target(T471* C,T0* a1,T0* a2);
/*CALL_INFIX_GE*/T0* r471non_void_no_dispatch_type(T471* C,T0* a1);
/*CALL_INFIX_GE*/void r471accept(T471* C,T0* a1);
/*CALL_INFIX_GE*/void r471call_proc_call_c2c(T471* C,T0* a1);
/*CALL_INFIX_GE*/T0* r471use_current_stack(void);
/*CALL_INFIX_GE*/void r471set_target(T471* C,T0* a1);
/*CALL_INFIX_GE*/T0* r471call_support_collect(T471* C,T0* a1);
/*CALL_INFIX_GE*/void r471make(T471* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_GE*/void r471standard_check_export_and_obsolete_calls(T471* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_GE*/T0* r471twin(T471* C);
/*CALL_INFIX_GE*/void r471set_feature_stamp(T471* C,T0* a1);
/*CALL_INFIX_GE*/void r471pretty(T471* C,T2 a1);
/*CALL_INFIX_GE*/T296 r471start_position(T471* C);
/*CALL_INFIX_GE*/void r471init(T471* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_GE*/T0* r471inline_with(T471* C,T0* a1,T0* a2);
/*CALL_INFIX_GE*/T0* r471arg1(T471* C);
/*CALL_INFIX_GE*/void r471bracketed_pretty(T471* C,T2 a1);
/*CALL_INFIX_GE*/void r471pretty_target(T471* C,T2 a1);
/*CALL_INFIX_GE*/void r471safety_check(T471* C,T0* a1);
/*CALL_INFIX_GE*/T0* r471specialize_2(T471* C,T0* a1);
/*CALL_INFIX_GE*/T0* r471simplify(T471* C,T0* a1);
/*CALL_INFIX_GE*/T0* r471specialize_thru(T471* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_GE*/T0* r471static_simplify(T471* C);
/*CALL_INFIX_GE*/void r471set_arguments(T471* C,T0* a1);
/*CALL_INFIX_GE*/T0* r471run_feature_for(T471* C,T0* a1);
/*CALL_INFIX_GE*/void r471compile_to_c_with_internal_c_local_saving(T471* C,T0* a1);
/*CALL_INFIX_GE*/T0* r471specialize_in(T471* C,T0* a1);
/*CALL_INFIX_GE*/void r471compile_to_c(T471* C,T0* a1);
/*CALL_INFIX_GE*/T0* r471_P_407_declaration_type(T471* C);
/*CALL_INFIX_LT*/T6 r458use_current(T458* C,T0* a1);
/*CALL_INFIX_LT*/T6 r458side_effect_free(T458* C,T0* a1);
/*CALL_INFIX_LT*/void r458copy(T458* C,T0* a1);
/*CALL_INFIX_LT*/T0* r458declaration_type(T458* C);
/*CALL_INFIX_LT*/T0* r458adapt_for(T458* C,T0* a1);
/*CALL_INFIX_LT*/T6 r458is_equal(T458* C,T0* a1);
/*CALL_INFIX_LT*/T0* r458resolve_in(T458* C,T0* a1);
/*CALL_INFIX_LT*/T0* r458current_or_twin_init(T458* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_LT*/T0* r458extra_local_expanded(T458* C,T0* a1);
/*CALL_INFIX_LT*/void r458function_and_argument_count_check(T458* C,T0* a1,T0* a2);
/*CALL_INFIX_LT*/T0* r458written_declaration_type_mark(void);
/*CALL_INFIX_LT*/T0* r458collect(T458* C,T0* a1);
/*CALL_INFIX_LT*/T6 r458is_balanced_operator(T0* a1);
/*CALL_INFIX_LT*/void r458c2c_cast_op(T458* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_LT*/void r458mapping_c_arg(T458* C,T0* a1);
/*CALL_INFIX_LT*/T0* r458feature_accumulator(void);
/*CALL_INFIX_LT*/T6 r458is_default_value(void);
/*CALL_INFIX_LT*/void r458mapping_c_target(T458* C,T0* a1,T0* a2);
/*CALL_INFIX_LT*/T0* r458non_void_no_dispatch_type(T458* C,T0* a1);
/*CALL_INFIX_LT*/void r458accept(T458* C,T0* a1);
/*CALL_INFIX_LT*/void r458call_proc_call_c2c(T458* C,T0* a1);
/*CALL_INFIX_LT*/T0* r458use_current_stack(void);
/*CALL_INFIX_LT*/void r458set_target(T458* C,T0* a1);
/*CALL_INFIX_LT*/T0* r458call_support_collect(T458* C,T0* a1);
/*CALL_INFIX_LT*/void r458make(T458* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_LT*/void r458standard_check_export_and_obsolete_calls(T458* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_LT*/T0* r458twin(T458* C);
/*CALL_INFIX_LT*/void r458set_feature_stamp(T458* C,T0* a1);
/*CALL_INFIX_LT*/void r458pretty(T458* C,T2 a1);
/*CALL_INFIX_LT*/T296 r458start_position(T458* C);
/*CALL_INFIX_LT*/void r458init(T458* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_LT*/T0* r458inline_with(T458* C,T0* a1,T0* a2);
/*CALL_INFIX_LT*/T0* r458arg1(T458* C);
/*CALL_INFIX_LT*/void r458bracketed_pretty(T458* C,T2 a1);
/*CALL_INFIX_LT*/void r458pretty_target(T458* C,T2 a1);
/*CALL_INFIX_LT*/void r458safety_check(T458* C,T0* a1);
/*CALL_INFIX_LT*/T0* r458specialize_2(T458* C,T0* a1);
/*CALL_INFIX_LT*/T0* r458simplify(T458* C,T0* a1);
/*CALL_INFIX_LT*/T0* r458specialize_thru(T458* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_LT*/T0* r458static_simplify(T458* C);
/*CALL_INFIX_LT*/void r458set_arguments(T458* C,T0* a1);
/*CALL_INFIX_LT*/T0* r458run_feature_for(T458* C,T0* a1);
/*CALL_INFIX_LT*/void r458compile_to_c_with_internal_c_local_saving(T458* C,T0* a1);
/*CALL_INFIX_LT*/T0* r458specialize_in(T458* C,T0* a1);
/*CALL_INFIX_LT*/void r458compile_to_c(T458* C,T0* a1);
/*CALL_INFIX_LT*/T0* r458_P_407_declaration_type(T458* C);
/*CALL_INFIX_GT*/T6 r464use_current(T464* C,T0* a1);
/*CALL_INFIX_GT*/T6 r464side_effect_free(T464* C,T0* a1);
/*CALL_INFIX_GT*/void r464copy(T464* C,T0* a1);
/*CALL_INFIX_GT*/T0* r464declaration_type(T464* C);
/*CALL_INFIX_GT*/T0* r464adapt_for(T464* C,T0* a1);
/*CALL_INFIX_GT*/T6 r464is_equal(T464* C,T0* a1);
/*CALL_INFIX_GT*/T0* r464resolve_in(T464* C,T0* a1);
/*CALL_INFIX_GT*/T0* r464current_or_twin_init(T464* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_GT*/T0* r464extra_local_expanded(T464* C,T0* a1);
/*CALL_INFIX_GT*/void r464function_and_argument_count_check(T464* C,T0* a1,T0* a2);
/*CALL_INFIX_GT*/T0* r464written_declaration_type_mark(void);
/*CALL_INFIX_GT*/T0* r464collect(T464* C,T0* a1);
/*CALL_INFIX_GT*/T6 r464is_balanced_operator(T0* a1);
/*CALL_INFIX_GT*/void r464c2c_cast_op(T464* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_GT*/void r464mapping_c_arg(T464* C,T0* a1);
/*CALL_INFIX_GT*/T0* r464feature_accumulator(void);
/*CALL_INFIX_GT*/T6 r464is_default_value(void);
/*CALL_INFIX_GT*/void r464mapping_c_target(T464* C,T0* a1,T0* a2);
/*CALL_INFIX_GT*/T0* r464non_void_no_dispatch_type(T464* C,T0* a1);
/*CALL_INFIX_GT*/void r464accept(T464* C,T0* a1);
/*CALL_INFIX_GT*/void r464call_proc_call_c2c(T464* C,T0* a1);
/*CALL_INFIX_GT*/T0* r464use_current_stack(void);
/*CALL_INFIX_GT*/void r464set_target(T464* C,T0* a1);
/*CALL_INFIX_GT*/T0* r464call_support_collect(T464* C,T0* a1);
/*CALL_INFIX_GT*/void r464make(T464* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_GT*/void r464standard_check_export_and_obsolete_calls(T464* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_GT*/T0* r464twin(T464* C);
/*CALL_INFIX_GT*/void r464set_feature_stamp(T464* C,T0* a1);
/*CALL_INFIX_GT*/void r464pretty(T464* C,T2 a1);
/*CALL_INFIX_GT*/T296 r464start_position(T464* C);
/*CALL_INFIX_GT*/void r464init(T464* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_GT*/T0* r464inline_with(T464* C,T0* a1,T0* a2);
/*CALL_INFIX_GT*/T0* r464arg1(T464* C);
/*CALL_INFIX_GT*/void r464bracketed_pretty(T464* C,T2 a1);
/*CALL_INFIX_GT*/void r464pretty_target(T464* C,T2 a1);
/*CALL_INFIX_GT*/void r464safety_check(T464* C,T0* a1);
/*CALL_INFIX_GT*/T0* r464specialize_2(T464* C,T0* a1);
/*CALL_INFIX_GT*/T0* r464simplify(T464* C,T0* a1);
/*CALL_INFIX_GT*/T0* r464specialize_thru(T464* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_GT*/T0* r464static_simplify(T464* C);
/*CALL_INFIX_GT*/void r464set_arguments(T464* C,T0* a1);
/*CALL_INFIX_GT*/T0* r464run_feature_for(T464* C,T0* a1);
/*CALL_INFIX_GT*/void r464compile_to_c_with_internal_c_local_saving(T464* C,T0* a1);
/*CALL_INFIX_GT*/T0* r464specialize_in(T464* C,T0* a1);
/*CALL_INFIX_GT*/void r464compile_to_c(T464* C,T0* a1);
/*CALL_INFIX_GT*/T0* r464_P_407_declaration_type(T464* C);
T410*create410make_eq(T0* a1,T296 a2,T0* a3);
/*BUILT_IN_EQ_NEQ*/T6 r410use_current(T410* C,T0* a1);
/*BUILT_IN_EQ_NEQ*/T6 r410side_effect_free(T410* C,T0* a1);
/*BUILT_IN_EQ_NEQ*/void r410copy(T410* C,T0* a1);
extern T0*oBC410declaration_type;
extern int fBC410declaration_type;
/*BUILT_IN_EQ_NEQ*/T0* r410declaration_type(void);
/*BUILT_IN_EQ_NEQ*/T0* r410adapt_for(T410* C,T0* a1);
/*BUILT_IN_EQ_NEQ*/T6 r410is_equal(T410* C,T0* a1);
/*BUILT_IN_EQ_NEQ*/T0* r410resolve_in(T0* a1);
/*BUILT_IN_EQ_NEQ*/T0* r410true_or_false(T410* C,T6 a1);
/*BUILT_IN_EQ_NEQ*/T0* r410written_declaration_type_mark(void);
/*BUILT_IN_EQ_NEQ*/T0* r410collect(T410* C,T0* a1);
/*BUILT_IN_EQ_NEQ*/T6 r410is_static(T410* C);
/*BUILT_IN_EQ_NEQ*/void r410mapping_c_arg(T410* C,T0* a1);
/*BUILT_IN_EQ_NEQ*/T6 r410is_default_value(void);
/*BUILT_IN_EQ_NEQ*/void r410mapping_c_target(T410* C,T0* a1,T0* a2);
/*BUILT_IN_EQ_NEQ*/T0* r410non_void_no_dispatch_type(T0* a1);
/*BUILT_IN_EQ_NEQ*/void r410specialize_2_standard_comparison_check(T410* C,T0* a1,T0* a2,T0* a3);
/*BUILT_IN_EQ_NEQ*/T0* r410simplify_integer_real(T410* C,T0* a1,T0* a2);
/*BUILT_IN_EQ_NEQ*/T0* r410simplify_boolean_constant(T410* C,T0* a1,T0* a2);
/*BUILT_IN_EQ_NEQ*/T0* r410simplify_null_pointer(T410* C,T0* a1,T0* a2);
/*BUILT_IN_EQ_NEQ*/void r410accept(T410* C,T0* a1);
/*BUILT_IN_EQ_NEQ*/T0* r410simplify_void(T410* C,T0* a1,T0* a2,T0* a3);
/*BUILT_IN_EQ_NEQ*/void r410make_eq(T410* C,T0* a1,T296 a2,T0* a3);
/*BUILT_IN_EQ_NEQ*/void r410basic_make(T410* C,T6 a1,T0* a2,T296 a3,T0* a4);
/*BUILT_IN_EQ_NEQ*/void r410compile_to_c_for_reference(T410* C,T0* a1,T0* a2,T0* a3);
/*BUILT_IN_EQ_NEQ*/void r410void_comparison_check(T410* C,T0* a1);
/*BUILT_IN_EQ_NEQ*/void r410cmp_user_expanded(T410* C,T0* a1,T0* a2);
/*BUILT_IN_EQ_NEQ*/T0* r410twin(T410* C);
/*BUILT_IN_EQ_NEQ*/void r410c2c_cmp_expanded_with_void(T410* C,T0* a1,T0* a2);
/*BUILT_IN_EQ_NEQ*/T0* r410simplify_character_constant(T410* C,T0* a1,T0* a2);
/*BUILT_IN_EQ_NEQ*/void r410set_left_and_right(T410* C,T0* a1,T0* a2);
/*BUILT_IN_EQ_NEQ*/void r410pretty(T410* C,T2 a1);
extern T0*oBC28precomputable_routine_detector;
/*BUILT_IN_EQ_NEQ*/void r410make_neq(T410* C,T0* a1,T296 a2,T0* a3);
/*BUILT_IN_EQ_NEQ*/void r410cmp_basic_eiffel_expanded(T410* C,T0* a1,T0* a2,T0* a3);
/*BUILT_IN_EQ_NEQ*/T296 r410start_position(T410* C);
/*BUILT_IN_EQ_NEQ*/T0* r410inline_with(T410* C,T0* a1,T0* a2);
/*BUILT_IN_EQ_NEQ*/void r410bracketed_pretty(T410* C,T2 a1);
/*BUILT_IN_EQ_NEQ*/void r410pretty_target(T410* C,T2 a1);
/*BUILT_IN_EQ_NEQ*/void r410safety_check(T410* C,T0* a1);
/*BUILT_IN_EQ_NEQ*/T0* r410specialize_2(T410* C,T0* a1);
/*BUILT_IN_EQ_NEQ*/T0* r410simplify(T410* C,T0* a1);
/*BUILT_IN_EQ_NEQ*/T0* r410specialize_thru(T410* C,T0* a1,T0* a2,T0* a3);
/*BUILT_IN_EQ_NEQ*/T0* r410static_simplify(T410* C);
/*BUILT_IN_EQ_NEQ*/void r410compile_to_c_with_internal_c_local_saving(T410* C,T0* a1);
/*BUILT_IN_EQ_NEQ*/T0* r410specialize_in(T410* C,T0* a1);
/*BUILT_IN_EQ_NEQ*/void r410compile_to_c(T410* C,T0* a1);
/*CALL_INFIX_MINUS*/T6 r455use_current(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T6 r455side_effect_free(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/void r455copy(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T0* r455declaration_type(T455* C);
/*CALL_INFIX_MINUS*/T0* r455adapt_for(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T6 r455is_equal(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T0* r455resolve_in(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T0* r455current_or_twin_init(T455* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_MINUS*/T0* r455extra_local_expanded(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/void r455function_and_argument_count_check(T455* C,T0* a1,T0* a2);
/*CALL_INFIX_MINUS*/T0* r455written_declaration_type_mark(void);
/*CALL_INFIX_MINUS*/T0* r455collect(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T6 r455is_balanced_operator(T0* a1);
/*CALL_INFIX_MINUS*/void r455mapping_c_arg(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T0* r455feature_accumulator(void);
/*CALL_INFIX_MINUS*/T6 r455is_default_value(void);
/*CALL_INFIX_MINUS*/void r455mapping_c_target(T455* C,T0* a1,T0* a2);
/*CALL_INFIX_MINUS*/T0* r455non_void_no_dispatch_type(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/void r455accept(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/void r455call_proc_call_c2c(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T0* r455use_current_stack(void);
/*CALL_INFIX_MINUS*/void r455set_target(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T0* r455call_support_collect(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/void r455make(T455* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_MINUS*/void r455standard_check_export_and_obsolete_calls(T455* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_MINUS*/T0* r455twin(T455* C);
/*CALL_INFIX_MINUS*/void r455set_feature_stamp(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/void r455pretty(T455* C,T2 a1);
/*CALL_INFIX_MINUS*/T296 r455start_position(T455* C);
/*CALL_INFIX_MINUS*/void r455init(T455* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_MINUS*/T0* r455inline_with(T455* C,T0* a1,T0* a2);
/*CALL_INFIX_MINUS*/T0* r455arg1(T455* C);
/*CALL_INFIX_MINUS*/void r455bracketed_pretty(T455* C,T2 a1);
/*CALL_INFIX_MINUS*/void r455pretty_target(T455* C,T2 a1);
/*CALL_INFIX_MINUS*/void r455safety_check(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T0* r455specialize_2(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T0* r455simplify(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T0* r455specialize_thru(T455* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_MINUS*/T0* r455static_simplify(T455* C);
/*CALL_INFIX_MINUS*/void r455set_arguments(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T0* r455run_feature_for(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/void r455compile_to_c_with_internal_c_local_saving(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T0* r455specialize_in(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/void r455compile_to_c(T455* C,T0* a1);
/*CALL_INFIX_MINUS*/T0* r455_P_407_declaration_type(T455* C);
/*CALL_INFIX_PLUS*/T6 r466use_current(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T6 r466side_effect_free(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/void r466copy(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T0* r466declaration_type(T466* C);
/*CALL_INFIX_PLUS*/T0* r466adapt_for(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T6 r466is_equal(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T0* r466resolve_in(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T0* r466current_or_twin_init(T466* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_PLUS*/T0* r466extra_local_expanded(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/void r466function_and_argument_count_check(T466* C,T0* a1,T0* a2);
/*CALL_INFIX_PLUS*/T0* r466written_declaration_type_mark(void);
/*CALL_INFIX_PLUS*/T0* r466collect(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T6 r466is_balanced_operator(T0* a1);
/*CALL_INFIX_PLUS*/void r466mapping_c_arg(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T0* r466feature_accumulator(void);
/*CALL_INFIX_PLUS*/T6 r466is_default_value(void);
/*CALL_INFIX_PLUS*/void r466mapping_c_target(T466* C,T0* a1,T0* a2);
/*CALL_INFIX_PLUS*/T0* r466non_void_no_dispatch_type(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/void r466accept(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/void r466call_proc_call_c2c(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T0* r466use_current_stack(void);
/*CALL_INFIX_PLUS*/void r466set_target(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T0* r466call_support_collect(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/void r466make(T466* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_PLUS*/void r466standard_check_export_and_obsolete_calls(T466* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_PLUS*/T0* r466twin(T466* C);
/*CALL_INFIX_PLUS*/void r466set_feature_stamp(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/void r466pretty(T466* C,T2 a1);
/*CALL_INFIX_PLUS*/T296 r466start_position(T466* C);
/*CALL_INFIX_PLUS*/void r466init(T466* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_PLUS*/T0* r466inline_with(T466* C,T0* a1,T0* a2);
/*CALL_INFIX_PLUS*/T0* r466arg1(T466* C);
/*CALL_INFIX_PLUS*/void r466bracketed_pretty(T466* C,T2 a1);
/*CALL_INFIX_PLUS*/void r466pretty_target(T466* C,T2 a1);
/*CALL_INFIX_PLUS*/void r466safety_check(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T0* r466specialize_2(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T0* r466simplify(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T0* r466specialize_thru(T466* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_PLUS*/T0* r466static_simplify(T466* C);
/*CALL_INFIX_PLUS*/void r466set_arguments(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T0* r466run_feature_for(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/void r466compile_to_c_with_internal_c_local_saving(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T0* r466specialize_in(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/void r466compile_to_c(T466* C,T0* a1);
/*CALL_INFIX_PLUS*/T0* r466_P_407_declaration_type(T466* C);
/*CALL_INFIX_INT_DIV*/T6 r420use_current(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T6 r420side_effect_free(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/void r420copy(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T0* r420declaration_type(T420* C);
/*CALL_INFIX_INT_DIV*/T0* r420adapt_for(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T6 r420is_equal(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T0* r420resolve_in(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T0* r420current_or_twin_init(T420* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_INT_DIV*/T0* r420extra_local_expanded(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/void r420function_and_argument_count_check(T420* C,T0* a1,T0* a2);
/*CALL_INFIX_INT_DIV*/T0* r420written_declaration_type_mark(void);
/*CALL_INFIX_INT_DIV*/T0* r420collect(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T6 r420is_balanced_operator(T0* a1);
/*CALL_INFIX_INT_DIV*/void r420mapping_c_arg(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T0* r420feature_accumulator(void);
/*CALL_INFIX_INT_DIV*/T6 r420is_default_value(void);
/*CALL_INFIX_INT_DIV*/void r420mapping_c_target(T420* C,T0* a1,T0* a2);
/*CALL_INFIX_INT_DIV*/T0* r420non_void_no_dispatch_type(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/void r420accept(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/void r420call_proc_call_c2c(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T0* r420use_current_stack(void);
/*CALL_INFIX_INT_DIV*/void r420set_target(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T0* r420call_support_collect(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/void r420make(T420* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_INT_DIV*/void r420standard_check_export_and_obsolete_calls(T420* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_INT_DIV*/T0* r420twin(T420* C);
/*CALL_INFIX_INT_DIV*/void r420set_feature_stamp(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/void r420pretty(T420* C,T2 a1);
/*CALL_INFIX_INT_DIV*/T296 r420start_position(T420* C);
/*CALL_INFIX_INT_DIV*/void r420init(T420* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_INT_DIV*/T0* r420inline_with(T420* C,T0* a1,T0* a2);
/*CALL_INFIX_INT_DIV*/T0* r420arg1(T420* C);
/*CALL_INFIX_INT_DIV*/void r420bracketed_pretty(T420* C,T2 a1);
/*CALL_INFIX_INT_DIV*/void r420pretty_target(T420* C,T2 a1);
/*CALL_INFIX_INT_DIV*/void r420safety_check(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T0* r420specialize_2(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T0* r420simplify(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T0* r420specialize_thru(T420* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_INT_DIV*/T0* r420static_simplify(T420* C);
/*CALL_INFIX_INT_DIV*/void r420set_arguments(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T0* r420run_feature_for(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/void r420compile_to_c_with_internal_c_local_saving(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T0* r420specialize_in(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/void r420compile_to_c(T420* C,T0* a1);
/*CALL_INFIX_INT_DIV*/T0* r420_P_407_declaration_type(T420* C);
/*CALL_INFIX_INT_REM*/T6 r444use_current(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T6 r444side_effect_free(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/void r444copy(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T0* r444declaration_type(T444* C);
/*CALL_INFIX_INT_REM*/T0* r444adapt_for(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T6 r444is_equal(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T0* r444resolve_in(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T0* r444current_or_twin_init(T444* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_INT_REM*/T0* r444extra_local_expanded(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/void r444function_and_argument_count_check(T444* C,T0* a1,T0* a2);
/*CALL_INFIX_INT_REM*/T0* r444written_declaration_type_mark(void);
/*CALL_INFIX_INT_REM*/T0* r444collect(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T6 r444is_balanced_operator(T0* a1);
/*CALL_INFIX_INT_REM*/void r444mapping_c_arg(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T0* r444feature_accumulator(void);
/*CALL_INFIX_INT_REM*/T6 r444is_default_value(void);
/*CALL_INFIX_INT_REM*/void r444mapping_c_target(T444* C,T0* a1,T0* a2);
/*CALL_INFIX_INT_REM*/T0* r444non_void_no_dispatch_type(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/void r444accept(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/void r444call_proc_call_c2c(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T0* r444use_current_stack(void);
/*CALL_INFIX_INT_REM*/void r444set_target(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T0* r444call_support_collect(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/void r444make(T444* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_INT_REM*/void r444standard_check_export_and_obsolete_calls(T444* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_INT_REM*/T0* r444twin(T444* C);
/*CALL_INFIX_INT_REM*/void r444set_feature_stamp(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/void r444pretty(T444* C,T2 a1);
/*CALL_INFIX_INT_REM*/T296 r444start_position(T444* C);
/*CALL_INFIX_INT_REM*/void r444init(T444* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_INT_REM*/T0* r444inline_with(T444* C,T0* a1,T0* a2);
/*CALL_INFIX_INT_REM*/T0* r444arg1(T444* C);
/*CALL_INFIX_INT_REM*/void r444bracketed_pretty(T444* C,T2 a1);
/*CALL_INFIX_INT_REM*/void r444pretty_target(T444* C,T2 a1);
/*CALL_INFIX_INT_REM*/void r444safety_check(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T0* r444specialize_2(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T0* r444simplify(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T0* r444specialize_thru(T444* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_INT_REM*/T0* r444static_simplify(T444* C);
/*CALL_INFIX_INT_REM*/void r444set_arguments(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T0* r444run_feature_for(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/void r444compile_to_c_with_internal_c_local_saving(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T0* r444specialize_in(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/void r444compile_to_c(T444* C,T0* a1);
/*CALL_INFIX_INT_REM*/T0* r444_P_407_declaration_type(T444* C);
/*CALL_INFIX_DIV*/T6 r443use_current(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T6 r443side_effect_free(T443* C,T0* a1);
/*CALL_INFIX_DIV*/void r443copy(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T0* r443declaration_type(T443* C);
/*CALL_INFIX_DIV*/T0* r443adapt_for(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T6 r443is_equal(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T0* r443resolve_in(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T0* r443current_or_twin_init(T443* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_DIV*/T0* r443extra_local_expanded(T443* C,T0* a1);
/*CALL_INFIX_DIV*/void r443function_and_argument_count_check(T443* C,T0* a1,T0* a2);
/*CALL_INFIX_DIV*/T0* r443written_declaration_type_mark(void);
/*CALL_INFIX_DIV*/T0* r443collect(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T6 r443is_balanced_operator(T0* a1);
/*CALL_INFIX_DIV*/void r443mapping_c_arg(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T0* r443feature_accumulator(void);
/*CALL_INFIX_DIV*/T6 r443is_default_value(void);
/*CALL_INFIX_DIV*/void r443mapping_c_target(T443* C,T0* a1,T0* a2);
/*CALL_INFIX_DIV*/T0* r443non_void_no_dispatch_type(T443* C,T0* a1);
/*CALL_INFIX_DIV*/void r443accept(T443* C,T0* a1);
/*CALL_INFIX_DIV*/void r443call_proc_call_c2c(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T0* r443use_current_stack(void);
/*CALL_INFIX_DIV*/void r443set_target(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T0* r443call_support_collect(T443* C,T0* a1);
/*CALL_INFIX_DIV*/void r443make(T443* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_DIV*/void r443standard_check_export_and_obsolete_calls(T443* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_DIV*/T0* r443twin(T443* C);
/*CALL_INFIX_DIV*/void r443set_feature_stamp(T443* C,T0* a1);
/*CALL_INFIX_DIV*/void r443pretty(T443* C,T2 a1);
/*CALL_INFIX_DIV*/T296 r443start_position(T443* C);
/*CALL_INFIX_DIV*/void r443init(T443* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_DIV*/T0* r443inline_with(T443* C,T0* a1,T0* a2);
/*CALL_INFIX_DIV*/T0* r443arg1(T443* C);
/*CALL_INFIX_DIV*/void r443bracketed_pretty(T443* C,T2 a1);
/*CALL_INFIX_DIV*/void r443pretty_target(T443* C,T2 a1);
/*CALL_INFIX_DIV*/void r443safety_check(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T0* r443specialize_2(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T0* r443simplify(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T0* r443specialize_thru(T443* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_DIV*/T0* r443static_simplify(T443* C);
/*CALL_INFIX_DIV*/void r443set_arguments(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T0* r443run_feature_for(T443* C,T0* a1);
/*CALL_INFIX_DIV*/void r443compile_to_c_with_internal_c_local_saving(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T0* r443specialize_in(T443* C,T0* a1);
/*CALL_INFIX_DIV*/void r443compile_to_c(T443* C,T0* a1);
/*CALL_INFIX_DIV*/T0* r443_P_407_declaration_type(T443* C);
/*CALL_INFIX_TIMES*/T6 r462use_current(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T6 r462side_effect_free(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/void r462copy(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T0* r462declaration_type(T462* C);
/*CALL_INFIX_TIMES*/T0* r462adapt_for(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T6 r462is_equal(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T0* r462resolve_in(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T0* r462current_or_twin_init(T462* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_TIMES*/T0* r462extra_local_expanded(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/void r462function_and_argument_count_check(T462* C,T0* a1,T0* a2);
/*CALL_INFIX_TIMES*/T0* r462written_declaration_type_mark(void);
/*CALL_INFIX_TIMES*/T0* r462collect(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T6 r462is_balanced_operator(T0* a1);
/*CALL_INFIX_TIMES*/void r462mapping_c_arg(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T0* r462feature_accumulator(void);
/*CALL_INFIX_TIMES*/T6 r462is_default_value(void);
/*CALL_INFIX_TIMES*/void r462mapping_c_target(T462* C,T0* a1,T0* a2);
/*CALL_INFIX_TIMES*/T0* r462non_void_no_dispatch_type(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/void r462accept(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/void r462call_proc_call_c2c(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T0* r462use_current_stack(void);
/*CALL_INFIX_TIMES*/void r462set_target(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T0* r462call_support_collect(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/void r462make(T462* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_TIMES*/void r462standard_check_export_and_obsolete_calls(T462* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_TIMES*/T0* r462twin(T462* C);
/*CALL_INFIX_TIMES*/void r462set_feature_stamp(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/void r462pretty(T462* C,T2 a1);
/*CALL_INFIX_TIMES*/T296 r462start_position(T462* C);
/*CALL_INFIX_TIMES*/void r462init(T462* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_TIMES*/T0* r462inline_with(T462* C,T0* a1,T0* a2);
/*CALL_INFIX_TIMES*/T0* r462arg1(T462* C);
/*CALL_INFIX_TIMES*/void r462bracketed_pretty(T462* C,T2 a1);
/*CALL_INFIX_TIMES*/void r462pretty_target(T462* C,T2 a1);
/*CALL_INFIX_TIMES*/void r462safety_check(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T0* r462specialize_2(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T0* r462simplify(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T0* r462specialize_thru(T462* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_TIMES*/T0* r462static_simplify(T462* C);
/*CALL_INFIX_TIMES*/void r462set_arguments(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T0* r462run_feature_for(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/void r462compile_to_c_with_internal_c_local_saving(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T0* r462specialize_in(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/void r462compile_to_c(T462* C,T0* a1);
/*CALL_INFIX_TIMES*/T0* r462_P_407_declaration_type(T462* C);
/*CALL_INFIX_POWER*/T6 r404use_current(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T6 r404side_effect_free(T404* C,T0* a1);
/*CALL_INFIX_POWER*/void r404copy(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T0* r404declaration_type(T404* C);
/*CALL_INFIX_POWER*/T0* r404adapt_for(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T6 r404is_equal(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T0* r404resolve_in(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T0* r404current_or_twin_init(T404* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_POWER*/T0* r404extra_local_expanded(T404* C,T0* a1);
/*CALL_INFIX_POWER*/void r404function_and_argument_count_check(T404* C,T0* a1,T0* a2);
/*CALL_INFIX_POWER*/T0* r404written_declaration_type_mark(void);
/*CALL_INFIX_POWER*/T0* r404collect(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T6 r404is_balanced_operator(T0* a1);
/*CALL_INFIX_POWER*/void r404mapping_c_arg(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T0* r404feature_accumulator(void);
/*CALL_INFIX_POWER*/T6 r404is_default_value(void);
/*CALL_INFIX_POWER*/void r404mapping_c_target(T404* C,T0* a1,T0* a2);
/*CALL_INFIX_POWER*/T0* r404non_void_no_dispatch_type(T404* C,T0* a1);
/*CALL_INFIX_POWER*/void r404accept(T404* C,T0* a1);
/*CALL_INFIX_POWER*/void r404call_proc_call_c2c(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T0* r404use_current_stack(void);
/*CALL_INFIX_POWER*/void r404set_target(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T0* r404call_support_collect(T404* C,T0* a1);
/*CALL_INFIX_POWER*/void r404make(T404* C,T0* a1,T296 a2,T0* a3);
/*CALL_INFIX_POWER*/void r404standard_check_export_and_obsolete_calls(T404* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_POWER*/T0* r404twin(T404* C);
/*CALL_INFIX_POWER*/void r404set_feature_stamp(T404* C,T0* a1);
/*CALL_INFIX_POWER*/void r404pretty(T404* C,T2 a1);
/*CALL_INFIX_POWER*/T296 r404start_position(T404* C);
/*CALL_INFIX_POWER*/void r404init(T404* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_POWER*/T0* r404inline_with(T404* C,T0* a1,T0* a2);
/*CALL_INFIX_POWER*/T0* r404arg1(T404* C);
/*CALL_INFIX_POWER*/void r404bracketed_pretty(T404* C,T2 a1);
/*CALL_INFIX_POWER*/void r404pretty_target(T404* C,T2 a1);
/*CALL_INFIX_POWER*/void r404safety_check(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T0* r404specialize_2(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T0* r404simplify(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T0* r404specialize_thru(T404* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_POWER*/T0* r404static_simplify(T404* C);
/*CALL_INFIX_POWER*/void r404set_arguments(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T0* r404run_feature_for(T404* C,T0* a1);
/*CALL_INFIX_POWER*/void r404compile_to_c_with_internal_c_local_saving(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T0* r404specialize_in(T404* C,T0* a1);
/*CALL_INFIX_POWER*/void r404compile_to_c(T404* C,T0* a1);
/*CALL_INFIX_POWER*/T0* r404_P_407_declaration_type(T404* C);
/*CALL_INFIX_FREEOP*/T6 r417use_current(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T6 r417side_effect_free(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/void r417copy(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T0* r417declaration_type(T417* C);
/*CALL_INFIX_FREEOP*/T0* r417adapt_for(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T6 r417is_equal(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T0* r417resolve_in(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T0* r417current_or_twin_init(T417* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_FREEOP*/T0* r417extra_local_expanded(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/void r417function_and_argument_count_check(T417* C,T0* a1,T0* a2);
/*CALL_INFIX_FREEOP*/T0* r417written_declaration_type_mark(void);
/*CALL_INFIX_FREEOP*/T0* r417collect(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T6 r417is_balanced_operator(T0* a1);
/*CALL_INFIX_FREEOP*/void r417mapping_c_arg(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T0* r417feature_accumulator(void);
/*CALL_INFIX_FREEOP*/T6 r417is_default_value(void);
/*CALL_INFIX_FREEOP*/void r417mapping_c_target(T417* C,T0* a1,T0* a2);
/*CALL_INFIX_FREEOP*/T0* r417non_void_no_dispatch_type(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/void r417accept(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/void r417call_proc_call_c2c(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T0* r417use_current_stack(void);
/*CALL_INFIX_FREEOP*/void r417set_target(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T0* r417call_support_collect(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/void r417make(T417* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_FREEOP*/void r417standard_check_export_and_obsolete_calls(T417* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_FREEOP*/T0* r417twin(T417* C);
/*CALL_INFIX_FREEOP*/void r417set_feature_stamp(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/void r417pretty(T417* C,T2 a1);
/*CALL_INFIX_FREEOP*/T296 r417start_position(T417* C);
/*CALL_INFIX_FREEOP*/void r417init(T417* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_FREEOP*/T0* r417inline_with(T417* C,T0* a1,T0* a2);
/*CALL_INFIX_FREEOP*/T0* r417arg1(T417* C);
/*CALL_INFIX_FREEOP*/void r417bracketed_pretty(T417* C,T2 a1);
/*CALL_INFIX_FREEOP*/void r417pretty_target(T417* C,T2 a1);
/*CALL_INFIX_FREEOP*/void r417safety_check(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T0* r417specialize_2(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T0* r417simplify(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T0* r417specialize_thru(T417* C,T0* a1,T0* a2,T0* a3);
/*CALL_INFIX_FREEOP*/T0* r417static_simplify(T417* C);
/*CALL_INFIX_FREEOP*/void r417set_arguments(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T0* r417run_feature_for(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/void r417compile_to_c_with_internal_c_local_saving(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T0* r417specialize_in(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/void r417compile_to_c(T417* C,T0* a1);
/*CALL_INFIX_FREEOP*/T0* r417_P_407_declaration_type(T417* C);
/*E_OLD*/void r421mapping_c_target(T421* C,T0* a1,T0* a2);
/*E_OLD*/void r421pretty_target(T421* C,T2 a1);
/*E_OLD*/void r421standard_mapping_c_target(T421* C,T0* a1,T0* a2);
/*E_OLD*/void r421copy(T421* C,T0* a1);
/*E_OLD*/T0* r421non_void_no_dispatch_type(T0* a1);
/*E_OLD*/T6 r421is_equal(T421* C,T0* a1);
/*E_OLD*/T0* r421specialize_2(T421* C,T0* a1);
extern T0*oBC421vaol_check_memory;
/*E_OLD*/T0* r421static_simplify(T421* C);
/*E_OLD*/T0* r421simplify(T0* a1);
/*E_OLD*/T0* r421collect(T421* C,T0* a1);
/*E_OLD*/T0* r421local_c_name(T421* C);
/*E_OLD*/T0* r421current_or_twin_init(T421* C,T0* a1);
extern T0*oBC421special_old_counter;
/*E_OLD*/T0* r421specialize_thru(T421* C,T0* a1,T0* a2,T0* a3);
/*E_OLD*/void r421c_declare_for_old(T421* C,T0* a1);
/*E_OLD*/void r421compile_to_c_old(T421* C,T0* a1);
/*E_OLD*/void r421compile_to_c_with_internal_c_local_saving(T421* C,T0* a1);
/*E_OLD*/T0* r421specialize_in(T421* C,T0* a1);
/*E_OLD*/void r421compile_to_c(T421* C,T0* a1);
/*E_OLD*/T6 r421use_current(T421* C,T0* a1);
/*E_OLD*/T6 r421side_effect_free(T0* a1);
/*E_OLD*/void r421accept(T421* C,T0* a1);
/*E_OLD*/T0* r421declaration_type(T421* C);
/*E_OLD*/T0* r421adapt_for(T421* C,T0* a1);
/*E_OLD*/T0* r421resolve_in(T421* C,T0* a1);
/*E_OLD*/void r421make(T421* C,T296 a1,T0* a2);
/*E_OLD*/T0* r421written_declaration_type_mark(void);
/*E_OLD*/T0* r421twin(T421* C);
/*E_OLD*/void r421pretty(T421* C,T2 a1);
/*E_OLD*/void r421mapping_c_arg(T421* C,T0* a1);
/*E_OLD*/void r421bracketed_pretty(T421* C,T2 a1);
/*E_OLD*/void r421safety_check(T421* C,T0* a1);
/*E_OLD*/T2 r421precedence(void);
/*E_OLD*/T6 r421is_default_value(void);
/*MANIFEST_TUPLE*/void r431mapping_c_target(T431* C,T0* a1,T0* a2);
/*MANIFEST_TUPLE*/void r431pretty_target(T431* C,T2 a1);
/*MANIFEST_TUPLE*/void r431copy(T431* C,T0* a1);
/*MANIFEST_TUPLE*/T0* r431non_void_no_dispatch_type(T431* C,T0* a1);
/*MANIFEST_TUPLE*/T6 r431is_equal(T431* C,T0* a1);
/*MANIFEST_TUPLE*/void r431init(T431* C,T0* a1,T0* a2);
/*MANIFEST_TUPLE*/T0* r431specialize_2(T431* C,T0* a1);
/*MANIFEST_TUPLE*/T0* r431static_simplify(T431* C);
/*MANIFEST_TUPLE*/T0* r431simplify(T431* C,T0* a1);
/*MANIFEST_TUPLE*/T0* r431collect(T431* C,T0* a1);
/*MANIFEST_TUPLE*/T0* r431current_or_twin_init(T431* C,T0* a1,T0* a2);
/*MANIFEST_TUPLE*/T0* r431specialize_thru(T431* C,T0* a1,T0* a2,T0* a3);
/*MANIFEST_TUPLE*/void r431compile_to_c_with_internal_c_local_saving(T431* C,T0* a1);
/*MANIFEST_TUPLE*/T0* r431specialize_in(T431* C,T0* a1);
/*MANIFEST_TUPLE*/void r431compile_to_c(T431* C,T0* a1);
/*MANIFEST_TUPLE*/T6 r431use_current(T431* C,T0* a1);
/*MANIFEST_TUPLE*/T6 r431side_effect_free(T0* a1);
/*MANIFEST_TUPLE*/void r431accept(T431* C,T0* a1);
/*MANIFEST_TUPLE*/T0* r431declaration_type(T431* C);
/*MANIFEST_TUPLE*/T0* r431create_expression_for(T431* C,T0* a1,T0* a2);
/*MANIFEST_TUPLE*/T0* r431adapt_for(T431* C,T0* a1);
/*MANIFEST_TUPLE*/T0* r431resolve_in(T431* C,T0* a1);
/*MANIFEST_TUPLE*/void r431make(T431* C,T296 a1,T0* a2);
/*MANIFEST_TUPLE*/T0* r431written_declaration_type_mark(void);
/*MANIFEST_TUPLE*/T0* r431twin(T431* C);
/*MANIFEST_TUPLE*/void r431pretty(T431* C,T2 a1);
/*MANIFEST_TUPLE*/void r431mapping_c_arg(T431* C,T0* a1);
/*MANIFEST_TUPLE*/void r431bracketed_pretty(T431* C,T2 a1);
/*MANIFEST_TUPLE*/void r431safety_check(T431* C,T0* a1);
/*MANIFEST_TUPLE*/T6 r431is_default_value(void);
T438*create438make(T296 a1);
/*E_TRUE*/void r438mapping_c_target(T0* a1,T0* a2);
/*E_TRUE*/void r438pretty_target(T2 a1);
/*E_TRUE*/void r438copy(T438* C,T0* a1);
/*E_TRUE*/T0* r438non_void_no_dispatch_type(T0* a1);
/*E_TRUE*/T6 r438is_equal(T438* C,T0* a1);
/*E_TRUE*/T0* r438specialize_2(T438* C,T0* a1);
/*E_TRUE*/T0* r438static_simplify(T438* C);
/*E_TRUE*/T0* r438simplify(T438* C,T0* a1);
/*E_TRUE*/T0* r438collect(T0* a1);
/*E_TRUE*/T0* r438specialize_thru(T438* C,T0* a1,T0* a2,T0* a3);
/*E_TRUE*/void r438compile_to_c_with_internal_c_local_saving(T0* a1);
/*E_TRUE*/T0* r438specialize_in(T438* C,T0* a1);
/*E_TRUE*/void r438compile_to_c(T0* a1);
/*E_TRUE*/T6 r438use_current(T0* a1);
/*E_TRUE*/T6 r438side_effect_free(T0* a1);
/*E_TRUE*/void r438accept(T438* C,T0* a1);
extern T0*oBC439declaration_type;
extern int fBC439declaration_type;
/*E_TRUE*/T0* r438declaration_type(void);
/*E_TRUE*/T0* r438adapt_for(T438* C,T0* a1);
/*E_TRUE*/T0* r438resolve_in(T0* a1);
/*E_TRUE*/void r438make(T438* C,T296 a1);
/*E_TRUE*/T0* r438written_declaration_type_mark(void);
/*E_TRUE*/T0* r438twin(T438* C);
/*E_TRUE*/void r438pretty(T2 a1);
/*E_TRUE*/void r438mapping_c_arg(T0* a1);
/*E_TRUE*/void r438bracketed_pretty(T2 a1);
/*E_TRUE*/T2 r438precedence(void);
/*E_TRUE*/T6 r438is_default_value(void);
T473*create473make(T296 a1);
/*E_FALSE*/void r473mapping_c_target(T0* a1,T0* a2);
/*E_FALSE*/void r473pretty_target(T2 a1);
/*E_FALSE*/void r473copy(T473* C,T0* a1);
/*E_FALSE*/T0* r473non_void_no_dispatch_type(T0* a1);
/*E_FALSE*/T6 r473is_equal(T473* C,T0* a1);
/*E_FALSE*/T0* r473specialize_2(T473* C,T0* a1);
/*E_FALSE*/T0* r473static_simplify(T473* C);
/*E_FALSE*/T0* r473simplify(T473* C,T0* a1);
/*E_FALSE*/T0* r473collect(T0* a1);
/*E_FALSE*/T0* r473specialize_thru(T473* C,T0* a1,T0* a2,T0* a3);
/*E_FALSE*/void r473compile_to_c_with_internal_c_local_saving(T0* a1);
/*E_FALSE*/T0* r473specialize_in(T473* C,T0* a1);
/*E_FALSE*/void r473compile_to_c(T0* a1);
/*E_FALSE*/T6 r473use_current(T0* a1);
/*E_FALSE*/T6 r473side_effect_free(T0* a1);
/*E_FALSE*/void r473accept(T473* C,T0* a1);
/*E_FALSE*/T0* r473declaration_type(void);
/*E_FALSE*/T0* r473adapt_for(T473* C,T0* a1);
/*E_FALSE*/T0* r473resolve_in(T0* a1);
/*E_FALSE*/void r473make(T473* C,T296 a1);
/*E_FALSE*/T0* r473written_declaration_type_mark(void);
/*E_FALSE*/T0* r473twin(T473* C);
/*E_FALSE*/void r473pretty(T2 a1);
/*E_FALSE*/void r473mapping_c_arg(T0* a1);
/*E_FALSE*/void r473bracketed_pretty(T2 a1);
/*E_FALSE*/T2 r473precedence(void);
/*E_FALSE*/T6 r473is_default_value(void);
T442*create442with(T296 a1,T3 a2);
/*CHARACTER_CONSTANT*/void r442mapping_c_target(T442* C,T0* a1,T0* a2);
/*CHARACTER_CONSTANT*/void r442pretty_target(T442* C,T2 a1);
/*CHARACTER_CONSTANT*/void r442copy(T442* C,T0* a1);
/*CHARACTER_CONSTANT*/T0* r442non_void_no_dispatch_type(T0* a1);
/*CHARACTER_CONSTANT*/T6 r442is_equal(T442* C,T0* a1);
/*CHARACTER_CONSTANT*/T0* r442specialize_2(T442* C,T0* a1);
/*CHARACTER_CONSTANT*/T0* r442static_simplify(T442* C);
/*CHARACTER_CONSTANT*/T0* r442simplify(T442* C,T0* a1);
/*CHARACTER_CONSTANT*/T0* r442collect(T0* a1);
/*CHARACTER_CONSTANT*/T0* r442specialize_thru(T442* C,T0* a1,T0* a2,T0* a3);
/*CHARACTER_CONSTANT*/void r442compile_to_c_with_internal_c_local_saving(T442* C,T0* a1);
/*CHARACTER_CONSTANT*/T0* r442specialize_in(T442* C,T0* a1);
/*CHARACTER_CONSTANT*/void r442compile_to_c(T442* C,T0* a1);
/*CHARACTER_CONSTANT*/T6 r442use_current(T0* a1);
/*CHARACTER_CONSTANT*/T6 r442side_effect_free(T0* a1);
/*CHARACTER_CONSTANT*/void r442accept(T442* C,T0* a1);
/*CHARACTER_CONSTANT*/T0* r442to_string(T442* C);
extern T0*oBC442declaration_type;
extern int fBC442declaration_type;
/*CHARACTER_CONSTANT*/T0* r442declaration_type(void);
/*CHARACTER_CONSTANT*/T0* r442adapt_for(T442* C,T0* a1);
/*CHARACTER_CONSTANT*/T0* r442resolve_in(T0* a1);
/*CHARACTER_CONSTANT*/void r442make(T442* C,T296 a1,T3 a2,T0* a3);
/*CHARACTER_CONSTANT*/T0* r442written_declaration_type_mark(void);
/*CHARACTER_CONSTANT*/T0* r442twin(T442* C);
/*CHARACTER_CONSTANT*/void r442pretty(T442* C,T2 a1);
/*CHARACTER_CONSTANT*/void r442character_coding(T3 a1,T0* a2);
/*CHARACTER_CONSTANT*/void r442mapping_c_arg(T442* C,T0* a1);
/*CHARACTER_CONSTANT*/void r442bracketed_pretty(T442* C,T2 a1);
/*CHARACTER_CONSTANT*/T2 r442precedence(void);
/*CHARACTER_CONSTANT*/T6 r442is_default_value(T442* C);
/*CHARACTER_CONSTANT*/void r442with(T442* C,T296 a1,T3 a2);
/*MANIFEST_STRING*/T6 r315use_current(T0* a1);
/*MANIFEST_STRING*/T6 r315side_effect_free(T315* C,T0* a1);
/*MANIFEST_STRING*/void r315copy(T315* C,T0* a1);
/*MANIFEST_STRING*/void r315storage_alias_of(T315* C,T0* a1);
/*MANIFEST_STRING*/T0* r315declaration_type(T315* C);
/*MANIFEST_STRING*/T0* r315adapt_for(T315* C,T0* a1);
/*MANIFEST_STRING*/T6 r315is_equal(T315* C,T0* a1);
/*MANIFEST_STRING*/T0* r315resolve_in(T315* C,T0* a1);
/*MANIFEST_STRING*/T0* r315written_declaration_type_mark(void);
/*MANIFEST_STRING*/T0* r315collect(T315* C,T0* a1);
/*MANIFEST_STRING*/T6 r315is_static(T315* C);
/*MANIFEST_STRING*/void r315mapping_c_arg(T315* C,T0* a1);
/*MANIFEST_STRING*/T2 r315precedence(void);
/*MANIFEST_STRING*/T6 r315is_default_value(void);
/*MANIFEST_STRING*/void r315mapping_c_target(T315* C,T0* a1,T0* a2);
/*MANIFEST_STRING*/T0* r315non_void_no_dispatch_type(T315* C,T0* a1);
/*MANIFEST_STRING*/void r315accept(T315* C,T0* a1);
/*MANIFEST_STRING*/T2 r315hash_code(T315* C);
/*MANIFEST_STRING*/void r315make(T315* C,T296 a1,T6 a2,T6 a3,T0* a4);
/*MANIFEST_STRING*/T0* r315twin(T315* C);
/*MANIFEST_STRING*/void r315pretty(T315* C,T2 a1);
/*MANIFEST_STRING*/void r315bracketed_pretty(T315* C,T2 a1);
/*MANIFEST_STRING*/void r315pretty_target(T315* C,T2 a1);
/*MANIFEST_STRING*/T2 r315count(T315* C);
/*MANIFEST_STRING*/T0* r315specialize_2(T315* C,T0* a1);
/*MANIFEST_STRING*/T0* r315simplify(T315* C,T0* a1);
/*MANIFEST_STRING*/T0* r315specialize_thru(T315* C,T0* a1,T0* a2,T0* a3);
/*MANIFEST_STRING*/T0* r315static_simplify(T315* C);
/*MANIFEST_STRING*/void r315compile_to_c_with_internal_c_local_saving(T315* C,T0* a1);
/*MANIFEST_STRING*/T0* r315specialize_in(T315* C,T0* a1);
/*MANIFEST_STRING*/void r315from_identifier(T315* C,T296 a1,T0* a2);
/*MANIFEST_STRING*/void r315compile_to_c(T315* C,T0* a1);
/*PRECURSOR_EXPRESSION*/T6 r409use_current(T0* a1);
/*PRECURSOR_EXPRESSION*/T6 r409side_effect_free(T0* a1);
/*PRECURSOR_EXPRESSION*/void r409set_specialized_parent(T409* C,T0* a1);
/*PRECURSOR_EXPRESSION*/void r409copy(T409* C,T0* a1);
/*PRECURSOR_EXPRESSION*/T0* r409declaration_type(T409* C);
/*PRECURSOR_EXPRESSION*/T0* r409adapt_for(T409* C,T0* a1);
/*PRECURSOR_EXPRESSION*/T6 r409is_equal(T409* C,T0* a1);
/*PRECURSOR_EXPRESSION*/T0* r409resolve_in(T409* C,T0* a1);
/*PRECURSOR_EXPRESSION*/T0* r409current_or_twin_init(T409* C,T0* a1,T0* a2);
/*PRECURSOR_EXPRESSION*/T0* r409written_declaration_type_mark(void);
/*PRECURSOR_EXPRESSION*/T0* r409collect(T409* C,T0* a1);
/*PRECURSOR_EXPRESSION*/void r409mapping_c_arg(T409* C,T0* a1);
/*PRECURSOR_EXPRESSION*/T0* r409feature_accumulator(void);
/*PRECURSOR_EXPRESSION*/void r409pretty_(T409* C,T2 a1);
/*PRECURSOR_EXPRESSION*/T2 r409precedence(void);
/*PRECURSOR_EXPRESSION*/T6 r409is_default_value(void);
/*PRECURSOR_EXPRESSION*/void r409mapping_c_target(T409* C,T0* a1,T0* a2);
/*PRECURSOR_EXPRESSION*/void r409standard_mapping_c_target(T409* C,T0* a1,T0* a2);
/*PRECURSOR_EXPRESSION*/T0* r409non_void_no_dispatch_type(T0* a1);
/*PRECURSOR_EXPRESSION*/void r409accept(T409* C,T0* a1);
/*PRECURSOR_EXPRESSION*/void r409make(T409* C,T296 a1,T0* a2,T0* a3);
/*PRECURSOR_EXPRESSION*/T0* r409twin(T409* C);
/*PRECURSOR_EXPRESSION*/void r409pretty(T409* C,T2 a1);
/*PRECURSOR_EXPRESSION*/void r409init(T409* C,T0* a1,T0* a2);
/*PRECURSOR_EXPRESSION*/void r409bracketed_pretty(T409* C,T2 a1);
/*PRECURSOR_EXPRESSION*/void r409pretty_target(T409* C,T2 a1);
/*PRECURSOR_EXPRESSION*/void r409safety_check(T409* C,T0* a1);
/*PRECURSOR_EXPRESSION*/T0* r409specialize_2(T409* C,T0* a1);
/*PRECURSOR_EXPRESSION*/T0* r409simplify(T409* C,T0* a1);
/*PRECURSOR_EXPRESSION*/T0* r409specialize_thru(T409* C,T0* a1,T0* a2,T0* a3);
/*PRECURSOR_EXPRESSION*/T0* r409static_simplify(T409* C);
/*PRECURSOR_EXPRESSION*/void r409compile_to_c_with_internal_c_local_saving(T409* C,T0* a1);
/*PRECURSOR_EXPRESSION*/T0* r409specialize_in(T409* C,T0* a1);
/*PRECURSOR_EXPRESSION*/void r409compile_to_c(T409* C,T0* a1);
/*FAKE_TARGET*/void r293mapping_c_target(T293* C,T0* a1,T0* a2);
/*FAKE_TARGET*/void r293pretty_target(T293* C,T2 a1);
/*FAKE_TARGET*/void r293standard_mapping_c_target(T293* C,T0* a1,T0* a2);
/*FAKE_TARGET*/void r293copy(T293* C,T0* a1);
/*FAKE_TARGET*/T0* r293non_void_no_dispatch_type(T0* a1);
/*FAKE_TARGET*/T6 r293is_equal(T293* C,T0* a1);
/*FAKE_TARGET*/T0* r293specialize_2(T293* C,T0* a1);
/*FAKE_TARGET*/T0* r293static_simplify(T293* C);
/*FAKE_TARGET*/T0* r293simplify(T293* C,T0* a1);
/*FAKE_TARGET*/T0* r293collect(T293* C,T0* a1);
/*FAKE_TARGET*/T0* r293current_or_twin_init(T293* C,T0* a1);
/*FAKE_TARGET*/T0* r293specialize_thru(T293* C,T0* a1,T0* a2,T0* a3);
/*FAKE_TARGET*/void r293compile_to_c_with_internal_c_local_saving(T0* a1);
/*FAKE_TARGET*/T0* r293specialize_in(T293* C,T0* a1);
/*FAKE_TARGET*/void r293compile_to_c(T0* a1);
/*FAKE_TARGET*/T6 r293use_current(T0* a1);
/*FAKE_TARGET*/T6 r293side_effect_free(T0* a1);
/*FAKE_TARGET*/void r293accept(T293* C,T0* a1);
/*FAKE_TARGET*/T0* r293declaration_type(T293* C);
/*FAKE_TARGET*/T0* r293adapt_for(T293* C,T0* a1);
/*FAKE_TARGET*/T0* r293resolve_in(T293* C,T0* a1);
/*FAKE_TARGET*/void r293make(T293* C,T296 a1,T0* a2);
/*FAKE_TARGET*/T0* r293written_declaration_type_mark(void);
/*FAKE_TARGET*/T0* r293twin(T293* C);
/*FAKE_TARGET*/void r293pretty(T293* C,T2 a1);
/*FAKE_TARGET*/void r293bracketed_pretty(T293* C,T2 a1);
/*FAKE_TARGET*/T2 r293precedence(void);
/*FAKE_TARGET*/T6 r293is_default_value(void);
/*CREATE_EXPRESSION*/T6 r474use_current(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T6 r474side_effect_free(T0* a1);
/*CREATE_EXPRESSION*/void r474copy(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T0* r474declaration_type(T474* C);
/*CREATE_EXPRESSION*/T0* r474adapt_for(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T6 r474is_equal(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T0* r474resolve_in(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T0* r474any_default_create_fs(void);
/*CREATE_EXPRESSION*/T0* r474current_or_twin_init(T474* C,T0* a1,T0* a2);
/*CREATE_EXPRESSION*/T0* r474extra_local_expanded(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T0* r474written_declaration_type_mark(void);
/*CREATE_EXPRESSION*/T0* r474collect(T474* C,T0* a1);
/*CREATE_EXPRESSION*/void r474mapping_c_arg(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T2 r474precedence(void);
/*CREATE_EXPRESSION*/T6 r474is_default_value(void);
/*CREATE_EXPRESSION*/void r474mapping_c_target(T474* C,T0* a1,T0* a2);
/*CREATE_EXPRESSION*/T0* r474non_void_no_dispatch_type(T474* C,T0* a1);
/*CREATE_EXPRESSION*/void r474accept(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T0* r474default_create_name(void);
/*CREATE_EXPRESSION*/T0* r474arguments(T474* C);
/*CREATE_EXPRESSION*/void r474make(T474* C,T296 a1,T0* a2,T0* a3);
/*CREATE_EXPRESSION*/T0* r474twin(T474* C);
/*CREATE_EXPRESSION*/void r474default_user_expanded(T474* C,T296 a1,T0* a2);
/*CREATE_EXPRESSION*/void r474pretty(T474* C,T2 a1);
/*CREATE_EXPRESSION*/void r474compile_to_c_support(T474* C,T0* a1,T0* a2);
/*CREATE_EXPRESSION*/void r474init(T474* C,T0* a1,T0* a2);
/*CREATE_EXPRESSION*/void r474bracketed_pretty(T474* C,T2 a1);
/*CREATE_EXPRESSION*/void r474pretty_target(T474* C,T2 a1);
/*CREATE_EXPRESSION*/void r474safety_check(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T0* r474specialize_2(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T0* r474simplify(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T0* r474specialize_thru(T474* C,T0* a1,T0* a2,T0* a3);
/*CREATE_EXPRESSION*/T0* r474static_simplify(T474* C);
/*CREATE_EXPRESSION*/void r474specialize_2_checks(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T0* r474created_type(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T0* r474creation_procedure(T474* C,T0* a1);
/*CREATE_EXPRESSION*/void r474compile_to_c_with_internal_c_local_saving(T474* C,T0* a1);
/*CREATE_EXPRESSION*/T0* r474specialize_in(T474* C,T0* a1);
/*CREATE_EXPRESSION*/void r474compile_to_c(T474* C,T0* a1);
/*AGENT_CREATION*/T6 r450use_current(T450* C,T0* a1);
/*AGENT_CREATION*/T6 r450side_effect_free(T0* a1);
/*AGENT_CREATION*/void r450copy(T450* C,T0* a1);
/*AGENT_CREATION*/T0* r450declaration_type(T450* C);
/*AGENT_CREATION*/T0* r450adapt_for(T450* C,T0* a1);
/*AGENT_CREATION*/T6 r450is_equal(T450* C,T0* a1);
/*AGENT_CREATION*/T0* r450resolve_in(T450* C,T0* a1);
extern T0*oBC450agent_creation_helper;
/*AGENT_CREATION*/T0* r450numbered_capture_for(T450* C,T0* a1);
/*AGENT_CREATION*/T0* r450current_or_twin_init(T450* C,T0* a1,T0* a2);
/*AGENT_CREATION*/void r450mold_id_in(T450* C,T0* a1,T0* a2);
/*AGENT_CREATION*/T0* r450written_declaration_type_mark(void);
/*AGENT_CREATION*/void r450compute_open_type_list(T450* C,T0* a1);
/*AGENT_CREATION*/T0* r450collect(T450* C,T0* a1);
/*AGENT_CREATION*/T0* r450c_define_type(T450* C,T0* a1,T6 a2,T0* a3,T2 a4);
/*AGENT_CREATION*/void r450update_capture_open_lists(T450* C,T0* a1,T0* a2,T0* a3);
/*AGENT_CREATION*/T0* r450numbered_capture(T450* C,T0* a1);
/*AGENT_CREATION*/void r450mapping_c_arg(T450* C,T0* a1);
/*AGENT_CREATION*/T6 r450same_mold_id_as(T450* C,T0* a1);
/*AGENT_CREATION*/T2 r450precedence(void);
/*AGENT_CREATION*/T6 r450is_default_value(void);
/*AGENT_CREATION*/void r450mapping_c_target(T450* C,T0* a1,T0* a2);
/*AGENT_CREATION*/T0* r450non_void_no_dispatch_type(T450* C,T0* a1);
/*AGENT_CREATION*/void r450accept(T450* C,T0* a1);
/*AGENT_CREATION*/void r450make(T450* C,T296 a1,T0* a2);
/*AGENT_CREATION*/T0* r450twin(T450* C);
/*AGENT_CREATION*/void r450pretty(T450* C,T2 a1);
/*AGENT_CREATION*/void r450init(T450* C,T0* a1,T0* a2);
/*AGENT_CREATION*/void r450c_define_function(T450* C,T0* a1,T0* a2,T2 a3);
/*AGENT_CREATION*/void r450bracketed_pretty(T450* C,T2 a1);
/*AGENT_CREATION*/void r450pretty_target(T450* C,T2 a1);
/*AGENT_CREATION*/void r450safety_check(T450* C,T0* a1);
/*AGENT_CREATION*/T0* r450specialize_2(T450* C,T0* a1);
/*AGENT_CREATION*/T0* r450simplify(T450* C,T0* a1);
/*AGENT_CREATION*/T0* r450specialize_thru(T450* C,T0* a1,T0* a2,T0* a3);
/*AGENT_CREATION*/T0* r450static_simplify(T450* C);
/*AGENT_CREATION*/void r450compile_to_c_with_internal_c_local_saving(T450* C,T0* a1);
/*AGENT_CREATION*/T0* r450specialize_in(T450* C,T0* a1);
/*AGENT_CREATION*/void r450compile_to_c(T450* C,T0* a1);
T434*create434make(T296 a1);
/*WRITTEN_CURRENT*/void r434mapping_c_target(T0* a1,T0* a2);
/*WRITTEN_CURRENT*/void r434pretty_target(T2 a1);
/*WRITTEN_CURRENT*/void r434copy(T434* C,T0* a1);
/*WRITTEN_CURRENT*/T0* r434non_void_no_dispatch_type(T0* a1);
/*WRITTEN_CURRENT*/T6 r434is_equal(T434* C,T0* a1);
/*WRITTEN_CURRENT*/T0* r434specialize_2(T434* C,T0* a1);
/*WRITTEN_CURRENT*/T0* r434static_simplify(T434* C);
/*WRITTEN_CURRENT*/T0* r434simplify(T434* C,T0* a1);
/*WRITTEN_CURRENT*/T0* r434collect(T0* a1);
/*WRITTEN_CURRENT*/T0* r434specialize_thru(T434* C,T0* a1,T0* a2,T0* a3);
/*WRITTEN_CURRENT*/void r434compile_to_c_with_internal_c_local_saving(T0* a1);
/*WRITTEN_CURRENT*/T0* r434specialize_in(T434* C,T0* a1);
/*WRITTEN_CURRENT*/void r434compile_to_c(T0* a1);
/*WRITTEN_CURRENT*/T6 r434use_current(T0* a1);
/*WRITTEN_CURRENT*/T6 r434side_effect_free(T0* a1);
/*WRITTEN_CURRENT*/void r434accept(T434* C,T0* a1);
/*WRITTEN_CURRENT*/T0* r434adapt_for(T434* C,T0* a1);
/*WRITTEN_CURRENT*/T0* r434resolve_in(T0* a1);
/*WRITTEN_CURRENT*/void r434make(T434* C,T296 a1);
/*WRITTEN_CURRENT*/T0* r434written_declaration_type_mark(void);
/*WRITTEN_CURRENT*/T0* r434twin(T434* C);
/*WRITTEN_CURRENT*/void r434pretty(T2 a1);
/*WRITTEN_CURRENT*/void r434mapping_c_arg(T0* a1);
/*WRITTEN_CURRENT*/void r434bracketed_pretty(T2 a1);
/*WRITTEN_CURRENT*/T2 r434precedence(void);
/*WRITTEN_CURRENT*/T6 r434is_default_value(void);
T413*create413make(T296 a1);
/*E_VOID*/void r413copy(T413* C,T0* a1);
/*E_VOID*/T0* r413non_void_no_dispatch_type(T0* a1);
/*E_VOID*/T6 r413is_equal(T413* C,T0* a1);
/*E_VOID*/T0* r413specialize_2(T413* C,T0* a1);
/*E_VOID*/T0* r413static_simplify(T413* C);
/*E_VOID*/T0* r413simplify(T413* C,T0* a1);
/*E_VOID*/T0* r413collect(T413* C,T0* a1);
/*E_VOID*/T0* r413specialize_thru(T413* C,T0* a1,T0* a2,T0* a3);
/*E_VOID*/void r413compile_to_c_with_internal_c_local_saving(T0* a1);
/*E_VOID*/T0* r413specialize_in(T413* C,T0* a1);
/*E_VOID*/void r413compile_to_c(T0* a1);
/*E_VOID*/T6 r413use_current(T0* a1);
/*E_VOID*/T6 r413side_effect_free(T0* a1);
/*E_VOID*/void r413accept(T413* C,T0* a1);
/*E_VOID*/T0* r413declaration_type(void);
/*E_VOID*/T0* r413adapt_for(T413* C,T0* a1);
/*E_VOID*/T0* r413resolve_in(T413* C,T0* a1);
/*E_VOID*/void r413make(T413* C,T296 a1);
/*E_VOID*/T0* r413written_declaration_type_mark(void);
/*E_VOID*/T0* r413twin(T413* C);
/*E_VOID*/void r413pretty(T2 a1);
/*E_VOID*/void r413mapping_c_arg(T0* a1);
/*E_VOID*/void r413bracketed_pretty(T2 a1);
/*E_VOID*/T2 r413precedence(void);
/*E_VOID*/T6 r413is_default_value(void);
T456*create456make(T296 a1);
/*IMPLICIT_CURRENT*/void r456mapping_c_target(T0* a1,T0* a2);
/*IMPLICIT_CURRENT*/void r456copy(T456* C,T0* a1);
/*IMPLICIT_CURRENT*/T0* r456non_void_no_dispatch_type(T0* a1);
/*IMPLICIT_CURRENT*/T6 r456is_equal(T456* C,T0* a1);
/*IMPLICIT_CURRENT*/T0* r456specialize_2(T456* C,T0* a1);
/*IMPLICIT_CURRENT*/T0* r456static_simplify(T456* C);
/*IMPLICIT_CURRENT*/T0* r456simplify(T456* C,T0* a1);
/*IMPLICIT_CURRENT*/T0* r456collect(T0* a1);
/*IMPLICIT_CURRENT*/T0* r456specialize_thru(T456* C,T0* a1,T0* a2,T0* a3);
/*IMPLICIT_CURRENT*/void r456compile_to_c_with_internal_c_local_saving(T0* a1);
/*IMPLICIT_CURRENT*/T0* r456specialize_in(T456* C,T0* a1);
/*IMPLICIT_CURRENT*/void r456compile_to_c(T0* a1);
/*IMPLICIT_CURRENT*/T6 r456use_current(T0* a1);
/*IMPLICIT_CURRENT*/T6 r456side_effect_free(T0* a1);
/*IMPLICIT_CURRENT*/void r456accept(T456* C,T0* a1);
/*IMPLICIT_CURRENT*/T0* r456adapt_for(T456* C,T0* a1);
/*IMPLICIT_CURRENT*/T0* r456resolve_in(T0* a1);
/*IMPLICIT_CURRENT*/void r456make(T456* C,T296 a1);
/*IMPLICIT_CURRENT*/T0* r456written_declaration_type_mark(void);
/*IMPLICIT_CURRENT*/T0* r456twin(T456* C);
/*IMPLICIT_CURRENT*/void r456pretty(T2 a1);
/*IMPLICIT_CURRENT*/void r456mapping_c_arg(T0* a1);
/*IMPLICIT_CURRENT*/void r456bracketed_pretty(T2 a1);
/*IMPLICIT_CURRENT*/T2 r456precedence(void);
/*IMPLICIT_CURRENT*/T6 r456is_default_value(void);
/*CALL_PREFIX_PLUS*/T6 r448use_current(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/T6 r448side_effect_free(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/void r448copy(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/T0* r448manifest_expression(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/T0* r448declaration_type(T448* C);
/*CALL_PREFIX_PLUS*/T6 r448simplify_limit_reached(T448* C);
/*CALL_PREFIX_PLUS*/T0* r448adapt_for(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/T6 r448is_equal(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/T0* r448resolve_in(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/T0* r448current_or_twin_init(T448* C,T0* a1,T0* a2);
/*CALL_PREFIX_PLUS*/T0* r448extra_local_expanded(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/void r448function_and_argument_count_check(T448* C,T0* a1,T0* a2);
/*CALL_PREFIX_PLUS*/T0* r448written_declaration_type_mark(void);
/*CALL_PREFIX_PLUS*/T0* r448collect(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/void r448mapping_c_arg(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/T0* r448feature_accumulator(void);
/*CALL_PREFIX_PLUS*/T6 r448is_default_value(void);
/*CALL_PREFIX_PLUS*/void r448mapping_c_target(T448* C,T0* a1,T0* a2);
/*CALL_PREFIX_PLUS*/T0* r448non_void_no_dispatch_type(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/void r448accept(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/void r448call_proc_call_c2c(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/T0* r448echo(void);
/*CALL_PREFIX_PLUS*/T0* r448use_current_stack(void);
/*CALL_PREFIX_PLUS*/void r448set_target(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/T0* r448arguments(void);
/*CALL_PREFIX_PLUS*/T0* r448call_support_collect(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/void r448make(T448* C,T296 a1,T0* a2);
/*CALL_PREFIX_PLUS*/T0* r448twin(T448* C);
/*CALL_PREFIX_PLUS*/void r448standard_check_export_and_obsolete_calls(T448* C,T0* a1,T0* a2,T0* a3);
/*CALL_PREFIX_PLUS*/void r448set_feature_stamp(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/void r448pretty(T448* C,T2 a1);
/*CALL_PREFIX_PLUS*/T296 r448start_position(T448* C);
/*CALL_PREFIX_PLUS*/T0* r448inline_with(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/void r448bracketed_pretty(T448* C,T2 a1);
/*CALL_PREFIX_PLUS*/void r448pretty_target(T448* C,T2 a1);
/*CALL_PREFIX_PLUS*/void r448safety_check(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/T0* r448specialize_2(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/T0* r448simplify(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/T0* r448specialize_thru(T448* C,T0* a1,T0* a2,T0* a3);
/*CALL_PREFIX_PLUS*/T0* r448static_simplify(T448* C);
/*CALL_PREFIX_PLUS*/T0* r448run_feature_for(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/void r448compile_to_c_with_internal_c_local_saving(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/T0* r448specialize_in(T448* C,T0* a1);
/*CALL_PREFIX_PLUS*/void r448compile_to_c(T448* C,T0* a1);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_empty_expanded(void);
/*FORMAL_GENERIC_TYPE_MARK*/void r530copy(T530* C,T0* a1);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530declaration_type(T530* C);
/*FORMAL_GENERIC_TYPE_MARK*/void r530id_extra_information(T0* a1);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530class_text(T530* C);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_real(void);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530resolve_in(T530* C,T0* a1);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_character(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_expanded(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_kernel_expanded(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_reference(void);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530at(T530* C,T296 a1);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_integer(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_generic(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_user_expanded(void);
/*FORMAL_GENERIC_TYPE_MARK*/void r530make(T530* C,T0* a1,T0* a2,T2 a3);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530written_mark(T530* C);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530twin(T530* C);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_string(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_tuple(void);
/*FORMAL_GENERIC_TYPE_MARK*/void r530pretty_in(T530* C,T0* a1);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_formal_generic(void);
/*FORMAL_GENERIC_TYPE_MARK*/T296 r530start_position(T530* C);
/*FORMAL_GENERIC_TYPE_MARK*/void r530gc_mark_in(T0* a1);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530same_signature_type(T530* C,T0* a1,T0* a2);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_anchored(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_boolean(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530need_gc_mark_function(void);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530default_expression(T530* C,T296 a1);
/*FORMAL_GENERIC_TYPE_MARK*/void r530c_frame_descriptor_in(T0* a1);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530to_static(T530* C,T0* a1);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530need_c_struct(void);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530specialize_thru(T530* C,T0* a1,T0* a2,T0* a3);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530signature_resolve_in(T530* C,T0* a1);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_like_current(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_agent(void);
/*FORMAL_GENERIC_TYPE_MARK*/void r530set_start_position(T530* C,T296 a1);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530generic_list(void);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530class_text_name(void);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530long_name(void);
/*FORMAL_GENERIC_TYPE_MARK*/T2 r530id(void);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530type(void);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530typed_internals_type_mark(T530* C,T296 a1);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_native_array(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r530is_pointer(void);
/*FORMAL_GENERIC_TYPE_MARK*/T0* r530specialize_in(T530* C,T0* a1);
/*FORMAL_GENERIC_TYPE_MARK*/void r530gc_call_new_in(T0* a1);
/*FORMAL_GENERIC_ARG*/void r521generic_formal_arguments_check(T521* C);
/*FORMAL_GENERIC_ARG*/void r521constraint_substitution(T521* C,T0* a1,T2 a2);
/*FORMAL_GENERIC_ARG*/void r521substitute(T0* a1,T0* a2,T2 a3,T0* a4);
/*FORMAL_GENERIC_ARG*/void r521make(T521* C,T0* a1,T0* a2);
/*FORMAL_GENERIC_ARG*/T296 r521start_position(T521* C);
/*FORMAL_GENERIC_LIST*/T2 r344count(T344* C);
/*FORMAL_GENERIC_LIST*/void r344generic_formal_arguments_check(T344* C);
/*FORMAL_GENERIC_LIST*/void r344add_last(T344* C,T0* a1);
/*FORMAL_GENERIC_LIST*/void r344constraint_genericity_check(T344* C,T0* a1,T0* a2,T296 a3);
/*FORMAL_GENERIC_LIST*/void r344make(T344* C,T296 a1);
/*USER_GENERIC_TYPE_MARK*/void r332c_initialize_user_expanded_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332gc_free_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332c_type_for_result_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332gc_align_mark_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_native_array(void);
/*USER_GENERIC_TYPE_MARK*/void r332copy(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332standard_c_struct(T332* C);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_pointer(void);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_like_current(void);
/*USER_GENERIC_TYPE_MARK*/void r332set_start_position(T332* C,T296 a1);
/*USER_GENERIC_TYPE_MARK*/void r332standard_c_object_model(T332* C);
/*USER_GENERIC_TYPE_MARK*/T0* r332typed_internals_type_mark(T332* C,T296 a1);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_real(void);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_empty_expanded(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332gc_store_left_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332c_header_pass3(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332c_header_pass4(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332standard_just_before_gc_mark_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_character(void);
/*USER_GENERIC_TYPE_MARK*/T0* r332specialize_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_expanded(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332gc_info_nb_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332gc_call_new_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_kernel_expanded(void);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_integer(void);
/*USER_GENERIC_TYPE_MARK*/T0* r332declaration_type(T332* C);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_static(T332* C);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_reference(T332* C);
/*USER_GENERIC_TYPE_MARK*/T0* r332resolve_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332c_type_for_target_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332c_header_pass1(T332* C);
/*USER_GENERIC_TYPE_MARK*/T0* r332twin(T332* C);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_user_expanded(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332make(T332* C,T0* a1,T0* a2);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_string(void);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_tuple(void);
/*USER_GENERIC_TYPE_MARK*/T296 r332start_position(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332pretty_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_boolean(void);
/*USER_GENERIC_TYPE_MARK*/T0* r332specialize_thru(T332* C,T0* a1,T0* a2,T0* a3);
/*USER_GENERIC_TYPE_MARK*/T0* r332type(T332* C);
/*USER_GENERIC_TYPE_MARK*/T0* r332strings(void);
/*USER_GENERIC_TYPE_MARK*/void r332id_extra_information(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/T0* r332class_text(T332* C);
/*USER_GENERIC_TYPE_MARK*/T0* r332at(T332* C,T296 a1);
/*USER_GENERIC_TYPE_MARK*/void r332c_initialize_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332gc_store_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332c_type_for_external_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/T0* r332canonical_long_name(T332* C);
/*USER_GENERIC_TYPE_MARK*/T0* r332written_mark(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332set_generic_list(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332gc_store_chunk_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332recompute_declaration_type(T332* C);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_formal_generic(void);
extern int fBC291generate_once_gc_update_weak_ref_item_polymorph;
/*USER_GENERIC_TYPE_MARK*/void r332generate_once_gc_update_weak_ref_item_polymorph(void);
/*USER_GENERIC_TYPE_MARK*/void r332standard_gc_define2(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332standard_gc_define1(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332set_static_generic_list(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332gc_mark_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332update_static_memory(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332just_before_gc_mark_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332standard_gc_define2_for_expanded(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332special_weak_reference_extra_check(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332standard_gc_info_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/T6 r332same_signature_type(T332* C,T0* a1,T0* a2);
/*USER_GENERIC_TYPE_MARK*/void r332standard_c_typedef(T332* C);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_anchored(void);
/*USER_GENERIC_TYPE_MARK*/T6 r332need_gc_mark_function(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332c_type_for_argument_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332gc_info_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/T0* r332written_name(T332* C);
/*USER_GENERIC_TYPE_MARK*/T0* r332default_expression(T332* C,T296 a1);
/*USER_GENERIC_TYPE_MARK*/void r332c_frame_descriptor_in(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/void r332standard_c_print_function(T332* C);
/*USER_GENERIC_TYPE_MARK*/T0* r332to_static(T332* C,T0* a1);
/*USER_GENERIC_TYPE_MARK*/T6 r332is_agent(void);
/*USER_GENERIC_TYPE_MARK*/T6 r332need_c_struct(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332gc_define1(T332* C);
/*USER_GENERIC_TYPE_MARK*/T2 r332id(T332* C);
/*USER_GENERIC_TYPE_MARK*/T0* r332long_name(T332* C);
/*USER_GENERIC_TYPE_MARK*/void r332gc_define2(T332* C);
/*USER_GENERIC_TYPE_MARK*/T0* r332signature_resolve_in(T332* C,T0* a1);
T545*create545make(T296 a1);
/*ANY_TYPE_MARK*/void r545copy(T545* C,T0* a1);
/*ANY_TYPE_MARK*/T0* r545declaration_type(T545* C);
/*ANY_TYPE_MARK*/void r545id_extra_information(T0* a1);
/*ANY_TYPE_MARK*/T0* r545class_text(T545* C);
/*ANY_TYPE_MARK*/T6 r545is_real(void);
/*ANY_TYPE_MARK*/T0* r545resolve_in(T0* a1);
/*ANY_TYPE_MARK*/T6 r545is_character(void);
/*ANY_TYPE_MARK*/T6 r545is_kernel_expanded(void);
/*ANY_TYPE_MARK*/void r545c_header_pass1(T545* C);
/*ANY_TYPE_MARK*/T0* r545at(T545* C,T296 a1);
/*ANY_TYPE_MARK*/T6 r545is_integer(void);
/*ANY_TYPE_MARK*/void r545c_type_for_target_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/void r545c_initialize_in(T0* a1);
/*ANY_TYPE_MARK*/void r545gc_store_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/void r545c_type_for_external_in(T0* a1);
/*ANY_TYPE_MARK*/void r545make(T545* C,T296 a1);
/*ANY_TYPE_MARK*/T0* r545written_mark(T545* C);
/*ANY_TYPE_MARK*/T0* r545twin(T545* C);
/*ANY_TYPE_MARK*/T6 r545is_string(void);
/*ANY_TYPE_MARK*/T6 r545is_tuple(void);
/*ANY_TYPE_MARK*/void r545gc_store_chunk_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/void r545pretty_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/T6 r545is_formal_generic(void);
/*ANY_TYPE_MARK*/void r545generate_once_gc_update_weak_ref_item_polymorph(void);
/*ANY_TYPE_MARK*/T296 r545start_position(T545* C);
/*ANY_TYPE_MARK*/void r545standard_gc_define2(T545* C);
/*ANY_TYPE_MARK*/void r545standard_gc_define1(T545* C);
/*ANY_TYPE_MARK*/void r545gc_mark_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/void r545just_before_gc_mark_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/void r545standard_gc_info_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/T6 r545same_signature_type(T545* C,T0* a1,T0* a2);
/*ANY_TYPE_MARK*/void r545standard_c_typedef(T545* C);
/*ANY_TYPE_MARK*/T6 r545is_anchored(void);
/*ANY_TYPE_MARK*/T6 r545is_boolean(void);
/*ANY_TYPE_MARK*/void r545c_type_for_argument_in(T0* a1);
/*ANY_TYPE_MARK*/void r545gc_info_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/T0* r545written_name(T545* C);
/*ANY_TYPE_MARK*/T0* r545default_expression(T296 a1);
/*ANY_TYPE_MARK*/void r545c_frame_descriptor_in(T0* a1);
/*ANY_TYPE_MARK*/void r545standard_c_print_function(void);
/*ANY_TYPE_MARK*/T0* r545to_static(T545* C,T0* a1);
/*ANY_TYPE_MARK*/T6 r545need_c_struct(void);
/*ANY_TYPE_MARK*/void r545gc_define1(T545* C);
/*ANY_TYPE_MARK*/void r545gc_define2(T545* C);
/*ANY_TYPE_MARK*/T0* r545specialize_thru(T545* C,T0* a1,T0* a2,T0* a3);
/*ANY_TYPE_MARK*/T0* r545signature_resolve_in(T0* a1);
/*ANY_TYPE_MARK*/void r545gc_free_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/void r545gc_align_mark_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/void r545standard_c_struct(T545* C);
/*ANY_TYPE_MARK*/T6 r545is_like_current(void);
/*ANY_TYPE_MARK*/T6 r545is_agent(void);
/*ANY_TYPE_MARK*/void r545set_start_position(T545* C,T296 a1);
/*ANY_TYPE_MARK*/T0* r545generic_list(void);
extern T0*oBC545long_name;
extern int fBC545long_name;
/*ANY_TYPE_MARK*/T0* r545long_name(void);
/*ANY_TYPE_MARK*/void r545standard_c_object_model(void);
/*ANY_TYPE_MARK*/T2 r545id(T545* C);
/*ANY_TYPE_MARK*/T0* r545type(void);
/*ANY_TYPE_MARK*/T0* r545typed_internals_type_mark(T545* C,T296 a1);
/*ANY_TYPE_MARK*/void r545gc_store_left_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/void r545c_type_for_result_in(T0* a1);
/*ANY_TYPE_MARK*/T6 r545is_native_array(void);
/*ANY_TYPE_MARK*/T6 r545is_pointer(void);
/*ANY_TYPE_MARK*/void r545c_header_pass4(T545* C);
/*ANY_TYPE_MARK*/void r545standard_just_before_gc_mark_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/void r545gc_info_nb_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/T0* r545specialize_in(T545* C,T0* a1);
/*ANY_TYPE_MARK*/void r545gc_call_new_in(T545* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517gc_free_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517c_type_for_result_in(T0* a1);
/*ARRAY_TYPE_MARK*/void r517gc_align_mark_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/T6 r517is_native_array(void);
/*ARRAY_TYPE_MARK*/void r517copy(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517standard_c_struct(T517* C);
/*ARRAY_TYPE_MARK*/T6 r517is_pointer(void);
/*ARRAY_TYPE_MARK*/T6 r517is_like_current(void);
/*ARRAY_TYPE_MARK*/void r517set_start_position(T517* C,T296 a1);
/*ARRAY_TYPE_MARK*/void r517standard_c_object_model(T517* C);
/*ARRAY_TYPE_MARK*/T0* r517typed_internals_type_mark(T517* C,T296 a1);
/*ARRAY_TYPE_MARK*/T6 r517is_real(void);
/*ARRAY_TYPE_MARK*/void r517gc_store_left_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517c_header_pass4(T517* C);
/*ARRAY_TYPE_MARK*/void r517standard_just_before_gc_mark_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/T6 r517is_character(void);
/*ARRAY_TYPE_MARK*/T0* r517specialize_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517gc_info_nb_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517gc_call_new_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/T6 r517is_kernel_expanded(void);
/*ARRAY_TYPE_MARK*/T6 r517is_integer(void);
/*ARRAY_TYPE_MARK*/T0* r517declaration_type(T517* C);
/*ARRAY_TYPE_MARK*/T6 r517is_static(T517* C);
/*ARRAY_TYPE_MARK*/T0* r517resolve_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517c_type_for_target_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517c_header_pass1(T517* C);
/*ARRAY_TYPE_MARK*/T0* r517twin(T517* C);
/*ARRAY_TYPE_MARK*/void r517make(T517* C,T296 a1,T0* a2);
/*ARRAY_TYPE_MARK*/T6 r517is_string(void);
extern T0*oBC517array_name;
extern int fBC517array_name;
/*ARRAY_TYPE_MARK*/T0* r517array_name(void);
/*ARRAY_TYPE_MARK*/T6 r517is_tuple(void);
/*ARRAY_TYPE_MARK*/T296 r517start_position(T517* C);
/*ARRAY_TYPE_MARK*/void r517pretty_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/T6 r517is_boolean(void);
/*ARRAY_TYPE_MARK*/T0* r517specialize_thru(T517* C,T0* a1,T0* a2,T0* a3);
/*ARRAY_TYPE_MARK*/T0* r517type(T517* C);
/*ARRAY_TYPE_MARK*/T0* r517strings(void);
/*ARRAY_TYPE_MARK*/void r517id_extra_information(T0* a1);
/*ARRAY_TYPE_MARK*/T0* r517class_text(T517* C);
/*ARRAY_TYPE_MARK*/void r517set_generic_list_with(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/T0* r517at(T517* C,T296 a1);
/*ARRAY_TYPE_MARK*/void r517c_initialize_in(T0* a1);
/*ARRAY_TYPE_MARK*/void r517gc_store_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517c_type_for_external_in(T0* a1);
/*ARRAY_TYPE_MARK*/T0* r517written_mark(T517* C);
/*ARRAY_TYPE_MARK*/void r517set_generic_list(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517gc_store_chunk_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517recompute_declaration_type(T517* C);
/*ARRAY_TYPE_MARK*/T6 r517is_formal_generic(void);
/*ARRAY_TYPE_MARK*/void r517generate_once_gc_update_weak_ref_item_polymorph(void);
/*ARRAY_TYPE_MARK*/void r517standard_gc_define2(T517* C);
/*ARRAY_TYPE_MARK*/void r517standard_gc_define1(T517* C);
/*ARRAY_TYPE_MARK*/void r517set_static_generic_list(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517gc_mark_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517update_static_memory(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517just_before_gc_mark_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517standard_gc_info_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/T6 r517same_signature_type(T517* C,T0* a1,T0* a2);
/*ARRAY_TYPE_MARK*/void r517standard_c_typedef(T517* C);
/*ARRAY_TYPE_MARK*/T6 r517is_anchored(void);
/*ARRAY_TYPE_MARK*/void r517c_type_for_argument_in(T0* a1);
/*ARRAY_TYPE_MARK*/void r517gc_info_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/T0* r517written_name(T517* C);
/*ARRAY_TYPE_MARK*/T0* r517default_expression(T296 a1);
/*ARRAY_TYPE_MARK*/void r517c_frame_descriptor_in(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/void r517standard_c_print_function(T517* C);
/*ARRAY_TYPE_MARK*/T0* r517to_static(T517* C,T0* a1);
/*ARRAY_TYPE_MARK*/T6 r517is_agent(void);
/*ARRAY_TYPE_MARK*/void r517gc_define1(T517* C);
/*ARRAY_TYPE_MARK*/T2 r517id(T517* C);
/*ARRAY_TYPE_MARK*/T0* r517long_name(T517* C);
/*ARRAY_TYPE_MARK*/void r517gc_define2(T517* C);
/*ARRAY_TYPE_MARK*/T0* r517signature_resolve_in(T517* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544copy(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544declaration_type(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/void r544c_type_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544id_extra_information(T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544class_text(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_real(void);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544resolve_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_character(void);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_kernel_expanded(void);
/*NATIVE_ARRAY_TYPE_MARK*/void r544c_header_pass1(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_static(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544at(T544* C,T296 a1);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_integer(void);
/*NATIVE_ARRAY_TYPE_MARK*/void r544c_type_for_target_in(T544* C,T0* a1);
extern T0*oBC28from_pointer_name;
extern int fBC28from_pointer_name;
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544from_pointer_name(void);
/*NATIVE_ARRAY_TYPE_MARK*/void r544c_initialize_in(T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544c_type_for_external_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544make(T544* C,T296 a1,T0* a2);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544written_mark(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544twin(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/void r544set_generic_list(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_string(void);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_tuple(void);
/*NATIVE_ARRAY_TYPE_MARK*/void r544recompute_declaration_type(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/void r544pretty_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_formal_generic(void);
/*NATIVE_ARRAY_TYPE_MARK*/T296 r544start_position(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/void r544set_static_generic_list(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544update_static_memory(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544gc_mark_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544just_before_gc_mark_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544same_signature_type(T544* C,T0* a1,T0* a2);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_anchored(void);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_boolean(void);
/*NATIVE_ARRAY_TYPE_MARK*/void r544c_type_for_argument_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544gc_info_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544written_name(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544default_expression(T544* C,T296 a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544c_frame_descriptor_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544standard_c_print_function(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544to_static(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544need_c_struct(void);
/*NATIVE_ARRAY_TYPE_MARK*/void r544gc_define1(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/void r544gc_define2(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544specialize_thru(T544* C,T0* a1,T0* a2,T0* a3);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544signature_resolve_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544gc_mark(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_like_current(void);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_agent(void);
/*NATIVE_ARRAY_TYPE_MARK*/void r544set_start_position(T544* C,T296 a1);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544long_name(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/void r544gc_na_env_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/T2 r544id(T544* C);
extern T0*oBC544native_array_name;
extern int fBC544native_array_name;
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544native_array_name(void);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544elements_type(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544type(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544typed_internals_type_mark(T544* C,T296 a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544c_type_for_result_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544c_header_pass2(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_native_array(void);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r544is_pointer(void);
/*NATIVE_ARRAY_TYPE_MARK*/void r544c_header_pass4(T544* C);
/*NATIVE_ARRAY_TYPE_MARK*/void r544gc_info_nb_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544specialize_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r544gc_call_new_in(T544* C,T0* a1);
/*NATIVE_ARRAY_TYPE_MARK*/T0* r544strings(void);
T543*create543make(T296 a1);
/*BOOLEAN_TYPE_MARK*/void r543copy(T543* C,T0* a1);
/*BOOLEAN_TYPE_MARK*/T0* r543declaration_type(T543* C);
/*BOOLEAN_TYPE_MARK*/void r543id_extra_information(T0* a1);
/*BOOLEAN_TYPE_MARK*/T0* r543class_text(T543* C);
/*BOOLEAN_TYPE_MARK*/T6 r543is_real(void);
/*BOOLEAN_TYPE_MARK*/T0* r543resolve_in(T0* a1);
/*BOOLEAN_TYPE_MARK*/T6 r543is_character(void);
/*BOOLEAN_TYPE_MARK*/T6 r543is_kernel_expanded(void);
/*BOOLEAN_TYPE_MARK*/T0* r543at(T543* C,T296 a1);
/*BOOLEAN_TYPE_MARK*/T6 r543is_integer(void);
/*BOOLEAN_TYPE_MARK*/void r543c_type_for_target_in(T0* a1);
/*BOOLEAN_TYPE_MARK*/void r543c_initialize_in(T0* a1);
/*BOOLEAN_TYPE_MARK*/void r543c_type_for_external_in(T0* a1);
/*BOOLEAN_TYPE_MARK*/void r543make(T543* C,T296 a1);
/*BOOLEAN_TYPE_MARK*/T0* r543written_mark(void);
/*BOOLEAN_TYPE_MARK*/T0* r543twin(T543* C);
/*BOOLEAN_TYPE_MARK*/T6 r543is_string(void);
/*BOOLEAN_TYPE_MARK*/T6 r543is_tuple(void);
/*BOOLEAN_TYPE_MARK*/void r543pretty_in(T0* a1);
/*BOOLEAN_TYPE_MARK*/T6 r543is_formal_generic(void);
/*BOOLEAN_TYPE_MARK*/T296 r543start_position(T543* C);
/*BOOLEAN_TYPE_MARK*/void r543gc_mark_in(T0* a1);
/*BOOLEAN_TYPE_MARK*/void r543c_type_for_va_arg_in(T0* a1);
/*BOOLEAN_TYPE_MARK*/T6 r543same_signature_type(T543* C,T0* a1,T0* a2);
/*BOOLEAN_TYPE_MARK*/T6 r543is_anchored(void);
/*BOOLEAN_TYPE_MARK*/T6 r543is_boolean(void);
/*BOOLEAN_TYPE_MARK*/void r543c_type_for_argument_in(T0* a1);
extern T0*oBC543written_name;
extern int fBC543written_name;
/*BOOLEAN_TYPE_MARK*/T0* r543written_name(void);
/*BOOLEAN_TYPE_MARK*/T0* r543default_expression(T296 a1);
/*BOOLEAN_TYPE_MARK*/void r543c_frame_descriptor_in(T0* a1);
/*BOOLEAN_TYPE_MARK*/T0* r543to_static(T543* C,T0* a1);
/*BOOLEAN_TYPE_MARK*/T0* r543specialize_thru(T543* C,T0* a1,T0* a2,T0* a3);
/*BOOLEAN_TYPE_MARK*/T0* r543signature_resolve_in(T0* a1);
/*BOOLEAN_TYPE_MARK*/T6 r543is_like_current(void);
/*BOOLEAN_TYPE_MARK*/T6 r543is_agent(void);
/*BOOLEAN_TYPE_MARK*/void r543set_start_position(T543* C,T296 a1);
/*BOOLEAN_TYPE_MARK*/T0* r543generic_list(void);
extern T0*oBC543long_name;
extern int fBC543long_name;
/*BOOLEAN_TYPE_MARK*/T0* r543long_name(void);
/*BOOLEAN_TYPE_MARK*/T0* r543type(void);
/*BOOLEAN_TYPE_MARK*/T0* r543typed_internals_type_mark(T543* C,T296 a1);
/*BOOLEAN_TYPE_MARK*/void r543c_type_for_result_in(T0* a1);
/*BOOLEAN_TYPE_MARK*/T6 r543is_native_array(void);
/*BOOLEAN_TYPE_MARK*/T6 r543is_pointer(void);
/*BOOLEAN_TYPE_MARK*/T0* r543specialize_in(T543* C,T0* a1);
/*BOOLEAN_TYPE_MARK*/void r543gc_call_new_in(T0* a1);
T542*create542make(T296 a1);
/*CHARACTER_TYPE_MARK*/void r542copy(T542* C,T0* a1);
/*CHARACTER_TYPE_MARK*/T0* r542declaration_type(T542* C);
/*CHARACTER_TYPE_MARK*/void r542id_extra_information(T0* a1);
/*CHARACTER_TYPE_MARK*/T0* r542class_text(T542* C);
/*CHARACTER_TYPE_MARK*/T6 r542is_real(void);
/*CHARACTER_TYPE_MARK*/T0* r542resolve_in(T0* a1);
/*CHARACTER_TYPE_MARK*/T6 r542is_character(void);
/*CHARACTER_TYPE_MARK*/T6 r542is_kernel_expanded(void);
/*CHARACTER_TYPE_MARK*/T0* r542at(T542* C,T296 a1);
/*CHARACTER_TYPE_MARK*/T6 r542is_integer(void);
/*CHARACTER_TYPE_MARK*/void r542c_type_for_target_in(T0* a1);
/*CHARACTER_TYPE_MARK*/void r542c_initialize_in(T0* a1);
/*CHARACTER_TYPE_MARK*/void r542c_type_for_external_in(T0* a1);
/*CHARACTER_TYPE_MARK*/void r542make(T542* C,T296 a1);
/*CHARACTER_TYPE_MARK*/T0* r542written_mark(void);
/*CHARACTER_TYPE_MARK*/T0* r542twin(T542* C);
/*CHARACTER_TYPE_MARK*/T6 r542is_string(void);
/*CHARACTER_TYPE_MARK*/T6 r542is_tuple(void);
/*CHARACTER_TYPE_MARK*/void r542pretty_in(T0* a1);
/*CHARACTER_TYPE_MARK*/T6 r542is_formal_generic(void);
/*CHARACTER_TYPE_MARK*/T296 r542start_position(T542* C);
/*CHARACTER_TYPE_MARK*/void r542gc_mark_in(T0* a1);
/*CHARACTER_TYPE_MARK*/void r542c_type_for_va_arg_in(T0* a1);
/*CHARACTER_TYPE_MARK*/T6 r542same_signature_type(T542* C,T0* a1,T0* a2);
/*CHARACTER_TYPE_MARK*/T6 r542is_anchored(void);
/*CHARACTER_TYPE_MARK*/T6 r542is_boolean(void);
/*CHARACTER_TYPE_MARK*/void r542c_type_for_argument_in(T0* a1);
extern T0*oBC542written_name;
extern int fBC542written_name;
/*CHARACTER_TYPE_MARK*/T0* r542written_name(void);
/*CHARACTER_TYPE_MARK*/T0* r542default_expression(T296 a1);
/*CHARACTER_TYPE_MARK*/void r542c_frame_descriptor_in(T0* a1);
/*CHARACTER_TYPE_MARK*/T0* r542to_static(T542* C,T0* a1);
/*CHARACTER_TYPE_MARK*/T0* r542specialize_thru(T542* C,T0* a1,T0* a2,T0* a3);
/*CHARACTER_TYPE_MARK*/T0* r542signature_resolve_in(T0* a1);
/*CHARACTER_TYPE_MARK*/T6 r542is_like_current(void);
/*CHARACTER_TYPE_MARK*/T6 r542is_agent(void);
/*CHARACTER_TYPE_MARK*/void r542set_start_position(T542* C,T296 a1);
/*CHARACTER_TYPE_MARK*/T0* r542generic_list(void);
extern T0*oBC542long_name;
extern int fBC542long_name;
/*CHARACTER_TYPE_MARK*/T0* r542long_name(void);
/*CHARACTER_TYPE_MARK*/T0* r542type(void);
/*CHARACTER_TYPE_MARK*/T0* r542typed_internals_type_mark(T542* C,T296 a1);
/*CHARACTER_TYPE_MARK*/void r542c_type_for_result_in(T0* a1);
/*CHARACTER_TYPE_MARK*/T6 r542is_native_array(void);
/*CHARACTER_TYPE_MARK*/T6 r542is_pointer(void);
/*CHARACTER_TYPE_MARK*/T0* r542specialize_in(T542* C,T0* a1);
/*CHARACTER_TYPE_MARK*/void r542gc_call_new_in(T0* a1);
T541*create541make(T0* a1);
/*CLASS_TYPE_MARK*/T6 r541is_empty_expanded(T541* C);
/*CLASS_TYPE_MARK*/void r541copy(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/T0* r541declaration_type(T541* C);
/*CLASS_TYPE_MARK*/void r541id_extra_information(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/T0* r541class_text(T541* C);
/*CLASS_TYPE_MARK*/T6 r541is_real(void);
/*CLASS_TYPE_MARK*/T0* r541resolve_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/T6 r541is_character(void);
/*CLASS_TYPE_MARK*/T6 r541is_expanded(T541* C);
/*CLASS_TYPE_MARK*/T6 r541is_kernel_expanded(void);
/*CLASS_TYPE_MARK*/T6 r541is_reference(T541* C);
/*CLASS_TYPE_MARK*/void r541c_header_pass1(T541* C);
/*CLASS_TYPE_MARK*/T0* r541at(T541* C,T296 a1);
/*CLASS_TYPE_MARK*/T6 r541is_integer(void);
/*CLASS_TYPE_MARK*/void r541c_type_for_target_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/T6 r541is_user_expanded(T541* C);
/*CLASS_TYPE_MARK*/void r541c_initialize_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541gc_store_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541c_type_for_external_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/T0* r541canonical_long_name(T541* C);
/*CLASS_TYPE_MARK*/void r541make(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/T0* r541written_mark(T541* C);
/*CLASS_TYPE_MARK*/T0* r541twin(T541* C);
/*CLASS_TYPE_MARK*/T6 r541is_string(void);
/*CLASS_TYPE_MARK*/T6 r541is_tuple(void);
/*CLASS_TYPE_MARK*/void r541gc_store_chunk_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541pretty_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/T6 r541is_formal_generic(void);
/*CLASS_TYPE_MARK*/void r541generate_once_gc_update_weak_ref_item_polymorph(void);
/*CLASS_TYPE_MARK*/T296 r541start_position(T541* C);
/*CLASS_TYPE_MARK*/void r541standard_gc_define2(T541* C);
/*CLASS_TYPE_MARK*/void r541standard_gc_define1(T541* C);
/*CLASS_TYPE_MARK*/void r541gc_mark_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541just_before_gc_mark_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541standard_gc_define2_for_expanded(T541* C);
/*CLASS_TYPE_MARK*/void r541standard_gc_info_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/T6 r541same_signature_type(T541* C,T0* a1,T0* a2);
/*CLASS_TYPE_MARK*/void r541standard_c_typedef(T541* C);
/*CLASS_TYPE_MARK*/T6 r541is_anchored(void);
/*CLASS_TYPE_MARK*/T6 r541is_boolean(void);
/*CLASS_TYPE_MARK*/T6 r541need_gc_mark_function(T541* C);
/*CLASS_TYPE_MARK*/void r541c_type_for_argument_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541gc_info_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/T0* r541written_name(T541* C);
/*CLASS_TYPE_MARK*/T0* r541default_expression(T541* C,T296 a1);
/*CLASS_TYPE_MARK*/void r541c_frame_descriptor_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541standard_c_print_function(T541* C);
/*CLASS_TYPE_MARK*/T0* r541to_static(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/T6 r541need_c_struct(T541* C);
/*CLASS_TYPE_MARK*/void r541gc_define1(T541* C);
/*CLASS_TYPE_MARK*/void r541gc_define2(T541* C);
/*CLASS_TYPE_MARK*/T0* r541specialize_thru(T541* C,T0* a1,T0* a2,T0* a3);
/*CLASS_TYPE_MARK*/T0* r541signature_resolve_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541c_initialize_user_expanded_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541gc_free_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541gc_align_mark_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541standard_c_struct(T541* C);
/*CLASS_TYPE_MARK*/T6 r541is_like_current(void);
/*CLASS_TYPE_MARK*/T6 r541is_agent(void);
/*CLASS_TYPE_MARK*/void r541set_start_position(T541* C,T296 a1);
/*CLASS_TYPE_MARK*/T0* r541generic_list(void);
/*CLASS_TYPE_MARK*/T0* r541long_name(T541* C);
/*CLASS_TYPE_MARK*/void r541standard_c_object_model(T541* C);
/*CLASS_TYPE_MARK*/T2 r541id(T541* C);
/*CLASS_TYPE_MARK*/T0* r541type(T541* C);
/*CLASS_TYPE_MARK*/T0* r541typed_internals_type_mark(T541* C,T296 a1);
/*CLASS_TYPE_MARK*/void r541gc_store_left_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541c_type_for_result_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541c_header_pass3(T541* C);
/*CLASS_TYPE_MARK*/T6 r541is_native_array(void);
/*CLASS_TYPE_MARK*/T6 r541is_pointer(void);
/*CLASS_TYPE_MARK*/void r541c_header_pass4(T541* C);
/*CLASS_TYPE_MARK*/void r541standard_just_before_gc_mark_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541gc_info_nb_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/T0* r541specialize_in(T541* C,T0* a1);
/*CLASS_TYPE_MARK*/void r541gc_call_new_in(T541* C,T0* a1);
T540*create540make(T296 a1);
/*POINTER_TYPE_MARK*/void r540copy(T540* C,T0* a1);
/*POINTER_TYPE_MARK*/T0* r540declaration_type(T540* C);
/*POINTER_TYPE_MARK*/void r540id_extra_information(T0* a1);
/*POINTER_TYPE_MARK*/T0* r540class_text(T540* C);
/*POINTER_TYPE_MARK*/T6 r540is_real(void);
/*POINTER_TYPE_MARK*/T0* r540resolve_in(T0* a1);
/*POINTER_TYPE_MARK*/T6 r540is_character(void);
/*POINTER_TYPE_MARK*/T6 r540is_kernel_expanded(void);
/*POINTER_TYPE_MARK*/T0* r540at(T540* C,T296 a1);
/*POINTER_TYPE_MARK*/T6 r540is_integer(void);
/*POINTER_TYPE_MARK*/void r540c_type_for_target_in(T0* a1);
/*POINTER_TYPE_MARK*/void r540c_initialize_in(T0* a1);
/*POINTER_TYPE_MARK*/void r540c_type_for_external_in(T0* a1);
/*POINTER_TYPE_MARK*/void r540make(T540* C,T296 a1);
/*POINTER_TYPE_MARK*/T0* r540written_mark(void);
/*POINTER_TYPE_MARK*/T0* r540twin(T540* C);
/*POINTER_TYPE_MARK*/T6 r540is_string(void);
/*POINTER_TYPE_MARK*/T6 r540is_tuple(void);
/*POINTER_TYPE_MARK*/void r540pretty_in(T0* a1);
/*POINTER_TYPE_MARK*/T6 r540is_formal_generic(void);
/*POINTER_TYPE_MARK*/T296 r540start_position(T540* C);
/*POINTER_TYPE_MARK*/void r540gc_mark_in(T0* a1);
/*POINTER_TYPE_MARK*/void r540c_type_for_va_arg_in(T0* a1);
/*POINTER_TYPE_MARK*/T6 r540same_signature_type(T540* C,T0* a1,T0* a2);
/*POINTER_TYPE_MARK*/T6 r540is_anchored(void);
/*POINTER_TYPE_MARK*/T6 r540is_boolean(void);
/*POINTER_TYPE_MARK*/void r540c_type_for_argument_in(T0* a1);
extern T0*oBC540written_name;
extern int fBC540written_name;
/*POINTER_TYPE_MARK*/T0* r540written_name(void);
/*POINTER_TYPE_MARK*/T0* r540default_expression(T540* C,T296 a1);
/*POINTER_TYPE_MARK*/void r540c_frame_descriptor_in(T0* a1);
/*POINTER_TYPE_MARK*/T0* r540to_static(T540* C,T0* a1);
/*POINTER_TYPE_MARK*/T0* r540specialize_thru(T540* C,T0* a1,T0* a2,T0* a3);
/*POINTER_TYPE_MARK*/T0* r540signature_resolve_in(T0* a1);
/*POINTER_TYPE_MARK*/T6 r540is_like_current(void);
/*POINTER_TYPE_MARK*/T6 r540is_agent(void);
/*POINTER_TYPE_MARK*/void r540set_start_position(T540* C,T296 a1);
/*POINTER_TYPE_MARK*/T0* r540generic_list(void);
extern T0*oBC540long_name;
extern int fBC540long_name;
/*POINTER_TYPE_MARK*/T0* r540long_name(void);
/*POINTER_TYPE_MARK*/T0* r540type(void);
/*POINTER_TYPE_MARK*/T0* r540typed_internals_type_mark(T540* C,T296 a1);
/*POINTER_TYPE_MARK*/void r540c_type_for_result_in(T0* a1);
/*POINTER_TYPE_MARK*/T6 r540is_native_array(void);
/*POINTER_TYPE_MARK*/T6 r540is_pointer(void);
/*POINTER_TYPE_MARK*/T0* r540specialize_in(T540* C,T0* a1);
/*POINTER_TYPE_MARK*/void r540gc_call_new_in(T0* a1);
T338*create338real_32(T296 a1);
T338*create338real(T296 a1);
T338*create338real_extended(T296 a1);
/*REAL_TYPE_MARK*/void r338copy(T338* C,T0* a1);
/*REAL_TYPE_MARK*/T0* r338declaration_type(T338* C);
/*REAL_TYPE_MARK*/T6 r338can_be_assigned_to(T338* C,T0* a1);
/*REAL_TYPE_MARK*/void r338id_extra_information(T0* a1);
/*REAL_TYPE_MARK*/T0* r338class_text(T338* C);
/*REAL_TYPE_MARK*/T6 r338is_real(void);
/*REAL_TYPE_MARK*/T0* r338resolve_in(T338* C,T0* a1);
/*REAL_TYPE_MARK*/T6 r338is_character(void);
/*REAL_TYPE_MARK*/T6 r338is_kernel_expanded(void);
/*REAL_TYPE_MARK*/T0* r338at(T338* C,T296 a1);
/*REAL_TYPE_MARK*/T6 r338is_integer(void);
/*REAL_TYPE_MARK*/void r338c_type_for_target_in(T338* C,T0* a1);
/*REAL_TYPE_MARK*/void r338c_initialize_in(T0* a1);
/*REAL_TYPE_MARK*/void r338c_type_for_external_in(T338* C,T0* a1);
/*REAL_TYPE_MARK*/T0* r338written_mark(T338* C);
/*REAL_TYPE_MARK*/T0* r338twin(T338* C);
/*REAL_TYPE_MARK*/T6 r338is_string(void);
/*REAL_TYPE_MARK*/T6 r338is_tuple(void);
/*REAL_TYPE_MARK*/void r338pretty_in(T338* C,T0* a1);
/*REAL_TYPE_MARK*/T6 r338is_formal_generic(void);
/*REAL_TYPE_MARK*/T296 r338start_position(T338* C);
/*REAL_TYPE_MARK*/void r338gc_mark_in(T338* C,T0* a1);
/*REAL_TYPE_MARK*/T3 r338structure_mark(T338* C);
/*REAL_TYPE_MARK*/void r338c_type_for_va_arg_in(T338* C,T0* a1);
/*REAL_TYPE_MARK*/T6 r338same_signature_type(T338* C,T0* a1,T0* a2);
/*REAL_TYPE_MARK*/T6 r338is_anchored(void);
/*REAL_TYPE_MARK*/T6 r338is_boolean(void);
/*REAL_TYPE_MARK*/void r338c_type_for_argument_in(T338* C,T0* a1);
/*REAL_TYPE_MARK*/T0* r338written_name(T338* C);
/*REAL_TYPE_MARK*/T0* r338default_expression(T338* C,T296 a1);
/*REAL_TYPE_MARK*/void r338c_frame_descriptor_in(T338* C,T0* a1);
extern T0*oBC338real_80_name;
extern int fBC338real_80_name;
/*REAL_TYPE_MARK*/T0* r338real_80_name(void);
extern T0*oBC338real_64_name;
extern int fBC338real_64_name;
/*REAL_TYPE_MARK*/T0* r338real_64_name(void);
/*REAL_TYPE_MARK*/T0* r338to_static(T338* C,T0* a1);
extern T0*oBC338real_128_name;
extern int fBC338real_128_name;
/*REAL_TYPE_MARK*/T0* r338real_128_name(void);
extern T0*oBC338real_name;
extern int fBC338real_name;
/*REAL_TYPE_MARK*/T0* r338real_name(void);
extern T0*oBC338real_32_name;
extern int fBC338real_32_name;
/*REAL_TYPE_MARK*/T0* r338real_32_name(void);
/*REAL_TYPE_MARK*/void r338real_32(T338* C,T296 a1);
/*REAL_TYPE_MARK*/void r338real_64(T338* C,T296 a1);
/*REAL_TYPE_MARK*/T0* r338specialize_thru(T338* C,T0* a1,T0* a2,T0* a3);
/*REAL_TYPE_MARK*/T0* r338signature_resolve_in(T338* C,T0* a1);
/*REAL_TYPE_MARK*/void r338real_80(T338* C,T296 a1);
extern T0*oBC338real_extended_name;
extern int fBC338real_extended_name;
/*REAL_TYPE_MARK*/T0* r338real_extended_name(void);
/*REAL_TYPE_MARK*/void r338real_extended(T338* C,T296 a1);
/*REAL_TYPE_MARK*/void r338real_128(T338* C,T296 a1);
/*REAL_TYPE_MARK*/void r338real(T338* C,T296 a1);
/*REAL_TYPE_MARK*/T6 r338is_like_current(void);
/*REAL_TYPE_MARK*/T6 r338is_agent(void);
/*REAL_TYPE_MARK*/void r338set_start_position(T338* C,T296 a1);
/*REAL_TYPE_MARK*/T0* r338generic_list(void);
/*REAL_TYPE_MARK*/T0* r338long_name(T338* C);
/*REAL_TYPE_MARK*/T2 r338id(T338* C);
/*REAL_TYPE_MARK*/T0* r338type(T338* C);
/*REAL_TYPE_MARK*/T0* r338typed_internals_type_mark(T338* C,T296 a1);
/*REAL_TYPE_MARK*/void r338c_type_for_result_in(T338* C,T0* a1);
/*REAL_TYPE_MARK*/T6 r338is_native_array(void);
/*REAL_TYPE_MARK*/T6 r338is_pointer(void);
/*REAL_TYPE_MARK*/T0* r338specialize_in(T338* C,T0* a1);
/*REAL_TYPE_MARK*/void r338gc_call_new_in(T338* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538copy(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538declaration_type(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/void r538id_extra_information(T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538class_text(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538is_real(void);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538resolve_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538is_character(void);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538is_kernel_expanded(void);
/*EMPTY_TUPLE_TYPE_MARK*/void r538c_header_pass1(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538at(T538* C,T296 a1);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538is_integer(void);
/*EMPTY_TUPLE_TYPE_MARK*/void r538c_type_for_target_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538c_initialize_in(T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538gc_store_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538c_type_for_external_in(T0* a1);
extern T0*oBC537canonical_long_name;
extern int fBC537canonical_long_name;
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538canonical_long_name(void);
/*EMPTY_TUPLE_TYPE_MARK*/void r538make(T538* C,T296 a1);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538written_mark(void);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538twin(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538is_string(void);
/*EMPTY_TUPLE_TYPE_MARK*/void r538gc_store_chunk_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538pretty_in(T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538is_formal_generic(void);
/*EMPTY_TUPLE_TYPE_MARK*/void r538generate_once_gc_update_weak_ref_item_polymorph(void);
/*EMPTY_TUPLE_TYPE_MARK*/T296 r538start_position(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/void r538standard_gc_define2(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/void r538standard_gc_define1(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/void r538gc_mark_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538just_before_gc_mark_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538standard_gc_info_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538same_signature_type(T538* C,T0* a1,T0* a2);
/*EMPTY_TUPLE_TYPE_MARK*/void r538standard_c_typedef(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538is_anchored(void);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538is_boolean(void);
/*EMPTY_TUPLE_TYPE_MARK*/void r538c_type_for_argument_in(T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538gc_info_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538written_name(void);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538default_expression(T296 a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538c_frame_descriptor_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538standard_c_print_function(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538to_static(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538need_c_struct(void);
/*EMPTY_TUPLE_TYPE_MARK*/void r538gc_define1(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/void r538gc_define2(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538specialize_thru(T538* C,T0* a1,T0* a2,T0* a3);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538signature_resolve_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538gc_free_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538gc_align_mark_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538standard_c_struct(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538is_like_current(void);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538is_agent(void);
/*EMPTY_TUPLE_TYPE_MARK*/void r538set_start_position(T538* C,T296 a1);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538generic_list(void);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538long_name(void);
/*EMPTY_TUPLE_TYPE_MARK*/void r538standard_c_object_model(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/T2 r538id(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538type(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538typed_internals_type_mark(T538* C,T296 a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538gc_store_left_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538c_type_for_result_in(T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538is_native_array(void);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r538is_pointer(void);
/*EMPTY_TUPLE_TYPE_MARK*/void r538c_header_pass4(T538* C);
/*EMPTY_TUPLE_TYPE_MARK*/void r538standard_just_before_gc_mark_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538gc_info_nb_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/T0* r538specialize_in(T538* C,T0* a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r538gc_call_new_in(T538* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536gc_free_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536c_type_for_result_in(T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536gc_align_mark_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536is_native_array(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536copy(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536standard_c_struct(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536is_pointer(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536is_like_current(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536set_start_position(T536* C,T296 a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536standard_c_object_model(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536typed_internals_type_mark(T536* C,T296 a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536is_real(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536gc_store_left_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536c_header_pass4(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536standard_just_before_gc_mark_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536is_character(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536specialize_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536gc_info_nb_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536gc_call_new_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536is_kernel_expanded(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536is_integer(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536declaration_type(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536is_static(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536resolve_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536c_type_for_target_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536c_header_pass1(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536twin(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536make(T536* C,T296 a1,T0* a2);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536is_string(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T296 r536start_position(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536pretty_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536is_boolean(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536specialize_thru(T536* C,T0* a1,T0* a2,T0* a3);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536type(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536strings(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536id_extra_information(T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536class_text(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536at(T536* C,T296 a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536c_initialize_in(T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536gc_store_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536c_type_for_external_in(T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536canonical_long_name(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536written_mark(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536set_generic_list(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536gc_store_chunk_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536recompute_declaration_type(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536is_formal_generic(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536generate_once_gc_update_weak_ref_item_polymorph(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536standard_gc_define2(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536standard_gc_define1(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536set_static_generic_list(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536gc_mark_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536update_static_memory(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536just_before_gc_mark_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536standard_gc_info_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536same_signature_type(T536* C,T0* a1,T0* a2);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536standard_c_typedef(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536is_anchored(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536c_type_for_argument_in(T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536gc_info_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536written_name(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536default_expression(T296 a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536c_frame_descriptor_in(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536standard_c_print_function(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536to_static(T536* C,T0* a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r536is_agent(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536gc_define1(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T2 r536id(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536long_name(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r536gc_define2(T536* C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0* r536signature_resolve_in(T536* C,T0* a1);
/*AGENT_TYPE_MARK*/void r534c_type_for_result_in(T0* a1);
/*AGENT_TYPE_MARK*/T6 r534is_native_array(void);
/*AGENT_TYPE_MARK*/void r534copy(T534* C,T0* a1);
extern T0*oBC534function_name;
extern int fBC534function_name;
/*AGENT_TYPE_MARK*/T0* r534function_name(void);
/*AGENT_TYPE_MARK*/T0* r534written_open(T534* C);
/*AGENT_TYPE_MARK*/T6 r534is_pointer(void);
/*AGENT_TYPE_MARK*/T6 r534is_like_current(void);
/*AGENT_TYPE_MARK*/void r534procedure(T534* C,T296 a1,T0* a2);
/*AGENT_TYPE_MARK*/void r534set_start_position(T534* C,T296 a1);
extern T0*oBC534routine_name;
extern int fBC534routine_name;
/*AGENT_TYPE_MARK*/T0* r534routine_name(void);
/*AGENT_TYPE_MARK*/void r534predicate(T534* C,T296 a1,T0* a2);
/*AGENT_TYPE_MARK*/void r534routine(T534* C,T296 a1,T0* a2);
extern T0*oBC534procedure_name;
extern int fBC534procedure_name;
/*AGENT_TYPE_MARK*/T0* r534procedure_name(void);
/*AGENT_TYPE_MARK*/void r534open_check(T534* C,T0* a1,T0* a2);
/*AGENT_TYPE_MARK*/T0* r534typed_internals_type_mark(T534* C,T296 a1);
/*AGENT_TYPE_MARK*/T6 r534is_real(void);
/*AGENT_TYPE_MARK*/void r534function(T534* C,T296 a1,T0* a2,T0* a3);
/*AGENT_TYPE_MARK*/void r534c_header_pass4(T534* C);
/*AGENT_TYPE_MARK*/T6 r534is_character(void);
/*AGENT_TYPE_MARK*/T0* r534specialize_in(T534* C,T0* a1);
/*AGENT_TYPE_MARK*/void r534gc_call_new_in(T534* C,T0* a1);
/*AGENT_TYPE_MARK*/T6 r534is_kernel_expanded(void);
/*AGENT_TYPE_MARK*/T6 r534is_integer(void);
/*AGENT_TYPE_MARK*/T0* r534declaration_type(T534* C);
/*AGENT_TYPE_MARK*/T6 r534is_static(T534* C);
/*AGENT_TYPE_MARK*/T0* r534resolve_in(T534* C,T0* a1);
/*AGENT_TYPE_MARK*/void r534c_type_for_target_in(T534* C,T0* a1);
/*AGENT_TYPE_MARK*/void r534c_header_pass1(T534* C);
/*AGENT_TYPE_MARK*/T0* r534twin(T534* C);
/*AGENT_TYPE_MARK*/T6 r534is_string(void);
/*AGENT_TYPE_MARK*/T6 r534is_tuple(void);
/*AGENT_TYPE_MARK*/T296 r534start_position(T534* C);
/*AGENT_TYPE_MARK*/void r534pretty_in(T534* C,T0* a1);
/*AGENT_TYPE_MARK*/T6 r534is_boolean(void);
/*AGENT_TYPE_MARK*/T0* r534specialize_thru(T534* C,T0* a1,T0* a2,T0* a3);
/*AGENT_TYPE_MARK*/T0* r534result_type(T534* C);
/*AGENT_TYPE_MARK*/T0* r534type(T534* C);
/*AGENT_TYPE_MARK*/T0* r534strings(void);
/*AGENT_TYPE_MARK*/void r534id_extra_information(T0* a1);
/*AGENT_TYPE_MARK*/T0* r534class_text(T534* C);
/*AGENT_TYPE_MARK*/T0* r534at(T534* C,T296 a1);
/*AGENT_TYPE_MARK*/void r534c_initialize_in(T0* a1);
/*AGENT_TYPE_MARK*/void r534c_type_for_external_in(T0* a1);
/*AGENT_TYPE_MARK*/T0* r534canonical_long_name(T534* C);
/*AGENT_TYPE_MARK*/void r534basic_make(T534* C,T2 a1,T0* a2,T0* a3);
/*AGENT_TYPE_MARK*/T0* r534written_mark(T534* C);
/*AGENT_TYPE_MARK*/void r534set_generic_list(T534* C,T0* a1);
/*AGENT_TYPE_MARK*/void r534recompute_declaration_type(T534* C);
/*AGENT_TYPE_MARK*/T6 r534is_formal_generic(void);
/*AGENT_TYPE_MARK*/void r534set_static_generic_list(T534* C,T0* a1);
/*AGENT_TYPE_MARK*/void r534gc_mark_in(T534* C,T0* a1);
/*AGENT_TYPE_MARK*/void r534update_static_memory(T534* C,T0* a1);
/*AGENT_TYPE_MARK*/T6 r534same_signature_type(T534* C,T0* a1,T0* a2);
/*AGENT_TYPE_MARK*/T6 r534is_anchored(void);
/*AGENT_TYPE_MARK*/void r534c_type_for_argument_in(T0* a1);
/*AGENT_TYPE_MARK*/T0* r534written_name(T534* C);
/*AGENT_TYPE_MARK*/T0* r534default_expression(T296 a1);
/*AGENT_TYPE_MARK*/void r534c_frame_descriptor_in(T534* C,T0* a1);
/*AGENT_TYPE_MARK*/void r534standard_c_print_function(T534* C);
/*AGENT_TYPE_MARK*/T0* r534to_static(T534* C,T0* a1);
/*AGENT_TYPE_MARK*/T6 r534is_agent(void);
/*AGENT_TYPE_MARK*/void r534gc_define1(T534* C);
/*AGENT_TYPE_MARK*/T2 r534id(T534* C);
/*AGENT_TYPE_MARK*/T0* r534long_name(T534* C);
/*AGENT_TYPE_MARK*/T0* r534signature_resolve_in(T534* C,T0* a1);
/*AGENT_TYPE_MARK*/T0* r534_P_333_specialize_thru(T534* C,T0* a1,T0* a2,T0* a3);
/*AGENT_TYPE_MARK*/T0* r534_P_333_specialize_in(T534* C,T0* a1);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_empty_expanded(void);
/*LIKE_FEATURE_TYPE_MARK*/void r526copy(T526* C,T0* a1);
/*LIKE_FEATURE_TYPE_MARK*/void r526id_extra_information(T0* a1);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526class_text(T526* C);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_real(void);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526resolve_in(T526* C,T0* a1);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_character(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_expanded(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_kernel_expanded(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_reference(void);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526at(T526* C,T296 a1);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_integer(void);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526feature_accumulator(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_generic(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_user_expanded(void);
/*LIKE_FEATURE_TYPE_MARK*/void r526make(T526* C,T296 a1,T0* a2);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526written_mark(T526* C);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526twin(T526* C);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_string(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_tuple(void);
/*LIKE_FEATURE_TYPE_MARK*/void r526pretty_in(T526* C,T0* a1);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_formal_generic(void);
/*LIKE_FEATURE_TYPE_MARK*/void r526gc_mark_in(T0* a1);
extern T0*oBC523written_mark_buffer;
extern int fBC523written_mark_buffer;
/*LIKE_FEATURE_TYPE_MARK*/T0* r526written_mark_buffer(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526same_signature_type(T526* C,T0* a1,T0* a2);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_anchored(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_boolean(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526need_gc_mark_function(void);
/*LIKE_FEATURE_TYPE_MARK*/void r526twin_feature_stamp_memory(T526* C,T0* a1,T0* a2);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526default_expression(T526* C,T296 a1);
/*LIKE_FEATURE_TYPE_MARK*/void r526c_frame_descriptor_in(T0* a1);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526to_static(T526* C,T0* a1);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526need_c_struct(void);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526specialize_thru(T526* C,T0* a1,T0* a2,T0* a3);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526signature_resolve_in(T526* C,T0* a1);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_like_current(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_agent(void);
/*LIKE_FEATURE_TYPE_MARK*/void r526set_start_position(T526* C,T296 a1);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526generic_list(void);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526class_text_name(void);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526long_name(void);
/*LIKE_FEATURE_TYPE_MARK*/T2 r526id(void);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526type(void);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526typed_internals_type_mark(T526* C,T296 a1);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_native_array(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r526is_pointer(void);
/*LIKE_FEATURE_TYPE_MARK*/T0* r526specialize_in(T526* C,T0* a1);
/*LIKE_FEATURE_TYPE_MARK*/void r526gc_call_new_in(T0* a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_empty_expanded(void);
/*LIKE_ARGUMENT_TYPE_MARK*/void r525copy(T525* C,T0* a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525declaration_type(T525* C);
/*LIKE_ARGUMENT_TYPE_MARK*/void r525id_extra_information(T0* a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525class_text(T525* C);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_real(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525resolve_in(T525* C,T0* a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_character(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_expanded(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_kernel_expanded(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_reference(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525at(T525* C,T296 a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_integer(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_generic(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_user_expanded(void);
/*LIKE_ARGUMENT_TYPE_MARK*/void r525make(T525* C,T296 a1,T0* a2);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525written_mark(T525* C);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525twin(T525* C);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_string(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_tuple(void);
/*LIKE_ARGUMENT_TYPE_MARK*/void r525pretty_in(T525* C,T0* a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_formal_generic(void);
/*LIKE_ARGUMENT_TYPE_MARK*/void r525gc_mark_in(T0* a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525written_mark_buffer(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525same_signature_type(T525* C,T0* a1,T0* a2);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_anchored(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_boolean(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525need_gc_mark_function(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525default_expression(T525* C,T296 a1);
/*LIKE_ARGUMENT_TYPE_MARK*/void r525c_frame_descriptor_in(T0* a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525to_static(T525* C,T0* a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525need_c_struct(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525specialize_thru(T525* C,T0* a1,T0* a2,T0* a3);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525signature_resolve_in(T525* C,T0* a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_like_current(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_agent(void);
/*LIKE_ARGUMENT_TYPE_MARK*/void r525set_start_position(T525* C,T296 a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525generic_list(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525class_text_name(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525long_name(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T2 r525id(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525type(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525typed_internals_type_mark(T525* C,T296 a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_native_array(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r525is_pointer(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T0* r525specialize_in(T525* C,T0* a1);
/*LIKE_ARGUMENT_TYPE_MARK*/void r525gc_call_new_in(T0* a1);
/*FORMAL_ARG_LIST*/void r285copy(T285* C,T0* a1);
/*FORMAL_ARG_LIST*/T2 r285count(T285* C);
/*FORMAL_ARG_LIST*/T0* r285type_mark(T285* C,T2 a1);
/*FORMAL_ARG_LIST*/T2 r285rank_of(T285* C,T0* a1);
/*FORMAL_ARG_LIST*/T2 r285fast_rank_of(T285* C,T0* a1);
/*FORMAL_ARG_LIST*/void r285name_clash_check(T285* C,T0* a1);
/*FORMAL_ARG_LIST*/void r285declaration_list_make(T285* C,T0* a1);
/*FORMAL_ARG_LIST*/void r285compile_to_c_in(T285* C,T0* a1,T0* a2);
/*FORMAL_ARG_LIST*/T0* r285specialize_thru(T285* C,T0* a1,T0* a2,T0* a3);
/*FORMAL_ARG_LIST*/void r285c_frame_descriptor(T285* C,T0* a1,T0* a2,T0* a3);
/*FORMAL_ARG_LIST*/void r285add_last(T285* C,T0* a1);
/*FORMAL_ARG_LIST*/void r285external_prototype_in(T285* C,T0* a1);
/*FORMAL_ARG_LIST*/T0* r285omitted_open_arguments(T285* C,T296 a1);
/*FORMAL_ARG_LIST*/T0* r285specialize_in(T285* C,T0* a1);
/*FORMAL_ARG_LIST*/T0* r285adapt_for(T285* C,T0* a1);
/*FORMAL_ARG_LIST*/void r285make(T285* C,T0* a1);
/*FORMAL_ARG_LIST*/T0* r285twin(T285* C);
/*FORMAL_ARG_LIST*/T296 r285start_position(T285* C);
T522*create522make(T296 a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_empty_expanded(void);
/*LIKE_CURRENT_TYPE_MARK*/void r522copy(T522* C,T0* a1);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522declaration_type(T522* C);
/*LIKE_CURRENT_TYPE_MARK*/void r522id_extra_information(T0* a1);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522class_text(T522* C);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_real(void);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522resolve_in(T0* a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_character(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_expanded(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_kernel_expanded(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_reference(void);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522at(T522* C,T296 a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_integer(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_generic(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_user_expanded(void);
/*LIKE_CURRENT_TYPE_MARK*/void r522make(T522* C,T296 a1);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522written_mark(void);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522twin(T522* C);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_string(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_tuple(void);
/*LIKE_CURRENT_TYPE_MARK*/void r522pretty_in(T0* a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_formal_generic(void);
/*LIKE_CURRENT_TYPE_MARK*/void r522gc_mark_in(T0* a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522same_signature_type(T522* C,T0* a1,T0* a2);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_anchored(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_boolean(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522need_gc_mark_function(void);
extern T0*oBC522written_name;
extern int fBC522written_name;
/*LIKE_CURRENT_TYPE_MARK*/T0* r522written_name(void);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522default_expression(T522* C,T296 a1);
/*LIKE_CURRENT_TYPE_MARK*/void r522c_frame_descriptor_in(T0* a1);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522to_static(T0* a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522need_c_struct(void);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522specialize_thru(T522* C,T0* a1,T0* a2,T0* a3);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522signature_resolve_in(T0* a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_like_current(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_agent(void);
/*LIKE_CURRENT_TYPE_MARK*/void r522set_start_position(T522* C,T296 a1);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522generic_list(void);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522class_text_name(void);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522long_name(void);
/*LIKE_CURRENT_TYPE_MARK*/T2 r522id(void);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522type(void);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522typed_internals_type_mark(T522* C,T296 a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_native_array(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r522is_pointer(void);
/*LIKE_CURRENT_TYPE_MARK*/T0* r522specialize_in(T522* C,T0* a1);
/*LIKE_CURRENT_TYPE_MARK*/void r522gc_call_new_in(T0* a1);
T428*create428question_mark(T296 a1);
/*OPEN_OPERAND*/T6 r428use_current(T0* a1);
/*OPEN_OPERAND*/T6 r428side_effect_free(T0* a1);
/*OPEN_OPERAND*/void r428copy(T428* C,T0* a1);
/*OPEN_OPERAND*/T0* r428declaration_type(T428* C);
/*OPEN_OPERAND*/T0* r428adapt_for(T428* C,T0* a1);
/*OPEN_OPERAND*/T6 r428is_equal(T428* C,T0* a1);
/*OPEN_OPERAND*/T0* r428resolve_in(T428* C,T0* a1);
/*OPEN_OPERAND*/T0* r428current_or_twin_init(T428* C,T0* a1);
/*OPEN_OPERAND*/T0* r428written_declaration_type_mark(void);
/*OPEN_OPERAND*/T0* r428collect(T428* C,T0* a1);
/*OPEN_OPERAND*/void r428mapping_c_arg(T428* C,T0* a1);
/*OPEN_OPERAND*/T2 r428precedence(void);
/*OPEN_OPERAND*/T6 r428is_default_value(void);
/*OPEN_OPERAND*/void r428mapping_c_target(T428* C,T0* a1,T0* a2);
/*OPEN_OPERAND*/void r428standard_mapping_c_target(T428* C,T0* a1,T0* a2);
/*OPEN_OPERAND*/T0* r428non_void_no_dispatch_type(T0* a1);
/*OPEN_OPERAND*/void r428accept(T428* C,T0* a1);
/*OPEN_OPERAND*/T0* r428twin(T428* C);
/*OPEN_OPERAND*/void r428pretty(T428* C,T2 a1);
/*OPEN_OPERAND*/void r428compile_to_c_in(T428* C,T0* a1,T0* a2);
/*OPEN_OPERAND*/void r428bracketed_pretty(T428* C,T2 a1);
/*OPEN_OPERAND*/void r428pretty_target(T428* C,T2 a1);
/*OPEN_OPERAND*/T0* r428specialize_2(T428* C,T0* a1);
/*OPEN_OPERAND*/T0* r428simplify(T428* C,T0* a1);
/*OPEN_OPERAND*/T0* r428specialize_thru(T428* C,T0* a1,T0* a2,T0* a3);
/*OPEN_OPERAND*/void r428notify_as_open_argument(T428* C,T0* a1,T0* a2,T0* a3,T2 a4);
/*OPEN_OPERAND*/void r428under_agent_scope_notify(T428* C);
/*OPEN_OPERAND*/T6 r428is_open_target(T428* C);
/*OPEN_OPERAND*/void r428type_holder(T428* C,T296 a1,T0* a2);
/*OPEN_OPERAND*/T0* r428static_simplify(T428* C);
/*OPEN_OPERAND*/void r428question_mark(T428* C,T296 a1);
/*OPEN_OPERAND*/void r428compile_to_c_with_internal_c_local_saving(T428* C,T0* a1);
/*OPEN_OPERAND*/T0* r428specialize_in(T428* C,T0* a1);
/*OPEN_OPERAND*/void r428compile_to_c(T428* C,T0* a1);
/*ASSIGNMENT_TEST*/void r436mapping_c_target(T436* C,T0* a1,T0* a2);
/*ASSIGNMENT_TEST*/void r436pretty_target(T436* C,T2 a1);
/*ASSIGNMENT_TEST*/void r436copy(T436* C,T0* a1);
/*ASSIGNMENT_TEST*/T0* r436non_void_no_dispatch_type(T0* a1);
/*ASSIGNMENT_TEST*/T6 r436is_equal(T436* C,T0* a1);
/*ASSIGNMENT_TEST*/T0* r436specialize_2(T436* C,T0* a1);
/*ASSIGNMENT_TEST*/T0* r436static_simplify(T436* C);
/*ASSIGNMENT_TEST*/T0* r436simplify(T436* C,T0* a1);
/*ASSIGNMENT_TEST*/T0* r436collect(T436* C,T0* a1);
/*ASSIGNMENT_TEST*/T0* r436specialize_thru(T436* C,T0* a1,T0* a2,T0* a3);
/*ASSIGNMENT_TEST*/void r436compile_to_c_with_internal_c_local_saving(T436* C,T0* a1);
/*ASSIGNMENT_TEST*/T0* r436specialize_in(T436* C,T0* a1);
/*ASSIGNMENT_TEST*/void r436compile_to_c(T436* C,T0* a1);
/*ASSIGNMENT_TEST*/T6 r436use_current(T436* C,T0* a1);
/*ASSIGNMENT_TEST*/T6 r436side_effect_free(T436* C,T0* a1);
/*ASSIGNMENT_TEST*/void r436accept(T436* C,T0* a1);
extern T0*oBC436declaration_type;
extern int fBC436declaration_type;
/*ASSIGNMENT_TEST*/T0* r436declaration_type(void);
/*ASSIGNMENT_TEST*/T0* r436adapt_for(T436* C,T0* a1);
/*ASSIGNMENT_TEST*/T0* r436resolve_in(T0* a1);
/*ASSIGNMENT_TEST*/void r436make(T436* C,T0* a1,T0* a2,T0* a3);
/*ASSIGNMENT_TEST*/T0* r436written_declaration_type_mark(void);
/*ASSIGNMENT_TEST*/T0* r436twin(T436* C);
/*ASSIGNMENT_TEST*/void r436pretty(T436* C,T2 a1);
/*ASSIGNMENT_TEST*/T6 r436static_left_type_mark(T436* C,T0* a1);
extern T0*oBC28assignment_test_pool;
/*ASSIGNMENT_TEST*/T296 r436start_position(T436* C);
/*ASSIGNMENT_TEST*/void r436with_type_mark(T436* C,T0* a1,T0* a2);
/*ASSIGNMENT_TEST*/void r436with_writable(T436* C,T0* a1,T0* a2);
/*ASSIGNMENT_TEST*/void r436mapping_c_arg(T436* C,T0* a1);
/*ASSIGNMENT_TEST*/void r436bracketed_pretty(T436* C,T2 a1);
/*ASSIGNMENT_TEST*/void r436safety_check(T436* C,T0* a1);
/*ASSIGNMENT_TEST*/T6 r436is_default_value(void);
/*REAL_CONSTANT*/void r451mapping_c_target(T451* C,T0* a1,T0* a2);
/*REAL_CONSTANT*/void r451pretty_target(T451* C,T2 a1);
/*REAL_CONSTANT*/void r451copy(T451* C,T0* a1);
/*REAL_CONSTANT*/T0* r451non_void_no_dispatch_type(T451* C,T0* a1);
/*REAL_CONSTANT*/T6 r451is_equal(T451* C,T0* a1);
/*REAL_CONSTANT*/T0* r451specialize_2(T451* C,T0* a1);
/*REAL_CONSTANT*/T0* r451normalized_view(T451* C);
/*REAL_CONSTANT*/T0* r451static_simplify(T451* C);
/*REAL_CONSTANT*/T0* r451simplify(T451* C,T0* a1);
/*REAL_CONSTANT*/T0* r451collect(T451* C,T0* a1);
/*REAL_CONSTANT*/T0* r451specialize_thru(T451* C,T0* a1,T0* a2,T0* a3);
/*REAL_CONSTANT*/void r451compile_to_c_with_internal_c_local_saving(T451* C,T0* a1);
/*REAL_CONSTANT*/T0* r451specialize_in(T451* C,T0* a1);
/*REAL_CONSTANT*/void r451compile_to_c(T451* C,T0* a1);
/*REAL_CONSTANT*/T6 r451use_current(T0* a1);
/*REAL_CONSTANT*/T6 r451side_effect_free(T0* a1);
/*REAL_CONSTANT*/void r451accept(T451* C,T0* a1);
/*REAL_CONSTANT*/T0* r451declaration_type(T451* C);
/*REAL_CONSTANT*/T0* r451adapt_for(T451* C,T0* a1);
/*REAL_CONSTANT*/T0* r451resolve_in(T451* C,T0* a1);
/*REAL_CONSTANT*/void r451make(T451* C,T296 a1,T0* a2,T0* a3);
/*REAL_CONSTANT*/T0* r451written_declaration_type_mark(void);
/*REAL_CONSTANT*/T0* r451twin(T451* C);
/*REAL_CONSTANT*/void r451pretty(T451* C,T2 a1);
/*REAL_CONSTANT*/void r451mapping_c_arg(T451* C,T0* a1);
/*REAL_CONSTANT*/T6 r451extra_bracket_flag(T451* C);
/*REAL_CONSTANT*/void r451bracketed_pretty(T451* C,T2 a1);
/*REAL_CONSTANT*/T2 r451precedence(void);
/*REAL_CONSTANT*/T6 r451is_default_value(T451* C);
T334*create334integer_64(T296 a1);
T334*create334integer(T296 a1);
T334*create334integer_16(T296 a1);
T334*create334integer_8(T296 a1);
T334*create334integer_32(T296 a1);
/*INTEGER_TYPE_MARK*/void r334copy(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/T0* r334declaration_type(T334* C);
/*INTEGER_TYPE_MARK*/T6 r334can_be_assigned_to(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/void r334id_extra_information(T0* a1);
/*INTEGER_TYPE_MARK*/T0* r334class_text(T334* C);
/*INTEGER_TYPE_MARK*/T6 r334is_real(void);
/*INTEGER_TYPE_MARK*/T0* r334resolve_in(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/T6 r334is_character(void);
/*INTEGER_TYPE_MARK*/T6 r334is_kernel_expanded(void);
/*INTEGER_TYPE_MARK*/T0* r334at(T334* C,T296 a1);
/*INTEGER_TYPE_MARK*/T6 r334is_integer(void);
/*INTEGER_TYPE_MARK*/void r334c_type_for_target_in(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/void r334c_initialize_in(T0* a1);
/*INTEGER_TYPE_MARK*/void r334c_type_for_external_in(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/T0* r334written_mark(T334* C);
/*INTEGER_TYPE_MARK*/T0* r334twin(T334* C);
/*INTEGER_TYPE_MARK*/T6 r334is_string(void);
/*INTEGER_TYPE_MARK*/T6 r334is_tuple(void);
/*INTEGER_TYPE_MARK*/void r334pretty_in(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/T6 r334is_formal_generic(void);
/*INTEGER_TYPE_MARK*/T296 r334start_position(T334* C);
/*INTEGER_TYPE_MARK*/void r334gc_mark_in(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/T3 r334structure_mark(T334* C);
/*INTEGER_TYPE_MARK*/void r334c_type_for_va_arg_in(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/T6 r334same_signature_type(T334* C,T0* a1,T0* a2);
/*INTEGER_TYPE_MARK*/void r334integer_16(T334* C,T296 a1);
/*INTEGER_TYPE_MARK*/void r334integer_32(T334* C,T296 a1);
/*INTEGER_TYPE_MARK*/T6 r334is_anchored(void);
/*INTEGER_TYPE_MARK*/T6 r334is_boolean(void);
extern T0*oBC334integer_64_name;
extern int fBC334integer_64_name;
/*INTEGER_TYPE_MARK*/T0* r334integer_64_name(void);
/*INTEGER_TYPE_MARK*/void r334integer(T334* C,T296 a1);
/*INTEGER_TYPE_MARK*/void r334c_type_for_argument_in(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/void r334integer_64(T334* C,T296 a1);
/*INTEGER_TYPE_MARK*/void r334integer_8(T334* C,T296 a1);
extern T0*oBC334integer_name;
extern int fBC334integer_name;
/*INTEGER_TYPE_MARK*/T0* r334integer_name(void);
extern T0*oBC334integer_8_name;
extern int fBC334integer_8_name;
/*INTEGER_TYPE_MARK*/T0* r334integer_8_name(void);
extern T0*oBC334integer_32_name;
extern int fBC334integer_32_name;
/*INTEGER_TYPE_MARK*/T0* r334integer_32_name(void);
/*INTEGER_TYPE_MARK*/T0* r334written_name(T334* C);
/*INTEGER_TYPE_MARK*/T0* r334default_expression(T334* C,T296 a1);
extern T0*oBC334integer_16_name;
extern int fBC334integer_16_name;
/*INTEGER_TYPE_MARK*/T0* r334integer_16_name(void);
/*INTEGER_TYPE_MARK*/void r334c_frame_descriptor_in(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/T0* r334to_static(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/T0* r334specialize_thru(T334* C,T0* a1,T0* a2,T0* a3);
/*INTEGER_TYPE_MARK*/T0* r334signature_resolve_in(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/T6 r334is_like_current(void);
/*INTEGER_TYPE_MARK*/T6 r334is_agent(void);
/*INTEGER_TYPE_MARK*/void r334set_start_position(T334* C,T296 a1);
/*INTEGER_TYPE_MARK*/T0* r334generic_list(void);
/*INTEGER_TYPE_MARK*/T0* r334long_name(T334* C);
/*INTEGER_TYPE_MARK*/T2 r334id(T334* C);
/*INTEGER_TYPE_MARK*/T0* r334type(T334* C);
/*INTEGER_TYPE_MARK*/T0* r334typed_internals_type_mark(T334* C,T296 a1);
/*INTEGER_TYPE_MARK*/void r334c_type_for_result_in(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/T6 r334is_native_array(void);
/*INTEGER_TYPE_MARK*/T6 r334is_pointer(void);
/*INTEGER_TYPE_MARK*/T0* r334specialize_in(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/void r334gc_call_new_in(T334* C,T0* a1);
/*INTEGER_TYPE_MARK*/T0* r334_P_291_class_text(T334* C);
T469*create469with(T11 a1,T296 a2,T0* a3);
T469*create469make(T11 a1,T296 a2);
/*INTEGER_CONSTANT*/T6 r469use_current(T0* a1);
/*INTEGER_CONSTANT*/T6 r469side_effect_free(T0* a1);
/*INTEGER_CONSTANT*/void r469copy(T469* C,T0* a1);
/*INTEGER_CONSTANT*/T0* r469declaration_type(T469* C);
/*INTEGER_CONSTANT*/T0* r469adapt_for(T469* C,T0* a1);
/*INTEGER_CONSTANT*/T6 r469is_equal(T469* C,T0* a1);
/*INTEGER_CONSTANT*/T0* r469resolve_in(T469* C,T0* a1);
/*INTEGER_CONSTANT*/void r469set_value(T469* C,T11 a1);
/*INTEGER_CONSTANT*/T0* r469written_declaration_type_mark(void);
/*INTEGER_CONSTANT*/T0* r469collect(T469* C,T0* a1);
/*INTEGER_CONSTANT*/void r469mapping_c_arg(T469* C,T0* a1);
/*INTEGER_CONSTANT*/T2 r469precedence(void);
/*INTEGER_CONSTANT*/T6 r469is_default_value(T469* C);
/*INTEGER_CONSTANT*/void r469mapping_c_target(T469* C,T0* a1,T0* a2);
/*INTEGER_CONSTANT*/T0* r469non_void_no_dispatch_type(T469* C,T0* a1);
/*INTEGER_CONSTANT*/void r469accept(T469* C,T0* a1);
/*INTEGER_CONSTANT*/void r469special(T469* C,T296 a1,T0* a2,T0* a3,T11 a4);
/*INTEGER_CONSTANT*/T0* r469to_real_constant(T469* C);
/*INTEGER_CONSTANT*/void r469hexadecimal(T469* C,T296 a1,T0* a2,T1 a3,T6 a4,T11 a5);
/*INTEGER_CONSTANT*/void r469make(T469* C,T11 a1,T296 a2);
/*INTEGER_CONSTANT*/T0* r469twin(T469* C);
/*INTEGER_CONSTANT*/void r469pretty(T469* C,T2 a1);
/*INTEGER_CONSTANT*/T0* r469to_string(T469* C);
/*INTEGER_CONSTANT*/T6 r469extra_bracket_flag(T469* C);
/*INTEGER_CONSTANT*/void r469bracketed_pretty(T469* C,T2 a1);
/*INTEGER_CONSTANT*/void r469pretty_target(T469* C,T2 a1);
/*INTEGER_CONSTANT*/T0* r469result_type(T469* C);
/*INTEGER_CONSTANT*/T0* r469specialize_2(T469* C,T0* a1);
/*INTEGER_CONSTANT*/void r469append_in(T469* C,T0* a1);
/*INTEGER_CONSTANT*/T0* r469simplify(T469* C,T0* a1);
/*INTEGER_CONSTANT*/T0* r469specialize_thru(T469* C,T0* a1,T0* a2,T0* a3);
/*INTEGER_CONSTANT*/T0* r469static_simplify(T469* C);
/*INTEGER_CONSTANT*/void r469with(T469* C,T11 a1,T296 a2,T0* a3);
/*INTEGER_CONSTANT*/void r469compile_to_c_with_internal_c_local_saving(T469* C,T0* a1);
/*INTEGER_CONSTANT*/T0* r469specialize_in(T469* C,T0* a1);
/*INTEGER_CONSTANT*/void r469compile_to_c(T469* C,T0* a1);
/*INTEGER_CONSTANT*/void r469_P_440_pretty_target(T469* C,T2 a1);
/*MANIFEST_GENERIC*/T6 r411use_current(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T6 r411side_effect_free(T0* a1);
/*MANIFEST_GENERIC*/void r411copy(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T0* r411declaration_type(T411* C);
/*MANIFEST_GENERIC*/T0* r411adapt_for(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T6 r411is_equal(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T0* r411resolve_in(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T0* r411written_declaration_type_mark(void);
/*MANIFEST_GENERIC*/T0* r411collect(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T0* r411manifest_semicolon_check_name(void);
/*MANIFEST_GENERIC*/T0* r411specialize_2_check(T0* a1,T0* a2,T0* a3,T0* a4);
extern T0*oBC28manifest_generic_pool;
/*MANIFEST_GENERIC*/void r411mapping_c_arg(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T2 r411precedence(void);
/*MANIFEST_GENERIC*/T6 r411is_default_value(void);
/*MANIFEST_GENERIC*/void r411mapping_c_target(T411* C,T0* a1,T0* a2);
/*MANIFEST_GENERIC*/T0* r411non_void_no_dispatch_type(T411* C,T0* a1);
/*MANIFEST_GENERIC*/void r411accept(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T2 r411hash_code(T411* C);
extern T0*oBC28calloc_name;
extern int fBC28calloc_name;
/*MANIFEST_GENERIC*/T0* r411calloc_name(void);
/*MANIFEST_GENERIC*/void r411make(T411* C,T296 a1,T0* a2,T0* a3,T0* a4,T2 a5,T296 a6);
/*MANIFEST_GENERIC*/T0* r411twin(T411* C);
/*MANIFEST_GENERIC*/void r411pretty(T411* C,T2 a1);
/*MANIFEST_GENERIC*/T6 r411use_current_of(T0* a1,T0* a2);
/*MANIFEST_GENERIC*/void r411init(T411* C,T0* a1,T0* a2);
/*MANIFEST_GENERIC*/void r411specialize_2_from_old_manifest_array(T411* C,T0* a1);
/*MANIFEST_GENERIC*/void r411bracketed_pretty(T411* C,T2 a1);
/*MANIFEST_GENERIC*/T0* r411optional_arguments_specialize_2(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T0* r411simplify_of(T0* a1,T0* a2);
/*MANIFEST_GENERIC*/T0* r411specialize_in_of(T0* a1,T0* a2);
/*MANIFEST_GENERIC*/T0* r411specialize_thru_of(T0* a1,T0* a2,T0* a3,T0* a4);
/*MANIFEST_GENERIC*/void r411pretty_target(T411* C,T2 a1);
/*MANIFEST_GENERIC*/T0* r411item_list_specialize_2(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T0* r411adapt_of(T0* a1,T0* a2);
/*MANIFEST_GENERIC*/void r411safety_check_of(T0* a1,T0* a2);
/*MANIFEST_GENERIC*/void r411safety_check(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T0* r411manifest_put_name(void);
/*MANIFEST_GENERIC*/T0* r411specialize_2(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T0* r411simplify(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T0* r411specialize_thru(T411* C,T0* a1,T0* a2,T0* a3);
/*MANIFEST_GENERIC*/T0* r411static_simplify(T411* C);
extern T0*oBC28put_name;
extern int fBC28put_name;
/*MANIFEST_GENERIC*/T0* r411put_name(void);
/*MANIFEST_GENERIC*/void r411compile_to_c_with_internal_c_local_saving(T411* C,T0* a1);
/*MANIFEST_GENERIC*/T0* r411manifest_make_name(void);
/*MANIFEST_GENERIC*/T0* r411specialize_in(T411* C,T0* a1);
/*MANIFEST_GENERIC*/void r411compile_to_c(T411* C,T0* a1);
/*LOCAL_VAR_LIST*/void r355copy(T355* C,T0* a1);
/*LOCAL_VAR_LIST*/T2 r355count(T355* C);
/*LOCAL_VAR_LIST*/T0* r355type_mark(T355* C,T2 a1);
/*LOCAL_VAR_LIST*/T2 r355rank_of(T355* C,T0* a1);
/*LOCAL_VAR_LIST*/void r355name_clash_check(T355* C,T0* a1);
/*LOCAL_VAR_LIST*/void r355declaration_list_make(T355* C,T0* a1);
/*LOCAL_VAR_LIST*/void r355collect(T355* C,T0* a1);
/*LOCAL_VAR_LIST*/T0* r355specialize_thru(T355* C,T0* a1,T0* a2,T0* a3);
/*LOCAL_VAR_LIST*/void r355c_frame_descriptor(T355* C,T0* a1,T0* a2,T0* a3);
/*LOCAL_VAR_LIST*/void r355c_declare(T355* C,T0* a1,T6 a2);
/*LOCAL_VAR_LIST*/void r355initialize_expanded(T355* C,T0* a1);
/*LOCAL_VAR_LIST*/void r355add_last(T355* C,T0* a1);
/*LOCAL_VAR_LIST*/T0* r355specialize_in(T355* C,T0* a1);
/*LOCAL_VAR_LIST*/void r355accept(T355* C,T0* a1);
/*LOCAL_VAR_LIST*/T6 r355side_effect_free(T355* C,T0* a1);
/*LOCAL_VAR_LIST*/T0* r355adapt_for(T355* C,T0* a1);
/*LOCAL_VAR_LIST*/void r355make(T355* C,T0* a1);
/*LOCAL_VAR_LIST*/T0* r355twin(T355* C);
/*RESULT*/T6 r408use_current(T0* a1);
/*RESULT*/T6 r408side_effect_free(T0* a1);
/*RESULT*/void r408copy(T408* C,T0* a1);
/*RESULT*/T0* r408adapt_for(T408* C,T0* a1);
/*RESULT*/T6 r408is_equal(T408* C,T0* a1);
/*RESULT*/T0* r408resolve_in(T408* C,T0* a1);
/*RESULT*/T0* r408current_or_twin_init(T408* C,T0* a1);
/*RESULT*/T0* r408written_declaration_type_mark(T408* C);
/*RESULT*/T0* r408collect(T0* a1);
/*RESULT*/void r408mapping_c_arg(T408* C,T0* a1);
/*RESULT*/T0* r408feature_accumulator(void);
/*RESULT*/T2 r408precedence(void);
/*RESULT*/void r408vffd7_check(T408* C,T0* a1);
/*RESULT*/T6 r408is_default_value(void);
/*RESULT*/void r408mapping_c_target(T408* C,T0* a1,T0* a2);
/*RESULT*/void r408set_enclosing_function(T408* C,T0* a1);
/*RESULT*/void r408standard_mapping_c_target(T408* C,T0* a1,T0* a2);
/*RESULT*/T0* r408non_void_no_dispatch_type(T408* C,T0* a1);
/*RESULT*/void r408accept(T408* C,T0* a1);
/*RESULT*/void r408make(T408* C,T296 a1);
/*RESULT*/T0* r408twin(T408* C);
/*RESULT*/void r408pretty(T2 a1);
/*RESULT*/void r408bracketed_pretty(T2 a1);
/*RESULT*/void r408pretty_target(T2 a1);
/*RESULT*/T0* r408specialize_2(T408* C,T0* a1);
/*RESULT*/T0* r408simplify(T408* C,T0* a1);
/*RESULT*/T0* r408specialize_thru(T408* C,T0* a1,T0* a2,T0* a3);
/*RESULT*/T0* r408static_simplify(T408* C);
/*RESULT*/void r408compile_to_c_with_internal_c_local_saving(T408* C,T0* a1);
/*RESULT*/T0* r408specialize_in(T408* C,T0* a1);
/*RESULT*/void r408compile_to_c(T408* C,T0* a1);
/*ADDRESS_OF*/T6 r415use_current(T0* a1);
/*ADDRESS_OF*/T6 r415side_effect_free(T0* a1);
/*ADDRESS_OF*/void r415copy(T415* C,T0* a1);
extern T0*oBC415declaration_type;
extern int fBC415declaration_type;
/*ADDRESS_OF*/T0* r415declaration_type(void);
/*ADDRESS_OF*/T0* r415adapt_for(T415* C,T0* a1);
/*ADDRESS_OF*/T6 r415is_equal(T415* C,T0* a1);
/*ADDRESS_OF*/T0* r415resolve_in(T0* a1);
/*ADDRESS_OF*/T0* r415current_or_twin_init(T415* C,T0* a1,T0* a2,T0* a3);
/*ADDRESS_OF*/T0* r415written_declaration_type_mark(void);
/*ADDRESS_OF*/T0* r415collect(T415* C,T0* a1);
/*ADDRESS_OF*/void r415mapping_c_arg(T415* C,T0* a1);
/*ADDRESS_OF*/T2 r415precedence(void);
/*ADDRESS_OF*/T6 r415is_default_value(void);
/*ADDRESS_OF*/void r415mapping_c_target(T415* C,T0* a1,T0* a2);
/*ADDRESS_OF*/T0* r415non_void_no_dispatch_type(T0* a1);
extern T0*oBC28address_of_pool;
/*ADDRESS_OF*/void r415accept(T415* C,T0* a1);
/*ADDRESS_OF*/T0* r415twin(T415* C);
/*ADDRESS_OF*/void r415pretty(T415* C,T2 a1);
/*ADDRESS_OF*/T296 r415start_position(T415* C);
/*ADDRESS_OF*/void r415bracketed_pretty(T415* C,T2 a1);
/*ADDRESS_OF*/void r415with_local(T415* C,T0* a1);
/*ADDRESS_OF*/void r415with_feature_name(T415* C,T0* a1);
/*ADDRESS_OF*/T0* r415specialize_2(T415* C,T0* a1);
/*ADDRESS_OF*/T0* r415simplify(T415* C,T0* a1);
/*ADDRESS_OF*/T0* r415specialize_thru(T415* C,T0* a1,T0* a2,T0* a3);
/*ADDRESS_OF*/T0* r415static_simplify(T415* C);
/*ADDRESS_OF*/void r415compile_to_c_with_internal_c_local_saving(T415* C,T0* a1);
/*ADDRESS_OF*/T0* r415specialize_in(T415* C,T0* a1);
/*ADDRESS_OF*/void r415compile_to_c(T415* C,T0* a1);
/*PROC_CALL_N*/void r396procedure_and_argument_count_check(T396* C,T0* a1,T0* a2);
/*PROC_CALL_N*/T0* r396simplify_routine_body_first(T396* C,T0* a1,T0* a2);
/*PROC_CALL_N*/void r396set_creation_type(T396* C,T0* a1);
/*PROC_CALL_N*/void r396copy(T396* C,T0* a1);
/*PROC_CALL_N*/T0* r396simplify_arguments(T396* C,T0* a1);
/*PROC_CALL_N*/T0* r396inline_with(T396* C,T0* a1,T0* a2);
/*PROC_CALL_N*/void r396init(T396* C,T0* a1,T0* a2,T0* a3);
/*PROC_CALL_N*/T0* r396specialize_2(T396* C,T0* a1);
/*PROC_CALL_N*/T0* r396simplify(T396* C,T0* a1);
/*PROC_CALL_N*/void r396collect(T396* C,T0* a1);
/*PROC_CALL_N*/T2 r396arg_count(T396* C);
/*PROC_CALL_N*/void r396set_arguments(T396* C,T0* a1);
/*PROC_CALL_N*/T0* r396specialize_thru(T396* C,T0* a1,T0* a2,T0* a3);
/*PROC_CALL_N*/void r396collect_create(T396* C,T0* a1,T0* a2,T296 a3);
/*PROC_CALL_N*/void r396compile_to_c_with_internal_c_local_saving(T396* C,T0* a1);
/*PROC_CALL_N*/T0* r396specialize_in(T396* C,T0* a1);
/*PROC_CALL_N*/void r396compile_to_c(T396* C,T0* a1);
/*PROC_CALL_N*/T6 r396use_current(T396* C,T0* a1);
/*PROC_CALL_N*/T0* r396specialize_2_without_checks(T396* C,T0* a1);
/*PROC_CALL_N*/T6 r396side_effect_free(T396* C,T0* a1);
/*PROC_CALL_N*/void r396accept(T396* C,T0* a1);
/*PROC_CALL_N*/T0* r396adapt_for(T396* C,T0* a1);
/*PROC_CALL_N*/T0* r396inline_2(T396* C,T0* a1,T0* a2,T0* a3);
/*PROC_CALL_N*/T0* r396run_feature_for(T396* C,T0* a1);
/*PROC_CALL_N*/void r396make(T396* C,T0* a1,T0* a2,T0* a3);
/*PROC_CALL_N*/T0* r396twin(T396* C);
/*PROC_CALL_N*/void r396call_proc_call_c2c(T396* C,T0* a1);
/*PROC_CALL_N*/T0* r396use_current_stack(void);
/*PROC_CALL_N*/T296 r396start_position(T396* C);
/*PROC_CALL_N*/void r396set_target(T396* C,T0* a1);
/*PROC_CALL_N*/T0* r396call_support_collect(T396* C,T0* a1);
/*PROC_CALL_N*/void r396safety_check(T396* C,T0* a1);
/*PROC_CALL_N*/void r396standard_check_export_and_obsolete_calls(T396* C,T0* a1,T0* a2,T0* a3);
/*PROC_CALL_N*/void r396set_feature_stamp(T396* C,T0* a1);
/*PROC_CALL_0*/void r388procedure_and_argument_count_check(T388* C,T0* a1,T0* a2);
/*PROC_CALL_0*/T0* r388simplify_routine_body_first(T388* C,T0* a1,T0* a2);
/*PROC_CALL_0*/void r388set_creation_type(T388* C,T0* a1);
/*PROC_CALL_0*/void r388copy(T388* C,T0* a1);
/*PROC_CALL_0*/T0* r388simplify_arguments(T388* C,T0* a1);
/*PROC_CALL_0*/T0* r388inline_with(T388* C,T0* a1);
/*PROC_CALL_0*/T0* r388specialize_2(T388* C,T0* a1);
/*PROC_CALL_0*/T0* r388simplify(T388* C,T0* a1);
/*PROC_CALL_0*/void r388collect(T388* C,T0* a1);
/*PROC_CALL_0*/T0* r388specialize_thru(T388* C,T0* a1,T0* a2,T0* a3);
/*PROC_CALL_0*/void r388collect_create(T388* C,T0* a1,T0* a2,T296 a3);
/*PROC_CALL_0*/T0* r388arguments(void);
/*PROC_CALL_0*/void r388compile_to_c_with_internal_c_local_saving(T388* C,T0* a1);
/*PROC_CALL_0*/T0* r388specialize_in(T388* C,T0* a1);
/*PROC_CALL_0*/void r388compile_to_c(T388* C,T0* a1);
/*PROC_CALL_0*/T6 r388use_current(T388* C,T0* a1);
/*PROC_CALL_0*/T0* r388specialize_2_without_checks(T388* C,T0* a1);
/*PROC_CALL_0*/T6 r388side_effect_free(T388* C,T0* a1);
/*PROC_CALL_0*/void r388accept(T388* C,T0* a1);
/*PROC_CALL_0*/T0* r388adapt_for(T388* C,T0* a1);
/*PROC_CALL_0*/T0* r388run_feature_for(T388* C,T0* a1);
/*PROC_CALL_0*/void r388make(T388* C,T0* a1,T0* a2);
/*PROC_CALL_0*/T0* r388twin(T388* C);
/*PROC_CALL_0*/void r388call_proc_call_c2c(T388* C,T0* a1);
/*PROC_CALL_0*/T0* r388use_current_stack(void);
/*PROC_CALL_0*/T296 r388start_position(T388* C);
/*PROC_CALL_0*/void r388set_target(T388* C,T0* a1);
/*PROC_CALL_0*/T0* r388call_support_collect(T388* C,T0* a1);
/*PROC_CALL_0*/void r388safety_check(T388* C,T0* a1);
/*PROC_CALL_0*/void r388standard_check_export_and_obsolete_calls(T388* C,T0* a1,T0* a2,T0* a3);
/*PROC_CALL_0*/void r388set_feature_stamp(T388* C,T0* a1);
/*PROC_CALL_1*/void r391procedure_and_argument_count_check(T391* C,T0* a1,T0* a2);
/*PROC_CALL_1*/T0* r391simplify_routine_body_first(T391* C,T0* a1,T0* a2);
/*PROC_CALL_1*/void r391set_creation_type(T391* C,T0* a1);
/*PROC_CALL_1*/void r391copy(T391* C,T0* a1);
/*PROC_CALL_1*/T0* r391simplify_arguments(T391* C,T0* a1);
/*PROC_CALL_1*/T0* r391inline_with(T391* C,T0* a1,T0* a2);
/*PROC_CALL_1*/T0* r391arg1(T391* C);
/*PROC_CALL_1*/void r391init(T391* C,T0* a1,T0* a2,T0* a3);
/*PROC_CALL_1*/T0* r391specialize_2(T391* C,T0* a1);
/*PROC_CALL_1*/T0* r391simplify(T391* C,T0* a1);
/*PROC_CALL_1*/void r391collect(T391* C,T0* a1);
/*PROC_CALL_1*/void r391set_arguments(T391* C,T0* a1);
/*PROC_CALL_1*/T0* r391specialize_thru(T391* C,T0* a1,T0* a2,T0* a3);
/*PROC_CALL_1*/void r391collect_create(T391* C,T0* a1,T0* a2,T296 a3);
/*PROC_CALL_1*/void r391compile_to_c_with_internal_c_local_saving(T391* C,T0* a1);
/*PROC_CALL_1*/T0* r391specialize_in(T391* C,T0* a1);
/*PROC_CALL_1*/void r391compile_to_c(T391* C,T0* a1);
/*PROC_CALL_1*/T6 r391use_current(T391* C,T0* a1);
/*PROC_CALL_1*/T0* r391specialize_2_without_checks(T391* C,T0* a1);
/*PROC_CALL_1*/T6 r391side_effect_free(T391* C,T0* a1);
/*PROC_CALL_1*/void r391accept(T391* C,T0* a1);
/*PROC_CALL_1*/T0* r391adapt_for(T391* C,T0* a1);
/*PROC_CALL_1*/T0* r391run_feature_for(T391* C,T0* a1);
/*PROC_CALL_1*/void r391make(T391* C,T0* a1,T0* a2,T0* a3);
/*PROC_CALL_1*/T0* r391twin(T391* C);
/*PROC_CALL_1*/void r391call_proc_call_c2c(T391* C,T0* a1);
/*PROC_CALL_1*/T0* r391use_current_stack(void);
/*PROC_CALL_1*/T296 r391start_position(T391* C);
/*PROC_CALL_1*/void r391set_target(T391* C,T0* a1);
/*PROC_CALL_1*/T0* r391call_support_collect(T391* C,T0* a1);
/*PROC_CALL_1*/void r391safety_check(T391* C,T0* a1);
/*PROC_CALL_1*/void r391standard_check_export_and_obsolete_calls(T391* C,T0* a1,T0* a2,T0* a3);
/*PROC_CALL_1*/void r391set_feature_stamp(T391* C,T0* a1);
/*PROC_CALL_1*/T6 r391_P_390_use_current(T391* C,T0* a1);
/*CALL_N*/T6 r414use_current(T414* C,T0* a1);
/*CALL_N*/T6 r414side_effect_free(T414* C,T0* a1);
/*CALL_N*/void r414copy(T414* C,T0* a1);
/*CALL_N*/T0* r414declaration_type(T414* C);
/*CALL_N*/T0* r414adapt_for(T414* C,T0* a1);
/*CALL_N*/T6 r414is_equal(T414* C,T0* a1);
/*CALL_N*/T0* r414resolve_in(T414* C,T0* a1);
/*CALL_N*/T0* r414extra_local_expanded(T414* C,T0* a1);
/*CALL_N*/T0* r414written_declaration_type_mark(void);
/*CALL_N*/void r414function_and_argument_count_check(T414* C,T0* a1,T0* a2);
/*CALL_N*/T0* r414collect(T414* C,T0* a1);
/*CALL_N*/void r414mapping_c_arg(T414* C,T0* a1);
/*CALL_N*/T0* r414feature_accumulator(void);
/*CALL_N*/T2 r414precedence(void);
/*CALL_N*/T6 r414is_default_value(void);
/*CALL_N*/void r414mapping_c_target(T414* C,T0* a1,T0* a2);
/*CALL_N*/T0* r414non_void_no_dispatch_type(T414* C,T0* a1);
/*CALL_N*/void r414accept(T414* C,T0* a1);
/*CALL_N*/void r414call_proc_call_c2c(T414* C,T0* a1);
/*CALL_N*/T0* r414use_current_stack(void);
/*CALL_N*/void r414set_target(T414* C,T0* a1);
/*CALL_N*/T0* r414call_support_collect(T414* C,T0* a1);
/*CALL_N*/void r414make(T414* C,T0* a1,T0* a2,T0* a3);
/*CALL_N*/T0* r414twin(T414* C);
/*CALL_N*/void r414standard_check_export_and_obsolete_calls(T414* C,T0* a1,T0* a2,T0* a3);
/*CALL_N*/void r414set_feature_stamp(T414* C,T0* a1);
/*CALL_N*/void r414pretty(T414* C,T2 a1);
/*CALL_N*/T296 r414start_position(T414* C);
/*CALL_N*/void r414init(T414* C,T0* a1,T0* a2,T0* a3);
/*CALL_N*/void r414bracketed_pretty(T414* C,T2 a1);
/*CALL_N*/void r414pretty_target(T414* C,T2 a1);
/*CALL_N*/void r414safety_check(T414* C,T0* a1);
/*CALL_N*/T0* r414specialize_2(T414* C,T0* a1);
/*CALL_N*/T0* r414simplify(T414* C,T0* a1);
/*CALL_N*/T0* r414specialize_thru(T414* C,T0* a1,T0* a2,T0* a3);
/*CALL_N*/T0* r414static_simplify(T414* C);
/*CALL_N*/T2 r414arg_count(T414* C);
/*CALL_N*/void r414set_arguments(T414* C,T0* a1);
/*CALL_N*/T0* r414run_feature_for(T414* C,T0* a1);
/*CALL_N*/void r414compile_to_c_with_internal_c_local_saving(T414* C,T0* a1);
/*CALL_N*/T0* r414specialize_in(T414* C,T0* a1);
/*CALL_N*/void r414compile_to_c(T414* C,T0* a1);
/*CALL_0_C*/T6 r447use_current(T447* C,T0* a1);
/*CALL_0_C*/T6 r447side_effect_free(T447* C,T0* a1);
/*CALL_0_C*/void r447copy(T447* C,T0* a1);
/*CALL_0_C*/T0* r447manifest_expression(T447* C,T0* a1);
/*CALL_0_C*/T0* r447declaration_type(T447* C);
/*CALL_0_C*/T6 r447simplify_limit_reached(T447* C);
/*CALL_0_C*/T0* r447adapt_for(T447* C,T0* a1);
/*CALL_0_C*/T6 r447is_equal(T447* C,T0* a1);
/*CALL_0_C*/T0* r447resolve_in(T447* C,T0* a1);
/*CALL_0_C*/T0* r447current_or_twin_init(T447* C,T0* a1,T0* a2);
/*CALL_0_C*/T0* r447extra_local_expanded(T447* C,T0* a1);
/*CALL_0_C*/T0* r447written_declaration_type_mark(void);
/*CALL_0_C*/void r447function_and_argument_count_check(T447* C,T0* a1,T0* a2);
/*CALL_0_C*/T0* r447collect(T447* C,T0* a1);
/*CALL_0_C*/void r447mapping_c_arg(T447* C,T0* a1);
/*CALL_0_C*/T0* r447feature_accumulator(void);
/*CALL_0_C*/T2 r447precedence(void);
/*CALL_0_C*/T6 r447is_default_value(void);
/*CALL_0_C*/void r447mapping_c_target(T447* C,T0* a1,T0* a2);
/*CALL_0_C*/T0* r447non_void_no_dispatch_type(T447* C,T0* a1);
/*CALL_0_C*/void r447accept(T447* C,T0* a1);
/*CALL_0_C*/void r447call_proc_call_c2c(T447* C,T0* a1);
/*CALL_0_C*/T0* r447echo(void);
/*CALL_0_C*/T0* r447use_current_stack(void);
/*CALL_0_C*/void r447set_target(T447* C,T0* a1);
/*CALL_0_C*/T0* r447arguments(void);
/*CALL_0_C*/T0* r447call_support_collect(T447* C,T0* a1);
/*CALL_0_C*/void r447make(T447* C,T0* a1,T0* a2);
/*CALL_0_C*/T0* r447twin(T447* C);
/*CALL_0_C*/void r447standard_check_export_and_obsolete_calls(T447* C,T0* a1,T0* a2,T0* a3);
/*CALL_0_C*/void r447set_feature_stamp(T447* C,T0* a1);
/*CALL_0_C*/void r447pretty(T447* C,T2 a1);
/*CALL_0_C*/T296 r447start_position(T447* C);
/*CALL_0_C*/T0* r447inline_with(T447* C,T0* a1);
/*CALL_0_C*/void r447bracketed_pretty(T447* C,T2 a1);
/*CALL_0_C*/void r447pretty_target(T447* C,T2 a1);
/*CALL_0_C*/void r447safety_check(T447* C,T0* a1);
/*CALL_0_C*/T0* r447specialize_2(T447* C,T0* a1);
/*CALL_0_C*/T0* r447simplify(T447* C,T0* a1);
/*CALL_0_C*/T0* r447specialize_thru(T447* C,T0* a1,T0* a2,T0* a3);
/*CALL_0_C*/T0* r447static_simplify(T447* C);
/*CALL_0_C*/T0* r447run_feature_for(T447* C,T0* a1);
/*CALL_0_C*/void r447make_specialized(T447* C,T0* a1,T0* a2,T0* a3);
/*CALL_0_C*/void r447compile_to_c_with_internal_c_local_saving(T447* C,T0* a1);
/*CALL_0_C*/T0* r447specialize_in(T447* C,T0* a1);
/*CALL_0_C*/void r447compile_to_c(T447* C,T0* a1);
/*CALL_1_C*/T6 r461use_current(T461* C,T0* a1);
/*CALL_1_C*/T6 r461side_effect_free(T461* C,T0* a1);
/*CALL_1_C*/void r461copy(T461* C,T0* a1);
/*CALL_1_C*/T0* r461declaration_type(T461* C);
/*CALL_1_C*/T0* r461adapt_for(T461* C,T0* a1);
/*CALL_1_C*/T6 r461is_equal(T461* C,T0* a1);
/*CALL_1_C*/T0* r461resolve_in(T461* C,T0* a1);
/*CALL_1_C*/T0* r461current_or_twin_init(T461* C,T0* a1,T0* a2,T0* a3);
/*CALL_1_C*/T0* r461extra_local_expanded(T461* C,T0* a1);
/*CALL_1_C*/T0* r461written_declaration_type_mark(void);
/*CALL_1_C*/void r461function_and_argument_count_check(T461* C,T0* a1,T0* a2);
/*CALL_1_C*/T0* r461collect(T461* C,T0* a1);
/*CALL_1_C*/T6 r461is_balanced_operator(T0* a1);
/*CALL_1_C*/void r461mapping_c_arg(T461* C,T0* a1);
/*CALL_1_C*/T0* r461feature_accumulator(void);
/*CALL_1_C*/T2 r461precedence(void);
/*CALL_1_C*/T6 r461is_default_value(void);
/*CALL_1_C*/void r461mapping_c_target(T461* C,T0* a1,T0* a2);
/*CALL_1_C*/T0* r461non_void_no_dispatch_type(T461* C,T0* a1);
/*CALL_1_C*/void r461accept(T461* C,T0* a1);
/*CALL_1_C*/void r461call_proc_call_c2c(T461* C,T0* a1);
/*CALL_1_C*/T0* r461use_current_stack(void);
/*CALL_1_C*/void r461set_target(T461* C,T0* a1);
/*CALL_1_C*/T0* r461call_support_collect(T461* C,T0* a1);
/*CALL_1_C*/void r461make(T461* C,T0* a1,T0* a2,T0* a3);
/*CALL_1_C*/T0* r461twin(T461* C);
/*CALL_1_C*/void r461standard_check_export_and_obsolete_calls(T461* C,T0* a1,T0* a2,T0* a3);
/*CALL_1_C*/void r461set_feature_stamp(T461* C,T0* a1);
/*CALL_1_C*/void r461pretty(T461* C,T2 a1);
/*CALL_1_C*/T296 r461start_position(T461* C);
/*CALL_1_C*/void r461init(T461* C,T0* a1,T0* a2,T0* a3);
/*CALL_1_C*/T0* r461inline_with(T461* C,T0* a1,T0* a2);
/*CALL_1_C*/T0* r461arg1(T461* C);
/*CALL_1_C*/void r461bracketed_pretty(T461* C,T2 a1);
/*CALL_1_C*/void r461pretty_target(T461* C,T2 a1);
/*CALL_1_C*/void r461safety_check(T461* C,T0* a1);
/*CALL_1_C*/T0* r461specialize_2(T461* C,T0* a1);
/*CALL_1_C*/T0* r461simplify(T461* C,T0* a1);
/*CALL_1_C*/T0* r461specialize_thru(T461* C,T0* a1,T0* a2,T0* a3);
/*CALL_1_C*/T0* r461static_simplify(T461* C);
/*CALL_1_C*/void r461set_arguments(T461* C,T0* a1);
/*CALL_1_C*/T0* r461run_feature_for(T461* C,T0* a1);
/*CALL_1_C*/void r461make_specialized(T461* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*CALL_1_C*/void r461compile_to_c_with_internal_c_local_saving(T461* C,T0* a1);
/*CALL_1_C*/T0* r461specialize_in(T461* C,T0* a1);
/*CALL_1_C*/void r461compile_to_c(T461* C,T0* a1);
/*CALL_1_C*/T0* r461_P_407_declaration_type(T461* C);
T287*create287make_2(T0* a1,T0* a2);
T287*create287make_1(T0* a1);
/*EFFECTIVE_ARG_LIST*/void r287copy(T287* C,T0* a1);
/*EFFECTIVE_ARG_LIST*/T2 r287count(T287* C);
/*EFFECTIVE_ARG_LIST*/T0* r287specialize_2(T287* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*EFFECTIVE_ARG_LIST*/void r287static_simplify(T287* C);
/*EFFECTIVE_ARG_LIST*/T0* r287simplify(T287* C,T0* a1);
/*EFFECTIVE_ARG_LIST*/void r287collect(T287* C,T0* a1,T0* a2,T0* a3);
/*EFFECTIVE_ARG_LIST*/T0* r287specialize_thru(T287* C,T0* a1,T0* a2,T0* a3);
/*EFFECTIVE_ARG_LIST*/void r287make_1(T287* C,T0* a1);
/*EFFECTIVE_ARG_LIST*/void r287add_last(T287* C,T0* a1);
/*EFFECTIVE_ARG_LIST*/T0* r287specialize_in(T287* C,T0* a1);
/*EFFECTIVE_ARG_LIST*/T0* r287create_inline(T287* C);
/*EFFECTIVE_ARG_LIST*/void r287compile_to_c(T287* C,T0* a1,T0* a2);
/*EFFECTIVE_ARG_LIST*/void r287make_2(T287* C,T0* a1,T0* a2);
/*EFFECTIVE_ARG_LIST*/T6 r287use_current(T287* C,T0* a1);
/*EFFECTIVE_ARG_LIST*/void r287put(T287* C,T0* a1,T2 a2);
/*EFFECTIVE_ARG_LIST*/void r287accept(T287* C,T0* a1);
/*EFFECTIVE_ARG_LIST*/T6 r287side_effect_free(T287* C,T0* a1);
/*EFFECTIVE_ARG_LIST*/void r287compile_to_c_ith(T287* C,T0* a1,T0* a2,T2 a3);
extern T0*oBC287collecting_formal;
extern int fBC287collecting_formal;
/*EFFECTIVE_ARG_LIST*/T0* r287collecting_formal(void);
/*EFFECTIVE_ARG_LIST*/void r287make_n(T287* C,T0* a1,T0* a2);
/*EFFECTIVE_ARG_LIST*/T0* r287specialize_2_basic(T0* a1,T0* a2,T0* a3,T0* a4);
/*EFFECTIVE_ARG_LIST*/T0* r287adapt_for(T287* C,T0* a1);
extern T0*oBC287collecting_formal_sub_type;
extern int fBC287collecting_formal_sub_type;
/*EFFECTIVE_ARG_LIST*/T0* r287collecting_formal_sub_type(void);
/*EFFECTIVE_ARG_LIST*/void r287simple_collect(T287* C,T0* a1,T0* a2);
/*EFFECTIVE_ARG_LIST*/T0* r287expression(T287* C,T2 a1);
/*EFFECTIVE_ARG_LIST*/T0* r287to_fake_tuple(T287* C);
/*EFFECTIVE_ARG_LIST*/T0* r287specialize_2_on_expressions(T287* C,T0* a1);
/*EFFECTIVE_ARG_LIST*/void r287pretty(T287* C,T2 a1);
/*EFFECTIVE_ARG_LIST*/T0* r287twin(T287* C);
/*EFFECTIVE_ARG_LIST*/T296 r287start_position(T287* C);
/*EFFECTIVE_ARG_LIST*/void r287safety_check(T287* C,T0* a1);
/*EFFECTIVE_ARG_LIST*/T6 r287is_static(T287* C);
/*PRETTY_PRINTER*/void r227keyword(T0* a1);
/*PRETTY_PRINTER*/void r227left_margin_in(T0* a1);
extern T0*oBC227buffer;
extern int fBC227buffer;
/*PRETTY_PRINTER*/T0* r227buffer(void);
/*PRETTY_PRINTER*/T2 r227column(void);
/*PRETTY_PRINTER*/void r227put_character(T3 a1);
/*PRETTY_PRINTER*/void r227put_string(T0* a1);
/*PRETTY_PRINTER*/void r227make(T227* C);
/*PRETTY_PRINTER*/void r227expression_in(T0* a1,T0* a2);
/*PRETTY_PRINTER*/void r227set_indent_level(T2 a1);
/*PRETTY_PRINTER*/void r227put_type_mark(T0* a1);
/*PRETTY_PRINTER*/void r227put_one_line_comment(T2 a1,T0* a2);
/*CALL_PREFIX_MINUS*/T6 r454use_current(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T6 r454side_effect_free(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/void r454copy(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T0* r454manifest_expression(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T0* r454declaration_type(T454* C);
/*CALL_PREFIX_MINUS*/T6 r454simplify_limit_reached(T454* C);
/*CALL_PREFIX_MINUS*/T0* r454adapt_for(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T6 r454is_equal(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T0* r454resolve_in(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T0* r454current_or_twin_init(T454* C,T0* a1,T0* a2);
/*CALL_PREFIX_MINUS*/T0* r454extra_local_expanded(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T0* r454written_declaration_type_mark(void);
/*CALL_PREFIX_MINUS*/void r454function_and_argument_count_check(T454* C,T0* a1,T0* a2);
/*CALL_PREFIX_MINUS*/T0* r454collect(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/void r454mapping_c_arg(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T0* r454feature_accumulator(void);
/*CALL_PREFIX_MINUS*/T6 r454is_default_value(void);
/*CALL_PREFIX_MINUS*/void r454mapping_c_target(T454* C,T0* a1,T0* a2);
/*CALL_PREFIX_MINUS*/T0* r454non_void_no_dispatch_type(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/void r454accept(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/void r454call_proc_call_c2c(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T0* r454echo(void);
/*CALL_PREFIX_MINUS*/T0* r454use_current_stack(void);
/*CALL_PREFIX_MINUS*/void r454set_target(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T0* r454arguments(void);
/*CALL_PREFIX_MINUS*/T0* r454call_support_collect(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/void r454make(T454* C,T296 a1,T0* a2);
/*CALL_PREFIX_MINUS*/T0* r454twin(T454* C);
/*CALL_PREFIX_MINUS*/void r454standard_check_export_and_obsolete_calls(T454* C,T0* a1,T0* a2,T0* a3);
/*CALL_PREFIX_MINUS*/void r454set_feature_stamp(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/void r454pretty(T454* C,T2 a1);
/*CALL_PREFIX_MINUS*/T296 r454start_position(T454* C);
/*CALL_PREFIX_MINUS*/T0* r454inline_with(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/void r454bracketed_pretty(T454* C,T2 a1);
/*CALL_PREFIX_MINUS*/void r454pretty_target(T454* C,T2 a1);
/*CALL_PREFIX_MINUS*/void r454safety_check(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T0* r454specialize_2(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T0* r454simplify(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T0* r454specialize_thru(T454* C,T0* a1,T0* a2,T0* a3);
/*CALL_PREFIX_MINUS*/T0* r454static_simplify(T454* C);
/*CALL_PREFIX_MINUS*/T0* r454run_feature_for(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/void r454compile_to_c_with_internal_c_local_saving(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/T0* r454specialize_in(T454* C,T0* a1);
/*CALL_PREFIX_MINUS*/void r454compile_to_c(T454* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T6 r459use_current(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T6 r459side_effect_free(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/void r459copy(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T0* r459manifest_expression(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T0* r459declaration_type(T459* C);
/*CALL_PREFIX_FREEOP*/T6 r459simplify_limit_reached(T459* C);
/*CALL_PREFIX_FREEOP*/T0* r459adapt_for(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T6 r459is_equal(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T0* r459resolve_in(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T0* r459current_or_twin_init(T459* C,T0* a1,T0* a2);
/*CALL_PREFIX_FREEOP*/T0* r459extra_local_expanded(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T0* r459written_declaration_type_mark(void);
/*CALL_PREFIX_FREEOP*/void r459function_and_argument_count_check(T459* C,T0* a1,T0* a2);
/*CALL_PREFIX_FREEOP*/T0* r459collect(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/void r459mapping_c_arg(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T0* r459feature_accumulator(void);
/*CALL_PREFIX_FREEOP*/T6 r459is_default_value(void);
/*CALL_PREFIX_FREEOP*/void r459mapping_c_target(T459* C,T0* a1,T0* a2);
/*CALL_PREFIX_FREEOP*/T0* r459non_void_no_dispatch_type(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/void r459accept(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/void r459call_proc_call_c2c(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T0* r459echo(void);
/*CALL_PREFIX_FREEOP*/T0* r459use_current_stack(void);
/*CALL_PREFIX_FREEOP*/void r459set_target(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T0* r459arguments(void);
/*CALL_PREFIX_FREEOP*/T0* r459call_support_collect(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/void r459make(T459* C,T0* a1,T0* a2);
/*CALL_PREFIX_FREEOP*/T0* r459twin(T459* C);
/*CALL_PREFIX_FREEOP*/void r459standard_check_export_and_obsolete_calls(T459* C,T0* a1,T0* a2,T0* a3);
/*CALL_PREFIX_FREEOP*/void r459set_feature_stamp(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/void r459pretty(T459* C,T2 a1);
/*CALL_PREFIX_FREEOP*/T296 r459start_position(T459* C);
/*CALL_PREFIX_FREEOP*/T0* r459inline_with(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/void r459bracketed_pretty(T459* C,T2 a1);
/*CALL_PREFIX_FREEOP*/void r459pretty_target(T459* C,T2 a1);
/*CALL_PREFIX_FREEOP*/void r459safety_check(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T0* r459specialize_2(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T0* r459simplify(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T0* r459specialize_thru(T459* C,T0* a1,T0* a2,T0* a3);
/*CALL_PREFIX_FREEOP*/T0* r459static_simplify(T459* C);
/*CALL_PREFIX_FREEOP*/T0* r459run_feature_for(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/void r459compile_to_c_with_internal_c_local_saving(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/T0* r459specialize_in(T459* C,T0* a1);
/*CALL_PREFIX_FREEOP*/void r459compile_to_c(T459* C,T0* a1);
/*CALL_PREFIX_NOT*/T6 r460use_current(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T6 r460side_effect_free(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/void r460copy(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T0* r460manifest_expression(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T0* r460declaration_type(T460* C);
/*CALL_PREFIX_NOT*/T6 r460simplify_limit_reached(T460* C);
/*CALL_PREFIX_NOT*/T0* r460adapt_for(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T6 r460is_equal(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T0* r460resolve_in(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T0* r460current_or_twin_init(T460* C,T0* a1,T0* a2);
/*CALL_PREFIX_NOT*/T0* r460extra_local_expanded(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T0* r460written_declaration_type_mark(void);
/*CALL_PREFIX_NOT*/void r460function_and_argument_count_check(T460* C,T0* a1,T0* a2);
/*CALL_PREFIX_NOT*/T0* r460collect(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/void r460mapping_c_arg(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T0* r460feature_accumulator(void);
/*CALL_PREFIX_NOT*/T6 r460is_default_value(void);
/*CALL_PREFIX_NOT*/void r460mapping_c_target(T460* C,T0* a1,T0* a2);
/*CALL_PREFIX_NOT*/T0* r460non_void_no_dispatch_type(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/void r460accept(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/void r460call_proc_call_c2c(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T0* r460echo(void);
/*CALL_PREFIX_NOT*/T0* r460use_current_stack(void);
/*CALL_PREFIX_NOT*/void r460set_target(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T0* r460arguments(void);
/*CALL_PREFIX_NOT*/T0* r460call_support_collect(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/void r460make(T460* C,T296 a1,T0* a2);
/*CALL_PREFIX_NOT*/T0* r460twin(T460* C);
/*CALL_PREFIX_NOT*/void r460standard_check_export_and_obsolete_calls(T460* C,T0* a1,T0* a2,T0* a3);
/*CALL_PREFIX_NOT*/void r460set_feature_stamp(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/void r460pretty(T460* C,T2 a1);
/*CALL_PREFIX_NOT*/T296 r460start_position(T460* C);
/*CALL_PREFIX_NOT*/T0* r460inline_with(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/void r460bracketed_pretty(T460* C,T2 a1);
/*CALL_PREFIX_NOT*/void r460pretty_target(T460* C,T2 a1);
/*CALL_PREFIX_NOT*/void r460safety_check(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T0* r460specialize_2(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T0* r460simplify(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T0* r460specialize_thru(T460* C,T0* a1,T0* a2,T0* a3);
/*CALL_PREFIX_NOT*/T0* r460static_simplify(T460* C);
/*CALL_PREFIX_NOT*/T0* r460run_feature_for(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/void r460compile_to_c_with_internal_c_local_saving(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/T0* r460specialize_in(T460* C,T0* a1);
/*CALL_PREFIX_NOT*/void r460compile_to_c(T460* C,T0* a1);
T77*create77simple_feature_name(T0* a1,T296 a2);
/*FEATURE_NAME*/void r77copy(T77* C,T0* a1);
/*FEATURE_NAME*/void r77infix_name(T77* C,T0* a1,T296 a2);
/*FEATURE_NAME*/T6 r77is_prefix_name(T77* C);
/*FEATURE_NAME*/void r77set_is_frozen(T77* C);
/*FEATURE_NAME*/void r77prefix_name(T77* C,T0* a1,T296 a2);
/*FEATURE_NAME*/void r77complete_name_in(T77* C,T0* a1);
/*FEATURE_NAME*/T6 r77is_equal(T77* C,T0* a1);
/*FEATURE_NAME*/T0* r77infix_or_prefix(T77* C);
/*FEATURE_NAME*/void r77unknown_position(T77* C,T0* a1);
/*FEATURE_NAME*/void r77basic_create_1(T77* C,T2 a1,T0* a2,T296 a3);
/*FEATURE_NAME*/void r77basic_create_0(T77* C,T2 a1,T0* a2,T296 a3);
/*FEATURE_NAME*/void r77declaration_in(T77* C,T0* a1);
/*FEATURE_NAME*/void r77mapping_c_in(T77* C,T0* a1);
/*FEATURE_NAME*/void r77simple_feature_name(T77* C,T0* a1,T296 a2);
/*FEATURE_NAME*/T6 r77is_infix_name(T77* C);
/*FEATURE_NAME*/T2 r77hash_code(T77* C);
/*FEATURE_NAME*/T6 r77is_simple_feature_name(T77* C);
/*FEATURE_NAME*/void r77pretty(T77* C,T2 a1);
/*FEATURE_NAME*/T0* r77twin(T77* C);
/*FEATURE_NAME*/T6 r77is_frozen(T77* C);
/*FEATURE_NAME*/void r77ordinary_name(T77* C,T0* a1,T296 a2);
/*EXPRESSION_WITH_COMMENT*/void r433mapping_c_target(T433* C,T0* a1,T0* a2);
/*EXPRESSION_WITH_COMMENT*/void r433pretty_target(T433* C,T2 a1);
/*EXPRESSION_WITH_COMMENT*/void r433copy(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T0* r433non_void_no_dispatch_type(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T6 r433is_equal(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T6 r433is_implicit_current(T433* C);
/*EXPRESSION_WITH_COMMENT*/T6 r433is_current(T433* C);
/*EXPRESSION_WITH_COMMENT*/T0* r433specialize_2(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T0* r433static_simplify(T433* C);
/*EXPRESSION_WITH_COMMENT*/T0* r433simplify(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T0* r433collect(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T0* r433current_or_twin_init(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T0* r433specialize_thru(T433* C,T0* a1,T0* a2,T0* a3);
/*EXPRESSION_WITH_COMMENT*/void r433compile_to_c_with_internal_c_local_saving(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T0* r433specialize_in(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/void r433compile_to_c(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T6 r433use_current(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T6 r433side_effect_free(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/void r433accept(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T0* r433declaration_type(T433* C);
/*EXPRESSION_WITH_COMMENT*/T0* r433adapt_for(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T0* r433resolve_in(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T6 r433is_manifest_string(T433* C);
/*EXPRESSION_WITH_COMMENT*/void r433make(T433* C,T0* a1,T0* a2);
/*EXPRESSION_WITH_COMMENT*/T0* r433written_declaration_type_mark(void);
/*EXPRESSION_WITH_COMMENT*/T0* r433twin(T433* C);
/*EXPRESSION_WITH_COMMENT*/void r433pretty(T433* C,T2 a1);
/*EXPRESSION_WITH_COMMENT*/T6 r433is_void(T433* C);
/*EXPRESSION_WITH_COMMENT*/T296 r433start_position(T433* C);
/*EXPRESSION_WITH_COMMENT*/T6 r433is_result(T433* C);
/*EXPRESSION_WITH_COMMENT*/void r433mapping_c_arg(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T6 r433extra_bracket_flag(T433* C);
/*EXPRESSION_WITH_COMMENT*/void r433bracketed_pretty(T433* C,T2 a1);
/*EXPRESSION_WITH_COMMENT*/void r433safety_check(T433* C,T0* a1);
/*EXPRESSION_WITH_COMMENT*/T2 r433precedence(T433* C);
/*EXPRESSION_WITH_COMMENT*/T6 r433is_default_value(void);
/*EXPRESSION_WITH_COMMENT*/T6 r433is_static(T433* C);
/*OLD_MANIFEST_ARRAY*/void r465pretty_target(T465* C,T2 a1);
/*OLD_MANIFEST_ARRAY*/void r465copy(T465* C,T0* a1);
/*OLD_MANIFEST_ARRAY*/T0* r465non_void_no_dispatch_type(T0* a1);
/*OLD_MANIFEST_ARRAY*/T6 r465is_equal(T465* C,T0* a1);
/*OLD_MANIFEST_ARRAY*/T0* r465specialize_2(T465* C,T0* a1);
/*OLD_MANIFEST_ARRAY*/T0* r465static_simplify(T465* C);
/*OLD_MANIFEST_ARRAY*/T0* r465simplify(T0* a1);
/*OLD_MANIFEST_ARRAY*/T0* r465collect(T0* a1);
/*OLD_MANIFEST_ARRAY*/T0* r465smallest_ancestor_from_type_set_buffer(void);
/*OLD_MANIFEST_ARRAY*/T0* r465specialize_thru(T465* C,T0* a1,T0* a2,T0* a3);
extern T0*oBC465type_set_buffer;
extern int fBC465type_set_buffer;
/*OLD_MANIFEST_ARRAY*/T0* r465type_set_buffer(void);
/*OLD_MANIFEST_ARRAY*/void r465compile_to_c_with_internal_c_local_saving(T0* a1);
/*OLD_MANIFEST_ARRAY*/T0* r465specialize_in(T465* C,T0* a1);
/*OLD_MANIFEST_ARRAY*/T6 r465use_current(T0* a1);
/*OLD_MANIFEST_ARRAY*/T6 r465side_effect_free(T0* a1);
/*OLD_MANIFEST_ARRAY*/void r465accept(T465* C,T0* a1);
/*OLD_MANIFEST_ARRAY*/T0* r465declaration_type(void);
/*OLD_MANIFEST_ARRAY*/T0* r465adapt_for(T0* a1);
/*OLD_MANIFEST_ARRAY*/T0* r465resolve_in(T0* a1);
/*OLD_MANIFEST_ARRAY*/void r465make(T465* C,T296 a1,T0* a2);
/*OLD_MANIFEST_ARRAY*/T0* r465written_declaration_type_mark(void);
/*OLD_MANIFEST_ARRAY*/T0* r465twin(T465* C);
/*OLD_MANIFEST_ARRAY*/void r465pretty(T465* C,T2 a1);
/*OLD_MANIFEST_ARRAY*/void r465bracketed_pretty(T465* C,T2 a1);
/*OLD_MANIFEST_ARRAY*/T6 r465is_default_value(void);
/*ASSERTION*/void r520copy(T520* C,T0* a1);
/*ASSERTION*/T0* r520specialize_2(T520* C,T0* a1);
/*ASSERTION*/void r520collect(T520* C,T0* a1);
/*ASSERTION*/T6 r520is_always_true(T520* C);
/*ASSERTION*/T0* r520current_or_twin_init(T520* C,T0* a1);
/*ASSERTION*/T0* r520specialize_thru(T520* C,T0* a1,T0* a2,T0* a3);
/*ASSERTION*/void r520specialize_2_check(T520* C,T0* a1);
/*ASSERTION*/T0* r520specialize_in(T520* C,T0* a1);
/*ASSERTION*/void r520compile_to_c(T520* C,T0* a1);
/*ASSERTION*/T6 r520use_current(T520* C,T0* a1);
/*ASSERTION*/T6 r520side_effect_free(T520* C,T0* a1);
/*ASSERTION*/T0* r520adapt_for(T520* C,T0* a1);
/*ASSERTION*/void r520make(T520* C,T0* a1,T0* a2,T0* a3);
/*ASSERTION*/T0* r520twin(T520* C);
/*ASSERTION*/T296 r520start_position(T520* C);
/*ASSERTION*/void r520safety_check(T520* C,T0* a1);
/*INI_PARSER*/void r68fatal_error_except_for_install(T68* C,T0* a1);
/*INI_PARSER*/void r68may_expand_var_into(T68* C,T0* a1);
/*INI_PARSER*/void r68plugin(T68* C);
/*INI_PARSER*/T0* r68sections_iterator(T68* C);
/*INI_PARSER*/T0* r68section_item(T68* C,T0* a1,T0* a2);
/*INI_PARSER*/T6 r68a_key(T68* C);
/*INI_PARSER*/T0* r68section_key_iterator(T68* C,T0* a1);
/*INI_PARSER*/void r68set_value(T68* C,T0* a1);
/*INI_PARSER*/T0* r68key_iterator(T68* C);
/*INI_PARSER*/T0* r68last_value(T68* C);
/*INI_PARSER*/T6 r68skip_spaces(T68* C);
/*INI_PARSER*/T0* r68parser_buffer(void);
/*INI_PARSER*/T0* r68echo(void);
/*INI_PARSER*/T6 r68has(T68* C,T0* a1);
extern T0*oBC69lcs;
extern int fBC69lcs;
/*INI_PARSER*/T0* r68lcs(void);
extern T0*oBC69unicode_string_buffer;
extern int fBC69unicode_string_buffer;
/*INI_PARSER*/T0* r68unicode_string_buffer(void);
/*INI_PARSER*/void r68go_back_at(T68* C,T2 a1,T2 a2);
/*INI_PARSER*/T6 r68skip1(T68* C,T3 a1);
/*INI_PARSER*/T296 r68current_position(T68* C);
/*INI_PARSER*/T6 r68a_keyword(T68* C,T0* a1);
/*INI_PARSER*/T6 r68a_manifest_string(T68* C,T6 a1);
/*INI_PARSER*/void r68skip_comments(T68* C);
/*INI_PARSER*/void r68next_char(T68* C);
/*INI_PARSER*/void r68update_last_manifest_string(T68* C,T296 a1,T6 a2,T6 a3,T0* a4,T0* a5);
/*INI_PARSER*/void r68may_expand_var(T68* C);
/*INI_PARSER*/T296 r68pos(T68* C,T2 a1,T2 a2);
extern T0*oBC69buffer;
extern int fBC69buffer;
/*INI_PARSER*/T0* r68buffer(void);
/*INI_PARSER*/void r68goto_next_line(T68* C);
/*INI_PARSER*/T6 r68section_has(T68* C,T0* a1,T0* a2);
/*INI_PARSER*/void r68serc(T68* C);
/*INI_PARSER*/T6 r68a_section(T68* C);
/*INI_PARSER*/void r68a_keys(T68* C);
/*INI_PARSER*/void r68a_sections(T68* C);
/*INI_PARSER*/T6 r68a_string(T68* C);
/*INI_PARSER*/T6 r68a_identifier(T68* C);
/*INI_PARSER*/T0* r68strings(void);
/*INI_PARSER*/void r68a_inifile(T68* C);
/*HASH_TABLE_SIZE*/T2 r573prime_number_ceiling(T2 a1);
/*CECIL_FILE*/T0* r282cecil_pool(void);
/*CECIL_FILE*/void r282collect(T282* C);
/*CECIL_FILE*/void r282c_define_users(T282* C);
/*CECIL_FILE*/void r282parse(T282* C);
/*CECIL_FILE*/void r282make(T282* C,T0* a1);
/*CECIL_FILE*/T0* r282echo(void);
/*UNICODE_STRING*/void r261utf8_encode_in(T261* C,T0* a1);
/*UNICODE_STRING*/void r261clear_count(T261* C);
/*UNICODE_STRING*/T2 r261item(T261* C,T2 a1);
/*UNICODE_STRING*/void r261extend(T261* C,T2 a1);
/*UNICODE_STRING*/void r261add_last(T261* C,T2 a1);
/*UNICODE_STRING*/void r261make(T261* C,T2 a1);
/*UNICODE_STRING*/void r261make_empty(T261* C);
/*UNICODE_STRING*/T6 r261valid_unicode(T2 a1);
/*UNICODE_STRING*/T10 r261low_surrogate_value(T261* C,T2 a1);
/*COMMENT*/T0* r309simplify_routine_body_first(T309* C,T0* a1,T0* a2);
/*COMMENT*/T2 r309count(T309* C);
/*COMMENT*/void r309good_end_warning_check(T309* C,T0* a1);
/*COMMENT*/T0* r309specialize_2(T309* C,T0* a1);
/*COMMENT*/T0* r309simplify(T0* a1);
/*COMMENT*/T0* r309specialize_thru(T309* C,T0* a1,T0* a2,T0* a3);
/*COMMENT*/void r309add_last(T309* C,T0* a1);
/*COMMENT*/void r309compile_to_c_with_internal_c_local_saving(T0* a1);
/*COMMENT*/T0* r309specialize_in(T309* C,T0* a1);
/*COMMENT*/T6 r309use_current(T0* a1);
/*COMMENT*/T0* r309specialize_2_without_checks(T309* C,T0* a1);
/*COMMENT*/T6 r309side_effect_free(T0* a1);
/*COMMENT*/void r309accept(T309* C,T0* a1);
/*COMMENT*/T0* r309adapt_for(T309* C,T0* a1);
/*COMMENT*/void r309append(T309* C,T0* a1);
/*COMMENT*/void r309make(T309* C,T296 a1,T0* a2);
/*COMMENT*/void r309pretty(T309* C,T2 a1);
/*TOKEN_BUFFER*/void r598extend(T3 a1);
/*TOKEN_BUFFER*/T0* r598to_argument_name1(T598* C);
/*TOKEN_BUFFER*/T0* r598to_argument_name2(T598* C,T0* a1,T2 a2);
/*TOKEN_BUFFER*/T0* r598to_manifest_string(T598* C);
/*TOKEN_BUFFER*/T6 r598isa_keyword(void);
/*TOKEN_BUFFER*/T0* r598to_local_name2(T598* C,T0* a1,T2 a2);
/*TOKEN_BUFFER*/T0* r598to_local_name1(T598* C);
/*TOKEN_BUFFER*/T0* r598to_class_name(T598* C);
/*TOKEN_BUFFER*/T0* r598to_tag_name(T598* C);
/*TOKEN_BUFFER*/void r598reset(T598* C,T2 a1,T2 a2);
/*TOKEN_BUFFER*/T0* r598to_writable_attribute_name(T598* C);
/*TOKEN_BUFFER*/T0* r598to_feature_name(T598* C);
/*TOKEN_BUFFER*/T296 r598start_position(T598* C);
/*TOKEN_BUFFER*/T0* r598hashed_string(T598* C);
/*CLASSES_TREE_FACTORY*/T0* r353classes(T353* C,T2 a1,T0* a2,T0* a3,T0* a4,T0* a5);
extern T0*oBC353classes_memory;
extern int fBC353classes_memory;
/*CLASSES_TREE_FACTORY*/T0* r353classes_memory(void);
extern T0*oBC353universe;
extern int fBC353universe;
/*CLASSES_TREE_FACTORY*/T0* r353universe(void);
/*PARSER_BUFFER*/T0* r225empty_line_at(T225* C,T2 a1);
/*PARSER_BUFFER*/void r225load_file(T225* C,T0* a1);
/*PARSER_BUFFER*/void r225release(T225* C);
/*PARSER_BUFFER*/void r225make(T225* C);
extern T0*oBC28tmp_file_read;
/*DIRECTORY*/void r276re_scan(T276* C);
/*DIRECTORY*/void r276init(T276* C,T2 a1);
/*DIRECTORY*/void r276make(T276* C);
/*DIRECTORY*/void r276scan_with(T276* C,T0* a1);
/*DIRECTORY*/void r276scan(T276* C,T0* a1);
/*UNIVERSE*/void r352set_parent(T352* C,T0* a1);
/*UNIVERSE*/void r352clusters_of(T352* C,T0* a1,T6 a2,T0* a3,T0* a4,T0* a5,T2 a6);
/*UNIVERSE*/T0* r352system_notation(T352* C);
/*UNIVERSE*/T0* r352find_physical_cluster(T352* C,T0* a1);
/*UNIVERSE*/T2 r352cluster_count(T352* C);
/*UNIVERSE*/void r352show_tabs(T2 a1);
/*UNIVERSE*/void r352add_classes(T352* C,T0* a1);
/*UNIVERSE*/T6 r352has_physical_cluster(T352* C,T0* a1);
/*UNIVERSE*/void r352add_entry(T352* C,T2 a1,T0* a2,T0* a3,T0* a4);
/*UNIVERSE*/void r352generic_formal_arguments_check(T352* C);
/*UNIVERSE*/void r352show(T352* C,T2 a1);
/*UNIVERSE*/T0* r352cluster_named(T352* C,T0* a1);
/*UNIVERSE*/void r352for_all(T352* C,T0* a1);
/*UNIVERSE*/void r352view_in(T352* C,T0* a1);
/*UNIVERSE*/void r352get_started(T352* C,T2 a1);
/*UNIVERSE*/void r352parse_include(T352* C);
/*UNIVERSE*/T2 r352loaded_class_count(T352* C);
/*UNIVERSE*/void r352make(T352* C);
/*UNIVERSE*/T0* r352echo(void);
/*UNIVERSE*/T6 r352is_system_path(T352* C,T0* a1);
/*UNIVERSE*/T0* r352system_path_to_classes_path(T352* C,T0* a1);
/*SE_C_MODE*/void r514make(T514* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8,T0* a9,T0* a10,T0* a11,T0* a12,T0* a13);
T511*create511(void);
/*WINDOWS_DIRECTORY_NOTATION*/void r511to_current_directory(T0* a1);
/*WINDOWS_DIRECTORY_NOTATION*/T6 r511can_sanitize(T0* a1);
/*WINDOWS_DIRECTORY_NOTATION*/void r511not_yet_implemented(T511* C);
/*WINDOWS_DIRECTORY_NOTATION*/void r511crash(T511* C);
/*WINDOWS_DIRECTORY_NOTATION*/void r511to_file_path_with(T0* a1,T0* a2);
/*WINDOWS_DIRECTORY_NOTATION*/void r511to_subpath_with(T0* a1,T0* a2);
/*WINDOWS_DIRECTORY_NOTATION*/void r511to_parent_directory(T0* a1);
/*WINDOWS_DIRECTORY_NOTATION*/void r511from_notation(T511* C,T0* a1,T0* a2);
/*WINDOWS_DIRECTORY_NOTATION*/T6 r511is_valid_path(T0* a1);
/*WINDOWS_DIRECTORY_NOTATION*/T0* r511to_notation(T511* C,T0* a1,T0* a2);
/*WINDOWS_DIRECTORY_NOTATION*/void r511to_directory_path(T0* a1);
/*WINDOWS_DIRECTORY_NOTATION*/void r511to_default_root(T0* a1);
/*WINDOWS_DIRECTORY_NOTATION*/T6 r511can_map_drive(T0* a1,T0* a2);
/*WINDOWS_DIRECTORY_NOTATION*/void r511to_absolute_path_in(T0* a1,T0* a2);
/*WINDOWS_DIRECTORY_NOTATION*/T6 r511is_absolute_path(T0* a1);
/*WINDOWS_DIRECTORY_NOTATION*/void r511to_subdirectory_with(T0* a1,T0* a2);
/*WINDOWS_DIRECTORY_NOTATION*/void r511to_root(T0* a1,T0* a2);
/*WINDOWS_DIRECTORY_NOTATION*/T6 r511is_valid_file_name(T0* a1);
T510*create510(void);
/*MACINTOSH_DIRECTORY_NOTATION*/void r510to_current_directory(T510* C,T0* a1);
/*MACINTOSH_DIRECTORY_NOTATION*/T6 r510can_sanitize(T0* a1);
/*MACINTOSH_DIRECTORY_NOTATION*/void r510not_yet_implemented(T510* C);
/*MACINTOSH_DIRECTORY_NOTATION*/void r510crash(T510* C);
/*MACINTOSH_DIRECTORY_NOTATION*/void r510to_file_path_with(T0* a1,T0* a2);
/*MACINTOSH_DIRECTORY_NOTATION*/void r510to_subpath_with(T0* a1,T0* a2);
/*MACINTOSH_DIRECTORY_NOTATION*/void r510to_parent_directory(T0* a1);
/*MACINTOSH_DIRECTORY_NOTATION*/void r510from_notation(T510* C,T0* a1,T0* a2);
/*MACINTOSH_DIRECTORY_NOTATION*/T6 r510is_valid_path(T0* a1);
/*MACINTOSH_DIRECTORY_NOTATION*/T0* r510to_notation(T510* C,T0* a1,T0* a2);
/*MACINTOSH_DIRECTORY_NOTATION*/void r510to_directory_path(T0* a1);
/*MACINTOSH_DIRECTORY_NOTATION*/void r510to_default_root(T510* C,T0* a1);
/*MACINTOSH_DIRECTORY_NOTATION*/T6 r510can_map_drive(T0* a1,T0* a2);
/*MACINTOSH_DIRECTORY_NOTATION*/void r510to_absolute_path_in(T510* C,T0* a1,T0* a2);
/*MACINTOSH_DIRECTORY_NOTATION*/T6 r510is_absolute_path(T510* C,T0* a1);
/*MACINTOSH_DIRECTORY_NOTATION*/void r510to_subdirectory_with(T0* a1,T0* a2);
/*MACINTOSH_DIRECTORY_NOTATION*/T6 r510is_valid_file_name(T0* a1);
T509*create509(void);
/*AMIGA_DIRECTORY_NOTATION*/void r509to_current_directory(T509* C,T0* a1);
/*AMIGA_DIRECTORY_NOTATION*/T6 r509can_sanitize(T0* a1);
/*AMIGA_DIRECTORY_NOTATION*/void r509not_yet_implemented(T509* C);
/*AMIGA_DIRECTORY_NOTATION*/void r509crash(T509* C);
/*AMIGA_DIRECTORY_NOTATION*/void r509to_file_path_with(T0* a1,T0* a2);
/*AMIGA_DIRECTORY_NOTATION*/void r509to_subpath_with(T0* a1,T0* a2);
/*AMIGA_DIRECTORY_NOTATION*/void r509to_parent_directory(T0* a1);
/*AMIGA_DIRECTORY_NOTATION*/void r509from_notation(T509* C,T0* a1,T0* a2);
/*AMIGA_DIRECTORY_NOTATION*/T6 r509is_valid_path(T0* a1);
/*AMIGA_DIRECTORY_NOTATION*/T0* r509to_notation(T509* C,T0* a1,T0* a2);
/*AMIGA_DIRECTORY_NOTATION*/void r509to_directory_path(T0* a1);
/*AMIGA_DIRECTORY_NOTATION*/void r509to_default_root(T509* C,T0* a1);
/*AMIGA_DIRECTORY_NOTATION*/T6 r509can_map_drive(T0* a1,T0* a2);
/*AMIGA_DIRECTORY_NOTATION*/void r509to_absolute_path_in(T509* C,T0* a1,T0* a2);
/*AMIGA_DIRECTORY_NOTATION*/T6 r509is_absolute_path(T509* C,T0* a1);
/*AMIGA_DIRECTORY_NOTATION*/void r509to_subdirectory_with(T0* a1,T0* a2);
/*AMIGA_DIRECTORY_NOTATION*/T6 r509is_valid_file_name(T0* a1);
T508*create508(void);
/*OPENVMS_DIRECTORY_NOTATION*/void r508to_current_directory(T508* C,T0* a1);
/*OPENVMS_DIRECTORY_NOTATION*/T6 r508can_sanitize(T0* a1);
/*OPENVMS_DIRECTORY_NOTATION*/void r508not_yet_implemented(T508* C);
/*OPENVMS_DIRECTORY_NOTATION*/void r508crash(T508* C);
/*OPENVMS_DIRECTORY_NOTATION*/void r508to_file_path_with(T0* a1,T0* a2);
/*OPENVMS_DIRECTORY_NOTATION*/void r508to_subpath_with(T508* C,T0* a1,T0* a2);
/*OPENVMS_DIRECTORY_NOTATION*/void r508to_parent_directory(T0* a1);
/*OPENVMS_DIRECTORY_NOTATION*/void r508from_notation(T508* C,T0* a1,T0* a2);
/*OPENVMS_DIRECTORY_NOTATION*/T6 r508is_valid_path(T0* a1);
/*OPENVMS_DIRECTORY_NOTATION*/T0* r508to_notation(T508* C,T0* a1,T0* a2);
/*OPENVMS_DIRECTORY_NOTATION*/void r508to_directory_path(T508* C,T0* a1);
/*OPENVMS_DIRECTORY_NOTATION*/void r508to_default_root(T508* C,T0* a1);
/*OPENVMS_DIRECTORY_NOTATION*/T6 r508can_map_drive(T0* a1,T0* a2);
/*OPENVMS_DIRECTORY_NOTATION*/void r508to_absolute_path_in(T508* C,T0* a1,T0* a2);
/*OPENVMS_DIRECTORY_NOTATION*/T6 r508is_absolute_path(T508* C,T0* a1);
/*OPENVMS_DIRECTORY_NOTATION*/void r508to_subdirectory_with(T0* a1,T0* a2);
/*OPENVMS_DIRECTORY_NOTATION*/T6 r508is_valid_file_name(T0* a1);
T507*create507(void);
/*CYGWIN_DIRECTORY_NOTATION*/void r507to_current_directory(T0* a1);
/*CYGWIN_DIRECTORY_NOTATION*/T6 r507can_sanitize(T0* a1);
/*CYGWIN_DIRECTORY_NOTATION*/void r507not_yet_implemented(T507* C);
/*CYGWIN_DIRECTORY_NOTATION*/void r507crash(T507* C);
/*CYGWIN_DIRECTORY_NOTATION*/void r507to_file_path_with(T0* a1,T0* a2);
/*CYGWIN_DIRECTORY_NOTATION*/void r507to_subpath_with(T0* a1,T0* a2);
/*CYGWIN_DIRECTORY_NOTATION*/void r507to_parent_directory(T0* a1);
/*CYGWIN_DIRECTORY_NOTATION*/void r507from_notation(T507* C,T0* a1,T0* a2);
/*CYGWIN_DIRECTORY_NOTATION*/T6 r507is_valid_path(T0* a1);
/*CYGWIN_DIRECTORY_NOTATION*/T0* r507to_notation(T507* C,T0* a1,T0* a2);
/*CYGWIN_DIRECTORY_NOTATION*/void r507to_directory_path(T0* a1);
/*CYGWIN_DIRECTORY_NOTATION*/void r507to_default_root(T0* a1);
/*CYGWIN_DIRECTORY_NOTATION*/T6 r507can_map_drive(T0* a1,T0* a2);
/*CYGWIN_DIRECTORY_NOTATION*/void r507to_absolute_path_in(T0* a1,T0* a2);
/*CYGWIN_DIRECTORY_NOTATION*/T6 r507is_absolute_path(T0* a1);
/*CYGWIN_DIRECTORY_NOTATION*/void r507to_subdirectory_with(T0* a1,T0* a2);
/*CYGWIN_DIRECTORY_NOTATION*/T6 r507is_valid_file_name(T0* a1);
T506*create506(void);
/*UNIX_DIRECTORY_NOTATION*/void r506to_current_directory(T0* a1);
/*UNIX_DIRECTORY_NOTATION*/T6 r506can_sanitize(T0* a1);
/*UNIX_DIRECTORY_NOTATION*/void r506to_file_path_with(T0* a1,T0* a2);
/*UNIX_DIRECTORY_NOTATION*/void r506to_subpath_with(T0* a1,T0* a2);
/*UNIX_DIRECTORY_NOTATION*/void r506to_parent_directory(T0* a1);
/*UNIX_DIRECTORY_NOTATION*/void r506from_notation(T506* C,T0* a1,T0* a2);
/*UNIX_DIRECTORY_NOTATION*/T6 r506is_valid_path(T0* a1);
/*UNIX_DIRECTORY_NOTATION*/T0* r506to_notation(T0* a1,T0* a2);
/*UNIX_DIRECTORY_NOTATION*/void r506to_directory_path(T0* a1);
/*UNIX_DIRECTORY_NOTATION*/void r506to_default_root(T0* a1);
/*UNIX_DIRECTORY_NOTATION*/T6 r506can_map_drive(T0* a1,T0* a2);
/*UNIX_DIRECTORY_NOTATION*/void r506to_absolute_path_in(T0* a1,T0* a2);
/*UNIX_DIRECTORY_NOTATION*/T6 r506is_absolute_path(T0* a1);
/*UNIX_DIRECTORY_NOTATION*/void r506to_subdirectory_with(T0* a1,T0* a2);
/*UNIX_DIRECTORY_NOTATION*/T6 r506is_valid_file_name(T0* a1);
/*BASIC_DIRECTORY*/void r496disconnect(T496* C);
/*BASIC_DIRECTORY*/T0* r496system_notation(void);
/*BASIC_DIRECTORY*/void r496connect_to(T496* C,T0* a1);
/*BASIC_DIRECTORY*/void r496compute_file_path_with(T0* a1,T0* a2);
/*BASIC_DIRECTORY*/T6 r496openvms_notation(void);
/*BASIC_DIRECTORY*/T6 r496cygwin_notation(void);
/*BASIC_DIRECTORY*/void r496compute_absolute_file_path_with(T0* a1);
/*BASIC_DIRECTORY*/T0* r496current_working_directory(void);
/*BASIC_DIRECTORY*/void r496set_notation_using(T0* a1);
/*BASIC_DIRECTORY*/T6 r496amiga_notation(void);
/*BASIC_DIRECTORY*/void r496connect_with(T496* C,T0* a1);
/*BASIC_DIRECTORY*/void r496connect_to_current_working_directory(T496* C);
/*BASIC_DIRECTORY*/void r496compute_subdirectory_with(T0* a1,T0* a2);
/*BASIC_DIRECTORY*/T6 r496is_case_sensitive(void);
/*BASIC_DIRECTORY*/T6 r496windows_notation(void);
/*BASIC_DIRECTORY*/T6 r496unix_notation(void);
extern T0*oBC496system_notation_buffer;
extern T0*oBC496last_entry;
extern int fBC496last_entry;
/*BASIC_DIRECTORY*/T0* r496last_entry(void);
/*BASIC_DIRECTORY*/T6 r496macintosh_notation(void);
/*BASIC_DIRECTORY*/void r496compute_parent_directory_of(T0* a1);
/*BASIC_DIRECTORY*/void r496read_entry(T496* C);
/*SERC_FACTORY*/T0* r279system_tools(void);
extern T0*oBC279userprofile_env;
extern int fBC279userprofile_env;
/*SERC_FACTORY*/T0* r279userprofile_env(void);
/*SERC_FACTORY*/T0* r279env(T0* a1);
/*SERC_FACTORY*/void r279add_to_chain(T0* a1,T0* a2);
extern T0*oBC279seconf_env;
extern int fBC279seconf_env;
/*SERC_FACTORY*/T0* r279seconf_env(void);
extern T0*oBC279home_env;
extern int fBC279home_env;
/*SERC_FACTORY*/T0* r279home_env(void);
extern T0*oBC279config;
extern int fBC279config;
/*SERC_FACTORY*/T0* r279config(void);
/*SERC_FACTORY*/T0* r279parser_buffer(void);
T539*create539make(T296 a1);
/*STRING_TYPE_MARK*/void r539copy(T539* C,T0* a1);
/*STRING_TYPE_MARK*/T0* r539declaration_type(T539* C);
/*STRING_TYPE_MARK*/void r539id_extra_information(T0* a1);
/*STRING_TYPE_MARK*/T0* r539class_text(T539* C);
/*STRING_TYPE_MARK*/T6 r539is_real(void);
/*STRING_TYPE_MARK*/T0* r539resolve_in(T0* a1);
/*STRING_TYPE_MARK*/T6 r539is_character(void);
/*STRING_TYPE_MARK*/T6 r539is_kernel_expanded(void);
/*STRING_TYPE_MARK*/void r539c_header_pass1(void);
/*STRING_TYPE_MARK*/T0* r539at(T539* C,T296 a1);
/*STRING_TYPE_MARK*/T6 r539is_integer(void);
/*STRING_TYPE_MARK*/void r539c_type_for_target_in(T0* a1);
/*STRING_TYPE_MARK*/void r539c_initialize_in(T0* a1);
/*STRING_TYPE_MARK*/void r539gc_store_in(T0* a1);
/*STRING_TYPE_MARK*/void r539c_type_for_external_in(T0* a1);
/*STRING_TYPE_MARK*/void r539make(T539* C,T296 a1);
/*STRING_TYPE_MARK*/T0* r539written_mark(void);
/*STRING_TYPE_MARK*/T0* r539twin(T539* C);
/*STRING_TYPE_MARK*/T6 r539is_string(void);
/*STRING_TYPE_MARK*/T6 r539is_tuple(void);
/*STRING_TYPE_MARK*/void r539gc_store_chunk_in(T0* a1);
/*STRING_TYPE_MARK*/void r539pretty_in(T0* a1);
/*STRING_TYPE_MARK*/T6 r539is_formal_generic(void);
/*STRING_TYPE_MARK*/void r539generate_once_gc_update_weak_ref_item_polymorph(void);
/*STRING_TYPE_MARK*/T296 r539start_position(T539* C);
/*STRING_TYPE_MARK*/void r539standard_gc_define2(void);
/*STRING_TYPE_MARK*/void r539standard_gc_define1(void);
/*STRING_TYPE_MARK*/void r539gc_mark_in(T0* a1);
/*STRING_TYPE_MARK*/void r539just_before_gc_mark_in(T0* a1);
/*STRING_TYPE_MARK*/void r539standard_gc_info_in(T0* a1);
/*STRING_TYPE_MARK*/T6 r539same_signature_type(T539* C,T0* a1,T0* a2);
/*STRING_TYPE_MARK*/void r539standard_c_typedef(void);
/*STRING_TYPE_MARK*/T6 r539is_anchored(void);
/*STRING_TYPE_MARK*/T6 r539is_boolean(void);
/*STRING_TYPE_MARK*/void r539c_type_for_argument_in(T0* a1);
/*STRING_TYPE_MARK*/void r539gc_info_in(T0* a1);
extern T0*oBC539written_name;
extern int fBC539written_name;
/*STRING_TYPE_MARK*/T0* r539written_name(void);
/*STRING_TYPE_MARK*/T0* r539default_expression(T296 a1);
/*STRING_TYPE_MARK*/void r539c_frame_descriptor_in(T0* a1);
/*STRING_TYPE_MARK*/T0* r539to_static(T539* C,T0* a1);
/*STRING_TYPE_MARK*/void r539gc_define1(void);
/*STRING_TYPE_MARK*/void r539gc_define2(void);
/*STRING_TYPE_MARK*/T0* r539specialize_thru(T539* C,T0* a1,T0* a2,T0* a3);
/*STRING_TYPE_MARK*/T0* r539signature_resolve_in(T0* a1);
/*STRING_TYPE_MARK*/void r539gc_free_in(T0* a1);
/*STRING_TYPE_MARK*/void r539gc_align_mark_in(T0* a1);
/*STRING_TYPE_MARK*/void r539standard_c_struct(void);
/*STRING_TYPE_MARK*/T6 r539is_like_current(void);
/*STRING_TYPE_MARK*/T6 r539is_agent(void);
/*STRING_TYPE_MARK*/void r539set_start_position(T539* C,T296 a1);
/*STRING_TYPE_MARK*/T0* r539generic_list(void);
extern T0*oBC539long_name;
extern int fBC539long_name;
/*STRING_TYPE_MARK*/T0* r539long_name(void);
/*STRING_TYPE_MARK*/void r539standard_c_object_model(void);
/*STRING_TYPE_MARK*/T0* r539type(void);
/*STRING_TYPE_MARK*/T0* r539typed_internals_type_mark(T539* C,T296 a1);
/*STRING_TYPE_MARK*/void r539gc_store_left_in(T0* a1);
/*STRING_TYPE_MARK*/void r539c_type_for_result_in(T0* a1);
/*STRING_TYPE_MARK*/T6 r539is_native_array(void);
/*STRING_TYPE_MARK*/T6 r539is_pointer(void);
/*STRING_TYPE_MARK*/void r539c_header_pass4(void);
/*STRING_TYPE_MARK*/void r539standard_just_before_gc_mark_in(T0* a1);
/*STRING_TYPE_MARK*/void r539gc_info_nb_in(T0* a1);
/*STRING_TYPE_MARK*/T0* r539specialize_in(T539* C,T0* a1);
/*STRING_TYPE_MARK*/void r539gc_call_new_in(T0* a1);
/*MANIFEST_GENERIC_POOL*/void r234c_define(void);
extern T0*oBC234collected_manifest_generic;
extern int fBC234collected_manifest_generic;
/*MANIFEST_GENERIC_POOL*/T0* r234collected_manifest_generic(void);
/*MANIFEST_GENERIC_POOL*/void r234va_type_in(T0* a1,T0* a2);
/*MANIFEST_GENERIC_POOL*/void r234c_define_for_user_generic(T0* a1);
/*MANIFEST_GENERIC_POOL*/void r234c_define_for_native_array(T0* a1);
/*ONCE_ROUTINE_POOL*/T6 r220is_precomputed(T0* a1);
extern T0*oBC220precomputable_function_list;
extern int fBC220precomputable_function_list;
/*ONCE_ROUTINE_POOL*/T0* r220precomputable_function_list(void);
/*ONCE_ROUTINE_POOL*/void r220unique_id_in(T0* a1,T0* a2);
/*ONCE_ROUTINE_POOL*/void r220c_pre_compute_of(T0* a1,T0* a2);
/*ONCE_ROUTINE_POOL*/T0* r220non_void_no_dispatch_for(T0* a1,T0* a2,T0* a3);
/*ONCE_ROUTINE_POOL*/void r220c_define_o_result(T0* a1);
/*ONCE_ROUTINE_POOL*/void r220collect_precomputable_function(T0* a1,T0* a2,T0* a3);
/*ONCE_ROUTINE_POOL*/void r220c_test_o_flag_introspect(T0* a1);
/*ONCE_ROUTINE_POOL*/void r220c_variables_for_precomputable_routines(void);
/*ONCE_ROUTINE_POOL*/void r220c_code_for_precomputable_routines(void);
/*ONCE_ROUTINE_POOL*/void r220c_test_o_flag(T0* a1);
extern T0*oBC220procedure_list;
extern int fBC220procedure_list;
/*ONCE_ROUTINE_POOL*/T0* r220procedure_list(void);
/*ONCE_ROUTINE_POOL*/void r220c_test_o_flag_recursion(T0* a1);
/*ONCE_ROUTINE_POOL*/void r220c_define_o_flag(T0* a1);
/*ONCE_ROUTINE_POOL*/void r220reset(void);
/*ONCE_ROUTINE_POOL*/void r220gc_mark(void);
/*ONCE_ROUTINE_POOL*/T0* r220o_flag(T0* a1);
/*ONCE_ROUTINE_POOL*/T0* r220echo(void);
extern T0*oBC220function_list;
extern int fBC220function_list;
/*ONCE_ROUTINE_POOL*/T0* r220function_list(void);
/*ONCE_ROUTINE_POOL*/T0* r220precomputable_function(T0* a1,T0* a2,T0* a3);
/*ONCE_ROUTINE_POOL*/T6 r220no_dispatch_for(T0* a1,T0* a2);
/*ONCE_ROUTINE_POOL*/void r220unique_result_in(T0* a1,T0* a2);
extern T0*oBC220collected_precomputable_function;
extern int fBC220collected_precomputable_function;
/*ONCE_ROUTINE_POOL*/T0* r220collected_precomputable_function(void);
/*SWITCH_COLLECTION*/T2 r710count(void);
/*SWITCH_COLLECTION*/void r710c_define(void);
/*SWITCH_COLLECTION*/T0* r710echo(void);
extern T0*oBC710count_memory;
/*SWITCH_COLLECTION*/T2 r710new_id(void);
/*SWITCH_COLLECTION*/void r710initialize_switch_site_profiles(void);
extern T0*oBC710dictionary;
extern int fBC710dictionary;
/*SWITCH_COLLECTION*/T0* r710dictionary(void);
/*SWITCH_COLLECTION*/void r710set_switch_for(T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
extern T0*oBC224launcher_memory;
extern int fBC224launcher_memory;
/*AGENT_POOL*/T0* r224launcher_memory(void);
extern T0*oBC224creation_collected_memory;
extern int fBC224creation_collected_memory;
/*AGENT_POOL*/T0* r224creation_collected_memory(void);
extern T0*oBC224agent_definition_set;
extern int fBC224agent_definition_set;
/*AGENT_POOL*/T0* r224agent_definition_set(void);
/*AGENT_POOL*/void r224agent_creation_collect(T224* C,T0* a1,T0* a2,T0* a3);
/*AGENT_POOL*/T0* r224agent_launcher_collect(T0* a1);
/*AGENT_POOL*/void r224c_switch_in(T0* a1,T0* a2,T0* a3);
/*AGENT_POOL*/void r224c_define_agent_creation_for(T0* a1);
extern T0*oBC224launcher_collected_memory;
extern int fBC224launcher_collected_memory;
/*AGENT_POOL*/T0* r224launcher_collected_memory(void);
/*AGENT_POOL*/void r224gc_info(T224* C);
extern T0*oBC224defined_agent_creation;
extern int fBC224defined_agent_creation;
/*AGENT_POOL*/T0* r224defined_agent_creation(void);
/*AGENT_POOL*/void r224c_header_pass1(T224* C);
/*AGENT_POOL*/void r224notify_assignment_handler_with(T0* a1,T0* a2);
/*AGENT_POOL*/void r224reset(T224* C);
/*AGENT_POOL*/void r224signature_add_last(T0* a1,T0* a2);
/*AGENT_POOL*/T0* r224echo(void);
/*AGENT_POOL*/void r224customize_c_runtime_1(T224* C);
/*AGENT_POOL*/void r224customize_c_runtime_2(T224* C);
/*ASSIGNMENT_TEST_POOL*/void r217collect(T0* a1,T0* a2);
/*ASSIGNMENT_TEST_POOL*/void r217function_name_in(T0* a1,T0* a2,T0* a3);
/*ASSIGNMENT_TEST_POOL*/T0* r217new_empty_set(void);
extern T0*oBC217map;
extern int fBC217map;
/*ASSIGNMENT_TEST_POOL*/T0* r217map(void);
/*ASSIGNMENT_TEST_POOL*/void r217c_define_assignment_test_functions(T0* a1);
/*ASSIGNMENT_TEST_POOL*/void r217right_hand_side_can_only_be_void(void);
/*ASSIGNMENT_TEST_POOL*/void r217reset(void);
extern T0*oBC217free_set_list;
extern int fBC217free_set_list;
/*ASSIGNMENT_TEST_POOL*/T0* r217free_set_list(void);
/*ASSIGNMENT_TEST_POOL*/void r217c_define_assignment_test_for(T0* a1,T0* a2,T0* a3);
/*ASSIGNMENT_TEST_POOL*/void r217signature_add_last(T0* a1,T0* a2);
/*ASSIGNMENT_TEST_POOL*/T0* r217echo(void);
/*MANIFEST_STRING_POOL*/void r239se_ums_c_call_in(T0* a1,T0* a2);
/*MANIFEST_STRING_POOL*/void r239collect_string(T0* a1);
/*MANIFEST_STRING_POOL*/void r239c_call_initialize(T239* C);
extern T0*oBC28storage_name;
extern int fBC28storage_name;
/*MANIFEST_STRING_POOL*/T0* r239storage_name(void);
/*MANIFEST_STRING_POOL*/void r239character_to_c_code(T3 a1,T0* a2);
extern T0*oBC239storage_alias;
extern int fBC239storage_alias;
/*MANIFEST_STRING_POOL*/T0* r239storage_alias(void);
/*MANIFEST_STRING_POOL*/void r239c_define1(T6 a1);
/*MANIFEST_STRING_POOL*/void r239c_define2(T239* C,T6 a1);
extern T0*oBC239collected_once_variables;
extern int fBC239collected_once_variables;
/*MANIFEST_STRING_POOL*/T0* r239collected_once_variables(void);
/*MANIFEST_STRING_POOL*/T6 r239manifest_string_trace(T0* a1,T0* a2);
/*MANIFEST_STRING_POOL*/void r239manifest_string_mark_signature(T2 a1);
extern T0*oBC239collected_storage_id_set;
extern int fBC239collected_storage_id_set;
/*MANIFEST_STRING_POOL*/T0* r239collected_storage_id_set(void);
/*MANIFEST_STRING_POOL*/void r239common_body_for_se_string_and_se_ms(T6 a1);
/*MANIFEST_STRING_POOL*/void r239define_manifest_string_mark(T239* C);
/*MANIFEST_STRING_POOL*/void r239native_array_to_c_code(T2 a1,T9 a2,T0* a3);
/*MANIFEST_STRING_POOL*/T0* r239collect(T239* C,T0* a1,T6 a2,T6 a3,T0* a4);
/*MANIFEST_STRING_POOL*/void r239se_ms_c_call_in(T0* a1,T0* a2);
/*MANIFEST_STRING_POOL*/void r239string_to_c_code(T0* a1,T0* a2);
/*MANIFEST_STRING_POOL*/T0* r239count_name(void);
extern T0*oBC28manifest_initialize_name;
extern int fBC28manifest_initialize_name;
/*MANIFEST_STRING_POOL*/T0* r239manifest_initialize_name(void);
/*MANIFEST_STRING_POOL*/void r239reset(T239* C);
extern T0*oBC28capacity_name;
extern int fBC28capacity_name;
/*MANIFEST_STRING_POOL*/T0* r239capacity_name(void);
/*MANIFEST_STRING_POOL*/T0* r239echo(void);
/*MANIFEST_STRING_POOL*/T0* r239calloc_name(void);
/*FEATURE_STAMP*/T0* r67resolve_static_binding_for(T67* C,T0* a1,T0* a2);
/*FEATURE_STAMP*/void r67rename_notify(T67* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*FEATURE_STAMP*/void r67specialize_2(T67* C,T0* a1);
extern T0*oBC67hash_counter;
/*FEATURE_STAMP*/T0* r67simplify(T67* C,T0* a1);
/*FEATURE_STAMP*/T0* r67specialize_thru(T67* C,T0* a1,T0* a2,T0* a3);
/*FEATURE_STAMP*/T6 r67has_type(T67* C,T0* a1);
/*FEATURE_STAMP*/void r67make_run_feature(T67* C,T0* a1,T0* a2);
/*FEATURE_STAMP*/T0* r67anonymous_feature_if_exist(T67* C,T0* a1);
/*FEATURE_STAMP*/T6 r67print_feature_hierarchy(T67* C,T0* a1,T0* a2,T304 a3);
/*FEATURE_STAMP*/T2 r67next_hash(void);
/*FEATURE_STAMP*/T0* r67feature_accumulator(void);
/*FEATURE_STAMP*/T0* r67resolve_static_binding_for_insert(T67* C,T0* a1,T0* a2);
/*FEATURE_STAMP*/T0* r67resolve_static_binding_for_inherit(T67* C,T0* a1,T0* a2);
/*FEATURE_STAMP*/T6 r67has_anonymous_feature_for(T67* C,T0* a1);
/*FEATURE_STAMP*/void r67register_type(T67* C,T0* a1);
/*FEATURE_STAMP*/void r67rename_down_notify(T67* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*FEATURE_STAMP*/T0* r67run_feature_for(T67* C,T0* a1);
/*FEATURE_STAMP*/void r67make(T67* C,T0* a1);
/*FEATURE_STAMP*/void r67add_anonymous_feature(T67* C,T0* a1,T0* a2);
/*FEATURE_STAMP*/T6 r67has_run_feature_for(T67* C,T0* a1);
/*FEATURE_STAMP*/T0* r67anonymous_feature(T67* C,T0* a1);
/*FEATURE_STAMP*/T6 r67add_seeds(T67* C,T0* a1,T0* a2,T0* a3);
/*ASSIGNMENT_HANDLER*/void r238id_extra_information(T0* a1,T0* a2);
/*ASSIGNMENT_HANDLER*/void r238collect_normal(T238* C,T0* a1,T0* a2);
/*ASSIGNMENT_HANDLER*/void r238from_external_(T238* C,T0* a1,T0* a2);
/*ASSIGNMENT_HANDLER*/T0* r238graph_node_for(T0* a1);
/*ASSIGNMENT_HANDLER*/void r238reset(void);
extern T0*oBC238graph_node_dictionary;
extern int fBC238graph_node_dictionary;
/*ASSIGNMENT_HANDLER*/T0* r238graph_node_dictionary(void);
/*ASSIGNMENT_HANDLER*/void r238collect_force(T238* C,T0* a1,T0* a2);
/*ASSIGNMENT_HANDLER*/T0* r238implicit_cast(T0* a1,T0* a2,T0* a3);
/*ASSIGNMENT_HANDLER*/void r238recompute_all_run_time_sets(void);
extern T0*oBC238external_types;
extern int fBC238external_types;
/*ASSIGNMENT_HANDLER*/T0* r238external_types(void);
/*ASSIGNMENT_HANDLER*/T0* r238implicit_cast_(T0* a1,T0* a2,T0* a3);
/*ASSIGNMENT_HANDLER*/void r238from_external(T238* C,T0* a1,T0* a2,T0* a3);
/*ASSIGNMENT_HANDLER*/T0* r238echo(void);
/*ASSIGNMENT_HANDLER*/void r238echo_information(void);
/*FEATURE_ACCUMULATOR*/void r231check_and_merge_seeds(T231* C);
/*FEATURE_ACCUMULATOR*/void r231start(T231* C,T0* a1);
/*FEATURE_ACCUMULATOR*/void r231do_pending_types(T231* C);
/*FEATURE_ACCUMULATOR*/void r231finalize(T231* C);
/*FEATURE_ACCUMULATOR*/void r231new_feature(T231* C,T0* a1);
/*FEATURE_ACCUMULATOR*/void r231new_incomplete_type(T231* C);
/*FEATURE_ACCUMULATOR*/T0* r231find_type_for(T231* C,T0* a1);
/*FEATURE_ACCUMULATOR*/void r231to_feature(T231* C,T0* a1);
/*FEATURE_ACCUMULATOR*/void r231add_parent_definition(T231* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*FEATURE_ACCUMULATOR*/T6 r231is_known(T231* C,T0* a1);
/*FEATURE_ACCUMULATOR*/T1 r231transition_index(T231* C,T0* a1,T0* a2,T0* a3);
/*FEATURE_ACCUMULATOR*/void r231make(T231* C);
/*FEATURE_ACCUMULATOR*/T1 r231next_state(T231* C,T1 a1,T1 a2,T0* a3,T0* a4,T0* a5);
/*FEATURE_ACCUMULATOR*/T0* r231anonymous_feature_for(T231* C,T0* a1);
/*FEATURE_ACCUMULATOR*/T0* r231echo(void);
/*FEATURE_ACCUMULATOR*/void r231add_local_definition(T231* C,T0* a1);
extern T0*oBC231transitions;
extern int fBC231transitions;
/*FEATURE_ACCUMULATOR*/T0* r231transitions(void);
/*FEATURE_ACCUMULATOR*/void r231register(T231* C,T0* a1);
/*FEATURE_ACCUMULATOR*/void r231echo_information(T231* C);
/*FEATURE_ACCUMULATOR*/T0* r231feature_stamp_of(T231* C,T0* a1);
/*STATUS*/void r518set_safety_checking(T518* C);
/*STATUS*/void r518set_collecting(T518* C);
/*STATUS*/void r518end_specializing(T518* C,T0* a1);
/*STATUS*/void r518start_specializing(T518* C,T0* a1);
/*STATUS*/void r518set_adapting(T518* C);
/*STATUS*/void r518make(T518* C);
/*STATUS*/void r518set_generating(T518* C);
/*STATUS*/void r518info(T518* C);
/*STATUS*/T0* r518echo(void);
extern T0*oBC518internal_phase_stack;
extern int fBC518internal_phase_stack;
/*STATUS*/T0* r518internal_phase_stack(void);
/*STATUS*/void r518pop_phase(T518* C);
/*STATUS*/void r518push_phase(T518* C,T2 a1);
/*TYPE*/T0* r73expanded_default_create_stamp(T73* C);
/*TYPE*/void r73c_type_for_result_in(T73* C,T0* a1);
/*TYPE*/void r73collect_features(T73* C);
/*TYPE*/T6 r73is_native_array(T73* C);
/*TYPE*/T6 r73is_pointer(T73* C);
/*TYPE*/void r73collect_default_rescue(T73* C,T0* a1);
/*TYPE*/void r73do_collect(T73* C);
/*TYPE*/T1 r73insert_inherit_test(T73* C,T0* a1);
/*TYPE*/T0* r73has_only_one_conformant_parent(T73* C);
/*TYPE*/T6 r73is_real(T73* C);
/*TYPE*/T0* r73feature_stamp_of(T73* C,T0* a1);
/*TYPE*/T6 r73is_empty_expanded(T73* C);
/*TYPE*/T0* r73find_manifest_expression_for(T73* C,T0* a1,T0* a2);
/*TYPE*/T6 r73can_be_assigned_to(T73* C,T0* a1);
/*TYPE*/T6 r73is_character(T73* C);
/*TYPE*/T6 r73is_expanded(T73* C);
/*TYPE*/T0* r73copy_stamp(T73* C);
/*TYPE*/T6 r73is_kernel_expanded(T73* C);
/*TYPE*/void r73adapt_class_invariant(T73* C);
/*TYPE*/T6 r73is_integer(T73* C);
/*TYPE*/void r73add_feature(T73* C,T0* a1,T0* a2);
/*TYPE*/T6 r73is_reference(T73* C);
/*TYPE*/void r73build_actual_invariant(T73* C);
/*TYPE*/T6 r73inherits_from(T73* C,T0* a1);
/*TYPE*/T0* r73open_arguments(T73* C);
/*TYPE*/void r73collect_local_features(T73* C);
/*TYPE*/T0* r73writable_attributes(T73* C);
/*TYPE*/T0* r73find_anonymous_feature_for(T73* C,T0* a1,T0* a2);
/*TYPE*/T6 r73is_user_expanded(T73* C);
/*TYPE*/void r73make(T73* C,T0* a1);
/*TYPE*/T2 r73collected_feature_count(T73* C);
/*TYPE*/void r73collect_one_feature(T73* C,T0* a1,T2 a2);
/*TYPE*/T6 r73direct_non_void_call_flag(T73* C);
/*TYPE*/T6 r73is_tuple(T73* C);
/*TYPE*/T0* r73agent_result(T73* C);
/*TYPE*/void r73print_graph_cycle(T73* C,T0* a1);
/*TYPE*/void r73inheritance_cycle_check(T73* C);
/*TYPE*/T6 r73is_boolean(T73* C);
/*TYPE*/void r73specialize_2(T73* C);
extern T0*oBC28any_default_rescue_fs;
extern int fBC28any_default_rescue_fs;
/*TYPE*/T0* r73any_default_rescue_fs(void);
/*TYPE*/T6 r73print_feature_hierarchy(T73* C,T0* a1,T304 a2);
/*TYPE*/void r73add_seeds(T73* C,T0* a1,T0* a2);
/*TYPE*/T0* r73feature_accumulator(void);
/*TYPE*/void r73add_parent(T73* C,T0* a1);
/*TYPE*/T2 r73parents_count(T73* C);
/*TYPE*/void r73deconnect_current(T73* C);
extern T0*oBC28default_rescue_name;
extern int fBC28default_rescue_name;
/*TYPE*/T0* r73default_rescue_name(void);
/*TYPE*/void r73node_init(T73* C,T0* a1);
/*TYPE*/T6 r73has_simple_feature_name(T73* C,T0* a1);
/*TYPE*/T0* r73name_from_string(T73* C,T0* a1);
/*TYPE*/T6 r73is_agent(T73* C);
/*TYPE*/T2 r73id(T73* C);
/*TYPE*/T0* r73long_name(T73* C);
/*TYPE*/void r73_P_75_make(T73* C,T0* a1);
/*TYPE*/void r73_P_75_add_parent(T73* C,T0* a1);
extern T0*oBC244fn_buffer;
extern int fBC244fn_buffer;
/*CLASS_TEXT*/T0* r244fn_buffer(void);
/*CLASS_TEXT*/T6 r244require_check(T244* C);
/*CLASS_TEXT*/T0* r244proper_name_get(T244* C,T0* a1);
/*CLASS_TEXT*/T0* r244non_written(T244* C,T0* a1,T0* a2);
/*CLASS_TEXT*/void r244create_parent_lists_using(T244* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*CLASS_TEXT*/T0* r244root_creation_search(T244* C,T0* a1);
/*CLASS_TEXT*/T1 r244insert_inherit_test(T244* C,T0* a1);
/*CLASS_TEXT*/T6 r244is_native_array_collector_enabled(T244* C);
/*CLASS_TEXT*/void r244extra_expanded_check(T244* C,T0* a1);
/*CLASS_TEXT*/T0* r244declaration_type_of_like_current(T244* C);
/*CLASS_TEXT*/void r244formal_generic_list_count_check(T244* C,T296 a1,T0* a2);
/*CLASS_TEXT*/T6 r244invariant_check(T244* C);
/*CLASS_TEXT*/T6 r244inherits_from(T244* C,T0* a1);
/*CLASS_TEXT*/void r244make(T244* C,T0* a1,T0* a2,T0* a3,T10 a4);
/*CLASS_TEXT*/T6 r244all_check(T244* C);
/*CLASS_TEXT*/void r244check_level_2(T244* C,T0* a1);
/*CLASS_TEXT*/T0* r244any_default_create_fs(void);
/*CLASS_TEXT*/void r244initialize_and_check_level_1(T244* C);
/*CLASS_TEXT*/void r244id_extra_information(T244* C,T0* a1);
/*CLASS_TEXT*/T0* r244level_name(T2 a1);
/*CLASS_TEXT*/T0* r244default_create_name(void);
/*CLASS_TEXT*/T6 r244loop_check(T244* C);
/*CLASS_TEXT*/void r244finish_create(T244* C);
/*CLASS_TEXT*/T6 r244has_creation_check(T244* C,T0* a1,T296 a2);
/*CLASS_TEXT*/T0* r244default_root_procedure_name(T244* C);
/*CLASS_TEXT*/void r244fatal_error_when_no_creation_clause(T244* C);
/*CLASS_TEXT*/T6 r244once_flag(T244* C,T0* a1);
/*CLASS_TEXT*/T6 r244ensure_check(T244* C);
/*CLASS_TEXT*/T0* r244next_tuple(T244* C);
/*CLASS_TEXT*/void r244set_is_expanded(T244* C);
/*CLASS_TEXT*/T6 r244obvious_resolve_static_binding(T244* C,T0* a1,T6 a2);
/*CLASS_TEXT*/void r244error_vtec1(T244* C);
/*CLASS_TEXT*/void r244add_index_clause(T244* C,T0* a1);
/*CLASS_TEXT*/T0* r244user_expanded_default_create_stamp(T244* C,T0* a1);
/*CLASS_TEXT*/void r244add_feature_clause(T244* C,T0* a1);
/*CLASS_TEXT*/T0* r244any_copy_feature(T244* C);
/*CLASS_TEXT*/T0* r244proper_get(T244* C,T0* a1);
extern T0*oBC28id_provider;
extern int fBC28id_provider;
/*CLASS_TEXT*/T0* r244id_provider(void);
extern T0*oBC28omitted_client_list;
/*CLASS_TEXT*/T6 r244proper_has(T244* C,T0* a1);
/*CLASS_TEXT*/T0* r244declaration_type_of_like_current_(T244* C,T296 a1);
/*CLASS_TEXT*/void r244obsolete_warning_check(T244* C,T296 a1);
/*CLASS_TEXT*/void r244add_creation_clause(T244* C,T0* a1);
/*CLASS_TEXT*/void r244creation_list_check(T244* C,T0* a1);
/*CLASS_TEXT*/void r244set_is_deferred(T244* C);
/*CLASS_TEXT*/void r244set_invariant(T244* C,T296 a1,T0* a2,T0* a3);
/*CLASS_TEXT*/void r244fatal_undefine(T244* C,T0* a1);
/*LIVE_TYPE*/T6 r317generator_used(T317* C);
/*LIVE_TYPE*/T6 r317is_native_array(T317* C);
/*LIVE_TYPE*/void r317do_collect(T317* C);
/*LIVE_TYPE*/T2 r317feature_count(T317* C);
/*LIVE_TYPE*/T6 r317is_empty_expanded(T317* C);
/*LIVE_TYPE*/void r317c_header_pass2(T317* C);
/*LIVE_TYPE*/void r317c_header_pass3(T317* C);
/*LIVE_TYPE*/T6 r317can_be_assigned_to(T317* C,T0* a1);
/*LIVE_TYPE*/void r317c_header_pass4(T317* C);
/*LIVE_TYPE*/void r317compile_to_c(T317* C,T2 a1);
/*LIVE_TYPE*/T6 r317is_reference(T317* C);
/*LIVE_TYPE*/void r317create_function_define(T317* C,T0* a1);
/*LIVE_TYPE*/void r317c_return_introspect(T317* C,T0* a1,T0* a2);
/*LIVE_TYPE*/T6 r317need_gc_mark(T317* C);
/*LIVE_TYPE*/void r317c_header_pass1(T317* C);
/*LIVE_TYPE*/T0* r317c_pointer_to_type(T0* a1);
/*LIVE_TYPE*/void r317do_collect_native_array_collector(T317* C);
/*LIVE_TYPE*/void r317create_function_register(T317* C,T0* a1);
/*LIVE_TYPE*/void r317sort_wam(T0* a1);
/*LIVE_TYPE*/void r317gc_mark_fixed_size(T317* C,T6 a1);
/*LIVE_TYPE*/void r317gc_set_fsoh_marked(T317* C);
/*LIVE_TYPE*/T0* r317writable_attributes(T317* C);
/*LIVE_TYPE*/void r317make(T317* C,T0* a1);
/*LIVE_TYPE*/void r317collect_is_deep_equal(T317* C);
/*LIVE_TYPE*/void r317set_generator_used(T317* C);
/*LIVE_TYPE*/void r317mark_attribute(T317* C,T0* a1);
/*LIVE_TYPE*/void r317forget_previous_collect(T317* C);
/*LIVE_TYPE*/T6 r317no_dispatch_collect(T317* C,T0* a1);
/*LIVE_TYPE*/T0* r317dynamic_feature(T317* C,T0* a1);
extern T0*oBC317wa_cyclic_buf;
extern int fBC317wa_cyclic_buf;
/*LIVE_TYPE*/T0* r317wa_cyclic_buf(void);
/*LIVE_TYPE*/void r317propagate_features(T317* C);
/*LIVE_TYPE*/T6 r317side_effect_free_default_create(T317* C);
/*LIVE_TYPE*/T0* r317get_memory_dispose(T317* C);
/*LIVE_TYPE*/T6 r317gt(T0* a1,T0* a2);
/*LIVE_TYPE*/void r317make_run_features(T317* C);
/*LIVE_TYPE*/void r317c_deep_twin_body(T317* C);
/*LIVE_TYPE*/void r317really_compile_to_c(T317* C);
/*LIVE_TYPE*/void r317make_switch_sites(T317* C);
/*LIVE_TYPE*/void r317c_object_model_in(T317* C,T0* a1);
/*LIVE_TYPE*/void r317c_field_access(T317* C,T0* a1,T0* a2);
/*LIVE_TYPE*/T0* r317copy_run_feature(T317* C);
/*LIVE_TYPE*/void r317allow_collecting(T317* C,T0* a1);
/*LIVE_TYPE*/void r317adapt_run_features_and_class_invariant(T317* C);
/*LIVE_TYPE*/void r317collect_deep_twin(T317* C);
/*LIVE_TYPE*/void r317simplify(T317* C);
/*LIVE_TYPE*/void r317set_at_run_time(T317* C);
/*LIVE_TYPE*/T0* r317precursor_run_feature(T317* C,T0* a1);
extern T0*oBC317wa_cycle;
extern int fBC317wa_cycle;
/*LIVE_TYPE*/T0* r317wa_cycle(void);
/*LIVE_TYPE*/int r317switch_collection(void);
/*LIVE_TYPE*/void r317forbid_collecting(T317* C,T0* a1);
/*LIVE_TYPE*/T0* r317default_create_run_feature(T317* C);
extern T0*oBC317wa_buf;
extern int fBC317wa_buf;
/*LIVE_TYPE*/T0* r317wa_buf(void);
/*LIVE_TYPE*/void r317gc_align_mark_fixed_size(T317* C);
extern T0*oBC317new_features;
extern int fBC317new_features;
/*LIVE_TYPE*/T0* r317new_features(void);
/*LIVE_TYPE*/void r317is_deep_equal_c_code(T317* C);
/*LIVE_TYPE*/T6 r317is_tagged(T317* C);
/*LIVE_TYPE*/T0* r317structure_signature(T317* C);
extern T0*oBC28deep_memcmp_name;
extern int fBC28deep_memcmp_name;
/*LIVE_TYPE*/T0* r317deep_memcmp_name(void);
/*LIVE_TYPE*/T6 r317gc_mark_to_follow(T317* C);
/*LIVE_TYPE*/void r317do_collect_is_deep_equal(T317* C);
extern T0*oBC28mark_item_name;
extern int fBC28mark_item_name;
/*LIVE_TYPE*/T0* r317mark_item_name(void);
/*LIVE_TYPE*/void r317id_extra_information(T317* C,T0* a1);
/*LIVE_TYPE*/void r317merge_features_from(T317* C,T0* a1);
/*LIVE_TYPE*/T6 r317collected(T317* C,T0* a1);
/*LIVE_TYPE*/void r317c_print_function(T317* C);
/*LIVE_TYPE*/void r317collect(T317* C,T0* a1);
/*LIVE_TYPE*/void r317prepare_introspection2(T317* C);
/*LIVE_TYPE*/T6 r317_ix_60(T317* C,T0* a1);
/*LIVE_TYPE*/void r317prepare_introspection(T317* C);
/*LIVE_TYPE*/void r317collect_precursor(T317* C,T0* a1,T0* a2);
/*LIVE_TYPE*/T0* r317at(T317* C,T0* a1);
/*LIVE_TYPE*/T0* r317echo(void);
extern T0*oBC28is_deep_equal_name;
extern int fBC28is_deep_equal_name;
/*LIVE_TYPE*/T0* r317is_deep_equal_name(void);
extern T0*oBC28any_is_deep_equal_fs;
extern int fBC28any_is_deep_equal_fs;
/*LIVE_TYPE*/T0* r317any_is_deep_equal_fs(void);
extern T0*oBC28deep_twin_from_name;
extern int fBC28deep_twin_from_name;
/*LIVE_TYPE*/T0* r317deep_twin_from_name(void);
/*LIVE_TYPE*/void r317just_before_gc_mark_in(T317* C,T0* a1);
/*LIVE_TYPE*/void r317safety_check(T317* C);
extern T0*oBC28any_deep_twin_fs;
extern int fBC28any_deep_twin_fs;
/*LIVE_TYPE*/T0* r317any_deep_twin_fs(void);
extern T0*oBC28mark_native_arrays_name;
extern int fBC28mark_native_arrays_name;
/*LIVE_TYPE*/T0* r317mark_native_arrays_name(void);
/*LIVE_TYPE*/T0* r317capacity_name(void);
/*LIVE_TYPE*/T0* r317id_provider(void);
/*LIVE_TYPE*/T6 r317generating_type_used(T317* C);
extern T0*oBC28deep_twin_name;
extern int fBC28deep_twin_name;
/*LIVE_TYPE*/T0* r317deep_twin_name(void);
/*LIVE_TYPE*/void r317gc_info_in(T317* C,T0* a1);
/*LIVE_TYPE*/void r317gc_define1(T317* C);
/*LIVE_TYPE*/void r317gc_define2(T317* C);
/*CLUSTER*/T0* r301system_tools(void);
/*CLUSTER*/T0* r301class_text(T301* C,T0* a1,T6 a2,T6 a3);
/*CLUSTER*/void r301add_default_debug_key(T301* C,T0* a1);
/*CLUSTER*/T6 r301match_debug_keys(T0* a1,T0* a2);
/*CLUSTER*/T0* r301level_name(T2 a1);
/*CLUSTER*/T6 r301debug_check(T301* C,T0* a1,T0* a2);
/*CLUSTER*/void r301generic_formal_arguments_check(T301* C);
/*CLUSTER*/T0* r301parser_buffer(void);
/*CLUSTER*/T0* r301echo(void);
/*CLUSTER*/void r301make(T301* C,T0* a1,T0* a2,T0* a3);
/*CLUSTER*/void r301set_default_trace(T301* C,T6 a1);
/*CLUSTER*/void r301for_all(T301* C,T0* a1);
/*CLUSTER*/void r301view_in(T301* C,T0* a1);
/*CLUSTER*/void r301get_started(T301* C,T2 a1);
/*CLUSTER*/void r301init(T301* C,T0* a1,T2 a2);
/*CLUSTER*/void r301register_class_text(T301* C,T0* a1);
/*CLUSTER*/void r301exclude_add_last(T301* C,T0* a1);
extern T0*oBC301file_name_buffer;
extern int fBC301file_name_buffer;
/*CLUSTER*/T0* r301file_name_buffer(void);
/*CLUSTER*/void r301include_add_last(T301* C,T0* a1);
/*CLUSTER*/void r301read_classes(T301* C);
/*CLUSTER*/T6 r301trace(T301* C,T0* a1);
/*CLUSTER*/void r301include_parsing(T301* C);
extern T0*oBC301path_buffer;
extern int fBC301path_buffer;
/*CLUSTER*/T0* r301path_buffer(void);
/*CLUSTER*/T6 r301parser_buffer_load(T301* C);
/*CLUSTER*/void r301show(T301* C);
/*CLUSTER*/T6 r301parser_buffer_for(T301* C,T0* a1,T6 a2);
/*CLUSTER*/T6 r301default_trace_or_ace_default_trace(T301* C);
/*CLUSTER*/T2 r301class_text_count(T301* C);
/*CLUSTER*/void r301set_option_assertion_level(T301* C,T0* a1,T2 a2);
/*CLUSTER*/void r301add_option_trace(T301* C,T0* a1);
/*CLUSTER*/T6 r301prepare_parser_buffer_for(T301* C,T0* a1);
/*CLUSTER*/void r301add_option_debug_key(T301* C,T0* a1,T0* a2);
/*CLUSTER*/T2 r301assertion_level_of(T301* C,T0* a1);
/*CLUSTER*/T2 r301loaded_class_count(T301* C);
/*TEXT_FILE_READ*/void r242disconnect(T242* C);
/*TEXT_FILE_READ*/void r242connect_to(T242* C,T0* a1);
extern T0*oBC52last_string;
extern int fBC52last_string;
/*TEXT_FILE_READ*/T0* r242last_string(void);
/*TEXT_FILE_READ*/void r242filtered_read_line_in(T242* C,T0* a1);
/*TEXT_FILE_READ*/void r242filtered_read_character(T242* C);
/*TEXT_FILE_READ*/void r242fill_buffer(T242* C);
/*TEXT_FILE_READ*/T6 r242same_as(T242* C,T0* a1);
/*TEXT_FILE_READ*/void r242read_line(T242* C);
extern T0*oBC302real_alias;
extern int fBC302real_alias;
/*TYPE_ALIASING*/T0* r302real_alias(void);
extern T0*oBC302integer_alias;
extern int fBC302integer_alias;
/*TYPE_ALIASING*/T0* r302integer_alias(void);
T245*create245make(T0* a1,T296 a2);
T245*create245unknown_position(T0* a1);
/*CLASS_NAME*/void r245copy(T245* C,T0* a1);
/*CLASS_NAME*/T6 r245get_export_permission_of(T245* C,T0* a1);
/*CLASS_NAME*/T6 r245is_equal(T245* C,T0* a1);
/*CLASS_NAME*/T0* r245class_text(T245* C);
/*CLASS_NAME*/void r245unknown_position(T245* C,T0* a1);
/*CLASS_NAME*/T2 r245tuple_count(T245* C);
/*CLASS_NAME*/T0* r245try_class_text(T245* C);
/*CLASS_NAME*/void r245set_hashed_name(T245* C,T0* a1);
/*CLASS_NAME*/void r245make(T245* C,T0* a1,T296 a2);
/*CLASS_NAME*/T0* r245twin(T245* C);
/*POSITION*/T6 r296is_equal(T296* C,T296 a1);
/*POSITION*/T6 r296sedb_trace(T296* C);
/*POSITION*/T2 r296line(T296* C);
/*POSITION*/T2 r296column(T296* C);
/*POSITION*/T0* r296class_text(T296* C);
/*POSITION*/T6 r296_ix_60(T296* C,T296 a1);
/*POSITION*/T6 r296_ix_62(T296* C,T296 a1);
/*POSITION*/T0* r296path(T296* C);
/*POSITION*/T10 r296id(T296* C);
/*POSITION*/void r296set(T296* C,T2 a1,T2 a2,T10 a3,T0* a4);
/*POSITION*/void r296set_in_ini_file(T296* C,T2 a1,T2 a2,T10 a3);
/*POSITION*/T0* r296id_provider(void);
extern T752 oBC296class_text_storage;
/*POSITION*/T6 r296before(T296* C,T296 a1);
/*POSITION*/T6 r296same_line_as(T296* C,T296 a1);
/*POSITION*/void r296set_in_ace_file(T296* C,T2 a1,T2 a2);
/*POSITION*/T0* r296class_text_name(T296* C);
/*HASHED_STRING*/T6 r60is_equal(T60* C,T0* a1);
/*HASHED_STRING*/void r60set(T60* C,T0* a1);
/*HASHED_STRING*/T6 r60is_tuple_related(T60* C);
/*HASHED_STRING*/void r60make(T60* C,T0* a1,T2 a2);
/*STD_OUTPUT*/void r45flush(T45* C);
/*STD_OUTPUT*/void r45disconnect(T45* C);
/*STD_OUTPUT*/void r45write_buffer(T45* C);
/*STD_OUTPUT*/void r45put_new_line(T45* C);
/*STD_OUTPUT*/T0* r45tmp_string(void);
/*STD_OUTPUT*/void r45put_integer(T45* C,T11 a1);
/*STD_OUTPUT*/void r45se_atexit(void);
/*STD_OUTPUT*/void r45put_real_format(T45* C,T5 a1,T2 a2);
/*STD_OUTPUT*/void r45put_character(T45* C,T3 a1);
/*STD_OUTPUT*/void r45put_string(T45* C,T0* a1);
extern T0*oBC13std_output;
extern int fBC13std_output;
/*STD_OUTPUT*/T0* r45std_output(void);
/*STD_OUTPUT*/void r45filtered_put_character(T45* C,T3 a1);
/*STD_OUTPUT*/void r45make(T45* C);
/*STD_OUTPUT*/void r45filtered_flush(T45* C);
/*STD_ERROR*/void r32flush(void);
/*STD_ERROR*/void r32disconnect(T32* C);
/*STD_ERROR*/void r32put_new_line(void);
/*STD_ERROR*/T0* r32tmp_string(void);
/*STD_ERROR*/void r32put_integer(T11 a1);
/*STD_ERROR*/void r32put_real_format(T5 a1,T2 a2);
/*STD_ERROR*/void r32put_character(T3 a1);
/*STD_ERROR*/void r32put_string(T0* a1);
/*STD_ERROR*/T0* r32std_output(void);
/*STD_ERROR*/void r32filtered_put_character(T3 a1);
/*STD_ERROR*/void r32filtered_flush(void);
/*TEXT_FILE_WRITE*/void r280flush(T280* C);
/*TEXT_FILE_WRITE*/void r280disconnect(T280* C);
/*TEXT_FILE_WRITE*/void r280connect_to(T280* C,T0* a1);
/*TEXT_FILE_WRITE*/T6 r280is_connected(T280* C);
/*TEXT_FILE_WRITE*/void r280write_buffer(T280* C);
/*TEXT_FILE_WRITE*/void r280put_new_line(T280* C);
/*TEXT_FILE_WRITE*/T0* r280tmp_string(void);
/*TEXT_FILE_WRITE*/void r280put_integer(T280* C,T11 a1);
/*TEXT_FILE_WRITE*/T11 r280character_count(T280* C);
/*TEXT_FILE_WRITE*/void r280put_real_format(T280* C,T5 a1,T2 a2);
/*TEXT_FILE_WRITE*/void r280put_character(T280* C,T3 a1);
/*TEXT_FILE_WRITE*/void r280put_string(T280* C,T0* a1);
/*TEXT_FILE_WRITE*/void r280make(T280* C);
/*TEXT_FILE_WRITE*/void r280filtered_put_character(T280* C,T3 a1);
/*TEXT_FILE_WRITE*/void r280filtered_flush(T280* C);
int create477(void);
/*SYSTEM*/T0* r477get_environment_variable(T0* a1);
int create254(void);
/*FILE_TOOLS*/T6 r254is_empty(T0* a1);
/*FILE_TOOLS*/T6 r254file_exists(T0* a1);
/*FILE_TOOLS*/void r254rename_to(T0* a1,T0* a2);
/*FILE_TOOLS*/T6 r254is_file(T0* a1);
extern T0*oBC254tfr1;
extern T0*oBC254tfr2;
/*FILE_TOOLS*/T6 r254same_files(T0* a1,T0* a2);
/*FILE_TOOLS*/T6 r254is_directory(T0* a1);
/*FILE_TOOLS*/T6 r254same_physical_file(T0* a1,T0* a2);
/*FILE_TOOLS*/void r254delete(T0* a1);
/*FILE_TOOLS*/T6 r254is_readable(T0* a1);
typedef struct _se_agenT232C232l661c14 se_agenT232C232l661c14;
struct _se_agenT232C232l661c14{Tid id;
int creation_mold_id;
void(*afp)(se_agenT232C232l661c14*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* c0;};
typedef struct _se_agent_eqC232_r232initialize_generator_of se_agent_eqC232_r232initialize_generator_of;
struct _se_agent_eqC232_r232initialize_generator_of{Tid id;
int creation_mold_id;
void*afp;
void*eq;
T0* c0;};
/*agent creation*/T0*agenT232C232l661c14(T0* c0);
/*agent equality*/int eq_agent_eqC232_r232initialize_generator_of(se_agent*u1, se_agent*u2);
typedef struct _se_agenT232C232l597c14 se_agenT232C232l597c14;
struct _se_agenT232C232l597c14{Tid id;
int creation_mold_id;
void(*afp)(se_agenT232C232l597c14*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* c0;};
typedef struct _se_agent_eqC232_r232initialize_path_table_of se_agent_eqC232_r232initialize_path_table_of;
struct _se_agent_eqC232_r232initialize_path_table_of{Tid id;
int creation_mold_id;
void*afp;
void*eq;
T0* c0;};
/*agent creation*/T0*agenT232C232l597c14(T0* c0);
/*agent equality*/int eq_agent_eqC232_r232initialize_path_table_of(se_agent*u1, se_agent*u2);
/*C_PRETTY_PRINTER*/void r232se_evobt(T232* C,T0* a1,T0* a2,T0* a3);
/*C_PRETTY_PRINTER*/void r232get_started(T232* C);
/*C_PRETTY_PRINTER*/void r232echo_information(T232* C);
/*C_PRETTY_PRINTER*/void r232stack_overflow(T232* C);
/*C_PRETTY_PRINTER*/void r232stack_push(T232* C,T2 a1);
/*C_PRETTY_PRINTER*/void r232incr_real_procedure_count(T232* C);
/*C_PRETTY_PRINTER*/int r232switch_collection(void);
/*C_PRETTY_PRINTER*/T2 r232nb_errors(void);
/*C_PRETTY_PRINTER*/void r232incr_procedure_count(T232* C);
/*C_PRETTY_PRINTER*/T0* r232run_features(void);
/*C_PRETTY_PRINTER*/T0* r232new_context(T2 a1);
/*C_PRETTY_PRINTER*/void r232incr_function_count(T232* C);
/*C_PRETTY_PRINTER*/T0* r232stack_top(T232* C);
/*C_PRETTY_PRINTER*/void r232free_context(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/T0* r232reserve_context(T232* C,T2 a1);
/*C_PRETTY_PRINTER*/void r232push_precursor(T232* C,T0* a1,T0* a2,T0* a3);
/*C_PRETTY_PRINTER*/void r232compile(T232* C);
/*C_PRETTY_PRINTER*/T0* r232system_tools(void);
/*C_PRETTY_PRINTER*/void r232push_check(T232* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*C_PRETTY_PRINTER*/void r232incr_direct_call_count(T232* C);
/*C_PRETTY_PRINTER*/void r232push_direct(T232* C,T0* a1,T0* a2,T0* a3,T0* a4);
extern T0*oBC28tmp_path;
extern int fBC28tmp_path;
/*C_PRETTY_PRINTER*/T0* r232tmp_path(void);
/*C_PRETTY_PRINTER*/T0* r232cecil_pool(void);
/*C_PRETTY_PRINTER*/void r232incr_real_function_count(T232* C);
/*C_PRETTY_PRINTER*/void r232incr_switched_call_count(T232* C);
/*C_PRETTY_PRINTER*/T6 r232dispatch_special(T0* a1,T0* a2,T0* a3);
/*C_PRETTY_PRINTER*/void r232pop(T232* C);
extern T0*oBC229context_stack;
extern int fBC229context_stack;
/*C_PRETTY_PRINTER*/T0* r232context_stack(void);
/*C_PRETTY_PRINTER*/void r232put_cpc(T232* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*C_PRETTY_PRINTER*/T0* r232live_type_map(void);
/*C_PRETTY_PRINTER*/T0* r232echo(void);
/*C_PRETTY_PRINTER*/void r232inside_twin(T232* C,T0* a1,T0* a2);
/*C_PRETTY_PRINTER*/T0* r232id_provider(void);
/*C_PRETTY_PRINTER*/void r232put_position(T296 a1);
/*C_PRETTY_PRINTER*/void r232put_trace_or_sedb_instruction(T296 a1);
/*C_PRETTY_PRINTER*/void r232inside_switch_call(T232* C,T0* a1,T0* a2);
extern T0*oBC232pending_c_function_signature;
extern int fBC232pending_c_function_signature;
/*C_PRETTY_PRINTER*/T0* r232pending_c_function_signature(void);
/*C_PRETTY_PRINTER*/void r232put_ith_argument(T232* C,T2 a1);
/*C_PRETTY_PRINTER*/void r232recompilation_comment(T0* a1);
/*C_PRETTY_PRINTER*/void r232put_h_file(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/T2 r232internal_c_local_stack_level(void);
/*C_PRETTY_PRINTER*/T6 r232use_c_function_call_for_attribute_read(T232* C);
/*C_PRETTY_PRINTER*/void r232write_out_h_buffer(T232* C);
extern T0*oBC232initialize_path_table_of_class_text;
extern int fBC232initialize_path_table_of_class_text;
/*C_PRETTY_PRINTER*/T0* r232initialize_path_table_of_class_text(T232* C);
extern T0*oBC232c_frame_descriptor_format;
extern int fBC232c_frame_descriptor_format;
/*C_PRETTY_PRINTER*/T0* r232c_frame_descriptor_format(void);
extern T0*oBC232path_make;
extern int fBC232path_make;
/*C_PRETTY_PRINTER*/T0* r232path_make(void);
/*C_PRETTY_PRINTER*/void r232write_extern_array_1(T232* C,T0* a1,T2 a2,T0* a3);
/*C_PRETTY_PRINTER*/void r232array_access(T3 a1,T2 a2);
/*C_PRETTY_PRINTER*/void r232set_dump_stack_top_for(T0* a1,T0* a2,T0* a3);
/*C_PRETTY_PRINTER*/void r232write_extern_array_2(T232* C,T0* a1,T2 a2);
/*C_PRETTY_PRINTER*/void r232put_arguments(T232* C,T2 a1);
/*C_PRETTY_PRINTER*/void r232put_c_file(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/void r232put_banner(T0* a1);
/*C_PRETTY_PRINTER*/void r232write_out_c_buffer(T232* C);
/*C_PRETTY_PRINTER*/void r232initialize_generating_type(void);
/*C_PRETTY_PRINTER*/void r232print_local(T0* a1);
/*C_PRETTY_PRINTER*/T0* r232need_invariant(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/void r232check_assertion(T232* C,T0* a1,T0* a2,T0* a3);
/*C_PRETTY_PRINTER*/void r232include_register(T232* C,T296 a1,T0* a2);
/*C_PRETTY_PRINTER*/void r232really_define_c_main(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/void r232initialize_path_table(T232* C);
/*C_PRETTY_PRINTER*/void r232add_include(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/void r232write_extern_2(T232* C,T0* a1,T0* a2);
/*C_PRETTY_PRINTER*/void r232write_extern_1(T232* C,T0* a1);
extern T0*oBC232path_c;
extern int fBC232path_c;
/*C_PRETTY_PRINTER*/T0* r232path_c(T232* C);
/*C_PRETTY_PRINTER*/void r232define_initialize_eiffel_runtime(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/void r232write_extern_0(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/void r232initialize_generator_of(T0* a1);
/*C_PRETTY_PRINTER*/void r232initialize_size_table(T232* C);
/*C_PRETTY_PRINTER*/void r232push_pop_cpc(T232* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
/*C_PRETTY_PRINTER*/void r232write_make_file(T232* C);
extern T0*oBC232path_h;
extern int fBC232path_h;
/*C_PRETTY_PRINTER*/T0* r232path_h(void);
/*C_PRETTY_PRINTER*/void r232put_inspect_tmp(T232* C);
/*C_PRETTY_PRINTER*/void r232print_argument(T2 a1);
/*C_PRETTY_PRINTER*/void r232backup_tfw_connect(T232* C,T0* a1);
extern T0*oBC232c_frame_descriptor_locals;
extern int fBC232c_frame_descriptor_locals;
/*C_PRETTY_PRINTER*/T0* r232c_frame_descriptor_locals(void);
/*C_PRETTY_PRINTER*/void r232define_extern_tables(T232* C);
extern T0*oBC232out_c_buffer;
extern int fBC232out_c_buffer;
/*C_PRETTY_PRINTER*/T0* r232out_c_buffer(void);
/*C_PRETTY_PRINTER*/void r232cecil_define(T232* C);
extern T0*oBC232c_code;
extern int fBC232c_code;
/*C_PRETTY_PRINTER*/T0* r232c_code(void);
extern T0*oBC232tmp_string;
extern int fBC232tmp_string;
/*C_PRETTY_PRINTER*/T0* r232tmp_string(void);
/*C_PRETTY_PRINTER*/T0* r232class_invariants(void);
/*C_PRETTY_PRINTER*/void r232connect_cecil_out_h(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/void r232put_target_generating_type(T232* C,T0* a1);
extern T0*oBC232out_h_buffer;
extern int fBC232out_h_buffer;
/*C_PRETTY_PRINTER*/T0* r232out_h_buffer(void);
/*C_PRETTY_PRINTER*/void r232customize_runtime(T232* C);
/*C_PRETTY_PRINTER*/T2 r232class_invariant_call_opening(T232* C,T0* a1,T6 a2);
/*C_PRETTY_PRINTER*/void r232show_profile(void);
/*C_PRETTY_PRINTER*/void r232push_create_instruction(T232* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*C_PRETTY_PRINTER*/void r232use_switch(T232* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*C_PRETTY_PRINTER*/void r232put_position_comment_on(T0* a1,T296 a2);
extern T0*oBC232internal_c_local_list;
/*C_PRETTY_PRINTER*/void r232path_c_in(T0* a1,T2 a2);
/*C_PRETTY_PRINTER*/void r232split_c_file_padding_here(T232* C);
/*C_PRETTY_PRINTER*/T0* r232get_inline_ms(T232* C);
/*C_PRETTY_PRINTER*/void r232put_sedb_breakpoint(T232* C);
/*C_PRETTY_PRINTER*/void r232current_class_invariant(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/void r232put_c_inline_c(T232* C);
/*C_PRETTY_PRINTER*/void r232dump_pending_c_function(T232* C,T6 a1);
/*C_PRETTY_PRINTER*/void r232put_c_inline_h(T232* C);
/*C_PRETTY_PRINTER*/void r232put_error0(T0* a1);
/*C_PRETTY_PRINTER*/void r232common_put_target(T232* C);
/*C_PRETTY_PRINTER*/void r232h_connect(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/T0* r232pending_c_function_lock_local(T0* a1);
/*C_PRETTY_PRINTER*/void r232define_main(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/void r232target_position_in_error_handler(T232* C);
/*C_PRETTY_PRINTER*/void r232trace_boolean_expression(T0* a1,T0* a2);
/*C_PRETTY_PRINTER*/void r232put_position_comment_in(T0* a1,T296 a2);
/*C_PRETTY_PRINTER*/void r232se_string(T0* a1);
/*C_PRETTY_PRINTER*/void r232sys_runtime_h_and_c(T232* C,T0* a1);
extern T0*oBC232out_make;
extern int fBC232out_make;
/*C_PRETTY_PRINTER*/T0* r232out_make(void);
/*C_PRETTY_PRINTER*/void r232push_create_expression(T232* C,T0* a1,T0* a2,T0* a3);
/*C_PRETTY_PRINTER*/void r232prepare_introspection(void);
/*C_PRETTY_PRINTER*/void r232do_write_make_file(T232* C);
/*C_PRETTY_PRINTER*/void r232put_target_as_target(T232* C);
/*C_PRETTY_PRINTER*/void r232initialize_generator(T232* C);
/*C_PRETTY_PRINTER*/void r232c_plus_plus_register(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/T0* r232agent_creations(void);
/*C_PRETTY_PRINTER*/void r232c_connect(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/void r232end_c_linkage(T0* a1);
extern T0*oBC232initialize_generator_of_class_text;
extern int fBC232initialize_generator_of_class_text;
/*C_PRETTY_PRINTER*/T0* r232initialize_generator_of_class_text(T232* C);
/*C_PRETTY_PRINTER*/void r232split_c_file_now(T232* C);
/*C_PRETTY_PRINTER*/void r232inspect_tmp_decrement(T232* C);
/*C_PRETTY_PRINTER*/void r232stop_recursive_assertion_closing(T6 a1);
/*C_PRETTY_PRINTER*/void r232c_plus_plus_definitions(T232* C);
/*C_PRETTY_PRINTER*/void r232compile_routines(void);
/*C_PRETTY_PRINTER*/void r232put_target_as_value(T232* C);
/*C_PRETTY_PRINTER*/void r232put_target_generator(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/T6 r232cannot_drop_all(T232* C);
/*C_PRETTY_PRINTER*/void r232put_object_size(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/void r232inspect_tmp_increment(T232* C);
/*C_PRETTY_PRINTER*/void r232add_include_on(T0* a1,T0* a2);
/*C_PRETTY_PRINTER*/void r232variant_check(T0* a1,T0* a2);
/*C_PRETTY_PRINTER*/void r232put_trace_or_sedb_expression(T296 a1);
/*C_PRETTY_PRINTER*/T6 r232arguments_cannot_be_dropped(T232* C);
extern T0*oBC232c_inline_h_mem;
extern int fBC232c_inline_h_mem;
/*C_PRETTY_PRINTER*/T0* r232c_inline_h_mem(void);
/*C_PRETTY_PRINTER*/void r232put_direct(T232* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*C_PRETTY_PRINTER*/void r232begin_c_linkage(T0* a1);
/*C_PRETTY_PRINTER*/void r232add_first_include(T232* C,T0* a1);
/*C_PRETTY_PRINTER*/void r232put_position_comment(T296 a1);
/*C_PRETTY_PRINTER*/void r232macro_def(T232* C,T0* a1,T2 a2);
/*C_PRETTY_PRINTER*/T6 r232target_cannot_be_dropped(T232* C);
/*C_PRETTY_PRINTER*/void r232put_trace_switch(T232* C);
/*C_PRETTY_PRINTER*/void r232put_file(T232* C,T0* a1,T0* a2);
/*C_PRETTY_PRINTER*/void r232echo_make(T0* a1);
/*C_PRETTY_PRINTER*/void r232initialize_path_table_of(T0* a1);
/*C_PRETTY_PRINTER*/T0* r232agent_switches(void);
/*C_PRETTY_PRINTER*/void r232class_invariant_call_closing(T2 a1,T6 a2);
/*C_PRETTY_PRINTER*/void r232initialize_profile(void);
/*C_PRETTY_PRINTER*/void r232put_position_in_ds(T296 a1);
extern T0*oBC232pending_c_function_body;
extern int fBC232pending_c_function_body;
/*C_PRETTY_PRINTER*/T0* r232pending_c_function_body(void);
/*C_PRETTY_PRINTER*/void r232prepare_c_function(T232* C);
/*C_PRETTY_PRINTER*/void r232check_id(T232* C,T0* a1,T0* a2,T2 a3);
/*C_PRETTY_PRINTER*/void r232stop_recursive_assertion_opening(T6 a1);
/*ERROR_HANDLER*/void r63display_lines(void);
/*ERROR_HANDLER*/void r63print_as_fatal_error(T63* C);
/*ERROR_HANDLER*/void r63print_as_internal_error(T63* C);
/*ERROR_HANDLER*/void r63append_integer(T2 a1);
/*ERROR_HANDLER*/void r63put_arrows_into(T0* a1,T0* a2);
/*ERROR_HANDLER*/void r63add_type_mark(T0* a1);
/*ERROR_HANDLER*/T0* r63get_line(T0* a1,T2 a2);
/*ERROR_HANDLER*/T6 r63is_empty(void);
/*ERROR_HANDLER*/void r63print_error_header(T0* a1,T0* a2,T2 a3,T0* a4);
/*ERROR_HANDLER*/void r63add_context_info(T0* a1);
/*ERROR_HANDLER*/void r63cancel(void);
/*ERROR_HANDLER*/void r63add_expression(T0* a1);
/*ERROR_HANDLER*/void r63do_print(T0* a1);
/*ERROR_HANDLER*/T2 r63detab_line(T0* a1);
extern T0*oBC63explanation;
extern int fBC63explanation;
/*ERROR_HANDLER*/T0* r63explanation(void);
/*ERROR_HANDLER*/void r63print_as_error(T63* C);
/*ERROR_HANDLER*/void r63print_spaces(T2 a1);
/*ERROR_HANDLER*/void r63add_feature_name(T0* a1);
extern T0*oBC63positions;
extern int fBC63positions;
/*ERROR_HANDLER*/T0* r63positions(void);
/*ERROR_HANDLER*/void r63crash(T63* C);
/*ERROR_HANDLER*/void r63add_type(T0* a1);
/*ERROR_HANDLER*/void r63get_positions_on_same_line(T0* a1);
/*ERROR_HANDLER*/void r63add_position(T296 a1);
/*ERROR_HANDLER*/void r63print_as_warning(T63* C);
/*ERROR_HANDLER*/T0* r63echo(void);
T59*create59(void);
/*CECIL_POOL*/void r59collect(T59* C);
/*CECIL_POOL*/void r59add_cecil_file(T59* C,T0* a1);
/*CECIL_POOL*/void r59parse_cecil_files(T59* C);
/*CECIL_POOL*/void r59c_define_for(T0* a1);
/*CECIL_POOL*/void r59c_define_body_of(T0* a1,T6 a2);
/*CECIL_POOL*/void r59c_define_users(T59* C);
/*CECIL_POOL*/T0* r59effective_arg_list(T0* a1);
/*CECIL_POOL*/T0* r59echo(void);
/*GC_HANDLER*/void r219just_before_mark(T0* a1);
/*GC_HANDLER*/void r219c_dicho(T0* a1,T2 a2,T2 a3);
/*GC_HANDLER*/void r219manifest_string_in(T219* C,T0* a1,T6 a2);
/*GC_HANDLER*/void r219memory_dispose(T219* C,T0* a1,T0* a2);
/*GC_HANDLER*/void r219switch_for(T0* a1);
/*GC_HANDLER*/void r219compute_ceils(void);
/*GC_HANDLER*/void r219native9_in(T219* C,T0* a1,T6 a2);
/*GC_HANDLER*/void r219customize_c_runtime(T219* C);
/*GC_HANDLER*/void r219set_info_flag(T219* C);
/*GC_HANDLER*/void r219define_gc_start(T219* C,T0* a1,T0* a2);
/*GC_HANDLER*/void r219initialize_runtime(T219* C);
/*GC_HANDLER*/void r219allocation_of(T219* C,T0* a1,T0* a2);
/*GC_HANDLER*/void r219no_gc(T219* C);
/*GC_HANDLER*/void r219define1(void);
/*GC_HANDLER*/void r219define2(T219* C);
/*GC_HANDLER*/void r219initialize_user_expanded_attributes(T0* a1,T0* a2);
/*GC_HANDLER*/void r219gc_info_before_exit(T219* C);
extern T0*oBC219switch_list;
extern int fBC219switch_list;
/*GC_HANDLER*/T0* r219switch_list(void);
/*GC_HANDLER*/void r219mark_for(T0* a1,T0* a2,T6 a3);
/*GC_HANDLER*/void r219define_gc_info(T0* a1);
/*GC_HANDLER*/T0* r219echo(void);
T704*create704(void);
/*C_PLUGIN_FACTORY*/T0* r704new(T296 a1,T0* a2,T0* a3);
/*EIFFEL_PARSER*/T6 r241a_keyword_precursor(T241* C);
/*EIFFEL_PARSER*/T6 r241a_prefix(T241* C);
/*EIFFEL_PARSER*/T6 r241a_class_name(T241* C);
extern T0*oBC241xor_name;
extern int fBC241xor_name;
/*EIFFEL_PARSER*/T0* r241xor_name(void);
/*EIFFEL_PARSER*/T6 r241a_feature_declaration(T241* C);
/*EIFFEL_PARSER*/void r241void_current_comparison_check_(T0* a1,T0* a2);
/*EIFFEL_PARSER*/T0* r241connect_to_cecil(T241* C,T0* a1);
/*EIFFEL_PARSER*/T6 r241a_keyword_void(T241* C);
/*EIFFEL_PARSER*/T6 r241a_actual(T241* C);
/*EIFFEL_PARSER*/T0* r241analyse_class(T241* C,T0* a1,T0* a2);
/*EIFFEL_PARSER*/T0* r241a_then_compound(T241* C);
/*EIFFEL_PARSER*/T6 r241a_manifest_or_type_test(T241* C,T1 a1);
/*EIFFEL_PARSER*/T6 r241a_when_part(T241* C,T0* a1);
/*EIFFEL_PARSER*/T6 r241a_debug(T241* C);
/*EIFFEL_PARSER*/T6 r241a_rename_pair(T241* C);
/*EIFFEL_PARSER*/void r241a_indexing(T241* C);
/*EIFFEL_PARSER*/T0* r241a_precursor_type_mark(T241* C,T296 a1);
/*EIFFEL_PARSER*/T6 r241a_inspect(T241* C);
/*EIFFEL_PARSER*/T6 r241a_e10(T241* C);
/*EIFFEL_PARSER*/T6 r241a_base_class_name(T241* C);
/*EIFFEL_PARSER*/T6 r241a_argument(T241* C);
extern T0*oBC241and_name;
extern int fBC241and_name;
/*EIFFEL_PARSER*/T0* r241and_name(void);
/*EIFFEL_PARSER*/T6 r241skip1unless2(T241* C,T3 a1,T3 a2);
/*EIFFEL_PARSER*/T6 r241a_infix(T241* C);
/*EIFFEL_PARSER*/void r241no_void_check(T0* a1,T0* a2);
/*EIFFEL_PARSER*/void r241a_procedure_call(T241* C);
extern T0*oBC241backslash_backslash_name;
extern int fBC241backslash_backslash_name;
/*EIFFEL_PARSER*/T0* r241backslash_backslash_name(void);
/*EIFFEL_PARSER*/T0* r241parse_c_name(T241* C);
/*EIFFEL_PARSER*/T6 r241a_parent_edge(T241* C,T6 a1);
/*EIFFEL_PARSER*/void r241err_exp(T296 a1,T6 a2,T0* a3);
/*EIFFEL_PARSER*/T6 r241a_e1(T241* C);
extern T0*oBC241faof;
extern int fBC241faof;
/*EIFFEL_PARSER*/T0* r241faof(void);
/*EIFFEL_PARSER*/T6 r241a_e2(T241* C);
/*EIFFEL_PARSER*/T6 r241a_formal_generic_type_mark(T241* C);
/*EIFFEL_PARSER*/T6 r241a_e3(T241* C);
/*EIFFEL_PARSER*/T6 r241a_e4(T241* C);
/*EIFFEL_PARSER*/T6 r241a_boolean_constant(T241* C);
/*EIFFEL_PARSER*/T6 r241a_e5(T241* C);
/*EIFFEL_PARSER*/T6 r241a_e6(T241* C);
/*EIFFEL_PARSER*/T6 r241a_e7(T241* C);
/*EIFFEL_PARSER*/T6 r241a_e8(T241* C);
/*EIFFEL_PARSER*/T6 r241a_e9(T241* C);
/*EIFFEL_PARSER*/T6 r241a_unary(T241* C);
extern T0*oBC241slash_slash_name;
extern int fBC241slash_slash_name;
/*EIFFEL_PARSER*/T0* r241slash_slash_name(void);
/*EIFFEL_PARSER*/T0* r241a_clients(T241* C);
/*EIFFEL_PARSER*/T0* r241mandatory_writable(T241* C);
extern T0*oBC241slash_name;
extern int fBC241slash_name;
/*EIFFEL_PARSER*/T0* r241slash_name(void);
/*EIFFEL_PARSER*/T6 r241a_free_operator_definition(T241* C,T6 a1);
/*EIFFEL_PARSER*/void r241a_local_var_list(T241* C);
/*EIFFEL_PARSER*/void r241anchored_creation_check(T0* a1);
/*EIFFEL_PARSER*/T6 r241a_assignment_or_procedure_call(T241* C);
/*EIFFEL_PARSER*/T6 r241a_type_mark(T241* C);
extern T0*oBC241lt_name;
extern int fBC241lt_name;
/*EIFFEL_PARSER*/T0* r241lt_name(void);
/*EIFFEL_PARSER*/void r241show_nb_errors(void);
/*EIFFEL_PARSER*/T6 r241a_local_name2(T241* C);
/*EIFFEL_PARSER*/void r241a_formal_generic_list(T241* C);
/*EIFFEL_PARSER*/T6 r241a_local_name1(T241* C);
extern T0*oBC241implies_name;
extern int fBC241implies_name;
/*EIFFEL_PARSER*/T0* r241implies_name(void);
/*EIFFEL_PARSER*/T0* r241buffer(void);
/*EIFFEL_PARSER*/T6 r241a_keyword_current(T241* C);
/*EIFFEL_PARSER*/void r241create_infix_prefix(T241* C,T6 a1,T2 a2,T2 a3);
extern T0*oBC241muls_name;
extern int fBC241muls_name;
/*EIFFEL_PARSER*/T0* r241muls_name(void);
/*EIFFEL_PARSER*/T6 r241a_ordinary_feature_name_or_local_name(T241* C);
/*EIFFEL_PARSER*/T2 r241nb_errors(void);
/*EIFFEL_PARSER*/void r241a_r1(T241* C,T0* a1);
/*EIFFEL_PARSER*/void r241a_r2(T241* C,T0* a1);
/*EIFFEL_PARSER*/void r241a_r3(T241* C,T0* a1);
/*EIFFEL_PARSER*/void r241a_r4(T241* C,T0* a1);
/*EIFFEL_PARSER*/void r241a_r5(T241* C,T0* a1);
/*EIFFEL_PARSER*/void r241a_r6(T241* C,T0* a1);
/*EIFFEL_PARSER*/T0* r241get_comment(T241* C);
/*EIFFEL_PARSER*/T6 r241a_keyword_false(T241* C);
/*EIFFEL_PARSER*/T0* r241parse_feature_name(T241* C);
/*EIFFEL_PARSER*/void r241unknown_external_language(T0* a1);
/*EIFFEL_PARSER*/void r241a_r7(T241* C,T0* a1);
/*EIFFEL_PARSER*/T6 r241a_create_expression(T241* C);
/*EIFFEL_PARSER*/void r241a_r8(T241* C,T0* a1);
/*EIFFEL_PARSER*/void r241integer_overflow_error(T241* C,T2 a1,T2 a2,T0* a3);
/*EIFFEL_PARSER*/T6 r241a_check(T241* C);
/*EIFFEL_PARSER*/T6 r241a_constant_allowed_in_when_of_inspect(T241* C);
extern T0*oBC241a_assertion_buffer;
extern int fBC241a_assertion_buffer;
/*EIFFEL_PARSER*/T0* r241a_assertion_buffer(void);
/*EIFFEL_PARSER*/void r241a_parent_list(T241* C);
/*EIFFEL_PARSER*/T6 r241a_keyword_result(T241* C);
/*EIFFEL_PARSER*/void r241void_current_comparison_check(T0* a1,T0* a2);
extern T0*oBC241sharp_muls_name;
extern int fBC241sharp_muls_name;
/*EIFFEL_PARSER*/T0* r241sharp_muls_name(void);
extern T0*oBC241gt_name;
extern int fBC241gt_name;
/*EIFFEL_PARSER*/T0* r241gt_name(void);
/*EIFFEL_PARSER*/void r241a_class_declaration(T241* C);
/*EIFFEL_PARSER*/T6 r241parse_cecil_is_creation(T241* C);
extern T0*oBC241pow_name;
extern int fBC241pow_name;
/*EIFFEL_PARSER*/T0* r241pow_name(void);
/*EIFFEL_PARSER*/T0* r241a_actuals(T241* C);
/*EIFFEL_PARSER*/T6 r241a_expression(T241* C);
/*EIFFEL_PARSER*/void r241no_void_after_elseif_check(T0* a1);
/*EIFFEL_PARSER*/void r241a_base_class_name1(T241* C);
/*EIFFEL_PARSER*/void r241error_handler_append_info_about_feature_name(void);
/*EIFFEL_PARSER*/T0* r241parser_buffer(void);
extern T0*oBC241sharp_minus_name;
extern int fBC241sharp_minus_name;
/*EIFFEL_PARSER*/T0* r241sharp_minus_name(void);
/*EIFFEL_PARSER*/T0* r241echo(void);
/*EIFFEL_PARSER*/T0* r241lcs(void);
/*EIFFEL_PARSER*/T0* r241and_then_name(void);
/*EIFFEL_PARSER*/T0* r241or_else_name(void);
/*EIFFEL_PARSER*/void r241go_back_at(T241* C,T2 a1,T2 a2);
/*EIFFEL_PARSER*/T6 r241skip1(T241* C,T3 a1);
/*EIFFEL_PARSER*/T296 r241current_position(T241* C);
/*EIFFEL_PARSER*/T6 r241a_keyword(T241* C,T0* a1);
/*EIFFEL_PARSER*/T6 r241a_manifest_string(T241* C,T6 a1);
/*EIFFEL_PARSER*/void r241skip_comments(T241* C);
/*EIFFEL_PARSER*/void r241next_char(T241* C);
/*EIFFEL_PARSER*/void r241update_last_manifest_string(T241* C,T296 a1,T6 a2,T6 a3,T0* a4,T0* a5);
/*EIFFEL_PARSER*/T296 r241pos(T241* C,T2 a1,T2 a2);
/*EIFFEL_PARSER*/T0* r241id_provider(void);
/*EIFFEL_PARSER*/T2 r241nb_warnings(void);
/*EIFFEL_PARSER*/T6 r241skip2(T241* C,T3 a1,T3 a2);
/*EIFFEL_PARSER*/void r241disconnect(T241* C);
/*EIFFEL_PARSER*/void r241manifest_just_after_a_dot(T241* C,T3 a1,T6 a2,T0* a3);
/*EIFFEL_PARSER*/T0* r241analyse_buffer(T241* C);
/*EIFFEL_PARSER*/T0* r241a_routine(T241* C);
/*EIFFEL_PARSER*/T0* r241parse_type_mark(T241* C);
/*EIFFEL_PARSER*/void r241show_nb(T2 a1,T0* a2);
/*EIFFEL_PARSER*/void r241show_nb_warnings(void);
/*EIFFEL_PARSER*/T0* r241a_compound1(T241* C);
/*EIFFEL_PARSER*/T0* r241a_compound2(T241* C,T0* a1,T0* a2);
/*EIFFEL_PARSER*/void r241a_formal_arg_list(T241* C);
/*EIFFEL_PARSER*/T6 r241a_tag_mark(T241* C);
/*EIFFEL_PARSER*/T6 r241a_instruction(T241* C);
/*EIFFEL_PARSER*/void r241valid_parent_edge_type_check(T0* a1);
extern T6 oBC241no_static_simplify;
extern int fBC241no_static_simplify;
/*EIFFEL_PARSER*/T6 r241no_static_simplify(void);
/*EIFFEL_PARSER*/void r241a_function_call(T241* C);
/*EIFFEL_PARSER*/T0* r241a_routine_body(T241* C);
/*EIFFEL_PARSER*/T0* r241unicode_string_buffer(void);
/*EIFFEL_PARSER*/T0* r241expression_with_comment(T241* C,T0* a1);
/*EIFFEL_PARSER*/T0* r241a_assertion(T241* C);
/*EIFFEL_PARSER*/void r241a_feature_clause(T241* C);
extern T0*oBC241not_name;
extern int fBC241not_name;
/*EIFFEL_PARSER*/T0* r241not_name(void);
/*EIFFEL_PARSER*/T6 r241a_keyword_true(T241* C);
/*EIFFEL_PARSER*/T6 r241a_index_clause(T241* C);
/*EIFFEL_PARSER*/void r241a_creation_clause(T241* C,T296 a1);
/*EIFFEL_PARSER*/void r241a_rename_list(T241* C);
/*EIFFEL_PARSER*/T6 r241a_retry(T241* C);
extern T0*oBC241or_name;
extern int fBC241or_name;
/*EIFFEL_PARSER*/T0* r241or_name(void);
/*EIFFEL_PARSER*/T6 r241a_binary(T241* C,T296 a1);
/*EIFFEL_PARSER*/void r241a_new_export_list(T241* C);
/*EIFFEL_PARSER*/void r241inside_function_precursor_check(T241* C,T0* a1);
/*EIFFEL_PARSER*/T6 r241a_static_type_mark(T241* C);
/*EIFFEL_PARSER*/T6 r241a_character_constant(T241* C,T1 a1);
/*EIFFEL_PARSER*/T0* r241to_proc_call(T241* C,T0* a1,T0* a2,T0* a3);
extern T0*oBC241le_name;
extern int fBC241le_name;
/*EIFFEL_PARSER*/T0* r241le_name(void);
/*EIFFEL_PARSER*/void r241just_after_a_dot(T241* C,T6 a1,T0* a2);
/*EIFFEL_PARSER*/void r241unused_once_warning_check(T241* C);
/*EIFFEL_PARSER*/T6 r241a_feature_name_list(T241* C);
/*EIFFEL_PARSER*/T6 r241a_writable(T241* C);
/*EIFFEL_PARSER*/T6 r241a_index_value(T241* C);
/*EIFFEL_PARSER*/T0* r241static_simplify(T0* a1);
/*EIFFEL_PARSER*/T6 r241a_free_operator_usage(T241* C,T6 a1);
/*EIFFEL_PARSER*/T6 r241a_possibly_frozen_feature_name(T241* C);
extern T0*oBC241plus_name;
extern int fBC241plus_name;
/*EIFFEL_PARSER*/T0* r241plus_name(void);
/*EIFFEL_PARSER*/T6 r241a_base_class_name_inside_client_list(T241* C);
/*EIFFEL_PARSER*/T6 r241a_old_creation(T241* C);
/*EIFFEL_PARSER*/T6 r241a_loop(T241* C);
/*EIFFEL_PARSER*/T6 r241a_conditional(T241* C);
/*EIFFEL_PARSER*/T0* r241to_call(T0* a1,T0* a2,T0* a3);
/*EIFFEL_PARSER*/T6 r241a_feature_name(T241* C);
/*EIFFEL_PARSER*/void r241a_r10(T241* C,T6 a1,T0* a2,T0* a3,T0* a4);
/*EIFFEL_PARSER*/T0* r241a_external(T241* C);
extern T0*oBC241ge_name;
extern int fBC241ge_name;
/*EIFFEL_PARSER*/T0* r241ge_name(void);
extern T0*oBC241minus_name;
extern int fBC241minus_name;
/*EIFFEL_PARSER*/T0* r241minus_name(void);
/*EIFFEL_PARSER*/T6 r241skip3(T241* C,T3 a1,T3 a2,T3 a3);
/*EIFFEL_PARSER*/T6 r241a_create_instruction(T241* C);
extern T0*oBC241sharp_plus_name;
extern int fBC241sharp_plus_name;
/*EIFFEL_PARSER*/T0* r241sharp_plus_name(void);
/*ACE*/T6 r80a_class_name(T80* C);
extern T0*oBC80pov_classes;
extern int fBC80pov_classes;
/*ACE*/T0* r80pov_classes(void);
/*ACE*/T2 r80a_assertion_level(T80* C);
/*ACE*/T6 r80sedb(T80* C);
extern T0*oBC80no_pov_classes;
extern int fBC80no_pov_classes;
/*ACE*/T0* r80no_pov_classes(void);
/*ACE*/T0* r80find_class_text(T0* a1,T6 a2,T6 a3,T0* a4);
/*ACE*/T6 r80a_system_level_defaults(T80* C);
/*ACE*/T2 r80cluster_count(void);
/*ACE*/T0* r80a_debug_key(T80* C);
extern T0*oBC80new_clusters;
extern int fBC80new_clusters;
/*ACE*/T0* r80new_clusters(void);
/*ACE*/T0* r80root_procedure_name(T80* C);
/*ACE*/void r80set_highest_encountered_level(T80* C,T2 a1);
extern T0*oBC80distances_;
extern int fBC80distances_;
/*ACE*/T0* r80distances_(void);
/*ACE*/void r80set_default_trace(T80* C);
/*ACE*/T6 r80no_check(T80* C);
/*ACE*/T0* r80class_name_using(T0* a1);
/*ACE*/T0* r80cluster_of(T0* a1,T6 a2);
/*ACE*/void r80view_in(T80* C,T0* a1);
/*ACE*/void r80get_started(T80* C);
/*ACE*/void r80set_debug_check(T80* C);
/*ACE*/T6 r80all_check(T80* C);
/*ACE*/T0* r80buffer(void);
extern T0*oBC28is_launcher_memory;
/*ACE*/T0* r80system_tools(void);
/*ACE*/T0* r80class_text(T0* a1,T6 a2,T6 a3,T0* a4);
/*ACE*/T0* r80cecil_pool(void);
/*ACE*/T0* r80parser_buffer(void);
/*ACE*/T0* r80echo(void);
/*ACE*/T0* r80lcs(void);
/*ACE*/T6 r80is_launcher(void);
/*ACE*/void r80go_back_at(T80* C,T2 a1,T2 a2);
/*ACE*/T6 r80skip1(T80* C,T3 a1);
/*ACE*/T296 r80current_position(T80* C);
/*ACE*/T6 r80a_keyword(T80* C,T0* a1);
/*ACE*/T6 r80a_manifest_string(T80* C,T6 a1);
/*ACE*/void r80skip_comments(T80* C);
/*ACE*/void r80next_char(T80* C);
/*ACE*/void r80may_expand_var(T80* C);
/*ACE*/T296 r80pos(T2 a1,T2 a2);
/*ACE*/T0* r80a_string(T80* C);
/*ACE*/T0* r80a_identifier(T80* C);
/*ACE*/void r80add_default_debug_key(T80* C,T0* a1);
/*ACE*/T6 r80match_debug_keys(T0* a1,T0* a2);
/*ACE*/T0* r80level_name(T2 a1);
extern T0*oBC80root_class_names;
extern int fBC80root_class_names;
/*ACE*/T0* r80root_class_names(void);
/*ACE*/void r80a_cluster_properties(T80* C);
/*ACE*/void r80a_cluster_mark(T80* C);
/*ACE*/void r80command_line_parsed(T80* C,T0* a1);
/*ACE*/void r80parse_include(T80* C);
extern T0*oBC80universe;
extern int fBC80universe;
/*ACE*/T0* r80universe(void);
/*ACE*/T6 r80a_yes_no_all(T80* C);
/*ACE*/T6 r80a_option_in_cluster_properties(T80* C);
/*ACE*/T0* r80unicode_string_buffer(void);
/*ACE*/void r80set_default_c_mode(T80* C);
/*ACE*/void r80set_command_line_debug(T80* C);
/*ACE*/T6 r80a_cluster_clause(T80* C);
/*ACE*/void r80set_root_class_name_using(T0* a1);
/*ACE*/T6 r80ensure_check(T80* C);
/*ACE*/T6 r80is_debug_checked(T80* C,T0* a1,T0* a2);
/*ACE*/void r80fatal_error_in(T80* C,T0* a1);
/*ACE*/T2 r80class_text_count(void);
/*ACE*/T0* r80a_cecil_file(T80* C);
/*ACE*/T2 r80assertion_level_of(T80* C,T0* a1);
/*ACE*/void r80new_universe_entry(T2 a1,T0* a2,T0* a3);
/*ACE*/void r80set_default_level(T80* C);
/*ACE*/T0* r80best_cluster_of(T0* a1,T0* a2,T6 a3,T0* a4);
/*ACE*/T6 r80a_cluster_clause_list(T80* C);
/*ACE*/T6 r80require_check(T80* C);
/*ACE*/T0* r80root_class_name(void);
/*ACE*/void r80add_loadpath(T0* a1,T0* a2,T2 a3);
/*ACE*/void r80a_generate(T80* C);
extern T0*oBC80clusters_;
extern int fBC80clusters_;
/*ACE*/T0* r80clusters_(void);
/*ACE*/void r80a_external(T80* C);
/*ACE*/void r80analyse_ace_file(T80* C,T0* a1);
/*ACE*/T6 r80trace_of(T80* C,T0* a1);
/*ACE*/T6 r80default_debug(T80* C,T0* a1);
/*SYSTEM_TOOLS*/void r235mandatory_sys_runtime(T235* C,T0* a1,T3 a2);
/*SYSTEM_TOOLS*/void r235add_smarteiffel_c_mode_options(T235* C);
/*SYSTEM_TOOLS*/void r235add_executable_name(T235* C,T0* a1);
/*SYSTEM_TOOLS*/void r235add_x_suffix(T235* C,T0* a1);
/*SYSTEM_TOOLS*/void r235read_loadpath_files(T235* C);
/*SYSTEM_TOOLS*/void r235external_c_files_for_lcc_win32(T235* C,T0* a1);
/*SYSTEM_TOOLS*/T2 r235extra_arg(T235* C,T0* a1,T2 a2,T0* a3);
/*SYSTEM_TOOLS*/void r235set_c_mode(T235* C,T0* a1);
extern T0*oBC235id_file_path;
extern int fBC235id_file_path;
/*SYSTEM_TOOLS*/T0* r235id_file_path(T235* C);
/*SYSTEM_TOOLS*/void r235add_lib_math_do_it_again(T235* C);
/*SYSTEM_TOOLS*/void r235verify_system_name(T235* C);
/*SYSTEM_TOOLS*/void r235set_alternate_c_mode(T235* C,T0* a1);
/*SYSTEM_TOOLS*/T0* r235strip_executable(T235* C);
extern T0*oBC235c_mode_memory;
extern int fBC235c_mode_memory;
/*SYSTEM_TOOLS*/T0* r235c_mode_memory(void);
/*SYSTEM_TOOLS*/T0* r235strip_path_or_default(T235* C,T0* a1);
/*SYSTEM_TOOLS*/T0* r235h_precompiler_command(T235* C,T0* a1);
extern T0*oBC235cluster_directory;
extern int fBC235cluster_directory;
/*SYSTEM_TOOLS*/T0* r235cluster_directory(void);
/*SYSTEM_TOOLS*/void r235environment_variable_substitution(T235* C,T0* a1,T0* a2);
/*SYSTEM_TOOLS*/void r235add_objects_(T235* C,T0* a1,T0* a2,T2 a3,T2 a4);
/*SYSTEM_TOOLS*/void r235system_name_in(T235* C,T0* a1);
extern T0*oBC235make_suffix;
extern int fBC235make_suffix;
/*SYSTEM_TOOLS*/T0* r235make_suffix(T235* C);
/*SYSTEM_TOOLS*/void r235get_started(T235* C);
extern T0*oBC235object_suffix;
extern int fBC235object_suffix;
/*SYSTEM_TOOLS*/T0* r235object_suffix(T235* C);
/*SYSTEM_TOOLS*/void r235subdirectory(T235* C,T0* a1,T0* a2);
/*SYSTEM_TOOLS*/T0* r235linker_path_of(T0* a1);
/*SYSTEM_TOOLS*/T0* r235linker_command(T235* C,T0* a1,T2 a2);
/*SYSTEM_TOOLS*/void r235parent_directory(T235* C,T0* a1);
/*SYSTEM_TOOLS*/void r235show_compiler_list_then_exit(T235* C,T0* a1);
/*SYSTEM_TOOLS*/T6 r235precompile_header_supported(T235* C);
/*SYSTEM_TOOLS*/void r235add_external_lib(T235* C,T0* a1);
/*SYSTEM_TOOLS*/void r235add_loadpath_file(T235* C,T0* a1);
/*SYSTEM_TOOLS*/T0* r235compiler_path_of(T0* a1);
/*SYSTEM_TOOLS*/void r235add_external_header_path(T0* a1);
extern int fBC235set_config;
/*SYSTEM_TOOLS*/void r235set_config(T235* C);
/*SYSTEM_TOOLS*/T6 r235is_c_plus_plus_file_path(T0* a1);
/*SYSTEM_TOOLS*/T2 r235nb_errors(void);
extern int fBC235include_config_loadpaths;
/*SYSTEM_TOOLS*/void r235include_config_loadpaths(T235* C);
/*SYSTEM_TOOLS*/void r235main_function_exit_in(T235* C,T0* a1);
/*SYSTEM_TOOLS*/void r235main_function_return_type_in(T235* C,T0* a1);
/*SYSTEM_TOOLS*/T0* r235loaded_plugin(T235* C,T0* a1,T0* a2);
extern T0*oBC235x_suffix;
extern int fBC235x_suffix;
/*SYSTEM_TOOLS*/T0* r235x_suffix(T235* C);
/*SYSTEM_TOOLS*/T0* r235tmp_path(void);
/*SYSTEM_TOOLS*/void r235add_config_loadpath_file(T235* C,T0* a1,T0* a2);
/*SYSTEM_TOOLS*/void r235add_libraries_from_compiler_options(T235* C);
/*SYSTEM_TOOLS*/void r235append_if_not_already(T0* a1,T0* a2);
extern int fBC235add_lib_math;
/*SYSTEM_TOOLS*/void r235add_lib_math(T235* C);
/*SYSTEM_TOOLS*/void r235set_external_header_path(T0* a1);
extern T0*oBC235precompiled_header_suffix;
extern int fBC235precompiled_header_suffix;
/*SYSTEM_TOOLS*/T0* r235precompiled_header_suffix(T235* C);
/*SYSTEM_TOOLS*/void r235add_external_lib_path(T235* C,T0* a1);
/*SYSTEM_TOOLS*/void r235bad_use_exit(T235* C,T0* a1,T0* a2);
/*SYSTEM_TOOLS*/void r235add_objects(T235* C,T0* a1,T0* a2,T2 a3);
/*SYSTEM_TOOLS*/void r235sys_runtime(T235* C,T0* a1,T3 a2);
extern int fBC235set_basic_directory_notation;
/*SYSTEM_TOOLS*/void r235set_basic_directory_notation(T235* C);
/*SYSTEM_TOOLS*/T0* r235sas_c_compiler_options(T6 a1);
/*SYSTEM_TOOLS*/void r235auto_init_plugins(T235* C);
/*SYSTEM_TOOLS*/T0* r235echo(void);
extern T0*oBC235c_plus_plus_compiler_list;
extern int fBC235c_plus_plus_compiler_list;
/*SYSTEM_TOOLS*/T0* r235c_plus_plus_compiler_list(void);
/*SYSTEM_TOOLS*/T0* r235c_compiler_command(T235* C,T0* a1);
extern T0*oBC235token_buffer;
extern int fBC235token_buffer;
/*SYSTEM_TOOLS*/T0* r235token_buffer(void);
/*SYSTEM_TOOLS*/T0* r235plugin(T235* C,T0* a1,T0* a2,T296 a3);
/*SYSTEM_TOOLS*/void r235file_path(T235* C,T0* a1,T0* a2);
/*SYSTEM_TOOLS*/T0* r235environment(T235* C,T0* a1);
/*SYSTEM_TOOLS*/void r235make(T235* C);
extern T0*oBC235compiler_list;
extern int fBC235compiler_list;
/*SYSTEM_TOOLS*/T0* r235compiler_list(void);
/*SYSTEM_TOOLS*/T0* r235path_h(T235* C);
/*SYSTEM_TOOLS*/void r235set_system_name(T235* C,T0* a1);
/*SYSTEM_TOOLS*/void r235set_default_c_mode(T235* C,T0* a1);
/*SYSTEM_TOOLS*/void r235append_token(T0* a1,T0* a2);
/*SYSTEM_TOOLS*/void r235set_c_compiler(T235* C,T0* a1);
/*SYSTEM_TOOLS*/void r235sys_runtime_(T235* C,T0* a1,T3 a2);
/*SYSTEM_TOOLS*/T6 r235is_linking_mandatory(void);
extern int fBC235add_lib_profile;
/*SYSTEM_TOOLS*/void r235add_lib_profile(T235* C);
extern int fBC235check_c_plus_plus;
/*SYSTEM_TOOLS*/void r235check_c_plus_plus(T235* C);
extern T0*oBC235system_list;
extern int fBC235system_list;
/*SYSTEM_TOOLS*/T0* r235system_list(void);
extern T0*oBC235external_lib_paths;
extern int fBC235external_lib_paths;
/*SYSTEM_TOOLS*/T0* r235external_lib_paths(void);
extern T6 oBC235Scoptions_exists;
extern int fBC235Scoptions_exists;
/*SYSTEM_TOOLS*/T6 r235Scoptions_exists(void);
extern T0*oBC235external_libs;
extern int fBC235external_libs;
/*SYSTEM_TOOLS*/T0* r235external_libs(void);
extern T0*oBC236type_dictionary;
extern int fBC236type_dictionary;
/*SMART_EIFFEL*/T0* r236type_dictionary(void);
/*SMART_EIFFEL*/T0* r236type_pointer(T236* C);
/*SMART_EIFFEL*/void r236start_profile_class_invariant(T236* C,T0* a1);
/*SMART_EIFFEL*/void r236echo_magic_count(T236* C,T0* a1);
/*SMART_EIFFEL*/void r236start_profile_agent_creation(T236* C,T0* a1);
/*SMART_EIFFEL*/void r236register_class_invariant(T236* C,T0* a1);
/*SMART_EIFFEL*/T0* r236feature_stamp_of(T0* a1,T0* a2);
extern T0*oBC236memory_dispose_stamp;
extern int fBC236memory_dispose_stamp;
/*SMART_EIFFEL*/T0* r236memory_dispose_stamp(void);
/*SMART_EIFFEL*/void r236collect_deep_features(void);
/*SMART_EIFFEL*/T0* r236type_integer_8(T236* C);
/*SMART_EIFFEL*/T0* r236type_unicode_string(T236* C);
/*SMART_EIFFEL*/T0* r236context_feature(void);
/*SMART_EIFFEL*/T0* r236get_inline_memo(void);
/*SMART_EIFFEL*/T0* r236simplify_integer_infix_power(T296 a1,T0* a2,T0* a3);
extern T0*oBC236any_c_inline_c_feature_stamp;
extern int fBC236any_c_inline_c_feature_stamp;
/*SMART_EIFFEL*/T0* r236any_c_inline_c_feature_stamp(void);
/*SMART_EIFFEL*/void r236collect_local_expanded(T0* a1);
/*SMART_EIFFEL*/T0* r236get_and_clear_old_list(T236* C);
/*SMART_EIFFEL*/T0* r236type_string(T236* C);
/*SMART_EIFFEL*/void r236unknown_feature_fatal_error(T0* a1,T0* a2,T0* a3);
/*SMART_EIFFEL*/void r236tuple_class_not_found_fatal_error(T0* a1);
/*SMART_EIFFEL*/void r236register_run_feature(T236* C,T0* a1);
/*SMART_EIFFEL*/T6 r236is_ready(void);
/*SMART_EIFFEL*/void r236collect_generic(T0* a1);
extern T0*oBC236free_inline_memo;
extern int fBC236free_inline_memo;
/*SMART_EIFFEL*/T0* r236free_inline_memo(void);
/*SMART_EIFFEL*/void r236optimize(T236* C,T0* a1,T0* a2);
/*SMART_EIFFEL*/void r236collect_external_function(T0* a1,T0* a2,T0* a3);
extern T0*oBC236context_feature_stack;
extern int fBC236context_feature_stack;
/*SMART_EIFFEL*/T0* r236context_feature_stack(void);
/*SMART_EIFFEL*/T0* r236get_type(T0* a1);
/*SMART_EIFFEL*/T0* r236type_real_extended(T236* C);
/*SMART_EIFFEL*/void r236argument_count_check(T296 a1,T0* a2,T0* a3);
/*SMART_EIFFEL*/void r236collect_precomputable(T0* a1,T0* a2);
/*SMART_EIFFEL*/T0* r236type_boolean(T236* C);
/*SMART_EIFFEL*/T0* r236get_type_for_non_generic(T0* a1);
/*SMART_EIFFEL*/T0* r236cluster_of(T0* a1,T6 a2);
/*SMART_EIFFEL*/void r236collect_from_root(T236* C,T0* a1,T0* a2);
/*SMART_EIFFEL*/void r236register_agent_switch(T236* C,T0* a1);
/*SMART_EIFFEL*/T0* r236cluster_named(T0* a1);
/*SMART_EIFFEL*/void r236get_started(T236* C,T0* a1,T0* a2);
/*SMART_EIFFEL*/void r236vffd7_fatal_error(T296 a1);
/*SMART_EIFFEL*/T0* r236type_real_64(T236* C);
/*SMART_EIFFEL*/void r236register_agent_creation(T236* C,T0* a1);
extern T0*oBC236manifest_creation_name;
extern int fBC236manifest_creation_name;
/*SMART_EIFFEL*/T0* r236manifest_creation_name(T236* C);
extern T0*oBC236copyright;
extern int fBC236copyright;
/*SMART_EIFFEL*/T0* r236copyright(void);
/*SMART_EIFFEL*/T0* r236type_integer_16(T236* C);
extern T0*oBC236collected_external_functions;
extern int fBC236collected_external_functions;
/*SMART_EIFFEL*/T0* r236collected_external_functions(void);
/*SMART_EIFFEL*/void r236start_profile_agent_switch(T236* C,T0* a1);
/*SMART_EIFFEL*/T0* r236loaded_class_text(T0* a1);
/*SMART_EIFFEL*/T0* r236type_real_32(T236* C);
/*SMART_EIFFEL*/T0* r236type_integer_32(T236* C);
/*SMART_EIFFEL*/T6 r236is_at_run_time(T0* a1);
/*SMART_EIFFEL*/void r236collect_se_atexit(T236* C,T0* a1);
/*SMART_EIFFEL*/void r236register_plug_in(T0* a1);
/*SMART_EIFFEL*/void r236simplify(T236* C);
/*SMART_EIFFEL*/void r236do_one_collect_cycle(void);
/*SMART_EIFFEL*/void r236pop_context(T0* a1);
/*SMART_EIFFEL*/void r236start_profile(T236* C,T0* a1);
/*SMART_EIFFEL*/int r236switch_collection(void);
extern T0*oBC236any_c_inline_h_feature_stamp;
extern int fBC236any_c_inline_h_feature_stamp;
/*SMART_EIFFEL*/T0* r236any_c_inline_h_feature_stamp(void);
/*SMART_EIFFEL*/void r236register_old(T236* C,T0* a1);
/*SMART_EIFFEL*/T2 r236nb_errors(void);
/*SMART_EIFFEL*/T0* r236type_integer_64(T236* C);
/*SMART_EIFFEL*/void r236register_type(T0* a1);
/*SMART_EIFFEL*/T6 r236is_tagged(T0* a1);
/*SMART_EIFFEL*/void r236collect_create(T0* a1);
/*SMART_EIFFEL*/void r236customize_runtime(void);
/*SMART_EIFFEL*/void r236id_extra_information(T0* a1,T0* a2,T0* a3);
/*SMART_EIFFEL*/T0* r236class_text(T0* a1,T6 a2);
/*SMART_EIFFEL*/T0* r236collect(T0* a1,T0* a2,T6 a3);
/*SMART_EIFFEL*/void r236compile(T236* C,T0* a1);
extern T0*oBC28dispose_name;
extern int fBC28dispose_name;
/*SMART_EIFFEL*/T0* r236dispose_name(void);
/*SMART_EIFFEL*/T0* r236feature_accumulator(void);
/*SMART_EIFFEL*/T0* r236parser_buffer(void);
/*SMART_EIFFEL*/T0* r236dispatch_special(T236* C,T0* a1,T0* a2);
/*SMART_EIFFEL*/T0* r236echo(void);
/*SMART_EIFFEL*/void r236parse_include(T0* a1);
extern T0*oBC236live_type_map;
extern int fBC236live_type_map;
/*SMART_EIFFEL*/T0* r236live_type_map(void);
/*SMART_EIFFEL*/void r236collect_constant(T0* a1);
/*SMART_EIFFEL*/void r236safety_check(T236* C);
/*SMART_EIFFEL*/T0* r236long_type_name(T0* a1,T0* a2);
/*SMART_EIFFEL*/T0* r236analyze_class(T0* a1,T0* a2);
extern T0*oBC28se_atexit_name;
extern int fBC28se_atexit_name;
/*SMART_EIFFEL*/T0* r236se_atexit_name(void);
/*SMART_EIFFEL*/void r236collect_external(T0* a1);
/*SMART_EIFFEL*/T0* r236type_any(T236* C);
/*SMART_EIFFEL*/void r236covariance_check(T296 a1,T0* a2,T0* a3);
/*SMART_EIFFEL*/void r236collect_cecil_entry(T0* a1,T0* a2,T6 a3);
extern int fBC236initialize_any_tuple;
/*SMART_EIFFEL*/void r236initialize_any_tuple(void);
/*SMART_EIFFEL*/T0* r236type_character(T236* C);
/*SMART_EIFFEL*/T2 r236class_text_count(void);
/*SMART_EIFFEL*/T0* r236collect_one_type(T0* a1,T6 a2);
extern T0*oBC236status;
/*SMART_EIFFEL*/void r236magic_count_increment(T236* C);
/*SMART_EIFFEL*/void r236very_last_information(void);
/*SMART_EIFFEL*/T0* r236create_type(T0* a1);
extern T0*oBC236collected_plug_in;
extern int fBC236collected_plug_in;
/*SMART_EIFFEL*/T0* r236collected_plug_in(void);
/*ID_PROVIDER*/void r66disk_restore(T66* C);
/*ID_PROVIDER*/void r66disk_save(T66* C);
/*ID_PROVIDER*/void r66id_memory_add(T10 a1,T0* a2,T6 a3);
/*ID_PROVIDER*/T0* r66class_name_of(T0* a1);
/*ID_PROVIDER*/void r66cluster_id_memory_add(T10 a1,T0* a2,T0* a3);
/*ID_PROVIDER*/T0* r66alias_of(T10 a1);
/*ID_PROVIDER*/T10 r66item(T66* C,T0* a1,T0* a2);
extern T0*oBC66per_cluster_id_memory;
extern int fBC66per_cluster_id_memory;
/*ID_PROVIDER*/T0* r66per_cluster_id_memory(void);
/*ID_PROVIDER*/T10 r66high_item(T66* C,T0* a1);
/*ID_PROVIDER*/T0* r66system_tools(void);
/*ID_PROVIDER*/void r66make(T66* C);
/*ID_PROVIDER*/T0* r66echo(void);
extern T0*oBC66temporary_type_name;
extern int fBC66temporary_type_name;
/*ID_PROVIDER*/T0* r66temporary_type_name(void);
extern T0*oBC66id_memory;
extern int fBC66id_memory;
/*ID_PROVIDER*/T0* r66id_memory(void);
/*ID_PROVIDER*/T0* r66cluster_id_memory(T0* a1);
/*ID_PROVIDER*/void r66disk_save_ids(T66* C,T0* a1,T0* a2,T0* a3);
/*ID_PROVIDER*/T6 r66is_valid_type_mark(T0* a1);
/*STRING_ALIASER*/T0* r85string(T0* a1);
extern T0*oBC85tuple_name;
extern int fBC85tuple_name;
/*STRING_ALIASER*/T0* r85tuple_name(void);
/*STRING_ALIASER*/T0* r85create_hashed_string(T0* a1);
/*STRING_ALIASER*/T6 r85registered_one(T0* a1);
extern T0*oBC85hashed_string_buffer;
extern int fBC85hashed_string_buffer;
/*STRING_ALIASER*/T0* r85hashed_string_buffer(void);
/*STRING_ALIASER*/T0* r85hashed_string(T0* a1);
/*STRING_ALIASER*/void r85echo_information(void);
/*STRING_ALIASER*/T0* r85echo(void);
extern T0*oBC85memory;
extern int fBC85memory;
/*STRING_ALIASER*/T0* r85memory(void);
/*ECHO*/T0* r218getenv(T218* C,T0* a1,T0* a2);
/*ECHO*/void r218tfr_connect_or_exit(T218* C,T0* a1,T0* a2);
/*ECHO*/void r218print_count(T218* C,T0* a1,T2 a2);
/*ECHO*/T0* r218system_tools(void);
/*ECHO*/void r218w_put_string(T218* C,T0* a1);
/*ECHO*/void r218put_new_line(T218* C);
/*ECHO*/void r218w_put_integer(T218* C,T2 a1);
/*ECHO*/void r218put_integer(T218* C,T2 a1);
/*ECHO*/void r218put_real_format(T218* C,T5 a1,T2 a2);
/*ECHO*/void r218put_character(T218* C,T3 a1);
/*ECHO*/void r218put_string(T218* C,T0* a1);
/*ECHO*/void r218before_exit_close(T218* C);
/*ECHO*/T0* r218std_output(void);
/*ECHO*/void r218file_removing(T218* C,T0* a1);
/*ECHO*/void r218make(T218* C);
/*ECHO*/void r218file_renaming(T218* C,T0* a1,T0* a2);
/*ECHO*/void r218tfw_connect(T218* C,T0* a1,T0* a2);
/*ECHO*/void r218redirect_output_on(T218* C,T0* a1);
/*ECHO*/void r218w_put_character(T218* C,T3 a1);
/*ECHO*/void r218tfr_connect(T218* C,T0* a1,T0* a2);
/*STRING_COMMAND_LINE*/T0* r255system_tools(void);
/*STRING_COMMAND_LINE*/T6 r255flag_match(T0* a1,T0* a2);
/*STRING_COMMAND_LINE*/T6 r255is_trace_flag(T0* a1);
/*STRING_COMMAND_LINE*/T6 r255is_profile(T0* a1);
extern T0*oBC255option_buffer;
extern int fBC255option_buffer;
/*STRING_COMMAND_LINE*/T0* r255option_buffer(void);
/*STRING_COMMAND_LINE*/void r255set_command_name(T0* a1);
/*STRING_COMMAND_LINE*/void r255next_option(void);
/*STRING_COMMAND_LINE*/void r255parse(T0* a1);
extern T0*oBC255command_line_buffer;
extern int fBC255command_line_buffer;
/*STRING_COMMAND_LINE*/T0* r255command_line_buffer(void);
/*STRING_COMMAND_LINE*/T0* r255echo(void);
/*COMPILE_TO_C*/T6 r25is_version_flag(T25* C,T0* a1);
/*COMPILE_TO_C*/T6 r25is_output_error_warning_on_flag(T25* C,T0* a1,T2 a2);
/*COMPILE_TO_C*/T0* r25system_tools(void);
/*COMPILE_TO_C*/T6 r25is_version_flag_no_exit(T25* C,T0* a1);
/*COMPILE_TO_C*/T6 r25is_no_style_warning_flag(T0* a1);
/*COMPILE_TO_C*/T6 r25is_relax_flag(T0* a1);
/*COMPILE_TO_C*/T6 r25is_flat_check_flag(T0* a1);
/*COMPILE_TO_C*/T6 r25is_cecil_flag(T25* C,T0* a1,T2 a2);
/*COMPILE_TO_C*/T6 r25ace_file_mode(T25* C);
/*COMPILE_TO_C*/T6 r25flag_match(T0* a1,T0* a2);
/*COMPILE_TO_C*/T6 r25is_o_flag(T25* C,T0* a1,T2 a2);
/*COMPILE_TO_C*/T6 r25is_trace_flag(T0* a1);
/*COMPILE_TO_C*/T6 r25is_verbose_flag(T0* a1);
/*COMPILE_TO_C*/T0* r25search_for_echo_redirect_flag(T25* C);
/*COMPILE_TO_C*/T6 r25is_help_flag(T25* C,T0* a1);
/*COMPILE_TO_C*/T6 r25is_debug_flag(T0* a1);
/*COMPILE_TO_C*/T6 r25is_high_memory_compiler(T0* a1);
/*COMPILE_TO_C*/T6 r25is_no_warning_flag(T0* a1);
/*COMPILE_TO_C*/T6 r25is_safety_check_flag(T0* a1);
/*COMPILE_TO_C*/T6 r25is_profile(T0* a1);
/*COMPILE_TO_C*/T6 r25is_case_insensitive_flag(T0* a1);
/*COMPILE_TO_C*/T6 r25is_valid_argument_for_ace_mode(T25* C,T0* a1);
/*COMPILE_TO_C*/T6 r25is_manifest_string_trace_flag(T0* a1);
/*COMPILE_TO_C*/void r25search_for_cc_flag(void);
/*COMPILE_TO_C*/T0* r25echo(void);
/*COMPILE_TO_C*/T6 r25is_a_compilation_level_flag(T25* C,T0* a1);
/*COMPILE_TO_C*/void r25search_for_verbose_flag(void);
/*COMPILE_TO_C*/void r25check_for_level(T25* C,T0* a1);
/*COMPILE_TO_C*/void r25make(T25* C);
/*COMPILE_TO_C*/void r25parse_command_line(T25* C,T2 a1);
/*COMPILE_TO_C*/T0* r25id_provider(void);
extern int fBC28set_cecil_pool;
/*COMPILE_TO_C*/void r25set_cecil_pool(void);
extern T0*oBC31command_arguments;
extern int fBC31command_arguments;
/*COMPILE_TO_C*/T0* r25command_arguments(void);
/*COMPILE_TO_C*/T2 r25argument_count(void);
void agent_launcher_CLASS_TEXT(/*agent*/T0*a,T0* a1);
union _se_agent{T0 s0;se_agent0 u0;
se_agenT232C232l597c14 uagenT232C232l597c14;
se_agenT232C232l661c14 uagenT232C232l661c14;
};
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#define SE_AGENTS 1
#define EIF_AGENT se_agent*

se_agent* new_agent(Tid id);

#ifdef SE_GC_LIB

  typedef struct B_agent gc_agent;

  struct B_agent {
    se_agent object;
    union {
      void *flag;
      gc_agent *next;
    } header;
  };

  extern gc_agent *store_agent;
  extern gc_agent *gc_free_agent;
  extern int       store_left_agent;
  extern fsoc     *store_chunk_agent;
  extern fsoc      H_agent;
  extern int       gc_info_nb_agent;

  void gc_align_mark_agent(fsoc *c, gc_agent* a);
  void gc_sweep_agent(fsoc *c);

#endif
extern T0*ms317_215;
extern T0*ms301_597973944;
extern T0*ms317_1726920051;
extern T0*ms484_209121;
extern T0*ms232_1435285930;
extern T0*ms317_23313965;
extern T0*ms219_158634393;
extern T0*ms69_1708886163;
extern T0*ms360_704592146;
extern T0*ms469_36126743;
extern T0*ms235_273430505;
extern T0*ms317_1199620901;
extern T0*ms29_78002;
extern T0*ms232_17480bc232;
extern T0*ms436_246bc403;
extern T0*ms436_246bc360;
extern T0*ms436_246bc405;
extern T0*ms436_246bc410;
extern T0*ms317_84;
extern T0*ms436_246bc411;
extern T0*ms80_1737556726;
extern T0*ms317_1253917267;
extern T0*ms484_3485;
extern T0*ms235_19761224;
extern T0*ms317_325;
extern T0*ms285_134876562;
extern T0*ms232_545118879;
extern T0*ms317_284;
extern T0*ms235_25704393;
extern T0*ms421_26975293;
extern T0*ms407_230bc493;
extern T0*ms317_1150927957;
extern T0*ms544_77562923;
extern T0*ms232_1110850242;
extern T0*ms29_82570;
extern T0*ms450_1032053803;
extern T0*ms235_1615398571;
extern T0*ms317_419;
extern T0*ms317_382;
extern T0*ms329_1728089446;
extern T0*ms279_28418819;
extern T0*ms30_1680926299;
extern T0*ms436_246bc232c37;
extern T0*ms411_305bc232c36l2297;
extern T0*ms219_1637595774;
extern T0*ms436_246bc232c39;
extern T0*ms30_14150bc413;
extern T0*ms27_87180;
extern T0*ms291_1646bc317;
extern T0*ms410_245bc224;
extern T0*ms534_1777096676;
extern T0*ms30_406284;
extern T0*ms291_1646bc291;
extern T0*ms411_305bc232c36l2264;
extern T0*ms360_195246;
extern T0*ms235_9073bc235c46;
extern T0*ms29_78263;
extern T0*ms30_36193081;
extern T0*ms232_2123070311;
extern T0*ms85_240bc218c17;
extern T0*ms30_240810604;
extern T0*ms411_305bc59c42;
extern T0*ms30_619776399;
extern T0*ms317_635;
extern T0*ms234_3374bc234;
extern T0*ms64_87520bc500;
extern T0*ms232_928596125;
extern T0*ms66_0bc701c10;
extern T0*ms30_240810599;
extern T0*ms66_0bc701c13;
extern T0*ms410_245bc405;
extern T0*ms317_1113554587;
extern T0*ms410_245bc407;
extern T0*ms627_628172096;
extern T0*ms69_744085684;
extern T0*ms59_900404594;
extern T0*ms234_3374bc291;
extern T0*ms598_1400894751;
extern T0*ms30_51915068;
extern T0*ms234_3374bc360;
extern T0*ms232_1186179343;
extern T0*ms30_48856070;
extern T0*ms493_4052132;
extern T0*ms410_245bc470;
extern T0*ms29_78490;
extern T0*ms232_431043495bc232c36l377;
extern T0*ms232_441192857;
extern T0*ms30_2246041bc627;
extern T0*ms394_1965730;
extern T0*ms360_189390;
extern T0*ms629_21632225;
extern T0*ms80_527202963;
extern T0*ms29_78591;
extern T0*ms241_180894;
extern T0*ms80_698011541;
extern T0*ms544_27909038;
extern T0*ms411_305bc232c21;
extern T0*ms317_3209;
extern T0*ms239_162838175;
extern T0*ms235_932412928bc317;
extern T0*ms411_305bc232c35;
extern T0*ms407_230;
extern T0*ms411_305bc232c36;
extern T0*ms239_215791;
extern T0*ms411_305bc232c37;
extern T0*ms411_305bc232c38;
extern T0*ms291_3175bc544c18;
extern T0*ms219_172080;
extern T0*ms450_1694771411;
extern T0*ms232_1316373138;
extern T0*ms317_15405;
extern T0*ms232_16782bc289c38;
extern T0*ms357_257;
extern T0*ms407_258;
extern T0*ms360_1263916320;
extern T0*ms291_1279738389;
extern T0*ms241_401981819bc241;
extern T0*ms317_3337;
extern T0*ms411_305bc232c36l591;
extern T0*ms30_10945665;
extern T0*ms317_1206509635;
extern T0*ms450_784909;
extern T0*ms219_1271bc360c40;
extern T0*ms411_305bc232c21l967;
extern T0*ms411_305bc232c21l972;
extern T0*ms317_2870;
extern T0*ms317_273431355;
extern T0*ms236_113036818;
extern T0*ms30_42134669;
extern T0*ms411_305bc232c21l957;
extern T0*ms360_1586596820bc360;
extern T0*ms411_305bc232c21l960;
extern T0*ms66_0bc597c23;
extern T0*ms317_2187411;
extern T0*ms232_514187710;
extern T0*ms29_84443;
extern T0*ms410_2187619bc629;
extern T0*ms29_945182441;
extern T0*ms291_73472312bc291;
extern T0*ms217_1737592965;
extern T0*ms232_934202231;
extern T0*ms84_319940936bc84;
extern T0*ms701_302;
extern T0*ms239_122027336;
extern T0*ms218_141444;
extern T0*ms66_0bc701c9;
extern T0*ms232_36951bc435;
extern T0*ms291_32605;
extern T0*ms235_146157;
extern T0*ms80_1955866577;
extern T0*ms291_737599544;
extern T0*ms436_809795;
extern T0*ms317_205124;
extern T0*ms317_197373672;
extern T0*ms224_533301931;
extern T0*ms358_83406;
extern T0*ms29_56927287;
extern T0*ms235_5578901;
extern T0*ms360_17743770bc360;
extern T0*ms627_89481;
extern T0*ms232_1790869799;
extern T0*ms28_334bc701c13;
extern T0*ms28_329bc701c13;
extern T0*ms317_197373672bc317;
extern T0*ms29_1975394;
extern T0*ms436_246bc360c40l2000;
extern T0*ms597_1613492996;
extern T0*ms360_1942608409;
extern T0*ms436_246bc360c40l2006;
extern T0*ms235_932412928;
extern T0*ms25_1325879523;
extern T0*ms436_246bc360c40l2022;
extern T0*ms63_252bc411c32;
extern T0*ms63_252bc493;
extern T0*ms63_252bc536;
extern T0*ms63_252bc534;
extern T0*ms63_252bc481;
extern T0*ms360_6965bc360;
extern T0*ms59_738514888;
extern T0*ms63_252bc519;
extern T0*ms360_520373770;
extern T0*ms232_1290234339;
extern T0*ms329_1992825354;
extern T0*ms29_396356bc474;
extern T0*ms63_252bc465;
extern T0*ms234_1852104762;
extern T0*ms30_1192911276;
extern T0*ms317_16510;
extern T0*ms29_90408;
extern T0*ms360_7704337;
extern T0*ms392_244699380bc392;
extern T0*ms317_619030689;
extern T0*ms66_0bc701c9l180;
extern T0*ms63_252bc431;
extern T0*ms360_39831;
extern T0*ms29_8054609;
extern T0*ms622_1847764413;
extern T0*ms63_252bc411;
extern T0*ms59_227bc289c44;
extern T0*ms63_252bc287;
extern T0*ms232_251bc219c41;
extern T0*ms63_252bc333;
extern T0*ms66_0bc504c17;
extern T0*ms29_396356bc317;
extern T0*ms232_375072661;
extern T0*ms317_153655;
extern T0*ms30_1673345408;
extern T0*ms410_245bc405c39;
extern T0*ms235_143937264;
extern T0*ms232_54714119;
extern T0*ms392_244699380bc627;
extern T0*ms394_48939825;
extern T0*ms30_1671553525;
extern T0*ms239_2382bc545c15;
extern T0*ms235_98806116;
extern T0*ms29_1992063831;
extern T0*ms279_1185594;
extern T0*ms436_246bc360c40l1853;
extern T0*ms436_246bc360c40l1861;
extern T0*ms436_246bc360c40l1857;
extern T0*ms232_267478119;
extern T0*ms436_246bc360c40l1865;
extern T0*ms436_246bc360c40l1869;
extern T0*ms436_246bc360c40l1926;
extern T0*ms500_1691484858;
extern T0*ms69_696478167;
extern T0*ms450_259bc450c29;
extern T0*ms291_730579755;
extern T0*ms235_1626bc235;
extern T0*ms393_206419907;
extern T0*ms360_33291bc360c40;
extern T0*ms236_1242126608;
extern T0*ms241_1011636926;
extern T0*ms241_79251;
extern T0*ms436_246bc360c40l1996;
extern T0*ms291_33836;
extern T0*ms29_1072344038bc29;
extern T0*ms232_1672511676;
extern T0*ms232_21391495;
extern T0*ms291_33875;
extern T0*ms63_300bc317;
extern T0*ms235_1319327951;
extern T0*ms30_2126626;
extern T0*ms29_17221bc315;
extern T0*ms232_585944489;
extern T0*ms411_305bc220;
extern T0*ms358_380590;
extern T0*ms411_305bc224;
extern T0*ms411_305bc219;
extern T0*ms411_305bc232;
extern T0*ms411_305bc234;
extern T0*ms291_1173325215;
extern T0*ms544_2097247;
extern T0*ms218_44975894bc232;
extern T0*ms411_305bc239;
extern T0*ms317_486352305;
extern T0*ms411_305bc317;
extern T0*ms597_1398420907;
extern T0*ms232_506210947;
extern T0*ms450_832670;
extern T0*ms411_305bc291;
extern T0*ms317_1096165867bc317;
extern T0*ms411_305bc289;
extern T0*ms69_116346440;
extern T0*ms239_2382bc539c15;
extern T0*ms232_7918258;
extern T0*ms411_305bc403;
extern T0*ms63_2064444bc77;
extern T0*ms411_305bc355;
extern T0*ms411_305bc360;
extern T0*ms239_1483072174;
extern T0*ms411_305bc356;
extern T0*ms235_9073bc235;
extern T0*ms30_170256464;
extern T0*ms411_305bc357;
extern T0*ms30_65574bc536;
extern T0*ms411_305bc359;
extern T0*ms232_203646;
extern T0*ms317_1497878015;
extern T0*ms411_305bc421;
extern T0*ms360_7025bc360;
extern T0*ms411_305bc381;
extern T0*ms317_18257;
extern T0*ms360_384465bc360;
extern T0*ms411_305bc392;
extern T0*ms411_305bc394;
extern T0*ms359_34086;
extern T0*ms411_305bc450;
extern T0*ms219_1994852;
extern T0*ms411_305bc503;
extern T0*ms411_305bc398;
extern T0*ms360_240830;
extern T0*ms329_43730;
extern T0*ms411_1367878466;
extern T0*ms411_305bc481;
extern T0*ms220_1901755;
extern T0*ms411_305bc484;
extern T0*ms411_305bc534;
extern T0*ms232_1330bc232c37l769;
extern T0*ms411_305bc493;
extern T0*ms309_270bc227c22;
extern T0*ms309_270bc227c17;
extern T0*ms29_434665;
extern T0*ms411_305bc498;
extern T0*ms80_1091711046;
extern T0*ms411_305bc499;
extern T0*ms351_1047;
extern T0*ms30_7748406;
extern T0*ms411_305bc556;
extern T0*ms232_5395053bc291c41;
extern T0*ms232_1330bc232c37l751;
extern T0*ms291_35404;
extern T0*ms30_79341bc627;
extern T0*ms317_876720377;
extern T0*ms411_305bc629;
extern T0*ms360_265bc360;
extern T0*ms25_840215460;
extern T0*ms236_866669263;
extern T0*ms294_1046299075;
extern T0*ms232_1605087047;
extern T0*ms469_7233618;
extern T0*ms239_1586448448;
extern T0*ms317_7006;
extern T0*ms232_1330bc232c37l619;
extern T0*ms479_4636482;
extern T0*ms29_87466;
extern T0*ms232_1164920984;
extern T0*ms317_351281;
extern T0*ms66_0bc511c15;
extern T0*ms66_0bc506c15;
extern T0*ms360_188188376bc360;
extern T0*ms232_14005bc232;
extern T0*ms360_185515;
extern T0*ms30_1553736287;
extern T0*ms236_385188989;
extern T0*ms232_120095614;
extern T0*ms226_584218374;
extern T0*ms232_1377391529;
extern T0*ms30_1680885744;
extern T0*ms317_6614;
extern T0*ms627_2092258783;
extern T0*ms235_2075119688;
extern T0*ms469_36137368;
extern T0*ms360_384465;
extern T0*ms232_11086084bc232;
extern T0*ms224_489233515;
extern T0*ms30_744845610;
extern T0*ms30_247239028;
extern T0*ms359_852437;
extern T0*ms239_192841706;
extern T0*ms360_84085bc360;
extern T0*ms407_1947010027;
extern T0*ms351_1452;
extern T0*ms232_1826935309;
extern T0*ms291_41300;
extern T0*ms217_1471782099;
extern T0*ms234_2109816196;
extern T0*ms450_988243818bc629;
extern T0*ms232_950675891;
extern T0*ms499_1858133582;
extern T0*ms29_88336;
extern T0*ms30_1937220099;
extern T0*ms232_277bc217c44;
extern T0*ms385_10007800bc346;
extern T0*ms234_114bc317;
extern T0*ms317_7296;
extern T0*ms232_392938270;
extern T0*ms29_436196;
extern T0*ms30_421505;
extern T0*ms232_107312226;
extern T0*ms317_744114;
extern T0*ms360_6534bc360;
extern T0*ms29_51843716;
extern T0*ms317_1605175681;
extern T0*ms627_105;
extern T0*ms338_295;
extern T0*ms63_2064444;
extern T0*ms323_114137597;
extern T0*ms218_1974940930;
extern T0*ms493_32176;
extern T0*ms232_2630bc232;
extern T0*ms317_1927425;
extern T0*ms317_1809213019;
extern T0*ms30_54688766;
extern T0*ms232_2142659303;
extern T0*ms29_2073386;
extern T0*ms360_520377520;
extern T0*ms26_1090;
extern T0*ms30_506823435;
extern T0*ms292_3557;
extern T0*ms627_1175100011;
extern T0*ms30_12376;
extern T0*ms360_5654700;
extern T0*ms235_373286592;
extern T0*ms30_61bc627;
extern T0*ms239_2382bc537c15;
extern T0*ms69_85511833;
extern T0*ms232_2630bc289;
extern T0*ms29_10876026;
extern T0*ms360_15020bc360;
extern T0*ms244_1838187926;
extern T0*ms232_2630bc360;
extern T0*ms469_7227375;
extern T0*ms232_1772404517;
extern T0*ms219_1565bc219;
extern T0*ms80_1476966395;
extern T0*ms317_284bc239;
extern T0*ms219_1565bc232;
extern T0*ms29_437070;
extern T0*ms232_1601653158bc232;
extern T0*ms291_931143030;
extern T0*ms358_241;
extern T0*ms317_635bc317c40;
extern T0*ms317_284bc317;
extern T0*ms317_202031759bc369;
extern T0*ms30_1673348567;
extern T0*ms317_1317154036;
extern T0*ms405_1240;
extern T0*ms317_284bc291;
extern T0*ms232_5395053bc232;
extern T0*ms30_61bc410;
extern T0*ms506_276bc511c32;
extern T0*ms232_5395053bc239;
extern T0*ms219_1565bc289;
extern T0*ms29_3415bc421;
extern T0*ms358_345;
extern T0*ms360_1280;
extern T0*ms506_276bc511c12;
extern T0*ms506_276bc506c12;
extern T0*ms30_761722990;
extern T0*ms410_1285;
extern T0*ms30_13194;
extern T0*ms317_244793715bc317;
extern T0*ms360_1291;
extern T0*ms232_5395053bc332;
extern T0*ms544_1012357115;
extern T0*ms69_1836169859;
extern T0*ms232_5395053bc335;
extern T0*ms232_5395053bc291;
extern T0*ms232_5395053bc289;
extern T0*ms317_8436;
extern T0*ms219_1565bc450;
extern T0*ms360_2017590;
extern T0*ms219_38305571;
extern T0*ms627_499;
extern T0*ms232_5395053bc413;
extern T0*ms411_1088102843;
extern T0*ms232_255270944;
extern T0*ms217_16487bc627;
extern T0*ms317_1245850444;
extern T0*ms30_2067995;
extern T0*ms627_574;
extern T0*ms219_1565bc474;
extern T0*ms627_576;
extern T0*ms29_48390502;
extern T0*ms29_436911;
extern T0*ms69_92397395;
extern T0*ms317_284bc544;
extern T0*ms356_1932272303;
extern T0*ms232_6455bc317c42;
extern T0*ms360_2217200;
extern T0*ms232_1009317511;
extern T0*ms358_535;
extern T0*ms317_204519611;
extern T0*ms217_16487bc544;
extern T0*ms219_1565bc499;
extern T0*ms69_2004339522;
extern T0*ms232_16782bc59;
extern T0*ms29_1690381566;
extern T0*ms236_1783880762;
extern T0*ms232_5395053bc517;
extern T0*ms407_258bc474;
extern T0*ms239_2382bc541c19;
extern T0*ms291_1085305030;
extern T0*ms232_5395053bc534;
extern T0*ms232_5395053bc541;
extern T0*ms232_5395053bc536;
extern T0*ms30_52347889;
extern T0*ms30_1578334651;
extern T0*ms232_5395053bc538;
extern T0*ms232_5395053bc544;
extern T0*ms232_5395053bc539;
extern T0*ms232_5395053bc545;
extern T0*ms235_683870135;
extern T0*ms360_1174230416bc360;
extern T0*ms465_360bc360;
extern T0*ms26_1090bc218;
extern T0*ms26_1090bc232;
extern T0*ms232_10666295;
extern T0*ms346_8835bc346;
extern T0*ms26_1090bc235;
extern T0*ms317_680177517;
extern T0*ms30_869539012;
extern T0*ms317_382bc398c41;
extern T0*ms29_1747646688;
extern T0*ms217_16487bc291;
extern T0*ms235_2109537640bc235c14;
extern T0*ms29_89771;
extern T0*ms30_14150;
extern T0*ms235_45436;
extern T0*ms29_1532343833;
extern T0*ms80_929353692;
extern T0*ms29_3645bc291;
extern T0*ms232_12201;
extern T0*ms235_2109537640;
extern T0*ms317_9980719bc317;
extern T0*ms484_77;
extern T0*ms69_274238642;
extern T0*ms355_2327;
extern T0*ms30_911175911;
extern T0*ms360_1840;
extern T0*ms360_2996bc360;
extern T0*ms217_16487bc220;
extern T0*ms360_1900;
extern T0*ms450_1111954737;
extern T0*ms360_2403;
extern T0*ms218_1635864124;
extern T0*ms291_69352117;
extern T0*ms232_12188;
extern T0*ms235_561720547;
extern T0*ms232_7720290;
extern T0*ms614_37074;
extern T0*ms235_2139128753;
extern T0*ms290_927498134;
extern T0*ms360_60405;
extern T0*ms232_9130bc291;
extern T0*ms232_4980205;
extern T0*ms534_1476287022;
extern T0*ms469_1446625;
extern T0*ms450_129254700;
extern T0*ms232_522691310;
extern T0*ms234_114;
extern T0*ms232_12331;
extern T0*ms236_604558099;
extern T0*ms30_1744612358;
extern T0*ms622_1959331451;
extern T0*ms360_1773508175;
extern T0*ms232_932172292;
extern T0*ms232_1994596535;
extern T0*ms289_5284;
extern T0*ms499_11977;
extern T0*ms241_18150bc59;
extern T0*ms232_1361175839;
extern T0*ms360_2670;
extern T0*ms629_193284;
extern T0*ms59_228498053;
extern T0*ms232_9130bc627;
extern T0*ms30_47bc234;
extern T0*ms360_3181;
extern T0*ms289_2072064738;
extern T0*ms317_340114884;
extern T0*ms360_1037332903;
extern T0*ms469_7225250;
extern T0*ms235_9073bc235c46l915;
extern T0*ms232_8359055;
extern T0*ms217_77412;
extern T0*ms628_3118;
extern T0*ms30_424424;
extern T0*ms30_424430;
extern T0*ms234_379;
extern T0*ms457_184795;
extern T0*ms294_5515;
extern T0*ms317_9905;
extern T0*ms232_20552830;
extern T0*ms291_1111960899;
extern T0*ms317_884813300;
extern T0*ms357_1152812249;
extern T0*ms451_1753bc283;
extern T0*ms450_1949908058;
extern T0*ms241_1778077539;
extern T0*ms29_1532344910;
extern T0*ms544_619166512;
extern T0*ms232_2041682;
extern T0*ms317_5313505bc317;
extern T0*ms29_2065491;
extern T0*ms30_94407393;
extern T0*ms360_60855;
extern T0*ms232_1855175789;
extern T0*ms232_1591358844;
extern T0*ms291_129037214;
extern T0*ms219_2072467813;
extern T0*ms317_826425832;
extern T0*ms291_5161461;
extern T0*ms232_2110526086;
extern T0*ms232_1187263559;
extern T0*ms360_68406039bc360;
extern T0*ms450_259bc450;
extern T0*ms400_31625;
extern T0*ms291_90782bc291c45;
extern T0*ms450_80771;
extern T0*ms232_941548611;
extern T0*ms30_15448;
extern T0*ms219_1824264277;
extern T0*ms69_1226144723;
extern T0*ms360_2996;
extern T0*ms627_121515080;
extern T0*ms469_7224500;
extern T0*ms317_5313530;
extern T0*ms576_1854402277;
extern T0*ms421_26975293bc289;
extern T0*ms394_29037;
extern T0*ms317_5313505;
extern T0*ms232_14005;
extern T0*ms360_1586596820bc360c40;
extern T0*ms80_376816512;
extern T0*ms360_177459204bc360;
extern T0*ms69_595894613;
extern T0*ms544_26635163;
extern T0*ms219_1231257120;
extern T0*ms450_259bc629;
extern T0*ms291_44739;
extern T0*ms29_479921113;
extern T0*ms360_1449951397;
extern T0*ms219_1757386798;
extern T0*ms232_651bc232;
extern T0*ms232_1365405869;
extern T0*ms232_1964848975;
extern T0*ms232_2038260346;
extern T0*ms30_203589551;
extern T0*ms27_385751bc80;
extern T0*ms291_27492334;
extern T0*ms30_15751;
extern T0*ms519_287bc317;
extern T0*ms217_395316170;
extern T0*ms232_1988895671;
extern T0*ms30_43bc360;
extern T0*ms291_479982486;
extern T0*ms394_2042716661;
extern T0*ms224_960414291;
extern T0*ms232_988839165;
extern T0*ms450_882065083bc629;
extern T0*ms232_13801;
extern T0*ms232_434116584;
extern T0*ms30_15831;
extern T0*ms450_76659;
extern T0*ms232_282430172;
extern T0*ms360_1291bc360;
extern T0*ms30_7095298;
extern T0*ms29_49076540;
extern T0*ms30_55041151;
extern T0*ms64_87520;
extern T0*ms29_1957581;
extern T0*ms30_55041141;
extern T0*ms30_55041091;
extern T0*ms353_1955986872;
extern T0*ms360_129654140;
extern T0*ms317_1637927398bc289;
extern T0*ms235_297bc701;
extern T0*ms29_451011;
extern T0*ms411_305bc450c40;
extern T0*ms411_305bc450c39;
extern T0*ms392_1090184065;
extern T0*ms30_16616;
extern T0*ms30_55040391;
extern T0*ms450_882065083;
extern T0*ms238_580488532;
extern T0*ms289_759184012;
extern T0*ms27_267875778;
extern T0*ms442_570bc627;
extern T0*ms219_40031469;
extern T0*ms30_16639;
extern T0*ms294_168;
extern T0*ms232_565060278;
extern T0*ms30_55040401;
extern T0*ms30_55040341;
extern T0*ms289_254;
extern T0*ms30_16686;
extern T0*ms394_1965730bc476;
extern T0*ms29_479922190;
extern T0*ms289_274;
extern T0*ms421_53548636;
extern T0*ms80_305465997;
extern T0*ms358_413651;
extern T0*ms235_1102814319;
extern T0*ms235_179868158;
extern T0*ms627_1181502;
extern T0*ms291_3175bc220c39;
extern T0*ms29_396356;
extern T0*ms291_46525;
extern T0*ms294_671bc220;
extern T0*ms30_9529116;
extern T0*ms232_3430bc224;
extern T0*ms64_87520bc64;
extern T0*ms30_17422;
extern T0*ms232_586511651;
extern T0*ms360_296bc360;
extern T0*ms232_15351;
extern T0*ms241_188494264;
extern T0*ms499_593760881;
extern T0*ms291_52067;
extern T0*ms360_46980416;
extern T0*ms392_2251910;
extern T0*ms29_2063276;
extern T0*ms232_3430bc291;
extern T0*ms291_1800342110;
extern T0*ms30_2067759348;
extern T0*ms360_520388145;
extern T0*ms218_210141519;
extern T0*ms219_41125176;
extern T0*ms232_1460025642;
extern T0*ms30_18110;
extern T0*ms232_273443870;
extern T0*ms218_1071750288;
extern T0*ms238_46bc506c55;
extern T0*ms291_1665297219;
extern T0*ms232_3430bc450;
extern T0*ms25_1525604536;
extern T0*ms238_46bc511c28;
extern T0*ms294_671;
extern T0*ms241_18150bc499;
extern T0*ms232_1881374985;
extern T0*ms393_550508910;
extern T0*ms241_18150bc484;
extern T0*ms232_23988287;
extern T0*ms235_8884bc235;
extern T0*ms317_35157672;
extern T0*ms359_348;
extern T0*ms30_2038667775;
extern T0*ms493_160937;
extern T0*ms294_671bc499;
extern T0*ms317_1511378937;
extern T0*ms69_174945438;
extern T0*ms241_18150bc450;
extern T0*ms360_6411;
extern T0*ms484_2115846852;
extern T0*ms294_671bc625;
extern T0*ms359_1809088081;
extern T0*ms232_3430bc629;
extern T0*ms232_1156367484;
extern T0*ms436_246bc360c40l439;
extern T0*ms360_6425;
extern T0*ms289_82;
extern T0*ms241_18150bc357;
extern T0*ms239_2382bc332c16;
extern T0*ms239_893005;
extern T0*ms317_41131;
extern T0*ms436_246bc410c40l459;
extern T0*ms360_168532;
extern T0*ms360_6396;
extern T0*ms282_864187036;
extern T0*ms241_18150bc289;
extern T0*ms224_3475bc450c28;
extern T0*ms360_7025;
extern T0*ms232_862271166;
extern T0*ms224_3475bc450c44;
extern T0*ms241_18150bc317;
extern T0*ms360_6534;
extern T0*ms317_78629bc317;
extern T0*ms317_16510bc380;
extern T0*ms241_18150bc235;
extern T0*ms219_1565bc59;
extern T0*ms629_4999725;
extern T0*ms317_1112927266;
extern T0*ms241_2176510;
extern T0*ms317_1023363018;
extern T0*ms360_529853775;
extern T0*ms59_207160501;
extern T0*ms544_958639438;
extern T0*ms360_6810;
extern T0*ms232_277bc234c39;
extern T0*ms360_870841390;
extern T0*ms30_112335826;
extern T0*ms493_1216329562bc481;
extern T0*ms220_282;
extern T0*ms244_8198176;
extern T0*ms232_365905049;
extern T0*ms27_594bc235;
extern T0*ms219_1119207694;
extern T0*ms232_246893097;
extern T0*ms232_1704274529;
extern T0*ms30_9676326;
extern T0*ms469_360bc232;
extern T0*ms289_386819;
extern T0*ms352_8777401;
extern T0*ms291_618166083;
extern T0*ms30_30191860;
extern T0*ms220_397;
extern T0*ms232_251bc239c40;
extern T0*ms360_384465bc360c23;
extern T0*ms29_10315778;
extern T0*ms235_109;
extern T0*ms360_6946;
extern T0*ms232_16782;
extern T0*ms85_240bc241;
extern T0*ms85_240bc235;
extern T0*ms360_6965;
extern T0*ms85_240bc218;
extern T0*ms232_1618833880;
extern T0*ms394_1016822887;
extern T0*ms525_1083118122;
extern T0*ms346_8835;
extern T0*ms544_1069766146bc544;
extern T0*ms360_6995;
extern T0*ms411_305bc398c41;
extern T0*ms232_397592212;
extern T0*ms235_180;
extern T0*ms232_756717624;
extern T0*ms226_51895507;
extern T0*ms392_1650bc385c39;
extern T0*ms235_301;
extern T0*ms63_1750778;
extern T0*ms576_68224;
extern T0*ms232_17480;
extern T0*ms239_2382bc219;
extern T0*ms594_1121854;
extern T0*ms294_13424808;
extern T0*ms26_7779;
extern T0*ms235_326;
extern T0*ms239_2382bc234;
extern T0*ms235_327;
extern T0*ms235_333;
extern T0*ms235_334;
extern T0*ms357_7317;
extern T0*ms235_340;
extern T0*ms235_341;
extern T0*ms30_451899881;
extern T0*ms236_298390;
extern T0*ms235_297;
extern T0*ms235_402;
extern T0*ms235_298;
extern T0*ms80_139303084;
extern T0*ms411_305bc398c41l197;
extern T0*ms239_2382bc332;
extern T0*ms234_1645835456;
extern T0*ms27_16177;
extern T0*ms239_2382bc292;
extern T0*ms291_1196941282;
extern T0*ms232_565063403;
extern T0*ms360_8291;
extern T0*ms232_4620546;
extern T0*ms394_4179775;
extern T0*ms411_305bc398c41l204;
extern T0*ms232_4620481;
extern T0*ms234_308542101;
extern T0*ms232_54734511;
extern T0*ms232_1065652086;
extern T0*ms291_6755bc544;
extern T0*ms239_2382bc450;
extern T0*ms29_877484516;
extern T0*ms232_1238750212;
extern T0*ms235_603;
extern T0*ms239_1858528797;
extern T0*ms291_1772045883;
extern T0*ms239_2382bc517;
extern T0*ms25_1852009437;
extern T0*ms469_278;
extern T0*ms519_287;
extern T0*ms360_1679636650bc360;
extern T0*ms239_2382bc534;
extern T0*ms239_2382bc541;
extern T0*ms239_2382bc537;
extern T0*ms239_2382bc539;
extern T0*ms239_2382bc545;
extern T0*ms469_360;
extern T0*ms217_273430530bc217;
extern T0*ms360_8485;
extern T0*ms710_1199364167;
extern T0*ms235_674;
extern T0*ms236_1574136045;
extern T0*ms239_2382bc629;
extern T0*ms244_292482;
extern T0*ms544_101;
extern T0*ms66_1265;
extern T0*ms235_689;
extern T0*ms232_2055072316;
extern T0*ms26_8771;
extern T0*ms411_305bc360c40l1818;
extern T0*ms317_419bc317;
extern T0*ms499_1552636066;
extern T0*ms394_252339bc394c42;
extern T0*ms232_1330bc317c42;
extern T0*ms217_1417;
extern T0*ms232_1330bc317c40;
extern T0*ms234_379bc234;
extern T0*ms360_1174230416;
extern T0*ms360_946895bc360;
extern T0*ms450_1269;
extern T0*ms499_342169763;
extern T0*ms232_1642367158bc232c36;
extern T0*ms232_1642367158bc232c35;
extern T0*ms289_1115628985;
extern T0*ms499_69237763;
extern T0*ms360_1923619084;
extern T0*ms241_18150bc289c45l453;
extern T0*ms392_180128;
extern T0*ms232_5395053bc291c41l895;
extern T0*ms219_1374304640;
extern T0*ms235_57487;
extern T0*ms629_2142146116;
extern T0*ms360_813409;
extern T0*ms392_180037;
extern T0*ms291_1403828457;
extern T0*ms234_175857472;
extern T0*ms360_1923619234;
extern T0*ms220_287218105;
extern T0*ms360_8885;
extern T0*ms291_2121801775;
extern T0*ms357_8545;
extern T0*ms360_2138778683;
extern T0*ms30_440571;
extern T0*ms360_887295984;
extern T0*ms232_253935823;
extern T0*ms410_366bc410;
extern T0*ms219_1271;
extern T0*ms411_305bc289c39l245;
extern T0*ms219_1284;
extern T0*ms27_10714862;
extern T0*ms232_1063704391;
extern T0*ms219_1407;
extern T0*ms239_1581747096;
extern T0*ms29_14036;
extern T0*ms231_2035830473;
extern T0*ms360_1416678934;
extern T0*ms219_1284bc232c36;
extern T0*ms235_2109537640bc235c14l1160;
extern T0*ms219_1284bc232c37;
extern T0*ms232_1530032908bc232c35;
extern T0*ms410_366bc476;
extern T0*ms232_1530032908bc232c36;
extern T0*ms30_49076823;
extern T0*ms234_1682814572;
extern T0*ms27_17498;
extern T0*ms232_431043495;
extern T0*ms30_1554777;
extern T0*ms450_1676;
extern T0*ms232_1330bc360c40l90;
extern T0*ms28_8897;
extern T0*ms30_1549697;
extern T0*ms493_80037bc481;
extern T0*ms291_25822456bc291;
extern T0*ms629_4996600;
extern T0*ms234_15589;
extern T0*ms30_1549680;
extern T0*ms219_1565;
extern T0*ms224_2075;
extern T0*ms360_17743770;
extern T0*ms30_1549703;
extern T0*ms217_3040;
extern T0*ms317_9980719;
extern T0*ms232_451157bc219;
extern T0*ms241_12184;
extern T0*ms66_327902bc66;
extern T0*ms291_1747685533;
extern T0*ms217_3100;
extern T0*ms232_451157bc232;
extern T0*ms220_2947;
extern T0*ms701_10220290;
extern T0*ms232_1917882;
extern T0*ms80_767646015;
extern T0*ms360_17743865;
extern T0*ms232_1173628471;
extern T0*ms232_1234811086;
extern T0*ms232_411134193;
extern T0*ms30_1639475718;
extern T0*ms317_884381655;
extern T0*ms317_2030510390;
extern T0*ms27_2248290;
extern T0*ms232_860532685;
extern T0*ms380_279959115;
extern T0*ms232_451157bc289;
extern T0*ms701_387651299;
extern T0*ms241_12362;
extern T0*ms394_1385443480;
extern T0*ms329_657822788;
extern T0*ms59_522142839;
extern T0*ms289_1566831588;
extern T0*ms239_280139425;
extern T0*ms239_2382bc517c15;
extern T0*ms27_17498bc232;
extern T0*ms224_2395;
extern T0*ms232_1564992795;
extern T0*ms232_1082664800;
extern T0*ms279_1096544670;
extern T0*ms710_5580;
extern T0*ms317_1068122514;
extern T0*ms220_3760;
extern T0*ms238_46bc507;
extern T0*ms238_46bc511;
extern T0*ms238_46bc506;
extern T0*ms232_471707221;
extern T0*ms232_451157bc499;
extern T0*ms232_1330bc360c41l86;
extern T0*ms317_45355;
extern T0*ms235_39204698;
extern T0*ms66_0bc622c14l12;
extern T0*ms27_10714216;
extern T0*ms30_386854;
extern T0*ms232_1530032908bc232;
extern T0*ms63_60894;
extern T0*ms291_73472312;
extern T0*ms235_129391217;
extern T0*ms239_1418906530;
extern T0*ms30_1947419;
extern T0*ms232_2087300232;
extern T0*ms235_2109537640bc235;
extern T0*ms291_1208522276;
extern T0*ms235_1772235;
extern T0*ms235_2109537640bc232;
extern T0*ms436_246bc360c41l400;
extern T0*ms85_1587749191;
extern T0*ms436_246bc360c41l410;
extern T0*ms235_759424351;
extern T0*ms219_2072467813bc232;
extern T0*ms450_1387812168;
extern T0*ms29_56255230;
extern T0*ms436_246bc360c41l501;
extern T0*ms69_1861857328;
extern T0*ms236_646243744;
extern T0*ms30_1947246;
extern T0*ms30_1947251;
extern T0*ms232_923503323;
extern T0*ms232_1330bc317c42l1818;
extern T0*ms394_28032126bc394;
extern T0*ms436_246bc360c41l480;
extern T0*ms232_565066528;
extern T0*ms30_1831158645;
extern T0*ms360_17743865bc360;
extern T0*ms291_365929075;
extern T0*ms241_720902969;
extern T0*ms29_9909665;
extern T0*ms29_16001;
extern T0*ms701_10559665;
extern T0*ms235_6687bc235;
extern T0*ms436_246bc360c41l545;
extern T0*ms219_2072467813bc289;
extern T0*ms235_59731;
extern T0*ms436_246bc360c41l561;
extern T0*ms239_400297641bc234c45;
extern T0*ms63_200;
extern T0*ms66_0bc279c10;
extern T0*ms232_1253959973;
extern T0*ms232_1195084695;
extern T0*ms232_1728206941;
extern T0*ms219_1565bc289c26;
extern T0*ms30_438300;
extern T0*ms219_1565bc289c40;
extern T0*ms63_192;
extern T0*ms63_300;
extern T0*ms701_1331532446bc701;
extern T0*ms29_78591bc80;
extern T0*ms63_252;
extern T0*ms534_413927315;
extern T0*ms219_2072467813bc474;
extern T0*ms627_620926730;
extern T0*ms28_329bc701;
extern T0*ms28_334bc701;
extern T0*ms224_3475;
extern T0*ms235_1335;
extern T0*ms30_1202672333;
extern T0*ms359_9808515;
extern T0*ms69_543076045;
extern T0*ms220_1743948446;
extern T0*ms59_471bc59;
extern T0*ms498_529996976;
extern T0*ms232_10940631;
extern T0*ms544_419443;
extern T0*ms291_110557057;
extern T0*ms235_1438;
extern T0*ms360_1903915589;
extern T0*ms29_16264;
extern T0*ms392_1650bc360;
extern T0*ms232_6455bc219;
extern T0*ms64_740bc64;
extern T0*ms629_1172831412;
extern T0*ms450_16159bc426;
extern T0*ms392_1650bc385;
extern T0*ms392_1650bc387;
extern T0*ms80_1977886;
extern T0*ms460_205;
extern T0*ms219_497096041;
extern T0*ms30_567319806;
extern T0*ms30_567319812;
extern T0*ms360_91;
extern T0*ms291_1831440704;
extern T0*ms232_2022630;
extern T0*ms232_6455bc317;
extern T0*ms27_2246326;
extern T0*ms392_1650bc476;
extern T0*ms235_1626;
extern T0*ms360_804085bc360;
extern T0*ms392_1650bc499;
extern T0*ms232_6455bc360;
extern T0*ms291_2021999449;
extern T0*ms236_216;
extern T0*ms82_1861287086;
extern T0*ms232_16782bc499;
extern T0*ms627_25900;
extern T0*ms232_1968768303;
extern T0*ms392_1650bc627;
extern T0*ms235_2178;
extern T0*ms291_1058430701bc291;
extern T0*ms544_1506490209;
extern T0*ms241_194;
extern T0*ms232_6455bc450;
extern T0*ms235_1744;
extern T0*ms26_1090bc218c15;
extern T0*ms26_1090bc218c16;
extern T0*ms236_262;
extern T0*ms360_1586596820;
extern T0*ms411_305bc291c29l1281;
extern T0*ms29_16630;
extern T0*ms224_302501127;
extern T0*ms279_1747846;
extern T0*ms235_1775;
extern T0*ms30_76691bc450;
extern T0*ms317_1824713404;
extern T0*ms29_17221;
extern T0*ms239_1160736641;
extern T0*ms29_17176;
extern T0*ms59_6355;
extern T0*ms232_16782bc289;
extern T0*ms29_2593373;
extern T0*ms235_2440;
extern T0*ms29_16761;
extern T0*ms30_1944903;
extern T0*ms235_3291bc332c16l232;
extern T0*ms232_490869799;
extern T0*ms29_10648581;
extern T0*ms392_2251910bc627;
extern T0*ms544_97510;
extern T0*ms317_926003101;
extern T0*ms360_162070;
extern T0*ms291_604bc291;
extern T0*ms450_505232755;
extern T0*ms317_692075493;
extern T0*ms30_1856946950;
extern T0*ms232_16782bc232;
extern T0*ms232_16782bc219;
extern T0*ms224_339308075;
extern T0*ms627_32175;
extern T0*ms239_905827712;
extern T0*ms239_1264;
extern T0*ms629_173055;
extern T0*ms235_2565;
extern T0*ms235_3069;
extern T0*ms360_162020;
extern T0*ms220_43088975;
extern T0*ms305_1001314405;
extern T0*ms29_16942;
extern T0*ms29_1223234252bc80;
extern T0*ms66_1133285999;
extern T0*ms360_4881995;
extern T0*ms360_162010;
extern T0*ms493_138425bc481;
extern T0*ms235_3094;
extern T0*ms219_159025018;
extern T0*ms394_252339bc394;
extern T0*ms30_1395184171;
extern T0*ms232_32869;
extern T0*ms232_251bc219;
extern T0*ms30_2246041;
extern T0*ms232_33425;
extern T0*ms232_251bc232;
extern T0*ms30_1418282620;
extern T0*ms80_90141;
extern T0*ms235_3169;
extern T0*ms232_251bc239;
extern T0*ms239_942808765;
extern T0*ms291_236525;
extern T0*ms464_11300605bc463;
extern T0*ms464_11300605bc458;
extern T0*ms544_1396798042;
extern T0*ms464_11300605bc471;
extern T0*ms234_6559bc234;
extern T0*ms30_747962924;
extern T0*ms232_251bc317;
extern T0*ms410_21020045bc360;
extern T0*ms360_804085;
extern T0*ms232_901897617;
extern T0*ms29_18090;
extern T0*ms30_33120277;
extern T0*ms218_195766720;
extern T0*ms235_2833;
extern T0*ms317_635bc400c39;
extern T0*ms235_3291;
extern T0*ms232_1540494783;
extern T0*ms235_3294;
extern T0*ms232_251bc358;
extern T0*ms239_1130602126;
extern T0*ms29_17715;
extern T0*ms30_296bc410;
extern T0*ms224_1145546877;
extern T0*ms291_1058430701;
extern T0*ms26_1090bc218c15l154;
extern T0*ms30_1604515261;
extern T0*ms493_138425;
extern T0*ms392_1236593865;
extern T0*ms629_1212159;
extern T0*ms239_215791bc291;
extern T0*ms235_3494;
extern T0*ms236_1377208779;
extern T0*ms360_946895;
extern T0*ms235_1721407046;
extern T0*ms360_802840;
extern T0*ms241_18150bc450c45;
extern T0*ms219_6271;
extern T0*ms73_5757;
extern T0*ms239_215791bc239;
extern T0*ms234_40bc432;
extern T0*ms241_18150bc450c29;
extern T0*ms235_333bc235c25;
extern T0*ms29_10703002;
extern T0*ms232_495363549;
extern T0*ms232_34415;
extern T0*ms493_60837;
extern T0*ms450_6580;
extern T0*ms224_1844536619bc450;
extern T0*ms239_2382;
extern T0*ms232_565069653;
extern T0*ms30_312005144;
extern T0*ms235_207986277;
extern T0*ms59_8260;
extern T0*ms234_40bc234;
extern T0*ms232_12331bc360;
extern T0*ms232_526bc317;
extern T0*ms360_21064105;
extern T0*ms217_570bc217;
extern T0*ms217_570bc224;
extern T0*ms219_6550;
extern T0*ms232_526bc289;
extern T0*ms80_2085574777;
extern T0*ms289_674382779;
extern T0*ms232_12331bc317;
extern T0*ms69_1452518781;
extern T0*ms29_1072344038;
extern T0*ms219_49152444bc59;
extern T0*ms241_331100035;
extern T0*ms407_230bc360c40;
extern T0*ms291_614bc291c39l934;
extern T0*ms360_160146;
extern T0*ms317_4488096;
extern T0*ms232_1723513855bc232;
extern T0*ms408_1686701;
extern T0*ms30_180965424;
extern T0*ms329_240932594;
extern T0*ms30_180965430;
extern T0*ms232_1723513855bc236;
extern T0*ms232_738771309;
extern T0*ms360_77767;
extern T0*ms232_1723513855bc239;
extern T0*ms232_485090394;
extern T0*ms360_77773;
extern T0*ms219_6655;
extern T0*ms236_1816632501;
extern T0*ms360_83277;
extern T0*ms219_1384921237;
extern T0*ms30_180965447;
extern T0*ms226_899910547;
extern T0*ms360_83345;
extern T0*ms232_719604853;
extern T0*ms360_1326669899;
extern T0*ms29_10049231;
extern T0*ms218_354654986;
extern T0*ms239_283387313;
extern T0*ms30_577213499;
extern T0*ms450_7475;
extern T0*ms317_19199275;
extern T0*ms30_849712179;
extern T0*ms69_181806522;
extern T0*ms66_0bc622c14l231;
extern T0*ms232_431043495bc232;
extern T0*ms235_592781506;
extern T0*ms556_1115076;
extern T0*ms224_644847010bc627;
extern T0*ms358_18186;
extern T0*ms241_4750778;
extern T0*ms484_36460172;
extern T0*ms239_3393;
extern T0*ms30_2090604340;
extern T0*ms493_1530bc317;
extern T0*ms239_1853640928;
extern T0*ms68_1656731300;
extern T0*ms241_18036;
extern T0*ms30_9713026;
extern T0*ms411_305bc317c40;
extern T0*ms411_305bc317c42;
extern T0*ms360_84085;
extern T0*ms701_10220290bc701;
extern T0*ms701_1935504882;
extern T0*ms234_2109816196bc234;
extern T0*ms63_878860;
extern T0*ms544_484169497;
extern T0*ms66_1265bc236;
extern T0*ms234_32080;
extern T0*ms232_257bc232;
extern T0*ms241_18150;
extern T0*ms356_999609966;
extern T0*ms30_1739790308;
extern T0*ms30_175767198;
extern T0*ms360_4680700;
extern T0*ms68_745978733;
extern T0*ms232_697705640bc232c35;
extern T0*ms219_1549077634;
extern T0*ms30_9712276;
extern T0*ms235_69601;
extern T0*ms30_378799862;
extern T0*ms410_226bc410;
extern T0*ms232_257bc289;
extern T0*ms627_685204250;
extern T0*ms291_25822456;
extern T0*ms30_48958735;
extern T0*ms317_106047655;
extern T0*ms317_2117730851;
extern T0*ms244_8198176bc536;
extern T0*ms241_23410;
extern T0*ms450_8475;
extern T0*ms232_257bc394;
extern T0*ms232_257bc451;
extern T0*ms317_605650769;
extern T0*ms30_447584;
extern T0*ms360_1628970485;
extern T0*ms235_1247935972;
extern T0*ms235_448859;
extern T0*ms291_14464bc544;
extern T0*ms235_1067454155;
extern T0*ms392_180128bc392;
extern T0*ms235_539873441;
extern T0*ms232_257bc469;
extern T0*ms493_1216329562;
extern T0*ms246_3520;
extern T0*ms450_1642168697;
extern T0*ms30_2187483;
extern T0*ms333_835850355;
extern T0*ms544_2082029949;
extern T0*ms30_2187464;
extern T0*ms450_1032053803bc499;
extern T0*ms436_246;
extern T0*ms59_227;
extern T0*ms232_257bc614;
extern T0*ms410_226bc627;
extern T0*ms232_1656195746;
extern T0*ms27_2191641;
extern T0*ms235_69851;
extern T0*ms69_1038536453;
extern T0*ms218_3556890bc232;
extern T0*ms232_42279221;
extern T0*ms241_1109293176;
extern T0*ms30_36200588;
extern T0*ms66_360205908bc66;
extern T0*ms30_447851;
extern T0*ms232_1629400044;
extern T0*ms435_7506001;
extern T0*ms232_1580612071;
extern T0*ms30_1339128;
extern T0*ms66_0;
extern T0*ms30_1682815431;
extern T0*ms317_47598300;
extern T0*ms29_75797981;
extern T0*ms360_2122389958;
extern T0*ms232_22971612;
extern T0*ms544_291421585;
extern T0*ms59_471;
extern T0*ms317_2054563574;
extern T0*ms232_2041682bc232c21l977;
extern T0*ms392_244699380bc627c40;
extern T0*ms360_68406039;
extern T0*ms232_2041682bc232c21l991;
extern T0*ms317_1659544035;
extern T0*ms411_305bc450c40l599;
extern T0*ms69_1538234998;
extern T0*ms442_162019;
extern T0*ms29_251916328;
extern T0*ms236_1950567157;
extern T0*ms294_219885238;
extern T0*ms442_898426;
extern T0*ms360_1679626025bc360;
extern T0*ms68_1385667261;
extern T0*ms410_240bc232;
extern T0*ms219_1428771266;
extern T0*ms30_1604522960;
extern T0*ms30_1530432238;
extern T0*ms597_1139569132;
extern T0*ms232_5395053;
extern T0*ms235_51699930;
extern T0*ms291_212314278;
extern T0*ms360_427390771;
extern T0*ms506_276;
extern T0*ms217_570;
extern T0*ms30_1326673961;
extern T0*ms66_327902;
extern T0*ms236_1378502623;
extern T0*ms410_240bc315;
extern T0*ms291_176986;
extern T0*ms66_0bc235c39l935;
extern T0*ms30_1286698901;
extern T0*ms232_36951;
extern T0*ms232_325655889;
extern T0*ms66_0bc235c9;
extern T0*ms317_61699;
extern T0*ms29_2185421;
extern T0*ms410_240bc283;
extern T0*ms235_6687;
extern T0*ms239_1404148845bc234;
extern T0*ms701_1760616840;
extern T0*ms64_740;
extern T0*ms411_305bc360c41l74;
extern T0*ms232_1642367158bc232c36l384;
extern T0*ms410_240bc360;
extern T0*ms410_240bc405;
extern T0*ms450_1575353618;
extern T0*ms410_240bc358;
extern T0*ms301_178490;
extern T0*ms232_1642367158bc232c36l372;
extern T0*ms410_240bc359;
extern T0*ms450_1125599189;
extern T0*ms235_447734;
extern T0*ms235_76405;
extern T0*ms360_1008067448;
extern T0*ms360_1102979958;
extern T0*ms410_240bc431;
extern T0*ms410_240bc432;
extern T0*ms232_444175272;
extern T0*ms530_672729595;
extern T0*ms30_552bc627;
extern T0*ms232_941548611bc232c36;
extern T0*ms218_809686569;
extern T0*ms597_888288799;
extern T0*ms232_781060556;
extern T0*ms232_1330bc232c37l1428;
extern T0*ms360_6946bc360;
extern T0*ms218_1711985232;
extern T0*ms317_382bc59;
extern T0*ms30_1297876698;
extern T0*ms360_534333098;
extern T0*ms232_2039472678;
extern T0*ms355_134876560;
extern T0*ms232_1330bc232c35l1672;
extern T0*ms291_2021999449bc291;
extern T0*ms544_576790349;
extern T0*ms701_1331532446;
extern T0*ms484_308580;
extern T0*ms411_29585;
extern T0*ms239_6330;
extern T0*ms232_490486762;
extern T0*ms30_1223936132;
extern T0*ms241_124311631;
extern T0*ms232_1723513855;
extern T0*ms219_1203432441;
extern T0*ms289_1484470448;
extern T0*ms701_2072196164;
extern T0*ms291_614bc291c39;
extern T0*ms224_18131599bc450;
extern T0*ms291_614bc291c41;
extern T0*ms476_4425;
extern T0*ms66_0bc351c14;
extern T0*ms499_2746980;
extern T0*ms291_249330648;
extern T0*ms317_635bc499c39;
extern T0*ms241_2141291014;
extern T0*ms232_1880060695;
extern T0*ms234_1982839385;
extern T0*ms235_7809;
extern T0*ms29_2234341;
extern T0*ms544_1396;
extern T0*ms360_87090;
extern T0*ms30_279656751;
extern T0*ms85_240bc80;
extern T0*ms232_850522083;
extern T0*ms360_10089540;
extern T0*ms66_360205908;
extern T0*ms544_1973244310;
extern T0*ms627_48939847bc627;
extern T0*ms235_7878;
extern T0*ms360_1220661594;
extern T0*ms235_395994;
extern T0*ms232_5395053bc232c36;
extern T0*ms476_744;
extern T0*ms544_913822046;
extern T0*ms360_60405bc317;
extern T0*ms360_10089690;
extern T0*ms235_50863580;
extern T0*ms235_9107;
extern T0*ms232_6455bc360c42;
extern T0*ms451_2009909053;
extern T0*ms235_9121;
extern T0*ms26_579450289;
extern T0*ms235_9073;
extern T0*ms232_431043495bc232c35;
extern T0*ms232_431043495bc232c36;
extern T0*ms360_60405bc360;
extern T0*ms544_28263330;
extern T0*ms360_59375621;
extern T0*ms544_998144220;
extern T0*ms30_43bc360c40;
extern T0*ms411_305bc360c40l139;
extern T0*ms236_1105551897;
extern T0*ms232_1330bc219;
extern T0*ms317_1191155066;
extern T0*ms232_1330bc226;
extern T0*ms232_1330bc232;
extern T0*ms29_2233396;
extern T0*ms219_54714979;
extern T0*ms239_1099040180;
extern T0*ms235_9220;
extern T0*ms232_1330bc239;
extern T0*ms224_1844536619;
extern T0*ms235_9222;
extern T0*ms232_251bc317c40l1742;
extern T0*ms30_1735712398;
extern T0*ms539_2417;
extern T0*ms232_1565125654;
extern T0*ms232_1330bc317;
extern T0*ms26_1090bc235c16;
extern T0*ms360_15020bc360c40;
extern T0*ms235_8801;
extern T0*ms232_27063164;
extern T0*ms629_205909;
extern T0*ms597_263008962;
extern T0*ms232_1330bc291;
extern T0*ms29_10990481;
extern T0*ms450_1485929081;
extern T0*ms232_1330bc360;
extern T0*ms219_1328320695;
extern T0*ms317_273431355bc629;
extern T0*ms232_1330bc359;
extern T0*ms232_277bc217;
extern T0*ms30_124;
extern T0*ms30_126;
extern T0*ms317_273431355bc626;
extern T0*ms232_1836282258;
extern T0*ms317_273431355bc624;
extern T0*ms232_277bc232;
extern T0*ms232_277bc234;
extern T0*ms29_265093627;
extern T0*ms317_273431355bc499;
extern T0*ms232_1330bc394;
extern T0*ms235_3291bc332;
extern T0*ms239_162838175bc234;
extern T0*ms235_301485;
extern T0*ms232_1330bc450;
extern T0*ms235_3291bc334;
extern T0*ms232_712350300;
extern T0*ms26_142550;
extern T0*ms317_273431355bc493;
extern T0*ms235_120239233;
extern T0*ms30_220;
extern T0*ms232_1330bc450c41;
extern T0*ms232_1154403080;
extern T0*ms235_8884;
extern T0*ms30_217;
extern T0*ms30_218;
extern T0*ms498_56845112bc553;
extern T0*ms317_273431355bc484;
extern T0*ms232_1330bc450c28;
extern T0*ms411_305bc232c35l1709;
extern T0*ms235_8889;
extern T0*ms232_4692662;
extern T0*ms235_830570470;
extern T0*ms30_1300046706;
extern T0*ms30_1574640467;
extern T0*ms232_1330bc479;
extern T0*ms627_6575105;
extern T0*ms576_1932458562;
extern T0*ms232_277bc289;
extern T0*ms360_134878499;
extern T0*ms291_81437;
extern T0*ms235_8976;
extern T0*ms30_1176378494;
extern T0*ms232_1330bc556;
extern T0*ms476_6305;
extern T0*ms317_1990989;
extern T0*ms235_8991;
extern T0*ms29_212160365;
extern T0*ms224_2120987577;
extern T0*ms544_161665;
extern T0*ms30_282;
extern T0*ms232_251bc317c40;
extern T0*ms59_1203674198;
extern T0*ms232_1339521386;
extern T0*ms498_56845112;
extern T0*ms474_161951;
extern T0*ms232_277bc394;
extern T0*ms30_296;
extern T0*ms232_277bc451;
extern T0*ms30_840111968;
extern T0*ms30_361;
extern T0*ms235_3291bc541;
extern T0*ms235_3291bc542;
extern T0*ms235_3291bc543;
extern T0*ms239_162838175bc450;
extern T0*ms30_371;
extern T0*ms30_1622700141;
extern T0*ms232_277bc469;
extern T0*ms241_49203356;
extern T0*ms30_548331507;
extern T0*ms232_277bc484;
extern T0*ms410_240bc360c40;
extern T0*ms410_240bc360c41;
extern T0*ms66_0bc232c11l739;
extern T0*ms232_401124480;
extern T0*ms239_162838175bc484;
extern T0*ms239_7869;
extern T0*ms232_1994813154;
extern T0*ms232_993675817;
extern T0*ms241_4492176;
extern T0*ms219_1271bc232;
extern T0*ms241_2018315248;
extern T0*ms232_284bc232;
extern T0*ms30_534;
extern T0*ms360_388821092;
extern T0*ms30_728963476;
extern T0*ms219_1240206596;
extern T0*ms30_552;
extern T0*ms226_1797674551;
extern T0*ms66_0bc66;
extern T0*ms66_0bc68;
extern T0*ms66_0bc80;
extern T0*ms29_10193105;
extern T0*ms291_742356016;
extern T0*ms235_39617954;
extern T0*ms235_84381;
extern T0*ms291_742356033;
extern T0*ms30_636;
extern T0*ms544_1411018665;
extern T0*ms30_280482649;
extern T0*ms219_1271bc360;
extern T0*ms219_1271bc405;
extern T0*ms231_10bc484;
extern T0*ms30_669;
extern T0*ms218_1430004157;
extern T0*ms360_304601115;
extern T0*ms232_1642367158bc232;
extern T0*ms232_1281004126;
extern T0*ms360_1887064762;
extern T0*ms232_391886489;
extern T0*ms224_1042003640;
extern T0*ms701_387651299bc701;
extern T0*ms356_52798383;
extern T0*ms30_1597390874;
extern T0*ms30_53339;
extern T0*ms394_1295bc232;
extern T0*ms59_21571428;
extern T0*ms238_1616517694;
extern T0*ms710_1556476521;
extern T0*ms625_4434071;
extern T0*ms359_54686040;
extern T0*ms392_244699380bc392c40;
extern T0*ms235_3291bc541c19l241;
extern T0*ms217_16487;
extern T0*ms30_9647090;
extern T0*ms329_1426;
extern T0*ms29_1473988901;
extern T0*ms219_118716790;
extern T0*ms629_558682149;
extern T0*ms59_471bc359;
extern T0*ms239_8880;
extern T0*ms442_236;
extern T0*ms239_400297641bc499;
extern T0*ms219_10322525;
extern T0*ms59_471bc360;
extern T0*ms317_1489891655;
extern T0*ms239_2189840;
extern T0*ms239_400297641bc484;
extern T0*ms392_485184123;
extern T0*ms231_10bc220;
extern T0*ms59_471bc317;
extern T0*ms436_809795bc403;
extern T0*ms436_809795bc360;
extern T0*ms66_0bc235c30l931;
extern T0*ms317_9954400;
extern T0*ms239_400297641bc450;
extern T0*ms317_2039095413;
extern T0*ms59_471bc232;
extern T0*ms30_756809447;
extern T0*ms481_1956008156;
extern T0*ms291_1040644265;
extern T0*ms218_322;
extern T0*ms232_1312728230;
extern T0*ms235_5528704;
extern T0*ms30_705019679;
extern T0*ms544_692716864;
extern T0*ms239_400297641bc329;
extern T0*ms360_1679626025;
extern T0*ms234_1911279888;
extern T0*ms236_1737672775;
extern T0*ms231_10;
extern T0*ms29_2032026;
extern T0*ms329_706329;
extern T0*ms291_1414;
extern T0*ms232_1533928773;
extern T0*ms317_646768902;
extern T0*ms239_400297641bc234;
extern T0*ms442_570;
extern T0*ms232_1777292479;
extern T0*ms279_1826;
extern T0*ms232_1350760769;
extern T0*ms236_36778611;
extern T0*ms450_7475bc629;
extern T0*ms400_56655830;
extern T0*ms235_91157;
extern T0*ms358_241bc291;
extern T0*ms232_941548611bc232;
extern T0*ms360_1516064621;
extern T0*ms85_240;
extern T0*ms239_2382bc450c30;
extern T0*ms317_202031759;
extern T0*ms317_1124779458;
extern T0*ms450_16159;
extern T0*ms30_1501191bc435;
extern T0*ms317_252669317;
extern T0*ms235_3291bc541c19;
extern T0*ms29_1168210079;
extern T0*ms291_171955;
extern T0*ms291_1646;
extern T0*ms291_1651;
extern T0*ms360_842325609;
extern T0*ms239_1586354711;
extern T0*ms232_1307483215;
extern T0*ms457_506;
extern T0*ms239_7869bc317c43;
extern T0*ms239_6330bc234;
extern T0*ms239_7869bc317c44;
extern T0*ms484_1838958244;
extern T0*ms235_1588150185;
extern T0*ms241_2001191;
extern T0*ms232_1530032908bc232c36l446;
extern T0*ms493_80037;
extern T0*ms227_128358027;
extern T0*ms234_163909964;
extern T0*ms234_1572014572;
extern T0*ms29_306165094;
extern T0*ms219_49917876;
extern T0*ms287_37095bc289;
extern T0*ms402_180503525;
extern T0*ms350_1043;
extern T0*ms291_377bc291;
extern T0*ms232_1661632742;
extern T0*ms450_1694771411bc629;
extern T0*ms329_585895143;
extern T0*ms232_1642367158;
extern T0*ms360_933501;
extern T0*ms66_838840612;
extern T0*ms338_1478;
extern T0*ms219_444775459;
extern T0*ms627_47187;
extern T0*ms329_3293;
extern T0*ms291_992457137;
extern T0*ms394_750bc480;
extern T0*ms232_1601653158;
extern T0*ms450_1096872141;
extern T0*ms232_93;
extern T0*ms394_352968782;
extern T0*ms544_1265395998;
extern T0*ms317_705408837;
extern T0*ms436_29662;
extern T0*ms25_85614bc255;
extern T0*ms360_340514;
extern T0*ms219_6550bc627;
extern T0*ms544_1682659883;
extern T0*ms30_2035472654;
extern T0*ms290_2014364610;
extern T0*ms63_2082988666;
extern T0*ms239_6330bc701;
extern T0*ms232_1295bc360;
extern T0*ms232_1295bc411;
extern T0*ms69_256559978;
extern T0*ms219_1284bc232;
extern T0*ms385_10007800;
extern T0*ms219_1284bc239;
extern T0*ms329_948421114;
extern T0*ms291_3175;
extern T0*ms360_1567661459;
extern T0*ms219_1284bc317;
extern T0*ms289_46733806;
extern T0*ms69_543076045bc69;
extern T0*ms499_2000361;
extern T0*ms553_5317;
extern T0*ms710_103345652;
extern T0*ms232_475921520;
extern T0*ms219_1284bc360;
extern T0*ms432_41;
extern T0*ms219_1284bc410;
extern T0*ms219_1284bc411;
extern T0*ms394_847125;
extern T0*ms239_1724182721;
extern T0*ms30_1744399653;
extern T0*ms232_1901889757;
extern T0*ms553_5417;
extern T0*ms436_902517583;
extern T0*ms360_511943145;
extern T0*ms232_471553120bc232;
extern T0*ms421_680166993;
extern T0*ms59_227bc289;
extern T0*ms27_1777434714;
extern T0*ms30_1115958189;
extern T0*ms597_1927020241;
extern T0*ms232_301786;
extern T0*ms224_106460275;
extern T0*ms544_6830;
extern T0*ms30_279523519;
extern T0*ms218_113009969;
extern T0*ms317_300665;
extern T0*ms289_1111279623;
extern T0*ms544_7374;
extern T0*ms29_17176bc238;
extern T0*ms232_824324978;
extern T0*ms235_333bc235;
extern T0*ms30_1157;
extern T0*ms432_41bc360;
extern T0*ms411_305bc291c29;
extern T0*ms411_305bc291c40;
extern T0*ms415_178948;
extern T0*ms26_104;
extern T0*ms411_305bc291c39;
extern T0*ms30_1235;
extern T0*ms235_99bc701;
extern T0*ms69_332623945;
extern T0*ms26_118;
extern T0*ms30_1247;
extern T0*ms30_2174354;
extern T0*ms224_1783951564;
extern T0*ms232_316342789;
extern T0*ms232_738637120;
extern T0*ms622_277;
extern T0*ms291_90782;
extern T0*ms291_1360462097;
extern T0*ms232_451157;
extern T0*ms241_1631593164;
extern T0*ms291_90792;
extern T0*ms291_3175bc220;
extern T0*ms432_41bc232;
extern T0*ms235_273430505bc217;
extern T0*ms629_56760755;
extern T0*ms291_1029549485;
extern T0*ms701_10559665bc701;
extern T0*ms317_2118444283;
extern T0*ms627_99866859;
extern T0*ms218_1711985232bc232;
extern T0*ms69_372047073;
extern T0*ms219_49680837;
extern T0*ms219_15915;
extern T0*ms30_1427;
extern T0*ms291_3175bc317;
extern T0*ms627_1132;
extern T0*ms30_207673214;
extern T0*ms411_305bc59;
extern T0*ms30_207673231;
extern T0*ms234_40;
extern T0*ms291_3175bc346;
extern T0*ms244_439490016;
extern T0*ms291_3175bc360;
extern T0*ms239_30604924;
extern T0*ms241_12184bc241;
extern T0*ms244_2123229206;
extern T0*ms30_2104;
extern T0*ms291_3175bc385;
extern T0*ms291_3175bc387;
extern T0*ms317_687744958;
extern T0*ms317_915251302;
extern T0*ms345_3190;
extern T0*ms30_267647687;
extern T0*ms450_180709512;
extern T0*ms629_283801480;
extern T0*ms241_2047201942;
extern T0*ms217_1981256377;
extern T0*ms317_526175446;
extern T0*ms217_1197714671;
extern T0*ms68_42698349;
extern T0*ms627_1297;
extern T0*ms291_3175bc544;
extern T0*ms29_661bc291;
extern T0*ms30_243411981;
extern T0*ms360_1243717377;
extern T0*ms360_8485bc360;
extern T0*ms503_265537649;
extern T0*ms357_257bc499;
extern T0*ms241_2047202317;
extern T0*ms360_1458627261;
extern T0*ms234_1624663341bc234;
extern T0*ms232_1604142009;
extern T0*ms30_591414963;
extern T0*ms232_389672;
extern T0*ms394_252339;
extern T0*ms450_1880914324;
extern T0*ms289_26975282;
extern T0*ms329_5720;
extern T0*ms239_1916291223;
extern T0*ms234_1201497496;
extern T0*ms544_775406525;
extern T0*ms219_2077255577;
extern T0*ms219_16927;
extern T0*ms29_937397683;
extern T0*ms30_2504;
extern T0*ms219_101227749;
extern T0*ms219_453998;
extern T0*ms442_898426bc410;
extern T0*ms219_1994852bc239;
extern T0*ms235_530877013;
extern T0*ms232_149822297;
extern T0*ms618_3468;
extern T0*ms544_77282146;
extern T0*ms291_1574324912;
extern T0*ms241_599810839;
extern T0*ms69_348041349;
extern T0*ms29_9790205;
extern T0*ms30_2218105;
extern T0*ms450_567426438;
extern T0*ms219_398948;
extern T0*ms544_1242450095;
extern T0*ms219_1994852bc291;
extern T0*ms30_3075;
extern T0*ms235_99;
extern T0*ms394_264bc394;
extern T0*ms30_253393261;
extern T0*ms232_1773201687;
extern T0*ms428_207996821;
extern T0*ms239_1924772383;
extern T0*ms239_997623147;
extern T0*ms238_1442714837;
extern T0*ms235_89862;
extern T0*ms317_244793715;
extern T0*ms30_275488632;
extern T0*ms236_1377208779bc236;
extern T0*ms224_317;
extern T0*ms394_1261705;
extern T0*ms30_827429162;
extern T0*ms224_277;
extern T0*ms232_33425bc232;
extern T0*ms627_4766225;
extern T0*ms518_902076231;
extern T0*ms411_1832;
extern T0*ms627_999291000;
extern T0*ms30_3421;
extern T0*ms30_324411;
extern T0*ms629_472574902;
extern T0*ms236_772432310;
extern T0*ms287_37095;
extern T0*ms239_1934139;
extern T0*ms30_3501;
extern T0*ms232_2041682bc232c21;
extern T0*ms30_3460;
extern T0*ms629_2301;
extern T0*ms393_1888091524;
extern T0*ms594_324bc235;
extern T0*ms30_3472;
extern T0*ms29_396356bc474c39;
extern T0*ms30_3474;
extern T0*ms360_162010bc317;
extern T0*ms317_826425832bc289;
extern T0*ms30_591417242;
extern T0*ms235_3291bc332c16;
extern T0*ms241_67;
extern T0*ms63_10926944;
extern T0*ms232_2096892436;
extern T0*ms239_204;
extern T0*ms235_466551816;
extern T0*ms80_817932306;
extern T0*ms291_407207;
extern T0*ms226_253892190;
extern T0*ms317_826425832bc450;
extern T0*ms291_54686284;
extern T0*ms360_10895;
extern T0*ms317_754574290;
extern T0*ms291_7066;
extern T0*ms244_251;
extern T0*ms232_511465169;
extern T0*ms411_305bc289c40;
extern T0*ms30_3669;
extern T0*ms411_305bc289c41;
extern T0*ms411_305bc289c42;
extern T0*ms411_305bc289c39;
extern T0*ms627_227751;
extern T0*ms29_1939265372;
extern T0*ms232_1988895671bc232;
extern T0*ms30_1740332382;
extern T0*ms232_697705640bc232;
extern T0*ms232_1240218271;
extern T0*ms317_2092663259;
extern T0*ms291_6755;
extern T0*ms80_957054969;
extern T0*ms217_2115332211;
extern T0*ms29_3073;
extern T0*ms66_1185293475bc66;
extern T0*ms29_3085;
extern T0*ms241_9897510;
extern T0*ms241_18150bc59c45;
extern T0*ms289_1185483839;
extern T0*ms29_3175;
extern T0*ms317_78082;
extern T0*ms360_1679636650;
extern T0*ms30_1483884743;
extern T0*ms219_30034;
extern T0*ms359_1961687;
extern T0*ms66_0bc232;
extern T0*ms29_3249;
extern T0*ms499_1156329759;
extern T0*ms239_589;
extern T0*ms241_2047202317bc241;
extern T0*ms66_0bc235;
extern T0*ms241_50040236;
extern T0*ms66_0bc236;
extern T0*ms239_660;
extern T0*ms291_1341105285;
extern T0*ms66_0bc246;
extern T0*ms66_0bc301;
extern T0*ms309_270;
extern T0*ms629_9589368;
extern T0*ms234_1059359695;
extern T0*ms470_920950;
extern T0*ms232_1988895671bc499;
extern T0*ms66_0bc317;
extern T0*ms29_1509818;
extern T0*ms30_1957775868;
extern T0*ms29_3349;
extern T0*ms66_0bc279;
extern T0*ms30_954385774;
extern T0*ms544_598811726;
extern T0*ms63_1224218969;
extern T0*ms29_3415;
extern T0*ms218_1662662954;
extern T0*ms360_18482240;
extern T0*ms66_0bc351;
extern T0*ms358_3196;
extern T0*ms232_5367889;
extern T0*ms29_1839765037;
extern T0*ms360_189390bc360;
extern T0*ms232_1330bc232c38;
extern T0*ms232_1330bc232c37;
extern T0*ms232_1330bc232c36;
extern T0*ms232_1500500537;
extern T0*ms30_65574;
extern T0*ms232_1330bc232c35;
extern T0*ms360_108351709;
extern T0*ms291_160930;
extern T0*ms219_1565bc232c30;
extern T0*ms232_163413385;
extern T0*ms69_1578831409;
extern T0*ms232_1102979933;
extern T0*ms217_16487bc291c26;
extern T0*ms291_89821;
extern T0*ms66_0bc500;
extern T0*ms219_1565bc232c38;
extern T0*ms69_1604340919;
extern T0*ms66_0bc504;
extern T0*ms232_713312393;
extern T0*ms66_0bc511;
extern T0*ms66_0bc506;
extern T0*ms465_372bc360;
extern T0*ms66_0bc520;
extern T0*ms239_934;
extern T0*ms29_3601;
extern T0*ms291_1815688614;
extern T0*ms219_189437896;
extern T0*ms29_400652;
extern T0*ms66_0bc496;
extern T0*ms553_327;
extern T0*ms232_374291339;
extern T0*ms66_0bc615;
extern T0*ms66_0bc622;
extern T0*ms29_3645;
extern T0*ms29_3595;
extern T0*ms220_614557109;
extern T0*ms66_0bc627;
extern T0*ms66_0bc583;
extern T0*ms544_1295032451;
extern T0*ms291_69352117bc291;
extern T0*ms627_1291760099;
extern T0*ms66_0bc701;
extern T0*ms66_0bc597;
extern T0*ms358_3496;
extern T0*ms238_46;
extern T0*ms236_1865554673;
extern T0*ms317_78629;
extern T0*ms255_624587783;
extern T0*ms232_499425548;
extern T0*ms334_293;
extern T0*ms30_1498845794;
extern T0*ms334_294;
extern T0*ms27_385751;
extern T0*ms220_4631170;
extern T0*ms235_1255802680;
extern T0*ms219_1215177661;
extern T0*ms30_55926626;
extern T0*ms481_2187432;
extern T0*ms701_1439959996;
extern T0*ms27_2191641bc232;
extern T0*ms69_432335312;
extern T0*ms317_111269879;
extern T0*ms232_2145444338;
extern T0*ms544_11381817;
extern T0*ms544_1314337673;
extern T0*ms291_8624;
extern T0*ms360_177459204;
extern T0*ms279_32450971;
extern T0*ms618_228;
extern T0*ms701_1942675017;
extern T0*ms450_1938986363;
extern T0*ms219_197159;
extern T0*ms220_1288915017bc220;
extern T0*ms239_1404148845bc234c40;
extern T0*ms235_1058443417;
extern T0*ms305_1060258809;
extern T0*ms59_471bc317c40;
extern T0*ms226_1568216255;
extern T0*ms80_374877;
extern T0*ms291_1843146228;
extern T0*ms232_726227573;
extern T0*ms372_3147;
extern T0*ms484_958964069;
extern T0*ms519_80251;
extern T0*ms219_1193180751;
extern T0*ms436_809795bc360c41;
extern T0*ms291_11241768;
extern T0*ms235_6159594;
extern T0*ms360_188188376;
extern T0*ms317_476433922;
extern T0*ms317_90405963;
extern T0*ms27_336;
extern T0*ms360_1155996628;
extern T0*ms232_179423058;
extern T0*ms66_0bc622c14;
extern T0*ms30_839855894;
extern T0*ms701_482960256;
extern T0*ms69_74239;
extern T0*ms239_389675;
extern T0*ms69_175744216;
extern T0*ms224_1426099398;
extern T0*ms544_1069766146;
extern T0*ms294_168bc220;
extern T0*ms232_1957408550;
extern T0*ms29_402346;
extern T0*ms69_175744241;
extern T0*ms317_25969530;
extern T0*ms428_13290;
extern T0*ms360_245384155;
extern T0*ms360_965636096;
extern T0*ms360_29107967;
extern T0*ms289_1923813010;
extern T0*ms235_270309168;
extern T0*ms235_186217457;
extern T0*ms415_1096645863;
extern T0*ms232_1965252672;
extern T0*ms69_175744316;
extern T0*ms69_1700247488;
extern T0*ms30_1209184326;
extern T0*ms317_635bc220;
extern T0*ms30_10377643;
extern T0*ms360_15020;
extern T0*ms360_467677827;
extern T0*ms317_273431355bc59;
extern T0*ms232_471553120;
extern T0*ms80_2108992007;
extern T0*ms80_139303084bc29;
extern T0*ms29_54418471;
extern T0*ms29_401994;
extern T0*ms80_1689176777;
extern T0*ms317_635bc317;
extern T0*ms232_889346373;
extern T0*ms27_594;
extern T0*ms360_8291bc360;
extern T0*ms232_2103819988;
extern T0*ms317_635bc291;
extern T0*ms80_17696;
extern T0*ms317_635bc400;
extern T0*ms317_635bc346;
extern T0*ms282_1262756502;
extern T0*ms235_2077353217;
extern T0*ms317_3209bc360;
extern T0*ms26_1042405932;
extern T0*ms627_7118;
extern T0*ms317_635bc385;
extern T0*ms317_635bc387;
extern T0*ms317_635bc392;
extern T0*ms358_55156846;
extern T0*ms317_635bc450;
extern T0*ms239_341357508;
extern T0*ms241_401981819;
extern T0*ms30_1206543966;
extern T0*ms329_2028521226;
extern T0*ms627_169510;
extern T0*ms317_635bc481;
extern T0*ms317_635bc476;
extern T0*ms317_635bc484;
extern T0*ms219_2006740748;
extern T0*ms317_635bc493;
extern T0*ms236_1814748872;
extern T0*ms394_28032126bc394c42;
extern T0*ms241_12362bc29;
extern T0*ms30_55924644;
extern T0*ms394_28032126bc394c41;
extern T0*ms69_175744666;
extern T0*ms30_1245671098;
extern T0*ms317_635bc499;
extern T0*ms218_1293738877;
extern T0*ms236_1131876546;
extern T0*ms236_601041072;
extern T0*ms69_175744691;
extern T0*ms291_1748680500;
extern T0*ms244_672350142;
extern T0*ms220_726728775;
extern T0*ms217_561301605;
extern T0*ms394_264;
extern T0*ms518_520647979;
extern T0*ms30_261093457;
extern T0*ms282_1413407004;
extern T0*ms450_988243818;
extern T0*ms235_11253;
extern T0*ms360_15533;
extern T0*ms457_506bc232;
extern T0*ms232_1330bc219c40;
extern T0*ms232_351488799;
extern T0*ms66_1185293475;
extern T0*ms77_15195;
extern T0*ms279_193194;
extern T0*ms220_1288915017;
extern T0*ms220_46350;
extern T0*ms410_226bc627c39;
extern T0*ms239_437780;
extern T0*ms236_1377208779bc236c39l1557;
extern T0*ms77_15370;
extern T0*ms238_46bc511c8;
extern T0*ms238_46bc506c8;
extern T0*ms30_39154229;
extern T0*ms317_8436bc317;
extern T0*ms224_33475;
extern T0*ms241_18150bc357c29;
extern T0*ms239_437715;
extern T0*ms235_17494489;
extern T0*ms291_244523906;
extern T0*ms450_41159;
extern T0*ms220_411283072;
extern T0*ms232_1330bc360c41l1046;
extern T0*ms232_1530032908;
extern T0*ms394_750;
extern T0*ms217_77412bc627;
extern T0*ms317_775396;
extern T0*ms66_0bc80c14;
extern T0*ms436_246bc360c40;
extern T0*ms436_246bc410c40;
extern T0*ms436_246bc360c41;
extern T0*ms232_1330bc360c41l1015;
extern T0*ms436_246bc410c39;
extern T0*ms217_77412bc499;
extern T0*ms392_180037bc392;
extern T0*ms30_80109;
extern T0*ms30_50246319;
extern T0*ms217_77412bc476;
extern T0*ms403_162095;
extern T0*ms236_1377208779bc236c39;
extern T0*ms239_7869bc219;
extern T0*ms289_2111741;
extern T0*ms239_7869bc232;
extern T0*ms69_1923039443;
extern T0*ms80_2100317873;
extern T0*ms217_77412bc394;
extern T0*ms544_585110409;
extern T0*ms234_32080bc317;
extern T0*ms392_1650;
extern T0*ms238_1152235958;
extern T0*ms220_47278;
extern T0*ms239_7869bc317;
extern T0*ms239_7869bc360;
extern T0*ms236_1142598643;
extern T0*ms394_1295;
extern T0*ms239_7869bc411;
extern T0*ms232_660780608;
extern T0*ms217_77412bc317;
extern T0*ms59_1761241425;
extern T0*ms235_13028;
extern T0*ms30_167970159;
extern T0*ms291_255bc450;
extern T0*ms358_449661;
extern T0*ms30_550709268;
extern T0*ms232_1793244543;
extern T0*ms30_80416;
extern T0*ms241_300594bc218;
extern T0*ms241_300594bc232;
extern T0*ms217_77412bc224;
extern T0*ms30_39002989;
extern T0*ms217_77412bc217;
extern T0*ms291_2051940780;
extern T0*ms29_264667428;
extern T0*ms239_7869bc484;
extern T0*ms411_305bc499c39;
extern T0*ms360_829308144;
extern T0*ms291_1648235130;
extern T0*ms235_217674;
extern T0*ms235_218174;
extern T0*ms232_218198560;
extern T0*ms30_586229245;
extern T0*ms385_400650bc346;
extern T0*ms232_1040899642;
extern T0*ms66_0bc232c11;
extern T0*ms411_305bc360c40;
extern T0*ms219_1284bc232c36l2772;
extern T0*ms291_784300160;
extern T0*ms238_23085765;
extern T0*ms411_305bc360c41;
extern T0*ms411_305bc355c42;
extern T0*ms317_635bc385c41;
extern T0*ms29_1730514379;
extern T0*ms317_635bc385c39;
extern T0*ms30_859431564;
extern T0*ms30_1375414302;
extern T0*ms441_1639500234;
extern T0*ms232_531983658;
extern T0*ms27_234165132;
extern T0*ms232_1772404517bc484;
extern T0*ms30_1095772782;
extern T0*ms239_1404148845;
extern T0*ms224_1367009564;
extern T0*ms235_1494914262;
extern T0*ms499_242;
extern T0*ms80_208962844;
extern T0*ms219_49152444;
extern T0*ms484_731500039;
extern T0*ms394_1727;
extern T0*ms338_399591;
extern T0*ms499_248;
extern T0*ms30_361bc476c41;
extern T0*ms360_618933431;
extern T0*ms30_41849945;
extern T0*ms30_80694;
extern T0*ms232_588411932;
extern T0*ms360_4638080;
extern T0*ms469_2126200255;
extern T0*ms232_1772404517bc411;
extern T0*ms232_941548611bc232c36l373;
extern T0*ms219_1869700848;
extern T0*ms232_1772404517bc360;
extern T0*ms30_2054549840;
extern T0*ms317_181352;
extern T0*ms232_426087775;
extern T0*ms232_5164112;
extern T0*ms29_10208843;
extern T0*ms217_273430530;
extern T0*ms494_2015374870;
extern T0*ms317_382bc220;
extern T0*ms235_89862bc235;
extern T0*ms30_80854;
extern T0*ms63_4479182;
extern T0*ms499_11319686;
extern T0*ms232_1772404517bc239;
extern T0*ms63_1661812564;
extern T0*ms317_8436bc317c40;
extern T0*ms411_305bc360c41l1042;
extern T0*ms232_1772404517bc232;
extern T0*ms232_1772404517bc224;
extern T0*ms239_400297641;
extern T0*ms232_1170250908;
extern T0*ms219_52555395;
extern T0*ms317_382bc289;
extern T0*ms416_580292587;
extern T0*ms30_2098363273;
extern T0*ms236_485115581;
extern T0*ms317_382bc355;
extern T0*ms317_124454155;
extern T0*ms317_2076497529;
extern T0*ms360_1400582480;
extern T0*ms291_90782bc291;
extern T0*ms219_6655bc317;
extern T0*ms224_644847010;
extern T0*ms317_382bc398;
extern T0*ms451_1753;
extern T0*ms232_15351bc232;
extern T0*ms220_282bc544;
extern T0*ms410_226;
extern T0*ms235_262628264;
extern T0*ms410_240;
extern T0*ms30_337331;
extern T0*ms29_59251;
extern T0*ms410_245;
extern T0*ms360_247;
extern T0*ms30_76691;
extern T0*ms360_255;
extern T0*ms218_2537;
extern T0*ms317_382bc556;
extern T0*ms360_265;
extern T0*ms317_2136427942;
extern T0*ms232_323348966;
extern T0*ms317_653639191;
extern T0*ms30_1644425991;
extern T0*ms232_1330;
extern T0*ms360_296;
extern T0*ms291_90782bc544;
extern T0*ms28_331;
extern T0*ms28_329;
extern T0*ms28_334;
extern T0*ms232_1295;
extern T0*ms360_1174230416bc360c40;
extern T0*ms410_366;
extern T0*ms291_1710309;
extern T0*ms239_1839365502;
extern T0*ms360_870841390bc360;
extern T0*ms66_0bc627c16;
extern T0*ms291_479982486bc291;
extern T0*ms235_1431838787;
extern T0*ms232_11086084;
extern T0*ms360_269141588;
extern T0*ms241_300594;
extern T0*ms26_375350487;
extern T0*ms232_1492394528;
extern T0*ms291_349661420;
extern T0*ms360_471;
extern T0*ms544_1288623074;
extern T0*ms241_494839979;
extern T0*ms232_1476;
extern T0*ms394_264bc394c41;
extern T0*ms360_23692781;
extern T0*ms411_305bc291c39l1096;
extern T0*ms232_1493;
extern T0*ms594_324;
extern T0*ms317_1096165867;
extern T0*ms239_7869bc317c43l1813;
extern T0*ms627_48939847;
extern T0*ms239_7869bc317c43l1826;
extern T0*ms450_646287685;
extern T0*ms235_721564652;
extern T0*ms63_1831619428;
extern T0*ms411_305bc291c39l1113;
extern T0*ms329_49159605;
extern T0*ms29_407540;
extern T0*ms241_52979396;
extern T0*ms30_78150;
extern T0*ms69_35386613;
extern T0*ms360_670;
extern T0*ms68_618869258;
extern T0*ms359_16902bc359;
extern T0*ms69_1581369567;
extern T0*ms289_560761477;
extern T0*ms232_218061703;
extern T0*ms29_408086;
extern T0*ms241_50040236bc241;
extern T0*ms30_1607595572;
extern T0*ms235_415107;
extern T0*ms239_7869bc317c43l1953;
extern T0*ms232_1330bc359c16;
extern T0*ms360_10430693;
extern T0*ms234_357794960;
extern T0*ms400_1952787551;
extern T0*ms69_1242149539;
extern T0*ms220_1136118256;
extern T0*ms25_1767481079;
extern T0*ms30_77832;
extern T0*ms30_361bc476;
extern T0*ms219_259021955;
extern T0*ms431_2088401;
extern T0*ms27_388005040;
extern T0*ms30_169371474;
extern T0*ms232_3015;
extern T0*ms232_1065942137;
extern T0*ms289_430519127;
extern T0*ms224_1136523103;
extern T0*ms235_15721;
extern T0*ms241_439136;
extern T0*ms317_215bc350;
extern T0*ms224_2395bc358;
extern T0*ms450_259;
extern T0*ms232_2545;
extern T0*ms30_880412606;
extern T0*ms26_941571923;
extern T0*ms66_0bc235c10;
extern T0*ms218_322bc301;
extern T0*ms450_327;
extern T0*ms66_0bc235c15;
extern T0*ms66_0bc235c17;
extern T0*ms66_0bc235c23;
extern T0*ms66_0bc235c30;
extern T0*ms232_2630;
extern T0*ms66_0bc235c31;
extern T0*ms66_0bc235c26;
extern T0*ms66_0bc235c32;
extern T0*ms220_1423844543;
extern T0*ms66_0bc235c34;
extern T0*ms66_0bc235c40;
extern T0*ms66_0bc235c35;
extern T0*ms450_404;
extern T0*ms317_284bc291c44;
extern T0*ms317_284bc291c45;
extern T0*ms66_0bc235c37;
extern T0*ms317_284bc291c46;
extern T0*ms66_0bc235c39;
extern T0*ms29_1223234252;
extern T0*ms235_15828;
extern T0*ms219_185146;
extern T0*ms218_349372;
extern T0*ms69_1658160521;
extern T0*ms360_33291bc360;
extern T0*ms234_1765;
extern T0*ms63_10926944bc77;
extern T0*ms224_724500276;
extern T0*ms518_456083848;
extern T0*ms30_1447702;
extern T0*ms236_1500;
extern T0*ms232_1295bc360c42;
extern T0*ms25_1889925553;
extern T0*ms232_2753;
extern T0*ms234_561947515;
extern T0*ms289_1367040625;
extern T0*ms360_306706;
extern T0*ms27_1994621;
extern T0*ms224_383570;
extern T0*ms30_79341;
extern T0*ms234_1364588829;
extern T0*ms289_126319331;
extern T0*ms30_201970776;
extern T0*ms232_3430;
extern T0*ms241_1733505988;
extern T0*ms30_201970793;
extern T0*ms30_548214405;
extern T0*ms317_525205114;
extern T0*ms30_201970799;
extern T0*ms291_14464;
extern T0*ms232_277a;
extern T0*ms235_99bc701c39;
extern T0*ms232_2041682bc232;
extern T0*ms465_360;
extern T0*ms710_670393442;
extern T0*ms235_1361085152;
extern T0*ms465_372;
extern T0*ms29_414461;
extern T0*ms411_305bc359c40;
extern T0*ms63_7207;
extern T0*ms394_1784247739;
extern T0*ms389_1742784741;
extern T0*ms301_299;
extern T0*ms27_336bc235;
extern T0*ms411_305bc220c41;
extern T0*ms232_2101369329;
extern T0*ms241_1289042164;
extern T0*ms241_1933;
extern T0*ms360_475042348;
extern T0*ms235_1331737400;
extern T0*ms219_1087364605;
extern T0*ms317_1199805276;
extern T0*ms317_1637927398;
extern T0*ms701_1942892277;
extern T0*ms234_3374;
extern T0*ms29_114085235;
extern T0*ms234_2883;
extern T0*ms30_50778415;
extern T0*ms291_280766651;
extern T0*ms241_437331;
extern T0*ms394_5912;
extern T0*ms301_620;
extern T0*ms359_2237652;
extern T0*ms28_331bc301;
extern T0*ms30_84881;
extern T0*ms360_32400;
extern T0*ms218_27561173;
extern T0*ms499_607189345;
extern T0*ms629_68284;
extern T0*ms29_1988096;
extern T0*ms235_18144;
extern T0*ms30_573080478;
extern T0*ms239_802495724;
extern T0*ms239_1934139bc234;
extern T0*ms360_32435;
extern T0*ms30_84969;
extern T0*ms246_685;
extern T0*ms239_1934139bc224;
extern T0*ms30_42;
extern T0*ms30_43;
extern T0*ms30_38;
extern T0*ms235_62380794;
extern T0*ms30_45;
extern T0*ms219_35343969;
extern T0*ms235_1663868;
extern T0*ms360_32456;
extern T0*ms30_90544;
extern T0*ms30_47;
extern T0*ms241_54634669;
extern T0*ms544_1719402393;
extern T0*ms30_60;
extern T0*ms30_61;
extern T0*ms540_476;
extern T0*ms30_62;
extern T0*ms30_64;
extern T0*ms25_85614;
extern T0*ms360_887295984bc360;
extern T0*ms317_1007239;
extern T0*ms219_1246644455;
extern T0*ms244_620670284;
extern T0*ms30_94;
extern T0*ms710_5580bc317;
extern T0*ms30_1501191;
extern T0*ms84_319940936;
extern T0*ms291_1739163321;
extern T0*ms360_29126717;
extern T0*ms235_17794;
extern T0*ms30_48672249;
extern T0*ms232_78646;
extern T0*ms360_32650;
extern T0*ms627_206626;
extern T0*ms360_1651828280;
extern T0*ms232_1308400309;
extern T0*ms218_3556890;
extern T0*ms627_207112;
extern T0*ms241_1680421289;
extern T0*ms394_6775;
extern T0*ms291_237;
extern T0*ms291_244;
extern T0*ms317_44462444;
extern T0*ms291_255;
extern T0*ms218_210310269;
extern T0*ms217_1713607783;
extern T0*ms232_1220584686;
extern T0*ms360_33291;
extern T0*ms80_1553744164;
extern T0*ms352_161074567;
extern T0*ms394_28032126;
extern T0*ms66_411001267;
extern T0*ms232_249bc291;
extern T0*ms291_377;
extern T0*ms506_276bc511;
extern T0*ms235_69851bc235;
extern T0*ms506_276bc506;
extern T0*ms241_4235;
extern T0*ms506_276bc507;
extern T0*ms360_1905022886;
extern T0*ms232_1680956616;
extern T0*ms410_2187619;
extern T0*ms291_1994331;
extern T0*ms291_614bc317;
extern T0*ms27_77608;
extern T0*ms411_123;
extern T0*ms26_63;
extern T0*ms219_197159bc317;
extern T0*ms63_927785894;
extern T0*ms360_2187545;
extern T0*ms411_305bc421c39;
extern T0*ms317_1514442508;
extern T0*ms291_614bc291;
extern T0*ms218_44975894;
extern T0*ms30_698215697;
extern T0*ms30_878996813;
extern T0*ms436_29662bc217;
extern T0*ms291_604;
extern T0*ms219_49806180;
extern T0*ms27_2020550321;
extern T0*ms291_614;
extern T0*ms411_230;
extern T0*ms29_251171752;
extern T0*ms360_114321512;
extern T0*ms232_1330bc360c43;
extern T0*ms232_1330bc360c41;
extern T0*ms410_21020045;
extern T0*ms232_1330bc360c40;
extern T0*ms469_36122993;
extern T0*ms29_820292;
extern T0*ms30_1419919903;
extern T0*ms411_305;
extern T0*ms464_11300605;
extern T0*ms27_10554609;
extern T0*ms231_69115705;
extern T0*ms503_1901947715;
extern T0*ms30_337331bc408;
extern T0*ms291_2142119302;
extern T0*ms360_1836355544;
extern T0*ms317_1553763390;
extern T0*ms291_699;
extern T0*ms499_2092688244;
extern T0*ms469_561523426;
extern T0*ms235_1115301;
extern T0*ms241_18150bc289c45;
extern T0*ms239_1368099455;
extern T0*ms29_78263bc241;
extern T0*ms309_77;
extern T0*ms219_1197879602;
extern T0*ms360_2122389958bc360;
extern T0*ms232_6455;
extern T0*ms238_97543221;
extern T0*ms30_1594034;
extern T0*ms597_849265556;
extern T0*ms29_11251026;
extern T0*ms25_1950832492;
extern T0*ms217_1746979137;
extern T0*ms27_78495;
extern T0*ms30_87541;
extern T0*ms360_34510;
extern T0*ms235_1223801083;
extern T0*ms30_88048;
extern T0*ms29_600;
extern T0*ms30_88049;
extern T0*ms291_306811962;
extern T0*ms29_611;
extern T0*ms232_1102979933bc360;
extern T0*ms476_6305bc360;
extern T0*ms29_627;
extern T0*ms317_732402575;
extern T0*ms232_1206795525;
extern T0*ms29_640;
extern T0*ms232_6651;
extern T0*ms224_18131599;
extern T0*ms627_1779043510;
extern T0*ms63_188916891;
extern T0*ms29_661;
extern T0*ms29_670;
extern T0*ms29_69805;
extern T0*ms484_1271;
extern T0*ms232_1273572186;
extern T0*ms358_116864219;
extern T0*ms544_5839580;
extern T0*ms360_37173080;
extern T0*ms232_1404852998;
extern T0*ms291_1985327250;
extern T0*ms219_689812670;
extern T0*ms66_0bc235c35l2162;
extern T0*ms392_1470642763;
extern T0*ms232_451157bc59;
extern T0*ms235_355003;
extern T0*ms392_244699380;
extern T0*ms235_8991bc235;
extern T0*ms236_5615;
extern T0*ms291_1290234494;
extern T0*ms359_16902;
extern T0*ms30_349117293;
extern T0*ms232_6877;
extern T0*ms289_208313786;
extern T0*ms317_5279655;
extern T0*ms305_25373399;
extern T0*ms317_61699bc317;
extern T0*ms232_4049151;
extern T0*ms30_1297432701;
extern T0*ms27_2141685;
extern T0*ms234_6559;
extern T0*ms219_10322525bc499;
extern T0*ms241_1587734026;
extern T0*ms291_130382376;
extern T0*ms218_203714719;
extern T0*ms29_3601bc358;
extern T0*ms232_251;
extern T0*ms232_1607940692;
extern T0*ms232_249;
extern T0*ms291_1126647264;
extern T0*ms232_257;
extern T0*ms232_697705640;
extern T0*ms309_270bc227;
extern T0*ms29_76226;
extern T0*ms236_1365578385;
extern T0*ms232_272;
extern T0*ms232_1164208;
extern T0*ms232_277;
extern T0*ms385_400650;
extern T0*ms232_284;
extern T0*ms232_985140858;
extern T0*ms493_1312bc358;
extern T0*ms219_10322525bc291;
extern T0*ms30_1979951;
extern T0*ms317_10937200;
extern T0*ms235_10937305;
extern T0*ms27_914215870;
extern T0*ms239_443468597;
extern T0*ms30_88795;
extern T0*ms532_3343;
extern T0*ms232_526;
extern T0*ms360_1911859989;
extern T0*ms234_1624663341;
extern T0*ms503_1664721281;
extern T0*ms446_1771711260;
extern T0*ms69_446380143;
extern T0*ms29_427898753;
extern T0*ms30_89510;
extern T0*ms232_625;
extern T0*ms493_1312;
extern T0*ms232_1330bc232c36l1604;
extern T0*ms232_651;
extern T0*ms360_35966;
extern T0*ms66_0bc301c13;
extern T0*ms66_0bc301c20;
extern T0*ms232_9130;
extern T0*ms84_319940936bc84c15;
extern T0*ms317_834589410;
extern T0*ms30_42134669bc402;
extern T0*ms220_148900;
extern T0*ms232_57150800;
extern T0*ms232_1582839830;
extern T0*ms323_22861847;
extern T0*ms457_506bc232c35;
extern T0*ms291_1523807481;
extern T0*ms627_202642;
extern T0*ms224_3475bc450;
extern T0*ms493_1530;
extern T0*ms232_1919660703;
extern T0*ms232_1330bc232c36l1400;
extern T0*ms289_386819bc499;
extern T0*ms80_452889;
extern T0*ms407_230bc317;
extern T0*ms245_1554312113;
extern T0*ms436_246bc232;
extern T0*ms29_77350;
extern T0*ms405_1240bc358;
extern T0*ms407_230bc360;
extern T0*ms232_700572143;
T0*se_ms(int c,char*e);
T0*se_string(char*e);
void se_msi1(void);
void se_msi2(void);
void se_msi3(void);
void se_msi4(void);
void se_msi5(void);
void se_msi6(void);
void se_msi7(void);
void se_msi8(void);
void se_msi9(void);
void se_msi10(void);
void se_msi11(void);
void se_msi12(void);
void se_msi13(void);
void se_msi14(void);
void se_msi15(void);
void se_msi16(void);
void se_msi17(void);
void se_msi18(void);
void se_msi19(void);
void se_msi20(void);
void se_msi21(void);
void se_msi22(void);
void se_msi23(void);
void se_msi24(void);
void se_msi25(void);
void se_msi26(void);
void se_msi27(void);
void se_msi28(void);
void se_msi29(void);
void se_msi30(void);
void se_msi31(void);
void se_msi32(void);
void se_msi33(void);
void se_msi34(void);
void se_msi35(void);
void se_msi36(void);
void se_msi37(void);
void se_msi38(void);
void se_msi39(void);
void se_msi40(void);
void se_msi41(void);
void se_msi42(void);
void se_msi43(void);
void se_msi44(void);
void se_msi45(void);
void se_msi46(void);
void se_msi47(void);
void se_msi48(void);
void se_msi49(void);
void se_msi50(void);
void se_msi51(void);
void se_msi52(void);
void se_msi53(void);
void se_msi54(void);
void se_msi55(void);
void se_msi56(void);
extern T25*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 1161
extern T7*g[];
extern T7*t[];
void se_atexit(void);
void initialize_eiffel_runtime(int argc,char*argv[]);
int main(int argc,char*argv[]);
T0* se_manifest801(T2 initial_lower,int argc,...);
T0* se_manifest726(T2 initial_lower,int argc,...);
T0* se_manifest769(T2 initial_lower,int argc,...);
T0* se_manifest716(int argc,...);
T0* se_manifest1068(int argc,...);
T0* se_manifest802(T2 initial_lower,int argc,...);
T0* se_manifest765(int argc,...);
T0* se_manifest718(int argc,...);
T0* se_manifest816(int argc,...);
T0* X439declaration_type(T0*C);
T0* X439resolve_in(T0*C,T0* a1);
T0* X439collect(T0*C,T0* a1);
T6 X439value(T0*C);
T296 X439start_position(T0*C);
T0* X341routine_body(T0*C);
void X305set_permissions(T0*C,T0* a1);
void X305copy(T0*C,T0* a1);
T0* X305specialized_ensure_thru(T0*C,T0* a1,T0* a2,T0* a3);
T0* X305specialize_signature_in(T0*C,T0* a1);
T0* X305inline_instruction_n(T0*C,T0* a1,T0* a2,T0* a3,T0* a4);
T0* X305try_to_undefine_aux(T0*C,T0* a1,T0* a2);
T0* X305header_comment(T0*C);
T0* X305specialize_require_thru(T0*C,T0* a1,T0* a2,T0* a3);
void X305collect(T0*C,T0* a1);
void X305set_end_comment(T0*C,T0* a1);
T0* X305ensure_assertion(T0*C);
T0* X305specialize_2(T0*C,T0* a1);
T1 X305unrelated_code(T0*C);
void X305set_ensure(T0*C,T0* a1);
T0* X305simplify(T0*C,T0* a1);
T0* X305arguments(T0*C);
T0* X305specialized_require_thru(T0*C,T0* a1,T0* a2,T0* a3);
T0* X305permissions(T0*C);
T0* X305first_name(T0*C);
T0* X305obsolete_mark(T0*C);
T0* X305inline_instruction_1(T0*C,T0* a1,T0* a2,T0* a3,T0* a4);
void X305collect_body(T0*C,T0* a1);
T0* X305inline_instruction_0(T0*C,T0* a1,T0* a2,T0* a3);
T0* X305specialize_require_in(T0*C,T0* a1);
T0* X305names(T0*C);
T1 X305inherits_code(T0*C);
void X305add_into(T0*C,T0* a1,T0* a2);
T0* X305require_assertion(T0*C);
T0* X305merge_signature_thru(T0*C,T0* a1,T0* a2,T0* a3,T0* a4,T6 a5);
T0* X305try_to_undefine(T0*C,T0* a1,T0* a2);
void X305add_into_(T0*C,T0* a1,T0* a2);
T0* X305new_run_feature_for(T0*C,T0* a1,T0* a2);
T0* X305result_type(T0*C);
void X305valid_redefinition_error(T0*C,T0* a1,T0* a2,T0* a3,T0* a4);
T1 X305inserts_code(T0*C);
void X305collect_precursor(T0*C,T0* a1,T0* a2);
void X305obsolete_warning_check(T0*C,T0* a1,T296 a2);
T6 X305use_current(T0*C,T0* a1);
T0* X305feature_text(T0*C);
T0* X305inline_expression_n(T0*C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
T0* X305change_ensure(T0*C,T0* a1,T6 a2);
T0* X305brand_new_run_feature_for(T0*C,T0* a1,T0* a2,T6 a3);
T0* X305specialize_permissions(T0*C,T0* a1,T6 a2);
void X305hook_collect(T0*C,T0* a1);
T6 X305same_body_as(T0*C,T0* a1);
T0* X305specialize_body_thru(T0*C,T0* a1,T0* a2,T0* a3,T6 a4);
T6 X305same_signature(T0*C,T0* a1,T0* a2);
void X305set_header_comment(T0*C,T0* a1);
T6 X305side_effect_free(T0*C,T0* a1);
T0* X305specialize_signature_thru(T0*C,T0* a1,T0* a2,T0* a3);
T0* X305specialize_ensure_in(T0*C,T0* a1,T6 a2);
T0* X305twin(T0*C);
void X305hook_for(T0*C,T0* a1);
T0* X305specialize_ensure_thru(T0*C,T0* a1,T0* a2,T0* a3,T6 a4);
void X305set_ensure_assertion(T0*C,T0* a1);
T0* X305class_text(T0*C);
T0* X305clients(T0*C);
void X305accept(T0*C,T0* a1);
T0* X305inline_expression_1(T0*C,T0* a1,T0* a2,T296 a3,T0* a4,T0* a5,T0* a6,T0* a7);
T0* X305inline_expression_0(T0*C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T6 X305valid_redefinition(T0*C,T0* a1,T0* a2,T0* a3,T0* a4);
T0* X305change_require(T0*C,T0* a1,T6 a2);
void X305set_require(T0*C,T0* a1);
T6 X305is_deferred(T0*C);
T0* X305obsolete_warning_check_memory(T0*C);
T296 X305start_position(T0*C);
void X305set_rescue_compound(T0*C,T0* a1);
T6 X305is_attribute(T0*C);
T0* X305specialize_body_in(T0*C,T0* a1,T6 a2);
void X205visit_local_name2(T0*C,T0* a1);
void X207visit_agent_expression(T0*C,T0* a1);
void X208visit_e_old(T0*C,T0* a1);
void X312execute_command_line(T0*C,T0* a1,T6 a2);
void X312set_direct_output(T0*C,T6 a1);
T6 X312is_connected(T0*C);
T0* X312group(T0*C);
T6 X312direct_output(T0*C);
T0* X312output(T0*C);
void X312set_direct_error(T0*C,T6 a1);
T6 X312direct_error(T0*C);
void X312set_group(T0*C,T0* a1);
void X312set_direct_input(T0*C,T6 a1);
T6 X312direct_input(T0*C);
void X312wait(T0*C);
void X34put_new_line(T0*C);
void X34disconnect(T0*C);
T6 X34is_connected(T0*C);
T0* X34tmp_string(T0*C);
void X34put_integer(T0*C,T11 a1);
void X34filtered_put_character(T0*C,T3 a1);
void X34put_real_format(T0*C,T5 a1,T2 a2);
void X34flush(T0*C);
void X34filtered_flush(T0*C);
void X34put_character(T0*C,T3 a1);
void X34put_string(T0*C,T0* a1);
void X351generic_formal_arguments_check(T0*C);
void X351parse_include(T0*C);
T0* X351to_string(T0*C);
void X351show(T0*C,T2 a1);
void X351set_parent(T0*C,T0* a1);
void X351clusters_of(T0*C,T0* a1,T6 a2,T0* a3,T0* a4,T0* a5,T2 a6);
T2 X351loaded_class_count(T0*C);
void X351for_all(T0*C,T0* a1);
T0* X351find_physical_cluster(T0*C,T0* a1);
T2 X351cluster_count(T0*C);
T2 X351distance(T0*C);
T0* X351parent(T0*C);
T0* X351cluster_named(T0*C,T0* a1);
void X351get_started(T0*C,T2 a1);
void X351view_in(T0*C,T0* a1);
void X170visit_call_infix_ge(T0*C,T0* a1);
T0* X554specialize_2_string(T0*C,T0* a1);
T0* X554adapt_for(T0*C,T0* a1);
void X554validity_check_continued_(T0*C,T0* a1);
void X554collect(T0*C,T0* a1);
T0* X554specialize_in(T0*C,T0* a1);
T6 X554validity_check_continued(T0*C,T0* a1);
T6 X554match_value(T0*C,T2 a1);
T0* X554specialize_2_integer(T0*C,T0* a1);
void X554force_internal_character_values(T0*C,T0* a1,T0* a2);
T0* X554specialize_thru(T0*C,T0* a1,T0* a2,T0* a3);
void X554force_internal_integer_values(T0*C,T0* a1,T0* a2);
void X554validity_check_continued_when_item_2(T0*C,T0* a1);
void X554validity_check_continued_when_item_1(T0*C,T0* a1);
void X554validity_check(T0*C,T0* a1);
void X554compute_values(T0*C,T0* a1);
T0* X554specialize_2_character(T0*C,T0* a1);
T296 X554start_position(T0*C);
void X172visit_call_infix_le(T0*C,T0* a1);
T0* X342typed_internal_local(T0*C,T0* a1,T0* a2,T296 a3,T0* a4);
T0* X342internal_locals(T0*C);
T0* X342routine_body(T0*C);
T0* X342local_vars(T0*C);
void X342accept(T0*C,T0* a1);
void X168visit_call_infix_plus(T0*C,T0* a1);
void X176visit_call_infix_minus(T0*C,T0* a1);
void X879clear_all(T0*C);
void X879ensure_capacity_and_bounds(T0*C,T2 a1,T2 a2,T2 a3);
T2 X879count(T0*C);
void X879put(T0*C,T0* a1,T2 a2);
T2 X879upper(T0*C);
T0* X879item(T0*C,T2 a1);
T2 X879lower(T0*C);
T2 X879capacity(T0*C);
T997 X879storage(T0*C);
void X879set_all_with(T0*C,T0* a1);
void X879with_capacity(T0*C,T2 a1,T2 a2);
void X879from_collection(T0*C,T0* a1);
void X214visit_create_expression(T0*C,T0* a1);
void X151visit_e_true(T0*C,T0* a1);
void X165visit_call_infix_int_rem(T0*C,T0* a1);
void X213visit_precursor_expression(T0*C,T0* a1);
void X201visit_create_writable(T0*C,T0* a1);
void X505to_file_path_with(T0*C,T0* a1,T0* a2);
void X505to_subpath_with(T0*C,T0* a1,T0* a2);
T6 X505is_case_sensitive(T0*C);
void X505to_parent_directory(T0*C,T0* a1);
void X505from_notation(T0*C,T0* a1,T0* a2);
T6 X505is_valid_path(T0*C,T0* a1);
T0* X505to_notation(T0*C,T0* a1,T0* a2);
void X505to_directory_path(T0*C,T0* a1);
void X505to_default_root(T0*C,T0* a1);
T6 X505can_map_drive(T0*C,T0* a1,T0* a2);
void X505to_absolute_path_in(T0*C,T0* a1,T0* a2);
T6 X505is_absolute_path(T0*C,T0* a1);
void X505to_subdirectory_with(T0*C,T0* a1,T0* a2);
void X505to_root(T0*C,T0* a1,T0* a2);
void X505to_valid_file_name(T0*C,T0* a1);
T6 X505is_valid_file_name(T0*C,T0* a1);
void X505to_current_directory(T0*C,T0* a1);
T6 X505can_sanitize(T0*C,T0* a1);
T0* X512environment(T0*C,T0* a1);
T0* X512os(T0*C);
T0* X512sys(T0*C);
T0* X512short(T0*C);
T0* X512c_mode(T0*C,T0* a1);
void X512loadpaths_in(T0*C,T0* a1);
T0* X512flavor(T0*C);
T0* X512bin(T0*C);
void X739put(T0*C,T0* a1,T2 a2);
T2 X739upper(T0*C);
T0* X739item(T0*C,T2 a1);
T2 X739lower(T0*C);
T6 X739valid_index(T0*C,T2 a1);
void X739add_last(T0*C,T0* a1);
void X739add(T0*C,T0* a1,T2 a2);
void X739swap(T0*C,T2 a1,T2 a2);
void X495copy(T0*C,T0* a1);
T0* X495specialize_in(T0*C,T0* a1);
void X495set_result_type(T0*C,T0* a1);
T0* X495specialize_thru(T0*C,T0* a1,T0* a2,T0* a3);
T0* X495to_string(T0*C);
T0* X495result_type(T0*C);
void X495set_rank(T0*C,T2 a1);
T2 X495rank(T0*C);
T0* X495twin(T0*C);
T296 X495start_position(T0*C);
void X152visit_e_false(T0*C,T0* a1);
void X169visit_call_infix_xor(T0*C,T0* a1);
void X187visit_call_0_c(T0*C,T0* a1);
void X153visit_e_void(T0*C,T0* a1);
void X209visit_manifest_generic(T0*C,T0* a1);
void X192visit_implicit_current(T0*C,T0* a1);
void X88visit_effective_arg_list(T0*C,T0* a1);
void X179visit_call_1_c(T0*C,T0* a1);
T0* X310adapt_for(T0*C,T0* a1);
void X310compile_to_c_with_internal_c_local_saving(T0*C,T0* a1);
void X310collect(T0*C,T0* a1);
T0* X310specialize_in(T0*C,T0* a1);
T0* X310specialize_2(T0*C,T0* a1);
T0* X310simplify(T0*C,T0* a1);
void X310safety_check(T0*C,T0* a1);
T0* X310specialize_thru(T0*C,T0* a1,T0* a2,T0* a3);
void X310compile_to_c(T0*C,T0* a1);
T6 X310use_current(T0*C,T0* a1);
T0* X310simplify_routine_body_first(T0*C,T0* a1,T0* a2);
T0* X310specialize_2_without_checks(T0*C,T0* a1);
T6 X310side_effect_free(T0*C,T0* a1);
void X310accept(T0*C,T0* a1);
T296 X310start_position(T0*C);
void X174visit_call_infix_int_div(T0*C,T0* a1);
void X188visit_implicit_cast(T0*C,T0* a1);
void X372copy(T0*C,T0* a1);
T0* X372ensure_assertion(T0*C);
T0* X372arguments(T0*C);
T0* X372routine_body(T0*C);
void X372set_routine_body(T0*C,T0* a1);
T0* X372first_name(T0*C);
T0* X372names(T0*C);
T0* X372current_or_twin_init(T0*C,T0* a1,T0* a2,T6 a3,T0* a4,T0* a5,T6 a6);
T0* X372require_assertion(T0*C);
T0* X372native(T0*C);
T0* X372result_type(T0*C);
void X372init(T0*C,T0* a1,T0* a2,T6 a3,T0* a4,T0* a5);
T0* X372feature_text(T0*C);
T2 X372argument_rank_of(T0*C,T0* a1);
T0* X372external_name(T0*C);
T0* X372local_vars(T0*C);
T6 X372is_generated_eiffel(T0*C);
T0* X372twin(T0*C);
T0* X372class_text(T0*C);
T0* X372alias_string(T0*C);
T296 X372start_position(T0*C);
T0* X372c_plus_plus_name(T0*C);
void X154visit_fake_target(T0*C,T0* a1);
void X183visit_call_prefix_not(T0*C,T0* a1);
void X164visit_call_infix_times(T0*C,T0* a1);
void X286add_last(T0*C,T0* a1);
T0* X286flat_list(T0*C);
void X189visit_generator_generating_type(T0*C,T0* a1);
void X202visit_expression_with_comment(T0*C,T0* a1);
void X289c_set_dump_stack_top(T0*C,T0* a1,T0* a2);
T0* X289ensure_assertion(T0*C);
T0* X289name(T0*C);
T0* X289arguments(T0*C);
T0* X289routine_body(T0*C);
void X289mapping_c(T0*C);
T0* X289require_assertion(T0*C);
T6 X289prepare_introspection(T0*C,T6 a1);
T0* X289result_type(T0*C);
T0* X289feature_stamp(T0*C);
T6 X289prepare_introspection2(T0*C,T6 a1);
T0* X289local_vars(T0*C);
void X289address_of_c_mapping(T0*C);
void X289c_define(T0*C);
void X289address_of_c_define(T0*C,T0* a1);
void X289do_adapt(T0*C);
T0* X289type_of_current(T0*C);
void X289mapping_name_in(T0*C,T0* a1);
void X289adapt(T0*C);
T296 X289start_position(T0*C);
T0* X289base_feature(T0*C);
void X162visit_call_infix_div(T0*C,T0* a1);
void X389copy(T0*C,T0* a1);
void X389set_creation_type(T0*C,T0* a1);
T0* X389adapt_for(T0*C,T0* a1);
void X389collect(T0*C,T0* a1);
T0* X389specialize_in(T0*C,T0* a1);
T0* X389specialize_2(T0*C,T0* a1);
void X389set_target(T0*C,T0* a1);
T0* X389arguments(T0*C);
void X389safety_check(T0*C,T0* a1);
T0* X389creation_type(T0*C);
T0* X389specialize_thru(T0*C,T0* a1,T0* a2,T0* a3);
T0* X389call_support_collect(T0*C,T0* a1);
void X389set_feature_stamp(T0*C,T0* a1);
void X389set_arguments(T0*C,T0* a1);
T0* X389simplify_arguments(T0*C,T0* a1);
T0* X389feature_stamp(T0*C);
T0* X389target(T0*C);
T0* X389feature_name(T0*C);
T0* X389run_feature_for(T0*C,T0* a1);
T0* X389twin(T0*C);
T2 X389arg_count(T0*C);
T296 X389start_position(T0*C);
void X389collect_create(T0*C,T0* a1,T0* a2,T296 a3);
void X186visit_call_prefix_minus(T0*C,T0* a1);
void X181visit_static_call_0_c(T0*C,T0* a1);
T0* X283declaration_type(T0*C);
void X283copy(T0*C,T0* a1);
T0* X283adapt_for(T0*C,T0* a1);
T0* X283resolve_in(T0*C,T0* a1);
void X283compile_to_c_with_internal_c_local_saving(T0*C,T0* a1);
T0* X283collect(T0*C,T0* a1);
T6 X283is_manifest_string(T0*C);
T6 X283is_equal(T0*C,T0* a1);
T0* X283specialize_in(T0*C,T0* a1);
T0* X283specialize_2(T0*C,T0* a1);
T6 X283is_static(T0*C);
T0* X283written_declaration_type_mark(T0*C);
T0* X283simplify(T0*C,T0* a1);
void X283pretty_target(T0*C,T2 a1);
void X283safety_check(T0*C,T0* a1);
T0* X283specialize_thru(T0*C,T0* a1,T0* a2,T0* a3);
T6 X283is_void(T0*C);
void X283compile_to_c(T0*C,T0* a1);
T6 X283is_result(T0*C);
void X283mapping_c_arg(T0*C,T0* a1);
T2 X283precedence(T0*C);
T6 X283same_dynamic_type(T0*C,T0* a1);
T6 X283use_current(T0*C,T0* a1);
T0* X283static_simplify(T0*C);
T6 X283is_default_value(T0*C);
void X283pretty(T0*C,T2 a1);
T6 X283side_effect_free(T0*C,T0* a1);
T6 X283extra_bracket_flag(T0*C);
void X283mapping_c_target(T0*C,T0* a1,T0* a2);
T0* X283non_void_no_dispatch_type(T0*C,T0* a1);
T0* X283twin(T0*C);
void X283bracketed_pretty(T0*C,T2 a1);
void X283accept(T0*C,T0* a1);
T6 X283is_implicit_current(T0*C);
T6 X283is_current(T0*C);
T296 X283start_position(T0*C);
void X197visit_non_void_no_dispatch(T0*C,T0* a1);
void X185visit_call_prefix_freeop(T0*C,T0* a1);
void X195visit_numbered_capture(T0*C,T0* a1);
void X147visit_integer_constant(T0*C,T0* a1);
void X398copy(T0*C,T0* a1);
T0* X398call(T0*C);
T0* X398adapt_for(T0*C,T0* a1);
void X398typed_internals(T0*C,T296 a1,T0* a2);
void X398compile_to_c_with_internal_c_local_saving(T0*C,T0* a1);
void X398collect(T0*C,T0* a1);
void X398specialize_2_checks(T0*C,T0* a1);
T0* X398specialize_in(T0*C,T0* a1);
T0* X398specialize_2(T0*C,T0* a1);
T0* X398any_default_create_fs(T0*C);
T0* X398created_type(T0*C,T0* a1);
T0* X398simplify(T0*C,T0* a1);
T0* X398writable(T0*C);
T0* X398arguments(T0*C);
void X398safety_check(T0*C,T0* a1);
T0* X398specialize_thru(T0*C,T0* a1,T0* a2,T0* a3);
void X398compile_to_c(T0*C,T0* a1);
T0* X398current_or_twin_init(T0*C,T0* a1,T0* a2,T0* a3);
void X398make(T0*C,T296 a1,T0* a2,T0* a3,T0* a4);
T0* X398default_create_name(T0*C);
T6 X398use_current(T0*C,T0* a1);
void X398init(T0*C,T0* a1,T0* a2,T0* a3);
T0* X398simplify_routine_body_first(T0*C,T0* a1,T0* a2);
T6 X398default_create_call(T0*C);
T0* X398specialize_2_without_checks(T0*C,T0* a1);
T6 X398side_effect_free(T0*C,T0* a1);
T0* X398creation_procedure(T0*C,T0* a1);
T0* X398explicit_type(T0*C);
T0* X398twin(T0*C);
void X398accept(T0*C,T0* a1);
void X398make_specialized(T0*C,T296 a1,T0* a2,T0* a3,T0* a4);
T296 X398start_position(T0*C);
void X291c_initialize_in(T0*C,T0* a1);
T0* X291declaration_type(T0*C);
void X291copy(T0*C,T0* a1);
T6 X291is_agent(T0*C);
void X291c_type_for_external_in(T0*C,T0* a1);
T0* X291generic_list(T0*C);
T0* X291long_name(T0*C);
T0* X291written_mark(T0*C);
T0* X291resolve_in(T0*C,T0* a1);
T0* X291at(T0*C,T296 a1);
void X291c_type_for_result_in(T0*C,T0* a1);
T0* X291class_text_name(T0*C);
T6 X291is_formal_generic(T0*C);
T0* X291specialize_in(T0*C,T0* a1);
T6 X291is_native_array(T0*C);
void X291gc_mark_in(T0*C,T0* a1);
T6 X291is_static(T0*C);
void X291just_before_gc_mark_in(T0*C,T0* a1);
T0* X291type(T0*C);
T6 X291is_pointer(T0*C);
T2 X291id(T0*C);
T0* X291specialize_thru(T0*C,T0* a1,T0* a2,T0* a3);
T6 X291is_real(T0*C);
T0* X291class_text_memory(T0*C);
T6 X291is_empty_expanded(T0*C);
T6 X291same_signature_type(T0*C,T0* a1,T0* a2);
T6 X291is_anchored(T0*C);
T6 X291need_gc_mark_function(T0*C);
void X291c_type_for_argument_in(T0*C,T0* a1);
T6 X291is_integer(T0*C);
T6 X291is_character(T0*C);
T6 X291is_expanded(T0*C);
T6 X291is_kernel_expanded(T0*C);
void X291gc_info_in(T0*C,T0* a1);
T0* X291written_name(T0*C);
T0* X291default_expression(T0*C,T296 a1);
void X291c_frame_descriptor_in(T0*C,T0* a1);
T0* X291to_static(T0*C,T0* a1);
T6 X291need_c_struct(T0*C);
T6 X291is_reference(T0*C);
void X291gc_define1(T0*C);
void X291gc_define2(T0*C);
void X291c_type_for_target_in(T0*C,T0* a1);
T0* X291signature_resolve_in(T0*C,T0* a1);
T6 X291is_generic(T0*C);
T0* X291twin(T0*C);
void X291set_start_position(T0*C,T296 a1);
T6 X291is_like_current(T0*C);
T6 X291is_user_expanded(T0*C);
void X291id_extra_information(T0*C,T0* a1);
T0* X291class_text(T0*C);
T6 X291is_boolean(T0*C);
T0* X291typed_internals_type_mark(T0*C,T296 a1);
T6 X291is_string(T0*C);
T6 X291is_tuple(T0*C);
void X291c_header_pass1(T0*C);
void X291c_header_pass2(T0*C);
void X291c_header_pass3(T0*C);
void X291pretty_in(T0*C,T0* a1);
void X291c_header_pass4(T0*C);
T296 X291start_position(T0*C);
void X291gc_call_new_in(T0*C,T0* a1);
void X163visit_call_infix_or_else(T0*C,T0* a1);
void X149visit_real_constant(T0*C,T0* a1);
void X357collect(T0*C,T0* a1,T0* a2);
void X357c_define_function(T0*C,T0* a1,T0* a2,T0* a3);
void X357c_mapping_procedure(T0*C,T0* a1,T0* a2,T0* a3);
void X357c_define_procedure(T0*C,T0* a1,T0* a2,T0* a3);
T6 X357use_current(T0*C,T0* a1);
void X357c_mapping_function(T0*C,T0* a1,T0* a2,T0* a3);
T6 X357side_effect_free(T0*C,T0* a1,T0* a2);
void X357accept(T0*C,T0* a1);
void X175visit_call_infix_or(T0*C,T0* a1);
T2 X527count(T0*C);
T0* X527specialize_in(T0*C,T0* a1);
T0* X527specialize_thru(T0*C,T0* a1,T0* a2,T0* a3);
void X527append_in(T0*C,T0* a1);
void X402set_specialized_parent(T0*C,T0* a1);
T0* X402parent(T0*C);
T0* X402specialized_parent(T0*C);
T296 X402start_position(T0*C);
void X161visit_call_infix_and(T0*C,T0* a1);
void X196visit_void_call(T0*C,T0* a1);
T0* X339value_memory(T0*C);
T0* X339first_name(T0*C);
T0* X339names(T0*C);
T0* X339value(T0*C);
T0* X339result_type(T0*C);
T0* X339feature_text(T0*C);
void X339hook_for(T0*C,T0* a1);
T296 X339start_position(T0*C);
T0* X971get_new_iterator_on_keys(T0*C);
T2 X971count(T0*C);
T0* X971key(T0*C,T2 a1);
T2 X971upper(T0*C);
T0* X971item(T0*C,T2 a1);
T6 X971has(T0*C,T0* a1);
void X971add(T0*C,T0* a1,T0* a2);
void X206visit_open_operand(T0*C,T0* a1);
void X167visit_call_infix_and_then(T0*C,T0* a1);
void X171visit_call_infix_gt(T0*C,T0* a1);
void X173visit_call_infix_lt(T0*C,T0* a1);
T0* X485target_memory(T0*C);
void X485set_type(T0*C,T0* a1);
T0* X485effective_arguments_memory(T0*C);
T0* X485type(T0*C);
void X485set_target(T0*C,T0* a1);
void X485set_internal_c_local(T0*C,T0* a1);
void X485set_static_type(T0*C,T0* a1);
T0* X485anonymous_feature_memory(T0*C);
T0* X485type_memory(T0*C);
T0* X485internal_c_local_memory(T0*C);
T2 X485code(T0*C);
T0* X485static_type(T0*C);
T0* X485static_type_memory(T0*C);
T0* X485target(T0*C);
T0* X485internal_c_local(T0*C);
void X485reserve(T0*C);
void X485set_anonymous_feature(T0*C,T0* a1);
T0* X485anonymous_feature(T0*C);
void X485set_effective_arguments(T0*C,T0* a1);
void X485free(T0*C);
T0* X485effective_arguments(T0*C);
void X145visit_manifest_string(T0*C,T0* a1);
T2 X1055count(T0*C);
T2 X1055upper(T0*C);
T0* X1055item(T0*C,T2 a1);
T2 X1055lower(T0*C);
void X166visit_call_infix_power(T0*C,T0* a1);
void X143visit_address_of(T0*C,T0* a1);
void X177visit_call_infix_freeop(T0*C,T0* a1);
void X446copy(T0*C,T0* a1);
T0* X446resolve_in(T0*C,T0* a1);
void X446set_target(T0*C,T0* a1);
T0* X446manifest_expression(T0*C,T0* a1);
T0* X446feature_stamp(T0*C);
T0* X446target(T0*C);
T0* X446feature_name(T0*C);
T0* X446inline_with(T0*C,T0* a1);
T0* X446twin(T0*C);
void X406copy(T0*C,T0* a1);
T0* X406resolve_in(T0*C,T0* a1);
void X406set_target(T0*C,T0* a1);
T0* X406arguments(T0*C);
T0* X406arg1(T0*C);
void X406set_arguments(T0*C,T0* a1);
T0* X406feature_stamp(T0*C);
void X406pretty(T0*C,T2 a1);
T0* X406target(T0*C);
T0* X406feature_name(T0*C);
T0* X406inline_with(T0*C,T0* a1,T0* a2);
T0* X406twin(T0*C);
T296 X406start_position(T0*C);
void X158visit_call_n(T0*C,T0* a1);
void X148visit_character_constant(T0*C,T0* a1);
void X407copy(T0*C,T0* a1);
T0* X407adapt_for(T0*C,T0* a1);
T0* X407collect(T0*C,T0* a1);
T0* X407specialize_in(T0*C,T0* a1);
T0* X407specialize_2(T0*C,T0* a1);
void X407set_target(T0*C,T0* a1);
T0* X407arguments(T0*C);
void X407safety_check(T0*C,T0* a1);
T0* X407specialize_thru(T0*C,T0* a1,T0* a2,T0* a3);
T0* X407call_support_collect(T0*C,T0* a1);
void X407set_feature_stamp(T0*C,T0* a1);
void X407set_arguments(T0*C,T0* a1);
T0* X407feature_stamp(T0*C);
void X407pretty(T0*C,T2 a1);
T0* X407target(T0*C);
T0* X407feature_name(T0*C);
T0* X407run_feature_for(T0*C,T0* a1);
T0* X407twin(T0*C);
T296 X407start_position(T0*C);
void X211visit_built_in_eq_neq(T0*C,T0* a1);
void X198visit_null_pointer(T0*C,T0* a1);
void X178visit_call_infix_implies(T0*C,T0* a1);
void X199visit_result(T0*C,T0* a1);
void X184visit_call_prefix_plus(T0*C,T0* a1);
void X200visit_writable_attribute_name(T0*C,T0* a1);
void X204visit_argument_name2(T0*C,T0* a1);
void X215visit_fake_argument(T0*C,T0* a1);
void X51disconnect(T0*C);
void X51filtered_read_character(T0*C);
T6 X51is_connected(T0*C);
void X51read_character(T0*C);
T6 X51end_of_input(T0*C);
T3 X51last_character(T0*C);
T3 X51filtered_last_character(T0*C);
void X155visit_assignment_test(T0*C,T0* a1);
T3 X335structure_mark(T0*C);
void X335c_type_for_va_arg_in(T0*C,T0* a1);
void X967next(T0*C);
T0* X967item(T0*C);
T6 X967is_off(T0*C);
T296 X316start_position(T0*C);
T2 X1022count(T0*C);
T2 X1022upper(T0*C);
T0* X1022item(T0*C,T2 a1);
T2 X1022lower(T0*C);
T6 X1022valid_index(T0*C,T2 a1);
void X190visit_old_manifest_array(T0*C,T0* a1);
T0* X350parent(T0*C);
void X193visit_written_current(T0*C,T0* a1);
void X156visit_agent_creation(T0*C,T0* a1);
void X212visit_manifest_tuple(T0*C,T0* a1);
void X333set_generic_list(T0*C,T0* a1);
T0* X333static_memory(T0*C);
void X333copy(T0*C,T0* a1);
T0* X333generic_list(T0*C);
void X333recompute_declaration_type(T0*C);
T0* X333declaration_type_memory(T0*C);
T0* X333signature_resolved_memory(T0*C);
T0* X333twin(T0*C);
void X333set_static_generic_list(T0*C,T0* a1);
void X333update_static_memory(T0*C,T0* a1);
T0* X333written_name_memory(T0*C);
T0* X367ensure_assertion(T0*C);
T0* X367arguments(T0*C);
T0* X367first_name(T0*C);
T0* X367names(T0*C);
T0* X367require_assertion(T0*C);
T0* X367result_type(T0*C);
T0* X367feature_text(T0*C);
T296 X367sedb_trace_before_exit(T0*C);
void X367hook_for(T0*C,T0* a1);
T296 X367start_position(T0*C);
int at_555__554(T0* expression);
int at_622__351(T0* expression);
int at_339__305(T0* expression);
int at_ATTRIBUTE__305(T0* expression);
int at_369__305(T0* expression);
int at_368__305(T0* expression);
int at_363__305(T0* expression);
int at_364__305(T0* expression);
int at_378__305(T0* expression);
int at_381__310(T0* expression);
int at_389__310(T0* expression);
int at_398__310(T0* expression);
int at_473__439(T0* expression);
int at_493__289(T0* expression);
int at_510__505(T0* expression);
int at_508__505(T0* expression);
int at_511__505(T0* expression);
int at_506__505(T0* expression);
int at_509__505(T0* expression);
int at_507__505(T0* expression);
int at_525__291(T0* expression);
int at_338__291(T0* expression);
int at_334__291(T0* expression);
int at_359__357(T0* expression);
int at_412__283(T0* expression);
int at_451__283(T0* expression);
int at_407__283(T0* expression);
int at_470__283(T0* expression);
int at_432__283(T0* expression);
int at_428__283(T0* expression);
int at_442__283(T0* expression);
int at_469__283(T0* expression);
int at_315__283(T0* expression);
int at_439__283(T0* expression);
int at_441__283(T0* expression);

#ifdef __cplusplus
}
#endif
