-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
deferred class PLUGIN
	--
	-- Plugin handling
	--
	-- Note that all the exported features return the same STRING object.
	--

inherit
	HASHABLE

insert
	GLOBALS
		redefine is_equal
		end

feature {SYSTEM_TOOLS}
	try_auto_init is
			-- try to write init code for this plugin, provided all dependancies are satisfied.
		require
			not auto_init_done
		deferred
		end

feature {ANY}
	auto_init_done: BOOLEAN is
			-- True when the auto_init code was written.
		deferred
		end

feature {ANY}
	is_equal (other: like Current): BOOLEAN is
		do
			Result := name.same_as(other.name) and then path.same_as(other.path)
		end

	hash_code: INTEGER

feature {PLUGIN, NATIVE}
	name: STRING

	path: STRING

feature {NATIVE_PLUG_IN}
	include (position: POSITION) is
		deferred
		end

feature {} -- directory handling
	bd: BASIC_DIRECTORY

	cwd: STRING is ""

	absolute_path (some_path: STRING): STRING is
		do
			Result := once ""
			Result.copy(cwd)
			bd.system_notation.to_absolute_path_in(Result, some_path)
		end

	tfr: TEXT_FILE_READ is
		once
			create Result.make
		end

end -- class PLUGIN
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
