-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class TEST_HASHED_SET17

insert
	EIFFELTEST_TOOLS

creation {ANY}
	make

feature {ANY}
	make is
		local
			s1, s2: HASHED_SET[INTEGER]; c: INTEGER
		do
			create s1.make
			create s2.make
			s1.add(15)
			s1.add(18)
			s2.add(10)
			s2.add(16)
			s1.intersection(s2)
			assert(not s1.has(10))
			assert(not s1.has(16))
			assert(s1.count = 0)
			s2.add(15)
			assert(s1.count = 0)
			assert(not s1.has(15))
			s1.intersection(s2)
			assert(s1.count = 0)
			assert(not s1.has(15))
			s2.add(10)
			s2.add(15)
			s2.add(-6)
			s1.add(-6)
			s1.add(18)
			s1.add(15)
			s1.intersection(s2)
			assert(s1.count = 2)
			assert(s1.has(-6))
			assert(s1.has(15))
			s1.intersection(s2)
			assert(s1.count = 2)
			s2.clear_count
			s1.intersection(s2)
			assert(s1.count = 0)
			-- New implementation of SET (25 mai 2001):
			from
				create s1.make
				c := 0
			until
				s1.count = 1000
			loop
				random.next
				c := c + 1
				s1.add(random.last_integer(100000))
			end
			assert(s1.count = 1000)
			s2 := s1.twin
			assert(s2.count = 1000)
			s1.intersection(s2)
			assert(s1.count = 1000)
			assert(s2.count = 1000)
			s1.intersection(s1)
			assert(s1.count = 1000)
			assert(s2.count = 1000)
			s2.clear_count
			assert(s2.count = 0)
			s2.add(s1.item(500))
			assert(s2.count = 1)
			s1.intersection(s2)
			assert(s1.count = 1)
			assert(s2.count = 1)
			make_aux_hashed_set17
		end

	make_aux_hashed_set17 is
		local
			s1, s2: HASHED_SET[AUX_SET17]; c: INTEGER; aux: AUX_SET17
		do
			-- New implementation of SET (25 mai 2001):
			from
				create s1.make
				c := 0
			until
				s1.count = 1000
			loop
				random.next
				c := c + 1
				create aux.make(random.last_integer(100000))
				s1.add(aux)
			end
			assert(s1.count = 1000)
			s2 := s1.twin
			assert(s2.count = 1000)
			s1.intersection(s2)
			assert(s1.count = 1000)
			assert(s2.count = 1000)
			s1.intersection(s1)
			assert(s1.count = 1000)
			assert(s2.count = 1000)
			s2.clear_count
			assert(s2.count = 0)
			s2.add(s1.item(500))
			assert(s2.count = 1)
			s1.intersection(s2)
			assert(s1.count = 1)
			assert(s2.count = 1)
		end

	random: PRESS_RANDOM_NUMBER_GENERATOR is
		once
			create Result.make
		end

end -- class TEST_HASHED_SET17
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
