-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class TEST_BIT_STRING6

creation {ANY}
	make

feature {ANY}
	make is
		local
			b1, b2, b3, b4, b5: BIT_STRING
		do
			create b1.from_string("11111111111111100000000000000001111111111111111111111111111111100000000000000000")
			create b2.make(80)
			b1.xor_mask(b2)
			b3 := b1.twin
			assert(b1.is_equal(b3))
			b2.invert
			b3.invert
			b1.xor_mask(b2)
			assert(b1.is_equal(b3))
			b1.from_string("11111111111111100000000000000001111111111111111111111111111111100000000000000000")
			b1.xor_mask(b3)
			assert(b1.all_set)
			------------------------------------------------------
			b1.from_string("111111111111000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101010101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110100000000000000000000000000000000000000000000000000000001111101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111100")
			create b4.make(765)
			b2 := b1.twin
			b3 := b1.twin
			b1.and_mask(b4)
			assert(b1.is_equal(b4))
			b4.set_all
			b2.and_mask(b4)
			assert(b2.is_equal(b3))
			b5 := b3.twin
			b4.clear_all
			b5.invert
			b5.and_mask(b3)
			assert(b5.is_equal(b4))
			---------------------------------------------------
			b1.from_string("1111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111111111111111100000000000000000111111111111111110000000000000000011111111111111111000000000000000001111110")
			b2 := b1.twin
			b2.invert
			b1.or_mask(b2)
			b2.set_all
			assert(b1.is_equal(b2))
			b1.from_string("00000000000000000000000000000000001111111111111111111111111111111101")
			create b2.make(68)
			b2.invert
			b1.or_mask(b2)
			assert(b1.is_equal(b2))
			b1.from_string("000000000000111111111111100000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111")
			b2 := b1.twin
			b3 := b1.twin
			b2.clear_all
			b1.or_mask(b2)
			assert(b1.is_equal(b3))
		end

	assert (b: BOOLEAN) is
		do
			cpt := cpt + 1
			if not b then
				std_output.put_string("TEST_BIT_STRING6: ERROR Test # ")
				std_output.put_integer(cpt)
				std_output.put_string("%N")
				crash
			else
				-- std_output.put_string("Yes%N");
			end
		end

	cpt: INTEGER

end -- class TEST_BIT_STRING6
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
