-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class TEST_IS_EXPANDED_TYPE

creation {ANY}
	make

feature {ANY}
	make is
		local
			i: INTEGER; r_32: REAL_32; r: REAL; c: CHARACTER; b: BOOLEAN; p: LIB_TEST_POINT; aexp: ARRAY[INTEGER]
			aref: ARRAY[LIB_TEST_POINT]; cp: COLORED_POINT; t_string: AUX_IS_EXPANDED_TYPE[STRING]
			t_integer: AUX_IS_EXPANDED_TYPE[INTEGER]
		do
			create p.make(1, 1)
			aexp := {ARRAY[INTEGER] 1, << 1 >> }
			create aref.make(1, 2)
			create cp.make(1, 2, "foo")
			create t_string
			create t_integer
			--
			assert('a'.is_expanded_type)
			assert(True.is_expanded_type)
			assert(False.is_expanded_type)
			assert(1.5.is_expanded_type)
			assert(1.is_expanded_type)
			assert(i.is_expanded_type)
			assert(r_32.is_expanded_type)
			assert(r.is_expanded_type)
			assert(c.is_expanded_type)
			assert(b.is_expanded_type)
			create p.make(1, 2)
			assert(not p.is_expanded_type)
			assert(not p.twin.is_expanded_type)
			create aref.make(1, 1)
			assert(aexp.item(1).is_expanded_type)
			aref.put(p, 1)
			assert(not aref.item(1).is_expanded_type)
			p := cp
			assert(not p.is_expanded_type)
			assert(not cp.is_expanded_type)
			t_string.set_item("foo")
			assert(not t_string.item.is_expanded_type)
			assert(t_integer.item.is_expanded_type)
			if t_integer.item.is_expanded_type then
			else
				assert(False)
			end
			if t_string.item.is_expanded_type then
				assert(False)
			end
		end

	assert (b: BOOLEAN) is
		do
			cpt := cpt + 1
			if not b then
				std_output.put_string("TEST_IS_EXPANDED_TYPE: ERROR Test # ")
				std_output.put_integer(cpt)
				std_output.put_string("%N")
			else
				-- std_output.put_string("Yes%N")
			end
		end

	cpt: INTEGER

end -- class TEST_IS_EXPANDED_TYPE
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
