-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class AUX_SCR1B

creation {ANY}
	make

feature {ANY}
	make is
		do
			next := 0
			create clients.make(0, max_clients - 1)
		end

feature {AUX_SCR1A}
	manage (d: AUX_SCR1A) is
		require
			not_full: next < max_clients
		do
			clients.put(d, next)
			next := next + 1
		ensure
			job_done: is_managed(d)
		end

	is_managed (d: AUX_SCR1A): BOOLEAN is
		do
			Result := True
		end

feature {ANY}
	max_clients: INTEGER is 99

	next: INTEGER

	clients: ARRAY[AUX_SCR1A]

invariant
	clients_created: clients /= Void

end -- class AUX_SCR1B
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
