-- See the Copyright notice at the end of this file.
--
deferred class XML_PARSER_TOOLS

feature {ANY}
	line: INTEGER

	column: INTEGER

	connect_to (a_stream: like stream) is
		require
			a_stream.is_connected
		do
			stream := a_stream
			line := 1
			column := 0
			next -- be sure to have a character available
		end

feature {}
	stream: INPUT_STREAM

	skip_blanks is
		do
			from
			until
				end_of_input or else not current_character.is_separator
			loop
				next
			end
		end

	end_of_input: BOOLEAN is
		do
			Result := stream.end_of_input
		end

	next is
		require
			not end_of_input
		do
			stream.read_character
			if not end_of_input then
				if current_character = '%N' then
					line := line + 1
					column := 1
				else
					column := column + 1
				end
			end
		end

	current_character: CHARACTER is
		require
			not end_of_input
		do
			Result := stream.last_character
		end

	skip (character: CHARACTER): BOOLEAN is
		do
			if not end_of_input then
				if current_character = character then
					Result := True
					next
				end
			end
		end

	skip2 (char1, char2: CHARACTER): BOOLEAN is
		do
			Result := skip(char1) and then skip(char2)
		end

	skip_word (word: STRING): BOOLEAN is
		require
			not word.is_empty
		local
			i: INTEGER
		do
			from
				i := word.lower
				Result := True
			until
				not Result or else i > word.upper
			loop
				Result := skip(word.item(i))
				i := i + 1
			end
		end

	read_identifier: STRING is
		local
			done: BOOLEAN
		do
			from
				if end_of_input then
					done := True
				else
					Result := once ""
					Result.clear_count
				end
			until
				done
			loop
				if end_of_input then
					done := True
				else
					inspect
						current_character
					when '0' .. '9', 'A' .. 'Z', 'a' .. 'z', ':', '_', '-' then
						Result.extend(current_character)
						next
					else
						done := True
					end
				end
			end
			if Result.is_empty then
				Result := Void
			end
		end

	read_string: STRING is
		local
			done: BOOLEAN; limit: CHARACTER
		do
			from
				if end_of_input then
					done := True
				else
					limit := current_character
					inspect
						limit
					when '"', '%'' then
						Result := once ""
						Result.clear_count
						next
					else
						done := True
					end
				end
			until
				done
			loop
				if end_of_input then
					done := True
				else
					if end_of_input then
						Result := Void
						done := True
					elseif current_character = limit then
						next
						done := True
					else
						Result.extend(current_character)
						next
					end
				end
			end
		end

end -- class XML_PARSER_TOOLS
--
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- This file is part of the SmartEiffel standard library.
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
