-- See the Copyright notice at the end of this file.
--
deferred class TCP_PROTOCOL
	--
	-- A protocol that handles a TCP stream.
	--

inherit
	PROTOCOL

feature {ANY}
	error: STRING

feature {URL}
	connect_to (url: URL) is
		local
			ios: SOCKET_INPUT_OUTPUT_STREAM
			a: TCP_ACCESS; h: HOST
		do
			if agent_unregister = Void then
				agent_unregister := agent unregister(Current)
			end
			create h.make(url.host)
			if url.port = 0 then
				create a.make(h, standard_port)
			else
				create a.make(h, url.port)
			end
			ios := a.sync_stream
			if a.error /= Void then
				error := h.error
			else
				ios.when_disconnect(agent_unregister)
				tcp_connect_to(ios, url)
			end
		end

	standard_port: INTEGER is
		deferred
		end

feature {}
	tcp_connect_to (ios: SOCKET_INPUT_OUTPUT_STREAM; url: URL) is
		require
			ios.is_connected
			url /= Void
			not is_connected
		deferred
		end

	agent_unregister: PROCEDURE[TUPLE]

	unregister (p: PROTOCOL) is
		require
			not p.is_connected
		local
			protocols: PROTOCOLS
		do
			protocols.unregister(p)
		end

end -- class TCP_PROTOCOL
--
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- This file is part of the SmartEiffel standard library.
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
