# Slune
# Copyright (C) 2002-2003 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import slune.globdef as globdef

if globdef.MUSIC:
  import pyopenal.openal4soya as openal4soya
  
  _MUSIC = None
  def play_music(filename):
    global _MUSIC
    _MUSIC = openal4soya.play(filename, None, None, 1, globdef.ASYNC_LOAD_MUSIC)
    
  def end_music ():
    global _MUSIC
    if _MUSIC:
      _MUSIC.stop()
      _MUSIC = None
      
  preload_sound = openal4soya.preload_sound
  
else:
  def play_music   (*args): pass
  def end_music    (): pass
  def preload_sound(*args): pass

if globdef.SOUND:
  from pyopenal.openal4soya import play
  
else:
  def play(filename, position = None, speed = None, looping = 0): pass



# import slune.globdef as globdef
# import os, os.path, popen2, signal, thread, time

# PATH = os.path.join(globdef.APPDIR, "sounds")


# _MUSIC_DURATIONS = {
#   "summum_of_the_light.ogg" : 142.0,
#   }

# _MUSIC_PROCESS = None

# CURRENT_MUSIC = ""

# def play_music(filename):
#   global CURRENT_MUSIC
#   CURRENT_MUSIC = filename
#   if globdef.MUSIC:
#     thread.start_new_thread(_play_music, (filename, ))
    
# def _play_music(filename):
#   global CURRENT_MUSIC, _MUSIC_PROCESS
#   end_music()
#   duration = _MUSIC_DURATIONS[CURRENT_MUSIC]
  
#   while CURRENT_MUSIC == filename:
#     _MUSIC_PROCESS = popen2.Popen4(globdef.PLAY_OGG_COMMAND % os.path.join(PATH, filename))
#     time.sleep(duration)
    
# def end_music():
#   global CURRENT_MUSIC, _MUSIC_PROCESS
  
#   if _MUSIC_PROCESS:
#     try:
#       os.kill(_MUSIC_PROCESS.pid, signal.SIGKILL)
#     except: pass # Terminated
#     _MUSIC_PROCESS = None
#     CURRENT_MUSIC  = ""
