%define name slib
%define version 3a2
%define release 1

Name:         %{name}
Release:      %{release}
Version:      %{version}
Packager:     Aubrey Jaffer <agj@alum.mit.edu>

Copyright:    distributable, see individual files for copyright
Vendor:       Aubrey Jaffer <agj @ alum.mit.edu>
Group:        Development/Tools
Provides:     slib
BuildArch:    noarch

Summary: platform independent library for scheme
Source:       ftp://swiss.csail.mit.edu/pub/scm/slib%{version}.zip
URL:          http://swiss.csail.mit.edu/~jaffer/SLIB.html
BuildRoot:    %{_tmppath}/%{name}%{version}
Prefix:       /usr

%description
"SLIB" is a portable library for the programming language Scheme.
It provides a platform independent framework for using "packages" of
Scheme procedures and syntax.  As distributed, SLIB contains useful
packages for all Scheme implementations.  Its catalog can be
transparently extended to accomodate packages specific to a site,
implementation, user, or directory.

%define __os_install_post /usr/lib/rpm/brp-compress

%prep
%setup -n slib -c -T
cd ..
unzip ${RPM_SOURCE_DIR}/slib%{version}.zip

%build
gzip -f slib.info

%install
mkdir -p ${RPM_BUILD_ROOT}%{prefix}/lib/slib
mkdir -p ${RPM_BUILD_ROOT}%{prefix}/bin
cp -r *.scm *.init *.xyz saturate.txt resenecolours.txt grapheps.ps Makefile ${RPM_BUILD_ROOT}%{prefix}/lib/slib
mkdir -p ${RPM_BUILD_ROOT}/usr/info
cp slib.info.gz ${RPM_BUILD_ROOT}/usr/info

echo '#! /bin/sh'			 > ${RPM_BUILD_ROOT}%{prefix}/bin/slib
echo SCHEME_LIBRARY_PATH=%{prefix}/lib/slib/ >> ${RPM_BUILD_ROOT}%{prefix}/bin/slib
echo export SCHEME_LIBRARY_PATH		>> ${RPM_BUILD_ROOT}%{prefix}/bin/slib
echo VERSION=%{version}			>> ${RPM_BUILD_ROOT}%{prefix}/bin/slib
echo "S48_VICINITY=\"%{prefix}/lib/scheme48\";export S48_VICINITY" >> ${RPM_BUILD_ROOT}%{prefix}/bin/slib
cat slib.sh				>> ${RPM_BUILD_ROOT}%{prefix}/bin/slib
chmod +x ${RPM_BUILD_ROOT}%{prefix}/bin/slib
%clean
rm -rf ${RPM_BUILD_ROOT}

%post
/sbin/install-info /usr/info/slib.info.gz /usr/info/dir

# This symlink is made as in the spec file of Robert J. Meier.
if [ -L /usr/share/guile/slib ]; then
  rm /usr/share/guile/slib
  ln -s %{prefix}/lib/slib /usr/share/guile/slib
fi

# Rebuild catalogs for as many implementations as possible.
export PATH=$PATH:/usr/local/bin
echo PATH=${PATH}
cd %{prefix}/lib/slib/
make catalogs

%preun
cd %{prefix}/lib/slib/
rm -f srcdir.mk slib.image

%files
%defattr(-, root, root)
%{prefix}/bin/slib
%dir %{prefix}/lib/slib
%{prefix}/lib/slib/*.scm
%{prefix}/lib/slib/*.init
%{prefix}/lib/slib/cie1931.xyz
%{prefix}/lib/slib/cie1964.xyz
%{prefix}/lib/slib/saturate.txt
%{prefix}/lib/slib/resenecolours.txt
%{prefix}/lib/slib/grapheps.ps
/usr/info/slib.info.gz
# The Makefile is included as it is useful for building documentation.
%{prefix}/lib/slib/Makefile
%doc ANNOUNCE README COPYING FAQ ChangeLog

%changelog
* Sat Jun 18 2004 Aubrey Jaffer <agj@alum.mit.edu>
- Fixed for RPMbuild version 4.3.1
- Make slib executable.

* Wed Mar 14 2001 Radey Shouman <shouman@ne.mediaone.net>
- Adapted from the spec file of R. J. Meier.

* Mon Jul 12 2000 Dr. Robert J. Meier <robert.meier@computer.org> 0.9.4-1suse
- Packaged for SuSE 6.3

* Sun May 30 2000 Aubrey Jaffer <agj @ alum.mit.edu>
- Updated content
