/* Public domain. */

#include "bytestr.h"
#include "fmtscan.h"
#include "stralloc.h"
#include "tai.h"
#include "djbunix.h"
#include "dns_transmit.h"

static int init (char *ip, stralloc *tmp)
{
  unsigned int tmpbase = tmp->len ;
  unsigned int iplen = 0 ;
  char const *x = env_get("DNSCACHEIP") ;
  if (x)
    while (iplen <= 60)
    {
      if (*x == '.') ++x ;
      else
      {
        unsigned int i = ip4_scan(x, ip + iplen) ;
	if (!i) break ;
	x += i ;
	iplen += 4 ;
      }
    }

  if (!iplen)
  {
    int i = openreadclose("/etc/resolv.conf", tmp, 64) ;
    if (i == -1) return 0 ;
    if (i)
    {
      unsigned int j = tmpbase ;
      if (!stralloc_catb(tmp, "\n", 1)) return 0 ;
      i = tmpbase ;
      for (; j < tmp->len ; j++)
        if (tmp->s[j] == '\n')
        {
          if (byte_equal("nameserver ", 11, tmp->s + i) || byte_equal("nameserver\t", 11, tmp->s + i))
          {
            i += 10 ;
            while ((tmp->s[i] == ' ') || (tmp->s[i] == '\t')) ++i ;
            if (iplen <= 60)
              if (ip4_scan(tmp->s + i, ip + iplen))
              {
		if (byte_equal(ip + iplen, 4, "\0\0\0"))
		  byte_copy(ip + iplen, 4, "\177\0\0\1") ;
                iplen += 4 ;
	      }
          }
          i = j + 1;
        }
    }
  }

  if (!iplen)
  {
    byte_copy(ip, 4, "\177\0\0\1") ;
    iplen = 4 ;
  }
  byte_zero(ip + iplen, 64 - iplen) ;
  tmp->len = tmpbase ;
  return 1 ;
}

int dns_resolvconfipit_tmp (struct dns_rcip_info *dr, stralloc *tmp)
{
  struct taia now ;
  taia_now(&now) ;
  if (!dr->uses-- || taia_less(&dr->deadline, &now))
  {
    if (!init(dr->ip, tmp)) return 0 ;
    taia_addsec(&dr->deadline, &now, 600) ;
    dr->uses = 10000 ;
  }
  return 1 ;
}
