# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v4/sisupod_make.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: create sisupod filetype and copy it to output directory!

=end
module SiSU_Doc
  require_relative 'shared_sisupod_source'              # shared_sisupod_source.rb
    include SiSU_Source
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  class Source < SiSU_Source::SiSUpodSource
    require_relative 'response'                         # response.rb
    def initialize(opt,build=nil,place=nil)
      super(opt,build,place)
      @zipfile=@opt.fno.gsub(/(?:\~\S{2,3})?(\.ss[tm])$/,'\1')
      unless @opt.cmd =~/q/
        pthinfo="#{@file.output_path.sisupod.dir}/#{@zipfile}.txz"
        @opt.cmd=~/[MVv]/ \
        ? SiSU_Screen::Ansi.new(@opt.cmd,'Assemble source for sisu document',"#{@opt.fns} -> file://#{pthinfo}").cyan_hi_blue
        : SiSU_Screen::Ansi.new(@opt.cmd,'Assemble source for sisu document',pthinfo).cyan_title_hi
      end
    end
    def sisupod_tar_xz
      begin
        FileUtils::mkdir_p(@file.output_path.sisupod.dir) unless FileTest.directory?(@file.output_path.sisupod.dir)
        tree=(@opt.cmd =~/[vVM]/ \
        && SiSU_Env::SystemCall.new.program_found?('tree')) \
        ? 'tree sisupod'
        : ''
        if FileTest.directory?(@path_pod[:fnb])
          Dir.chdir(@path_pod[:fnb])
          system(%{
            #{tree}
            tar -cJf #{@zipfile}.txz sisupod
            #echo "#{@file.place_file.sisupod.dir}"
          })
          FileUtils::mv("#{@zipfile}.txz",@file.place_file.sisupod.dir)
          Dir.chdir(@env.path.pwd)
          SiSU_Screen::Ansi.new('',"#{@opt.fns}.txz").blue_tab if @opt.cmd=~/[MVv]/
        else
          SiSU_Screen::Ansi.new('',"#{@opt.fns}.txz not built").blue_tab if @opt.cmd=~/[MVv]/
        end
      rescue
      ensure
      end
    end
  end
end
__END__
question?:                   should you permit the packing of multiple documents in single .xz ?

  open @opt.fns, parse file
    extract from file content:
      images and copy each image from whatever image source to _sisu/sisupod/sisu/_sisu/image

   remove previously existing contents of _/sisu/sisupod &
   make directory structure:

v3 -->
   _sisu
     sisupod
       doc
         manifest.txt
         en/content.sst                [file content]
         fr/content.sst
         _sisu
           conf
           image (ln -s ../../image)
           audio (ln -s ../../audio)
           video (ln -s ../../video)
       image                           [all images for specific document gathered here]
       audio
       video

v2 -->
   _sisu
     sisupod
       content.sst                     [file content]
       filename.sst                    [link to content.sst]
       _sisu/
         image/                        [all images for specific document gathered here]

sisu
  _sisu
    sisurc.yml
    convert/
    standard_terms/
    image
    processing
      dal/
      tex/
      texinfo/
      tune/
    sisupod

special case

composite file (master), e.g.
SiSU.ssm
