# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: urls for output files

=end
module SiSU_urls
  require "#{SiSU_lib}/particulars"                        # particulars.rb
    include SiSU_Particulars
  require "#{SiSU_lib}/sysenv"                             # sysenv.rb
    include SiSU_Env; include SiSU_Screen
  class Source
    attr_reader :opt
    def initialize(opt)
      @opt=opt
    end
    def read
      begin
        SiSU_urls::Output_urls.new(@opt).songsheet if @opt.fnb #fnb[/.+?\.(?:[_-]?sst|ssm)$/]
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd).error
      ensure
      end
    end
  end
  class Output_urls
    attr_reader :fns,:fnb,:cmd,:dir,:m_regular,:u
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::Combined_singleton.instance.get_env_md(opt)
      fn_set_lang=SiSU_Env::Standardise_language.new.file_to_language(@opt.fns)
      @cmd=@opt.cmd
      @md=@particulars.md
      @env=@particulars.env
      @fnb=@env.fnb
      fn_set_lang=SiSU_Env::Standardise_language.new.file_to_language(@opt.fns)
      @fnl=@env.i18n.lang_filename(fn_set_lang[:c])
      @fn=SiSU_Env::Env_call.new(@opt.fns).lang(fn_set_lang[:c])
      @m_regular=/(.+?)\.(?:(?:-|ssm\.)?sst|ssm)$/
      @prog=@env.program
      source=if @opt.fns =~/\.sst$/; @opt.fns
      elsif @opt.fns =~/\.ssm\.sst/; "#{@fnb}.ssm.sst"
      else 'not recognised file'
      end
      @u ||= {
        'a (Plain-text (footnotes))'=>@fn[:plain],
        'A (Plain-text (footnotes) dos)'=>@fn[:plain],
        'b (XHTML)'=>@fn[:xhtml],
        'D[iu] (DBI import/update postgresql)'=>'dbi psql',
        'd[iu] (DBI import/update sqlite)'=>'dbi sqlite3',
        'e (EPUB)'=>@fn[:epub],
        'h (HTML segmented)'=>@fn[:toc],
        'H (HTML segmented)'=>@fn[:toc],
        'h (HTML scroll)'=>@fn[:doc],
        'H (HTML scroll)'=>@fn[:doc],
        'I (Info file)'=>'info',
        'i (manpage)'=>'manpage',
        'm (Document Abstraction)'=>'dal',
        'N (Digests md5/sha256)'=>@fn[:digest],
        'o (ODF:ODT - Open Document)'=>@fn[:odf],
        'p (PDF landscape)'=>@fn[:pdf_l],
        'p (PDF portrait)'=>@fn[:pdf_p],
        'P (Ruby profiler)'=>'profile',
        's (sisu markup)'=>source,
        'S (sisupod)'=>@fn[:sisupod],
        'x (XML sax type)'=>@fn[:sax],
        'X (XML dom type)'=>@fn[:dom],
        'y (Manifest, html)'=>@fn[:manifest],
        'Y (Sitemap, xml)'=>@fn[:sitemap],
        'w (Concordance, html)'=>@fn[:concordance],
      }.sort {|a,b| a[0].downcase<=>b[0].downcase}
    end
    def songsheet
      begin
       @opt.cmd=~/U/ ? urls_all : (urls_select unless @opt.cmd=~/q/)
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    def urls_maintenance(opt,x,y)
      if x=~/^([abcehHmNopwxXy])/ \
      and opt.cmd =~/[abcehHmNopwxXy]/ \
      and x=~/^[#{opt.cmd}]/ \
      and opt.cmd =~/M/
        m=$1
        f=y
        tool=@prog.text_editor
        if x =~/^m/ \
        and @opt.cmd=~/m/ \
        and x=~/^[#{opt.cmd}]/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.text_editor} #{@env.path.dal}/#{@opt.fns}.meta").maintenance if @opt.cmd =~/[MVv]/
        end
        if x=~/^([hHw])/ \
        and @opt.cmd=~/[hHw]/ \
        and x=~/^[#{@opt.cmd}]/
          f=if x !~/segmented/; "#{y}.html"
          else                  "#{y}.index.html"
          end
        end
        if x=~/^p/ \
        and @opt.cmd=~/p/ \
        and x=~/^[#{@opt.cmd}]/
          tool=@prog.pdf_viewer
          fns=@opt.fns.gsub(/~/,'-')
          unless @opt.cmd =~/q/
            tell=if y =~/landscape/
              SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.text_editor} #{@env.path.tex}/#{fns}.landscape.tex")
            else SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.text_editor} #{@env.path.tex}/#{fns}.tex")
            end
            tell.maintenance if @opt.cmd =~/[MVv]/
          end
        end
        if x=~/^o/ \
        and @opt.cmd=~/o/ \
        and x=~/^[#{@opt.cmd}]/
          tool=@prog.odf_viewer
        end
        if x=~/^e/ \
        and @opt.cmd=~/e/ \
        and x=~/^[#{@opt.cmd}]/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.text_editor} #{@env.path.epub}/OPS/toc.xhtml").maintenance if @opt.cmd =~/[MVv]/
        end
        if x !~/^[me]/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{tool} #{@env.path.output}/#{@fnb}/#{y}").maintenance if @opt.cmd =~/[MVv]/
        end
        @opt.cmd.gsub!(/#{m}/,'')
      end
    end
    def urls_select
      unless @opt.cmd =~/q/
        i="(output manifest) #{@env.url.output_tell}/#{@fnb}/sisu_manifest.html"
        @opt.cmd=~/[MVvz]/ \
        ? SiSU_Screen::Ansi.new(@opt.cmd,'URLs').grey_title_hi \
        : SiSU_Screen::Ansi.new(@opt.cmd,'URL',i).green_hi_blue
        SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.path.output}/#{@fnb}").flow if @opt.cmd =~/[MVv]/
      end
      m=/.+\/(?:src\/)?(\S+)/im # m=/.+?\/(?:src\/)?([^\/]+)$/im # m=/.+\/(\S+)/m
      @pwd_stub="#{@env.url.output_tell}"[m,1]
      unless @opt.cmd =~/q/
        @u.each do |x,y|
          if @opt.fns =~ @m_regular
            if @opt.cmd =~/[MVv]/
              if x=~/^([abchHNopwxXyY])/ \
              and @opt.cmd=~/[abchHNopwxXyY]/ \
              and x=~/^[#{@opt.cmd}]/
                m=$1
                SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.web_browser} #{@env.url.output_tell}/#{@fnb}/#{y}").result
                @opt.cmd.gsub!(/#{m}/,'')
              end
              if x=~/^I/ \
              and @opt.cmd =~/I/
                SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","cd #{@env.path.texinfo}; pinfo ./#{@fnb}.#{y}; cd -").result
                @opt.cmd.gsub!(/I/,'')
              end
              if x=~/^D/ \
              and @opt.cmd =~/D/
                SiSU_Screen::Ansi.new(@opt.cmd,"-#{x} DBI psql","#{@pwd_stub}::#{@opt.fns}",y).result
                @opt.cmd.gsub!(/D[iu]/,'')
              end
              if x=~/^d/ \
              and @opt.cmd =~/d/
                SiSU_Screen::Ansi.new(@opt.cmd,"-#{x} DBI sqlite","sqlite3 #{@env.path.output}/sisu_sqlite.db", "#{y}").result
                @opt.cmd.gsub!(/d[iu]/,'')
              end
              if x=~/^e/ \
              and @opt.cmd =~/e/
                SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.epub_viewer} #{@env.path.output}/epub/#{y}").result
              end
              if x=~/^i/ \
              and @opt.cmd =~/i/
                SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.manpage_generator} #{@env.path.manpage}/#{@fnb}.1 |most").result
                @opt.cmd.gsub!(/I/,'')
              end
              if x=~/^P/ \
              and @opt.cmd =~/P/
                SiSU_Screen::Ansi.new(@opt.cmd,"-#{x} Profile","#{@pwd_stub}::#{@opt.fns}",y).result
                @opt.cmd.gsub!(/P/,'')
              end
              if x=~/^s/ \
              and @opt.cmd =~/s/
                SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.web_browser} #{@env.url.output_tell}/src/#{y}").result
                @opt.cmd.gsub!(/I/,'')
              end
              if x=~/^S/ \
              and @opt.cmd =~/[sS]/
                zipfile=if @opt.fns =~/\.ssm\.sst$/; y.gsub(/(?:\~\S{2,3})?(\.ssm\.sst\.zip)$/,'.ssm.zip')
                else y.gsub(/(?:\~\S{2,3})?(\.sst\.zip)$/,'\1')
                end
                SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.web_browser} #{@env.url.output_tell}/pod/#{y}").result
                @opt.cmd.gsub!(/I/,'')
              end
            end
            urls_maintenance(@opt,x,y) if @opt.cmd =~/[MV]/
          end
        end
      end
    end
    def urls_all
      i="(output manifest) #{@env.url.output_tell}/#{@fnb}/sisu_manifest.html"
      SiSU_Screen::Ansi.new(@opt.cmd,'URLs',i).grey_title_hi
      @u.each do |x,y|
        tell=case x
        when /^m/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.text_editor} ~#{y}/#{@fnb}.#{y}")
        when /^[abBcdhNopswxXy]/
          tellx=SiSU_Screen::Ansi.new(@opt.cmd,"-p (LaTeX)","#{@prog.text_editor} ~work/tex_rz/#{@fnb}.tex") if y=~/landscape/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.web_browser} #{@env.url.output_tell}/#{@fnb}/#{y}")
        when /^e/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.epub_viewer} #{@env.path.output}/epub/#{y}")
        when /^Y/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.web_browser} #{@env.url.output_tell}/sitemap/#{y}")
        when /^I/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","cd #{@env.path.texinfo}; pinfo ./#{@fnb}.#{y}; cd -")
        when /^i/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.manpage_generator} #{@env.path.manpage}/#{@fnb}.1 |most")
        end
        unless @opt.cmd =~/q/
          tellx.result if tellx
          tell.result if tell
        end
        tellx=nil
      end
    end
  end
end
__END__
