# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_Git
  require "#{SiSU_lib}/param"                              # param.rb
  require "#{SiSU_lib}/sysenv"                             # sysenv.rb
  require "#{SiSU_lib}/dal"                                # dal.rb
  class Source
    include FileUtils #::Verbose
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::Info_env.new
      @git_path={}
      @git_path[:fnb]=@env.path.processing_path_git + '/' + @opt.fnb
      @git_path[:src]=@git_path[:fnb] + '/' + Gt[:txt]
      @git_path[:image]=@git_path[:fnb] + '/' + Gt[:image]
      @git_path[:conf]=@git_path[:fnb] + '/' + Gt[:conf]
      @md=SiSU_Param::Parameters.new(@opt).get
      SiSU_DAL::Source.new(@opt).read                                         # -m
    end
    def read
      make_dir_fnb
      if program_found?
        git_init
      end
      populate.sisusrc_files
      if program_found?
        git_commit
      end
    end
    def program_found?
      found=`whereis git`
      (found =~/bin\/git\b/) ? true : false
    end
    def make_dir_fnb
      mkdir_p(@git_path[:fnb]) unless FileTest.directory?(@git_path[:fnb])
      mkdir_p(@git_path[:src]) unless FileTest.directory?(@git_path[:src])
      mkdir_p(@git_path[:conf]) unless FileTest.directory?(@git_path[:conf])
      mkdir_p("#{@git_path[:conf]}/skin") unless FileTest.directory?("#{@git_path[:conf]}/skin")
      mkdir_p(@git_path[:image]) unless FileTest.directory?(@git_path[:image])
    end
    def git_init
      unless FileTest.directory?("#{@git_path[:fnb]}/.git")
        system("cd #{@git_path[:fnb]}\
          && git init
        ")
      end
    end
    def git_commit
      system("cd #{@git_path[:fnb]} \
        && git add . \
        && git commit -a
      ")
    end
    def populate
      def identify_language_versions
        print __FILE__ + ':'
        p __LINE__
      end
      def copy_src_head
        if @opt.fns =~/\.ssm\.sst/
          ssm=@opt.fns.gsub(/\.ssm\.sst/,'.ssm')
          cp_r("#{@env.path.pwd}/#{ssm}",@git_path[:src])
        else
          cp_r("#{@env.path.pwd}/#{@opt.fns}",@git_path[:src])
        end
      end
      def copy_related_sst_ssi
        doc_import=[]
        @rgx_doc_import=/^<<\s(\S+?\.ss[ti])/
        file_array=IO.readlines(@opt.fns,'')
        file_array.each do |f|
          if f =~@rgx_doc_import
            doc_import = doc_import + f.scan(@rgx_doc_import).uniq.flatten
          end
        end
        doc_import.each do |f|
          cp_r("#{@env.path.pwd}/#{f}",@git_path[:src])
        end
      end
      def locate_parse_file
        composite_src=@opt.fns=~/\.ssm$/ ? true : false
        parse_file=if composite_src \
        and @opt.cmd.inspect !~/m/
          ##SiSU_Assemble::Composite.new(@opt).read
          #SiSU_DAL::Source.new(@opt).read                                         # -m
          "#{@env.path.composite_file}/#{@opt.fnb}.ssm.sst"
        elsif composite_src
          "#{@env.path.composite_file}/#{@opt.fnb}.ssm.sst"
        else "#{@env.path.pwd}/#{@opt.fns}"
        end
      end
      def locate_skin
        SiSU_Env::Info_skin.new(@md).select
      end
      def read_composite
        #print __FILE__ + ':'
        #p __LINE__
      end
      def extract_skin
        #print __FILE__ + ':'
        #p __LINE__
      end
      def extract_skin_and_images #(parse_file)
        parse_file_name=locate_parse_file
        parse_file=IO.readlines(parse_file_name,'')
        rgx_image=/(?:^|[^_\\])\{\s*(\S+?\.(?:png|jpg|gif))/
        #rgx_rb_image=/["'](\S+?\.(?:png|jpg|gif))["']/
        #rgx_rb_image=/[^\/]?([a-z]\S+?\.(?:png|jpg|gif))/
        rgx_rb_image=/([a-z][^ \/]+?\.(?:png|jpg|gif))/
        rgx_skin=/^\s+:skin:\s+(\S+)/
        skin_get=nil
        images=[]
        skin_get
        parse_file.each do |f|                                                  #% work area
          if f !~/^%+\s/
            skin_get ||= f.scan(rgx_skin).uniq.flatten if f =~rgx_skin
            if f =~rgx_image
              images << f.scan(rgx_image).uniq
            end
          end
        end
        skin=skin_get[0] if skin_get
        skin=locate_skin
        parse_skin=IO.readlines(skin,"\n")
        parse_skin.each do |f|                                                  #% work area
          if f !~/^#/ \
          and f =~rgx_rb_image
            images << f.scan(rgx_rb_image).uniq
          end
        end
        image_path="#{@env.path.pwd}/_sisu/image"
        images.flatten.each do |i|
          if FileTest.file?("#{image_path}/#{i}")
            cp_r("#{image_path}/#{i}",@git_path[:image])
          end
        end
        if FileTest.file?(skin)
          cp_r(skin,"#{@git_path[:conf]}/skin")
        end
        {:skin =>skin, :images =>images}
      end
      def read_src
        print __FILE__ + ':'
        p __LINE__
      end
      def composite_src?
        @opt.fns=~/\.ssm$/ ? true : false
      end
      def sisusrc_files
        populate.copy_src_head
        if composite_src?
          populate.copy_related_sst_ssi
        end
        populate.extract_skin
        #parse_file_name=locate_parse_file
        #parse_file=IO.readlines(parse_file_name,'')
        populate.extract_skin_and_images #(parse_file)
        #populate.extract_composite_source
        #populate.read_composite # or read_each_composite
        populate.identify_language_versions
      end
      self
    end
  end
end
__END__
