# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: html scroll generation, processing

=end
module SiSU_HTML_scroll
  require "#{SiSU_lib}/shared_html"
  require "#{SiSU_lib}/html"
  require "#{SiSU_lib}/html_promo"
  class Scroll
    @@dp=nil
    def initialize(data='',md='')
      @data,@md=data,md
      @vz=SiSU_Env::Get_init.instance.skin
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
    end
    def songsheet
      begin
        scr=Scroll.new(@data,@md).markup
        scr[:tails]=Scroll.new('',@md).tails
        scr
      rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
      ensure
      end
    end
  protected
    def markup
      data=@data
      @rcdc=false
      @scr={ :body=>[],:metadata=>[],:owner_details=>[] }
      data.each do |para|
        #if para =~/^#{Mx[:lv_o]}\d:endnotes#{Mx[:lv_c]}\s*Endnotes/
        ##  para.gsub!(/Endnotes.+/,'')
        #end
        para='' if para =~/#{Mx[:lv_o]}\d+:.*?#{Mx[:lv_c]}.+?#{Mx[:pa_non_object_dummy_heading]}/
        if para =~/^#{Mx[:lv_o]}\d:meta#{Mx[:lv_c]}\s*Document Information/
          para.gsub!(/(Document Information(?: \(metadata\))?)/,'\1<a name="docinfo"></a>')
        end
        if para =~/^#{Mx[:lv_o]}\d:metadata#{Mx[:lv_c]}\s*Metadata/
          para.gsub!(/(Metadata)/,'\1<a name="metadata"></a>')
        end
        if @rcdc==false \
        and (para =~/^#{Mx[:lv_o]}:metadata#{Mx[:lv_c]}/ or para =~/^#{Mx[:lv_o]}1:meta#{Mx[:lv_c]}\s*Document Information/)
          @rcdc=true
        end
        para.gsub!(/(?:\s*#{Mx[:br_page]}\s*|\s*#{Mx[:br_page_new]}\s*)+/m,'<p><hr width=90% /></p>')
        if para !~/(^#{Rx[:meta]}|#{Mx[:br_endnotes]}|#{Mx[:br_eof]})/
          unless para =~/^#{Mx[:gr_o]}code#{Mx[:gr_c]}/; para.gsub!(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]}).+?(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})\s*/m,' ')
          end
          if para =~/.+?#{Mx[:id_o]}~\d+;(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
            ocn=para[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/,1]
            @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
          end
          @sto=SiSU_HTML::Source::Split_text_object.new(@md,para).html_scroll
          m=/#{Mx[:id_o]}~\d+;(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          if para =~m
            if @sto.format =~/i[1-9]|ordinary/ #watch
              txt_obj={:txt =>@sto.text}
              format_txt_obj=SiSU_HTML_Format::Format_text_object.new(@md,txt_obj)
            end
            para=case @sto.format
            when /^1:\S*?/; @sto.scroll_lev_para_ocn.heading_body1
            when /^2:\S*?/; @sto.scroll_lev_para_ocn.heading_body2
            when /^3:\S*?/; @sto.scroll_lev_para_ocn.heading_body3
            when /^4:\S+?/; @sto.scroll_lev_para_ocn.heading_body4 # work on see Split_text_object4
            when /^5:\S*?/; @sto.scroll_lev_para_ocn.heading_body5
            when /^6:\S*?/; @sto.scroll_lev_para_ocn.heading_body6
            when /^#{Mx[:gl_bullet]}/; @sto.scroll_lev_para_ocn.bullet
            when /^#{Mx[:pa_o]}:i([1-9])#{Mx[:pa_c]}#{Mx[:gl_bullet]}/ #indent with bullet
              format_txt_obj.gsub_body
              @sto.scroll_lev_para_ocn.format('li',"i#{$1}")
            when /^i([1-9])$/ #indent
              format_txt_obj.gsub_body
              @sto.scroll_lev_para_ocn.format('p',"i#{$1}")
            when /^center$/;               @sto.scroll_lev_para_ocn.center
            when /^(?:b|bold)$/;           @sto.scroll_lev_para_ocn.bold
            when /^(?:verse|group|alt)$/;  @sto.scroll_lev_para_ocn.para
            when /^code$/;                 @sto.scroll_lev_para_ocn.code
            when /ordinary/ # see whether u can improve
              para=if para !~/#{@vz.margin_txt_0}|#{@vz.margin_txt_1}|#{@vz.margin_txt_2}/
                format_txt_obj.gsub_body
                para=if para =~/#{Mx[:gr_o]}Th?.+/ # tables come as single block
                  #@sto=nil
                  table=SiSU_HTML_shared::Table.new(para)
                  table.table_split
                else @sto.scroll_lev_para_ocn.para
                end
              else para
              end
            else para
            end
          elsif para =~/^#{Mx[:lv_o]}[1-9]:/ \
          and para !~/#{Mx[:id_o]}~\d+;(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_c]}#@dp:#@dp#{Mx[:id_c]}$/
            txt_obj={:txt =>para}
            format_txt_obj=SiSU_HTML_Format::Format_text_object.new(@md,txt_obj)
            para=format_txt_obj.bold_header
          elsif para =~/Endnotes?/ \
          and para !~/#{Mx[:id_o]}~\d+;(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
            txt_obj={:txt =>'<br /><a name="notes">Note</a>'}
            format_txt_obj=SiSU_HTML_Format::Format_text_object.new(@md,txt_obj)
            para=format_txt_obj.bold_para
          elsif para =~/Owner Details/ \
          and para !~/#{Mx[:id_o]}~\d+;(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
            txt_obj={:txt =>'<br /><a name="owner.details">Owner Details</a>'}
            format_txt_obj=SiSU_HTML_Format::Format_text_object.new(@md,txt_obj)
            @scr[:owner_details]=format_txt_obj.bold_para
            para=''
          elsif para =~/(.*)#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}(.*)/ #watch
            cont=if $2.empty?
              $1
            else "#{$1} #{$2}" #watch, check desired where $2 is other than space
            end
            txt_obj={:txt =>cont}
            format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
            para=format_seg.no_paranum
          end
          if para =~/<a name="n\d+">/ \
          and para =~/^(?:\^~\d+\s|<!e[:_]\d+!>)/ # hmmm re-adjusted 200507, for alt endnote which should again be matched ^~ ... not in response to problem though
            para=''
          end
          para.gsub!(/^#{Rx[:mx_fa_clean]}/,' '); para.gsub!(/^<:\S?>/,'')
          para.gsub!(/#{Rx[:mx_fa_clean]}/,' '); para.gsub!(/<:\S?>/,' '); para.gsub!(/<!.+!>/,' ')
          para.strip!
          unless @rcdc; @scr[:body] << para unless para =~/\A\s*\Z/
          else          @scr[:metadata] << para
          end
        end
      end
      @scr
    end
    def tails
      scr_tail=[]
      format_head_scroll=SiSU_HTML_Format::Head_toc.new(@md)
      ads=SiSU_HTML_promo::Ad.new(@md)
      scr_tail << format_head_scroll.scroll_tail << ads.div.close << ads.display << format_head_scroll.html_close
      scr_tail
    end
  end
end
__END__
